/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class CvsFileSet
extends FileSet {
    private String mode = "controlled";
    private static final Set[] NO_ENTRIES = new Set[]{Collections.EMPTY_SET, Collections.EMPTY_SET};

    public void setMode(Mode mode) {
        this.mode = mode.getValue();
    }

    public DirectoryScanner getDirectoryScanner(Project project) throws BuildException {
        CvsDirectoryScanner cvsDirectoryScanner = new CvsDirectoryScanner();
        this.setupDirectoryScanner((FileScanner)cvsDirectoryScanner, project);
        cvsDirectoryScanner.scan();
        return cvsDirectoryScanner;
    }

    private class CvsDirectoryScanner
    extends DirectoryScanner {
        private final Map entries = new HashMap(100);

        private CvsDirectoryScanner() {
        }

        protected boolean isIncluded(String string) throws BuildException {
            if (!super.isIncluded(string)) {
                return false;
            }
            File file = new File(this.getBasedir(), string);
            if (!file.exists()) {
                throw new IllegalStateException();
            }
            if (!file.isFile()) {
                return false;
            }
            Set[] setArray = this.loadEntries(file.getParentFile());
            Set set = setArray[0];
            Set set2 = setArray[1];
            String string2 = file.getName();
            if (CvsFileSet.this.mode.equals("controlled")) {
                return set.contains(string2) || set2.contains(string2);
            }
            if (CvsFileSet.this.mode.equals("uncontrolled")) {
                return !set.contains(string2) && !set2.contains(string2);
            }
            if (CvsFileSet.this.mode.equals("text")) {
                return set.contains(string2);
            }
            if (CvsFileSet.this.mode.equals("binary")) {
                return set2.contains(string2);
            }
            throw new IllegalStateException(CvsFileSet.this.mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set[] loadEntries(File file) throws BuildException {
            Set[] setArray = (Set[])this.entries.get(file);
            if (setArray == null) {
                block9: {
                    File file2 = new File(new File(file, "CVS"), "Entries");
                    if (file2.exists()) {
                        setArray = new Set[]{new HashSet(10), new HashSet(10)};
                        try {
                            FileReader fileReader = new FileReader(file2);
                            try {
                                String string;
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                while ((string = bufferedReader.readLine()) != null) {
                                    if (!string.startsWith("/")) continue;
                                    string = string.substring(1);
                                    int n = string.indexOf(47);
                                    String string2 = string.substring(0, n);
                                    n = string.lastIndexOf(47);
                                    String string3 = (string = string.substring(0, n)).substring((n = string.lastIndexOf(47)) + 1);
                                    if (string3.equals("")) {
                                        setArray[0].add(string2);
                                        continue;
                                    }
                                    if (string3.equals("-kb")) {
                                        setArray[1].add(string2);
                                        continue;
                                    }
                                    throw new BuildException("Strange key subst mode in " + file2 + ": " + string3);
                                }
                                Object var11_11 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                ((Reader)fileReader).close();
                                throw throwable;
                            }
                            ((Reader)fileReader).close();
                            {
                                break block9;
                            }
                        }
                        catch (IOException iOException) {
                            throw new BuildException("While reading " + file2, (Throwable)iOException);
                        }
                    }
                    setArray = NO_ENTRIES;
                }
                this.entries.put(file, setArray);
            }
            return setArray;
        }

        protected boolean couldHoldIncluded(String string) {
            if (!super.couldHoldIncluded(string)) {
                return false;
            }
            return !string.endsWith(File.separatorChar + "CVS");
        }
    }

    public static final class Mode
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"controlled", "uncontrolled", "text", "binary"};
        }
    }
}

