/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.util.WeakListener;

public class DefaultPropertyModel
implements ExPropertyModel,
PropertyChangeListener {
    private Object bean;
    private String propertyName;
    private PropertyChangeSupport support;
    private BeanInfo beanInfo;
    private PropertyDescriptor prop;
    private Method readMethod;
    private Method writeMethod;
    private Class propertyTypeClass;
    private boolean donotfire = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public DefaultPropertyModel(Object object, String string) throws IllegalArgumentException {
        this(object, DefaultPropertyModel.findInfo(object, string));
    }

    public DefaultPropertyModel(Object object, PropertyDescriptor propertyDescriptor) {
        this.bean = object;
        this.propertyName = propertyDescriptor.getName();
        this.support = new PropertyChangeSupport(this);
        this.prop = propertyDescriptor;
        this.propertyTypeClass = propertyDescriptor.getPropertyType();
        this.readMethod = propertyDescriptor.getReadMethod();
        this.writeMethod = propertyDescriptor.getWriteMethod();
        try {
            try {
                Method method = object.getClass().getMethod("addPropertyChangeListener", class$java$lang$String == null ? (class$java$lang$String = DefaultPropertyModel.class$("java.lang.String")) : class$java$lang$String, class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DefaultPropertyModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                method.invoke(object, this.propertyName, WeakListener.propertyChange(this, object));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method method = object.getClass().getMethod("addPropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = DefaultPropertyModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                    method.invoke(object, WeakListener.propertyChange(this, object));
                }
                catch (NoSuchMethodException noSuchMethodException2) {}
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, exception);
        }
    }

    private static PropertyDescriptor findInfo(Object object, String string) throws IllegalArgumentException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getName().equals(string)) {
                    return propertyDescriptorArray[n];
                }
                ++n;
            }
            throw new IllegalArgumentException("No property named " + string + " in class " + object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, introspectionException);
            throw illegalArgumentException;
        }
    }

    public Class getPropertyType() {
        return this.propertyTypeClass;
    }

    public Object getValue() throws InvocationTargetException {
        try {
            return this.readMethod == null ? null : this.readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, illegalAccessException);
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public void setValue(Object object) throws InvocationTargetException {
        try {
            if (this.writeMethod != null) {
                this.donotfire = true;
                this.writeMethod.invoke(this.bean, object);
                this.donotfire = false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, illegalAccessException);
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyName.equals(propertyChangeEvent.getPropertyName()) && !this.donotfire) {
            this.support.firePropertyChange("value", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public Class getPropertyEditorClass() {
        return this.prop.getPropertyEditorClass();
    }

    public Object[] getBeans() {
        return new Object[]{this.bean};
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.prop;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

