      SUBROUTINE TEST_PUTR(STATUS)
*+
*  Name:
*     TEST_PUTR

*  Purpose:
*     Test CHR_PUTR.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL TEST_PUTR(STATUS)

*  Description:
*     Test CHR_PUTR.
*     If any failure occurs, return STATUS = SAI__ERROR.
*     Otherwise, STATUS is unchanged.

*  Arguments:
*     STATUS = INTEGER (Returned)
*        The status of the tests. 

*  Authors:
*     RLVAD::AJC: A J Chipperfield (STARLINK)
*     RLVAD::ACC: A C Charles (STARLINK)
*     {enter_new_authors_here}

*  History:
*     17-AUG-1989 (RLVAD::AJC):
*        Original version.
*     14-SEP-1993 (ACC)
*        Modularised version: broken into one routine for each of 5 main 
*        categories of tests.
*     01-MAR-1994 (ACC)
*        Second modularised version: broken further into one routine for 
*        each of subroutine tested.  This subroutine created.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*  Subprograms called:   
*     CHR_PUTR

*-

*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Arguments Given:
*     None

*  Arguments Returned:
      INTEGER STATUS

*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
      INCLUDE 'CHR_ERR'

*  Local Variables:
      INTEGER PTR1               ! String indexes
      CHARACTER*120 STRING

*.

*    Test CHR_PUTR -- Real to character at given position

      STRING = ' '
      PTR1 = 0
      CALL CHR_PUTR (33.3, STRING, PTR1)
      CALL CHR_PUTC (' ', STRING, PTR1)
      CALL CHR_PUTR (-3.0, STRING, PTR1)      
      IF (STRING(1:PTR1) .EQ. '33.3 -3') THEN
         PRINT *, 'CHR_PUTR OK'
      ELSE
         PRINT *, 'CHR_PUTR FAILS- STRING is:',STRING
         STATUS = SAI__ERROR
      ENDIF

      END
