# coding=utf-8
#####################################################
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT #
#####################################################
# noqa: E128,E201
from .client import BaseClient
from .client import createApiClient
from .client import config
from .client import createTemporaryCredentials
from .client import createSession
_defaultConfig = config


class Pulse(BaseClient):
    """
    The taskcluster-pulse service, typically available at `pulse.taskcluster.net`
    manages pulse credentials for taskcluster users.

    A service to manage Pulse credentials for anything using
    Taskcluster credentials. This allows for self-service pulse
    access and greater control within the Taskcluster project.
    """

    classOptions = {
        "baseUrl": "https://pulse.taskcluster.net/v1"
    }

    def overview(self, *args, **kwargs):
        """
        Rabbit Overview

        Get an overview of the Rabbit cluster.

        This method gives output: ``http://schemas.taskcluster.net/pulse/v1/rabbit-overview.json``

        This method is ``experimental``
        """

        return self._makeApiCall(self.funcinfo["overview"], *args, **kwargs)

    def listNamespaces(self, *args, **kwargs):
        """
        List Namespaces

        List the namespaces managed by this service.

        This will list up to 1000 namespaces. If more namespaces are present a
        `continuationToken` will be returned, which can be given in the next
        request. For the initial request, do not provide continuation.

        This method gives output: ``http://schemas.taskcluster.net/pulse/v1/list-namespaces-response.json``

        This method is ``experimental``
        """

        return self._makeApiCall(self.funcinfo["listNamespaces"], *args, **kwargs)

    def namespace(self, *args, **kwargs):
        """
        Get a namespace

        Get public information about a single namespace. This is the same information
        as returned by `listNamespaces`.

        This method gives output: ``http://schemas.taskcluster.net/pulse/v1/namespace.json``

        This method is ``experimental``
        """

        return self._makeApiCall(self.funcinfo["namespace"], *args, **kwargs)

    def claimNamespace(self, *args, **kwargs):
        """
        Claim a namespace

        Claim a namespace, returning a username and password with access to that
        namespace good for a short time.  Clients should call this endpoint again
        at the re-claim time given in the response, as the password will be rotated
        soon after that time.  The namespace will expire, and any associated queues
        and exchanges will be deleted, at the given expiration time.

        The `expires` and `contact` properties can be updated at any time in a reclaim
        operation.

        This method takes input: ``http://schemas.taskcluster.net/pulse/v1/namespace-request.json``

        This method gives output: ``http://schemas.taskcluster.net/pulse/v1/namespace-response.json``

        This method is ``experimental``
        """

        return self._makeApiCall(self.funcinfo["claimNamespace"], *args, **kwargs)

    def ping(self, *args, **kwargs):
        """
        Ping Server

        Respond without doing anything.
        This endpoint is used to check that the service is up.

        This method is ``stable``
        """

        return self._makeApiCall(self.funcinfo["ping"], *args, **kwargs)

    funcinfo = {
        "claimNamespace": {
            'args': ['namespace'],
            'input': 'http://schemas.taskcluster.net/pulse/v1/namespace-request.json',
            'method': 'post',
            'name': 'claimNamespace',
            'output': 'http://schemas.taskcluster.net/pulse/v1/namespace-response.json',
            'route': '/namespace/<namespace>',
            'stability': 'experimental',
        },
        "listNamespaces": {
            'args': [],
            'method': 'get',
            'name': 'listNamespaces',
            'output': 'http://schemas.taskcluster.net/pulse/v1/list-namespaces-response.json',
            'query': ['limit', 'continuation'],
            'route': '/namespaces',
            'stability': 'experimental',
        },
        "namespace": {
            'args': ['namespace'],
            'method': 'get',
            'name': 'namespace',
            'output': 'http://schemas.taskcluster.net/pulse/v1/namespace.json',
            'route': '/namespace/<namespace>',
            'stability': 'experimental',
        },
        "overview": {
            'args': [],
            'method': 'get',
            'name': 'overview',
            'output': 'http://schemas.taskcluster.net/pulse/v1/rabbit-overview.json',
            'route': '/overview',
            'stability': 'experimental',
        },
        "ping": {
            'args': [],
            'method': 'get',
            'name': 'ping',
            'route': '/ping',
            'stability': 'stable',
        },
    }


__all__ = ['createTemporaryCredentials', 'config', '_defaultConfig', 'createApiClient', 'createSession', 'Pulse']
