/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * AUTOGENERATED - DO NOT EDIT
 *******************************************************************************
 * This file has been generated from the protobuf message
 * perfetto/config/power/android_power_config.proto
 * by
 * ../../tools/proto_to_cpp/proto_to_cpp.cc.
 * If you need to make changes here, change the .proto file and then run
 * ./tools/gen_tracing_cpp_headers_from_protos
 */

#include "perfetto/tracing/core/android_power_config.h"

#include "perfetto/config/power/android_power_config.pb.h"

namespace perfetto {

AndroidPowerConfig::AndroidPowerConfig() = default;
AndroidPowerConfig::~AndroidPowerConfig() = default;
AndroidPowerConfig::AndroidPowerConfig(const AndroidPowerConfig&) = default;
AndroidPowerConfig& AndroidPowerConfig::operator=(const AndroidPowerConfig&) =
    default;
AndroidPowerConfig::AndroidPowerConfig(AndroidPowerConfig&&) noexcept = default;
AndroidPowerConfig& AndroidPowerConfig::operator=(AndroidPowerConfig&&) =
    default;

void AndroidPowerConfig::FromProto(
    const perfetto::protos::AndroidPowerConfig& proto) {
  static_assert(sizeof(battery_poll_ms_) == sizeof(proto.battery_poll_ms()),
                "size mismatch");
  battery_poll_ms_ =
      static_cast<decltype(battery_poll_ms_)>(proto.battery_poll_ms());

  battery_counters_.clear();
  for (const auto& field : proto.battery_counters()) {
    battery_counters_.emplace_back();
    static_assert(
        sizeof(battery_counters_.back()) == sizeof(proto.battery_counters(0)),
        "size mismatch");
    battery_counters_.back() =
        static_cast<decltype(battery_counters_)::value_type>(field);
  }
  unknown_fields_ = proto.unknown_fields();
}

void AndroidPowerConfig::ToProto(
    perfetto::protos::AndroidPowerConfig* proto) const {
  proto->Clear();

  static_assert(sizeof(battery_poll_ms_) == sizeof(proto->battery_poll_ms()),
                "size mismatch");
  proto->set_battery_poll_ms(
      static_cast<decltype(proto->battery_poll_ms())>(battery_poll_ms_));

  for (const auto& it : battery_counters_) {
    proto->add_battery_counters(
        static_cast<decltype(proto->battery_counters(0))>(it));
    static_assert(sizeof(it) == sizeof(proto->battery_counters(0)),
                  "size mismatch");
  }
  *(proto->mutable_unknown_fields()) = unknown_fields_;
}

}  // namespace perfetto
