/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * AUTOGENERATED - DO NOT EDIT
 *******************************************************************************
 * This file has been generated from the protobuf message
 * perfetto/config/test_config.proto
 * by
 * ../../tools/proto_to_cpp/proto_to_cpp.cc.
 * If you need to make changes here, change the .proto file and then run
 * ./tools/gen_tracing_cpp_headers_from_protos
 */

#ifndef INCLUDE_PERFETTO_TRACING_CORE_TEST_CONFIG_H_
#define INCLUDE_PERFETTO_TRACING_CORE_TEST_CONFIG_H_

#include <stdint.h>
#include <string>
#include <type_traits>
#include <vector>

#include "perfetto/base/export.h"

// Forward declarations for protobuf types.
namespace perfetto {
namespace protos {
class TestConfig;
class TestConfig_DummyFields;
}  // namespace protos
}  // namespace perfetto

namespace perfetto {

class PERFETTO_EXPORT TestConfig {
 public:
  class PERFETTO_EXPORT DummyFields {
   public:
    DummyFields();
    ~DummyFields();
    DummyFields(DummyFields&&) noexcept;
    DummyFields& operator=(DummyFields&&);
    DummyFields(const DummyFields&);
    DummyFields& operator=(const DummyFields&);

    // Conversion methods from/to the corresponding protobuf types.
    void FromProto(const perfetto::protos::TestConfig_DummyFields&);
    void ToProto(perfetto::protos::TestConfig_DummyFields*) const;

    uint32_t field_uint32() const { return field_uint32_; }
    void set_field_uint32(uint32_t value) { field_uint32_ = value; }

    int32_t field_int32() const { return field_int32_; }
    void set_field_int32(int32_t value) { field_int32_ = value; }

    uint64_t field_uint64() const { return field_uint64_; }
    void set_field_uint64(uint64_t value) { field_uint64_ = value; }

    int64_t field_int64() const { return field_int64_; }
    void set_field_int64(int64_t value) { field_int64_ = value; }

    uint64_t field_fixed64() const { return field_fixed64_; }
    void set_field_fixed64(uint64_t value) { field_fixed64_ = value; }

    int64_t field_sfixed64() const { return field_sfixed64_; }
    void set_field_sfixed64(int64_t value) { field_sfixed64_ = value; }

    uint32_t field_fixed32() const { return field_fixed32_; }
    void set_field_fixed32(uint32_t value) { field_fixed32_ = value; }

    int32_t field_sfixed32() const { return field_sfixed32_; }
    void set_field_sfixed32(int32_t value) { field_sfixed32_ = value; }

    double field_double() const { return field_double_; }
    void set_field_double(double value) { field_double_ = value; }

    float field_float() const { return field_float_; }
    void set_field_float(float value) { field_float_ = value; }

    int64_t field_sint64() const { return field_sint64_; }
    void set_field_sint64(int64_t value) { field_sint64_ = value; }

    int32_t field_sint32() const { return field_sint32_; }
    void set_field_sint32(int32_t value) { field_sint32_ = value; }

    const std::string& field_string() const { return field_string_; }
    void set_field_string(const std::string& value) { field_string_ = value; }

    const std::string& field_bytes() const { return field_bytes_; }
    void set_field_bytes(const std::string& value) { field_bytes_ = value; }
    void set_field_bytes(const void* p, size_t s) {
      field_bytes_.assign(reinterpret_cast<const char*>(p), s);
    }

   private:
    uint32_t field_uint32_ = {};
    int32_t field_int32_ = {};
    uint64_t field_uint64_ = {};
    int64_t field_int64_ = {};
    uint64_t field_fixed64_ = {};
    int64_t field_sfixed64_ = {};
    uint32_t field_fixed32_ = {};
    int32_t field_sfixed32_ = {};
    double field_double_ = {};
    float field_float_ = {};
    int64_t field_sint64_ = {};
    int32_t field_sint32_ = {};
    std::string field_string_ = {};
    std::string field_bytes_ = {};

    // Allows to preserve unknown protobuf fields for compatibility
    // with future versions of .proto files.
    std::string unknown_fields_;
  };

  TestConfig();
  ~TestConfig();
  TestConfig(TestConfig&&) noexcept;
  TestConfig& operator=(TestConfig&&);
  TestConfig(const TestConfig&);
  TestConfig& operator=(const TestConfig&);

  // Conversion methods from/to the corresponding protobuf types.
  void FromProto(const perfetto::protos::TestConfig&);
  void ToProto(perfetto::protos::TestConfig*) const;

  uint32_t message_count() const { return message_count_; }
  void set_message_count(uint32_t value) { message_count_ = value; }

  uint32_t max_messages_per_second() const { return max_messages_per_second_; }
  void set_max_messages_per_second(uint32_t value) {
    max_messages_per_second_ = value;
  }

  uint32_t seed() const { return seed_; }
  void set_seed(uint32_t value) { seed_ = value; }

  uint32_t message_size() const { return message_size_; }
  void set_message_size(uint32_t value) { message_size_ = value; }

  bool send_batch_on_register() const { return send_batch_on_register_; }
  void set_send_batch_on_register(bool value) {
    send_batch_on_register_ = value;
  }

  const DummyFields& dummy_fields() const { return dummy_fields_; }
  DummyFields* mutable_dummy_fields() { return &dummy_fields_; }

 private:
  uint32_t message_count_ = {};
  uint32_t max_messages_per_second_ = {};
  uint32_t seed_ = {};
  uint32_t message_size_ = {};
  bool send_batch_on_register_ = {};
  DummyFields dummy_fields_ = {};

  // Allows to preserve unknown protobuf fields for compatibility
  // with future versions of .proto files.
  std::string unknown_fields_;
};

}  // namespace perfetto

#endif  // INCLUDE_PERFETTO_TRACING_CORE_TEST_CONFIG_H_
