/*
 * Generated by gdbus-codegen 2.59.0 from org.freedesktop.UPower.xml. DO NOT EDIT.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "up-daemon-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  gboolean use_gvariant;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.UPower
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UpExportedDaemon
 * @title: UpExportedDaemon
 * @short_description: Generated C code for the org.freedesktop.UPower D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-UPower.top_of_page">org.freedesktop.UPower</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.UPower ---- */

static const _ExtendedGDBusArgInfo _up_exported_daemon_method_info_enumerate_devices_OUT_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _up_exported_daemon_method_info_enumerate_devices_OUT_ARG_pointers[] =
{
  &_up_exported_daemon_method_info_enumerate_devices_OUT_ARG_devices.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _up_exported_daemon_method_enumerate_devices_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _up_exported_daemon_method_enumerate_devices_annotation_info_pointers[] =
{
  &_up_exported_daemon_method_enumerate_devices_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _up_exported_daemon_method_info_enumerate_devices =
{
  {
    -1,
    (gchar *) "EnumerateDevices",
    NULL,
    (GDBusArgInfo **) &_up_exported_daemon_method_info_enumerate_devices_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_up_exported_daemon_method_enumerate_devices_annotation_info_pointers
  },
  "handle-enumerate-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _up_exported_daemon_method_info_get_display_device_OUT_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _up_exported_daemon_method_info_get_display_device_OUT_ARG_pointers[] =
{
  &_up_exported_daemon_method_info_get_display_device_OUT_ARG_device.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _up_exported_daemon_method_get_display_device_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _up_exported_daemon_method_get_display_device_annotation_info_pointers[] =
{
  &_up_exported_daemon_method_get_display_device_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _up_exported_daemon_method_info_get_display_device =
{
  {
    -1,
    (gchar *) "GetDisplayDevice",
    NULL,
    (GDBusArgInfo **) &_up_exported_daemon_method_info_get_display_device_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_up_exported_daemon_method_get_display_device_annotation_info_pointers
  },
  "handle-get-display-device",
  FALSE
};

static const _ExtendedGDBusArgInfo _up_exported_daemon_method_info_get_critical_action_OUT_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _up_exported_daemon_method_info_get_critical_action_OUT_ARG_pointers[] =
{
  &_up_exported_daemon_method_info_get_critical_action_OUT_ARG_action.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _up_exported_daemon_method_get_critical_action_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.Async",
  (gchar *) "",
  NULL
};

static const GDBusAnnotationInfo * const _up_exported_daemon_method_get_critical_action_annotation_info_pointers[] =
{
  &_up_exported_daemon_method_get_critical_action_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _up_exported_daemon_method_info_get_critical_action =
{
  {
    -1,
    (gchar *) "GetCriticalAction",
    NULL,
    (GDBusArgInfo **) &_up_exported_daemon_method_info_get_critical_action_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_up_exported_daemon_method_get_critical_action_annotation_info_pointers
  },
  "handle-get-critical-action",
  FALSE
};

static const GDBusMethodInfo * const _up_exported_daemon_method_info_pointers[] =
{
  &_up_exported_daemon_method_info_enumerate_devices.parent_struct,
  &_up_exported_daemon_method_info_get_display_device.parent_struct,
  &_up_exported_daemon_method_info_get_critical_action.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _up_exported_daemon_signal_info_device_added_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _up_exported_daemon_signal_info_device_added_ARG_pointers[] =
{
  &_up_exported_daemon_signal_info_device_added_ARG_device.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _up_exported_daemon_signal_info_device_added =
{
  {
    -1,
    (gchar *) "DeviceAdded",
    (GDBusArgInfo **) &_up_exported_daemon_signal_info_device_added_ARG_pointers,
    NULL
  },
  "device-added"
};

static const _ExtendedGDBusArgInfo _up_exported_daemon_signal_info_device_removed_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _up_exported_daemon_signal_info_device_removed_ARG_pointers[] =
{
  &_up_exported_daemon_signal_info_device_removed_ARG_device.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _up_exported_daemon_signal_info_device_removed =
{
  {
    -1,
    (gchar *) "DeviceRemoved",
    (GDBusArgInfo **) &_up_exported_daemon_signal_info_device_removed_ARG_pointers,
    NULL
  },
  "device-removed"
};

static const GDBusSignalInfo * const _up_exported_daemon_signal_info_pointers[] =
{
  &_up_exported_daemon_signal_info_device_added.parent_struct,
  &_up_exported_daemon_signal_info_device_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _up_exported_daemon_property_info_daemon_version =
{
  {
    -1,
    (gchar *) "DaemonVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "daemon-version",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _up_exported_daemon_property_info_on_battery =
{
  {
    -1,
    (gchar *) "OnBattery",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "on-battery",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _up_exported_daemon_property_info_lid_is_closed =
{
  {
    -1,
    (gchar *) "LidIsClosed",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "lid-is-closed",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _up_exported_daemon_property_info_lid_is_present =
{
  {
    -1,
    (gchar *) "LidIsPresent",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "lid-is-present",
  FALSE
};

static const GDBusPropertyInfo * const _up_exported_daemon_property_info_pointers[] =
{
  &_up_exported_daemon_property_info_daemon_version.parent_struct,
  &_up_exported_daemon_property_info_on_battery.parent_struct,
  &_up_exported_daemon_property_info_lid_is_closed.parent_struct,
  &_up_exported_daemon_property_info_lid_is_present.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _up_exported_daemon_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.UPower",
    (GDBusMethodInfo **) &_up_exported_daemon_method_info_pointers,
    (GDBusSignalInfo **) &_up_exported_daemon_signal_info_pointers,
    (GDBusPropertyInfo **) &_up_exported_daemon_property_info_pointers,
    NULL
  },
  "exported-daemon",
};


/**
 * up_exported_daemon_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-UPower.top_of_page">org.freedesktop.UPower</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
up_exported_daemon_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_up_exported_daemon_interface_info.parent_struct;
}

/**
 * up_exported_daemon_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UpExportedDaemon interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
up_exported_daemon_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "daemon-version");
  g_object_class_override_property (klass, property_id_begin++, "on-battery");
  g_object_class_override_property (klass, property_id_begin++, "lid-is-closed");
  g_object_class_override_property (klass, property_id_begin++, "lid-is-present");
  return property_id_begin - 1;
}



/**
 * UpExportedDaemon:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UPower.top_of_page">org.freedesktop.UPower</link>.
 */

/**
 * UpExportedDaemonIface:
 * @parent_iface: The parent interface.
 * @handle_enumerate_devices: Handler for the #UpExportedDaemon::handle-enumerate-devices signal.
 * @handle_get_critical_action: Handler for the #UpExportedDaemon::handle-get-critical-action signal.
 * @handle_get_display_device: Handler for the #UpExportedDaemon::handle-get-display-device signal.
 * @get_daemon_version: Getter for the #UpExportedDaemon:daemon-version property.
 * @get_lid_is_closed: Getter for the #UpExportedDaemon:lid-is-closed property.
 * @get_lid_is_present: Getter for the #UpExportedDaemon:lid-is-present property.
 * @get_on_battery: Getter for the #UpExportedDaemon:on-battery property.
 * @device_added: Handler for the #UpExportedDaemon::device-added signal.
 * @device_removed: Handler for the #UpExportedDaemon::device-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UPower.top_of_page">org.freedesktop.UPower</link>.
 */

typedef UpExportedDaemonIface UpExportedDaemonInterface;
G_DEFINE_INTERFACE (UpExportedDaemon, up_exported_daemon, G_TYPE_OBJECT)

static void
up_exported_daemon_default_init (UpExportedDaemonIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UpExportedDaemon::handle-enumerate-devices:
   * @object: A #UpExportedDaemon.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UPower.EnumerateDevices">EnumerateDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call up_exported_daemon_complete_enumerate_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enumerate-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UpExportedDaemonIface, handle_enumerate_devices),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * UpExportedDaemon::handle-get-display-device:
   * @object: A #UpExportedDaemon.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UPower.GetDisplayDevice">GetDisplayDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call up_exported_daemon_complete_get_display_device() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-display-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UpExportedDaemonIface, handle_get_display_device),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * UpExportedDaemon::handle-get-critical-action:
   * @object: A #UpExportedDaemon.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-UPower.GetCriticalAction">GetCriticalAction()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call up_exported_daemon_complete_get_critical_action() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-critical-action",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UpExportedDaemonIface, handle_get_critical_action),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * UpExportedDaemon::device-added:
   * @object: A #UpExportedDaemon.
   * @arg_device: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-UPower.DeviceAdded">"DeviceAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("device-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UpExportedDaemonIface, device_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * UpExportedDaemon::device-removed:
   * @object: A #UpExportedDaemon.
   * @arg_device: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-UPower.DeviceRemoved">"DeviceRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("device-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UpExportedDaemonIface, device_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * UpExportedDaemon:daemon-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UPower.DaemonVersion">"DaemonVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("daemon-version", "DaemonVersion", "DaemonVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UpExportedDaemon:on-battery:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UPower.OnBattery">"OnBattery"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("on-battery", "OnBattery", "OnBattery", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UpExportedDaemon:lid-is-closed:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UPower.LidIsClosed">"LidIsClosed"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("lid-is-closed", "LidIsClosed", "LidIsClosed", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UpExportedDaemon:lid-is-present:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-UPower.LidIsPresent">"LidIsPresent"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("lid-is-present", "LidIsPresent", "LidIsPresent", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * up_exported_daemon_get_daemon_version: (skip)
 * @object: A #UpExportedDaemon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UPower.DaemonVersion">"DaemonVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use up_exported_daemon_dup_daemon_version() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
up_exported_daemon_get_daemon_version (UpExportedDaemon *object)
{
  return UP_EXPORTED_DAEMON_GET_IFACE (object)->get_daemon_version (object);
}

/**
 * up_exported_daemon_dup_daemon_version: (skip)
 * @object: A #UpExportedDaemon.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-UPower.DaemonVersion">"DaemonVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
up_exported_daemon_dup_daemon_version (UpExportedDaemon *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "daemon-version", &value, NULL);
  return value;
}

/**
 * up_exported_daemon_set_daemon_version: (skip)
 * @object: A #UpExportedDaemon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UPower.DaemonVersion">"DaemonVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
up_exported_daemon_set_daemon_version (UpExportedDaemon *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "daemon-version", value, NULL);
}

/**
 * up_exported_daemon_get_on_battery: (skip)
 * @object: A #UpExportedDaemon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UPower.OnBattery">"OnBattery"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
up_exported_daemon_get_on_battery (UpExportedDaemon *object)
{
  return UP_EXPORTED_DAEMON_GET_IFACE (object)->get_on_battery (object);
}

/**
 * up_exported_daemon_set_on_battery: (skip)
 * @object: A #UpExportedDaemon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UPower.OnBattery">"OnBattery"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
up_exported_daemon_set_on_battery (UpExportedDaemon *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "on-battery", value, NULL);
}

/**
 * up_exported_daemon_get_lid_is_closed: (skip)
 * @object: A #UpExportedDaemon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UPower.LidIsClosed">"LidIsClosed"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
up_exported_daemon_get_lid_is_closed (UpExportedDaemon *object)
{
  return UP_EXPORTED_DAEMON_GET_IFACE (object)->get_lid_is_closed (object);
}

/**
 * up_exported_daemon_set_lid_is_closed: (skip)
 * @object: A #UpExportedDaemon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UPower.LidIsClosed">"LidIsClosed"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
up_exported_daemon_set_lid_is_closed (UpExportedDaemon *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "lid-is-closed", value, NULL);
}

/**
 * up_exported_daemon_get_lid_is_present: (skip)
 * @object: A #UpExportedDaemon.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-UPower.LidIsPresent">"LidIsPresent"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
up_exported_daemon_get_lid_is_present (UpExportedDaemon *object)
{
  return UP_EXPORTED_DAEMON_GET_IFACE (object)->get_lid_is_present (object);
}

/**
 * up_exported_daemon_set_lid_is_present: (skip)
 * @object: A #UpExportedDaemon.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-UPower.LidIsPresent">"LidIsPresent"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
up_exported_daemon_set_lid_is_present (UpExportedDaemon *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "lid-is-present", value, NULL);
}

/**
 * up_exported_daemon_emit_device_added:
 * @object: A #UpExportedDaemon.
 * @arg_device: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-UPower.DeviceAdded">"DeviceAdded"</link> D-Bus signal.
 */
void
up_exported_daemon_emit_device_added (
    UpExportedDaemon *object,
    const gchar *arg_device)
{
  g_signal_emit_by_name (object, "device-added", arg_device);
}

/**
 * up_exported_daemon_emit_device_removed:
 * @object: A #UpExportedDaemon.
 * @arg_device: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-UPower.DeviceRemoved">"DeviceRemoved"</link> D-Bus signal.
 */
void
up_exported_daemon_emit_device_removed (
    UpExportedDaemon *object,
    const gchar *arg_device)
{
  g_signal_emit_by_name (object, "device-removed", arg_device);
}

/**
 * up_exported_daemon_call_enumerate_devices:
 * @proxy: A #UpExportedDaemonProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UPower.EnumerateDevices">EnumerateDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call up_exported_daemon_call_enumerate_devices_finish() to get the result of the operation.
 *
 * See up_exported_daemon_call_enumerate_devices_sync() for the synchronous, blocking version of this method.
 */
void
up_exported_daemon_call_enumerate_devices (
    UpExportedDaemon *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnumerateDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * up_exported_daemon_call_enumerate_devices_finish:
 * @proxy: A #UpExportedDaemonProxy.
 * @out_devices: (out) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to up_exported_daemon_call_enumerate_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with up_exported_daemon_call_enumerate_devices().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
up_exported_daemon_call_enumerate_devices_finish (
    UpExportedDaemon *proxy,
    gchar ***out_devices,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * up_exported_daemon_call_enumerate_devices_sync:
 * @proxy: A #UpExportedDaemonProxy.
 * @out_devices: (out) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UPower.EnumerateDevices">EnumerateDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See up_exported_daemon_call_enumerate_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
up_exported_daemon_call_enumerate_devices_sync (
    UpExportedDaemon *proxy,
    gchar ***out_devices,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnumerateDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_devices);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * up_exported_daemon_call_get_display_device:
 * @proxy: A #UpExportedDaemonProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UPower.GetDisplayDevice">GetDisplayDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call up_exported_daemon_call_get_display_device_finish() to get the result of the operation.
 *
 * See up_exported_daemon_call_get_display_device_sync() for the synchronous, blocking version of this method.
 */
void
up_exported_daemon_call_get_display_device (
    UpExportedDaemon *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDisplayDevice",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * up_exported_daemon_call_get_display_device_finish:
 * @proxy: A #UpExportedDaemonProxy.
 * @out_device: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to up_exported_daemon_call_get_display_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with up_exported_daemon_call_get_display_device().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
up_exported_daemon_call_get_display_device_finish (
    UpExportedDaemon *proxy,
    gchar **out_device,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * up_exported_daemon_call_get_display_device_sync:
 * @proxy: A #UpExportedDaemonProxy.
 * @out_device: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UPower.GetDisplayDevice">GetDisplayDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See up_exported_daemon_call_get_display_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
up_exported_daemon_call_get_display_device_sync (
    UpExportedDaemon *proxy,
    gchar **out_device,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDisplayDevice",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_device);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * up_exported_daemon_call_get_critical_action:
 * @proxy: A #UpExportedDaemonProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-UPower.GetCriticalAction">GetCriticalAction()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call up_exported_daemon_call_get_critical_action_finish() to get the result of the operation.
 *
 * See up_exported_daemon_call_get_critical_action_sync() for the synchronous, blocking version of this method.
 */
void
up_exported_daemon_call_get_critical_action (
    UpExportedDaemon *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCriticalAction",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * up_exported_daemon_call_get_critical_action_finish:
 * @proxy: A #UpExportedDaemonProxy.
 * @out_action: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to up_exported_daemon_call_get_critical_action().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with up_exported_daemon_call_get_critical_action().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
up_exported_daemon_call_get_critical_action_finish (
    UpExportedDaemon *proxy,
    gchar **out_action,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_action);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * up_exported_daemon_call_get_critical_action_sync:
 * @proxy: A #UpExportedDaemonProxy.
 * @out_action: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-UPower.GetCriticalAction">GetCriticalAction()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See up_exported_daemon_call_get_critical_action() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
up_exported_daemon_call_get_critical_action_sync (
    UpExportedDaemon *proxy,
    gchar **out_action,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCriticalAction",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_action);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * up_exported_daemon_complete_enumerate_devices:
 * @object: A #UpExportedDaemon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @devices: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UPower.EnumerateDevices">EnumerateDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
up_exported_daemon_complete_enumerate_devices (
    UpExportedDaemon *object,
    GDBusMethodInvocation *invocation,
    const gchar *const *devices)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   devices));
}

/**
 * up_exported_daemon_complete_get_display_device:
 * @object: A #UpExportedDaemon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @device: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UPower.GetDisplayDevice">GetDisplayDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
up_exported_daemon_complete_get_display_device (
    UpExportedDaemon *object,
    GDBusMethodInvocation *invocation,
    const gchar *device)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   device));
}

/**
 * up_exported_daemon_complete_get_critical_action:
 * @object: A #UpExportedDaemon.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @action: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-UPower.GetCriticalAction">GetCriticalAction()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
up_exported_daemon_complete_get_critical_action (
    UpExportedDaemon *object,
    GDBusMethodInvocation *invocation,
    const gchar *action)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   action));
}

/* ------------------------------------------------------------------------ */

/**
 * UpExportedDaemonProxy:
 *
 * The #UpExportedDaemonProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UpExportedDaemonProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UpExportedDaemonProxy.
 */

struct _UpExportedDaemonProxyPrivate
{
  GData *qdata;
};

static void up_exported_daemon_proxy_iface_init (UpExportedDaemonIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UpExportedDaemonProxy, up_exported_daemon_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UpExportedDaemonProxy)
                         G_IMPLEMENT_INTERFACE (UP_TYPE_EXPORTED_DAEMON, up_exported_daemon_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UpExportedDaemonProxy, up_exported_daemon_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UP_TYPE_EXPORTED_DAEMON, up_exported_daemon_proxy_iface_init))

#endif
static void
up_exported_daemon_proxy_finalize (GObject *object)
{
  UpExportedDaemonProxy *proxy = UP_EXPORTED_DAEMON_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (up_exported_daemon_proxy_parent_class)->finalize (object);
}

static void
up_exported_daemon_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _up_exported_daemon_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
up_exported_daemon_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.UPower: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
up_exported_daemon_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _up_exported_daemon_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.UPower", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) up_exported_daemon_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
up_exported_daemon_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_up_exported_daemon_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UP_TYPE_EXPORTED_DAEMON);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UP_TYPE_EXPORTED_DAEMON);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
up_exported_daemon_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UpExportedDaemonProxy *proxy = UP_EXPORTED_DAEMON_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_up_exported_daemon_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_up_exported_daemon_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
up_exported_daemon_proxy_get_daemon_version (UpExportedDaemon *object)
{
  UpExportedDaemonProxy *proxy = UP_EXPORTED_DAEMON_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DaemonVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
up_exported_daemon_proxy_get_on_battery (UpExportedDaemon *object)
{
  UpExportedDaemonProxy *proxy = UP_EXPORTED_DAEMON_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OnBattery");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
up_exported_daemon_proxy_get_lid_is_closed (UpExportedDaemon *object)
{
  UpExportedDaemonProxy *proxy = UP_EXPORTED_DAEMON_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LidIsClosed");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
up_exported_daemon_proxy_get_lid_is_present (UpExportedDaemon *object)
{
  UpExportedDaemonProxy *proxy = UP_EXPORTED_DAEMON_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LidIsPresent");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
up_exported_daemon_proxy_init (UpExportedDaemonProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = up_exported_daemon_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UP_TYPE_EXPORTED_DAEMON_PROXY, UpExportedDaemonProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), up_exported_daemon_interface_info ());
}

static void
up_exported_daemon_proxy_class_init (UpExportedDaemonProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = up_exported_daemon_proxy_finalize;
  gobject_class->get_property = up_exported_daemon_proxy_get_property;
  gobject_class->set_property = up_exported_daemon_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = up_exported_daemon_proxy_g_signal;
  proxy_class->g_properties_changed = up_exported_daemon_proxy_g_properties_changed;

  up_exported_daemon_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UpExportedDaemonProxyPrivate));
#endif
}

static void
up_exported_daemon_proxy_iface_init (UpExportedDaemonIface *iface)
{
  iface->get_daemon_version = up_exported_daemon_proxy_get_daemon_version;
  iface->get_on_battery = up_exported_daemon_proxy_get_on_battery;
  iface->get_lid_is_closed = up_exported_daemon_proxy_get_lid_is_closed;
  iface->get_lid_is_present = up_exported_daemon_proxy_get_lid_is_present;
}

/**
 * up_exported_daemon_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UPower.top_of_page">org.freedesktop.UPower</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call up_exported_daemon_proxy_new_finish() to get the result of the operation.
 *
 * See up_exported_daemon_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
up_exported_daemon_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UP_TYPE_EXPORTED_DAEMON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UPower", NULL);
}

/**
 * up_exported_daemon_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to up_exported_daemon_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with up_exported_daemon_proxy_new().
 *
 * Returns: (transfer full) (type UpExportedDaemonProxy): The constructed proxy object or %NULL if @error is set.
 */
UpExportedDaemon *
up_exported_daemon_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UP_EXPORTED_DAEMON (ret);
  else
    return NULL;
}

/**
 * up_exported_daemon_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UPower.top_of_page">org.freedesktop.UPower</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See up_exported_daemon_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UpExportedDaemonProxy): The constructed proxy object or %NULL if @error is set.
 */
UpExportedDaemon *
up_exported_daemon_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UP_TYPE_EXPORTED_DAEMON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UPower", NULL);
  if (ret != NULL)
    return UP_EXPORTED_DAEMON (ret);
  else
    return NULL;
}


/**
 * up_exported_daemon_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like up_exported_daemon_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call up_exported_daemon_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See up_exported_daemon_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
up_exported_daemon_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UP_TYPE_EXPORTED_DAEMON_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UPower", NULL);
}

/**
 * up_exported_daemon_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to up_exported_daemon_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with up_exported_daemon_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UpExportedDaemonProxy): The constructed proxy object or %NULL if @error is set.
 */
UpExportedDaemon *
up_exported_daemon_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UP_EXPORTED_DAEMON (ret);
  else
    return NULL;
}

/**
 * up_exported_daemon_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like up_exported_daemon_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See up_exported_daemon_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UpExportedDaemonProxy): The constructed proxy object or %NULL if @error is set.
 */
UpExportedDaemon *
up_exported_daemon_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UP_TYPE_EXPORTED_DAEMON_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.UPower", NULL);
  if (ret != NULL)
    return UP_EXPORTED_DAEMON (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UpExportedDaemonSkeleton:
 *
 * The #UpExportedDaemonSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UpExportedDaemonSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UpExportedDaemonSkeleton.
 */

struct _UpExportedDaemonSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_up_exported_daemon_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UP_TYPE_EXPORTED_DAEMON);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UP_TYPE_EXPORTED_DAEMON);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_up_exported_daemon_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_up_exported_daemon_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_up_exported_daemon_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_up_exported_daemon_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _up_exported_daemon_skeleton_vtable =
{
  _up_exported_daemon_skeleton_handle_method_call,
  _up_exported_daemon_skeleton_handle_get_property,
  _up_exported_daemon_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
up_exported_daemon_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return up_exported_daemon_interface_info ();
}

static GDBusInterfaceVTable *
up_exported_daemon_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_up_exported_daemon_skeleton_vtable;
}

static GVariant *
up_exported_daemon_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_up_exported_daemon_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _up_exported_daemon_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _up_exported_daemon_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _up_exported_daemon_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UPower", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _up_exported_daemon_emit_changed (gpointer user_data);

static void
up_exported_daemon_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _up_exported_daemon_emit_changed (skeleton);
}

static void
_up_exported_daemon_on_signal_device_added (
    UpExportedDaemon *object,
    const gchar *arg_device)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_device));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UPower", "DeviceAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_up_exported_daemon_on_signal_device_removed (
    UpExportedDaemon *object,
    const gchar *arg_device)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_device));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.UPower", "DeviceRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void up_exported_daemon_skeleton_iface_init (UpExportedDaemonIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UpExportedDaemonSkeleton, up_exported_daemon_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UpExportedDaemonSkeleton)
                         G_IMPLEMENT_INTERFACE (UP_TYPE_EXPORTED_DAEMON, up_exported_daemon_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UpExportedDaemonSkeleton, up_exported_daemon_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UP_TYPE_EXPORTED_DAEMON, up_exported_daemon_skeleton_iface_init))

#endif
static void
up_exported_daemon_skeleton_finalize (GObject *object)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (up_exported_daemon_skeleton_parent_class)->finalize (object);
}

static void
up_exported_daemon_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_up_exported_daemon_emit_changed (gpointer user_data)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.UPower",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_up_exported_daemon_schedule_emit_changed (UpExportedDaemonSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
up_exported_daemon_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _up_exported_daemon_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _up_exported_daemon_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
up_exported_daemon_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _up_exported_daemon_schedule_emit_changed (skeleton, (const _ExtendedGDBusPropertyInfo *) _up_exported_daemon_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
up_exported_daemon_skeleton_init (UpExportedDaemonSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = up_exported_daemon_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UP_TYPE_EXPORTED_DAEMON_SKELETON, UpExportedDaemonSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
}

static const gchar *
up_exported_daemon_skeleton_get_daemon_version (UpExportedDaemon *object)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
up_exported_daemon_skeleton_get_on_battery (UpExportedDaemon *object)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
up_exported_daemon_skeleton_get_lid_is_closed (UpExportedDaemon *object)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
up_exported_daemon_skeleton_get_lid_is_present (UpExportedDaemon *object)
{
  UpExportedDaemonSkeleton *skeleton = UP_EXPORTED_DAEMON_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
up_exported_daemon_skeleton_class_init (UpExportedDaemonSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = up_exported_daemon_skeleton_finalize;
  gobject_class->get_property = up_exported_daemon_skeleton_get_property;
  gobject_class->set_property = up_exported_daemon_skeleton_set_property;
  gobject_class->notify       = up_exported_daemon_skeleton_notify;


  up_exported_daemon_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = up_exported_daemon_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = up_exported_daemon_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = up_exported_daemon_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = up_exported_daemon_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UpExportedDaemonSkeletonPrivate));
#endif
}

static void
up_exported_daemon_skeleton_iface_init (UpExportedDaemonIface *iface)
{
  iface->device_added = _up_exported_daemon_on_signal_device_added;
  iface->device_removed = _up_exported_daemon_on_signal_device_removed;
  iface->get_daemon_version = up_exported_daemon_skeleton_get_daemon_version;
  iface->get_on_battery = up_exported_daemon_skeleton_get_on_battery;
  iface->get_lid_is_closed = up_exported_daemon_skeleton_get_lid_is_closed;
  iface->get_lid_is_present = up_exported_daemon_skeleton_get_lid_is_present;
}

/**
 * up_exported_daemon_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-UPower.top_of_page">org.freedesktop.UPower</link>.
 *
 * Returns: (transfer full) (type UpExportedDaemonSkeleton): The skeleton object.
 */
UpExportedDaemon *
up_exported_daemon_skeleton_new (void)
{
  return UP_EXPORTED_DAEMON (g_object_new (UP_TYPE_EXPORTED_DAEMON_SKELETON, NULL));
}

