/*

Copyright (C) 2010-2011 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_H
#define TQT_H

#define USE_QT@QT_VERSION@

#ifndef TQT_VERSION_ONLY

#ifdef USE_QT4
#define QT3_SUPPORT
#endif

#ifdef TQT_METHOD
#undef TQT_METHOD
#endif
#ifdef TQT_SLOT
#undef TQT_SLOT
#endif
#ifdef TQT_SIGNAL
#undef TQT_SIGNAL
#endif

#ifdef __cplusplus
#define TQT_METHOD(a)	METHOD(a)
#define TQT_SLOT(a)	SLOT(a)
#define TQT_SIGNAL(a)	SIGNAL(a)
#endif /* __cplusplus */

#ifdef USE_QT3

#include <qglobal.h>

#ifdef QT_NO_SQL
#define TQT_NO_SQL
#endif /* QT_NO_SQL */

#ifdef Q_WS_X11
#define TQ_WS_X11
#endif /* Q_WS_X11 */

#define TQ_OBJECT		/* UNUSED */

#define TQWIDGETSIZE_MAX		QWIDGETSIZE_MAX
#define TQ_INLINE_TEMPLATES		Q_INLINE_TEMPLATES
#define TQ_DUMMY_COMPARISON_OPERATOR	Q_DUMMY_COMPARISON_OPERATOR
#define TQM_EXPORT_SQL			QM_EXPORT_SQL

#define TQSIGNAL_CODE			QSIGNAL_CODE
#define TQSLOT_CODE			QSLOT_CODE
#define TQ_OVERRIDE			Q_OVERRIDE
#define TQRESULT			QRESULT
#define TQ_REFCOUNT			Q_REFCOUNT
#define TQE_NOINTERFACE			QE_NOINTERFACE
#define TQS_OK				QS_OK
#define TQTSFUNC			QTSFUNC
#define TQ_TYPENAME			Q_TYPENAME
#define TQT_CHECK_INVALID_MAP_ELEMENT	QT_CHECK_INVALID_MAP_ELEMENT

#define TQT_VERSION			QT_VERSION
#define TQT_VERSION_STR			QT_VERSION_STR
#define TQT_PRODUCT_LICENSEE		QT_PRODUCT_LICENSEE

#define qint64			long
#define quint64			unsigned long

#define tqtr			tr
#define tqaccess		access
#define tqcolorTable		colorTable
#define TQSO_Default		Default
#define SO_Default		Default
#define TQ_PrimitiveElement	PrimitiveElement
#define TQ_StyleHint		StyleHint
#define tqstrcmp		qstrcmp
#define tqqt_cast		qt_cast
#define tqt_dynamic_cast	dynamic_cast
#define TQ_StrongFocus		QWidget::StrongFocus
#define TQ_NoFocus		QWidget::NoFocus
#define TQ_WheelFocus		QWidget::WheelFocus
#define TQ_ClickFocus		QWidget::ClickFocus
#define TQ_TabFocus		QWidget::TabFocus
#define TQ_FocusPolicy		QWidget::FocusPolicy
#define TQ_Horizontal		Horizontal
#define TQ_Vertical		Vertical
#define TQ_Alignment		Qt::AlignmentFlags
#define TQImage_ScaleFree	QImage::ScaleFree
#define TQ_ScaleFree		QImage::ScaleFree
#define TQ_ScaleMin		QImage::ScaleMin
#define TQ_ScaleMax		QImage::ScaleMax
#define TQ_ScaleMode		QImage::ScaleMode
#define TQ_Key_Shift		Key_Shift
#define TQ_Key_Control		Key_Control
#define TQ_Key_Alt		Key_Alt
#define TQ_Key_Meta		Key_Meta
#define TQ_Key_Super_L		Key_Super_L
#define TQ_Key_Super_R		Key_Super_R
#define TQ_Key_Hyper_L		Key_Hyper_L
#define TQ_Key_Hyper_R		Key_Hyper_R
#define TQ_ButtonState		Qt::ButtonState
#define TQ_LeftButton		LeftButton
#define TQ_MidButton		MidButton
#define TQ_RightButton		RightButton
#define TQ_ShiftButton		ShiftButton
#define TQ_ControlButton	ControlButton
#define TQ_AltButton		AltButton
#define TQ_MetaButton		MetaButton
#define TQ_WFlags		TQt::WFlags
#define TQIODevice_OpenModeFlag int
#define TQ_OpenMode		int
#define TQ_SPVertically		TQSizePolicy::Vertically
#define TQ_SPHorizontally	TQSizePolicy::Horizontally
#define TQ_SPNoDirection	TQSizePolicy::NoDirection

#define TQPOINT_OBJECT_NAME_STRING		"QPoint"
#define TQBYTEARRAY_OBJECT_NAME_STRING		"QByteArray"
#define TQPIXMAP_OBJECT_NAME_STRING		"QPixmap"
#define TQSTRING_OBJECT_NAME_STRING		"QString"
#define TQSTRINGLIST_OBJECT_NAME_STRING		"QStringList"
#define TQLAYOUT_OBJECT_NAME_STRING		"QLayout"
#define TQBOXLAYOUT_OBJECT_NAME_STRING		"QBoxLayout"
#define TQHBOXLAYOUT_OBJECT_NAME_STRING		"QHBoxLayout"
#define TQVBOXLAYOUT_OBJECT_NAME_STRING		"QVBoxLayout"
#define TQGRIDLAYOUT_OBJECT_NAME_STRING		"QGridLayout"
#define TQHBOX_OBJECT_NAME_STRING		"QHBox"
#define TQVBOX_OBJECT_NAME_STRING		"QVBox"
#define TQGRID_OBJECT_NAME_STRING		"QGrid"
#define TQTABWIDGET_OBJECT_NAME_STRING		"QTabWidget"
#define TQCHECKBOX_OBJECT_NAME_STRING		"QCheckBox"
#define TQLINEEDIT_OBJECT_NAME_STRING		"QLineEdit"
#define TQTEXTEDIT_OBJECT_NAME_STRING		"QTextEdit"
#define TQOBJECT_OBJECT_NAME_STRING		"QObject"
#define TQWIDGET_OBJECT_NAME_STRING		"QWidget"
#define TQGLWIDGET_OBJECT_NAME_STRING		"QGLWidget"
#define TQLABEL_OBJECT_NAME_STRING		"QLabel"
#define TQTIMER_OBJECT_NAME_STRING		"QTimer"
#define TQFRAME_OBJECT_NAME_STRING		"QFrame"
#define TQACCEL_OBJECT_NAME_STRING		"QAccel"
#define TQDIALOG_OBJECT_NAME_STRING		"QDialog"
#define TQDIAL_OBJECT_NAME_STRING		"QDial"
#define TQACTION_OBJECT_NAME_STRING		"QAction"
#define TQACTIONGROUP_OBJECT_NAME_STRING	"QActionGroup"
#define TQLCDNUMBER_OBJECT_NAME_STRING		"QLCDNumber"
#define TQPROGRESSBAR_OBJECT_NAME_STRING	"QProgressBar"
#define TQTABDIALOG_OBJECT_NAME_STRING		"QTabDialog"
#define TQTABWIDGET_OBJECT_NAME_STRING		"QTabWidget"
#define TQDOCKWINDOW_OBJECT_NAME_STRING		"QDockWindow"
#define TQGROUPBOX_OBJECT_NAME_STRING		"QGroupBox"
#define TQCOMBOBOX_OBJECT_NAME_STRING		"QComboBox"
#define TQSPINBOX_OBJECT_NAME_STRING		"QSpinBox"
#define TQSPINWIDGET_OBJECT_NAME_STRING		"QSpinWidget"
#define TQLISTBOX_OBJECT_NAME_STRING		"QListBox"
#define TQTOOLBOX_OBJECT_NAME_STRING		"QToolBox"
#define TQTOOLBOXBUTTON_OBJECT_NAME_STRING	"QToolBoxButton"
#define TQVGROUPBOX_OBJECT_NAME_STRING		"QVGroupBox"
#define TQSPLITTER_OBJECT_NAME_STRING		"QSplitter"
#define TQSPLITTERHANDLE_OBJECT_NAME_STRING	"QSplitterHandle"
#define TQBUTTON_OBJECT_NAME_STRING		"QButton"
#define TQGRIDVIEW_OBJECT_NAME_STRING		"QGridView"
#define TQSLIDER_OBJECT_NAME_STRING		"QSlider"
#define TQPUSHBUTTON_OBJECT_NAME_STRING		"QPushButton"
#define TQTOOLBUTTON_OBJECT_NAME_STRING		"QToolButton"
#define TQRADIOBUTTON_OBJECT_NAME_STRING	"QRadioButton"
#define TQPOPUPMENU_OBJECT_NAME_STRING		"QPopupMenu"
#define TQTOOLBAR_OBJECT_NAME_STRING		"QToolBar"
#define TQMENUBAR_OBJECT_NAME_STRING		"QMenuBar"
#define TQTABBAR_OBJECT_NAME_STRING		"QTabBar"
#define TQLISTVIEW_OBJECT_NAME_STRING		"QListView"
#define TQSCROLLBAR_OBJECT_NAME_STRING		"QScrollBar"
#define TQSCROLLVIEW_OBJECT_NAME_STRING		"QScrollView"
#define TQRANGECONTROL_OBJECT_NAME_STRING	"QRangeControl"
#define TQCANVASITEM_OBJECT_NAME_STRING		"QCanvasItem"
#define TQICONVIEW_OBJECT_NAME_STRING		"QIconView"
#define TQMULTILINEEDIT_OBJECT_NAME_STRING	"QMultiLineEdit"
#define TQINTVALIDATOR_OBJECT_NAME_STRING	"QIntValidator"
#define TQDATEEDIT_OBJECT_NAME_STRING		"QDateEdit"
#define TQTIMEEDIT_OBJECT_NAME_STRING		"QTimeEdit"
#define TQDATETIMEEDIT_OBJECT_NAME_STRING	"QDateTimeEdit"
#define TQHEADER_OBJECT_NAME_STRING		"QHeader"
#define TQSIZEGRIP_OBJECT_NAME_STRING		"QSizeGrip"
#define TQDOCKWINDOWHANDLE_OBJECT_NAME_STRING	"QDockWindowHandle"
#define TQHIDEDOCK_OBJECT_NAME_STRING		"QHideDock"
#define TQTABLE_OBJECT_NAME_STRING		"QTable"
#define TQWIZARD_OBJECT_NAME_STRING		"QWizard"
#define TQDATATABLE_OBJECT_NAME_STRING		"QDataTable"
#define TQDATABROWSER_OBJECT_NAME_STRING	"QDataBrowser"
#define TQDATAVIEW_OBJECT_NAME_STRING		"QDataView"
#define TQMAINWINDOW_OBJECT_NAME_STRING		"QMainWindow"
#define TQWIDGETSTACK_OBJECT_NAME_STRING	"QWidgetStack"
#define TQBUTTONGROUP_OBJECT_NAME_STRING	"QButtonGroup"
#define TQTEXTVIEW_OBJECT_NAME_STRING		"QTextView"
#define TQTEXTBROWSER_OBJECT_NAME_STRING	"QTextBrowser"
#define TQLAYOUTWIDGET_OBJECT_NAME_STRING	"QLayoutWidget"

#define TQMOTIFPLUSSTYLE_OBJECT_NAME_STRING	"QMotifPlusStyle"

#define TQAlignCenter AlignCenter
#define TQNoBrush NoBrush
#define aboutTQt aboutQt

#define tqred red
#define tqgreen green
#define tqblue blue
#define tqcyan cyan
#define tqmagenta magenta
#define tqyellow yellow
#define tqdarkRed darkRed
#define tqdarkGreen darkGreen
#define tqdarkBlue darkBlue
#define tqdarkCyan darkCyan
#define tqdarkMagenta darkMagenta
#define tqdarkYellow darkYellow
#define tqwhite white
#define tqwhiteptr &Qt::white
#define tqlightGray lightGray
#define tqgray gray
#define tqdarkGray darkGray
#define tqblack black
#define tqblackptr &Qt::black
#define tqcolor0 color0
#define tqcolor1 color1

#define IID_TQUnknown IID_QUnknown
#define IID_TQComponentInformation IID_QComponentInformation
#define IID_TQWidgetFactory IID_QWidgetFactory

#define TQAccel QAccel
#define TQAccessible QAccessible
#define TQAccessibleObject QAccessibleObject
#define TQAction QAction
#define TQActionGroup QActionGroup
#define TQApplication QApplication
#define TQAsciiCache QAsciiCache
#define TQAsciiCacheIterator QAsciiCacheIterator
#define TQAsciiDict QAsciiDict
#define TQAsciiDictIterator QAsciiDictIterator
#define TQAssistantClient QAssistantClient
#define TQImageConsumer QImageConsumer
#define TQImageFormat QImageFormat
#define TQImageFormatType QImageFormatType
#define TQImageDecoder QImageDecoder
#define TQAsyncIO QAsyncIO
#define TQByteArray QByteArray
#define TQDataSink QDataSink
#define TQDataSource QDataSource
#define TQIODeviceSource QIODeviceSource
#define TQDataPump QDataPump
#define TQBig5Codec QBig5Codec
#define TQBig5hkscsCodec QBig5hkscsCodec
#define TQBitVal QBitVal
#define TQBitArray QBitArray
#define TQBitmap QBitmap
#define TQBrush QBrush
#define TQBuffer QBuffer
#define TQButtonGroup QButtonGroup
#define TQButton QButton
#define TQCache QCache
#define TQCacheIterator QCacheIterator
#define TQCanvasChunk QCanvasChunk
#define TQCanvasItemList QCanvasItemList
#define TQCanvasItemExtra QCanvasItemExtra
#define TQCanvasItem QCanvasItem
#define TQCanvasData QCanvasData
#define TQCanvas QCanvas
#define TQCanvasViewData QCanvasViewData
#define TQCanvasView QCanvasView
#define TQCanvasPixmap QCanvasPixmap
#define TQCanvasPixmapArray QCanvasPixmapArray
#define TQCanvasSprite QCanvasSprite
#define TQPolygonalProcessor QPolygonalProcessor
#define TQPDevCmdParam QPDevCmdParam
#define TQCanvasPolygonalItem QCanvasPolygonalItem
#define TQCanvasRectangle QCanvasRectangle
#define TQCanvasPolygon QCanvasPolygon
#define TQCanvasSpline QCanvasSpline
#define TQCanvasLine QCanvasLine
#define TQCanvasEllipse QCanvasEllipse
#define TQCanvasTextExtra QCanvasTextExtra
#define TQCanvasText QCanvasText
#define TQCDEStyle QCDEStyle
#define TQCheckBox QCheckBox
#define TQClassInfo QClassInfo
#define TQCleanupHandler QCleanupHandler
#define TQClipboard QClipboard
#define TQSessionManager QSessionManager
#define TQScriptItem QScriptItem
#define TQSingleCleanupHandler QSingleCleanupHandler
#define TQSharedCleanupHandler QSharedCleanupHandler
#define TQSharedDoubleBuffer QSharedDoubleBuffer
#define TQShared QShared
#define TQCollection QCollection
#define TQColor QColor
#define TQColorDialog QColorDialog
#define TQStringPairList QStringPairList
#define TQLineEdit QLineEdit
#define TQValidator QValidator
#define TQListBox QListBox
#define TQList QList
#define TQComboBoxData QComboBoxData
#define TQComboTableItem QComboTableItem
#define TQWheelEvent QWheelEvent
#define TQComboBox QComboBox
#define TQCommonStyle QCommonStyle
#define TQCompactStyle QCompactStyle
#define TQComponentInformationInterface QComponentInformationInterface
#define TQConnection QConnection
#define TQCString QCString
#define TQCursor QCursor
#define TQSqlForm QSqlForm
#define TQSqlDriverCreator QSqlDriverCreator
#define TQDataBrowserPrivate QDataBrowserPrivate
#define TQDataBrowser QDataBrowser
#define TQDataStream QDataStream
#define TQPainter QPainter
#define TQSqlField QSqlField
#define TQSqlPropertyMap QSqlPropertyMap
#define TQDataTablePrivate QDataTablePrivate
#define TQDataTable QDataTable
#define TQDataView QDataView
#define TQDateEdit QDateEdit
#define TQTimeEdit QTimeEdit
#define TQDateTimeEdit QDateTimeEdit
#define TQDateTimeEditBase QDateTimeEditBase
#define TQDate QDate
#define TQTime QTime
#define TQDateTime QDateTime
#define TQDeepCopy QDeepCopy
#define TQDesktopWidget QDesktopWidget
#define TQDial QDial
#define TQDialog QDialog
#define TQDict QDict
#define TQDictIterator QDictIterator
#define TQDir QDir
#define TQDirLineEdit QDirLineEdit
#define TQDirMultiLineEdit QDirMultiLineEdit
#define TQDns QDns
#define TQDnsSocket QDnsSocket
#define TQDockArea QDockArea
#define TQDockAreaLayout QDockAreaLayout
#define TQDockWindow QDockWindow
#define TQDomImplementation QDomImplementation
#define TQDomNodeList QDomNodeList
#define TQDomDocumentType QDomDocumentType
#define TQDomDocument QDomDocument
#define TQDomNamedNodeMap QDomNamedNodeMap
#define TQDomDocumentFragment QDomDocumentFragment
#define TQDomCharacterData QDomCharacterData
#define TQDomAttr QDomAttr
#define TQDomElement QDomElement
#define TQDomText QDomText
#define TQDomComment QDomComment
#define TQDomCDATASection QDomCDATASection
#define TQDomNotation QDomNotation
#define TQDomEntity QDomEntity
#define TQDomEntityReference QDomEntityReference
#define TQDomProcessingInstruction QDomProcessingInstruction
#define TQDomNode QDomNode
#define TQDragObject QDragObject
#define TQStoredDrag QStoredDrag
#define TQTextDocument QTextDocument
#define TQTextStringChar QTextStringChar
#define TQTextDrag QTextDrag
#define TQTextCursor QTextCursor
#define TQTextEngine QTextEngine
#define TQTextFormat QTextFormat
#define TQTextFormatterBreakInWords QTextFormatterBreakInWords
#define TQTextItem QTextItem
#define TQTextParagraph QTextParagraph
#define TQTextParag QTextParag
#define TQTextPreProcessor QTextPreProcessor
#define TQImageDrag QImageDrag
#define TQUriDrag QUriDrag
#define TQUuid QUuid
#define TQColorDrag QColorDrag
#define TQDropSite QDropSite
#define TQEditorFactory QEditorFactory
#define TQEffects QEffects
#define TQErrorMessage QErrorMessage
#define TQEucJpCodec QEucJpCodec
#define TQEucKrCodec QEucKrCodec
#define TQEvent QEvent
#define TQTimerEvent QTimerEvent
#define TQMouseEvent QMouseEvent
#define TQWheelEvent QWheelEvent
#define TQTabletEvent QTabletEvent
#define TQKeyEvent QKeyEvent
#define TQFeatureListInterface QFeatureListInterface
#define TQFocusEvent QFocusEvent
#define TQPaintEvent QPaintEvent
#define TQMoveEvent QMoveEvent
#define TQResizeEvent QResizeEvent
#define TQRgb QRgb
#define TQCloseEvent QCloseEvent
#define TQIconDragEvent QIconDragEvent
#define TQShowEvent QShowEvent
#define TQHideEvent QHideEvent
#define TQContextMenuEvent QContextMenuEvent
#define TQIMEvent QIMEvent
#define TQIMComposeEvent QIMComposeEvent
#define TQDropEvent QDropEvent
#define TQDragMoveEvent QDragMoveEvent
#define TQDragEnterEvent QDragEnterEvent
#define TQDragResponseEvent QDragResponseEvent
#define TQDragLeaveEvent QDragLeaveEvent
#define TQChildEvent QChildEvent
#define TQCustomEvent QCustomEvent
#define TQEventLoop QEventLoop
#define TQFileIconProvider QFileIconProvider
#define TQFilePreview QFilePreview
#define TQFileDialog QFileDialog
#define TQFile QFile
#define TQFileInfo QFileInfo
#define TQFileInfoList QFileInfoList
#define TQFileInfoListIterator QFileInfoListIterator
#define TQFocusData QFocusData
#define TQFontDatabase QFontDatabase
#define TQFont QFont
#define TQFontDialog QFontDialog
#define TQFontInfo QFontInfo
#define TQFontMetrics QFontMetrics
#define TQFrame QFrame
#define TQFtp QFtp
#define TQGArray QGArray
#define TQGb18030Codec QGb18030Codec
#define TQGbkCodec QGbkCodec
#define TQGb2312Codec QGb2312Codec
#define TQGCache QGCache
#define TQGCacheIterator QGCacheIterator
#define TQBaseBucket QBaseBucket
#define TQStringBucket QStringBucket
#define TQAsciiBucket QAsciiBucket
#define TQIntBucket QIntBucket
#define TQPtrBucket QPtrBucket
#define TQGDict QGDict
#define TQGDictIterator QGDictIterator
#define TQGLColormap QGLColormap
#define TQGL QGL
#define TQGLFormat QGLFormat
#define TQGLContext QGLContext
#define TQGLWidget QGLWidget
#define TQLNode QLNode
#define TQGList QGList
#define TQGListIterator QGListIterator
#define TQGListStdIterator QGListStdIterator
#define TQGPlugin QGPlugin
#define TQGrid QGrid
#define TQGridView QGridView
#define TQGroupBox QGroupBox
#define TQGuardedPtr QGuardedPtr
#define TQGuardedPtrPrivate QGuardedPtrPrivate
#define TQGVector QGVector
#define TQHBox QHBox
#define TQHButtonGroup QHButtonGroup
#define TQHeader QHeader
#define TQHGroupBox QHGroupBox
#define TQHostAddress QHostAddress
#define TQHttpHeader QHttpHeader
#define TQHttpResponseHeader QHttpResponseHeader
#define TQHttpRequestHeader QHttpRequestHeader
#define TQHttp QHttp
#define TQIconSet QIconSet
#define TQIconFactory QIconFactory
#define TQIconDragItem QIconDragItem
#define TQIconDrag QIconDrag
#define TQIconViewItem QIconViewItem
#define TQIconView QIconView
#define TQImageFormatPlugin QImageFormatPlugin
#define TQImageTextKeyLang QImageTextKeyLang
#define TQImage QImage
#define TQImageIO QImageIO
#define TQInputContextFactory QInputContextFactory
#define TQInputContext QInputContext
#define TQInputDialog QInputDialog
#define TQIntCache QIntCache
#define TQIntCacheIterator QIntCacheIterator
#define TQIntDict QIntDict
#define TQIntDictIterator QIntDictIterator
#define TQInterfacePtr QInterfacePtr
#define TQIODevice QIODevice
#define TQJisCodec QJisCodec
#define TQJpUnicodeConv QJpUnicodeConv
#define TQKeySequence QKeySequence
#define TQLabel QLabel
#define TQGLayoutIterator QGLayoutIterator
#define TQLayoutIterator QLayoutIterator
#define TQLayoutItem QLayoutItem
#define TQLayoutStruct QLayoutStruct
#define TQLayoutWidget QLayoutWidget
#define TQSpacerItem QSpacerItem
#define TQWidgetItem QWidgetItem
#define TQLayout QLayout
#define TQGridLayout QGridLayout
#define TQBoxLayout QBoxLayout
#define TQHBoxLayout QHBoxLayout
#define TQVBoxLayout QVBoxLayout
#define TQLCDNumber QLCDNumber
#define TQLibrary QLibrary
#define TQLineEdit QLineEdit
#define TQListBoxItem QListBoxItem
#define TQListBoxText QListBoxText
#define TQListBoxPixmap QListBoxPixmap
#define TQListViewItem QListViewItem
#define TQListView QListView
#define TQCheckListItem QCheckListItem
#define TQListViewItemIterator QListViewItemIterator
#define TQLocale QLocale
#define TQLocalFs QLocalFs
#define TQMainWindow QMainWindow
#define TQMapIterator QMapIterator
#define TQMapConstIterator QMapConstIterator
#define TQMapPrivateBase QMapPrivateBase
#define TQMapPrivate QMapPrivate
#define TQMap QMap
#define TQMemArray QMemArray
#define TQMenuBar QMenuBar
#define TQMenuItem QMenuItem
#define TQCustomMenuItem QCustomMenuItem
#define TQMenuData QMenuData
#define TQMessageBox QMessageBox
#define TQMetaData QMetaData
#define TQMetaProperty QMetaProperty
#define TQMetaObject QMetaObject
#define TQMetaObjectCleanUp QMetaObjectCleanUp
#define TQMimeSource QMimeSource
#define TQMimeSourceFactory QMimeSourceFactory
#define TQWindowsMime QWindowsMime
#define TQMacMime QMacMime
#define TQMotifPlusStyle QMotifPlusStyle
#define TQMotifStyle QMotifStyle
#define TQMovie QMovie
#define TQMultiLineEdit QMultiLineEdit
#define TQMutex QMutex
#define TQMutexLocker QMutexLocker
#define TQt Qt
#define TQInternal QInternal
#define TQNetworkProtocolFactoryBase QNetworkProtocolFactoryBase
#define TQNetworkProtocolFactory QNetworkProtocolFactory
#define TQNetworkProtocol QNetworkProtocol
#define TQNetworkOperation QNetworkOperation
#define TQObjectCleanupHandler QObjectCleanupHandler
#define TQObjectDictionary QObjectDictionary
#define TQObject QObject
#define TQObjectUserData QObjectUserData
#define TQObject QObject
#define TQObjectList QObjectList
#define TQObjectListIterator QObjectListIterator
#define TQObjectListIt QObjectListIt
#define TQPaintDevice QPaintDevice
#define TQPaintDeviceMetrics QPaintDeviceMetrics
#define TQColorGroup QColorGroup
#define TQPair QPair
#define TQPalette QPalette
#define TQPen QPen
#define TQPicture QPicture
#define TQPixmapCache QPixmapCache
#define TQPixmap QPixmap
#define TQPlatinumStyle QPlatinumStyle
#define TQPluginManager QPluginManager
#define TQPNGImageWriter QPNGImageWriter
#define TQPNGImagePacker QPNGImagePacker
#define TQPointArray QPointArray
#define TQPoint QPoint
#define TQPolygonScanner QPolygonScanner
#define TQPopupMenu QPopupMenu
#define TQPrintDialog QPrintDialog
#define TQPrinter QPrinter
#define TQProcess QProcess
#define TQProgressBar QProgressBar
#define TQProgressDialog QProgressDialog
#define TQPtrCollection QPtrCollection
#define TQPtrDict QPtrDict
#define TQPtrDictIterator QPtrDictIterator
#define TQPtrListStdIterator QPtrListStdIterator
#define TQPtrList QPtrList
#define TQPtrListIterator QPtrListIterator
#define TQPtrQueue QPtrQueue
#define TQPtrStack QPtrStack
#define TQPtrVector QPtrVector
#define TQPushButton QPushButton
#define TQRadioButton QRadioButton
#define TQRangeControl QRangeControl
#define TQSpinWidget QSpinWidget
#define TQRect QRect
#define TQRegExp QRegExp
#define TQRegion QRegion
#define TQHebrewCodec QHebrewCodec
#define TQScrollBar QScrollBar
#define TQScrollView QScrollView
#define TQSemaphore QSemaphore
#define TQSemiModal QSemiModal
#define TQServerSocket QServerSocket
#define TQSettings QSettings
#define TQSGIStyle QSGIStyle
#define TQSignal QSignal
#define TQSignalMapper QSignalMapper
#define TQConnectionList QConnectionList
#define TQConnectionListIt QConnectionListIt
#define TQSignalVec QSignalVec
#define TQSimpleRichText QSimpleRichText
#define TQSizeGrip QSizeGrip
#define TQSize QSize
#define TQSizePolicy QSizePolicy
#define TQSjisCodec QSjisCodec
#define TQSlider QSlider
#define TQSocketDevice QSocketDevice
#define TQSocket QSocket
#define TQSocketNotifier QSocketNotifier
#define TQSortedList QSortedList
#define TQSound QSound
#define TQSpinBox QSpinBox
#define TQSplashScreen QSplashScreen
#define TQSplitter QSplitter
#define TQSplitterHandle QSplitterHandle
#define TQSplitterLayoutStruct QSplitterLayoutStruct
#define TQSqlCursor QSqlCursor
#define TQSqlDatabase QSqlDatabase
#define TQSqlDriver QSqlDriver
#define TQSqlDriverPlugin QSqlDriverPlugin
#define TQSqlEditorFactory QSqlEditorFactory
#define TQSqlError QSqlError
#define TQSqlFieldPrivate QSqlFieldPrivate
#define TQSqlField QSqlField
#define TQSqlFieldInfo QSqlFieldInfo
#define TQSql QSql
#define TQSqlIndex QSqlIndex
#define TQSqlQuery QSqlQuery
#define TQSqlResultShared QSqlResultShared
#define TQSqlRecordShared QSqlRecordShared
#define TQSqlRecord QSqlRecord
#define TQSqlRecordInfo QSqlRecordInfo
#define TQSqlResult QSqlResult
#define TQSqlSelectCursorPrivate QSqlSelectCursorPrivate
#define TQSqlSelectCursor QSqlSelectCursor
#define TQStatusBar QStatusBar
#define TQChar QChar
#define TQCharAttributes QCharAttributes
#define TQString QString
#define TQCharRef QCharRef
#define TQConstString QConstString
#define TQStringList QStringList
#define TQStrListIterator QStrListIterator
#define TQStrIList QStrIList
#define TQStrList QStrList
#define TQStrVec QStrVec
#define TQStrIVec QStrIVec
#define TQStyleFactory QStyleFactory
#define TQStyleOption QStyleOption
#define TQStyle QStyle
#define TQStyleHintReturn QStyleHintReturn
#define TQStylePlugin QStylePlugin
#define TQStyleSheetItem QStyleSheetItem
#define TQStyleSheet QStyleSheet
#define TQSyntaxHighlighter QSyntaxHighlighter
#define TQTab QTab
#define TQTabBar QTabBar
#define TQTabDialog QTabDialog
#define TQTableSelection QTableSelection
#define TQTableItem QTableItem
#define TQCheckTableItem QCheckTableItem
#define TQTable QTable
#define TQTabWidget QTabWidget
#define TQTextBrowser QTextBrowser
#define TQTextCodecFactory QTextCodecFactory
#define TQTextEncoder QTextEncoder
#define TQTextDecoder QTextDecoder
#define TQTextCodec QTextCodec
#define TQTextCodecPlugin QTextCodecPlugin
#define TQTextEdit QTextEdit
#define TQTextStream QTextStream
#define TQTextIStream QTextIStream
#define TQTextOStream QTextOStream
#define TQTSManip QTSManip
#define TQTextView QTextView
#define TQThread QThread
#define TQThreadStorageData QThreadStorageData
#define TQThreadStorage QThreadStorage
#define TQTimer QTimer
#define TQTextOStreamIterator QTextOStreamIterator
#define TQBackInsertIterator QBackInsertIterator
#define TQtMsgType QtMsgType
#define TQtMsgHandler QtMsgHandler
#define TQToolBar QToolBar
#define TQToolBox QToolBox
#define TQToolButton QToolButton
#define TQToolTipGroup QToolTipGroup
#define TQToolTip QToolTip
#define TQTranslator QTranslator
#define TQTranslatorMessage QTranslatorMessage
#define TQTsciiCodec QTsciiCodec
#define TQUrl QUrl
#define TQUrlInfo QUrlInfo
#define TQUrlOperator QUrlOperator
#define TQUtf8Codec QUtf8Codec
#define TQUtf16Codec QUtf16Codec
#define TQValidator QValidator
#define TQIntValidator QIntValidator
#define TQDoubleValidator QDoubleValidator
#define TQRegExpValidator QRegExpValidator
#define TQValueListNode QValueListNode
#define TQValueListIterator QValueListIterator
#define TQValueListConstIterator QValueListConstIterator
#define TQValueListPrivate QValueListPrivate
#define TQValueList QValueList
#define TQValueStack QValueStack
#define TQValueVectorPrivate QValueVectorPrivate
#define TQValueVector QValueVector
#define TQVariant QVariant
#define TQVBox QVBox
#define TQVButtonGroup QVButtonGroup
#define TQVGroupBox QVGroupBox
#define TQWaitCondition QWaitCondition
#define TQWhatsThis QWhatsThis
#define TQWidgetFactory QWidgetFactory
#define TQWidgetFactoryInterface QWidgetFactoryInterface
#define TQWidget QWidget
#define TQWidgetIntDict QWidgetIntDict
#define TQWidgetIntDictIt QWidgetIntDictIt
#define TQWidgetList QWidgetList
#define TQWidgetListIt QWidgetListIt
#define TQWidgetPlugin QWidgetPlugin
#define TQWidgetContainerPlugin QWidgetContainerPlugin
#define TQWidgetStack QWidgetStack
#define TQWidgetStackAccelManager QWidgetStackAccelManager
#define TQWindowsStyle QWindowsStyle
#define TQWizard QWizard
#define TQWMatrix QWMatrix
#define TQWorkspace QWorkspace
#define TQXEmbed QXEmbed
#define TQXmlNamespaceSupport QXmlNamespaceSupport
#define TQXmlAttributes QXmlAttributes
#define TQXmlInputSource QXmlInputSource
#define TQXmlParseException QXmlParseException
#define TQXmlReader QXmlReader
#define TQXmlSimpleReader QXmlSimpleReader
#define TQXmlLocator QXmlLocator
#define TQXmlContentHandler QXmlContentHandler
#define TQXmlErrorHandler QXmlErrorHandler
#define TQXmlDTDHandler QXmlDTDHandler
#define TQXmlEntityResolver QXmlEntityResolver
#define TQXmlLexicalHandler QXmlLexicalHandler
#define TQXmlDeclHandler QXmlDeclHandler
#define TQXmlDefaultHandler QXmlDefaultHandler
#define TQUnknownInterface QUnknownInterface

#define tqRound	qRound
#define tqstrlen	qstrlen
#define tqstrncmp	qstrncmp
#define tqUncompress	qUncompress
#define tqCopy	qCopy
#define tqEqual	qEqual
#define tqFill	qFill
#define tqFind	qFind
#define tqCount	qCount
#define tqSwap	qSwap
#define tqSystemWarning	qSystemWarning
#define tqSuppressObsoleteWarnings	qSuppressObsoleteWarnings

#define tqmoc	moc
#define TQMOC	MOC
#define TQRGB_MASK	RGB_MASK

#define WPaintOnScreen	((WFlags)0)

#define TQ_INT8		Q_INT8
#define TQ_INT16	Q_INT16
#define TQ_INT32	Q_INT32
#define TQ_INT64	Q_INT64
#define TQ_UINT8	Q_UINT8
#define TQ_UINT16	Q_UINT16
#define TQ_UINT32	Q_UINT32
#define TQ_UINT64	Q_UINT64

#define TQ_LONG		Q_LONG
#define TQ_LLONG	Q_LLONG
#define TQ_ULONG	Q_ULONG
#define TQ_ULLONG	Q_ULLONG

#define tqRed	qRed
#define tqGreen	qGreen
#define tqBlue	qBlue
#define tqAlpha	qAlpha
#define tqRgb	qRgb
#define tqRgba	qRgba
#define tqGray	qGray
#define tqCompress	qCompress
#define tqInstallMsgHandler	qInstallMsgHandler
#define tqchildAt	childAt
#define tqchildrenRect	childrenRect
#define tqchildrenRegion	childrenRegion
#define tqAppName	qAppName
#define tqApp	qApp

#define tqCursorShape	CursorShape
#define tqshape	shape
#define tqStatus	Status
#define resetqStatus	resetStatus
#define tqmetaObject	metaObject
#define tqfind	find
#define tqchildren	children
#define tqfindWidget	findWidget
#define tqfindFirstVisibleItem	findFirstVisibleItem
#define tqfindLastVisibleItem	findLastVisibleItem
#define tqsetObjectName	setObjectName
#define tqsetBackgroundPixmap	setBackgroundPixmap
#define tqsetWhatsThis	setWhatsThis
#define tqtopLevelWidget	topLevelWidget
#define tqparent	parent
#define tqmask	mask
#define tqfocusWidget	focusWidget
#define tqcontains	contains
#define tqunicode	unicode
#define tqunicodeUriToUri	unicodeUriToUri
#define tqreplace	replace
#define tqsignals	signals
#define tqslots	slots
#define tqworldMatrix	worldMatrix
#define tqsizeHint	sizeHint
#define tqminimumSize	minimumSize
#define tqmaximumSize	maximumSize
#define tqgeometry	geometry
#define tqspacerItem	spacerItem
#define tqlayout	layout
#define tqsetAlignment	setAlignment
#define tqinvalidate	invalidate
#define tqalignment	alignment
#define tqdevice	device
#define tqfromLatin1	fromLatin1
#define tqreceivers	receivers
#define tqencodedData	encodedData
#define tqcurrentDate	currentDate
#define tqstyleHint	styleHint
#define tqitemRect	itemRect
#define tqvisualRect	visualRect
#define tqdrawControl	drawControl
#define tqdrawPolygon	drawPolygon
#define tqsetSizePolicy	setSizePolicy
#define tqpixelMetric	pixelMetric
#define tqdrawComplexControl	drawComplexControl
#define tqrepaint	repaint
#define tqcolorGroup	colorGroup
#define tqdrawTextItem	drawTextItem
#define tqsetLibraryPaths	setLibraryPaths
#define tqsetColorGroup	setColorGroup
#define tqfindRev	findRev
#define tqfindProperty	findProperty
#define tqfindSlot	findSlot
#define tqcurrentDateTime	currentDateTime
#define tqfindItem	findItem
#define tqtopLevelWidgets	topLevelWidgets
#define tqcontainsRef	containsRef
#define tqfindIndex	findIndex
#define tqfindRef	findRef
#define tqminimumSizeHint	minimumSizeHint
#define tqmaximumSizeHint	maximumSizeHint
#define tqreplaceChild	replaceChild
#define tqfindSignal	findSignal
#define settqStatus	setStatus
#define tqfindNextRef	findNextRef
#define connecttqStatus	connectStatus
#define disconnecttqStatus	disconnectStatus
#define tqreplacement	replacement
#define tqsuperClass	superClass
#define tqinvertPixels	invertPixels
#define setqStatus	setStatus
#define tqsuperClassName	superClassName
#define tqclipboard	clipboard
#define tqfamilies	families
#define tqstartsWith	startsWith
#define tqrects	rects
#define tqsetFont	setFont
#define tqsetPalette	setPalette
#define tqpalette	palette
#define tqstyle		style
#define tqstyles	styles
#define tqsizePolicy	sizePolicy
#define tqsmoothSizes	smoothSizes
#define tqstandardSizes	standardSizes
#define tqresize	resize
#define tqstaticMetaObject	staticMetaObject
#define tqopen	open
#define tqtext	text
#define tqdrawPolyline	drawPolyline
#define tqbrush	brush
#define tqat	at
#define tqresizeMode	resizeMode
#define connectqStatus	connectStatus
#define disconnectqStatus	disconnectStatus
#define tqendsWith	endsWith
#define tqdrawConvexPolygon	drawConvexPolygon
#define tqallWidgets	allWidgets
#define tqcapturedTexts	capturedTexts
#define tqarg	arg
#define tqbegin	begin
#define tqdrawPixmap	drawPixmap
#define tqscale	scale
#define exitqStatus	exitStatus
#define tqsetNum	setNum
#define tqprocessEvents	processEvents
#define tqsetBufferFromCopy	setBuffer
#define tqsetVisible	setVisible
#define tqsetUpdatesEnabled	setUpdatesEnabled
#define tqfindExtension	findExtension
#define tqfindHistory	findHistory
#define tqfindNext	findNext
#define tqfindPrev	findPrev
#define tqfindByPath	findByPath
#define tqfindObject	findObject
#define tqfindServiceFor	findServiceFor
#define tqfindByUid findByUid
#define tqfindByEmail findByEmail
#define tqfindByContent findByContent
#define tqfindByFileContent findByFileContent
#define slavetqStatus slaveStatus
#define tqfindText findText
#define tqfindTextNext findTextNext
#define tqfindBufferType findBufferType
#define spelltqStatus spellStatus
#define tqreplacedPath replacedPath
#define tqfindFileType findFileType
#define tqtextList textList
#define expandingDirections expanding
#define tqpointSizes pointSizes

#define tqdrawPrimitive			drawPrimitive
#define tqdrawControlMask		drawControlMask
#define tqsizeFromContents		sizeFromContents
#define tqdrawComplexControlMask	drawComplexControlMask

#define TQCOORD		QCOORD
#define TQCOORD_MAX	QCOORD_MAX
#define TQ_SETS		Q_SETS
#define TQ_PROPERTY	Q_PROPERTY
#define TQMIN		QMIN
#define TQMAX		QMAX
#define TQABS		QABS
#define tqMakePair	qMakePair
#define qt_tqfind_obj_child	qt_find_obj_child
#define tqt_ucm_query_verification_data	qt_ucm_query_verification_data
#define tqmemmove	qmemmove

#define TQ_ControlElement	ControlElement
#define TQ_ComplexControl	ComplexControl

#define TQUObject		QUObject
#define static_TQUType_int	static_QUType_int
#define static_TQUType_TQString	static_QUType_QString
#define static_TQUType_ptr	static_QUType_ptr
#define static_TQUType_bool	static_QUType_bool
#define static_TQUType_varptr	static_QUType_varptr
#define static_TQUType_charstar	static_QUType_charstar

#define TQ_EXTERN_C		Q_EXTERN_C
#define TQ_EXPORT_PLUGIN	Q_EXPORT_PLUGIN
#define TQ_EXPORT		Q_EXPORT

#define tqreadBlock		readBlock
#define tqwriteBlock		writeBlock
#define TQT_TQIO_LONG		TQ_LONG
#define TQT_TQIO_ULONG		TQ_ULONG

#define tqt_mo_access access
#define tqt_mo_ci_name name
#define tqt_mo_ci_value value
#define tqt_mo_ci_count count
#define tqt_mo_ci_items items
#define tqt_mo_ci_method method

/* BEGIN BLOCK ONE
   This block of text is taken (mostly) straight from TQt for Qt4 tqtglobaldefines.h
   It will need to be updated now and then as TQt for Qt4 changes */

#define TQT_TQOBJECT(x) (static_cast<TQObject*>(static_cast<QObject*>(x)))
#define TQT_TQWIDGET(x) (static_cast<TQWidget*>(static_cast<QWidget*>(x)))
#define TQT_TQSIZEPOLICY(x) (static_cast<TQSizePolicy*>(static_cast<QSizePolicy*>(x)))
#define TQT_TQLAYOUT(x) (static_cast<TQLayout*>(static_cast<QLayout*>(x)))
#define TQT_TQGRIDLAYOUT(x) (static_cast<TQGridLayout*>(static_cast<QGridLayout*>(x)))
#define TQT_TQPAINTER(x) (static_cast<TQPainter*>(static_cast<QPainter*>(x)))
#define TQT_TQPAINTDEVICE(x) (static_cast<TQPaintDevice*>(static_cast<QPaintDevice*>(x)))
#define TQT_TQLAYOUTITEM(x) (static_cast<TQLayoutItem*>(static_cast<QLayoutItem*>(x)))
#define TQT_TQIODEVICE(x) (static_cast<TQIODevice*>(static_cast<QIODevice*>(x)))
#define TQT_TQCOLOR(x) (static_cast<TQColor*>(static_cast<QColor*>(x)))
#define TQT_TQCHAR(x) TQChar(x)
#define TQT_TQSTRING(x) TQString(x)
#define TQT_TQBUFFER(x) (static_cast<TQBuffer*>(static_cast<QBuffer*>(x)))
#define TQT_TQWMATRIX(x) (static_cast<TQWMatrix*>(static_cast<QMatrix*>(x)))
#define TQT_TQFILE(x) (static_cast<TQFile*>(static_cast<QFile*>(x)))
#define TQT_TQBYTEARRAY(x) (static_cast<TQByteArray*>(static_cast<QByteArray*>(x)))
#define TQT_TQMIMESOURCE(x) (static_cast<TQMimeSource*>(static_cast<QMimeSource*>(x)))
#define TQT_TQWEXTRA(x) (static_cast<TQWExtra*>(static_cast<QWExtra*>(x)))
#define TQT_TQPIXMAP(x) (static_cast<TQPixmap*>(static_cast<QPixmap*>(x)))
#define TQT_TQCLIPBOARD(x) (static_cast<TQClipboard*>(static_cast<QClipboard*>(x)))
#define TQT_TQPRINTER(x) (static_cast<TQPrinter*>(static_cast<QPrinter*>(x)))
#define TQT_TQVARIANT(x) (static_cast<TQVariant*>(static_cast<QVariant*>(x)))
#define TQT_TQMETAOBJECT(x) (static_cast<TQMetaObject*>(static_cast<QMetaObject*>(x)))
#define TQT_TQSTYLEOPTION(x) (static_cast<TQStyleOption*>(static_cast<TQStyleOption*>(x)))
#define TQT_TQEVENT(x) (static_cast<TQEvent*>(static_cast<QEvent*>(x)))
#define TQT_TQKEYEVENT(x) (static_cast<TQKeyEvent*>(static_cast<QKeyEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQMOVEEVENT(x) (static_cast<TQMoveEvent*>(static_cast<QMoveEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQSHOWEVENT(x) (static_cast<TQShowEvent*>(static_cast<QShowEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQMOUSEEVENT(x) (static_cast<TQMouseEvent*>(static_cast<QMouseEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQWHEELEVENT(x) (static_cast<TQWheelEvent*>(static_cast<QWheelEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQFOCUSEVENT(x) (static_cast<TQFocusEvent*>(static_cast<QFocusEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQPAINTEVENT(x) (static_cast<TQPaintEvent*>(static_cast<QPaintEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQCHILDEVENT(x) (static_cast<TQChildEvent*>(static_cast<QChildEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQCLOSEEVENT(x) (static_cast<TQCloseEvent*>(static_cast<QCloseEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQTIMEREVENT(x) (static_cast<TQTimerEvent*>(static_cast<QTimerEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQRESIZEEVENT(x) (static_cast<TQResizeEvent*>(static_cast<QResizeEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQTABLETEVENT(x) (static_cast<TQTabletEvent*>(static_cast<QTabletEvent*>(static_cast<QEvent*>(x))))
#define TQT_TQCONTEXTMENUEVENT(x) (static_cast<TQContextMenuEvent*>(static_cast<QContextMenuEvent*>(static_cast<QEvent*>(x))))

#define TQT_TQOBJECT_OBJECT(x) x
#define TQT_TQSIZEPOLICY_OBJECT(x) x
#define TQT_TQLAYOUT_OBJECT(x) x
#define TQT_TQCOLOR_OBJECT(x) x
#define TQT_TQSTRING_OBJECT(x) x
#define TQT_TQSTRLIST_OBJECT(x) x
#define TQT_TQSTRINGLIST_OBJECT(x) x
#define TQT_TQWMATRIX_OBJECT(x) x
#define TQT_TQRECT_OBJECT(x) x
#define TQT_TQBYTEARRAY_OBJECT(x) x
#define TQT_TQPIXMAP_OBJECT(x) x
#define TQT_TQTIME_OBJECT(x) x
#define TQT_TQDATE_OBJECT(x) x
#define TQT_TQDATETIME_OBJECT(x) x
#define TQT_TQBRUSH_OBJECT(x) x
#define TQT_TQPALETTE_OBJECT(x) x
#define TQT_TQPOINT_OBJECT(x) x
#define TQT_TQREGION_OBJECT(x) x
#define TQT_TQIMAGE_OBJECT(x) x
#define TQT_TQPAINTDEVICE_OBJECT(x) x
#define TQT_TQVARIANT_OBJECT(x) x
#define TQT_TQIODEVICE_OBJECT(x) x
#define TQT_TQSTYLEOPTION_OBJECT(x) x

#define TQT_TQOBJECT_CONST(x) (static_cast<const TQObject*>(static_cast<const TQObject*>(x)))
#define TQT_TQWIDGET_CONST(x) (static_cast<const TQWidget*>(static_cast<const QWidget*>(x)))
#define TQT_TQMIMESOURCE_CONST(x) (static_cast<const TQMimeSource*>(static_cast<const QMimeSource*>(x)))
#define TQT_TQBRUSH_CONST(x) (static_cast<const TQBrush*>(static_cast<const QBrush*>(x)))
#define TQT_TQPIXMAP_CONST(x) (static_cast<const TQPixmap*>(static_cast<const QPixmap*>(x)))
#define TQT_TQPAINTDEVICE_CONST(x) (static_cast<const TQPaintDevice*>(static_cast<const QPaintDevice*>(x)))
#define TQT_TQCOLOR_CONST(x) (static_cast<const TQColor*>(static_cast<const QColor*>(x)))
#define TQT_TQPRINTER_CONST(x) (static_cast<const TQPrinter*>(static_cast<const QPrinter*>(x)))
#define TQT_TQIODEVICE_CONST(x) (static_cast<const TQIODevice*>(static_cast<const QIODevice*>(x)))
#define TQT_TQVARIANT_CONST(x) (static_cast<const TQVariant*>(static_cast<const QVariant*>(x)))
#define TQT_TQMETAOBJECT_CONST(x) (static_cast<const TQMetaObject*>(static_cast<const QMetaObject*>(x)))
#define TQT_TQSTYLEOPTION_CONST(x) (static_cast<const TQStyleOption*>(static_cast<const TQStyleOption*>(x)))

#define TQT_BASE_OBJECT_NAME QObject
#define TQT_BASE_OBJECT(x) (static_cast<TQT_BASE_OBJECT_NAME*>(x))
#define TQT_BASE_OBJECT_CONST(x) (static_cast<const TQT_BASE_OBJECT_NAME*>(x))

#define setTqmaximumSize	setMaximumSize
#define setTqminimumSize	setMinimumSize
#define setTqalignment		tqsetAlignment
#define setTqgeometry		setGeometry

/* END BLOCK ONE */

#define tqarrowCursor		Qt::arrowCursor
#define tqupArrowCursor		Qt::upArrowCursor
#define tqcrossCursor		Qt::crossCursor
#define tqwaitCursor		Qt::waitCursor
#define tqibeamCursor		Qt::ibeamCursor
#define tqsizeVerCursor		Qt::sizeVerCursor
#define tqsizeHorCursor		Qt::sizeHorCursor
#define tqsizeBDiagCursor	Qt::sizeBDiagCursor
#define tqsizeFDiagCursor	Qt::sizeFDiagCursor
#define tqsizeAllCursor		Qt::sizeAllCursor
#define tqblankCursor		Qt::blankCursor
#define tqsplitVCursor		Qt::splitVCursor
#define tqsplitHCursor		Qt::splitHCursor
#define tqpointingHandCursor	Qt::pointingHandCursor
#define tqforbiddenCursor	Qt::forbiddenCursor
#define tqwhatsThisCursor	Qt::whatsThisCursor
#define tqbusyCursor		Qt::busyCursor

#define SET_QT_X_TIME(x)	set_tqt_x_time(x)
#define GET_QT_X_TIME(x)	get_tqt_x_time()
#define SET_QT_X_USER_TIME(x)	set_tqt_x_time(x)
#define GET_QT_X_USER_TIME(x)	get_tqt_x_time()

#endif /* USE_QT3 */

#ifdef USE_QT4

#define TQT_QT_STRING_LIST_TYPE TQStrList

#ifdef __cplusplus
class TQT_QT_STRING_LIST_TYPE;
class QUObject;

#include <tqt4/Qt/qglobal.h>
#include <tqt4/Qt/qchar.h>
#include <tqt4/Qt/qnamespace.h>
#include <tqt4/Qt/qobjectdefs.h>
#include <tqt4/Qt/qlist.h>
#include <tqt4/Qt/qbytearray.h>
#include <tqt4/Qt/qstring.h>
#include <tqt4/Qt/qobject.h>
#include <tqucomextra_p.h>
#define QT_NO_QOBJECT
#include <tqt4/Qt/qiodevice.h>
#undef QT_NO_QOBJECT
#include <tqt4/Qt/qdatastream.h>
#include <tqt4/Qt/qvariant.h>
#include <tqt4/Qt/qmetaobject.h>
#include <tqeventloop.h>
#include <tqt4/Qt/qpaintdevice.h>
#include <tqt4/Qt/qvector.h>
#include <tqt4/Qt/qimage.h>
#include <tqt4/Qt/qpixmap.h>
#include <tqt4/Qt/qwidget.h>
#include <tqt4/Qt/q3painter.h>
#include <tqt4/Qt/qicon.h>
#include <tqt4/Qt/qstyle.h>
#include <tqt4/Qt/qtabbar.h>
#include <tqt4/Qt/qstyleoption.h>
#include <tqt4/Qt/qcommonstyle.h>
#include <tqt4/Qt/qapplication.h>
#include <tqt4/Qt/q3cstring.h>
#include <tqt4/Qt/q3pointarray.h>
#include <tqt4/Qt/qslider.h>
#include <tqt4/Qt/qscrollbar.h>
#include <tqt4/Qt/qfileinfo.h>
#include <tqt4/Qt/qmenu.h>
#include <tqt4/Qt/q3popupmenu.h>
#include <tqt4/Qt/qmenudata.h>
#include <tqt4/Qt/qdir.h>
#include <tqt4/Qt/qtooltip.h>
#include <tqt4/Qt/qmovie.h>
#include <tqt4/Qt/q3whatsthis.h>
#include <tqt4/Qt/qtextcodec.h>

#include <Qt/q3strlist.h>
#include <Qt/qx11info_x11.h>

#include <Qt/q3combobox.h>
#include <Qt/q3groupbox.h>
#include <Qt/q3progressbar.h>
#include <Qt/q3textstream.h>
#include <Qt/q3valuelist.h>
#include <Qt/q3url.h>
#include <Qt/qdesktopwidget.h>
#include <Qt/qevent.h>

#include <tqlistiterator.h>

#include <tqstringlist.h>
#endif /* __cplusplus */

#define tqchildren		ptrchildren
#define tqaccess		access()
#define tqcolorTable		ptrColorTable
#define tqmask			ptrmask
#define TQSO_Default		SO_Default
#define tqqt_cast		qobject_cast
#define TQ_Horizontal		Qt::Horizontal
#define TQ_Vertical		Qt::Vertical
#define TQImage_ScaleFree	Qt::ScaleFree
#define TQ_Key_Shift		Qt::Key_Shift
#define TQ_Key_Control		Qt::Key_Control
#define TQ_Key_Alt		Qt::Key_Alt
#define TQ_Key_Meta		Qt::Key_Meta
#define TQ_Key_Super_L		Qt::Key_Super_L
#define TQ_Key_Super_R		Qt::Key_Super_R
#define TQ_Key_Hyper_L		Qt::Key_Hyper_L
#define TQ_Key_Hyper_R		Qt::Key_Hyper_R
#define TQ_ButtonState		ButtonState
#define TQ_LeftButton		Qt::LeftButton
#define TQ_MidButton		Qt::MidButton
#define TQ_RightButton		Qt::RightButton
#define TQ_ShiftButton		Qt::ShiftButton
#define TQ_ControlButton	Qt::ControlButton
#define TQ_AltButton		Qt::AltButton
#define TQ_MetaButton		Qt::MetaButton
#define TQIODevice_OpenModeFlag QIODevice::OpenModeFlag

#define TQAlignCenter Qt::AlignCenter
#define TQNoBrush Qt::NoBrush

#define QMetaData QMetaMethod
#define qt_xdisplay QX11Info::display
#define qt_xrootwin QX11Info::appRootWindow
#define qt_xscreen QX11Info::appScreen
#define qt_xget_temp_gc QPaintDevice::qt_xget_temp_gc
#define TickSetting TickPosition
#define ButtonState Qt::ButtonState
#define qHeapSort tqHeapSort

#define ColorOnly Qt::ColorOnly
#define MonoOnly Qt::MonoOnly
#define ColorMode_Mask Qt::ColorMode_Mask

#define tqred Qt::red
#define tqgreen Qt::green
#define tqblue Qt::blue
#define tqcyan Qt::cyan
#define tqmagenta Qt::magenta
#define tqyellow Qt::yellow
#define tqdarkRed Qt::darkRed
#define tqdarkGreen Qt::darkGreen
#define tqdarkBlue Qt::darkBlue
#define tqdarkCyan Qt::darkCyan
#define tqdarkMagenta Qt::darkMagenta
#define tqdarkYellow Qt::darkYellow
#define tqwhite Qt::white
#define tqlightGray Qt::lightGray
#define tqgray Qt::gray
#define tqdarkGray Qt::darkGray
#define tqblack Qt::black
#define tqcolor0 Qt::color0
#define tqcolor1 Qt::color1

#define tqblackptr &tqblackptr_core

#define SubRect			SubElement
#define SR_PushButtonContents	SE_PushButtonContents
#define SR_PushButtonFocusRect	SE_PushButtonFocusRect
#define SR_CheckBoxIndicator	SE_CheckBoxIndicator
#define SR_CheckBoxContents	SE_CheckBoxContents
#define SR_CheckBoxFocusRect	SE_CheckBoxFocusRect
#define SR_RadioButtonIndicator	SE_RadioButtonIndicator
#define SR_RadioButtonContents	SE_RadioButtonContents
#define SR_RadioButtonFocusRect	SE_RadioButtonFocusRect
#define SR_ComboBoxFocusRect	SE_ComboBoxFocusRect
#define SR_SliderFocusRect	SE_SliderFocusRect
#define SR_DockWindowHandleRect	SE_DockWindowHandleRect
#define SR_ProgressBarGroove	SE_ProgressBarGroove
#define SR_ProgressBarContents	SE_ProgressBarContents
#define SR_ProgressBarLabel	SE_ProgressBarLabel
#define SR_ToolButtonContents	SE_ToolButtonContents
#define SR_DialogButtonAccept	SE_DialogButtonAccept
#define SR_DialogButtonReject	SE_DialogButtonReject
#define SR_DialogButtonApply	SE_DialogButtonApply
#define SR_DialogButtonHelp	SE_DialogButtonHelp
#define SR_DialogButtonAll	SE_DialogButtonAll
#define SR_DialogButtonAbort	SE_DialogButtonAbort
#define SR_DialogButtonIgnore	SE_DialogButtonIgnore
#define SR_DialogButtonRetry	SE_DialogButtonRetry
#define SR_DialogButtonCustom	SE_DialogButtonCustom
#define SR_ToolBoxTabContents	SE_ToolBoxTabContents
#define SR_CustomBase		SE_CustomBase

#define StylePixmap			StandardPixmap
#define SP_DockWindowCloseButton	SP_DockWidgetCloseButton

#define StyleFlags		StateFlags
#define Style_Default		QStyle::State_Default
#define Style_Enabled		QStyle::State_Enabled
#define Style_Raised		QStyle::State_Raised
#define Style_Sunken		QStyle::State_Sunken
#define Style_Off		QStyle::State_Off
#define Style_NoChange		QStyle::State_NoChange
#define Style_On		QStyle::State_On
#define Style_Down		QStyle::State_DownArrow
#define Style_Horizontal	QStyle::State_Horizontal
#define Style_HasFocus		QStyle::State_HasFocus
#define Style_To		QStyle::State_To
#define Style_Bottom		QStyle::State_Bottom
#define Style_FocusAtBorder	QStyle::State_FocusAtBorder
#define Style_AutoRaise		QStyle::State_AutoRaise
#define Style_MouseOver		QStyle::State_MouseOver
#define Style_Up		QStyle::State_UpArrow
#define Style_Selected		QStyle::State_Selected
#define Style_Active		QStyle::State_Active
#define Style_ButtonDefault	QStyle::State_ButtonDefault

#define PE_ArrowDown		PE_IndicatorArrowDown
#define PE_ArrowUp		PE_IndicatorArrowUp
#define PE_ButtonTool		PE_PanelButtonTool
#define	PE_DockWindowHandle	PE_IndicatorToolBarHandle
#define PE_DockWindowSeparator	PE_Q3DockWindowSeparator

#define PE_FocusRect		PE_FrameFocusRect
#define PE_Panel		PE_Frame
#define PE_RubberBand		CE_RubberBand
#define PE_ScrollBarAddLine	CE_ScrollBarAddLine
#define PE_ScrollBarAddPage	CE_ScrollBarAddPage
#define PE_ScrollBarFirst	CE_ScrollBarFirst
#define PE_ScrollBarLast	CE_ScrollBarLast
#define PE_ScrollBarSlider	CE_ScrollBarSlider
#define PE_ScrollBarSubLine	CE_ScrollBarSubLine
#define PE_ScrollBarSubPage	CE_ScrollBarSubPage

#define SC_ListView		SC_Q3ListView
#define SC_ListViewBranch	SC_Q3ListViewBranch
#define SC_ListViewExpand	SC_Q3ListViewExpand

#define CC_ListView		CC_Q3ListView

#define WState			Qt::WidgetAttribute
#define	WState_Polished		Qt::WA_WState_Polished
#define WState_ForceHide	Qt::WA_WState_Hidden

#define WStyle_Customize	Qt::WStyle_Customize
#define WType_Popup		Qt::WType_Popup
#define WX11BypassWM		Qt::WX11BypassWM

#define SH_PopupMenu_Scrollable			SH_Menu_Scrollable
#define SH_PopupMenu_SloppySubMenus		SH_Menu_SloppySubMenus
#define SH_PopupMenu_SubMenuPopupDelay		SH_Menu_SubMenuPopupDelay
#define SH_PopupMenu_AllowActiveAndDisabled	SH_Menu_AllowActiveAndDisabled
#define SH_PopupMenu_MouseTracking		SH_Menu_MouseTracking

#define	CE_PopupMenuScroller			CE_MenuScroller

#define PM_DockWindowHandleExtent		PM_DockWidgetHandleExtent
#define PM_MenuBarFrameWidth			PM_ToolBarFrameWidth
#define PM_DockWindowFrameWidth			PM_DockWidgetFrameWidth
#define PM_PopupMenuScrollerHeight		PM_MenuScrollerHeight

#define TQAccel Q3Accel
#define TQAccessible QAccessible
#define TQAccessibleObject QAccessibleObject
#define TQAction Q3Action
#define TQActionGroup Q3ActionGroup
#define TQApplication QApplication
#define TQAsciiCache Q3AsciiCache
#define TQAsciiCacheIterator Q3AsciiCacheIterator
#define TQAsciiDict Q3AsciiDict
#define TQAsciiDictIterator Q3AsciiDictIterator
#define TQImageConsumer QImageConsumer
#define TQImageFormat QImageFormat
#define TQImageFormatType QImageFormatType
#define TQImageDecoder QImageDecoder
#define TQAsyncIO QAsyncIO
#define TQByteArray QByteArray
#define TQDataSink QDataSink
#define TQDataSource QDataSource
#define TQIODeviceSource QIODeviceSource
#define TQDataPump QDataPump
#define TQBig5Codec QBig5Codec
#define TQBig5hkscsCodec QBig5hkscsCodec
#define TQBitVal QBitVal
#define TQBitArray QBitArray
#define TQBitmap QBitmap
#define TQBrush QBrush
#define TQBuffer QBuffer
#define TQButtonGroup Q3ButtonGroup
#define TQButton Q3Button
#define TQCache Q3Cache
#define TQCacheIterator Q3CacheIterator
#define TQCanvasChunk Q3CanvasChunk
#define TQCanvasItemList Q3CanvasItemList
#define TQCanvasItemExtra Q3CanvasItemExtra
#define TQCanvasItem Q3CanvasItem
#define TQCanvasData Q3CanvasData
#define TQCanvas Q3Canvas
#define TQCanvasViewData Q3CanvasViewData
#define TQCanvasView Q3CanvasView
#define TQCanvasPixmap Q3CanvasPixmap
#define TQCanvasPixmapArray Q3CanvasPixmapArray
#define TQCanvasSprite Q3CanvasSprite
#define TQPolygonalProcessor QPolygonalProcessor
#define TQCanvasPolygonalItem Q3CanvasPolygonalItem
#define TQCanvasRectangle Q3CanvasRectangle
#define TQCanvasPolygon Q3CanvasPolygon
#define TQCanvasSpline Q3CanvasSpline
#define TQCanvasLine Q3CanvasLine
#define TQCanvasEllipse Q3CanvasEllipse
#define TQCanvasTextExtra Q3CanvasTextExtra
#define TQCanvasText Q3CanvasText
#define TQCDEStyle QCDEStyle
#define TQCheckBox QCheckBox
#define TQShared Q3Shared
#define TQColor QColor
#define TQColorDialog QColorDialog
#define TQStringPairList Q3StringPairList
#define TQLineEdit QLineEdit
#define TQValidator QValidator
#define TQComboBoxData Q3ComboBoxData
#define TQComboTableItem Q3ComboTableItem
#define TQWheelEvent QWheelEvent
#define TQComboBox Q3ComboBox
#define TQCommonStyle QCommonStyle
#define TQCompactStyle QCompactStyle
#define TQConnection QConnection
#define TQCString Q3CString
#define TQCursor QCursor
#define TQDataBrowserPrivate Q3DataBrowserPrivate
#define TQDataBrowser Q3DataBrowser
#define TQDataStream QDataStream
#define TQSqlField QSqlField
#define TQDataTablePrivate QDataTablePrivate
#define TQDataTable Q3DataTable
#define TQDataView Q3DataView
#define TQDateEdit Q3DateEdit
#define TQTimeEdit Q3TimeEdit
#define TQDateTimeEdit Q3DateTimeEdit
#define TQDateTimeEditBase Q3DateTimeEditBase
#define TQDate QDate
#define TQTime QTime
#define TQDateTime QDateTime
#define TQDeepCopy Q3DeepCopy
#define TQDesktopWidget QDesktopWidget
#define TQDial QDial
#define TQDialog QDialog
#define TQDict Q3Dict
#define TQDictIterator Q3DictIterator
#define TQDir QDir
#define TQDirLineEdit QDirLineEdit
#define TQDirMultiLineEdit QDirMultiLineEdit
#define TQDns Q3Dns
#define TQDnsSocket QDnsSocket
#define TQDockArea Q3DockArea
#define TQDockAreaLayout QDockAreaLayout
#define TQDockWindow Q3DockWindow
#define TQDomImplementation QDomImplementation
#define TQDomNodeList QDomNodeList
#define TQDomDocumentType QDomDocumentType
#define TQDomDocument QDomDocument
#define TQDomNamedNodeMap QDomNamedNodeMap
#define TQDomDocumentFragment QDomDocumentFragment
#define TQDomCharacterData QDomCharacterData
#define TQDomAttr QDomAttr
#define TQDomElement QDomElement
#define TQDomText QDomText
#define TQDomComment QDomComment
#define TQDomCDATASection QDomCDATASection
#define TQDomNotation QDomNotation
#define TQDomEntity QDomEntity
#define TQDomEntityReference QDomEntityReference
#define TQDomProcessingInstruction QDomProcessingInstruction
#define TQDomNode QDomNode
#define TQDragObject Q3DragObject
#define TQStoredDrag Q3StoredDrag
#define TQTextDrag Q3TextDrag
#define TQImageDrag Q3ImageDrag
#define TQUriDrag Q3UriDrag
#define TQColorDrag Q3ColorDrag
#define TQDropSite Q3DropSite
#define TQEditorFactory Q3EditorFactory
#define TQErrorMessage QErrorMessage
#define TQEucJpCodec QEucJpCodec
#define TQEucKrCodec QEucKrCodec
#define TQEvent QEvent
#define TQTimerEvent QTimerEvent
#define TQMouseEvent QMouseEvent
#define TQWheelEvent QWheelEvent
#define TQTabletEvent QTabletEvent
#define TQKeyEvent QKeyEvent
#define TQFocusEvent QFocusEvent
#define TQPaintEvent QPaintEvent
#define TQMoveEvent QMoveEvent
#define TQResizeEvent QResizeEvent
#define TQCloseEvent QCloseEvent
#define TQIconDragEvent QIconDragEvent
#define TQShowEvent QShowEvent
#define TQHideEvent QHideEvent
#define TQContextMenuEvent QContextMenuEvent
#define TQIMEvent QIMEvent
#define TQIMComposeEvent QIMComposeEvent
#define TQDropEvent QDropEvent
#define TQDragMoveEvent QDragMoveEvent
#define TQDragEnterEvent QDragEnterEvent
#define TQDragResponseEvent QDragResponseEvent
#define TQDragLeaveEvent QDragLeaveEvent
#define TQChildEvent QChildEvent
#define TQCustomEvent QCustomEvent
#define TQFileIconProvider Q3FileIconProvider
#define TQFilePreview Q3FilePreview
#define TQFileDialog Q3FileDialog
#define TQFile QFile
#define TQFileInfo QFileInfo
#define TQFileInfoList QFileInfoList
#define TQFileInfoListIterator TQListIteratorRetPtr<QFileInfo>
#define TQFocusData QFocusData
#define TQFontDatabase QFontDatabase
#define TQFont QFont
#define TQFontInfo QFontInfo
#define TQFontMetrics QFontMetrics
#define TQFrame Q3Frame
#define TQFtp Q3Ftp
#define TQGArray QGArray
#define TQGb18030Codec QGb18030Codec
#define TQGbkCodec QGbkCodec
#define TQGb2312Codec QGb2312Codec
#define TQGCache QGCache
#define TQGCacheIterator QGCacheIterator
#define TQBaseBucket QBaseBucket
#define TQStringBucket QStringBucket
#define TQAsciiBucket QAsciiBucket
#define TQIntBucket QIntBucket
#define TQPtrBucket QPtrBucket
#define TQGDict Q3GDict
#define TQGDictIterator Q3GDictIterator
#define TQGLColormap QGLColormap
#define TQGL QGL
#define TQGLFormat QGLFormat
#define TQGLContext QGLContext
#define TQGLWidget QGLWidget
#define TQLNode QLNode
#define TQGList Q3GList
#define TQGListIterator Q3GListIterator
#define TQGListStdIterator Q3GListStdIterator
#define TQGPlugin QGPlugin
#define TQGrid Q3Grid
#define TQGridView Q3GridView
#define TQGroupBox Q3GroupBox
#define TQGuardedPtr QPointer
#define TQGuardedPtrPrivate QPointerPrivate
#define TQGVector QGVector
#define TQHBox Q3HBox
#define TQHButtonGroup Q3HButtonGroup
#define TQHeader Q3Header
#define TQHGroupBox Q3HGroupBox
#define TQHostAddress QHostAddress
#define TQHttpHeader Q3HttpHeader
#define TQHttpResponseHeader Q3HttpResponseHeader
#define TQHttpRequestHeader Q3HttpRequestHeader
#define TQHttp Q3Http
#define TQIconSet QIcon
#define TQIconDragItem Q3IconDragItem
#define TQIconDrag Q3IconDrag
#define TQIconViewItem Q3IconViewItem
#define TQIconView Q3IconView
#define TQImageFormatPlugin QImageFormatPlugin
#define TQImageTextKeyLang QImageTextKeyLang
#define TQImage QImage
#define TQInputContextFactory QInputContextFactory
#define TQInputContext QInputContext
#define TQIntCache Q3IntCache
#define TQIntCacheIterator Q3IntCacheIterator
#define TQIntDict Q3IntDict
#define TQIntDictIterator Q3IntDictIterator
#define TQIODevice QIODevice
#define TQJisCodec QJisCodec
#define TQJpUnicodeConv QJpUnicodeConv
#define TQKeySequence QKeySequence
#define TQLabel QLabel
#define TQGLayoutIterator QGLayoutIterator
#define TQLayoutIterator QLayoutIterator
#define TQLayoutItem QLayoutItem
#define TQSpacerItem QSpacerItem
#define TQWidgetItem QWidgetItem
#define TQLayout QLayout
#define TQGridLayout QGridLayout
#define TQBoxLayout QBoxLayout
#define TQHBoxLayout QHBoxLayout
#define TQVBoxLayout QVBoxLayout
#define TQLCDNumber QLCDNumber
#define TQLibrary QLibrary
#define TQLineEdit QLineEdit
#define TQListBox Q3ListBox
#define TQListBoxItem Q3ListBoxItem
#define TQListBoxText Q3ListBoxText
#define TQListBoxPixmap Q3ListBoxPixmap
#define TQListViewItem Q3ListViewItem
#define TQListView Q3ListView
#define TQCheckListItem Q3CheckListItem
#define TQListViewItemIterator Q3ListViewItemIterator
#define TQLocale QLocale
#define TQLocalFs Q3LocalFs
#define TQMainWindow Q3MainWindow
#define TQMemArray Q3MemArray
#define TQMenuBar QMenuBar
#define TQMenuItem QMenuItem
#define TQCustomMenuItem QCustomMenuItem
#define TQMenuData QMenuData
#define TQMessageBox QMessageBox
#define TQMetaProperty QMetaProperty
#define TQMetaObject const QMetaObject
#define TQMetaObjectCleanUp QMetaObjectCleanUp
#define TQMimeSource QMimeSource
#define TQMimeSourceFactory Q3MimeSourceFactory
#define TQWindowsMime QWindowsMime
#define TQMacMime QMacMime
#define TQMotifPlusStyle QMotifPlusStyle
#define TQMotifStyle QMotifStyle
#define TQMultiLineEdit Q3MultiLineEdit
#define TQMutex QMutex
#define TQMutexLocker QMutexLocker
#define TQt Qt
#define TQInternal QInternal
#define TQNetworkProtocolFactoryBase QNetworkProtocolFactoryBase
#define TQNetworkProtocolFactory QNetworkProtocolFactory
#define TQNetworkProtocol Q3NetworkProtocol
#define TQNetworkOperation Q3NetworkOperation
#define TQObjectCleanupHandler QObjectCleanupHandler
#define TQObjectDictionary QObjectDictionary
#define TQObject QObject
#define TQObjectUserData QObjectUserData
#define TQObject QObject
#define TQObjectList TQPtrList<QObject>
#define TQObjectListIterator TQPtrListIterator<QObject>
#define TQObjectListIt TQObjectListIterator
#define TQPaintDevice QPaintDevice
#define TQPaintDeviceMetrics Q3PaintDeviceMetrics
#define TQPainter Q3Painter
#define TQColorGroup QColorGroup
#define TQPalette QPalette
#define TQPen QPen
#define TQPicture Q3Picture
#define TQPixmapCache QPixmapCache
#define TQPixmap QPixmap
#define TQPlatinumStyle QPlatinumStyle
#define TQPNGImageWriter QPNGImageWriter
#define TQPNGImagePacker QPNGImagePacker
#define TQPointArray Q3PointArray
#define TQPoint QPoint
#define TQPolygonScanner QPolygonScanner
#define TQPopupMenu Q3PopupMenu
#define TQPrintDialog QPrintDialog
#define TQPrinter QPrinter
#define TQProcess Q3Process
#define TQProgressBar Q3ProgressBar
#define TQProgressDialog Q3ProgressDialog
#define TQPtrCollection Q3PtrCollection
#define TQPtrDict Q3PtrDict
#define TQPtrDictIterator Q3PtrDictIterator
#define TQPtrQueue Q3PtrQueue
#define TQPtrStack Q3PtrStack
#define TQPtrVector Q3PtrVector
#define TQPushButton QPushButton
#define TQRadioButton QRadioButton
#define TQRangeControl Q3RangeControl
#define TQSpinWidget QSpinWidget
#define TQRect QRect
#define TQRegExp QRegExp
#define TQRegion QRegion
#define TQHebrewCodec QHebrewCodec
#define TQScrollBar QScrollBar
#define TQScrollView Q3ScrollView
#define TQSemaphore Q3Semaphore
#define TQSemiModal QSemiModal
#define TQServerSocket Q3ServerSocket
#define TQSettings QSettings
#define TQSGIStyle QSGIStyle
#define TQSignal Q3Signal
#define TQSignalMapper QSignalMapper
#define TQConnectionList QConnectionList
#define TQConnectionListIt QConnectionListIt
#define TQSignalVec QSignalVec
#define TQSimpleRichText Q3SimpleRichText
#define TQSizeGrip QSizeGrip
#define TQSize QSize
#define TQSizePolicy QSizePolicy
#define TQSjisCodec QSjisCodec
#define TQSlider QSlider
#define TQSocketDevice Q3SocketDevice
#define TQSocket Q3Socket
#define TQSocketNotifier QSocketNotifier
#define TQSortedList QSortedList
#define TQSound QSound
#define TQSpinBox QSpinBox
#define TQSplashScreen QSplashScreen
#define TQSplitter QSplitter
#define TQSqlCursor Q3SqlCursor
#define TQSqlDatabase QSqlDatabase
#define TQSqlDriver QSqlDriver
#define TQSqlDriverPlugin QSqlDriverPlugin
#define TQSqlEditorFactory Q3SqlEditorFactory
#define TQSqlError QSqlError
#define TQSqlFieldPrivate QSqlFieldPrivate
#define TQSqlField QSqlField
#define TQSqlFieldInfo Q3SqlFieldInfo
#define TQSqlForm Q3SqlForm
#define TQSql QSql
#define TQSqlIndex QSqlIndex
#define TQSqlPropertyMap Q3SqlPropertyMap
#define TQSqlQuery QSqlQuery
#define TQSqlResultShared QSqlResultShared
#define TQSqlRecordShared QSqlRecordShared
#define TQSqlRecord QSqlRecord
#define TQSqlRecordInfo Q3SqlRecordInfo
#define TQSqlResult QSqlResult
#define TQSqlSelectCursorPrivate QSqlSelectCursorPrivate
#define TQSqlSelectCursor Q3SqlSelectCursor
#define TQStatusBar QStatusBar
#define TQChar QChar
#define TQString QString
#define TQCharRef QCharRef
#define TQConstString QConstString
#define TQStrVec QStrVec
#define TQStrIVec QStrIVec
#define TQStyleFactory QStyleFactory
#define TQStyleOption QStyleOption
#define TQStyle QStyle
#define TQStyleHintReturn QStyleHintReturn
#define TQStylePlugin QStylePlugin
#define TQStyleSheetItem Q3StyleSheetItem
#define TQStyleSheet Q3StyleSheet
#define TQSyntaxHighlighter Q3SyntaxHighlighter
#define TQTab QTab
#define TQTabBar QTabBar
#define TQTabDialog Q3TabDialog
#define TQTableSelection Q3TableSelection
#define TQTableItem Q3TableItem
#define TQCheckTableItem Q3CheckTableItem
#define TQTable Q3Table
#define TQTabWidget QTabWidget
#define TQTextBrowser Q3TextBrowser
#define TQTextCodecFactory QTextCodecFactory
#define TQTextEncoder QTextEncoder
#define TQTextDecoder QTextDecoder
#define TQTextCodec QTextCodec
#define TQTextCodecPlugin QTextCodecPlugin
#define TQTextEdit Q3TextEdit
#define TQTextStream Q3TextStream
#define TQTextIStream QTextIStream
#define TQTextOStream QTextOStream
#define TQTSManip QTSManip
#define TQTextView Q3TextView
#define TQThread QThread
#define TQThreadStorageData QThreadStorageData
#define TQThreadStorage QThreadStorage
#define TQTimer QTimer
#define TQTextOStreamIterator QTextOStreamIterator
#define TQBackInsertIterator QBackInsertIterator
#define TQtMsgType QtMsgType
#define TQtMsgHandler QtMsgHandler
#define TQToolBar Q3ToolBar
#define TQToolBox QToolBox
#define TQToolButton QToolButton
#define TQToolTipGroup QToolTipGroup
#define TQToolTip QToolTip
#define TQTranslator QTranslator
#define TQTranslatorMessage QTranslatorMessage
#define TQTsciiCodec QTsciiCodec
#define TQUrl Q3Url
#define TQUrlInfo QUrlInfo
#define TQUrlOperator Q3UrlOperator
#define TQUtf8Codec QUtf8Codec
#define TQUtf16Codec QUtf16Codec
#define TQValidator QValidator
#define TQIntValidator QIntValidator
#define TQDoubleValidator QDoubleValidator
#define TQRegExpValidator QRegExpValidator
#define TQValueStack Q3ValueStack
#define TQValueVectorPrivate QValueVectorPrivate
#define TQValueVector Q3ValueVector
#define TQVariant QVariant
#define TQVBox Q3VBox
#define TQVButtonGroup Q3VButtonGroup
#define TQVGroupBox Q3VGroupBox
#define TQWaitCondition QWaitCondition
#define TQWhatsThis Q3WhatsThis
#define TQWidgetFactory QWidgetFactory
#define TQWidget QWidget
#define TQWidgetIntDict QWidgetIntDict
#define TQWidgetIntDictIt QWidgetIntDictIt
#define TQWidgetPlugin QWidgetPlugin
#define TQWidgetContainerPlugin QWidgetContainerPlugin
#define TQWidgetStack Q3WidgetStack
#define TQWidgetStackAccelManager Q3WidgetStackAccelManager
#define TQWindowsStyle QWindowsStyle
#define TQWizard Q3Wizard
#define TQWMatrix QMatrix
#define TQWorkspace QWorkspace
#define TQXmlNamespaceSupport QXmlNamespaceSupport
#define TQXmlAttributes QXmlAttributes
#define TQXmlInputSource QXmlInputSource
#define TQXmlParseException QXmlParseException
#define TQXmlReader QXmlReader
#define TQXmlSimpleReader QXmlSimpleReader
#define TQXmlLocator QXmlLocator
#define TQXmlContentHandler QXmlContentHandler
#define TQXmlErrorHandler QXmlErrorHandler
#define TQXmlDTDHandler QXmlDTDHandler
#define TQXmlEntityResolver QXmlEntityResolver
#define TQXmlLexicalHandler QXmlLexicalHandler
#define TQXmlDeclHandler QXmlDeclHandler
#define TQXmlDefaultHandler QXmlDefaultHandler
#endif

#endif /* TQT_VERSION_ONLY */

#endif /* TQT_H */
