STRINGIFY(

// defines built-in functions supported by SkiaSL

$genType radians($genType degrees);
$genType sin($genType angle);
$genType cos($genType angle);
$genType tan($genType angle);
$genType asin($genType x);
$genType acos($genType x);
$genType atan($genType y, $genType x);
$genType atan($genType y_over_x);
$genType sinh($genType x);
$genType cosh($genType x);
$genType tanh($genType x);
$genType asinh($genType x);
$genType acosh($genType x);
$genType atanh($genType x);
$genType pow($genType x, $genType y);
$genType exp($genType x);
$genType log($genType x);
$genType exp2($genType x);
$genType log2($genType x);
$genType sqrt($genType x);
//$genDType sqrt($genDType x);
$genType inversesqrt($genType x);
//$genDType inversesqrt($genDType x);
$genType abs($genType x);
$genIType abs($genIType x);
//$genDType abs($genDType x);
$genType sign($genType x);
$genIType sign($genIType x);
//$genDType sign($genDType x);
$genType floor($genType x);
//$genDType floor($genDType x);
$genType trunc($genType x);
//$genDType trunc($genDType x);
$genType round($genType x);
//$genDType round($genDType x);
$genType roundEven($genType x);
//$genDType roundEven($genDType x);
$genType ceil($genType x);
//$genDType ceil($genDType x);
$genType fract($genType x);
//$genDType fract($genDType x);
$genType mod($genType x, float y);
$genType mod($genType x, $genType y);
//$genDType mod($genDType x, double y);
//$genDType mod($genDType x, $genDType y);
$genType modf($genType x, out $genType i);
//$genDType modf($genDType x, out $genDType i);
$genType min($genType x, $genType y);
$genType min($genType x, float y);
//$genDType min($genDType x, $genDType y);
//$genDType min($genDType x, double y);
$genIType min($genIType x, $genIType y);
$genIType min($genIType x, int y);
//$genUType min($genUType x, $genUType y);
//$genUType min($genUType x, uint y);
$genType max($genType x, $genType y);
$genType max($genType x, float y);
//$genDType max($genDType x, $genDType y);
//$genDType max($genDType x, double y);
$genIType max($genIType x, $genIType y);
$genIType max($genIType x, int y);
//$genUType max($genUType x, $genUType y);
//$genUType max($genUType x, uint y);
$genType clamp($genType x, $genType minVal, $genType maxVal);
$genType clamp($genType x, float minVal, float maxVal);
//$genDType clamp($genDType x, $genDType minVal, $genDType maxVal);
//$genDType clamp($genDType x, double minVal, double maxVal);
$genIType clamp($genIType x, $genIType minVal, $genIType maxVal);
$genIType clamp($genIType x, int minVal, int maxVal);
//$genUType clamp($genUType x, $genUType minVal, $genUType maxVal);
//$genUType clamp($genUType x, uint minVal, uint maxVal);
$genType saturate($genType x);
$genType mix($genType x, $genType y, $genType a);
$genType mix($genType x, $genType y, float a);
//$genDType mix($genDType x, $genDType y, $genDType a);
//$genDType mix($genDType x, $genDType y, double a);
$genType mix($genType x, $genType y, $genBType a);
//$genDType mix($genDType x, $genDType y, $genBType a);
$genIType mix($genIType x, $genIType y, $genBType a);
//$genUType mix($genUType x, $genUType y, $genBType a);
$genBType mix($genBType x, $genBType y, $genBType a);
$genType step($genType edge, $genType x);
$genType step(float edge, $genType x);
//$genDType step($genDType edge, $genDType x);
//$genDType step(double edge, $genDType x);
$genType smoothstep($genType edge0, $genType edge1, $genType x);
$genType smoothstep(float edge0, float edge1, $genType x);
//$genDType smoothstep($genDType edge0, $genDType edge1, $genDType x);
//$genDType smoothstep(double edge0, double edge1, $genDType x);
$genBType isnan($genType x);
$genBType isnan($genDType x);
$genBType isinf($genType x);
$genBType isinf($genDType x);
$genIType floatBitsToInt($genType value);
//$genUType floatBitsToUint($genType value);
$genType intBitsTofloat($genIType value);
$genType uintBitsTofloat($genUType value);
$genType fma($genType a, $genType b, $genType c);
$genHType fma($genHType a, $genHType b, $genHType c);
$genDType fma($genDType a, $genDType b, $genDType c);
//$genDType fma($genDType a, $genDType b, $genDType c);
sk_has_side_effects $genType frexp($genType x, out $genIType exp);
//$genDType frexp($genDType x, out $genIType exp);
$genType ldexp($genType x, in $genIType exp);
//$genDType ldexp($genDType x, in $genIType exp);
uint packUnorm2x16(float2 v);
uint packSnorm2x16(float2 v);
uint packUnorm4x8(float4 v);
uint packSnorm4x8(float4 v);
float2 unpackUnorm2x16(uint p);
float2 unpackSnorm2x16(uint p);
float4 unpackUnorm4x8(uint p);
float4 unpackSnorm4x8(uint p);
//double packDouble2x32(uint2 v);
uint2 unpackDouble2x32(double v);
uint packHalf2x16(float2 v);
float2 unpackHalf2x16(uint v);
float length($genType x);
half length($genHType x);
double length($genDType x);
float distance($genType p0, $genType p1);
half distance($genHType p0, $genHType p1);
double distance($genDType p0, $genDType p1);
float dot($genType x, $genType y);
half dot($genHType x, $genHType y);
double dot($genDType x, $genDType y);
float3 cross(float3 x, float3 y);
half3 cross(half3 x, half3 y);
double3 cross(double3 x, double3 y);
$genType normalize($genType x);
$genHType normalize($genHType x);
$genDType normalize($genDType x);
float4 ftransform();
$genType faceforward($genType N, $genType I, $genType Nref);
$genHType faceforward($genHType N, $genHType I, $genHType Nref);
$genDType faceforward($genDType N, $genDType I, $genDType Nref);
$genType reflect($genType I, $genType N);
$genHType reflect($genHType I, $genHType N);
$genDType reflect($genDType I, $genDType N);
$genType refract($genType I, $genType N, float eta);
$genHType refract($genHType I, $genHType N, float eta);
$genDType refract($genDType I, $genDType N, float eta);
$mat matrixCompMult($mat x, $mat y);
float2x2 outerProduct(float2 c, float2 r);
float3x3 outerProduct(float3 c, float3 r);
float4x3 outerProduct(float4 c, float4 r);
float2x3 outerProduct(float3 c, float2 r);
float3x2 outerProduct(float2 c, float3 r);
float2x4 outerProduct(float4 c, float2 r);
float4x2 outerProduct(float2 c, float4 r);
float3x4 outerProduct(float4 c, float3 r);
float4x3 outerProduct(float3 c, float4 r);
float2x2 transpose(float2x2 m);
float3x3 transpose(float3x3 m);
float4x4 transpose(float4x4 m);
float2x3 transpose(float3x2 m);
float3x2 transpose(float2x3 m);
float2x4 transpose(float4x2 m);
float4x2 transpose(float2x4 m);
float3x4 transpose(float4x3 m);
float4x3 transpose(float3x4 m);
float determinant(float2x2 m);
float determinant(float3x3 m);
float determinant(float4x4 m);
float2x2 inverse(float2x2 m);
float3x3 inverse(float3x3 m);
float4x4 inverse(float4x4 m);
$bvec lessThan($vec x, $vec y);
$bvec lessThan($hvec x, $hvec y);
$bvec lessThan($dvec x, $dvec y);
$bvec lessThan($ivec x, $ivec y);
$bvec lessThan($svec x, $svec y);
$bvec lessThan($usvec x, $usvec y);
$bvec lessThan($uvec x, $uvec y);
$bvec lessThanEqual($vec x, $vec y);
$bvec lessThanEqual($hvec x, $hvec y);
$bvec lessThanEqual($dvec x, $dvec y);
$bvec lessThanEqual($ivec x, $ivec y);
$bvec lessThanEqual($uvec x, $uvec y);
$bvec lessThanEqual($svec x, $svec y);
$bvec lessThanEqual($usvec x, $usvec y);
$bvec greaterThan($vec x, $vec y);
$bvec greaterThan($hvec x, $hvec y);
$bvec greaterThan($dvec x, $dvec y);
$bvec greaterThan($ivec x, $ivec y);
$bvec greaterThan($uvec x, $uvec y);
$bvec greaterThan($svec x, $svec y);
$bvec greaterThan($usvec x, $usvec y);
$bvec greaterThanEqual($vec x, $vec y);
$bvec greaterThanEqual($hvec x, $hvec y);
$bvec greaterThanEqual($dvec x, $dvec y);
$bvec greaterThanEqual($ivec x, $ivec y);
$bvec greaterThanEqual($uvec x, $uvec y);
$bvec greaterThanEqual($svec x, $svec y);
$bvec greaterThanEqual($usvec x, $usvec y);
$bvec equal($vec x, $vec y);
$bvec equal($hvec x, $hvec y);
$bvec equal($dvec x, $dvec y);
$bvec equal($ivec x, $ivec y);
$bvec equal($uvec x, $uvec y);
$bvec equal($svec x, $svec y);
$bvec equal($usvec x, $usvec y);
$bvec equal($bvec x, $bvec y);
$bvec notEqual($vec x, $vec y);
$bvec notEqual($hvec x, $hvec y);
$bvec notEqual($dvec x, $dvec y);
$bvec notEqual($ivec x, $ivec y);
$bvec notEqual($uvec x, $uvec y);
$bvec notEqual($svec x, $svec y);
$bvec notEqual($usvec x, $usvec y);
$bvec notEqual($bvec x, $bvec y);
bool any($bvec x);
bool all($bvec x);
$bvec not($bvec x);

$genIType bitCount($genIType value);
$genIType bitCount($genUType value);
$genIType findLSB($genIType value);
$genIType findLSB($genUType value);
$genIType findMSB($genIType value);
$genIType findMSB($genUType value);

/*
//$genUType uaddCarry($genUType x, $genUType y, out $genUType carry);
//$genUType usubBorrow($genUType x, $genUType y, out $genUType borrow);
void umulExtended($genUType x, $genUType y, out $genUType msb, out $genUType lsb);
void imulExtended($genIType x, $genIType y, out $genIType msb, out $genIType lsb);
$genIType bitfieldExtract($genIType value, int offset, int bits);
//$genUType bitfieldExtract($genUType value, int offset, int bits);
$genIType bitfieldInsert($genIType base, $genIType insert, int offset, int bits);
//$genUType bitfieldInsert($genUType base, $genUType insert, int offset, int bits);
$genIType bitfieldReverse($genIType value);
//$genUType bitfieldReverse($genUType value);
int textureSize($gsampler1D sampler, int lod);
int2 textureSize($gsampler2D sampler, int lod);
int3 textureSize($gsampler3D sampler, int lod);
int2 textureSize($gsamplerCube sampler, int lod);
int textureSize(sampler1DShadow sampler, int lod);
int2 textureSize(sampler2DShadow sampler, int lod);
int2 textureSize(samplerCubeShadow sampler, int lod);
int3 textureSize($gsamplerCubeArray sampler, int lod);
int3 textureSize(samplerCubeArrayShadow sampler, int lod);
*/
int2 textureSize($gsampler2DRect sampler);
/*
int2 textureSize(sampler2DRectShadow sampler);
int2 textureSize($gsampler1DArray sampler, int lod);
int3 textureSize($gsampler2DArray sampler, int lod);
int2 textureSize(sampler1DArrayShadow sampler, int lod);
int3 textureSize(sampler2DArrayShadow sampler, int lod);
int textureSize($gsamplerBuffer sampler);
int2 textureSize($gsampler2DMS sampler);
int3 textureSize($gsampler2DMSArray sampler);
float2 textureQueryLod($gsampler1D sampler, float P);
float2 textureQueryLod($gsampler2D sampler, float2 P);
float2 textureQueryLod($gsampler3D sampler, float3 P);
float2 textureQueryLod($gsamplerCube sampler, float3 P);
float2 textureQueryLod($gsampler1DArray sampler, float P);
float2 textureQueryLod($gsampler2DArray sampler, float2 P);
float2 textureQueryLod($gsamplerCubeArray sampler, float3 P);
float2 textureQueryLod(sampler1DShadow sampler, float P);
float2 textureQueryLod(sampler2DShadow sampler, float2 P);
float2 textureQueryLod(samplerCubeShadow sampler, float3 P);
float2 textureQueryLod(sampler1DArrayShadow sampler, float P);
float2 textureQueryLod(sampler2DArrayShadow sampler, float2 P);
float2 textureQueryLod(samplerCubeArrayShadow sampler, float3 P);
int textureQueryLevels($gsampler1D sampler);
int textureQueryLevels($gsampler2D sampler);
int textureQueryLevels($gsampler3D sampler);
int textureQueryLevels($gsamplerCube sampler);
int textureQueryLevels($gsampler1DArray sampler);
int textureQueryLevels($gsampler2DArray sampler);
int textureQueryLevels($gsamplerCubeArray sampler);
int textureQueryLevels(sampler1DShadow sampler);
int textureQueryLevels(sampler2DShadow sampler);
int textureQueryLevels(samplerCubeShadow sampler);
int textureQueryLevels(sampler1DArrayShadow sampler);
int textureQueryLevels(sampler2DArrayShadow sampler);
int textureQueryLevels(samplerCubeArrayShadow sampler);
*/

half4 texture($gsampler1D sampler, float P);
half4 texture($gsampler1D sampler, float P, float bias);
half4 texture($gsampler2D sampler, float2 P);
// The above currently only expand to handle the float/fixed case. So we also declare this integer
// version of texture().
int4 texture(isampler2D sampler, float2 P);
half4 texture(samplerExternalOES sampler, float2 P, float bias);
half4 texture(samplerExternalOES sampler, float2 P);

/*
$gfloat4 texture($gsampler2D sampler, float2 P, float bias);
$gfloat4 texture($gsampler3D sampler, float3 P);
$gfloat4 texture($gsampler3D sampler, float3 P, float bias);
$gfloat4 texture($gsamplerCube sampler, float3 P);
$gfloat4 texture($gsamplerCube sampler, float3 P, float bias);
float texture(sampler1DShadow sampler, float3 P);
float texture(sampler1DShadow sampler, float3 P, float bias);
float texture(sampler2DShadow sampler, float3 P);
float texture(sampler2DShadow sampler, float3 P, float bias);
float texture(samplerCubeShadow sampler, float4 P);
float texture(samplerCubeShadow sampler, float4 P, float bias);
$gfloat4 texture($gsampler1DArray sampler, float2 P);
$gfloat4 texture($gsampler1DArray sampler, float2 P, float bias);
$gfloat4 texture($gsampler2DArray sampler, float3 P);
$gfloat4 texture($gsampler2DArray sampler, float3 P, float bias);
$gfloat4 texture($gsamplerCubeArray sampler, float4 P);
$gfloat4 texture($gsamplerCubeArray sampler, float4 P, float bias);
float texture(sampler1DArrayShadow sampler, float3 P);
float texture(sampler1DArrayShadow sampler, float3 P, float bias);
float texture(sampler2DArrayShadow sampler, float4 P);
*/

half4 texture($gsampler2DRect sampler, float2 P);
half4 texture($gsampler2DRect sampler, float3 P);

/*
float texture(sampler2DRectShadow sampler, float3 P);
float texture($gsamplerCubeArrayShadow sampler, float4 P, float compare);
*/

// Currently we do not support the generic types of loading subpassInput so we have some explicit
// versions that we currently use
float4 subpassLoad(subpassInput subpass);
float4 subpassLoad(subpassInputMS subpass, int sample);
/*
$gfloat4subpassLoad(gsubpassInput subpass);
$gfloat4subpassLoad(gsubpassInputMS subpass, int sample);
*/
)

// split into multiple chunks, as MSVC++ complains if a single string is too long

STRINGIFY(

half4 texture($gsampler1D sampler, float2 P);
half4 texture($gsampler1D sampler, float2 P, float bias);
half4 texture($gsampler2D sampler, float3 P);
half4 texture($gsampler2D sampler, float3 P, float bias);
/*
$gfloat4 textureProj($gsampler3D sampler, float4 P);
$gfloat4 textureProj($gsampler3D sampler, float4 P, float bias);
float textureProj(sampler1DShadow sampler, float4 P);
float textureProj(sampler1DShadow sampler, float4 P, float bias);
float textureProj(sampler2DShadow sampler, float4 P);
float textureProj(sampler2DShadow sampler, float4 P, float bias);
$gfloat4 textureProj($gsampler2DRect sampler, float4 P);
float textureProj(sampler2DRectShadow sampler, float4 P);
$gfloat4 textureLod($gsampler1D sampler, float P, float lod);
$gfloat4 textureLod($gsampler2D sampler, float2 P, float lod);
$gfloat4 textureLod($gsampler3D sampler, float3 P, float lod);
$gfloat4 textureLod($gsamplerCube sampler, float3 P, float lod);
float textureLod(sampler1DShadow sampler, float3 P, float lod);
float textureLod(sampler2DShadow sampler, float3 P, float lod);
$gfloat4 textureLod($gsampler1DArray sampler, float2 P, float lod);
$gfloat4 textureLod($gsampler2DArray sampler, float3 P, float lod);
float textureLod(sampler1DArrayShadow sampler, float3 P, float lod);
$gfloat4 textureLod($gsamplerCubeArray sampler, float4 P, float lod);
$gfloat4 textureOffset($gsampler1D sampler, float P, int offset);
$gfloat4 textureOffset($gsampler1D sampler, float P, int offset, float bias);
$gfloat4 textureOffset($gsampler2D sampler, float2 P, int2 offset);
$gfloat4 textureOffset($gsampler2D sampler, float2 P, int2 offset, float bias);
$gfloat4 textureOffset($gsampler3D sampler, float3 P, int3 offset);
$gfloat4 textureOffset($gsampler3D sampler, float3 P, int3 offset, float bias);
$gfloat4 textureOffset($gsampler2DRect sampler, float2 P, int2 offset);
float textureOffset(sampler2DRectShadow sampler, float3 P, int2 offset);
float textureOffset(sampler1DShadow sampler, float3 P, int offset);
float textureOffset(sampler1DShadow sampler, float3 P, int offset, float bias);
float textureOffset(sampler2DShadow sampler, float3 P, int2 offset);
float textureOffset(sampler2DShadow sampler, float3 P, int2 offset, float bias);
$gfloat4 textureOffset($gsampler1DArray sampler, float2 P, int offset);
$gfloat4 textureOffset($gsampler1DArray sampler, float2 P, int offset, float bias);
$gfloat4 textureOffset($gsampler2DArray sampler, float3 P, int2 offset);
$gfloat4 textureOffset($gsampler2DArray sampler, float3 P, int2 offset, float bias);
float textureOffset(sampler1DArrayShadow sampler, float3 P, int offset);
float textureOffset(sampler1DArrayShadow sampler, float3 P, int offset, float bias);
float textureOffset(sampler2DArrayShadow sampler, float4 P, int2 offset);
float4 texelFetch(samplerBuffer sampler, int P);
$gfloat4 texelFetch($gsampler1D sampler, int P, int lod);
$gfloat4 texelFetch($gsampler2D sampler, int2 P, int lod);
$gfloat4 texelFetch($gsampler2DRect sampler, int2 P);
$gfloat4 texelFetch($gsampler3D sampler, int3 P, int lod);
$gfloat4 texelFetch($gsampler1DArray sampler, int2 P, int lod);
$gfloat4 texelFetch($gsampler2DArray sampler, int3 P, int lod);
$gfloat4 texelFetch($gsampler2DMS sampler, int2 P, int sample);
$gfloat4 texelFetch($gsampler2DMSArray sampler, int3 P, int sample);
$gfloat4 texelFetchOffset($gsampler1D sampler, int P, int lod, int offset);
$gfloat4 texelFetchOffset($gsampler2D sampler, int2 P, int lod, int2 offset);
$gfloat4 texelFetchOffset($gsampler3D sampler, int3 P, int lod, int3 offset);
$gfloat4 texelFetchOffset($gsampler2DRect sampler, int2 P, int2 offset);
$gfloat4 texelFetchOffset($gsampler1DArray sampler, int2 P, int lod, int offset);
$gfloat4 texelFetchOffset($gsampler2DArray sampler, int3 P, int lod, int2 offset);
$gfloat4 textureProjOffset($gsampler1D sampler, float2 P, int offset);
$gfloat4 textureProjOffset($gsampler1D sampler, float2 P, int offset, float bias);
$gfloat4 textureProjOffset($gsampler1D sampler, float4 P, int offset);
$gfloat4 textureProjOffset($gsampler1D sampler, float4 P, int offset, float bias);
$gfloat4 textureProjOffset($gsampler2D sampler, float3 P, int2 offset);
$gfloat4 textureProjOffset($gsampler2D sampler, float3 P, int2 offset, float bias);
$gfloat4 textureProjOffset($gsampler2D sampler, float4 P, int2 offset);
$gfloat4 textureProjOffset($gsampler2D sampler, float4 P, int2 offset, float bias);
$gfloat4 textureProjOffset($gsampler3D sampler, float4 P, int3 offset);
$gfloat4 textureProjOffset($gsampler3D sampler, float4 P, int3 offset, float bias);
$gfloat4 textureProjOffset($gsampler2DRect sampler, float3 P, int2 offset);
$gfloat4 textureProjOffset($gsampler2DRect sampler, float4 P, int2 offset);
float textureProjOffset(sampler2DRectShadow sampler, float4 P, int2 offset);
float textureProjOffset(sampler1DShadow sampler, float4 P, int offset);
float textureProjOffset(sampler1DShadow sampler, float4 P, int offset, float bias);
float textureProjOffset(sampler2DShadow sampler, float4 P, int2 offset);
float textureProjOffset(sampler2DShadow sampler, float4 P, int2 offset, float bias);
$gfloat4 textureLodOffset($gsampler1D sampler, float P, float lod, int offset);
$gfloat4 textureLodOffset($gsampler2D sampler, float2 P, float lod, int2 offset);
$gfloat4 textureLodOffset($gsampler3D sampler, float3 P, float lod, int3 offset);
float textureLodOffset(sampler1DShadow sampler, float3 P, float lod, int offset);
float textureLodOffset(sampler2DShadow sampler, float3 P, float lod, int2 offset);
$gfloat4 textureLodOffset($gsampler1DArray sampler, float2 P, float lod, int offset);
$gfloat4 textureLodOffset($gsampler2DArray sampler, float3 P, float lod, int2 offset);
float textureLodOffset(sampler1DArrayShadow sampler, float3 P, float lod, int offset);
$gfloat4 textureProjLod($gsampler1D sampler, float2 P, float lod);
$gfloat4 textureProjLod($gsampler1D sampler, float4 P, float lod);
$gfloat4 textureProjLod($gsampler2D sampler, float3 P, float lod);
$gfloat4 textureProjLod($gsampler2D sampler, float4 P, float lod);
$gfloat4 textureProjLod($gsampler3D sampler, float4 P, float lod);
float textureProjLod(sampler1DShadow sampler, float4 P, float lod);
float textureProjLod(sampler2DShadow sampler, float4 P, float lod);
$gfloat4 textureProjLodOffset($gsampler1D sampler, float2 P, float lod, int offset);
$gfloat4 textureProjLodOffset($gsampler1D sampler, float4 P, float lod, int offset);
$gfloat4 textureProjLodOffset($gsampler2D sampler, float3 P, float lod, int2 offset);
$gfloat4 textureProjLodOffset($gsampler2D sampler, float4 P, float lod, int2 offset);
$gfloat4 textureProjLodOffset($gsampler3D sampler, float4 P, float lod, int3 offset);
float textureProjLodOffset(sampler1DShadow sampler, float4 P, float lod, int offset);
float textureProjLodOffset(sampler2DShadow sampler, float4 P, float lod, int2 offset);
$gfloat4 textureGrad($gsampler1D sampler, float P, float dPdx, float dPdy);
$gfloat4 textureGrad($gsampler2D sampler, float2 P, float2 dPdx, float2 dPdy);
$gfloat4 textureGrad($gsampler3D sampler, float3 P, float3 dPdx, float3 dPdy);
$gfloat4 textureGrad($gsamplerCube sampler, float3 P, float3 dPdx, float3 dPdy);
$gfloat4 textureGrad($gsampler2DRect sampler, float2 P, float2 dPdx, float2 dPdy);
float textureGrad(sampler2DRectShadow sampler, float3 P, float2 dPdx, float2 dPdy);
float textureGrad(sampler1DShadow sampler, float3 P, float dPdx, float dPdy);
float textureGrad(sampler2DShadow sampler, float3 P, float2 dPdx, float2 dPdy);
float textureGrad(samplerCubeShadow sampler, float4 P, float3 dPdx, float3 dPdy);
$gfloat4 textureGrad($gsampler1DArray sampler, float2 P, float dPdx, float dPdy);
$gfloat4 textureGrad($gsampler2DArray sampler, float3 P, float2 dPdx, float2 dPdy);
float textureGrad(sampler1DArrayShadow sampler, float3 P, float dPdx, float dPdy);
float textureGrad(sampler2DArrayShadow sampler, float4 P, float2 dPdx, float2 dPdy);
$gfloat4 textureGrad($gsamplerCubeArray sampler, float4 P, float3 dPdx, float3 dPdy);
$gfloat4 textureGradOffset($gsampler1D sampler, float P, float dPdx, float dPdy, int offset);
$gfloat4 textureGradOffset($gsampler2D sampler, float2 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureGradOffset($gsampler3D sampler, float3 P, float3 dPdx, float3 dPdy, int3 offset);
$gfloat4 textureGradOffset($gsampler2DRect sampler, float2 P, float2 dPdx, float2 dPdy, int2 offset);
float textureGradOffset(sampler2DRectShadow sampler, float3 P, float2 dPdx, float2 dPdy, int2 offset);
float textureGradOffset(sampler1DShadow sampler, float3 P, float dPdx, float dPdy, int offset );
float textureGradOffset(sampler2DShadow sampler, float3 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureGradOffset($gsampler1DArray sampler, float2 P, float dPdx, float dPdy, int offset);
$gfloat4 textureGradOffset($gsampler2DArray sampler, float3 P, float2 dPdx, float2 dPdy, int2 offset);
float textureGradOffset(sampler1DArrayShadow sampler, float3 P, float dPdx, float dPdy, int offset);
float textureGradOffset(sampler2DArrayShadow sampler, float4 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureProjGrad($gsampler1D sampler, float2 P, float dPdx, float dPdy);
$gfloat4 textureProjGrad($gsampler1D sampler, float4 P, float dPdx, float dPdy);
$gfloat4 textureProjGrad($gsampler2D sampler, float3 P, float2 dPdx, float2 dPdy);
$gfloat4 textureProjGrad($gsampler2D sampler, float4 P, float2 dPdx, float2 dPdy);
$gfloat4 textureProjGrad($gsampler3D sampler, float4 P, float3 dPdx, float3 dPdy);
$gfloat4 textureProjGrad($gsampler2DRect sampler, float3 P, float2 dPdx, float2 dPdy);
$gfloat4 textureProjGrad($gsampler2DRect sampler, float4 P, float2 dPdx, float2 dPdy);
float textureProjGrad(sampler2DRectShadow sampler, float4 P, float2 dPdx, float2 dPdy);
float textureProjGrad(sampler1DShadow sampler, float4 P, float dPdx, float dPdy);
float textureProjGrad(sampler2DShadow sampler, float4 P, float2 dPdx, float2 dPdy);
$gfloat4 textureProjGradOffset($gsampler1D sampler, float2 P, float dPdx, float dPdy, int offset);
$gfloat4 textureProjGradOffset($gsampler1D sampler, float4 P, float dPdx, float dPdy, int offset);
$gfloat4 textureProjGradOffset($gsampler2D sampler, float3 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureProjGradOffset($gsampler2D sampler, float4 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureProjGradOffset($gsampler2DRect sampler, float3 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureProjGradOffset($gsampler2DRect sampler, float4 P, float2 dPdx, float2 dPdy, int2 offset);
float textureProjGradOffset(sampler2DRectShadow sampler, float4 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureProjGradOffset($gsampler3D sampler, float4 P, float3 dPdx, float3 dPdy, int3 offset);
float textureProjGradOffset(sampler1DShadow sampler, float4 P, float dPdx, float dPdy, int offset);
float textureProjGradOffset(sampler2DShadow sampler, float4 P, float2 dPdx, float2 dPdy, int2 offset);
$gfloat4 textureGather($gsampler2D sampler, float2 P);
$gfloat4 textureGather($gsampler2D sampler, float2 P, int comp);
$gfloat4 textureGather($gsampler2DArray sampler, float3 P);
$gfloat4 textureGather($gsampler2DArray sampler, float3 P, int comp);
$gfloat4 textureGather($gsamplerCube sampler, float3 P);
$gfloat4 textureGather($gsamplerCube sampler, float3 P, int comp);
$gfloat4 textureGather($gsamplerCubeArray sampler, float4 P);
$gfloat4 textureGather($gsamplerCubeArray sampler, float4 P, int comp);
$gfloat4 textureGather($gsampler2DRect sampler, float2 P);
$gfloat4 textureGather($gsampler2DRect sampler, float2 P, int comp);
float4 textureGather(sampler2DShadow sampler, float2 P, float refZ);
float4 textureGather(sampler2DArrayShadow sampler, float3 P, float refZ);
float4 textureGather(samplerCubeShadow sampler, float3 P, float refZ);
float4 textureGather(samplerCubeArrayShadow sampler, float4 P, float refZ);
float4 textureGather(sampler2DRectShadow sampler, float2 P, float refZ);
$gfloat4 textureGatherOffset($gsampler2D sampler, float2 P, int2 offset);
$gfloat4 textureGatherOffset($gsampler2D sampler, float2 P, int2 offset, int comp);
$gfloat4 textureGatherOffset($gsampler2DArray sampler, float3 P, int2 offset);
$gfloat4 textureGatherOffset($gsampler2DArray sampler, float3 P, int2 offset, int comp);
$gfloat4 textureGatherOffset($gsampler2DRect sampler, float2 P, int2 offset);
$gfloat4 textureGatherOffset($gsampler2DRect sampler, float2 P, int2 offset, int comp);
float4 textureGatherOffset(sampler2DShadow sampler, float2 P, float refZ, int2 offset);
float4 textureGatherOffset(sampler2DArrayShadow sampler, float3 P, float refZ, int2 offset);
float4 textureGatherOffset(sampler2DRectShadow sampler, float2 P, float refZ, int2 offset);
$gfloat4 textureGatherOffsets($gsampler2D sampler, float2 P, int2 offsets[4]);
$gfloat4 textureGatherOffsets($gsampler2D sampler, float2 P, int2 offsets[4], int comp);
$gfloat4 textureGatherOffsets($gsampler2DArray sampler, float3 P, int2 offsets[4]);
$gfloat4 textureGatherOffsets($gsampler2DArray sampler, float3 P, int2 offsets[4], int comp);
$gfloat4 textureGatherOffsets($gsampler2DRect sampler, float2 P, int2 offsets[4]);
$gfloat4 textureGatherOffsets($gsampler2DRect sampler, float2 P, int2 offsets[4], int comp);
float4 textureGatherOffsets(sampler2DShadow sampler, float2 P, float refZ, int2 offsets[4]);
float4 textureGatherOffsets(sampler2DArrayShadow sampler, float3 P, float refZ, int2 offsets[4]);
float4 textureGatherOffsets(sampler2DRectShadow sampler, float2 P, float refZ, int2 offsets[4]);
uint atomicCounterIncrement(atomic_uint c);
uint atomicCounter(atomic_uint c);
uint atomicAdd(inout uint mem, uint data);
int atomicAdd(inout int mem, int data);
uint atomicMin(inout uint mem, uint data);
int atomicMin(inout int mem, int data);
uint atomicMax(inout uint mem, uint data);
int atomicMax(inout int mem, int data);
uint atomicAnd(inout uint mem, uint data);
int atomicAnd(inout int mem, int data);
uint atomicOr(inout uint mem, uint data);
int atomicOr(inout int mem, int data);
uint atomicXor(inout uint mem, uint data);
int atomicXor(inout int mem, int data);
uint atomicExchange(inout uint mem, uint data);
int atomicExchange(inout int mem, int data);
uint atomicCompSwap(inout uint mem, uint compare, uint data);
int atomicCompSwap(inout int mem, int compare, int data);
*/
// section 8.12 Additional Image Functions will go here if and when we add
// support for them
float4 imageLoad(image2D image, int2 P);
int4 imageLoad(iimage2D image, int2 P);
$genType dFdx($genType p);
$genType dFdy($genType p);
float interpolateAtSample(float interpolant, int sample);
float2 interpolateAtSample(float2 interpolant, int sample);
float3 interpolateAtSample(float3 interpolant, int sample);
float4 interpolateAtSample(float4 interpolant, int sample);
float interpolateAtOffset(float interpolant, float2 offset);
float2 interpolateAtOffset(float2 interpolant, float2 offset);
float3 interpolateAtOffset(float3 interpolant, float2 offset);
float4 interpolateAtOffset(float4 interpolant, float2 offset);

/*
$genType fwidth($genType p);
$genType fwidthCoarse($genType p);
$genType fwidthFine($genType p);
void barrier();
void memoryBarrier();
void memoryBarrierAtomicCounter();
void memoryBarrierBuffer();
void memoryBarrierShared();
void memoryBarrierImage();
void groupMemoryBarrier();
*/

)
