/*
 * Copyright 2016 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can
 * be found in the LICENSE file.
 *
 */

//
// This file was generated using the odd-merge rule.
//

#include "networks.h"
#include "common/macros.h"

//
//
//

#define M(n)   static struct hsg_op const mn##n[]
#define X(a,b) { HSG_OP_TYPE_CMP_XCHG, { a, b }}

//
//
//

#define LM(n)  { ARRAY_LENGTH_MACRO(mn##n), mn##n }

//
//
//

M(2) = {
  X(1,2)
};
M(3) = {
  X(1,2), X(2,3), X(1,2)
};
M(4) = {
  X(1,3), X(2,4), X(1,2), X(3,4)
};
M(5) = {
  X(1,3), X(3,5), X(1,3), X(2,4), X(2,3), X(4,5), X(1,2), X(3,4)
};
M(6) = {
  X(1,3), X(3,5), X(1,3), X(2,4), X(4,6), X(2,4), X(1,2), X(3,4), X(5,6)
};
M(7) = {
  X(1,5), X(3,7), X(1,3), X(5,7), X(2,4), X(4,6), X(2,4), X(2,3), X(4,5),
  X(6,7), X(1,2), X(3,4), X(5,6)
};
M(8) = {
  X(1,5), X(3,7), X(1,3), X(5,7), X(2,6), X(4,8), X(2,4), X(6,8), X(1,2),
  X(3,4), X(5,6), X(7,8)
};
M(9) = {
  X(1,5), X(5,9), X(1,5), X(3,7), X(3,5), X(7,9), X(1,3), X(5,7), X(2,6),
  X(4,8), X(2,4), X(6,8), X(2,3), X(4,5), X(6,7), X(8,9), X(1,2), X(3,4), X(5,6),
  X(7,8)
};
M(10) = {
  X(1,5), X(5,9), X(1,5), X(3,7), X(3,5), X(7,9), X(1,3), X(5,7), X(2,6),
  X(6,10), X(2,6), X(4,8), X(4,6), X(8,10), X(2,4), X(6,8), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10)
};
M(11) = {
  X(1,5), X(5,9), X(1,5), X(3,7), X(7,11), X(3,7), X(1,3), X(5,7), X(9,11),
  X(2,6), X(6,10), X(2,6), X(4,8), X(4,6), X(8,10), X(2,4), X(6,8), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10)
};
M(12) = {
  X(1,5), X(5,9), X(1,5), X(3,7), X(7,11), X(3,7), X(1,3), X(5,7), X(9,11),
  X(2,6), X(6,10), X(2,6), X(4,8), X(8,12), X(4,8), X(2,4), X(6,8), X(10,12),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12)
};
M(13) = {
  X(1,9), X(5,13), X(1,5), X(9,13), X(3,7), X(7,11), X(3,7), X(3,5), X(7,9),
  X(11,13), X(1,3), X(5,7), X(9,11), X(2,6), X(6,10), X(2,6), X(4,8), X(8,12),
  X(4,8), X(2,4), X(6,8), X(10,12), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12)
};
M(14) = {
  X(1,9), X(5,13), X(1,5), X(9,13), X(3,7), X(7,11), X(3,7), X(3,5), X(7,9),
  X(11,13), X(1,3), X(5,7), X(9,11), X(2,10), X(6,14), X(2,6), X(10,14), X(4,8),
  X(8,12), X(4,8), X(4,6), X(8,10), X(12,14), X(2,4), X(6,8), X(10,12), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14)
};
M(15) = {
  X(1,9), X(5,13), X(1,5), X(9,13), X(3,11), X(7,15), X(3,7), X(11,15), X(1,3),
  X(5,7), X(9,11), X(13,15), X(2,10), X(6,14), X(2,6), X(10,14), X(4,8), X(8,12),
  X(4,8), X(4,6), X(8,10), X(12,14), X(2,4), X(6,8), X(10,12), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14)
};
M(16) = {
  X(1,9), X(5,13), X(1,5), X(9,13), X(3,11), X(7,15), X(3,7), X(11,15), X(1,3),
  X(5,7), X(9,11), X(13,15), X(2,10), X(6,14), X(2,6), X(10,14), X(4,12),
  X(8,16), X(4,8), X(12,16), X(2,4), X(6,8), X(10,12), X(14,16), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16)
};
M(17) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(5,9), X(13,17), X(1,5), X(9,13), X(3,11),
  X(7,15), X(3,7), X(11,15), X(3,5), X(7,9), X(11,13), X(15,17), X(1,3), X(5,7),
  X(9,11), X(13,15), X(2,10), X(6,14), X(2,6), X(10,14), X(4,12), X(8,16),
  X(4,8), X(12,16), X(2,4), X(6,8), X(10,12), X(14,16), X(2,3), X(4,5), X(6,7),
  X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16)
};
M(18) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(5,9), X(13,17), X(1,5), X(9,13), X(3,11),
  X(7,15), X(3,7), X(11,15), X(3,5), X(7,9), X(11,13), X(15,17), X(1,3), X(5,7),
  X(9,11), X(13,15), X(2,10), X(10,18), X(2,10), X(6,14), X(6,10), X(14,18),
  X(2,6), X(10,14), X(4,12), X(8,16), X(4,8), X(12,16), X(4,6), X(8,10),
  X(12,14), X(16,18), X(2,4), X(6,8), X(10,12), X(14,16), X(1,2), X(3,4), X(5,6),
  X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18)
};
M(19) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(5,9), X(13,17), X(1,5), X(9,13), X(3,11),
  X(11,19), X(3,11), X(7,15), X(7,11), X(15,19), X(3,7), X(11,15), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(2,10), X(10,18), X(2,10), X(6,14),
  X(6,10), X(14,18), X(2,6), X(10,14), X(4,12), X(8,16), X(4,8), X(12,16),
  X(4,6), X(8,10), X(12,14), X(16,18), X(2,4), X(6,8), X(10,12), X(14,16),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18)
};
M(20) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(5,9), X(13,17), X(1,5), X(9,13), X(3,11),
  X(11,19), X(3,11), X(7,15), X(7,11), X(15,19), X(3,7), X(11,15), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(2,10), X(10,18), X(2,10), X(6,14),
  X(6,10), X(14,18), X(2,6), X(10,14), X(4,12), X(12,20), X(4,12), X(8,16),
  X(8,12), X(16,20), X(4,8), X(12,16), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20)
};
M(21) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(13,21), X(5,13), X(1,5), X(9,13),
  X(17,21), X(3,11), X(11,19), X(3,11), X(7,15), X(7,11), X(15,19), X(3,7),
  X(11,15), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(2,10), X(10,18), X(2,10), X(6,14), X(6,10),
  X(14,18), X(2,6), X(10,14), X(4,12), X(12,20), X(4,12), X(8,16), X(8,12),
  X(16,20), X(4,8), X(12,16), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20)
};
M(22) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(13,21), X(5,13), X(1,5), X(9,13),
  X(17,21), X(3,11), X(11,19), X(3,11), X(7,15), X(7,11), X(15,19), X(3,7),
  X(11,15), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(2,10), X(10,18), X(2,10), X(6,14), X(14,22),
  X(6,14), X(2,6), X(10,14), X(18,22), X(4,12), X(12,20), X(4,12), X(8,16),
  X(8,12), X(16,20), X(4,8), X(12,16), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(1,2), X(3,4), X(5,6),
  X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22)
};
M(23) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(13,21), X(5,13), X(1,5), X(9,13),
  X(17,21), X(3,11), X(11,19), X(3,11), X(7,15), X(15,23), X(7,15), X(3,7),
  X(11,15), X(19,23), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(2,10), X(10,18), X(2,10), X(6,14), X(14,22), X(6,14), X(2,6), X(10,14),
  X(18,22), X(4,12), X(12,20), X(4,12), X(8,16), X(8,12), X(16,20), X(4,8),
  X(12,16), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22)
};
M(24) = {
  X(1,9), X(9,17), X(1,9), X(5,13), X(13,21), X(5,13), X(1,5), X(9,13),
  X(17,21), X(3,11), X(11,19), X(3,11), X(7,15), X(15,23), X(7,15), X(3,7),
  X(11,15), X(19,23), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(2,10), X(10,18), X(2,10), X(6,14), X(14,22), X(6,14), X(2,6), X(10,14),
  X(18,22), X(4,12), X(12,20), X(4,12), X(8,16), X(16,24), X(8,16), X(4,8),
  X(12,16), X(20,24), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24)
};
M(25) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,13), X(13,21), X(5,13), X(5,9),
  X(13,17), X(21,25), X(1,5), X(9,13), X(17,21), X(3,11), X(11,19), X(3,11),
  X(7,15), X(15,23), X(7,15), X(3,7), X(11,15), X(19,23), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(2,10), X(10,18), X(2,10), X(6,14), X(14,22), X(6,14),
  X(2,6), X(10,14), X(18,22), X(4,12), X(12,20), X(4,12), X(8,16), X(16,24),
  X(8,16), X(4,8), X(12,16), X(20,24), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24)
};
M(26) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,13), X(13,21), X(5,13), X(5,9),
  X(13,17), X(21,25), X(1,5), X(9,13), X(17,21), X(3,11), X(11,19), X(3,11),
  X(7,15), X(15,23), X(7,15), X(3,7), X(11,15), X(19,23), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(2,18), X(10,26), X(2,10), X(18,26), X(6,14), X(14,22),
  X(6,14), X(6,10), X(14,18), X(22,26), X(2,6), X(10,14), X(18,22), X(4,12),
  X(12,20), X(4,12), X(8,16), X(16,24), X(8,16), X(4,8), X(12,16), X(20,24),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26)
};
M(27) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,13), X(13,21), X(5,13), X(5,9),
  X(13,17), X(21,25), X(1,5), X(9,13), X(17,21), X(3,19), X(11,27), X(3,11),
  X(19,27), X(7,15), X(15,23), X(7,15), X(7,11), X(15,19), X(23,27), X(3,7),
  X(11,15), X(19,23), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(2,18), X(10,26), X(2,10), X(18,26), X(6,14), X(14,22), X(6,14),
  X(6,10), X(14,18), X(22,26), X(2,6), X(10,14), X(18,22), X(4,12), X(12,20),
  X(4,12), X(8,16), X(16,24), X(8,16), X(4,8), X(12,16), X(20,24), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26)
};
M(28) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,13), X(13,21), X(5,13), X(5,9),
  X(13,17), X(21,25), X(1,5), X(9,13), X(17,21), X(3,19), X(11,27), X(3,11),
  X(19,27), X(7,15), X(15,23), X(7,15), X(7,11), X(15,19), X(23,27), X(3,7),
  X(11,15), X(19,23), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(2,18), X(10,26), X(2,10), X(18,26), X(6,14), X(14,22), X(6,14),
  X(6,10), X(14,18), X(22,26), X(2,6), X(10,14), X(18,22), X(4,20), X(12,28),
  X(4,12), X(20,28), X(8,16), X(16,24), X(8,16), X(8,12), X(16,20), X(24,28),
  X(4,8), X(12,16), X(20,24), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28)
};
M(29) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,21), X(13,29), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(11,27), X(3,11), X(19,27),
  X(7,15), X(15,23), X(7,15), X(7,11), X(15,19), X(23,27), X(3,7), X(11,15),
  X(19,23), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(2,18),
  X(10,26), X(2,10), X(18,26), X(6,14), X(14,22), X(6,14), X(6,10), X(14,18),
  X(22,26), X(2,6), X(10,14), X(18,22), X(4,20), X(12,28), X(4,12), X(20,28),
  X(8,16), X(16,24), X(8,16), X(8,12), X(16,20), X(24,28), X(4,8), X(12,16),
  X(20,24), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28)
};
M(30) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,21), X(13,29), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(11,27), X(3,11), X(19,27),
  X(7,15), X(15,23), X(7,15), X(7,11), X(15,19), X(23,27), X(3,7), X(11,15),
  X(19,23), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(2,18),
  X(10,26), X(2,10), X(18,26), X(6,22), X(14,30), X(6,14), X(22,30), X(2,6),
  X(10,14), X(18,22), X(26,30), X(4,20), X(12,28), X(4,12), X(20,28), X(8,16),
  X(16,24), X(8,16), X(8,12), X(16,20), X(24,28), X(4,8), X(12,16), X(20,24),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30)
};
M(31) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,21), X(13,29), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(11,27), X(3,11), X(19,27),
  X(7,23), X(15,31), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23), X(27,31),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(2,18), X(10,26), X(2,10), X(18,26), X(6,22), X(14,30), X(6,14), X(22,30),
  X(2,6), X(10,14), X(18,22), X(26,30), X(4,20), X(12,28), X(4,12), X(20,28),
  X(8,16), X(16,24), X(8,16), X(8,12), X(16,20), X(24,28), X(4,8), X(12,16),
  X(20,24), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30)
};
M(32) = {
  X(1,17), X(9,25), X(1,9), X(17,25), X(5,21), X(13,29), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(11,27), X(3,11), X(19,27),
  X(7,23), X(15,31), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23), X(27,31),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(2,18), X(10,26), X(2,10), X(18,26), X(6,22), X(14,30), X(6,14), X(22,30),
  X(2,6), X(10,14), X(18,22), X(26,30), X(4,20), X(12,28), X(4,12), X(20,28),
  X(8,24), X(16,32), X(8,16), X(24,32), X(4,8), X(12,16), X(20,24), X(28,32),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32)
};
M(33) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(13,29), X(5,13), X(21,29), X(5,9), X(13,17), X(21,25), X(29,33),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(11,27), X(3,11), X(19,27),
  X(7,23), X(15,31), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23), X(27,31),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(2,18), X(10,26), X(2,10), X(18,26), X(6,22), X(14,30), X(6,14), X(22,30),
  X(2,6), X(10,14), X(18,22), X(26,30), X(4,20), X(12,28), X(4,12), X(20,28),
  X(8,24), X(16,32), X(8,16), X(24,32), X(4,8), X(12,16), X(20,24), X(28,32),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32)
};
M(34) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(13,29), X(5,13), X(21,29), X(5,9), X(13,17), X(21,25), X(29,33),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(11,27), X(3,11), X(19,27),
  X(7,23), X(15,31), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23), X(27,31),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(2,18), X(18,34), X(2,18), X(10,26), X(10,18), X(26,34), X(2,10), X(18,26),
  X(6,22), X(14,30), X(6,14), X(22,30), X(6,10), X(14,18), X(22,26), X(30,34),
  X(2,6), X(10,14), X(18,22), X(26,30), X(4,20), X(12,28), X(4,12), X(20,28),
  X(8,24), X(16,32), X(8,16), X(24,32), X(4,8), X(12,16), X(20,24), X(28,32),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34)
};
M(35) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(13,29), X(5,13), X(21,29), X(5,9), X(13,17), X(21,25), X(29,33),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(19,35), X(3,19), X(11,27),
  X(11,19), X(27,35), X(3,11), X(19,27), X(7,23), X(15,31), X(7,15), X(23,31),
  X(7,11), X(15,19), X(23,27), X(31,35), X(3,7), X(11,15), X(19,23), X(27,31),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(2,18), X(18,34), X(2,18), X(10,26), X(10,18), X(26,34), X(2,10),
  X(18,26), X(6,22), X(14,30), X(6,14), X(22,30), X(6,10), X(14,18), X(22,26),
  X(30,34), X(2,6), X(10,14), X(18,22), X(26,30), X(4,20), X(12,28), X(4,12),
  X(20,28), X(8,24), X(16,32), X(8,16), X(24,32), X(4,8), X(12,16), X(20,24),
  X(28,32), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34)
};
M(36) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(13,29), X(5,13), X(21,29), X(5,9), X(13,17), X(21,25), X(29,33),
  X(1,5), X(9,13), X(17,21), X(25,29), X(3,19), X(19,35), X(3,19), X(11,27),
  X(11,19), X(27,35), X(3,11), X(19,27), X(7,23), X(15,31), X(7,15), X(23,31),
  X(7,11), X(15,19), X(23,27), X(31,35), X(3,7), X(11,15), X(19,23), X(27,31),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(2,18), X(18,34), X(2,18), X(10,26), X(10,18), X(26,34), X(2,10),
  X(18,26), X(6,22), X(14,30), X(6,14), X(22,30), X(6,10), X(14,18), X(22,26),
  X(30,34), X(2,6), X(10,14), X(18,22), X(26,30), X(4,20), X(20,36), X(4,20),
  X(12,28), X(12,20), X(28,36), X(4,12), X(20,28), X(8,24), X(16,32), X(8,16),
  X(24,32), X(8,12), X(16,20), X(24,28), X(32,36), X(4,8), X(12,16), X(20,24),
  X(28,32), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36)
};
M(37) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19),
  X(11,27), X(11,19), X(27,35), X(3,11), X(19,27), X(7,23), X(15,31), X(7,15),
  X(23,31), X(7,11), X(15,19), X(23,27), X(31,35), X(3,7), X(11,15), X(19,23),
  X(27,31), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(2,18), X(18,34), X(2,18), X(10,26), X(10,18),
  X(26,34), X(2,10), X(18,26), X(6,22), X(14,30), X(6,14), X(22,30), X(6,10),
  X(14,18), X(22,26), X(30,34), X(2,6), X(10,14), X(18,22), X(26,30), X(4,20),
  X(20,36), X(4,20), X(12,28), X(12,20), X(28,36), X(4,12), X(20,28), X(8,24),
  X(16,32), X(8,16), X(24,32), X(8,12), X(16,20), X(24,28), X(32,36), X(4,8),
  X(12,16), X(20,24), X(28,32), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36)
};
M(38) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19),
  X(11,27), X(11,19), X(27,35), X(3,11), X(19,27), X(7,23), X(15,31), X(7,15),
  X(23,31), X(7,11), X(15,19), X(23,27), X(31,35), X(3,7), X(11,15), X(19,23),
  X(27,31), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(2,18), X(18,34), X(2,18), X(10,26), X(10,18),
  X(26,34), X(2,10), X(18,26), X(6,22), X(22,38), X(6,22), X(14,30), X(14,22),
  X(30,38), X(6,14), X(22,30), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(4,20), X(20,36), X(4,20), X(12,28), X(12,20), X(28,36), X(4,12), X(20,28),
  X(8,24), X(16,32), X(8,16), X(24,32), X(8,12), X(16,20), X(24,28), X(32,36),
  X(4,8), X(12,16), X(20,24), X(28,32), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38)
};
M(39) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19),
  X(11,27), X(11,19), X(27,35), X(3,11), X(19,27), X(7,23), X(23,39), X(7,23),
  X(15,31), X(15,23), X(31,39), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(2,18), X(18,34), X(2,18), X(10,26),
  X(10,18), X(26,34), X(2,10), X(18,26), X(6,22), X(22,38), X(6,22), X(14,30),
  X(14,22), X(30,38), X(6,14), X(22,30), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(4,20), X(20,36), X(4,20), X(12,28), X(12,20), X(28,36), X(4,12),
  X(20,28), X(8,24), X(16,32), X(8,16), X(24,32), X(8,12), X(16,20), X(24,28),
  X(32,36), X(4,8), X(12,16), X(20,24), X(28,32), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38)
};
M(40) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(9,17), X(25,33), X(1,9), X(17,25),
  X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13), X(21,29),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19),
  X(11,27), X(11,19), X(27,35), X(3,11), X(19,27), X(7,23), X(23,39), X(7,23),
  X(15,31), X(15,23), X(31,39), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(2,18), X(18,34), X(2,18), X(10,26),
  X(10,18), X(26,34), X(2,10), X(18,26), X(6,22), X(22,38), X(6,22), X(14,30),
  X(14,22), X(30,38), X(6,14), X(22,30), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(4,20), X(20,36), X(4,20), X(12,28), X(12,20), X(28,36), X(4,12),
  X(20,28), X(8,24), X(24,40), X(8,24), X(16,32), X(16,24), X(32,40), X(8,16),
  X(24,32), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40)
};
M(41) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13),
  X(21,29), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19), X(11,27), X(11,19),
  X(27,35), X(3,11), X(19,27), X(7,23), X(23,39), X(7,23), X(15,31), X(15,23),
  X(31,39), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(2,18), X(18,34), X(2,18), X(10,26),
  X(10,18), X(26,34), X(2,10), X(18,26), X(6,22), X(22,38), X(6,22), X(14,30),
  X(14,22), X(30,38), X(6,14), X(22,30), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(4,20), X(20,36), X(4,20), X(12,28), X(12,20), X(28,36), X(4,12),
  X(20,28), X(8,24), X(24,40), X(8,24), X(16,32), X(16,24), X(32,40), X(8,16),
  X(24,32), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40)
};
M(42) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13),
  X(21,29), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19), X(11,27), X(11,19),
  X(27,35), X(3,11), X(19,27), X(7,23), X(23,39), X(7,23), X(15,31), X(15,23),
  X(31,39), X(7,15), X(23,31), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(2,18), X(18,34), X(2,18), X(10,26),
  X(26,42), X(10,26), X(2,10), X(18,26), X(34,42), X(6,22), X(22,38), X(6,22),
  X(14,30), X(14,22), X(30,38), X(6,14), X(22,30), X(6,10), X(14,18), X(22,26),
  X(30,34), X(38,42), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(4,20),
  X(20,36), X(4,20), X(12,28), X(12,20), X(28,36), X(4,12), X(20,28), X(8,24),
  X(24,40), X(8,24), X(16,32), X(16,24), X(32,40), X(8,16), X(24,32), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42)
};
M(43) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13),
  X(21,29), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19), X(11,27), X(27,43),
  X(11,27), X(3,11), X(19,27), X(35,43), X(7,23), X(23,39), X(7,23), X(15,31),
  X(15,23), X(31,39), X(7,15), X(23,31), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(2,18), X(18,34), X(2,18), X(10,26), X(26,42), X(10,26), X(2,10),
  X(18,26), X(34,42), X(6,22), X(22,38), X(6,22), X(14,30), X(14,22), X(30,38),
  X(6,14), X(22,30), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(4,20), X(20,36), X(4,20), X(12,28),
  X(12,20), X(28,36), X(4,12), X(20,28), X(8,24), X(24,40), X(8,24), X(16,32),
  X(16,24), X(32,40), X(8,16), X(24,32), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(2,3), X(4,5), X(6,7),
  X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23),
  X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39),
  X(40,41), X(42,43), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42)
};
M(44) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(13,21), X(29,37), X(5,13),
  X(21,29), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(3,19), X(19,35), X(3,19), X(11,27), X(27,43),
  X(11,27), X(3,11), X(19,27), X(35,43), X(7,23), X(23,39), X(7,23), X(15,31),
  X(15,23), X(31,39), X(7,15), X(23,31), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(2,18), X(18,34), X(2,18), X(10,26), X(26,42), X(10,26), X(2,10),
  X(18,26), X(34,42), X(6,22), X(22,38), X(6,22), X(14,30), X(14,22), X(30,38),
  X(6,14), X(22,30), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(4,20), X(20,36), X(4,20), X(12,28),
  X(28,44), X(12,28), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24),
  X(16,32), X(16,24), X(32,40), X(8,16), X(24,32), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44)
};
M(45) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(29,45), X(13,29), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(3,19), X(19,35), X(3,19), X(11,27), X(27,43), X(11,27), X(3,11), X(19,27),
  X(35,43), X(7,23), X(23,39), X(7,23), X(15,31), X(15,23), X(31,39), X(7,15),
  X(23,31), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21),
  X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(2,18), X(18,34), X(2,18), X(10,26), X(26,42), X(10,26), X(2,10),
  X(18,26), X(34,42), X(6,22), X(22,38), X(6,22), X(14,30), X(14,22), X(30,38),
  X(6,14), X(22,30), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(4,20), X(20,36), X(4,20), X(12,28),
  X(28,44), X(12,28), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24),
  X(16,32), X(16,24), X(32,40), X(8,16), X(24,32), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44)
};
M(46) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(29,45), X(13,29), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(3,19), X(19,35), X(3,19), X(11,27), X(27,43), X(11,27), X(3,11), X(19,27),
  X(35,43), X(7,23), X(23,39), X(7,23), X(15,31), X(15,23), X(31,39), X(7,15),
  X(23,31), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21),
  X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(2,18), X(18,34), X(2,18), X(10,26), X(26,42), X(10,26), X(2,10),
  X(18,26), X(34,42), X(6,22), X(22,38), X(6,22), X(14,30), X(30,46), X(14,30),
  X(6,14), X(22,30), X(38,46), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(4,20), X(20,36), X(4,20), X(12,28), X(28,44), X(12,28), X(4,12),
  X(20,28), X(36,44), X(8,24), X(24,40), X(8,24), X(16,32), X(16,24), X(32,40),
  X(8,16), X(24,32), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46)
};
M(47) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(29,45), X(13,29), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(3,19), X(19,35), X(3,19), X(11,27), X(27,43), X(11,27), X(3,11), X(19,27),
  X(35,43), X(7,23), X(23,39), X(7,23), X(15,31), X(31,47), X(15,31), X(7,15),
  X(23,31), X(39,47), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(2,18), X(18,34), X(2,18), X(10,26),
  X(26,42), X(10,26), X(2,10), X(18,26), X(34,42), X(6,22), X(22,38), X(6,22),
  X(14,30), X(30,46), X(14,30), X(6,14), X(22,30), X(38,46), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(4,20), X(20,36), X(4,20), X(12,28),
  X(28,44), X(12,28), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24),
  X(16,32), X(16,24), X(32,40), X(8,16), X(24,32), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(2,3), X(4,5), X(6,7),
  X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23),
  X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39),
  X(40,41), X(42,43), X(44,45), X(46,47), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46)
};
M(48) = {
  X(1,17), X(17,33), X(1,17), X(9,25), X(25,41), X(9,25), X(1,9), X(17,25),
  X(33,41), X(5,21), X(21,37), X(5,21), X(13,29), X(29,45), X(13,29), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(3,19), X(19,35), X(3,19), X(11,27), X(27,43), X(11,27), X(3,11), X(19,27),
  X(35,43), X(7,23), X(23,39), X(7,23), X(15,31), X(31,47), X(15,31), X(7,15),
  X(23,31), X(39,47), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(2,18), X(18,34), X(2,18), X(10,26),
  X(26,42), X(10,26), X(2,10), X(18,26), X(34,42), X(6,22), X(22,38), X(6,22),
  X(14,30), X(30,46), X(14,30), X(6,14), X(22,30), X(38,46), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(4,20), X(20,36), X(4,20), X(12,28),
  X(28,44), X(12,28), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24),
  X(16,32), X(32,48), X(16,32), X(8,16), X(24,32), X(40,48), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48)
};
M(49) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,21), X(21,37), X(5,21),
  X(13,29), X(29,45), X(13,29), X(5,13), X(21,29), X(37,45), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(3,19), X(19,35), X(3,19), X(11,27), X(27,43), X(11,27),
  X(3,11), X(19,27), X(35,43), X(7,23), X(23,39), X(7,23), X(15,31), X(31,47),
  X(15,31), X(7,15), X(23,31), X(39,47), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(2,18), X(18,34), X(2,18), X(10,26), X(26,42), X(10,26),
  X(2,10), X(18,26), X(34,42), X(6,22), X(22,38), X(6,22), X(14,30), X(30,46),
  X(14,30), X(6,14), X(22,30), X(38,46), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(4,20), X(20,36), X(4,20), X(12,28), X(28,44), X(12,28),
  X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24), X(16,32), X(32,48),
  X(16,32), X(8,16), X(24,32), X(40,48), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48)
};
M(50) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,21), X(21,37), X(5,21),
  X(13,29), X(29,45), X(13,29), X(5,13), X(21,29), X(37,45), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(3,19), X(19,35), X(3,19), X(11,27), X(27,43), X(11,27),
  X(3,11), X(19,27), X(35,43), X(7,23), X(23,39), X(7,23), X(15,31), X(31,47),
  X(15,31), X(7,15), X(23,31), X(39,47), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(2,34), X(18,50), X(2,18), X(34,50), X(10,26), X(26,42),
  X(10,26), X(10,18), X(26,34), X(42,50), X(2,10), X(18,26), X(34,42), X(6,22),
  X(22,38), X(6,22), X(14,30), X(30,46), X(14,30), X(6,14), X(22,30), X(38,46),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(4,20), X(20,36), X(4,20), X(12,28),
  X(28,44), X(12,28), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24),
  X(16,32), X(32,48), X(16,32), X(8,16), X(24,32), X(40,48), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50)
};
M(51) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,21), X(21,37), X(5,21),
  X(13,29), X(29,45), X(13,29), X(5,13), X(21,29), X(37,45), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(3,35), X(19,51), X(3,19), X(35,51), X(11,27), X(27,43),
  X(11,27), X(11,19), X(27,35), X(43,51), X(3,11), X(19,27), X(35,43), X(7,23),
  X(23,39), X(7,23), X(15,31), X(31,47), X(15,31), X(7,15), X(23,31), X(39,47),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(2,34), X(18,50), X(2,18), X(34,50), X(10,26), X(26,42), X(10,26),
  X(10,18), X(26,34), X(42,50), X(2,10), X(18,26), X(34,42), X(6,22), X(22,38),
  X(6,22), X(14,30), X(30,46), X(14,30), X(6,14), X(22,30), X(38,46), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(4,20), X(20,36), X(4,20), X(12,28), X(28,44),
  X(12,28), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24), X(16,32),
  X(32,48), X(16,32), X(8,16), X(24,32), X(40,48), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50)
};
M(52) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,21), X(21,37), X(5,21),
  X(13,29), X(29,45), X(13,29), X(5,13), X(21,29), X(37,45), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(3,35), X(19,51), X(3,19), X(35,51), X(11,27), X(27,43),
  X(11,27), X(11,19), X(27,35), X(43,51), X(3,11), X(19,27), X(35,43), X(7,23),
  X(23,39), X(7,23), X(15,31), X(31,47), X(15,31), X(7,15), X(23,31), X(39,47),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(2,34), X(18,50), X(2,18), X(34,50), X(10,26), X(26,42), X(10,26),
  X(10,18), X(26,34), X(42,50), X(2,10), X(18,26), X(34,42), X(6,22), X(22,38),
  X(6,22), X(14,30), X(30,46), X(14,30), X(6,14), X(22,30), X(38,46), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(4,36), X(20,52), X(4,20), X(36,52), X(12,28),
  X(28,44), X(12,28), X(12,20), X(28,36), X(44,52), X(4,12), X(20,28), X(36,44),
  X(8,24), X(24,40), X(8,24), X(16,32), X(32,48), X(16,32), X(8,16), X(24,32),
  X(40,48), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52)
};
M(53) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,37), X(21,53), X(5,21),
  X(37,53), X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(3,35), X(19,51), X(3,19), X(35,51), X(11,27), X(27,43), X(11,27),
  X(11,19), X(27,35), X(43,51), X(3,11), X(19,27), X(35,43), X(7,23), X(23,39),
  X(7,23), X(15,31), X(31,47), X(15,31), X(7,15), X(23,31), X(39,47), X(7,11),
  X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21),
  X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(2,34), X(18,50), X(2,18),
  X(34,50), X(10,26), X(26,42), X(10,26), X(10,18), X(26,34), X(42,50), X(2,10),
  X(18,26), X(34,42), X(6,22), X(22,38), X(6,22), X(14,30), X(30,46), X(14,30),
  X(6,14), X(22,30), X(38,46), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(4,36),
  X(20,52), X(4,20), X(36,52), X(12,28), X(28,44), X(12,28), X(12,20), X(28,36),
  X(44,52), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24), X(16,32),
  X(32,48), X(16,32), X(8,16), X(24,32), X(40,48), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52)
};
M(54) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,37), X(21,53), X(5,21),
  X(37,53), X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(3,35), X(19,51), X(3,19), X(35,51), X(11,27), X(27,43), X(11,27),
  X(11,19), X(27,35), X(43,51), X(3,11), X(19,27), X(35,43), X(7,23), X(23,39),
  X(7,23), X(15,31), X(31,47), X(15,31), X(7,15), X(23,31), X(39,47), X(7,11),
  X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21),
  X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(2,34), X(18,50), X(2,18),
  X(34,50), X(10,26), X(26,42), X(10,26), X(10,18), X(26,34), X(42,50), X(2,10),
  X(18,26), X(34,42), X(6,38), X(22,54), X(6,22), X(38,54), X(14,30), X(30,46),
  X(14,30), X(14,22), X(30,38), X(46,54), X(6,14), X(22,30), X(38,46), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(4,36), X(20,52),
  X(4,20), X(36,52), X(12,28), X(28,44), X(12,28), X(12,20), X(28,36), X(44,52),
  X(4,12), X(20,28), X(36,44), X(8,24), X(24,40), X(8,24), X(16,32), X(32,48),
  X(16,32), X(8,16), X(24,32), X(40,48), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54)
};
M(55) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,37), X(21,53), X(5,21),
  X(37,53), X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(3,35), X(19,51), X(3,19), X(35,51), X(11,27), X(27,43), X(11,27),
  X(11,19), X(27,35), X(43,51), X(3,11), X(19,27), X(35,43), X(7,39), X(23,55),
  X(7,23), X(39,55), X(15,31), X(31,47), X(15,31), X(15,23), X(31,39), X(47,55),
  X(7,15), X(23,31), X(39,47), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(2,34), X(18,50), X(2,18), X(34,50), X(10,26), X(26,42), X(10,26), X(10,18),
  X(26,34), X(42,50), X(2,10), X(18,26), X(34,42), X(6,38), X(22,54), X(6,22),
  X(38,54), X(14,30), X(30,46), X(14,30), X(14,22), X(30,38), X(46,54), X(6,14),
  X(22,30), X(38,46), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(4,36), X(20,52), X(4,20), X(36,52), X(12,28), X(28,44), X(12,28),
  X(12,20), X(28,36), X(44,52), X(4,12), X(20,28), X(36,44), X(8,24), X(24,40),
  X(8,24), X(16,32), X(32,48), X(16,32), X(8,16), X(24,32), X(40,48), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(2,3), X(4,5), X(6,7),
  X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23),
  X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39),
  X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54)
};
M(56) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,25), X(25,41), X(9,25), X(9,17),
  X(25,33), X(41,49), X(1,9), X(17,25), X(33,41), X(5,37), X(21,53), X(5,21),
  X(37,53), X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13),
  X(21,29), X(37,45), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(3,35), X(19,51), X(3,19), X(35,51), X(11,27), X(27,43), X(11,27),
  X(11,19), X(27,35), X(43,51), X(3,11), X(19,27), X(35,43), X(7,39), X(23,55),
  X(7,23), X(39,55), X(15,31), X(31,47), X(15,31), X(15,23), X(31,39), X(47,55),
  X(7,15), X(23,31), X(39,47), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(2,34), X(18,50), X(2,18), X(34,50), X(10,26), X(26,42), X(10,26), X(10,18),
  X(26,34), X(42,50), X(2,10), X(18,26), X(34,42), X(6,38), X(22,54), X(6,22),
  X(38,54), X(14,30), X(30,46), X(14,30), X(14,22), X(30,38), X(46,54), X(6,14),
  X(22,30), X(38,46), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(4,36), X(20,52), X(4,20), X(36,52), X(12,28), X(28,44), X(12,28),
  X(12,20), X(28,36), X(44,52), X(4,12), X(20,28), X(36,44), X(8,40), X(24,56),
  X(8,24), X(40,56), X(16,32), X(32,48), X(16,32), X(16,24), X(32,40), X(48,56),
  X(8,16), X(24,32), X(40,48), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56)
};
M(57) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13), X(21,29),
  X(37,45), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(3,35),
  X(19,51), X(3,19), X(35,51), X(11,27), X(27,43), X(11,27), X(11,19), X(27,35),
  X(43,51), X(3,11), X(19,27), X(35,43), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,31), X(31,47), X(15,31), X(15,23), X(31,39), X(47,55), X(7,15), X(23,31),
  X(39,47), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(2,34), X(18,50), X(2,18), X(34,50),
  X(10,26), X(26,42), X(10,26), X(10,18), X(26,34), X(42,50), X(2,10), X(18,26),
  X(34,42), X(6,38), X(22,54), X(6,22), X(38,54), X(14,30), X(30,46), X(14,30),
  X(14,22), X(30,38), X(46,54), X(6,14), X(22,30), X(38,46), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(4,36), X(20,52), X(4,20),
  X(36,52), X(12,28), X(28,44), X(12,28), X(12,20), X(28,36), X(44,52), X(4,12),
  X(20,28), X(36,44), X(8,40), X(24,56), X(8,24), X(40,56), X(16,32), X(32,48),
  X(16,32), X(16,24), X(32,40), X(48,56), X(8,16), X(24,32), X(40,48), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56)
};
M(58) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13), X(21,29),
  X(37,45), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(3,35),
  X(19,51), X(3,19), X(35,51), X(11,27), X(27,43), X(11,27), X(11,19), X(27,35),
  X(43,51), X(3,11), X(19,27), X(35,43), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,31), X(31,47), X(15,31), X(15,23), X(31,39), X(47,55), X(7,15), X(23,31),
  X(39,47), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(2,34), X(18,50), X(2,18), X(34,50),
  X(10,42), X(26,58), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42), X(50,58),
  X(6,38), X(22,54), X(6,22), X(38,54), X(14,30), X(30,46), X(14,30), X(14,22),
  X(30,38), X(46,54), X(6,14), X(22,30), X(38,46), X(6,10), X(14,18), X(22,26),
  X(30,34), X(38,42), X(46,50), X(54,58), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(4,36), X(20,52), X(4,20), X(36,52), X(12,28),
  X(28,44), X(12,28), X(12,20), X(28,36), X(44,52), X(4,12), X(20,28), X(36,44),
  X(8,40), X(24,56), X(8,24), X(40,56), X(16,32), X(32,48), X(16,32), X(16,24),
  X(32,40), X(48,56), X(8,16), X(24,32), X(40,48), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58)
};
M(59) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13), X(21,29),
  X(37,45), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(3,35),
  X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(3,11),
  X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55), X(15,31),
  X(31,47), X(15,31), X(15,23), X(31,39), X(47,55), X(7,15), X(23,31), X(39,47),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(2,34), X(18,50), X(2,18),
  X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42),
  X(50,58), X(6,38), X(22,54), X(6,22), X(38,54), X(14,30), X(30,46), X(14,30),
  X(14,22), X(30,38), X(46,54), X(6,14), X(22,30), X(38,46), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(4,36), X(20,52), X(4,20), X(36,52),
  X(12,28), X(28,44), X(12,28), X(12,20), X(28,36), X(44,52), X(4,12), X(20,28),
  X(36,44), X(8,40), X(24,56), X(8,24), X(40,56), X(16,32), X(32,48), X(16,32),
  X(16,24), X(32,40), X(48,56), X(8,16), X(24,32), X(40,48), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58)
};
M(60) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,29), X(29,45), X(13,29), X(13,21), X(29,37), X(45,53), X(5,13), X(21,29),
  X(37,45), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(3,35),
  X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(3,11),
  X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55), X(15,31),
  X(31,47), X(15,31), X(15,23), X(31,39), X(47,55), X(7,15), X(23,31), X(39,47),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(2,34), X(18,50), X(2,18),
  X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42),
  X(50,58), X(6,38), X(22,54), X(6,22), X(38,54), X(14,30), X(30,46), X(14,30),
  X(14,22), X(30,38), X(46,54), X(6,14), X(22,30), X(38,46), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(4,36), X(20,52), X(4,20), X(36,52),
  X(12,44), X(28,60), X(12,28), X(44,60), X(4,12), X(20,28), X(36,44), X(52,60),
  X(8,40), X(24,56), X(8,24), X(40,56), X(16,32), X(32,48), X(16,32), X(16,24),
  X(32,40), X(48,56), X(8,16), X(24,32), X(40,48), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60)
};
M(61) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,31), X(31,47), X(15,31), X(15,23), X(31,39), X(47,55), X(7,15), X(23,31),
  X(39,47), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(2,34), X(18,50), X(2,18),
  X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42),
  X(50,58), X(6,38), X(22,54), X(6,22), X(38,54), X(14,30), X(30,46), X(14,30),
  X(14,22), X(30,38), X(46,54), X(6,14), X(22,30), X(38,46), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(4,36), X(20,52), X(4,20), X(36,52),
  X(12,44), X(28,60), X(12,28), X(44,60), X(4,12), X(20,28), X(36,44), X(52,60),
  X(8,40), X(24,56), X(8,24), X(40,56), X(16,32), X(32,48), X(16,32), X(16,24),
  X(32,40), X(48,56), X(8,16), X(24,32), X(40,48), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60)
};
M(62) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,31), X(31,47), X(15,31), X(15,23), X(31,39), X(47,55), X(7,15), X(23,31),
  X(39,47), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(2,34), X(18,50), X(2,18),
  X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42),
  X(50,58), X(6,38), X(22,54), X(6,22), X(38,54), X(14,46), X(30,62), X(14,30),
  X(46,62), X(6,14), X(22,30), X(38,46), X(54,62), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(4,36), X(20,52), X(4,20),
  X(36,52), X(12,44), X(28,60), X(12,28), X(44,60), X(4,12), X(20,28), X(36,44),
  X(52,60), X(8,40), X(24,56), X(8,24), X(40,56), X(16,32), X(32,48), X(16,32),
  X(16,24), X(32,40), X(48,56), X(8,16), X(24,32), X(40,48), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62)
};
M(63) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(2,34), X(18,50), X(2,18), X(34,50), X(10,42), X(26,58), X(10,26), X(42,58),
  X(2,10), X(18,26), X(34,42), X(50,58), X(6,38), X(22,54), X(6,22), X(38,54),
  X(14,46), X(30,62), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46), X(54,62),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(4,36), X(20,52), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60),
  X(4,12), X(20,28), X(36,44), X(52,60), X(8,40), X(24,56), X(8,24), X(40,56),
  X(16,32), X(32,48), X(16,32), X(16,24), X(32,40), X(48,56), X(8,16), X(24,32),
  X(40,48), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(2,3), X(4,5), X(6,7),
  X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23),
  X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39),
  X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55),
  X(56,57), X(58,59), X(60,61), X(62,63), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62)
};
M(64) = {
  X(1,33), X(17,49), X(1,17), X(33,49), X(9,41), X(25,57), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(2,34), X(18,50), X(2,18), X(34,50), X(10,42), X(26,58), X(10,26), X(42,58),
  X(2,10), X(18,26), X(34,42), X(50,58), X(6,38), X(22,54), X(6,22), X(38,54),
  X(14,46), X(30,62), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46), X(54,62),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(4,36), X(20,52), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60),
  X(4,12), X(20,28), X(36,44), X(52,60), X(8,40), X(24,56), X(8,24), X(40,56),
  X(16,48), X(32,64), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48), X(56,64),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64)
};
M(65) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(2,34), X(18,50), X(2,18), X(34,50), X(10,42), X(26,58), X(10,26), X(42,58),
  X(2,10), X(18,26), X(34,42), X(50,58), X(6,38), X(22,54), X(6,22), X(38,54),
  X(14,46), X(30,62), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46), X(54,62),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(4,36), X(20,52), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60),
  X(4,12), X(20,28), X(36,44), X(52,60), X(8,40), X(24,56), X(8,24), X(40,56),
  X(16,48), X(32,64), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48), X(56,64),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64)
};
M(66) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(19,51), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18), X(34,50),
  X(10,42), X(26,58), X(10,26), X(42,58), X(10,18), X(26,34), X(42,50), X(58,66),
  X(2,10), X(18,26), X(34,42), X(50,58), X(6,38), X(22,54), X(6,22), X(38,54),
  X(14,46), X(30,62), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46), X(54,62),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(4,36), X(20,52), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60),
  X(4,12), X(20,28), X(36,44), X(52,60), X(8,40), X(24,56), X(8,24), X(40,56),
  X(16,48), X(32,64), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48), X(56,64),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66)
};
M(67) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(35,67), X(3,35), X(19,51), X(19,35), X(51,67), X(3,19), X(35,51),
  X(11,43), X(27,59), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18),
  X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(10,18), X(26,34), X(42,50),
  X(58,66), X(2,10), X(18,26), X(34,42), X(50,58), X(6,38), X(22,54), X(6,22),
  X(38,54), X(14,46), X(30,62), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46),
  X(54,62), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58),
  X(62,66), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(4,36), X(20,52), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28),
  X(44,60), X(4,12), X(20,28), X(36,44), X(52,60), X(8,40), X(24,56), X(8,24),
  X(40,56), X(16,48), X(32,64), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48),
  X(56,64), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62),
  X(64,66), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66)
};
M(68) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(21,53), X(5,21), X(37,53),
  X(13,45), X(29,61), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(3,35), X(35,67), X(3,35), X(19,51), X(19,35), X(51,67), X(3,19), X(35,51),
  X(11,43), X(27,59), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67),
  X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18),
  X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(10,18), X(26,34), X(42,50),
  X(58,66), X(2,10), X(18,26), X(34,42), X(50,58), X(6,38), X(22,54), X(6,22),
  X(38,54), X(14,46), X(30,62), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46),
  X(54,62), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58),
  X(62,66), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(4,36), X(36,68), X(4,36), X(20,52), X(20,36), X(52,68), X(4,20),
  X(36,52), X(12,44), X(28,60), X(12,28), X(44,60), X(12,20), X(28,36), X(44,52),
  X(60,68), X(4,12), X(20,28), X(36,44), X(52,60), X(8,40), X(24,56), X(8,24),
  X(40,56), X(16,48), X(32,64), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48),
  X(56,64), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(64,68), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68)
};
M(69) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(37,69), X(5,37), X(21,53),
  X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29), X(45,61),
  X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35), X(51,67), X(3,19),
  X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51),
  X(59,67), X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23),
  X(39,55), X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47),
  X(55,63), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59),
  X(63,67), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(2,34), X(34,66), X(2,34), X(18,50), X(18,34),
  X(50,66), X(2,18), X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(10,18),
  X(26,34), X(42,50), X(58,66), X(2,10), X(18,26), X(34,42), X(50,58), X(6,38),
  X(22,54), X(6,22), X(38,54), X(14,46), X(30,62), X(14,30), X(46,62), X(6,14),
  X(22,30), X(38,46), X(54,62), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(4,36), X(36,68), X(4,36), X(20,52), X(20,36),
  X(52,68), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60), X(12,20),
  X(28,36), X(44,52), X(60,68), X(4,12), X(20,28), X(36,44), X(52,60), X(8,40),
  X(24,56), X(8,24), X(40,56), X(16,48), X(32,64), X(16,32), X(48,64), X(8,16),
  X(24,32), X(40,48), X(56,64), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44),
  X(48,52), X(56,60), X(64,68), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(62,64), X(66,68), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68)
};
M(70) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(37,69), X(5,37), X(21,53),
  X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29), X(45,61),
  X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35), X(51,67), X(3,19),
  X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51),
  X(59,67), X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(23,55), X(7,23),
  X(39,55), X(15,47), X(31,63), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47),
  X(55,63), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59),
  X(63,67), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(2,34), X(34,66), X(2,34), X(18,50), X(18,34),
  X(50,66), X(2,18), X(34,50), X(10,42), X(26,58), X(10,26), X(42,58), X(10,18),
  X(26,34), X(42,50), X(58,66), X(2,10), X(18,26), X(34,42), X(50,58), X(6,38),
  X(38,70), X(6,38), X(22,54), X(22,38), X(54,70), X(6,22), X(38,54), X(14,46),
  X(30,62), X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(6,14),
  X(22,30), X(38,46), X(54,62), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(4,36), X(36,68), X(4,36), X(20,52),
  X(20,36), X(52,68), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60),
  X(12,20), X(28,36), X(44,52), X(60,68), X(4,12), X(20,28), X(36,44), X(52,60),
  X(8,40), X(24,56), X(8,24), X(40,56), X(16,48), X(32,64), X(16,32), X(48,64),
  X(8,16), X(24,32), X(40,48), X(56,64), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70)
};
M(71) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(37,69), X(5,37), X(21,53),
  X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29), X(45,61),
  X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35), X(51,67), X(3,19),
  X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51),
  X(59,67), X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(39,71), X(7,39),
  X(23,55), X(23,39), X(55,71), X(7,23), X(39,55), X(15,47), X(31,63), X(15,31),
  X(47,63), X(15,23), X(31,39), X(47,55), X(63,71), X(7,15), X(23,31), X(39,47),
  X(55,63), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(2,34), X(34,66), X(2,34), X(18,50),
  X(18,34), X(50,66), X(2,18), X(34,50), X(10,42), X(26,58), X(10,26), X(42,58),
  X(10,18), X(26,34), X(42,50), X(58,66), X(2,10), X(18,26), X(34,42), X(50,58),
  X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70), X(6,22), X(38,54),
  X(14,46), X(30,62), X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70),
  X(6,14), X(22,30), X(38,46), X(54,62), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(4,36), X(36,68), X(4,36),
  X(20,52), X(20,36), X(52,68), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28),
  X(44,60), X(12,20), X(28,36), X(44,52), X(60,68), X(4,12), X(20,28), X(36,44),
  X(52,60), X(8,40), X(24,56), X(8,24), X(40,56), X(16,48), X(32,64), X(16,32),
  X(48,64), X(8,16), X(24,32), X(40,48), X(56,64), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70)
};
M(72) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(25,57), X(9,25), X(41,57), X(9,17), X(25,33), X(41,49), X(57,65),
  X(1,9), X(17,25), X(33,41), X(49,57), X(5,37), X(37,69), X(5,37), X(21,53),
  X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29), X(45,61),
  X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45), X(53,61),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35), X(51,67), X(3,19),
  X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51),
  X(59,67), X(3,11), X(19,27), X(35,43), X(51,59), X(7,39), X(39,71), X(7,39),
  X(23,55), X(23,39), X(55,71), X(7,23), X(39,55), X(15,47), X(31,63), X(15,31),
  X(47,63), X(15,23), X(31,39), X(47,55), X(63,71), X(7,15), X(23,31), X(39,47),
  X(55,63), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(2,34), X(34,66), X(2,34), X(18,50),
  X(18,34), X(50,66), X(2,18), X(34,50), X(10,42), X(26,58), X(10,26), X(42,58),
  X(10,18), X(26,34), X(42,50), X(58,66), X(2,10), X(18,26), X(34,42), X(50,58),
  X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70), X(6,22), X(38,54),
  X(14,46), X(30,62), X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70),
  X(6,14), X(22,30), X(38,46), X(54,62), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(4,36), X(36,68), X(4,36),
  X(20,52), X(20,36), X(52,68), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28),
  X(44,60), X(12,20), X(28,36), X(44,52), X(60,68), X(4,12), X(20,28), X(36,44),
  X(52,60), X(8,40), X(40,72), X(8,40), X(24,56), X(24,40), X(56,72), X(8,24),
  X(40,56), X(16,48), X(32,64), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56),
  X(64,72), X(8,16), X(24,32), X(40,48), X(56,64), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72)
};
M(73) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45),
  X(53,61), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(61,65), X(69,73), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35),
  X(51,67), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(11,19),
  X(27,35), X(43,51), X(59,67), X(3,11), X(19,27), X(35,43), X(51,59), X(7,39),
  X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23), X(39,55), X(15,47),
  X(31,63), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55), X(63,71), X(7,15),
  X(23,31), X(39,47), X(55,63), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(3,5), X(7,9), X(11,13), X(15,17),
  X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49),
  X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18), X(34,50),
  X(10,42), X(26,58), X(10,26), X(42,58), X(10,18), X(26,34), X(42,50), X(58,66),
  X(2,10), X(18,26), X(34,42), X(50,58), X(6,38), X(38,70), X(6,38), X(22,54),
  X(22,38), X(54,70), X(6,22), X(38,54), X(14,46), X(30,62), X(14,30), X(46,62),
  X(14,22), X(30,38), X(46,54), X(62,70), X(6,14), X(22,30), X(38,46), X(54,62),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(4,36), X(36,68), X(4,36), X(20,52), X(20,36), X(52,68), X(4,20),
  X(36,52), X(12,44), X(28,60), X(12,28), X(44,60), X(12,20), X(28,36), X(44,52),
  X(60,68), X(4,12), X(20,28), X(36,44), X(52,60), X(8,40), X(40,72), X(8,40),
  X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(32,64), X(16,32),
  X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(8,16), X(24,32), X(40,48),
  X(56,64), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72)
};
M(74) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45),
  X(53,61), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(61,65), X(69,73), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35),
  X(51,67), X(3,19), X(35,51), X(11,43), X(27,59), X(11,27), X(43,59), X(11,19),
  X(27,35), X(43,51), X(59,67), X(3,11), X(19,27), X(35,43), X(51,59), X(7,39),
  X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23), X(39,55), X(15,47),
  X(31,63), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55), X(63,71), X(7,15),
  X(23,31), X(39,47), X(55,63), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(3,5), X(7,9), X(11,13), X(15,17),
  X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49),
  X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18), X(34,50),
  X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26), X(42,58),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(6,38), X(38,70), X(6,38),
  X(22,54), X(22,38), X(54,70), X(6,22), X(38,54), X(14,46), X(30,62), X(14,30),
  X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(6,14), X(22,30), X(38,46),
  X(54,62), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58),
  X(62,66), X(70,74), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(58,62), X(66,70), X(4,36), X(36,68), X(4,36), X(20,52), X(20,36),
  X(52,68), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60), X(12,20),
  X(28,36), X(44,52), X(60,68), X(4,12), X(20,28), X(36,44), X(52,60), X(8,40),
  X(40,72), X(8,40), X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48),
  X(32,64), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(8,16),
  X(24,32), X(40,48), X(56,64), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74)
};
M(75) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45),
  X(53,61), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(61,65), X(69,73), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35),
  X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43),
  X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55), X(63,71),
  X(7,15), X(23,31), X(39,47), X(55,63), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18),
  X(34,50), X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26),
  X(42,58), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(6,38), X(38,70),
  X(6,38), X(22,54), X(22,38), X(54,70), X(6,22), X(38,54), X(14,46), X(30,62),
  X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(6,14), X(22,30),
  X(38,46), X(54,62), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50),
  X(54,58), X(62,66), X(70,74), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(4,36), X(36,68), X(4,36), X(20,52),
  X(20,36), X(52,68), X(4,20), X(36,52), X(12,44), X(28,60), X(12,28), X(44,60),
  X(12,20), X(28,36), X(44,52), X(60,68), X(4,12), X(20,28), X(36,44), X(52,60),
  X(8,40), X(40,72), X(8,40), X(24,56), X(24,40), X(56,72), X(8,24), X(40,56),
  X(16,48), X(32,64), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56), X(64,72),
  X(8,16), X(24,32), X(40,48), X(56,64), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74)
};
M(76) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(29,61), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(5,13), X(21,29), X(37,45),
  X(53,61), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57),
  X(61,65), X(69,73), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(3,35), X(35,67), X(3,35), X(19,51), X(19,35),
  X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43),
  X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23), X(39,55),
  X(15,47), X(31,63), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55), X(63,71),
  X(7,15), X(23,31), X(39,47), X(55,63), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18),
  X(34,50), X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26),
  X(42,58), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(6,38), X(38,70),
  X(6,38), X(22,54), X(22,38), X(54,70), X(6,22), X(38,54), X(14,46), X(30,62),
  X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(6,14), X(22,30),
  X(38,46), X(54,62), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50),
  X(54,58), X(62,66), X(70,74), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(4,36), X(36,68), X(4,36), X(20,52),
  X(20,36), X(52,68), X(4,20), X(36,52), X(12,44), X(44,76), X(12,44), X(28,60),
  X(28,44), X(60,76), X(12,28), X(44,60), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(8,40), X(40,72), X(8,40), X(24,56), X(24,40), X(56,72), X(8,24),
  X(40,56), X(16,48), X(32,64), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56),
  X(64,72), X(8,16), X(24,32), X(40,48), X(56,64), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76)
};
M(77) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45),
  X(29,61), X(29,45), X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(19,35), X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59),
  X(27,43), X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23),
  X(39,55), X(15,47), X(31,63), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(7,15), X(23,31), X(39,47), X(55,63), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(2,34), X(34,66), X(2,34),
  X(18,50), X(18,34), X(50,66), X(2,18), X(34,50), X(10,42), X(42,74), X(10,42),
  X(26,58), X(26,42), X(58,74), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70),
  X(6,22), X(38,54), X(14,46), X(30,62), X(14,30), X(46,62), X(14,22), X(30,38),
  X(46,54), X(62,70), X(6,14), X(22,30), X(38,46), X(54,62), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(4,36), X(36,68), X(4,36), X(20,52), X(20,36), X(52,68), X(4,20), X(36,52),
  X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28), X(44,60),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40),
  X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(32,64), X(16,32),
  X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(8,16), X(24,32), X(40,48),
  X(56,64), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(64,68), X(72,76), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76)
};
M(78) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45),
  X(29,61), X(29,45), X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(19,35), X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59),
  X(27,43), X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23),
  X(39,55), X(15,47), X(31,63), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(7,15), X(23,31), X(39,47), X(55,63), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(2,34), X(34,66), X(2,34),
  X(18,50), X(18,34), X(50,66), X(2,18), X(34,50), X(10,42), X(42,74), X(10,42),
  X(26,58), X(26,42), X(58,74), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70),
  X(6,22), X(38,54), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78),
  X(14,30), X(46,62), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(4,36), X(36,68), X(4,36), X(20,52), X(20,36), X(52,68), X(4,20),
  X(36,52), X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28),
  X(44,60), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72),
  X(8,40), X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(32,64),
  X(16,32), X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(8,16), X(24,32),
  X(40,48), X(56,64), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78)
};
M(79) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45),
  X(29,61), X(29,45), X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(19,35), X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59),
  X(27,43), X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23),
  X(39,55), X(15,47), X(47,79), X(15,47), X(31,63), X(31,47), X(63,79), X(15,31),
  X(47,63), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(2,34), X(34,66), X(2,34), X(18,50),
  X(18,34), X(50,66), X(2,18), X(34,50), X(10,42), X(42,74), X(10,42), X(26,58),
  X(26,42), X(58,74), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70), X(6,22),
  X(38,54), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78), X(14,30),
  X(46,62), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(4,36), X(36,68), X(4,36), X(20,52), X(20,36), X(52,68), X(4,20), X(36,52),
  X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28), X(44,60),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40),
  X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(32,64), X(16,32),
  X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(8,16), X(24,32), X(40,48),
  X(56,64), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(64,68), X(72,76), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78)
};
M(80) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(17,33), X(49,65), X(1,17), X(33,49),
  X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25), X(41,57),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37),
  X(21,53), X(21,37), X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45),
  X(29,61), X(29,45), X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(19,35), X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59),
  X(27,43), X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23),
  X(39,55), X(15,47), X(47,79), X(15,47), X(31,63), X(31,47), X(63,79), X(15,31),
  X(47,63), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(2,34), X(34,66), X(2,34), X(18,50),
  X(18,34), X(50,66), X(2,18), X(34,50), X(10,42), X(42,74), X(10,42), X(26,58),
  X(26,42), X(58,74), X(10,26), X(42,58), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70), X(6,22),
  X(38,54), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78), X(14,30),
  X(46,62), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(4,36), X(36,68), X(4,36), X(20,52), X(20,36), X(52,68), X(4,20), X(36,52),
  X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28), X(44,60),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40),
  X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(48,80), X(16,48),
  X(32,64), X(32,48), X(64,80), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80)
};
M(81) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(21,37),
  X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45),
  X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(19,35), X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59),
  X(27,43), X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23),
  X(39,55), X(15,47), X(47,79), X(15,47), X(31,63), X(31,47), X(63,79), X(15,31),
  X(47,63), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65),
  X(67,69), X(71,73), X(75,77), X(79,81), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(2,34), X(34,66), X(2,34), X(18,50), X(18,34), X(50,66), X(2,18), X(34,50),
  X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26), X(42,58),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(6,38), X(38,70), X(6,38),
  X(22,54), X(22,38), X(54,70), X(6,22), X(38,54), X(14,46), X(46,78), X(14,46),
  X(30,62), X(30,46), X(62,78), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(58,62), X(66,70), X(74,78), X(4,36), X(36,68), X(4,36), X(20,52),
  X(20,36), X(52,68), X(4,20), X(36,52), X(12,44), X(44,76), X(12,44), X(28,60),
  X(28,44), X(60,76), X(12,28), X(44,60), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(8,40), X(40,72), X(8,40), X(24,56), X(24,40), X(56,72), X(8,24),
  X(40,56), X(16,48), X(48,80), X(16,48), X(32,64), X(32,48), X(64,80), X(16,32),
  X(48,64), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80)
};
M(82) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(21,37),
  X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45),
  X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(19,35), X(51,67), X(3,19), X(35,51), X(11,43), X(43,75), X(11,43), X(27,59),
  X(27,43), X(59,75), X(11,27), X(43,59), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(7,39), X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23),
  X(39,55), X(15,47), X(47,79), X(15,47), X(31,63), X(31,47), X(63,79), X(15,31),
  X(47,63), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65),
  X(67,69), X(71,73), X(75,77), X(79,81), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(2,34), X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50),
  X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26),
  X(42,58), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(22,38),
  X(54,70), X(6,22), X(38,54), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46),
  X(62,78), X(14,30), X(46,62), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(58,62), X(66,70), X(74,78), X(4,36), X(36,68), X(4,36), X(20,52),
  X(20,36), X(52,68), X(4,20), X(36,52), X(12,44), X(44,76), X(12,44), X(28,60),
  X(28,44), X(60,76), X(12,28), X(44,60), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(8,40), X(40,72), X(8,40), X(24,56), X(24,40), X(56,72), X(8,24),
  X(40,56), X(16,48), X(48,80), X(16,48), X(32,64), X(32,48), X(64,80), X(16,32),
  X(48,64), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66),
  X(68,70), X(72,74), X(76,78), X(80,82), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82)
};
M(83) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(21,37),
  X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45),
  X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(51,83), X(19,51), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43),
  X(27,59), X(27,43), X(59,75), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51),
  X(59,67), X(75,83), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(7,39),
  X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23), X(39,55), X(15,47),
  X(47,79), X(15,47), X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(2,34), X(34,66), X(2,34),
  X(18,50), X(50,82), X(18,50), X(2,18), X(34,50), X(66,82), X(10,42), X(42,74),
  X(10,42), X(26,58), X(26,42), X(58,74), X(10,26), X(42,58), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70), X(6,22), X(38,54),
  X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78), X(14,30), X(46,62),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(6,10), X(14,18), X(22,26),
  X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(4,36), X(36,68), X(4,36), X(20,52), X(20,36), X(52,68), X(4,20),
  X(36,52), X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28),
  X(44,60), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72),
  X(8,40), X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(48,80),
  X(16,48), X(32,64), X(32,48), X(64,80), X(16,32), X(48,64), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(2,3), X(4,5), X(6,7),
  X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23),
  X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39),
  X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55),
  X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71),
  X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82)
};
M(84) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(21,37),
  X(53,69), X(5,21), X(37,53), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45),
  X(61,77), X(13,29), X(45,61), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(3,35), X(35,67), X(3,35), X(19,51),
  X(51,83), X(19,51), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43),
  X(27,59), X(27,43), X(59,75), X(11,27), X(43,59), X(11,19), X(27,35), X(43,51),
  X(59,67), X(75,83), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(7,39),
  X(39,71), X(7,39), X(23,55), X(23,39), X(55,71), X(7,23), X(39,55), X(15,47),
  X(47,79), X(15,47), X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(2,34), X(34,66), X(2,34),
  X(18,50), X(50,82), X(18,50), X(2,18), X(34,50), X(66,82), X(10,42), X(42,74),
  X(10,42), X(26,58), X(26,42), X(58,74), X(10,26), X(42,58), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70), X(6,22), X(38,54),
  X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78), X(14,30), X(46,62),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(6,10), X(14,18), X(22,26),
  X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20),
  X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76),
  X(12,28), X(44,60), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40), X(24,56),
  X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(48,80), X(16,48), X(32,64),
  X(32,48), X(64,80), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(64,68), X(72,76), X(80,84), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84)
};
M(85) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85),
  X(21,53), X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61),
  X(29,45), X(61,77), X(13,29), X(45,61), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43), X(59,75),
  X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(7,39), X(39,71), X(7,39), X(23,55),
  X(23,39), X(55,71), X(7,23), X(39,55), X(15,47), X(47,79), X(15,47), X(31,63),
  X(31,47), X(63,79), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59),
  X(63,67), X(71,75), X(79,83), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(2,34),
  X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50), X(66,82),
  X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26), X(42,58),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(22,38), X(54,70),
  X(6,22), X(38,54), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78),
  X(14,30), X(46,62), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(4,36), X(36,68), X(4,36), X(20,52), X(52,84),
  X(20,52), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60),
  X(28,44), X(60,76), X(12,28), X(44,60), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72),
  X(8,40), X(24,56), X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(48,80),
  X(16,48), X(32,64), X(32,48), X(64,80), X(16,32), X(48,64), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44),
  X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84)
};
M(86) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85),
  X(21,53), X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61),
  X(29,45), X(61,77), X(13,29), X(45,61), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43), X(59,75),
  X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(7,39), X(39,71), X(7,39), X(23,55),
  X(23,39), X(55,71), X(7,23), X(39,55), X(15,47), X(47,79), X(15,47), X(31,63),
  X(31,47), X(63,79), X(15,31), X(47,63), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59),
  X(63,67), X(71,75), X(79,83), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(2,34),
  X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50), X(66,82),
  X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26), X(42,58),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86), X(22,54),
  X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46),
  X(62,78), X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20), X(36,52),
  X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28),
  X(44,60), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40), X(24,56), X(24,40),
  X(56,72), X(8,24), X(40,56), X(16,48), X(48,80), X(16,48), X(32,64), X(32,48),
  X(64,80), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68),
  X(72,76), X(80,84), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86)
};
M(87) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85),
  X(21,53), X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61),
  X(29,45), X(61,77), X(13,29), X(45,61), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43), X(59,75),
  X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(2,34), X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50),
  X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26),
  X(42,58), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86),
  X(22,54), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62),
  X(30,46), X(62,78), X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20),
  X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76),
  X(12,28), X(44,60), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40), X(24,56),
  X(24,40), X(56,72), X(8,24), X(40,56), X(16,48), X(48,80), X(16,48), X(32,64),
  X(32,48), X(64,80), X(16,32), X(48,64), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(64,68), X(72,76), X(80,84), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(84,86), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86)
};
M(88) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(25,41), X(57,73), X(9,25),
  X(41,57), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85),
  X(21,53), X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61),
  X(29,45), X(61,77), X(13,29), X(45,61), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43), X(59,75),
  X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(2,34), X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50),
  X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26),
  X(42,58), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86),
  X(22,54), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62),
  X(30,46), X(62,78), X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20),
  X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76),
  X(12,28), X(44,60), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40), X(24,56),
  X(56,88), X(24,56), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48),
  X(32,64), X(32,48), X(64,80), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82), X(83,84), X(85,86), X(87,88)
};
M(89) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45), X(61,77), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43), X(59,75),
  X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(2,34), X(34,66),
  X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50), X(66,82), X(10,42),
  X(42,74), X(10,42), X(26,58), X(26,42), X(58,74), X(10,26), X(42,58), X(10,18),
  X(26,34), X(42,50), X(58,66), X(74,82), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22),
  X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78),
  X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(4,36),
  X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20), X(36,52), X(68,84),
  X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28), X(44,60),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(32,48),
  X(64,80), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(80,88),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88)
};
M(90) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45), X(61,77), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(27,43), X(59,75),
  X(11,27), X(43,59), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(2,34), X(34,66),
  X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50), X(66,82), X(10,42),
  X(42,74), X(10,42), X(26,58), X(58,90), X(26,58), X(10,26), X(42,58), X(74,90),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,38), X(38,70),
  X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54), X(70,86), X(14,46),
  X(46,78), X(14,46), X(30,62), X(30,46), X(62,78), X(14,30), X(46,62), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58),
  X(62,66), X(70,74), X(78,82), X(86,90), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(4,36),
  X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20), X(36,52), X(68,84),
  X(12,44), X(44,76), X(12,44), X(28,60), X(28,44), X(60,76), X(12,28), X(44,60),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(32,48),
  X(64,80), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(80,88),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66),
  X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90)
};
M(91) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45), X(61,77), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(59,91), X(27,59),
  X(11,27), X(43,59), X(75,91), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(7,39), X(39,71), X(7,39), X(23,55), X(55,87), X(23,55), X(7,23),
  X(39,55), X(71,87), X(15,47), X(47,79), X(15,47), X(31,63), X(31,47), X(63,79),
  X(15,31), X(47,63), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(2,34), X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18),
  X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58),
  X(10,26), X(42,58), X(74,90), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22),
  X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78),
  X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52),
  X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(28,44),
  X(60,76), X(12,28), X(44,60), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(8,40), X(40,72), X(8,40),
  X(24,56), X(56,88), X(24,56), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80),
  X(16,48), X(32,64), X(32,48), X(64,80), X(16,32), X(48,64), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90)
};
M(92) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(29,45), X(61,77), X(13,29),
  X(45,61), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51), X(3,19),
  X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(59,91), X(27,59),
  X(11,27), X(43,59), X(75,91), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(7,39), X(39,71), X(7,39), X(23,55), X(55,87), X(23,55), X(7,23),
  X(39,55), X(71,87), X(15,47), X(47,79), X(15,47), X(31,63), X(31,47), X(63,79),
  X(15,31), X(47,63), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(2,34), X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18),
  X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58),
  X(10,26), X(42,58), X(74,90), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22),
  X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(30,46), X(62,78),
  X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52),
  X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(60,92),
  X(28,60), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(32,48),
  X(64,80), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56), X(64,72), X(80,88),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84),
  X(86,88), X(90,92), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92)
};
M(93) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29),
  X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(73,77), X(81,85), X(89,93), X(3,35), X(35,67), X(3,35), X(19,51),
  X(51,83), X(19,51), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43),
  X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(7,11),
  X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75),
  X(79,83), X(87,91), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(2,34), X(34,66), X(2,34), X(18,50), X(50,82),
  X(18,50), X(2,18), X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58),
  X(58,90), X(26,58), X(10,26), X(42,58), X(74,90), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86),
  X(22,54), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62),
  X(30,46), X(62,78), X(14,30), X(46,62), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(4,36), X(36,68), X(4,36), X(20,52),
  X(52,84), X(20,52), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56),
  X(56,88), X(24,56), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48),
  X(32,64), X(32,48), X(64,80), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76),
  X(80,84), X(88,92), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92)
};
M(94) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29),
  X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(73,77), X(81,85), X(89,93), X(3,35), X(35,67), X(3,35), X(19,51),
  X(51,83), X(19,51), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43),
  X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(31,47), X(63,79), X(15,31), X(47,63), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(7,11),
  X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75),
  X(79,83), X(87,91), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(2,34), X(34,66), X(2,34), X(18,50), X(50,82),
  X(18,50), X(2,18), X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58),
  X(58,90), X(26,58), X(10,26), X(42,58), X(74,90), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(6,38), X(38,70), X(6,38), X(22,54), X(54,86),
  X(22,54), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62),
  X(62,94), X(30,62), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(4,36),
  X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20), X(36,52), X(68,84),
  X(12,44), X(44,76), X(12,44), X(28,60), X(60,92), X(28,60), X(12,28), X(44,60),
  X(76,92), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(8,40),
  X(40,72), X(8,40), X(24,56), X(56,88), X(24,56), X(8,24), X(40,56), X(72,88),
  X(16,48), X(48,80), X(16,48), X(32,64), X(32,48), X(64,80), X(16,32), X(48,64),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66),
  X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94)
};
M(95) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29),
  X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(73,77), X(81,85), X(89,93), X(3,35), X(35,67), X(3,35), X(19,51),
  X(51,83), X(19,51), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43),
  X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95),
  X(2,34), X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50),
  X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58), X(10,26),
  X(42,58), X(74,90), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(6,38), X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54),
  X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(62,94), X(30,62), X(14,30),
  X(46,62), X(78,94), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(4,36), X(36,68), X(4,36), X(20,52),
  X(52,84), X(20,52), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56),
  X(56,88), X(24,56), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48),
  X(32,64), X(32,48), X(64,80), X(16,32), X(48,64), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76),
  X(80,84), X(88,92), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(84,86), X(88,90), X(92,94), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94)
};
M(96) = {
  X(1,33), X(33,65), X(1,33), X(17,49), X(49,81), X(17,49), X(1,17), X(33,49),
  X(65,81), X(9,41), X(41,73), X(9,41), X(25,57), X(57,89), X(25,57), X(9,25),
  X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53), X(5,21), X(37,53),
  X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29),
  X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61),
  X(65,69), X(73,77), X(81,85), X(89,93), X(3,35), X(35,67), X(3,35), X(19,51),
  X(51,83), X(19,51), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43),
  X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95),
  X(2,34), X(34,66), X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50),
  X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58), X(10,26),
  X(42,58), X(74,90), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(6,38), X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54),
  X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(62,94), X(30,62), X(14,30),
  X(46,62), X(78,94), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(4,36), X(36,68), X(4,36), X(20,52),
  X(52,84), X(20,52), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56),
  X(56,88), X(24,56), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48),
  X(32,64), X(64,96), X(32,64), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96)
};
M(97) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53),
  X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93),
  X(29,61), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49),
  X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51),
  X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(59,91),
  X(27,59), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55), X(55,87), X(23,55),
  X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47), X(31,63), X(63,95),
  X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(2,34), X(34,66),
  X(2,34), X(18,50), X(50,82), X(18,50), X(2,18), X(34,50), X(66,82), X(10,42),
  X(42,74), X(10,42), X(26,58), X(58,90), X(26,58), X(10,26), X(42,58), X(74,90),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,38), X(38,70),
  X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54), X(70,86), X(14,46),
  X(46,78), X(14,46), X(30,62), X(62,94), X(30,62), X(14,30), X(46,62), X(78,94),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52),
  X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(60,92),
  X(28,60), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(64,96),
  X(32,64), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96)
};
M(98) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53),
  X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93),
  X(29,61), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49),
  X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(3,35), X(35,67), X(3,35), X(19,51), X(51,83), X(19,51),
  X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59), X(59,91),
  X(27,59), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55), X(55,87), X(23,55),
  X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47), X(31,63), X(63,95),
  X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(2,66), X(34,98),
  X(2,34), X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98),
  X(2,18), X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90),
  X(26,58), X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(6,38), X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54),
  X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(62,94), X(30,62), X(14,30),
  X(46,62), X(78,94), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(4,36), X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20), X(36,52),
  X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(60,92), X(28,60), X(12,28),
  X(44,60), X(76,92), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56), X(8,24), X(40,56),
  X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(64,96), X(32,64), X(16,32),
  X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(92,96), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98)
};
M(99) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53),
  X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93),
  X(29,61), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49),
  X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51), X(51,83),
  X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83), X(11,43),
  X(43,75), X(11,43), X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91),
  X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18),
  X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58),
  X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,38),
  X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54), X(70,86),
  X(14,46), X(46,78), X(14,46), X(30,62), X(62,94), X(30,62), X(14,30), X(46,62),
  X(78,94), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(86,90), X(94,98), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(4,36),
  X(36,68), X(4,36), X(20,52), X(52,84), X(20,52), X(4,20), X(36,52), X(68,84),
  X(12,44), X(44,76), X(12,44), X(28,60), X(60,92), X(28,60), X(12,28), X(44,60),
  X(76,92), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(8,40),
  X(40,72), X(8,40), X(24,56), X(56,88), X(24,56), X(8,24), X(40,56), X(72,88),
  X(16,48), X(48,80), X(16,48), X(32,64), X(64,96), X(32,64), X(16,32), X(48,64),
  X(80,96), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84),
  X(86,88), X(90,92), X(94,96), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98)
};
M(100) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,37), X(37,69), X(5,37), X(21,53), X(53,85), X(21,53),
  X(5,21), X(37,53), X(69,85), X(13,45), X(45,77), X(13,45), X(29,61), X(61,93),
  X(29,61), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49),
  X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51), X(51,83),
  X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83), X(11,43),
  X(43,75), X(11,43), X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91),
  X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55),
  X(55,87), X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18),
  X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58),
  X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,38),
  X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54), X(70,86),
  X(14,46), X(46,78), X(14,46), X(30,62), X(62,94), X(30,62), X(14,30), X(46,62),
  X(78,94), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(86,90), X(94,98), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(4,68),
  X(36,100), X(4,36), X(68,100), X(20,52), X(52,84), X(20,52), X(20,36),
  X(52,68), X(84,100), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(64,96),
  X(32,64), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100)
};
M(101) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,45),
  X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61), X(77,93),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51),
  X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75),
  X(11,43), X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(11,19),
  X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(3,11), X(19,27), X(35,43),
  X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55), X(55,87),
  X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47), X(31,63),
  X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43),
  X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21),
  X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53),
  X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85),
  X(87,89), X(91,93), X(95,97), X(99,101), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18),
  X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58),
  X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,38),
  X(38,70), X(6,38), X(22,54), X(54,86), X(22,54), X(6,22), X(38,54), X(70,86),
  X(14,46), X(46,78), X(14,46), X(30,62), X(62,94), X(30,62), X(14,30), X(46,62),
  X(78,94), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(86,90), X(94,98), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(4,68),
  X(36,100), X(4,36), X(68,100), X(20,52), X(52,84), X(20,52), X(20,36),
  X(52,68), X(84,100), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(64,96),
  X(32,64), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(1,2), X(3,4), X(5,6),
  X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22),
  X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38),
  X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54),
  X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70),
  X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86),
  X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100)
};
M(102) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,45),
  X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61), X(77,93),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51),
  X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75),
  X(11,43), X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(11,19),
  X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(3,11), X(19,27), X(35,43),
  X(51,59), X(67,75), X(83,91), X(7,39), X(39,71), X(7,39), X(23,55), X(55,87),
  X(23,55), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47), X(31,63),
  X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43),
  X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21),
  X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53),
  X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85),
  X(87,89), X(91,93), X(95,97), X(99,101), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18),
  X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58),
  X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38),
  X(54,70), X(86,102), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46),
  X(30,62), X(62,94), X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(4,68),
  X(36,100), X(4,36), X(68,100), X(20,52), X(52,84), X(20,52), X(20,36),
  X(52,68), X(84,100), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(64,96),
  X(32,64), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26),
  X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58),
  X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90),
  X(92,94), X(96,98), X(100,102), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84),
  X(86,88), X(90,92), X(94,96), X(98,100), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102)
};
M(103) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,45),
  X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61), X(77,93),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51),
  X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75),
  X(11,43), X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(11,19),
  X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(3,11), X(19,27), X(35,43),
  X(51,59), X(67,75), X(83,91), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55),
  X(55,87), X(23,55), X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87),
  X(15,47), X(47,79), X(15,47), X(31,63), X(63,95), X(31,63), X(15,31), X(47,63),
  X(79,95), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(2,66), X(34,98), X(2,34), X(66,98),
  X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18), X(34,50),
  X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58), X(10,26),
  X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,70), X(38,102),
  X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38), X(54,70),
  X(86,102), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62),
  X(62,94), X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38), X(46,54),
  X(62,70), X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(4,68),
  X(36,100), X(4,36), X(68,100), X(20,52), X(52,84), X(20,52), X(20,36),
  X(52,68), X(84,100), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,40), X(40,72), X(8,40), X(24,56), X(56,88), X(24,56),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(64,96),
  X(32,64), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26),
  X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58),
  X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90),
  X(92,94), X(96,98), X(100,102), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20),
  X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52),
  X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84),
  X(86,88), X(90,92), X(94,96), X(98,100), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96),
  X(97,98), X(99,100), X(101,102)
};
M(104) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,41), X(41,73), X(9,41),
  X(25,57), X(57,89), X(25,57), X(9,25), X(41,57), X(73,89), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,45),
  X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61), X(77,93),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51),
  X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75),
  X(11,43), X(27,59), X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(11,19),
  X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(3,11), X(19,27), X(35,43),
  X(51,59), X(67,75), X(83,91), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55),
  X(55,87), X(23,55), X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87),
  X(15,47), X(47,79), X(15,47), X(31,63), X(63,95), X(31,63), X(15,31), X(47,63),
  X(79,95), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(2,66), X(34,98), X(2,34), X(66,98),
  X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18), X(34,50),
  X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58), X(10,26),
  X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,70), X(38,102),
  X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38), X(54,70),
  X(86,102), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62),
  X(62,94), X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38), X(46,54),
  X(62,70), X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(4,68),
  X(36,100), X(4,36), X(68,100), X(20,52), X(52,84), X(20,52), X(20,36),
  X(52,68), X(84,100), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,72), X(40,104), X(8,40), X(72,104), X(24,56), X(56,88),
  X(24,56), X(24,40), X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,48),
  X(48,80), X(16,48), X(32,64), X(64,96), X(32,64), X(16,32), X(48,64), X(80,96),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104)
};
M(105) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61),
  X(77,93), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(3,67),
  X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51), X(19,35), X(51,67),
  X(83,99), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59),
  X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(11,19), X(27,35), X(43,51),
  X(59,67), X(75,83), X(91,99), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55),
  X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79),
  X(15,47), X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(15,23),
  X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93),
  X(95,97), X(99,101), X(103,105), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19),
  X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51),
  X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83),
  X(85,87), X(89,91), X(93,95), X(97,99), X(101,103), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18),
  X(34,50), X(66,82), X(10,42), X(42,74), X(10,42), X(26,58), X(58,90), X(26,58),
  X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38),
  X(54,70), X(86,102), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46),
  X(30,62), X(62,94), X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(4,68),
  X(36,100), X(4,36), X(68,100), X(20,52), X(52,84), X(20,52), X(20,36),
  X(52,68), X(84,100), X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44),
  X(28,60), X(60,92), X(28,60), X(12,28), X(44,60), X(76,92), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(8,72), X(40,104), X(8,40), X(72,104), X(24,56), X(56,88),
  X(24,56), X(24,40), X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,48),
  X(48,80), X(16,48), X(32,64), X(64,96), X(32,64), X(16,32), X(48,64), X(80,96),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96),
  X(97,98), X(99,100), X(101,102), X(103,104)
};
M(106) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61),
  X(77,93), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(3,67),
  X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51), X(19,35), X(51,67),
  X(83,99), X(3,19), X(35,51), X(67,83), X(11,43), X(43,75), X(11,43), X(27,59),
  X(59,91), X(27,59), X(11,27), X(43,59), X(75,91), X(11,19), X(27,35), X(43,51),
  X(59,67), X(75,83), X(91,99), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55),
  X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79),
  X(15,47), X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(15,23),
  X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93),
  X(95,97), X(99,101), X(103,105), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19),
  X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51),
  X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83),
  X(85,87), X(89,91), X(93,95), X(97,99), X(101,103), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18),
  X(34,50), X(66,82), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58),
  X(58,90), X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58),
  X(74,90), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(6,70), X(38,102), X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38),
  X(54,70), X(86,102), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46),
  X(30,62), X(62,94), X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50),
  X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(4,68), X(36,100), X(4,36),
  X(68,100), X(20,52), X(52,84), X(20,52), X(20,36), X(52,68), X(84,100),
  X(4,20), X(36,52), X(68,84), X(12,44), X(44,76), X(12,44), X(28,60), X(60,92),
  X(28,60), X(12,28), X(44,60), X(76,92), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(92,100), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(8,72), X(40,104), X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40),
  X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48),
  X(32,64), X(64,96), X(32,64), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106)
};
M(107) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61),
  X(77,93), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(3,67),
  X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51), X(19,35), X(51,67),
  X(83,99), X(3,19), X(35,51), X(67,83), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,59), X(59,91), X(27,59), X(27,43), X(59,75), X(91,107),
  X(11,27), X(43,59), X(75,91), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55),
  X(55,87), X(23,55), X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87),
  X(15,47), X(47,79), X(15,47), X(31,63), X(63,95), X(31,63), X(15,31), X(47,63),
  X(79,95), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(2,66), X(34,98), X(2,34), X(66,98), X(18,50),
  X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18), X(34,50), X(66,82),
  X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90), X(26,58),
  X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70), X(38,102), X(6,38),
  X(70,102), X(22,54), X(54,86), X(22,54), X(22,38), X(54,70), X(86,102),
  X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(62,94),
  X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(4,68), X(36,100), X(4,36), X(68,100), X(20,52),
  X(52,84), X(20,52), X(20,36), X(52,68), X(84,100), X(4,20), X(36,52), X(68,84),
  X(12,44), X(44,76), X(12,44), X(28,60), X(60,92), X(28,60), X(12,28), X(44,60),
  X(76,92), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(8,72), X(40,104), X(8,40),
  X(72,104), X(24,56), X(56,88), X(24,56), X(24,40), X(56,72), X(88,104),
  X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64), X(64,96),
  X(32,64), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40), X(48,56), X(64,72),
  X(80,88), X(96,104), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96),
  X(97,98), X(99,100), X(101,102), X(103,104), X(105,106)
};
M(108) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,45), X(45,77), X(13,45), X(29,61), X(61,93), X(29,61), X(13,29), X(45,61),
  X(77,93), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45),
  X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(3,67),
  X(35,99), X(3,35), X(67,99), X(19,51), X(51,83), X(19,51), X(19,35), X(51,67),
  X(83,99), X(3,19), X(35,51), X(67,83), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,59), X(59,91), X(27,59), X(27,43), X(59,75), X(91,107),
  X(11,27), X(43,59), X(75,91), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55),
  X(55,87), X(23,55), X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87),
  X(15,47), X(47,79), X(15,47), X(31,63), X(63,95), X(31,63), X(15,31), X(47,63),
  X(79,95), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47),
  X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(2,66), X(34,98), X(2,34), X(66,98), X(18,50),
  X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18), X(34,50), X(66,82),
  X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90), X(26,58),
  X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70), X(38,102), X(6,38),
  X(70,102), X(22,54), X(54,86), X(22,54), X(22,38), X(54,70), X(86,102),
  X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46), X(30,62), X(62,94),
  X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(4,68), X(36,100), X(4,36), X(68,100), X(20,52),
  X(52,84), X(20,52), X(20,36), X(52,68), X(84,100), X(4,20), X(36,52), X(68,84),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92), X(28,60),
  X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72), X(40,104),
  X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40), X(56,72),
  X(88,104), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64),
  X(64,96), X(32,64), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104), X(106,108),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96),
  X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108)
};
M(109) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99),
  X(19,51), X(51,83), X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51),
  X(67,83), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91),
  X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71),
  X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55), X(23,39),
  X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51),
  X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(3,5), X(7,9), X(11,13), X(15,17),
  X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49),
  X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81),
  X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105), X(107,109),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95),
  X(97,99), X(101,103), X(105,107), X(2,66), X(34,98), X(2,34), X(66,98),
  X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18), X(34,50),
  X(66,82), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90),
  X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90), X(2,10),
  X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38),
  X(54,70), X(86,102), X(6,22), X(38,54), X(70,86), X(14,46), X(46,78), X(14,46),
  X(30,62), X(62,94), X(30,62), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50),
  X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(4,68), X(36,100), X(4,36),
  X(68,100), X(20,52), X(52,84), X(20,52), X(20,36), X(52,68), X(84,100),
  X(4,20), X(36,52), X(68,84), X(12,76), X(44,108), X(12,44), X(76,108),
  X(28,60), X(60,92), X(28,60), X(28,44), X(60,76), X(92,108), X(12,28),
  X(44,60), X(76,92), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(8,72), X(40,104), X(8,40), X(72,104), X(24,56), X(56,88),
  X(24,56), X(24,40), X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,48),
  X(48,80), X(16,48), X(32,64), X(64,96), X(32,64), X(16,32), X(48,64), X(80,96),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108)
};
M(110) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99),
  X(19,51), X(51,83), X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51),
  X(67,83), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91),
  X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71),
  X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55), X(23,39),
  X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,47), X(47,79), X(15,47),
  X(31,63), X(63,95), X(31,63), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51),
  X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(3,5), X(7,9), X(11,13), X(15,17),
  X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49),
  X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81),
  X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105), X(107,109),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95),
  X(97,99), X(101,103), X(105,107), X(2,66), X(34,98), X(2,34), X(66,98),
  X(18,50), X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18), X(34,50),
  X(66,82), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90),
  X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90), X(2,10),
  X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38),
  X(54,70), X(86,102), X(6,22), X(38,54), X(70,86), X(14,78), X(46,110),
  X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46), X(62,78),
  X(94,110), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(4,68), X(36,100), X(4,36), X(68,100), X(20,52),
  X(52,84), X(20,52), X(20,36), X(52,68), X(84,100), X(4,20), X(36,52), X(68,84),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92), X(28,60),
  X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72), X(40,104),
  X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40), X(56,72),
  X(88,104), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48), X(32,64),
  X(64,96), X(32,64), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60),
  X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110)
};
M(111) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99),
  X(19,51), X(51,83), X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51),
  X(67,83), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91),
  X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71),
  X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55), X(23,39),
  X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,79), X(47,111),
  X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47), X(63,79),
  X(95,111), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(2,66),
  X(34,98), X(2,34), X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66),
  X(82,98), X(2,18), X(34,50), X(66,82), X(10,74), X(42,106), X(10,42),
  X(74,106), X(26,58), X(58,90), X(26,58), X(26,42), X(58,74), X(90,106),
  X(10,26), X(42,58), X(74,90), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(6,70), X(38,102), X(6,38), X(70,102), X(22,54),
  X(54,86), X(22,54), X(22,38), X(54,70), X(86,102), X(6,22), X(38,54), X(70,86),
  X(14,78), X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62),
  X(30,46), X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(4,68), X(36,100), X(4,36), X(68,100),
  X(20,52), X(52,84), X(20,52), X(20,36), X(52,68), X(84,100), X(4,20), X(36,52),
  X(68,84), X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92),
  X(28,60), X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40),
  X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,48), X(48,80), X(16,48),
  X(32,64), X(64,96), X(32,64), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106),
  X(108,110), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110)
};
M(112) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,49), X(49,81), X(17,49), X(17,33),
  X(49,65), X(81,97), X(1,17), X(33,49), X(65,81), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73),
  X(81,89), X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53),
  X(53,85), X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99),
  X(19,51), X(51,83), X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51),
  X(67,83), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91),
  X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71),
  X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55), X(23,39),
  X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,79), X(47,111),
  X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47), X(63,79),
  X(95,111), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(2,66),
  X(34,98), X(2,34), X(66,98), X(18,50), X(50,82), X(18,50), X(18,34), X(50,66),
  X(82,98), X(2,18), X(34,50), X(66,82), X(10,74), X(42,106), X(10,42),
  X(74,106), X(26,58), X(58,90), X(26,58), X(26,42), X(58,74), X(90,106),
  X(10,26), X(42,58), X(74,90), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(6,70), X(38,102), X(6,38), X(70,102), X(22,54),
  X(54,86), X(22,54), X(22,38), X(54,70), X(86,102), X(6,22), X(38,54), X(70,86),
  X(14,78), X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62),
  X(30,46), X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(4,68), X(36,100), X(4,36), X(68,100),
  X(20,52), X(52,84), X(20,52), X(20,36), X(52,68), X(84,100), X(4,20), X(36,52),
  X(68,84), X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92),
  X(28,60), X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40),
  X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80),
  X(96,112), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112)
};
M(113) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51),
  X(51,83), X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83),
  X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91), X(27,59),
  X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71), X(39,103), X(7,39),
  X(71,103), X(23,55), X(55,87), X(23,55), X(23,39), X(55,71), X(87,103),
  X(7,23), X(39,55), X(71,87), X(15,79), X(47,111), X(15,47), X(79,111),
  X(31,63), X(63,95), X(31,63), X(31,47), X(63,79), X(95,111), X(15,31),
  X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65),
  X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(2,66), X(34,98), X(2,34), X(66,98), X(18,50),
  X(50,82), X(18,50), X(18,34), X(50,66), X(82,98), X(2,18), X(34,50), X(66,82),
  X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90), X(26,58),
  X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70), X(38,102), X(6,38),
  X(70,102), X(22,54), X(54,86), X(22,54), X(22,38), X(54,70), X(86,102),
  X(6,22), X(38,54), X(70,86), X(14,78), X(46,110), X(14,46), X(78,110),
  X(30,62), X(62,94), X(30,62), X(30,46), X(62,78), X(94,110), X(14,30),
  X(46,62), X(78,94), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(4,68), X(36,100), X(4,36), X(68,100), X(20,52), X(52,84), X(20,52), X(20,36),
  X(52,68), X(84,100), X(4,20), X(36,52), X(68,84), X(12,76), X(44,108),
  X(12,44), X(76,108), X(28,60), X(60,92), X(28,60), X(28,44), X(60,76),
  X(92,108), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(8,72), X(40,104), X(8,40), X(72,104),
  X(24,56), X(56,88), X(24,56), X(24,40), X(56,72), X(88,104), X(8,24), X(40,56),
  X(72,88), X(16,80), X(48,112), X(16,48), X(80,112), X(32,64), X(64,96),
  X(32,64), X(32,48), X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104), X(106,108),
  X(110,112), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112)
};
M(114) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99), X(19,51),
  X(51,83), X(19,51), X(19,35), X(51,67), X(83,99), X(3,19), X(35,51), X(67,83),
  X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91), X(27,59),
  X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71), X(39,103), X(7,39),
  X(71,103), X(23,55), X(55,87), X(23,55), X(23,39), X(55,71), X(87,103),
  X(7,23), X(39,55), X(71,87), X(15,79), X(47,111), X(15,47), X(79,111),
  X(31,63), X(63,95), X(31,63), X(31,47), X(63,79), X(95,111), X(15,31),
  X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33),
  X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65),
  X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(2,66), X(34,98), X(2,34), X(66,98), X(18,82),
  X(50,114), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114),
  X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90), X(26,58),
  X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90), X(10,18),
  X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(2,10),
  X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,54), X(54,86), X(22,54), X(22,38),
  X(54,70), X(86,102), X(6,22), X(38,54), X(70,86), X(14,78), X(46,110),
  X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46), X(62,78),
  X(94,110), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(4,68), X(36,100), X(4,36), X(68,100), X(20,52),
  X(52,84), X(20,52), X(20,36), X(52,68), X(84,100), X(4,20), X(36,52), X(68,84),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92), X(28,60),
  X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72), X(40,104),
  X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40), X(56,72),
  X(88,104), X(8,24), X(40,56), X(72,88), X(16,80), X(48,112), X(16,48),
  X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80), X(96,112),
  X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104),
  X(108,112), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62),
  X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94),
  X(96,98), X(100,102), X(104,106), X(108,110), X(112,114), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114)
};
M(115) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99), X(19,83),
  X(51,115), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91), X(27,59),
  X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(11,19),
  X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71),
  X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55), X(23,39),
  X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,79), X(47,111),
  X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47), X(63,79),
  X(95,111), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(103,107), X(111,115), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(2,66), X(34,98), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50), X(82,114),
  X(2,18), X(34,50), X(66,82), X(98,114), X(10,74), X(42,106), X(10,42),
  X(74,106), X(26,58), X(58,90), X(26,58), X(26,42), X(58,74), X(90,106),
  X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(106,114), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(6,70), X(38,102), X(6,38), X(70,102), X(22,54),
  X(54,86), X(22,54), X(22,38), X(54,70), X(86,102), X(6,22), X(38,54), X(70,86),
  X(14,78), X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62),
  X(30,46), X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(4,68), X(36,100), X(4,36), X(68,100),
  X(20,52), X(52,84), X(20,52), X(20,36), X(52,68), X(84,100), X(4,20), X(36,52),
  X(68,84), X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92),
  X(28,60), X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40),
  X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80),
  X(96,112), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114)
};
M(116) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,53), X(53,85),
  X(21,53), X(21,37), X(53,69), X(85,101), X(5,21), X(37,53), X(69,85), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(3,67), X(35,99), X(3,35), X(67,99), X(19,83),
  X(51,115), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(43,107), X(11,43), X(75,107), X(27,59), X(59,91), X(27,59),
  X(27,43), X(59,75), X(91,107), X(11,27), X(43,59), X(75,91), X(11,19),
  X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(7,71),
  X(39,103), X(7,39), X(71,103), X(23,55), X(55,87), X(23,55), X(23,39),
  X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,79), X(47,111),
  X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47), X(63,79),
  X(95,111), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(103,107), X(111,115), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(2,66), X(34,98), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50), X(82,114),
  X(2,18), X(34,50), X(66,82), X(98,114), X(10,74), X(42,106), X(10,42),
  X(74,106), X(26,58), X(58,90), X(26,58), X(26,42), X(58,74), X(90,106),
  X(10,26), X(42,58), X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(106,114), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(6,70), X(38,102), X(6,38), X(70,102), X(22,54),
  X(54,86), X(22,54), X(22,38), X(54,70), X(86,102), X(6,22), X(38,54), X(70,86),
  X(14,78), X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62),
  X(30,46), X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(4,68), X(36,100), X(4,36), X(68,100),
  X(20,84), X(52,116), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92),
  X(28,60), X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40),
  X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80),
  X(96,112), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80),
  X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96),
  X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116)
};
M(117) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85), X(53,117),
  X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99), X(3,35),
  X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59),
  X(59,91), X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59),
  X(75,91), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55), X(55,87),
  X(23,55), X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(91,93), X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95),
  X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(2,66), X(34,98),
  X(2,34), X(66,98), X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58),
  X(58,90), X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58),
  X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(6,70), X(38,102), X(6,38), X(70,102), X(22,54), X(54,86),
  X(22,54), X(22,38), X(54,70), X(86,102), X(6,22), X(38,54), X(70,86), X(14,78),
  X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46),
  X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(6,10), X(14,18), X(22,26),
  X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90),
  X(94,98), X(102,106), X(110,114), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(4,68), X(36,100), X(4,36), X(68,100), X(20,84),
  X(52,116), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92), X(28,60),
  X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(12,20),
  X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40),
  X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80),
  X(96,112), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65),
  X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81),
  X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97),
  X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116)
};
M(118) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85), X(53,117),
  X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99), X(3,35),
  X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59),
  X(59,91), X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59),
  X(75,91), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,55), X(55,87),
  X(23,55), X(23,39), X(55,71), X(87,103), X(7,23), X(39,55), X(71,87), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(91,93), X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31),
  X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63),
  X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95),
  X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(2,66), X(34,98),
  X(2,34), X(66,98), X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58),
  X(58,90), X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58),
  X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(6,70), X(38,102), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46),
  X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(4,68), X(36,100), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,60),
  X(60,92), X(28,60), X(28,44), X(60,76), X(92,108), X(12,28), X(44,60),
  X(76,92), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100),
  X(108,116), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(8,72), X(40,104), X(8,40), X(72,104), X(24,56), X(56,88),
  X(24,56), X(24,40), X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48),
  X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(116,118), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118)
};
M(119) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85), X(53,117),
  X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99), X(3,35),
  X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59),
  X(59,91), X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59),
  X(75,91), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103), X(105,107),
  X(109,111), X(113,115), X(117,119), X(2,66), X(34,98), X(2,34), X(66,98),
  X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82),
  X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90),
  X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(6,22), X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46),
  X(78,110), X(30,62), X(62,94), X(30,62), X(30,46), X(62,78), X(94,110),
  X(14,30), X(46,62), X(78,94), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102),
  X(106,110), X(114,118), X(4,68), X(36,100), X(4,36), X(68,100), X(20,84),
  X(52,116), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92), X(28,60),
  X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(12,20),
  X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,56), X(56,88), X(24,56), X(24,40),
  X(56,72), X(88,104), X(8,24), X(40,56), X(72,88), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80),
  X(96,112), X(16,32), X(48,64), X(80,96), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(116,118), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118)
};
M(120) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,57), X(57,89), X(25,57), X(25,41), X(57,73), X(89,105),
  X(9,25), X(41,57), X(73,89), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85), X(53,117),
  X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117), X(13,77),
  X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61), X(29,45),
  X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99), X(3,35),
  X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59),
  X(59,91), X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59),
  X(75,91), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103), X(105,107),
  X(109,111), X(113,115), X(117,119), X(2,66), X(34,98), X(2,34), X(66,98),
  X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82),
  X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58), X(58,90),
  X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58), X(74,90),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(6,22), X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46),
  X(78,110), X(30,62), X(62,94), X(30,62), X(30,46), X(62,78), X(94,110),
  X(14,30), X(46,62), X(78,94), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46),
  X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102),
  X(106,110), X(114,118), X(4,68), X(36,100), X(4,36), X(68,100), X(20,84),
  X(52,116), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,60), X(60,92), X(28,60),
  X(28,44), X(60,76), X(92,108), X(12,28), X(44,60), X(76,92), X(12,20),
  X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(48,112), X(16,48),
  X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80), X(96,112),
  X(16,32), X(48,64), X(80,96), X(16,24), X(32,40), X(48,56), X(64,72), X(80,88),
  X(96,104), X(112,120), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48),
  X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104),
  X(108,112), X(116,120), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120)
};
M(121) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21),
  X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59),
  X(59,91), X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59),
  X(75,91), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,58),
  X(58,90), X(26,58), X(26,42), X(58,74), X(90,106), X(10,26), X(42,58),
  X(74,90), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(6,70), X(38,102), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46),
  X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(4,68), X(36,100), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,60),
  X(60,92), X(28,60), X(28,44), X(60,76), X(92,108), X(12,28), X(44,60),
  X(76,92), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100),
  X(108,116), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88), X(56,120),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48),
  X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120)
};
M(122) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21),
  X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,59),
  X(59,91), X(27,59), X(27,43), X(59,75), X(91,107), X(11,27), X(43,59),
  X(75,91), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(2,66), X(34,98), X(2,34),
  X(66,98), X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(6,70), X(38,102), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46),
  X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(4,68), X(36,100),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20),
  X(36,52), X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108),
  X(28,60), X(60,92), X(28,60), X(28,44), X(60,76), X(92,108), X(12,28),
  X(44,60), X(76,92), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84),
  X(92,100), X(108,116), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(48,112), X(16,48), X(80,112), X(32,64), X(64,96), X(32,64),
  X(32,48), X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(16,24),
  X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122)
};
M(123) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21),
  X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,91),
  X(59,123), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91), X(107,123),
  X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107),
  X(115,123), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(2,66), X(34,98),
  X(2,34), X(66,98), X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(6,70), X(38,102), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46),
  X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(4,68), X(36,100),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20),
  X(36,52), X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108),
  X(28,60), X(60,92), X(28,60), X(28,44), X(60,76), X(92,108), X(12,28),
  X(44,60), X(76,92), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84),
  X(92,100), X(108,116), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(48,112), X(16,48), X(80,112), X(32,64), X(64,96), X(32,64),
  X(32,48), X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(16,24),
  X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122)
};
M(124) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,61), X(61,93), X(29,61),
  X(29,45), X(61,77), X(93,109), X(13,29), X(45,61), X(77,93), X(13,21),
  X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(3,67), X(35,99),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,91),
  X(59,123), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91), X(107,123),
  X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107),
  X(115,123), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,63), X(63,95), X(31,63), X(31,47),
  X(63,79), X(95,111), X(15,31), X(47,63), X(79,95), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(2,66), X(34,98),
  X(2,34), X(66,98), X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(6,70), X(38,102), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(46,110), X(14,46), X(78,110), X(30,62), X(62,94), X(30,62), X(30,46),
  X(62,78), X(94,110), X(14,30), X(46,62), X(78,94), X(14,22), X(30,38),
  X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(4,68), X(36,100),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20),
  X(36,52), X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108),
  X(28,92), X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(48,112), X(16,48), X(80,112), X(32,64), X(64,96), X(32,64),
  X(32,48), X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(16,24),
  X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76),
  X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124)
};
M(125) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61),
  X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(3,67), X(35,99), X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39), X(71,103),
  X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,63), X(63,95),
  X(31,63), X(31,47), X(63,79), X(95,111), X(15,31), X(47,63), X(79,95),
  X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(111,119),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(7,11),
  X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75),
  X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(2,66), X(34,98), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114), X(10,74),
  X(42,106), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122),
  X(10,26), X(42,58), X(74,90), X(106,122), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(6,70), X(38,102),
  X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46), X(78,110),
  X(30,62), X(62,94), X(30,62), X(30,46), X(62,78), X(94,110), X(14,30),
  X(46,62), X(78,94), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(4,68), X(36,100), X(4,36), X(68,100),
  X(20,84), X(52,116), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92), X(60,124),
  X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(8,72), X(40,104), X(8,40), X(72,104), X(24,88), X(56,120), X(24,56),
  X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48), X(64,80),
  X(96,112), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(112,120), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124)
};
M(126) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61),
  X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(3,67), X(35,99), X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39), X(71,103),
  X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,63), X(63,95),
  X(31,63), X(31,47), X(63,79), X(95,111), X(15,31), X(47,63), X(79,95),
  X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(111,119),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(7,11),
  X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75),
  X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(2,66), X(34,98), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114), X(10,74),
  X(42,106), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122),
  X(10,26), X(42,58), X(74,90), X(106,122), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(6,70), X(38,102),
  X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46), X(78,110),
  X(30,94), X(62,126), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94),
  X(110,126), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(4,68), X(36,100), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88), X(56,120),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48),
  X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(124,126), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126)
};
M(127) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61),
  X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(3,67), X(35,99), X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39), X(71,103),
  X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119),
  X(123,127), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(2,66), X(34,98), X(2,34), X(66,98), X(18,82),
  X(50,114), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114),
  X(10,74), X(42,106), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58),
  X(90,122), X(10,26), X(42,58), X(74,90), X(106,122), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(6,22), X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46),
  X(78,110), X(30,94), X(62,126), X(30,62), X(94,126), X(14,30), X(46,62),
  X(78,94), X(110,126), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(4,68), X(36,100), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88), X(56,120),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,64), X(64,96), X(32,64), X(32,48),
  X(64,80), X(96,112), X(16,32), X(48,64), X(80,96), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(124,126), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126)
};
M(128) = {
  X(1,65), X(33,97), X(1,33), X(65,97), X(17,81), X(49,113), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105), X(9,41),
  X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25), X(41,57),
  X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(5,69), X(37,101), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85), X(101,117),
  X(13,77), X(45,109), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61),
  X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(3,67), X(35,99), X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39), X(71,103),
  X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119),
  X(123,127), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(2,66), X(34,98), X(2,34), X(66,98), X(18,82),
  X(50,114), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114),
  X(10,74), X(42,106), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58),
  X(90,122), X(10,26), X(42,58), X(74,90), X(106,122), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(6,70),
  X(38,102), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(6,22), X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46),
  X(78,110), X(30,94), X(62,126), X(30,62), X(94,126), X(14,30), X(46,62),
  X(78,94), X(110,126), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(4,68), X(36,100), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88), X(56,120),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128)
};
M(129) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(37,101),
  X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45), X(77,109),
  X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(3,67), X(35,99),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,91),
  X(59,123), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91), X(107,123),
  X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107),
  X(115,123), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(2,66), X(34,98), X(2,34), X(66,98),
  X(18,82), X(50,114), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82),
  X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90), X(58,122),
  X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122), X(2,10),
  X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122),
  X(6,70), X(38,102), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54),
  X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78), X(46,110),
  X(14,46), X(78,110), X(30,94), X(62,126), X(30,62), X(94,126), X(14,30),
  X(46,62), X(78,94), X(110,126), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(4,68), X(36,100),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(4,20),
  X(36,52), X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108),
  X(28,92), X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64),
  X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128)
};
M(130) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(37,101),
  X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45), X(77,109),
  X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(3,67), X(35,99),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107), X(27,91),
  X(59,123), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91), X(107,123),
  X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107),
  X(115,123), X(7,71), X(39,103), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(6,70), X(38,102), X(6,38), X(70,102), X(22,86),
  X(54,118), X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118),
  X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126), X(30,62),
  X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(4,68), X(36,100), X(4,36), X(68,100), X(20,84), X(52,116),
  X(20,52), X(84,116), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76),
  X(44,108), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60), X(92,124),
  X(12,28), X(44,60), X(76,92), X(108,124), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(8,72), X(40,104),
  X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120), X(8,24),
  X(40,56), X(72,88), X(104,120), X(16,80), X(48,112), X(16,48), X(80,112),
  X(32,96), X(64,128), X(32,64), X(96,128), X(16,32), X(48,64), X(80,96),
  X(112,128), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106),
  X(108,110), X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130)
};
M(131) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(37,101),
  X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45), X(77,109),
  X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(3,67), X(67,131),
  X(3,67), X(35,99), X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(51,115),
  X(19,51), X(83,115), X(19,35), X(51,67), X(83,99), X(115,131), X(3,19),
  X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107),
  X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39), X(71,103),
  X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18),
  X(34,50), X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106),
  X(26,90), X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90),
  X(106,122), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(6,70), X(38,102), X(6,38), X(70,102),
  X(22,86), X(54,118), X(22,54), X(86,118), X(6,22), X(38,54), X(70,86),
  X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(4,68), X(36,100), X(4,36), X(68,100), X(20,84),
  X(52,116), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60),
  X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(8,72),
  X(40,104), X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(48,112), X(16,48),
  X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(16,32), X(48,64),
  X(80,96), X(112,128), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(120,128), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106),
  X(108,110), X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130)
};
M(132) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(37,101),
  X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45), X(77,109),
  X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(3,67), X(67,131),
  X(3,67), X(35,99), X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(51,115),
  X(19,51), X(83,115), X(19,35), X(51,67), X(83,99), X(115,131), X(3,19),
  X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43), X(75,107),
  X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39), X(71,103),
  X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18),
  X(34,50), X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106),
  X(26,90), X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90),
  X(106,122), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(6,70), X(38,102), X(6,38), X(70,102),
  X(22,86), X(54,118), X(22,54), X(86,118), X(6,22), X(38,54), X(70,86),
  X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116),
  X(20,36), X(52,68), X(84,100), X(116,132), X(4,20), X(36,52), X(68,84),
  X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92), X(60,124),
  X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(12,20),
  X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(124,132),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88), X(56,120),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32),
  X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64),
  X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132)
};
M(133) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(3,67),
  X(67,131), X(3,67), X(35,99), X(35,67), X(99,131), X(3,35), X(67,99), X(19,83),
  X(51,115), X(19,51), X(83,115), X(19,35), X(51,67), X(83,99), X(115,131),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39),
  X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55),
  X(71,87), X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,95),
  X(63,127), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51),
  X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99), X(103,107),
  X(111,115), X(119,123), X(127,131), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(129,131), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(6,70), X(38,102), X(6,38), X(70,102), X(22,86),
  X(54,118), X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118),
  X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126), X(30,62),
  X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36),
  X(52,68), X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(44,108), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60),
  X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(8,72), X(40,104), X(8,40), X(72,104), X(24,88), X(56,120), X(24,56),
  X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(16,32),
  X(48,64), X(80,96), X(112,128), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(120,128), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132)
};
M(134) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(3,67),
  X(67,131), X(3,67), X(35,99), X(35,67), X(99,131), X(3,35), X(67,99), X(19,83),
  X(51,115), X(19,51), X(83,115), X(19,35), X(51,67), X(83,99), X(115,131),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(7,71), X(39,103), X(7,39),
  X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(7,23), X(39,55),
  X(71,87), X(103,119), X(15,79), X(47,111), X(15,47), X(79,111), X(31,95),
  X(63,127), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51),
  X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99), X(103,107),
  X(111,115), X(119,123), X(127,131), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(129,131), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70),
  X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54), X(70,86),
  X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(4,68), X(68,132), X(4,68), X(36,100),
  X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(52,116), X(20,52),
  X(84,116), X(20,36), X(52,68), X(84,100), X(116,132), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64),
  X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76),
  X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120),
  X(124,128), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62),
  X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94),
  X(96,98), X(100,102), X(104,106), X(108,110), X(112,114), X(116,118),
  X(120,122), X(124,126), X(128,130), X(132,134), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134)
};
M(135) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(3,67),
  X(67,131), X(3,67), X(35,99), X(35,67), X(99,131), X(3,35), X(67,99), X(19,83),
  X(51,115), X(19,51), X(83,115), X(19,35), X(51,67), X(83,99), X(115,131),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(7,71), X(71,135), X(7,71),
  X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(7,23),
  X(39,55), X(71,87), X(103,119), X(15,79), X(47,111), X(15,47), X(79,111),
  X(31,95), X(63,127), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95),
  X(111,127), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103),
  X(111,119), X(127,135), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79),
  X(87,95), X(103,111), X(119,127), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70),
  X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54), X(70,86),
  X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(4,68), X(68,132), X(4,68), X(36,100),
  X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(52,116), X(20,52),
  X(84,116), X(20,36), X(52,68), X(84,100), X(116,132), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(8,72), X(40,104), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64),
  X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76),
  X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120),
  X(124,128), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62),
  X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94),
  X(96,98), X(100,102), X(104,106), X(108,110), X(112,114), X(116,118),
  X(120,122), X(124,126), X(128,130), X(132,134), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134)
};
M(136) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(41,105),
  X(9,41), X(73,105), X(25,89), X(57,121), X(25,57), X(89,121), X(9,25),
  X(41,57), X(73,89), X(105,121), X(9,17), X(25,33), X(41,49), X(57,65),
  X(73,81), X(89,97), X(105,113), X(121,129), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(1,5), X(9,13), X(17,21),
  X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85),
  X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(3,67),
  X(67,131), X(3,67), X(35,99), X(35,67), X(99,131), X(3,35), X(67,99), X(19,83),
  X(51,115), X(19,51), X(83,115), X(19,35), X(51,67), X(83,99), X(115,131),
  X(3,19), X(35,51), X(67,83), X(99,115), X(11,75), X(43,107), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(7,71), X(71,135), X(7,71),
  X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87), X(55,119),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(7,23),
  X(39,55), X(71,87), X(103,119), X(15,79), X(47,111), X(15,47), X(79,111),
  X(31,95), X(63,127), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95),
  X(111,127), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103),
  X(111,119), X(127,135), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79),
  X(87,95), X(103,111), X(119,127), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70),
  X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54), X(70,86),
  X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(4,68), X(68,132), X(4,68), X(36,100),
  X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(52,116), X(20,52),
  X(84,116), X(20,36), X(52,68), X(84,100), X(116,132), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72),
  X(104,136), X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120),
  X(24,40), X(56,72), X(88,104), X(120,136), X(8,24), X(40,56), X(72,88),
  X(104,120), X(16,80), X(48,112), X(16,48), X(80,112), X(32,96), X(64,128),
  X(32,64), X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(16,24),
  X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104), X(106,108),
  X(110,112), X(114,116), X(118,120), X(122,124), X(126,128), X(130,132),
  X(134,136), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136)
};
M(137) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(43,107), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59),
  X(91,123), X(11,27), X(43,59), X(75,91), X(107,123), X(11,19), X(27,35),
  X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39),
  X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39), X(55,71),
  X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93),
  X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(42,106), X(10,42), X(74,106), X(26,90),
  X(58,122), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70),
  X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54), X(70,86),
  X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(4,68), X(68,132), X(4,68), X(36,100),
  X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(52,116), X(20,52),
  X(84,116), X(20,36), X(52,68), X(84,100), X(116,132), X(4,20), X(36,52),
  X(68,84), X(100,116), X(12,76), X(44,108), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72),
  X(104,136), X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120),
  X(24,40), X(56,72), X(88,104), X(120,136), X(8,24), X(40,56), X(72,88),
  X(104,120), X(16,80), X(48,112), X(16,48), X(80,112), X(32,96), X(64,128),
  X(32,64), X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(16,24),
  X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104), X(106,108),
  X(110,112), X(114,116), X(118,120), X(122,124), X(126,128), X(130,132),
  X(134,136), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136)
};
M(138) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(43,107), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59),
  X(91,123), X(11,27), X(43,59), X(75,91), X(107,123), X(11,19), X(27,35),
  X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39),
  X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39), X(55,71),
  X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119), X(15,79),
  X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93),
  X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74),
  X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58), X(74,90),
  X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70), X(38,102),
  X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54),
  X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54),
  X(70,86), X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94),
  X(62,126), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126),
  X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118),
  X(126,134), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36), X(52,68),
  X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76),
  X(44,108), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60), X(92,124),
  X(12,28), X(44,60), X(76,92), X(108,124), X(12,20), X(28,36), X(44,52),
  X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(8,72),
  X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104),
  X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(16,32),
  X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56), X(64,72),
  X(80,88), X(96,104), X(112,120), X(128,136), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66),
  X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138)
};
M(139) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39),
  X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119),
  X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(135,139), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18),
  X(34,50), X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58),
  X(74,90), X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22),
  X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46), X(78,110),
  X(30,94), X(62,126), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94),
  X(110,126), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102),
  X(110,118), X(126,134), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36), X(52,68),
  X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76),
  X(44,108), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60), X(92,124),
  X(12,28), X(44,60), X(76,92), X(108,124), X(12,20), X(28,36), X(44,52),
  X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(8,72),
  X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104),
  X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(16,32),
  X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56), X(64,72),
  X(80,88), X(96,104), X(112,120), X(128,136), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34),
  X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66),
  X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137), X(138,139), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138)
};
M(140) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(45,109), X(13,45),
  X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39),
  X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119),
  X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(135,139), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18),
  X(34,50), X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58),
  X(74,90), X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22),
  X(38,54), X(70,86), X(102,118), X(14,78), X(46,110), X(14,46), X(78,110),
  X(30,94), X(62,126), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94),
  X(110,126), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102),
  X(110,118), X(126,134), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36), X(52,68),
  X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76),
  X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108),
  X(28,92), X(60,124), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(12,28), X(44,60), X(76,92), X(108,124), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40),
  X(72,104), X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72),
  X(88,104), X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76),
  X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104), X(106,108),
  X(110,112), X(114,116), X(118,120), X(122,124), X(126,128), X(130,132),
  X(134,136), X(138,140), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140)
};
M(141) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(61,125),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(13,29),
  X(45,61), X(77,93), X(109,125), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39),
  X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119),
  X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(135,139), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74),
  X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58), X(74,90),
  X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70), X(38,102),
  X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54),
  X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54),
  X(70,86), X(102,118), X(14,78), X(46,110), X(14,46), X(78,110), X(30,94),
  X(62,126), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126),
  X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118),
  X(126,134), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36),
  X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36), X(52,68),
  X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76),
  X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108),
  X(28,92), X(60,124), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(12,28), X(44,60), X(76,92), X(108,124), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40),
  X(72,104), X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72),
  X(88,104), X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(8,12),
  X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76),
  X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104), X(106,108),
  X(110,112), X(114,116), X(118,120), X(122,124), X(126,128), X(130,132),
  X(134,136), X(138,140), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137), X(138,139), X(140,141), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140)
};
M(142) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(61,125),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(13,29),
  X(45,61), X(77,93), X(109,125), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39),
  X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119),
  X(15,79), X(47,111), X(15,47), X(79,111), X(31,95), X(63,127), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(135,139), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18), X(34,50),
  X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74),
  X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58), X(74,90),
  X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70), X(38,102),
  X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54),
  X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54),
  X(70,86), X(102,118), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78),
  X(110,142), X(14,46), X(78,110), X(30,94), X(62,126), X(30,62), X(94,126),
  X(30,46), X(62,78), X(94,110), X(126,142), X(14,30), X(46,62), X(78,94),
  X(110,126), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142), X(4,68),
  X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36), X(68,100),
  X(20,84), X(52,116), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76), X(76,140),
  X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140),
  X(12,28), X(44,60), X(76,92), X(108,124), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(8,72),
  X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104),
  X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(48,112),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(16,32),
  X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56), X(64,72),
  X(80,88), X(96,104), X(112,120), X(128,136), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110),
  X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(132,134),
  X(136,138), X(140,142), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142)
};
M(143) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(61,125),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(13,29),
  X(45,61), X(77,93), X(109,125), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39),
  X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119),
  X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47),
  X(79,111), X(31,95), X(63,127), X(31,63), X(95,127), X(31,47), X(63,79),
  X(95,111), X(127,143), X(15,31), X(47,63), X(79,95), X(111,127), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18),
  X(34,50), X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58),
  X(74,90), X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22),
  X(38,54), X(70,86), X(102,118), X(14,78), X(78,142), X(14,78), X(46,110),
  X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(62,126), X(30,62),
  X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(14,30), X(46,62),
  X(78,94), X(110,126), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36),
  X(52,68), X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44),
  X(76,108), X(28,92), X(60,124), X(28,60), X(92,124), X(28,44), X(60,76),
  X(92,108), X(124,140), X(12,28), X(44,60), X(76,92), X(108,124), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136),
  X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120), X(24,40),
  X(56,72), X(88,104), X(120,136), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(48,112), X(16,48), X(80,112), X(32,96), X(64,128), X(32,64),
  X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68),
  X(72,76), X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124),
  X(128,132), X(136,140), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(124,126),
  X(128,130), X(132,134), X(136,138), X(140,142), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139), X(140,141),
  X(142,143), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142)
};
M(144) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(49,113), X(17,49), X(81,113), X(17,33), X(49,65), X(81,97),
  X(113,129), X(1,17), X(33,49), X(65,81), X(97,113), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105), X(121,137),
  X(9,25), X(41,57), X(73,89), X(105,121), X(1,9), X(17,25), X(33,41), X(49,57),
  X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(5,69), X(69,133),
  X(5,69), X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85),
  X(53,117), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101), X(117,133),
  X(5,21), X(37,53), X(69,85), X(101,117), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(61,125),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(13,29),
  X(45,61), X(77,93), X(109,125), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83), X(99,115),
  X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139), X(11,43),
  X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119), X(23,39),
  X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87), X(103,119),
  X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47),
  X(79,111), X(31,95), X(63,127), X(31,63), X(95,127), X(31,47), X(63,79),
  X(95,111), X(127,143), X(15,31), X(47,63), X(79,95), X(111,127), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18),
  X(34,50), X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58),
  X(74,90), X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22),
  X(38,54), X(70,86), X(102,118), X(14,78), X(78,142), X(14,78), X(46,110),
  X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(62,126), X(30,62),
  X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(14,30), X(46,62),
  X(78,94), X(110,126), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36),
  X(52,68), X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44),
  X(76,108), X(28,92), X(60,124), X(28,60), X(92,124), X(28,44), X(60,76),
  X(92,108), X(124,140), X(12,28), X(44,60), X(76,92), X(108,124), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136),
  X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120), X(24,40),
  X(56,72), X(88,104), X(120,136), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48),
  X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48), X(64,80),
  X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144)
};
M(145) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(5,21), X(37,53), X(69,85),
  X(101,117), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141),
  X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(29,45),
  X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93), X(109,125),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83),
  X(99,115), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139),
  X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123),
  X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107),
  X(115,123), X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71),
  X(103,135), X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119),
  X(23,39), X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(63,127), X(31,63), X(95,127), X(31,47),
  X(63,79), X(95,111), X(127,143), X(15,31), X(47,63), X(79,95), X(111,127),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(2,66), X(66,130),
  X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(50,114),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(2,18),
  X(34,50), X(66,82), X(98,114), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26), X(42,58),
  X(74,90), X(106,122), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(54,118),
  X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(6,22),
  X(38,54), X(70,86), X(102,118), X(14,78), X(78,142), X(14,78), X(46,110),
  X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(62,126), X(30,62),
  X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(14,30), X(46,62),
  X(78,94), X(110,126), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68), X(100,132),
  X(4,36), X(68,100), X(20,84), X(52,116), X(20,52), X(84,116), X(20,36),
  X(52,68), X(84,100), X(116,132), X(4,20), X(36,52), X(68,84), X(100,116),
  X(12,76), X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44),
  X(76,108), X(28,92), X(60,124), X(28,60), X(92,124), X(28,44), X(60,76),
  X(92,108), X(124,140), X(12,28), X(44,60), X(76,92), X(108,124), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136),
  X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120), X(24,40),
  X(56,72), X(88,104), X(120,136), X(8,24), X(40,56), X(72,88), X(104,120),
  X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48),
  X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48), X(64,80),
  X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(122,123), X(124,125), X(126,127),
  X(128,129), X(130,131), X(132,133), X(134,135), X(136,137), X(138,139),
  X(140,141), X(142,143), X(144,145), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144)
};
M(146) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(5,21), X(37,53), X(69,85),
  X(101,117), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141),
  X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(29,45),
  X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93), X(109,125),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(51,115), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(3,19), X(35,51), X(67,83),
  X(99,115), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139),
  X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123),
  X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107),
  X(115,123), X(131,139), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71),
  X(103,135), X(7,39), X(71,103), X(23,87), X(55,119), X(23,55), X(87,119),
  X(23,39), X(55,71), X(87,103), X(119,135), X(7,23), X(39,55), X(71,87),
  X(103,119), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(63,127), X(31,63), X(95,127), X(31,47),
  X(63,79), X(95,111), X(127,143), X(15,31), X(47,63), X(79,95), X(111,127),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(2,66), X(66,130),
  X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122),
  X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26),
  X(42,58), X(74,90), X(106,122), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(54,118), X(22,54), X(86,118), X(22,38), X(54,70),
  X(86,102), X(118,134), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46), X(78,110),
  X(30,94), X(62,126), X(30,62), X(94,126), X(30,46), X(62,78), X(94,110),
  X(126,142), X(14,30), X(46,62), X(78,94), X(110,126), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142), X(4,68),
  X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36), X(68,100),
  X(20,84), X(52,116), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76), X(76,140),
  X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140),
  X(12,28), X(44,60), X(76,92), X(108,124), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(8,72),
  X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104),
  X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(64,128), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(132,136), X(140,144), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(116,118), X(120,122), X(124,126), X(128,130), X(132,134), X(136,138),
  X(140,142), X(144,146), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146)
};
M(147) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(5,21), X(37,53), X(69,85),
  X(101,117), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141),
  X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(29,45),
  X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93), X(109,125),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115),
  X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135),
  X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87),
  X(55,119), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135),
  X(7,23), X(39,55), X(71,87), X(103,119), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(145,147), X(2,66), X(66,130),
  X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122),
  X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26),
  X(42,58), X(74,90), X(106,122), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(54,118), X(22,54), X(86,118), X(22,38), X(54,70),
  X(86,102), X(118,134), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46), X(78,110),
  X(30,94), X(62,126), X(30,62), X(94,126), X(30,46), X(62,78), X(94,110),
  X(126,142), X(14,30), X(46,62), X(78,94), X(110,126), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142), X(4,68),
  X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36), X(68,100),
  X(20,84), X(52,116), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(4,20), X(36,52), X(68,84), X(100,116), X(12,76), X(76,140),
  X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140),
  X(12,28), X(44,60), X(76,92), X(108,124), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(8,72),
  X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104),
  X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(64,128), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(132,136), X(140,144), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(116,118), X(120,122), X(124,126), X(128,130), X(132,134), X(136,138),
  X(140,142), X(144,146), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(138,139), X(140,141), X(142,143), X(144,145),
  X(146,147), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146)
};
M(148) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(53,117), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(5,21), X(37,53), X(69,85),
  X(101,117), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141),
  X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125), X(29,45),
  X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93), X(109,125),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(5,9), X(13,17), X(21,25), X(29,33), X(37,41),
  X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115),
  X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135),
  X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87),
  X(55,119), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135),
  X(7,23), X(39,55), X(71,87), X(103,119), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(145,147), X(2,66), X(66,130),
  X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(58,122),
  X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(10,26),
  X(42,58), X(74,90), X(106,122), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(54,118), X(22,54), X(86,118), X(22,38), X(54,70),
  X(86,102), X(118,134), X(6,22), X(38,54), X(70,86), X(102,118), X(14,78),
  X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46), X(78,110),
  X(30,94), X(62,126), X(30,62), X(94,126), X(30,46), X(62,78), X(94,110),
  X(126,142), X(14,30), X(46,62), X(78,94), X(110,126), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142), X(4,68),
  X(68,132), X(4,68), X(36,100), X(36,68), X(100,132), X(4,36), X(68,100),
  X(20,84), X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52),
  X(84,116), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(12,76),
  X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108),
  X(28,92), X(60,124), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(12,28), X(44,60), X(76,92), X(108,124), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(140,148),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(132,140), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72),
  X(104,136), X(8,40), X(72,104), X(24,88), X(56,120), X(24,56), X(88,120),
  X(24,40), X(56,72), X(88,104), X(120,136), X(8,24), X(40,56), X(72,88),
  X(104,120), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48),
  X(64,80), X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(136,144), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44),
  X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100),
  X(104,108), X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(132,136), X(140,144), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148)
};
M(149) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115),
  X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135),
  X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87),
  X(55,119), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135),
  X(7,23), X(39,55), X(71,87), X(103,119), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(2,66), X(66,130), X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(10,74),
  X(74,138), X(10,74), X(42,106), X(42,74), X(106,138), X(10,42), X(74,106),
  X(26,90), X(58,122), X(26,58), X(90,122), X(26,42), X(58,74), X(90,106),
  X(122,138), X(10,26), X(42,58), X(74,90), X(106,122), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70),
  X(102,134), X(6,38), X(70,102), X(22,86), X(54,118), X(22,54), X(86,118),
  X(22,38), X(54,70), X(86,102), X(118,134), X(6,22), X(38,54), X(70,86),
  X(102,118), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142),
  X(14,46), X(78,110), X(30,94), X(62,126), X(30,62), X(94,126), X(30,46),
  X(62,78), X(94,110), X(126,142), X(14,30), X(46,62), X(78,94), X(110,126),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(134,142), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60), X(92,124),
  X(28,44), X(60,76), X(92,108), X(124,140), X(12,28), X(44,60), X(76,92),
  X(108,124), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100),
  X(108,116), X(124,132), X(140,148), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136),
  X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(80,144), X(16,80),
  X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96), X(64,128),
  X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144), X(16,32),
  X(48,64), X(80,96), X(112,128), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(144,148), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(138,139), X(140,141), X(142,143), X(144,145),
  X(146,147), X(148,149), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148)
};
M(150) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115),
  X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135),
  X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87),
  X(55,119), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135),
  X(7,23), X(39,55), X(71,87), X(103,119), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(2,66), X(66,130), X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(10,74),
  X(74,138), X(10,74), X(42,106), X(42,74), X(106,138), X(10,42), X(74,106),
  X(26,90), X(58,122), X(26,58), X(90,122), X(26,42), X(58,74), X(90,106),
  X(122,138), X(10,26), X(42,58), X(74,90), X(106,122), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70),
  X(102,134), X(6,38), X(70,102), X(22,86), X(86,150), X(22,86), X(54,118),
  X(54,86), X(118,150), X(22,54), X(86,118), X(6,22), X(38,54), X(70,86),
  X(102,118), X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78),
  X(110,142), X(14,46), X(78,110), X(30,94), X(62,126), X(30,62), X(94,126),
  X(30,46), X(62,78), X(94,110), X(126,142), X(14,30), X(46,62), X(78,94),
  X(110,126), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102),
  X(110,118), X(126,134), X(142,150), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60), X(92,124),
  X(28,44), X(60,76), X(92,108), X(124,140), X(12,28), X(44,60), X(76,92),
  X(108,124), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100),
  X(108,116), X(124,132), X(140,148), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(56,120), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136),
  X(8,24), X(40,56), X(72,88), X(104,120), X(16,80), X(80,144), X(16,80),
  X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96), X(64,128),
  X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144), X(16,32),
  X(48,64), X(80,96), X(112,128), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(144,148), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150)
};
M(151) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115),
  X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135),
  X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87),
  X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55), X(87,119),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95),
  X(63,127), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143),
  X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(2,66), X(66,130), X(2,66), X(34,98), X(34,66), X(98,130),
  X(2,34), X(66,98), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82),
  X(114,146), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114),
  X(130,146), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74), X(106,138),
  X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122), X(26,42),
  X(58,74), X(90,106), X(122,138), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(138,146), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(14,30),
  X(46,62), X(78,94), X(110,126), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(94,102), X(110,118), X(126,134), X(142,150), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(130,134), X(138,142), X(146,150), X(4,68), X(68,132), X(4,68),
  X(36,100), X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(84,148),
  X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76),
  X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92), X(60,124),
  X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140), X(12,28),
  X(44,60), X(76,92), X(108,124), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40),
  X(72,104), X(24,88), X(56,120), X(24,56), X(88,120), X(24,40), X(56,72),
  X(88,104), X(120,136), X(8,24), X(40,56), X(72,88), X(104,120), X(16,80),
  X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112),
  X(32,96), X(64,128), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112),
  X(128,144), X(16,32), X(48,64), X(80,96), X(112,128), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144),
  X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68),
  X(72,76), X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124),
  X(128,132), X(136,140), X(144,148), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137), X(138,139), X(140,141), X(142,143),
  X(144,145), X(146,147), X(148,149), X(150,151), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150)
};
M(152) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(57,121), X(25,57), X(89,121), X(25,41), X(57,73), X(89,105),
  X(121,137), X(9,25), X(41,57), X(73,89), X(105,121), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105),
  X(113,121), X(129,137), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67),
  X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115),
  X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91),
  X(107,123), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135),
  X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87),
  X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55), X(87,119),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95),
  X(63,127), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143),
  X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(2,66), X(66,130), X(2,66), X(34,98), X(34,66), X(98,130),
  X(2,34), X(66,98), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82),
  X(114,146), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114),
  X(130,146), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74), X(106,138),
  X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122), X(26,42),
  X(58,74), X(90,106), X(122,138), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(138,146), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(14,30),
  X(46,62), X(78,94), X(110,126), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(94,102), X(110,118), X(126,134), X(142,150), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(130,134), X(138,142), X(146,150), X(4,68), X(68,132), X(4,68),
  X(36,100), X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(84,148),
  X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76),
  X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92), X(60,124),
  X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140), X(12,28),
  X(44,60), X(76,92), X(108,124), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40),
  X(72,104), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48),
  X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48), X(64,80),
  X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128), X(16,24),
  X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136),
  X(144,152), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152)
};
M(153) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115), X(51,83),
  X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139),
  X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123),
  X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(107,115),
  X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135), X(7,71),
  X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87), X(87,151),
  X(23,87), X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(7,23),
  X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119),
  X(123,127), X(131,135), X(139,143), X(147,151), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(2,66), X(66,130), X(2,66), X(34,98), X(34,66), X(98,130),
  X(2,34), X(66,98), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82),
  X(114,146), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114),
  X(130,146), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74), X(106,138),
  X(10,42), X(74,106), X(26,90), X(58,122), X(26,58), X(90,122), X(26,42),
  X(58,74), X(90,106), X(122,138), X(10,26), X(42,58), X(74,90), X(106,122),
  X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114),
  X(122,130), X(138,146), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(14,30),
  X(46,62), X(78,94), X(110,126), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(94,102), X(110,118), X(126,134), X(142,150), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(130,134), X(138,142), X(146,150), X(4,68), X(68,132), X(4,68),
  X(36,100), X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(84,148),
  X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76),
  X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92), X(60,124),
  X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140), X(12,28),
  X(44,60), X(76,92), X(108,124), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40),
  X(72,104), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48),
  X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48), X(64,80),
  X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128), X(16,24),
  X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136),
  X(144,152), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139), X(140,141),
  X(142,143), X(144,145), X(146,147), X(148,149), X(150,151), X(152,153), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152)
};
M(154) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115), X(51,83),
  X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139),
  X(11,43), X(75,107), X(27,91), X(59,123), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(11,27), X(43,59), X(75,91), X(107,123),
  X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(107,115),
  X(123,131), X(139,147), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(7,71), X(71,135), X(7,71),
  X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87), X(87,151),
  X(23,87), X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(7,23),
  X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119),
  X(123,127), X(131,135), X(139,143), X(147,151), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(2,66), X(66,130), X(2,66), X(34,98), X(34,66), X(98,130),
  X(2,34), X(66,98), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82),
  X(114,146), X(18,50), X(82,114), X(2,18), X(34,50), X(66,82), X(98,114),
  X(130,146), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74), X(106,138),
  X(10,42), X(74,106), X(26,90), X(90,154), X(26,90), X(58,122), X(58,90),
  X(122,154), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90), X(106,122),
  X(138,154), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(62,126),
  X(30,62), X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(14,30),
  X(46,62), X(78,94), X(110,126), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(94,102), X(110,118), X(126,134), X(142,150), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(150,154), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(60,124), X(28,60), X(92,124),
  X(28,44), X(60,76), X(92,108), X(124,140), X(12,28), X(44,60), X(76,92),
  X(108,124), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100),
  X(108,116), X(124,132), X(140,148), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(64,128), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(16,32), X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(124,126),
  X(128,130), X(132,134), X(136,138), X(140,142), X(144,146), X(148,150),
  X(152,154), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154)
};
M(155) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115), X(51,83),
  X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139),
  X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123), X(59,91),
  X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(115,123), X(131,139), X(147,155), X(7,71), X(71,135), X(7,71),
  X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87), X(87,151),
  X(23,87), X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(7,23),
  X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(135,139), X(143,147), X(151,155), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46),
  X(78,110), X(30,94), X(62,126), X(30,62), X(94,126), X(30,46), X(62,78),
  X(94,110), X(126,142), X(14,30), X(46,62), X(78,94), X(110,126), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(142,150), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(4,68), X(68,132),
  X(4,68), X(36,100), X(36,68), X(100,132), X(4,36), X(68,100), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(12,76), X(76,140),
  X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92),
  X(60,124), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140),
  X(12,28), X(44,60), X(76,92), X(108,124), X(12,20), X(28,36), X(44,52),
  X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136),
  X(8,40), X(72,104), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88),
  X(120,152), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48),
  X(64,80), X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(120,128), X(136,144), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(116,118), X(120,122), X(124,126), X(128,130), X(132,134), X(136,138),
  X(140,142), X(144,146), X(148,150), X(152,154), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154)
};
M(156) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(61,125), X(29,61), X(93,125),
  X(29,45), X(61,77), X(93,109), X(125,141), X(13,29), X(45,61), X(77,93),
  X(109,125), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101),
  X(109,117), X(125,133), X(141,149), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(5,9), X(13,17),
  X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81),
  X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(3,67), X(67,131), X(3,67), X(35,99), X(35,67), X(99,131),
  X(3,35), X(67,99), X(19,83), X(83,147), X(19,83), X(51,115), X(51,83),
  X(115,147), X(19,51), X(83,115), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75), X(107,139),
  X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123), X(59,91),
  X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(115,123), X(131,139), X(147,155), X(7,71), X(71,135), X(7,71),
  X(39,103), X(39,71), X(103,135), X(7,39), X(71,103), X(23,87), X(87,151),
  X(23,87), X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(7,23),
  X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143), X(15,79),
  X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95), X(63,127),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(15,31),
  X(47,63), X(79,95), X(111,127), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(7,11), X(15,19), X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67),
  X(71,75), X(79,83), X(87,91), X(95,99), X(103,107), X(111,115), X(119,123),
  X(127,131), X(135,139), X(143,147), X(151,155), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46),
  X(78,110), X(30,94), X(62,126), X(30,62), X(94,126), X(30,46), X(62,78),
  X(94,110), X(126,142), X(14,30), X(46,62), X(78,94), X(110,126), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(142,150), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(4,68), X(68,132),
  X(4,68), X(36,100), X(36,68), X(100,132), X(4,36), X(68,100), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(12,76), X(76,140),
  X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92),
  X(92,156), X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124),
  X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(148,156), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136),
  X(8,40), X(72,104), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88),
  X(120,152), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48),
  X(64,80), X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(120,128), X(136,144), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156)
};
M(157) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(141,157), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83),
  X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(7,71),
  X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103),
  X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55),
  X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111),
  X(31,95), X(63,127), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111),
  X(127,143), X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43),
  X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(103,107), X(111,115), X(119,123), X(127,131), X(135,139), X(143,147),
  X(151,155), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(147,149),
  X(151,153), X(155,157), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46),
  X(78,110), X(30,94), X(62,126), X(30,62), X(94,126), X(30,46), X(62,78),
  X(94,110), X(126,142), X(14,30), X(46,62), X(78,94), X(110,126), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(142,150), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(4,68), X(68,132),
  X(4,68), X(36,100), X(36,68), X(100,132), X(4,36), X(68,100), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(12,76), X(76,140),
  X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108), X(28,92),
  X(92,156), X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124),
  X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(148,156), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136),
  X(8,40), X(72,104), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88),
  X(120,152), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144),
  X(16,48), X(80,112), X(32,96), X(64,128), X(32,64), X(96,128), X(32,48),
  X(64,80), X(96,112), X(128,144), X(16,32), X(48,64), X(80,96), X(112,128),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(120,128), X(136,144), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(122,123), X(124,125), X(126,127),
  X(128,129), X(130,131), X(132,133), X(134,135), X(136,137), X(138,139),
  X(140,141), X(142,143), X(144,145), X(146,147), X(148,149), X(150,151),
  X(152,153), X(154,155), X(156,157), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156)
};
M(158) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(141,157), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83),
  X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(7,71),
  X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103),
  X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55),
  X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111),
  X(31,95), X(63,127), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111),
  X(127,143), X(15,31), X(47,63), X(79,95), X(111,127), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(7,11), X(15,19), X(23,27), X(31,35), X(39,43),
  X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(103,107), X(111,115), X(119,123), X(127,131), X(135,139), X(143,147),
  X(151,155), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(147,149),
  X(151,153), X(155,157), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(2,66), X(66,130), X(2,66),
  X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46),
  X(78,110), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(134,142), X(150,158), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(64,128), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(16,32), X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(152,156), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(132,136), X(140,144), X(148,152), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110),
  X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(132,134),
  X(136,138), X(140,142), X(144,146), X(148,150), X(152,154), X(156,158), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158)
};
M(159) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(141,157), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83),
  X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(7,71),
  X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103),
  X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55),
  X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(151,159), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(2,66), X(66,130),
  X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46),
  X(78,110), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(134,142), X(150,158), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(64,128), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(16,32), X(48,64), X(80,96), X(112,128), X(16,24), X(32,40), X(48,56),
  X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(152,156), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(132,136), X(140,144), X(148,152), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110),
  X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(132,134),
  X(136,138), X(140,142), X(144,146), X(148,150), X(152,154), X(156,158), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139), X(140,141),
  X(142,143), X(144,145), X(146,147), X(148,149), X(150,151), X(152,153),
  X(154,155), X(156,157), X(158,159), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158)
};
M(160) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(33,65), X(97,129), X(1,33), X(65,97),
  X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145), X(17,49),
  X(81,113), X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73),
  X(73,137), X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(1,9),
  X(17,25), X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121),
  X(129,137), X(145,153), X(5,69), X(69,133), X(5,69), X(37,101), X(37,69),
  X(101,133), X(5,37), X(69,101), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(5,21), X(37,53), X(69,85),
  X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(45,77),
  X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61), X(77,93),
  X(109,125), X(141,157), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83),
  X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(7,71),
  X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103),
  X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55),
  X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(151,159), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(2,66), X(66,130),
  X(2,66), X(34,98), X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38),
  X(70,102), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150),
  X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46),
  X(78,110), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(134,142), X(150,158), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144),
  X(152,160), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160)
};
M(161) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85), X(85,149),
  X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157),
  X(29,93), X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121),
  X(125,129), X(133,137), X(141,145), X(149,153), X(157,161), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83),
  X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(7,71),
  X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103),
  X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55),
  X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(151,159), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(91,93), X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(139,141),
  X(143,145), X(147,149), X(151,153), X(155,157), X(159,161), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(2,66), X(66,130), X(2,66), X(34,98),
  X(34,66), X(98,130), X(2,34), X(66,98), X(18,82), X(82,146), X(18,82),
  X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(2,18), X(34,50),
  X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154), X(26,90),
  X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(6,70),
  X(70,134), X(6,70), X(38,102), X(38,70), X(102,134), X(6,38), X(70,102),
  X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150), X(22,54),
  X(86,118), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(14,78),
  X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46), X(78,110),
  X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62),
  X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126),
  X(134,142), X(150,158), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144),
  X(152,160), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(122,123), X(124,125), X(126,127),
  X(128,129), X(130,131), X(132,133), X(134,135), X(136,137), X(138,139),
  X(140,141), X(142,143), X(144,145), X(146,147), X(148,149), X(150,151),
  X(152,153), X(154,155), X(156,157), X(158,159), X(160,161), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160)
};
M(162) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85), X(85,149),
  X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157),
  X(29,93), X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121),
  X(125,129), X(133,137), X(141,145), X(149,153), X(157,161), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(35,67), X(99,131), X(3,35), X(67,99), X(19,83), X(83,147), X(19,83),
  X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(7,71),
  X(71,135), X(7,71), X(39,103), X(39,71), X(103,135), X(7,39), X(71,103),
  X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151), X(23,55),
  X(87,119), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(151,159), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(91,93), X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(139,141),
  X(143,145), X(147,149), X(151,153), X(155,157), X(159,161), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(2,66), X(66,130), X(2,66), X(34,98),
  X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(18,34),
  X(50,66), X(82,98), X(114,130), X(146,162), X(2,18), X(34,50), X(66,82),
  X(98,114), X(130,146), X(10,74), X(74,138), X(10,74), X(42,106), X(42,74),
  X(106,138), X(10,42), X(74,106), X(26,90), X(90,154), X(26,90), X(58,122),
  X(58,90), X(122,154), X(26,58), X(90,122), X(10,26), X(42,58), X(74,90),
  X(106,122), X(138,154), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(106,114), X(122,130), X(138,146), X(154,162), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138),
  X(146,154), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70), X(102,134),
  X(6,38), X(70,102), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86),
  X(118,150), X(22,54), X(86,118), X(6,22), X(38,54), X(70,86), X(102,118),
  X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142),
  X(14,46), X(78,110), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94),
  X(126,158), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(150,158), X(6,10), X(14,18), X(22,26),
  X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90),
  X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100), X(36,68),
  X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144),
  X(152,160), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(152,154), X(156,158), X(160,162), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152),
  X(154,156), X(158,160), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162)
};
M(163) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85), X(85,149),
  X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157),
  X(29,93), X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121),
  X(125,129), X(133,137), X(141,145), X(149,153), X(157,161), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87),
  X(119,151), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(161,163),
  X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98),
  X(130,162), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138),
  X(10,74), X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90),
  X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122),
  X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146),
  X(154,162), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(94,158),
  X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126), X(14,30),
  X(46,62), X(78,94), X(110,126), X(142,158), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(150,154), X(158,162), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100),
  X(36,68), X(100,132), X(4,36), X(68,100), X(20,84), X(84,148), X(20,84),
  X(52,116), X(52,84), X(116,148), X(20,52), X(84,116), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108),
  X(44,76), X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92),
  X(60,124), X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60),
  X(76,92), X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72),
  X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104),
  X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56),
  X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80),
  X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112),
  X(32,96), X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64),
  X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(116,118), X(120,122), X(124,126), X(128,130), X(132,134), X(136,138),
  X(140,142), X(144,146), X(148,150), X(152,154), X(156,158), X(160,162), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(122,123), X(124,125), X(126,127),
  X(128,129), X(130,131), X(132,133), X(134,135), X(136,137), X(138,139),
  X(140,141), X(142,143), X(144,145), X(146,147), X(148,149), X(150,151),
  X(152,153), X(154,155), X(156,157), X(158,159), X(160,161), X(162,163), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162)
};
M(164) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(37,69), X(101,133), X(5,37), X(69,101), X(21,85), X(85,149),
  X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77),
  X(45,109), X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157),
  X(29,93), X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(5,13), X(21,29), X(37,45),
  X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157),
  X(5,9), X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65),
  X(69,73), X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121),
  X(125,129), X(133,137), X(141,145), X(149,153), X(157,161), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87),
  X(119,151), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(161,163),
  X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98),
  X(130,162), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138),
  X(10,74), X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90),
  X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122),
  X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146),
  X(154,162), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(6,70), X(70,134), X(6,70),
  X(38,102), X(38,70), X(102,134), X(6,38), X(70,102), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(46,78), X(110,142), X(14,46), X(78,110), X(30,94), X(94,158),
  X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126), X(14,30),
  X(46,62), X(78,94), X(110,126), X(142,158), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(150,154), X(158,162), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100),
  X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148),
  X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116), X(20,36),
  X(52,68), X(84,100), X(116,132), X(148,164), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76),
  X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84),
  X(92,100), X(108,116), X(124,132), X(140,148), X(156,164), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(148,156), X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136),
  X(8,40), X(72,104), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88),
  X(120,152), X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120),
  X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144),
  X(16,48), X(80,112), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96),
  X(128,160), X(32,64), X(96,128), X(16,32), X(48,64), X(80,96), X(112,128),
  X(144,160), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164)
};
M(165) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85),
  X(85,149), X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(149,165), X(5,21), X(37,53),
  X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109),
  X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93),
  X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87),
  X(119,151), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(91,93), X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(139,141),
  X(143,145), X(147,149), X(151,153), X(155,157), X(159,161), X(163,165), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(2,66), X(66,130), X(2,66),
  X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114),
  X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18), X(34,50),
  X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154), X(26,90),
  X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162), X(2,10),
  X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122),
  X(130,138), X(146,154), X(6,70), X(70,134), X(6,70), X(38,102), X(38,70),
  X(102,134), X(6,38), X(70,102), X(22,86), X(86,150), X(22,86), X(54,118),
  X(54,86), X(118,150), X(22,54), X(86,118), X(6,22), X(38,54), X(70,86),
  X(102,118), X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78),
  X(110,142), X(14,46), X(78,110), X(30,94), X(94,158), X(30,94), X(62,126),
  X(62,94), X(126,158), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94),
  X(110,126), X(142,158), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164),
  X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84),
  X(52,116), X(52,84), X(116,148), X(20,52), X(84,116), X(20,36), X(52,68),
  X(84,100), X(116,132), X(148,164), X(4,20), X(36,52), X(68,84), X(100,116),
  X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(44,76), X(108,140),
  X(12,44), X(76,108), X(28,92), X(92,156), X(28,92), X(60,124), X(60,92),
  X(124,156), X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124),
  X(140,156), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100),
  X(108,116), X(124,132), X(140,148), X(156,164), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156),
  X(8,72), X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40),
  X(72,104), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48),
  X(80,112), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96), X(128,160),
  X(32,64), X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(136,144), X(152,160), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(4,8), X(12,16), X(20,24), X(28,32),
  X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164)
};
M(166) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85),
  X(85,149), X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(149,165), X(5,21), X(37,53),
  X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109),
  X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93),
  X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(39,71), X(103,135),
  X(7,39), X(71,103), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87),
  X(119,151), X(23,55), X(87,119), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25),
  X(27,29), X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57),
  X(59,61), X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89),
  X(91,93), X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(139,141),
  X(143,145), X(147,149), X(151,153), X(155,157), X(159,161), X(163,165), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(2,66), X(66,130), X(2,66),
  X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114),
  X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18), X(34,50),
  X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74), X(42,106),
  X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154), X(26,90),
  X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162), X(2,10),
  X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122),
  X(130,138), X(146,154), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166),
  X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86),
  X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(22,38), X(54,70),
  X(86,102), X(118,134), X(150,166), X(6,22), X(38,54), X(70,86), X(102,118),
  X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142),
  X(14,46), X(78,110), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94),
  X(126,158), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102),
  X(110,118), X(126,134), X(142,150), X(158,166), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(130,134), X(138,142), X(146,150), X(154,158), X(162,166),
  X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100), X(4,36),
  X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116), X(52,84),
  X(116,148), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100), X(116,132),
  X(148,164), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(12,76),
  X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44), X(76,108),
  X(28,92), X(92,156), X(28,92), X(60,124), X(60,92), X(124,156), X(28,60),
  X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(12,20),
  X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(124,132),
  X(140,148), X(156,164), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72), X(72,136),
  X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144),
  X(152,160), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(152,156),
  X(160,164), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(152,154), X(156,158), X(160,162), X(164,166), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(122,124),
  X(126,128), X(130,132), X(134,136), X(138,140), X(142,144), X(146,148),
  X(150,152), X(154,156), X(158,160), X(162,164), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166)
};
M(167) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85),
  X(85,149), X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(149,165), X(5,21), X(37,53),
  X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109),
  X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93),
  X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103),
  X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151),
  X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47),
  X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159),
  X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159),
  X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(111,119),
  X(127,135), X(143,151), X(159,167), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(151,159), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50),
  X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(6,70), X(70,134), X(6,70), X(38,102),
  X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(22,38),
  X(54,70), X(86,102), X(118,134), X(150,166), X(6,22), X(38,54), X(70,86),
  X(102,118), X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78),
  X(110,142), X(14,46), X(78,110), X(30,94), X(94,158), X(30,94), X(62,126),
  X(62,94), X(126,158), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94),
  X(110,126), X(142,158), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(126,134), X(142,150), X(158,166), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(150,158), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(154,158),
  X(162,166), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(148,164), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(12,76), X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44),
  X(76,108), X(28,92), X(92,156), X(28,92), X(60,124), X(60,92), X(124,156),
  X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(140,148), X(156,164), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72),
  X(72,136), X(8,72), X(40,104), X(40,72), X(104,136), X(8,40), X(72,104),
  X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56),
  X(88,120), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80),
  X(80,144), X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112),
  X(32,96), X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64),
  X(96,128), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44),
  X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100),
  X(104,108), X(112,116), X(120,124), X(128,132), X(136,140), X(144,148),
  X(152,156), X(160,164), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22),
  X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54),
  X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86),
  X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110), X(112,114),
  X(116,118), X(120,122), X(124,126), X(128,130), X(132,134), X(136,138),
  X(140,142), X(144,146), X(148,150), X(152,154), X(156,158), X(160,162),
  X(164,166), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166)
};
M(168) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(41,73), X(105,137), X(9,41), X(73,105), X(25,89),
  X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57), X(89,121),
  X(9,25), X(41,57), X(73,89), X(105,121), X(137,153), X(9,17), X(25,33),
  X(41,49), X(57,65), X(73,81), X(89,97), X(105,113), X(121,129), X(137,145),
  X(153,161), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(5,69), X(69,133), X(5,69),
  X(37,101), X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85),
  X(85,149), X(21,85), X(53,117), X(53,85), X(117,149), X(21,53), X(85,117),
  X(21,37), X(53,69), X(85,101), X(117,133), X(149,165), X(5,21), X(37,53),
  X(69,85), X(101,117), X(133,149), X(13,77), X(77,141), X(13,77), X(45,109),
  X(45,77), X(109,141), X(13,45), X(77,109), X(29,93), X(93,157), X(29,93),
  X(61,125), X(61,93), X(125,157), X(29,61), X(93,125), X(13,29), X(45,61),
  X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53), X(61,69),
  X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37),
  X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115), X(19,35),
  X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51), X(67,83),
  X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107), X(43,75),
  X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83),
  X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103),
  X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151),
  X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143), X(15,47),
  X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159),
  X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159),
  X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103), X(111,119),
  X(127,135), X(143,151), X(159,167), X(7,15), X(23,31), X(39,47), X(55,63),
  X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(151,159), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50),
  X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(6,70), X(70,134), X(6,70), X(38,102),
  X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(22,38),
  X(54,70), X(86,102), X(118,134), X(150,166), X(6,22), X(38,54), X(70,86),
  X(102,118), X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78),
  X(110,142), X(14,46), X(78,110), X(30,94), X(94,158), X(30,94), X(62,126),
  X(62,94), X(126,158), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94),
  X(110,126), X(142,158), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(126,134), X(142,150), X(158,166), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(150,158), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(154,158),
  X(162,166), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(148,164), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(12,76), X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44),
  X(76,108), X(28,92), X(92,156), X(28,92), X(60,124), X(60,92), X(124,156),
  X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(140,148), X(156,164), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72),
  X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104),
  X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136), X(152,168),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152),
  X(160,168), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152),
  X(154,156), X(158,160), X(162,164), X(166,168), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168)
};
M(169) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141), X(13,45),
  X(77,109), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117),
  X(125,133), X(141,149), X(157,165), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67),
  X(75,83), X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167),
  X(39,103), X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87),
  X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71),
  X(87,103), X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103),
  X(111,119), X(127,135), X(143,151), X(159,167), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(151,159),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119),
  X(123,127), X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(131,133), X(135,137), X(139,141), X(143,145),
  X(147,149), X(151,153), X(155,157), X(159,161), X(163,165), X(167,169), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(42,74), X(106,138), X(10,42), X(74,106), X(26,90), X(90,154),
  X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50),
  X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(6,70), X(70,134), X(6,70), X(38,102),
  X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(22,38),
  X(54,70), X(86,102), X(118,134), X(150,166), X(6,22), X(38,54), X(70,86),
  X(102,118), X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(46,78),
  X(110,142), X(14,46), X(78,110), X(30,94), X(94,158), X(30,94), X(62,126),
  X(62,94), X(126,158), X(30,62), X(94,126), X(14,30), X(46,62), X(78,94),
  X(110,126), X(142,158), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(126,134), X(142,150), X(158,166), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(150,158), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(154,158),
  X(162,166), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(148,164), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(12,76), X(76,140), X(12,76), X(44,108), X(44,76), X(108,140), X(12,44),
  X(76,108), X(28,92), X(92,156), X(28,92), X(60,124), X(60,92), X(124,156),
  X(28,60), X(92,124), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(140,148), X(156,164), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(8,72),
  X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104),
  X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136), X(152,168),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152),
  X(160,168), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152),
  X(154,156), X(158,160), X(162,164), X(166,168), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(122,123), X(124,125), X(126,127),
  X(128,129), X(130,131), X(132,133), X(134,135), X(136,137), X(138,139),
  X(140,141), X(142,143), X(144,145), X(146,147), X(148,149), X(150,151),
  X(152,153), X(154,155), X(156,157), X(158,159), X(160,161), X(162,163),
  X(164,165), X(166,167), X(168,169), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164),
  X(165,166), X(167,168)
};
M(170) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141), X(13,45),
  X(77,109), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117),
  X(125,133), X(141,149), X(157,165), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(43,75), X(107,139), X(11,43), X(75,107), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(11,19), X(27,35), X(43,51), X(59,67),
  X(75,83), X(91,99), X(107,115), X(123,131), X(139,147), X(155,163), X(3,11),
  X(19,27), X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123),
  X(131,139), X(147,155), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167),
  X(39,103), X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87),
  X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71),
  X(87,103), X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(47,79), X(111,143),
  X(15,47), X(79,111), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103),
  X(111,119), X(127,135), X(143,151), X(159,167), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(151,159),
  X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63),
  X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119),
  X(123,127), X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(131,133), X(135,137), X(139,141), X(143,145),
  X(147,149), X(151,153), X(155,157), X(159,161), X(163,165), X(167,169), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170), X(26,90),
  X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170),
  X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38),
  X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86),
  X(118,150), X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134),
  X(150,166), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(14,78),
  X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46), X(78,110),
  X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62),
  X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(142,150), X(158,166), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(166,170), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(4,68), X(68,132), X(4,68),
  X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(20,36), X(52,68), X(84,100), X(116,132), X(148,164), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108),
  X(44,76), X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92),
  X(60,124), X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60),
  X(76,92), X(108,124), X(140,156), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(156,164), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(148,156), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168),
  X(40,104), X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88),
  X(56,120), X(56,88), X(120,152), X(24,56), X(88,120), X(24,40), X(56,72),
  X(88,104), X(120,136), X(152,168), X(8,24), X(40,56), X(72,88), X(104,120),
  X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144),
  X(16,48), X(80,112), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96),
  X(128,160), X(32,64), X(96,128), X(16,32), X(48,64), X(80,96), X(112,128),
  X(144,160), X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104),
  X(112,120), X(128,136), X(144,152), X(160,168), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120),
  X(124,128), X(132,136), X(140,144), X(148,152), X(156,160), X(164,168), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(152,154), X(156,158), X(160,162), X(164,166), X(168,170), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(166,168), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(169,170)
};
M(171) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141), X(13,45),
  X(77,109), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117),
  X(125,133), X(141,149), X(157,165), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155),
  X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(151,167),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151),
  X(159,167), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(145,147), X(149,151),
  X(153,155), X(157,159), X(161,163), X(165,167), X(169,171), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170), X(26,90),
  X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170),
  X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38),
  X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86),
  X(118,150), X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134),
  X(150,166), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(14,78),
  X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46), X(78,110),
  X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62),
  X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(142,150), X(158,166), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(166,170), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(4,68), X(68,132), X(4,68),
  X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(20,36), X(52,68), X(84,100), X(116,132), X(148,164), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108),
  X(44,76), X(108,140), X(12,44), X(76,108), X(28,92), X(92,156), X(28,92),
  X(60,124), X(60,92), X(124,156), X(28,60), X(92,124), X(12,28), X(44,60),
  X(76,92), X(108,124), X(140,156), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(156,164), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(148,156), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168),
  X(40,104), X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88),
  X(56,120), X(56,88), X(120,152), X(24,56), X(88,120), X(24,40), X(56,72),
  X(88,104), X(120,136), X(152,168), X(8,24), X(40,56), X(72,88), X(104,120),
  X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80), X(112,144),
  X(16,48), X(80,112), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96),
  X(128,160), X(32,64), X(96,128), X(16,32), X(48,64), X(80,96), X(112,128),
  X(144,160), X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104),
  X(112,120), X(128,136), X(144,152), X(160,168), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160),
  X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64),
  X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120),
  X(124,128), X(132,136), X(140,144), X(148,152), X(156,160), X(164,168), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(152,154), X(156,158), X(160,162), X(164,166), X(168,170), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(166,168), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(169,170)
};
M(172) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(45,77), X(109,141), X(13,45),
  X(77,109), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(13,21), X(29,37), X(45,53), X(61,69), X(77,85), X(93,101), X(109,117),
  X(125,133), X(141,149), X(157,165), X(5,13), X(21,29), X(37,45), X(53,61),
  X(69,77), X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155),
  X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(151,167),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151),
  X(159,167), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(145,147), X(149,151),
  X(153,155), X(157,159), X(161,163), X(165,167), X(169,171), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146), X(18,50),
  X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138), X(10,74),
  X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170), X(26,90),
  X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170),
  X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38),
  X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86),
  X(118,150), X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134),
  X(150,166), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(14,78),
  X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46), X(78,110),
  X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62),
  X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(142,150), X(158,166), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(166,170), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(4,68), X(68,132), X(4,68),
  X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(20,36), X(52,68), X(84,100), X(116,132), X(148,164), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108),
  X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92), X(92,156),
  X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124), X(28,44),
  X(60,76), X(92,108), X(124,140), X(156,172), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(8,72),
  X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104),
  X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136), X(152,168),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152),
  X(160,168), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(168,172), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152),
  X(154,156), X(158,160), X(162,164), X(166,168), X(170,172), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(169,170),
  X(171,172)
};
M(173) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45),
  X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93),
  X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141),
  X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(165,173), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155),
  X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(151,167),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151),
  X(159,167), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153),
  X(155,157), X(159,161), X(163,165), X(167,169), X(171,173), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98),
  X(130,162), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138),
  X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170),
  X(26,90), X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(162,170), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102),
  X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118),
  X(54,86), X(118,150), X(22,54), X(86,118), X(22,38), X(54,70), X(86,102),
  X(118,134), X(150,166), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(46,78), X(110,142), X(14,46),
  X(78,110), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158),
  X(30,62), X(94,126), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158),
  X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118),
  X(126,134), X(142,150), X(158,166), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130),
  X(134,138), X(142,146), X(150,154), X(158,162), X(166,170), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(4,68), X(68,132), X(4,68),
  X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(20,36), X(52,68), X(84,100), X(116,132), X(148,164), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108),
  X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92), X(92,156),
  X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124), X(28,44),
  X(60,76), X(92,108), X(124,140), X(156,172), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(8,72),
  X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104),
  X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136), X(152,168),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152),
  X(160,168), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(168,172), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152),
  X(154,156), X(158,160), X(162,164), X(166,168), X(170,172), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171),
  X(172,173), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172)
};
M(174) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45),
  X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93),
  X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141),
  X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(165,173), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155),
  X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(151,167),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(47,79), X(111,143), X(15,47), X(79,111), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(15,23), X(31,39),
  X(47,55), X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151),
  X(159,167), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153),
  X(155,157), X(159,161), X(163,165), X(167,169), X(171,173), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98),
  X(130,162), X(18,82), X(82,146), X(18,82), X(50,114), X(50,82), X(114,146),
  X(18,50), X(82,114), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(10,74), X(74,138),
  X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170),
  X(26,90), X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(162,170), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102),
  X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118),
  X(54,86), X(118,150), X(22,54), X(86,118), X(22,38), X(54,70), X(86,102),
  X(118,134), X(150,166), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(14,78), X(78,142), X(14,78), X(46,110), X(110,174), X(46,110), X(14,46),
  X(78,110), X(142,174), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94),
  X(126,158), X(30,62), X(94,126), X(30,46), X(62,78), X(94,110), X(126,142),
  X(158,174), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126),
  X(134,142), X(150,158), X(166,174), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(162,166), X(170,174), X(4,68), X(68,132), X(4,68),
  X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84),
  X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52), X(84,116),
  X(20,36), X(52,68), X(84,100), X(116,132), X(148,164), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76), X(44,108),
  X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92), X(92,156),
  X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124), X(28,44),
  X(60,76), X(92,108), X(124,140), X(156,172), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(8,72),
  X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104),
  X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152),
  X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136), X(152,168),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144),
  X(16,80), X(48,112), X(48,80), X(112,144), X(16,48), X(80,112), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152),
  X(160,168), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(8,12), X(16,20), X(24,28),
  X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(168,172), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(4,6), X(8,10), X(12,14),
  X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46),
  X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78),
  X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106),
  X(108,110), X(112,114), X(116,118), X(120,122), X(124,126), X(128,130),
  X(132,134), X(136,138), X(140,142), X(144,146), X(148,150), X(152,154),
  X(156,158), X(160,162), X(164,166), X(168,170), X(172,174), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(122,124),
  X(126,128), X(130,132), X(134,136), X(138,140), X(142,144), X(146,148),
  X(150,152), X(154,156), X(158,160), X(162,164), X(166,168), X(170,172), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(169,170),
  X(171,172), X(173,174)
};
M(175) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45),
  X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93),
  X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141),
  X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(165,173), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155),
  X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(151,167),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31),
  X(47,63), X(79,95), X(111,127), X(143,159), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(151,159),
  X(167,175), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(155,159),
  X(163,167), X(171,175), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(161,163),
  X(165,167), X(169,171), X(173,175), X(2,66), X(66,130), X(2,66), X(34,98),
  X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(18,34),
  X(50,66), X(82,98), X(114,130), X(146,162), X(2,18), X(34,50), X(66,82),
  X(98,114), X(130,146), X(10,74), X(74,138), X(10,74), X(42,106), X(106,170),
  X(42,106), X(10,42), X(74,106), X(138,170), X(26,90), X(90,154), X(26,90),
  X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(26,42), X(58,74),
  X(90,106), X(122,138), X(154,170), X(10,26), X(42,58), X(74,90), X(106,122),
  X(138,154), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150), X(22,54),
  X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(150,166), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94),
  X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126),
  X(30,46), X(62,78), X(94,110), X(126,142), X(158,174), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(130,134), X(138,142), X(146,150), X(154,158), X(162,166),
  X(170,174), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(148,164), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108), X(12,44),
  X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124), X(60,92),
  X(124,156), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140),
  X(156,172), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(148,156), X(164,172), X(8,72), X(72,136), X(8,72), X(40,104),
  X(104,168), X(40,104), X(8,40), X(72,104), X(136,168), X(24,88), X(88,152),
  X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120), X(24,40),
  X(56,72), X(88,104), X(120,136), X(152,168), X(8,24), X(40,56), X(72,88),
  X(104,120), X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(48,80),
  X(112,144), X(16,48), X(80,112), X(32,96), X(96,160), X(32,96), X(64,128),
  X(64,96), X(128,160), X(32,64), X(96,128), X(16,32), X(48,64), X(80,96),
  X(112,128), X(144,160), X(16,24), X(32,40), X(48,56), X(64,72), X(80,88),
  X(96,104), X(112,120), X(128,136), X(144,152), X(160,168), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144),
  X(152,160), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(152,156),
  X(160,164), X(168,172), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(164,168), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110),
  X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(132,134),
  X(136,138), X(140,142), X(144,146), X(148,150), X(152,154), X(156,158),
  X(160,162), X(164,166), X(168,170), X(172,174), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152),
  X(154,156), X(158,160), X(162,164), X(166,168), X(170,172), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171),
  X(172,173), X(174,175), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162), X(163,164), X(165,166),
  X(167,168), X(169,170), X(171,172), X(173,174)
};
M(176) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(49,81), X(113,145),
  X(17,49), X(81,113), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(9,73), X(73,137),
  X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105), X(137,169),
  X(25,89), X(89,153), X(25,89), X(57,121), X(57,89), X(121,153), X(25,57),
  X(89,121), X(25,41), X(57,73), X(89,105), X(121,137), X(153,169), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(1,9), X(17,25), X(33,41),
  X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137), X(145,153),
  X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165), X(37,101),
  X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85), X(53,117),
  X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69), X(85,101),
  X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117), X(133,149),
  X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45),
  X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93),
  X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141),
  X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(5,13),
  X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125),
  X(133,141), X(149,157), X(165,173), X(1,5), X(9,13), X(17,21), X(25,29),
  X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77), X(81,85), X(89,93),
  X(97,101), X(105,109), X(113,117), X(121,125), X(129,133), X(137,141),
  X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51), X(83,115),
  X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19), X(35,51),
  X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75), X(43,107),
  X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155),
  X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43),
  X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87), X(119,151),
  X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135), X(151,167),
  X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79), X(79,143),
  X(15,79), X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31),
  X(47,63), X(79,95), X(111,127), X(143,159), X(7,15), X(23,31), X(39,47),
  X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143), X(151,159),
  X(167,175), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(155,159),
  X(163,167), X(171,175), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(161,163),
  X(165,167), X(169,171), X(173,175), X(2,66), X(66,130), X(2,66), X(34,98),
  X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(50,82), X(114,146), X(18,50), X(82,114), X(18,34),
  X(50,66), X(82,98), X(114,130), X(146,162), X(2,18), X(34,50), X(66,82),
  X(98,114), X(130,146), X(10,74), X(74,138), X(10,74), X(42,106), X(106,170),
  X(42,106), X(10,42), X(74,106), X(138,170), X(26,90), X(90,154), X(26,90),
  X(58,122), X(58,90), X(122,154), X(26,58), X(90,122), X(26,42), X(58,74),
  X(90,106), X(122,138), X(154,170), X(10,26), X(42,58), X(74,90), X(106,122),
  X(138,154), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150), X(22,54),
  X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(150,166), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94),
  X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126),
  X(30,46), X(62,78), X(94,110), X(126,142), X(158,174), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(130,134), X(138,142), X(146,150), X(154,158), X(162,166),
  X(170,174), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(52,84), X(116,148), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100),
  X(116,132), X(148,164), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108), X(12,44),
  X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124), X(60,92),
  X(124,156), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140),
  X(156,172), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(148,156), X(164,172), X(8,72), X(72,136), X(8,72), X(40,104),
  X(104,168), X(40,104), X(8,40), X(72,104), X(136,168), X(24,88), X(88,152),
  X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120), X(24,40),
  X(56,72), X(88,104), X(120,136), X(152,168), X(8,24), X(40,56), X(72,88),
  X(104,120), X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(112,176),
  X(48,112), X(16,48), X(80,112), X(144,176), X(32,96), X(96,160), X(32,96),
  X(64,128), X(64,96), X(128,160), X(32,64), X(96,128), X(32,48), X(64,80),
  X(96,112), X(128,144), X(160,176), X(16,32), X(48,64), X(80,96), X(112,128),
  X(144,160), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(168,176), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(122,124),
  X(126,128), X(130,132), X(134,136), X(138,140), X(142,144), X(146,148),
  X(150,152), X(154,156), X(158,160), X(162,164), X(166,168), X(170,172),
  X(174,176), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172), X(173,174), X(175,176)
};
M(177) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69),
  X(85,101), X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109),
  X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109),
  X(125,141), X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(149,157), X(165,173), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(157,161), X(165,169), X(173,177), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131),
  X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163),
  X(19,83), X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51),
  X(83,115), X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19),
  X(35,51), X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75),
  X(43,107), X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91),
  X(91,155), X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39),
  X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87),
  X(119,151), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135),
  X(151,167), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(111,175), X(47,111), X(15,47), X(79,111),
  X(143,175), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(159,175),
  X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(151,159), X(167,175), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(163,167), X(171,175), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153),
  X(155,157), X(159,161), X(163,165), X(167,169), X(171,173), X(175,177), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98),
  X(2,34), X(66,98), X(130,162), X(18,82), X(82,146), X(18,82), X(50,114),
  X(50,82), X(114,146), X(18,50), X(82,114), X(18,34), X(50,66), X(82,98),
  X(114,130), X(146,162), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146),
  X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42),
  X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(58,90),
  X(122,154), X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138),
  X(154,170), X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(2,10),
  X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122),
  X(130,138), X(146,154), X(162,170), X(6,70), X(70,134), X(6,70), X(38,102),
  X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150),
  X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118), X(22,38),
  X(54,70), X(86,102), X(118,134), X(150,166), X(6,22), X(38,54), X(70,86),
  X(102,118), X(134,150), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174),
  X(46,110), X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94),
  X(62,126), X(62,94), X(126,158), X(30,62), X(94,126), X(30,46), X(62,78),
  X(94,110), X(126,142), X(158,174), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(150,158), X(166,174), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(170,174), X(4,68), X(68,132),
  X(4,68), X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164),
  X(20,84), X(84,148), X(20,84), X(52,116), X(52,84), X(116,148), X(20,52),
  X(84,116), X(20,36), X(52,68), X(84,100), X(116,132), X(148,164), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(12,76), X(76,140), X(12,76),
  X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92),
  X(92,156), X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124),
  X(28,44), X(60,76), X(92,108), X(124,140), X(156,172), X(12,28), X(44,60),
  X(76,92), X(108,124), X(140,156), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172),
  X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40),
  X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(56,88),
  X(120,152), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104), X(120,136),
  X(152,168), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(16,80),
  X(80,144), X(16,80), X(48,112), X(112,176), X(48,112), X(16,48), X(80,112),
  X(144,176), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96), X(128,160),
  X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144), X(160,176),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16), X(24,32),
  X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144),
  X(152,160), X(168,176), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(164,168), X(172,176), X(2,4), X(6,8), X(10,12),
  X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44),
  X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76),
  X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104),
  X(106,108), X(110,112), X(114,116), X(118,120), X(122,124), X(126,128),
  X(130,132), X(134,136), X(138,140), X(142,144), X(146,148), X(150,152),
  X(154,156), X(158,160), X(162,164), X(166,168), X(170,172), X(174,176), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171),
  X(172,173), X(174,175), X(176,177), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164),
  X(165,166), X(167,168), X(169,170), X(171,172), X(173,174), X(175,176)
};
M(178) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69),
  X(85,101), X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109),
  X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109),
  X(125,141), X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(149,157), X(165,173), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(157,161), X(165,169), X(173,177), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131),
  X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163),
  X(19,83), X(83,147), X(19,83), X(51,115), X(51,83), X(115,147), X(19,51),
  X(83,115), X(19,35), X(51,67), X(83,99), X(115,131), X(147,163), X(3,19),
  X(35,51), X(67,83), X(99,115), X(131,147), X(11,75), X(75,139), X(11,75),
  X(43,107), X(107,171), X(43,107), X(11,43), X(75,107), X(139,171), X(27,91),
  X(91,155), X(27,91), X(59,123), X(59,91), X(123,155), X(27,59), X(91,123),
  X(27,43), X(59,75), X(91,107), X(123,139), X(155,171), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39),
  X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(55,87),
  X(119,151), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103), X(119,135),
  X(151,167), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151), X(15,79),
  X(79,143), X(15,79), X(47,111), X(111,175), X(47,111), X(15,47), X(79,111),
  X(143,175), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159),
  X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(159,175),
  X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(151,159), X(167,175), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(163,167), X(171,175), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153),
  X(155,157), X(159,161), X(163,165), X(167,169), X(171,173), X(175,177), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98),
  X(2,34), X(66,98), X(130,162), X(18,82), X(82,146), X(18,82), X(50,114),
  X(114,178), X(50,114), X(18,50), X(82,114), X(146,178), X(2,18), X(34,50),
  X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138), X(10,74),
  X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170), X(26,90),
  X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162), X(170,178),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(162,170), X(6,70), X(70,134), X(6,70),
  X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86),
  X(86,150), X(22,86), X(54,118), X(54,86), X(118,150), X(22,54), X(86,118),
  X(22,38), X(54,70), X(86,102), X(118,134), X(150,166), X(6,22), X(38,54),
  X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78), X(46,110),
  X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94), X(94,158),
  X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126), X(30,46),
  X(62,78), X(94,110), X(126,142), X(158,174), X(14,30), X(46,62), X(78,94),
  X(110,126), X(142,158), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174), X(6,10),
  X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74),
  X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130),
  X(134,138), X(142,146), X(150,154), X(158,162), X(166,170), X(174,178), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100), X(4,36),
  X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116), X(52,84),
  X(116,148), X(20,52), X(84,116), X(20,36), X(52,68), X(84,100), X(116,132),
  X(148,164), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(12,76),
  X(76,140), X(12,76), X(44,108), X(108,172), X(44,108), X(12,44), X(76,108),
  X(140,172), X(28,92), X(92,156), X(28,92), X(60,124), X(60,92), X(124,156),
  X(28,60), X(92,124), X(28,44), X(60,76), X(92,108), X(124,140), X(156,172),
  X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(4,12), X(20,28),
  X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140),
  X(148,156), X(164,172), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168),
  X(40,104), X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88),
  X(56,120), X(56,88), X(120,152), X(24,56), X(88,120), X(24,40), X(56,72),
  X(88,104), X(120,136), X(152,168), X(8,24), X(40,56), X(72,88), X(104,120),
  X(136,152), X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112),
  X(16,48), X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128),
  X(64,96), X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112),
  X(128,144), X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(136,144), X(152,160), X(168,176), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(124,126),
  X(128,130), X(132,134), X(136,138), X(140,142), X(144,146), X(148,150),
  X(152,154), X(156,158), X(160,162), X(164,166), X(168,170), X(172,174),
  X(176,178), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164),
  X(165,166), X(167,168), X(169,170), X(171,172), X(173,174), X(175,176),
  X(177,178)
};
M(179) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69),
  X(85,101), X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109),
  X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109),
  X(125,141), X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(149,157), X(165,173), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(157,161), X(165,169), X(173,177), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131),
  X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163),
  X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115), X(19,51),
  X(83,115), X(147,179), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147),
  X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107),
  X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(27,43), X(59,75), X(91,107),
  X(123,139), X(155,171), X(11,27), X(43,59), X(75,91), X(107,123), X(139,155),
  X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(107,115),
  X(123,131), X(139,147), X(155,163), X(171,179), X(3,11), X(19,27), X(35,43),
  X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155),
  X(163,171), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103),
  X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151),
  X(15,79), X(79,143), X(15,79), X(47,111), X(111,175), X(47,111), X(15,47),
  X(79,111), X(143,175), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143),
  X(159,175), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(151,159), X(167,175), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(103,107), X(111,115), X(119,123), X(127,131), X(135,139), X(143,147),
  X(151,155), X(159,163), X(167,171), X(175,179), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(2,66), X(66,130), X(2,66), X(34,98), X(98,162),
  X(34,98), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146), X(18,82),
  X(50,114), X(114,178), X(50,114), X(18,50), X(82,114), X(146,178), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138),
  X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170),
  X(26,90), X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50),
  X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162),
  X(170,178), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150), X(22,54),
  X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(150,166), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94),
  X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126),
  X(30,46), X(62,78), X(94,110), X(126,142), X(158,174), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(150,154), X(158,162), X(166,170),
  X(174,178), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(154,158),
  X(162,166), X(170,174), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164),
  X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84),
  X(52,116), X(52,84), X(116,148), X(20,52), X(84,116), X(20,36), X(52,68),
  X(84,100), X(116,132), X(148,164), X(4,20), X(36,52), X(68,84), X(100,116),
  X(132,148), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108),
  X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(156,172), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(132,140), X(148,156), X(164,172), X(8,72), X(72,136), X(8,72),
  X(40,104), X(104,168), X(40,104), X(8,40), X(72,104), X(136,168), X(24,88),
  X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56), X(88,120),
  X(24,40), X(56,72), X(88,104), X(120,136), X(152,168), X(8,24), X(40,56),
  X(72,88), X(104,120), X(136,152), X(16,80), X(80,144), X(16,80), X(48,112),
  X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96), X(96,160),
  X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128), X(32,48),
  X(64,80), X(96,112), X(128,144), X(160,176), X(16,32), X(48,64), X(80,96),
  X(112,128), X(144,160), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(120,128), X(136,144), X(152,160), X(168,176), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(132,136), X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(152,154), X(156,158), X(160,162), X(164,166), X(168,170),
  X(172,174), X(176,178), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139), X(140,141),
  X(142,143), X(144,145), X(146,147), X(148,149), X(150,151), X(152,153),
  X(154,155), X(156,157), X(158,159), X(160,161), X(162,163), X(164,165),
  X(166,167), X(168,169), X(170,171), X(172,173), X(174,175), X(176,177),
  X(178,179), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172), X(173,174), X(175,176), X(177,178)
};
M(180) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(53,85), X(117,149), X(21,53), X(85,117), X(21,37), X(53,69),
  X(85,101), X(117,133), X(149,165), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173), X(45,109),
  X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93), X(61,125),
  X(61,93), X(125,157), X(29,61), X(93,125), X(29,45), X(61,77), X(93,109),
  X(125,141), X(157,173), X(13,29), X(45,61), X(77,93), X(109,125), X(141,157),
  X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93), X(101,109),
  X(117,125), X(133,141), X(149,157), X(165,173), X(5,9), X(13,17), X(21,25),
  X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89),
  X(93,97), X(101,105), X(109,113), X(117,121), X(125,129), X(133,137),
  X(141,145), X(149,153), X(157,161), X(165,169), X(173,177), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(3,67), X(67,131),
  X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163),
  X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115), X(19,51),
  X(83,115), X(147,179), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147),
  X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107),
  X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123),
  X(59,91), X(123,155), X(27,59), X(91,123), X(27,43), X(59,75), X(91,107),
  X(123,139), X(155,171), X(11,27), X(43,59), X(75,91), X(107,123), X(139,155),
  X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99), X(107,115),
  X(123,131), X(139,147), X(155,163), X(171,179), X(3,11), X(19,27), X(35,43),
  X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155),
  X(163,171), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71), X(87,103),
  X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119), X(135,151),
  X(15,79), X(79,143), X(15,79), X(47,111), X(111,175), X(47,111), X(15,47),
  X(79,111), X(143,175), X(31,95), X(95,159), X(31,95), X(63,127), X(63,95),
  X(127,159), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111), X(127,143),
  X(159,175), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(7,15),
  X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127),
  X(135,143), X(151,159), X(167,175), X(7,11), X(15,19), X(23,27), X(31,35),
  X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91), X(95,99),
  X(103,107), X(111,115), X(119,123), X(127,131), X(135,139), X(143,147),
  X(151,155), X(159,163), X(167,171), X(175,179), X(3,7), X(11,15), X(19,23),
  X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87),
  X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(2,66), X(66,130), X(2,66), X(34,98), X(98,162),
  X(34,98), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146), X(18,82),
  X(50,114), X(114,178), X(50,114), X(18,50), X(82,114), X(146,178), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138),
  X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170),
  X(26,90), X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58),
  X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50),
  X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162),
  X(170,178), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(54,86), X(118,150), X(22,54),
  X(86,118), X(22,38), X(54,70), X(86,102), X(118,134), X(150,166), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(14,78), X(78,142), X(14,78),
  X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94),
  X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126),
  X(30,46), X(62,78), X(94,110), X(126,142), X(158,174), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174),
  X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66),
  X(70,74), X(78,82), X(86,90), X(94,98), X(102,106), X(110,114), X(118,122),
  X(126,130), X(134,138), X(142,146), X(150,154), X(158,162), X(166,170),
  X(174,178), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(154,158),
  X(162,166), X(170,174), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164),
  X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84),
  X(52,116), X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140),
  X(12,76), X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172),
  X(28,92), X(92,156), X(28,92), X(60,124), X(60,92), X(124,156), X(28,60),
  X(92,124), X(28,44), X(60,76), X(92,108), X(124,140), X(156,172), X(12,28),
  X(44,60), X(76,92), X(108,124), X(140,156), X(12,20), X(28,36), X(44,52),
  X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(156,164),
  X(172,180), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(8,72), X(72,136),
  X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104), X(136,168),
  X(24,88), X(88,152), X(24,88), X(56,120), X(56,88), X(120,152), X(24,56),
  X(88,120), X(24,40), X(56,72), X(88,104), X(120,136), X(152,168), X(8,24),
  X(40,56), X(72,88), X(104,120), X(136,152), X(16,80), X(80,144), X(16,80),
  X(48,112), X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(32,48), X(64,80), X(96,112), X(128,144), X(160,176), X(16,32), X(48,64),
  X(80,96), X(112,128), X(144,160), X(8,16), X(24,32), X(40,48), X(56,64),
  X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160), X(168,176),
  X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68),
  X(72,76), X(80,84), X(88,92), X(96,100), X(104,108), X(112,116), X(120,124),
  X(128,132), X(136,140), X(144,148), X(152,156), X(160,164), X(168,172),
  X(176,180), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160),
  X(164,168), X(172,176), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168), X(169,170), X(171,172), X(173,174),
  X(175,176), X(177,178), X(179,180)
};
M(181) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77), X(77,141),
  X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109), X(141,173),
  X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157), X(29,61),
  X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53),
  X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165),
  X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(177,181),
  X(3,67), X(67,131), X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99),
  X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115),
  X(19,51), X(83,115), X(147,179), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171),
  X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(155,163), X(171,179), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(163,171), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167),
  X(39,103), X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87),
  X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71),
  X(87,103), X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(111,175), X(47,111),
  X(15,47), X(79,111), X(143,175), X(31,95), X(95,159), X(31,95), X(63,127),
  X(63,95), X(127,159), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111),
  X(127,143), X(159,175), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(147,149),
  X(151,153), X(155,157), X(159,161), X(163,165), X(167,169), X(171,173),
  X(175,177), X(179,181), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(161,163),
  X(165,167), X(169,171), X(173,175), X(177,179), X(2,66), X(66,130), X(2,66),
  X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114),
  X(146,178), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178),
  X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42),
  X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(58,90),
  X(122,154), X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138),
  X(154,170), X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(10,18),
  X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130),
  X(138,146), X(154,162), X(170,178), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170),
  X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38),
  X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(54,86),
  X(118,150), X(22,54), X(86,118), X(22,38), X(54,70), X(86,102), X(118,134),
  X(150,166), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(14,78),
  X(78,142), X(14,78), X(46,110), X(110,174), X(46,110), X(14,46), X(78,110),
  X(142,174), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158),
  X(30,62), X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(158,174),
  X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(150,158), X(166,174), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(158,162), X(166,170), X(174,178), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(170,174), X(4,68), X(68,132),
  X(4,68), X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164),
  X(20,84), X(84,148), X(20,84), X(52,116), X(116,180), X(52,116), X(20,52),
  X(84,116), X(148,180), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(164,180), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108),
  X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(156,172), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(140,148), X(156,164), X(172,180), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156),
  X(164,172), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(56,88), X(120,152), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(152,168), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112), X(16,48),
  X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96),
  X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(168,176), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(168,172), X(176,180), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(122,124),
  X(126,128), X(130,132), X(134,136), X(138,140), X(142,144), X(146,148),
  X(150,152), X(154,156), X(158,160), X(162,164), X(166,168), X(170,172),
  X(174,176), X(178,180), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137), X(138,139), X(140,141), X(142,143),
  X(144,145), X(146,147), X(148,149), X(150,151), X(152,153), X(154,155),
  X(156,157), X(158,159), X(160,161), X(162,163), X(164,165), X(166,167),
  X(168,169), X(170,171), X(172,173), X(174,175), X(176,177), X(178,179),
  X(180,181), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172), X(173,174), X(175,176), X(177,178), X(179,180)
};
M(182) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77), X(77,141),
  X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109), X(141,173),
  X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157), X(29,61),
  X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53),
  X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165),
  X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(177,181),
  X(3,67), X(67,131), X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99),
  X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115),
  X(19,51), X(83,115), X(147,179), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171),
  X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(155,163), X(171,179), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(163,171), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167),
  X(39,103), X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87),
  X(55,119), X(55,87), X(119,151), X(23,55), X(87,119), X(23,39), X(55,71),
  X(87,103), X(119,135), X(151,167), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(15,79), X(79,143), X(15,79), X(47,111), X(111,175), X(47,111),
  X(15,47), X(79,111), X(143,175), X(31,95), X(95,159), X(31,95), X(63,127),
  X(63,95), X(127,159), X(31,63), X(95,127), X(31,47), X(63,79), X(95,111),
  X(127,143), X(159,175), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(7,11), X(15,19), X(23,27),
  X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83), X(87,91),
  X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(147,149),
  X(151,153), X(155,157), X(159,161), X(163,165), X(167,169), X(171,173),
  X(175,177), X(179,181), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23),
  X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55),
  X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87),
  X(89,91), X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115),
  X(117,119), X(121,123), X(125,127), X(129,131), X(133,135), X(137,139),
  X(141,143), X(145,147), X(149,151), X(153,155), X(157,159), X(161,163),
  X(165,167), X(169,171), X(173,175), X(177,179), X(2,66), X(66,130), X(2,66),
  X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114),
  X(146,178), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178),
  X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42),
  X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(58,90),
  X(122,154), X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138),
  X(154,170), X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(10,18),
  X(26,34), X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130),
  X(138,146), X(154,162), X(170,178), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170),
  X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38),
  X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(118,182),
  X(54,118), X(22,54), X(86,118), X(150,182), X(6,22), X(38,54), X(70,86),
  X(102,118), X(134,150), X(166,182), X(14,78), X(78,142), X(14,78), X(46,110),
  X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94), X(94,158),
  X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126), X(30,46),
  X(62,78), X(94,110), X(126,142), X(158,174), X(14,30), X(46,62), X(78,94),
  X(110,126), X(142,158), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(126,134), X(142,150), X(158,166), X(174,182), X(6,14),
  X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126),
  X(134,142), X(150,158), X(166,174), X(2,6), X(10,14), X(18,22), X(26,30),
  X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(162,166), X(170,174), X(178,182), X(4,68), X(68,132),
  X(4,68), X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164),
  X(20,84), X(84,148), X(20,84), X(52,116), X(116,180), X(52,116), X(20,52),
  X(84,116), X(148,180), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(164,180), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108),
  X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(156,172), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(140,148), X(156,164), X(172,180), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156),
  X(164,172), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(56,88), X(120,152), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(152,168), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112), X(16,48),
  X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96),
  X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(168,176), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(168,172), X(176,180), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(124,126),
  X(128,130), X(132,134), X(136,138), X(140,142), X(144,146), X(148,150),
  X(152,154), X(156,158), X(160,162), X(164,166), X(168,170), X(172,174),
  X(176,178), X(180,182), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168), X(169,170), X(171,172), X(173,174),
  X(175,176), X(177,178), X(179,180), X(181,182)
};
M(183) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77), X(77,141),
  X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109), X(141,173),
  X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157), X(29,61),
  X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53),
  X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165),
  X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(177,181),
  X(3,67), X(67,131), X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99),
  X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115),
  X(19,51), X(83,115), X(147,179), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171),
  X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(155,163), X(171,179), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(163,171), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167),
  X(39,103), X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87),
  X(55,119), X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23),
  X(39,55), X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143),
  X(15,79), X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31),
  X(47,63), X(79,95), X(111,127), X(143,159), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(159,167),
  X(175,183), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(167,175), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(179,183), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(2,66), X(66,130), X(2,66), X(34,98),
  X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114), X(146,178),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74),
  X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106),
  X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(58,90), X(122,154),
  X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(154,170),
  X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146),
  X(154,162), X(170,178), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(6,70),
  X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102),
  X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(118,182), X(54,118),
  X(22,54), X(86,118), X(150,182), X(6,22), X(38,54), X(70,86), X(102,118),
  X(134,150), X(166,182), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174),
  X(46,110), X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94),
  X(62,126), X(62,94), X(126,158), X(30,62), X(94,126), X(30,46), X(62,78),
  X(94,110), X(126,142), X(158,174), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102),
  X(110,118), X(126,134), X(142,150), X(158,166), X(174,182), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(150,158), X(166,174), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(162,166), X(170,174), X(178,182), X(4,68), X(68,132),
  X(4,68), X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164),
  X(20,84), X(84,148), X(20,84), X(52,116), X(116,180), X(52,116), X(20,52),
  X(84,116), X(148,180), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(164,180), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108),
  X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(156,172), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(140,148), X(156,164), X(172,180), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156),
  X(164,172), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(56,88), X(120,152), X(24,56), X(88,120), X(24,40), X(56,72), X(88,104),
  X(120,136), X(152,168), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112), X(16,48),
  X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96),
  X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144),
  X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(168,176), X(8,12), X(16,20), X(24,28), X(32,36),
  X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84), X(88,92),
  X(96,100), X(104,108), X(112,116), X(120,124), X(128,132), X(136,140),
  X(144,148), X(152,156), X(160,164), X(168,172), X(176,180), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(4,6), X(8,10),
  X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42),
  X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74),
  X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98), X(100,102),
  X(104,106), X(108,110), X(112,114), X(116,118), X(120,122), X(124,126),
  X(128,130), X(132,134), X(136,138), X(140,142), X(144,146), X(148,150),
  X(152,154), X(156,158), X(160,162), X(164,166), X(168,170), X(172,174),
  X(176,178), X(180,182), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(122,123), X(124,125), X(126,127),
  X(128,129), X(130,131), X(132,133), X(134,135), X(136,137), X(138,139),
  X(140,141), X(142,143), X(144,145), X(146,147), X(148,149), X(150,151),
  X(152,153), X(154,155), X(156,157), X(158,159), X(160,161), X(162,163),
  X(164,165), X(166,167), X(168,169), X(170,171), X(172,173), X(174,175),
  X(176,177), X(178,179), X(180,181), X(182,183), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168), X(169,170), X(171,172), X(173,174),
  X(175,176), X(177,178), X(179,180), X(181,182)
};
M(184) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(57,89), X(121,153), X(25,57), X(89,121), X(25,41), X(57,73),
  X(89,105), X(121,137), X(153,169), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81), X(89,97),
  X(105,113), X(121,129), X(137,145), X(153,161), X(169,177), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(5,69), X(69,133), X(5,69), X(37,101), X(101,165),
  X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149), X(21,85),
  X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181), X(5,21),
  X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77), X(77,141),
  X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109), X(141,173),
  X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157), X(29,61),
  X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37), X(45,53),
  X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149), X(157,165),
  X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(1,5), X(9,13),
  X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69), X(73,77),
  X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125), X(129,133),
  X(137,141), X(145,149), X(153,157), X(161,165), X(169,173), X(177,181),
  X(3,67), X(67,131), X(3,67), X(35,99), X(99,163), X(35,99), X(3,35), X(67,99),
  X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115),
  X(19,51), X(83,115), X(147,179), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171),
  X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91),
  X(59,123), X(59,91), X(123,155), X(27,59), X(91,123), X(27,43), X(59,75),
  X(91,107), X(123,139), X(155,171), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(11,19), X(27,35), X(43,51), X(59,67), X(75,83), X(91,99),
  X(107,115), X(123,131), X(139,147), X(155,163), X(171,179), X(3,11), X(19,27),
  X(35,43), X(51,59), X(67,75), X(83,91), X(99,107), X(115,123), X(131,139),
  X(147,155), X(163,171), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167),
  X(39,103), X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87),
  X(55,119), X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23),
  X(39,55), X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143),
  X(15,79), X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175),
  X(31,95), X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63),
  X(95,127), X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31),
  X(47,63), X(79,95), X(111,127), X(143,159), X(15,23), X(31,39), X(47,55),
  X(63,71), X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(159,167),
  X(175,183), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(167,175), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(179,183), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(2,66), X(66,130), X(2,66), X(34,98),
  X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114), X(146,178),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74),
  X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106),
  X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(58,90), X(122,154),
  X(26,58), X(90,122), X(26,42), X(58,74), X(90,106), X(122,138), X(154,170),
  X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(10,18), X(26,34),
  X(42,50), X(58,66), X(74,82), X(90,98), X(106,114), X(122,130), X(138,146),
  X(154,162), X(170,178), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74),
  X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(6,70),
  X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102),
  X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(118,182), X(54,118),
  X(22,54), X(86,118), X(150,182), X(6,22), X(38,54), X(70,86), X(102,118),
  X(134,150), X(166,182), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174),
  X(46,110), X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94),
  X(62,126), X(62,94), X(126,158), X(30,62), X(94,126), X(30,46), X(62,78),
  X(94,110), X(126,142), X(158,174), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102),
  X(110,118), X(126,134), X(142,150), X(158,166), X(174,182), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(150,158), X(166,174), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38),
  X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86), X(90,94),
  X(98,102), X(106,110), X(114,118), X(122,126), X(130,134), X(138,142),
  X(146,150), X(154,158), X(162,166), X(170,174), X(178,182), X(4,68), X(68,132),
  X(4,68), X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164),
  X(20,84), X(84,148), X(20,84), X(52,116), X(116,180), X(52,116), X(20,52),
  X(84,116), X(148,180), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(164,180), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108),
  X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124),
  X(60,92), X(124,156), X(28,60), X(92,124), X(28,44), X(60,76), X(92,108),
  X(124,140), X(156,172), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(12,20), X(28,36), X(44,52), X(60,68), X(76,84), X(92,100), X(108,116),
  X(124,132), X(140,148), X(156,164), X(172,180), X(4,12), X(20,28), X(36,44),
  X(52,60), X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156),
  X(164,172), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(120,184), X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56),
  X(72,88), X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80),
  X(48,112), X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(32,48), X(64,80), X(96,112), X(128,144), X(160,176), X(16,32), X(48,64),
  X(80,96), X(112,128), X(144,160), X(16,24), X(32,40), X(48,56), X(64,72),
  X(80,88), X(96,104), X(112,120), X(128,136), X(144,152), X(160,168),
  X(176,184), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(168,176), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(166,168),
  X(170,172), X(174,176), X(178,180), X(182,184), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168), X(169,170), X(171,172), X(173,174),
  X(175,176), X(177,178), X(179,180), X(181,182), X(183,184)
};
M(185) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173),
  X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149),
  X(157,165), X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(173,177),
  X(181,185), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115), X(147,179),
  X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179), X(11,75),
  X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43), X(75,107),
  X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(59,91), X(123,155),
  X(27,59), X(91,123), X(27,43), X(59,75), X(91,107), X(123,139), X(155,171),
  X(11,27), X(43,59), X(75,91), X(107,123), X(139,155), X(11,19), X(27,35),
  X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(139,147),
  X(155,163), X(171,179), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(119,183), X(55,119),
  X(23,55), X(87,119), X(151,183), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(167,183), X(15,79), X(79,143), X(15,79), X(47,111), X(111,175),
  X(47,111), X(15,47), X(79,111), X(143,175), X(31,95), X(95,159), X(31,95),
  X(63,127), X(63,95), X(127,159), X(31,63), X(95,127), X(31,47), X(63,79),
  X(95,111), X(127,143), X(159,175), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103),
  X(111,119), X(127,135), X(143,151), X(159,167), X(175,183), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(151,159), X(167,175), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(163,167), X(171,175), X(179,183), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(147,149),
  X(151,153), X(155,157), X(159,161), X(163,165), X(167,169), X(171,173),
  X(175,177), X(179,181), X(183,185), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103), X(105,107),
  X(109,111), X(113,115), X(117,119), X(121,123), X(125,127), X(129,131),
  X(133,135), X(137,139), X(141,143), X(145,147), X(149,151), X(153,155),
  X(157,159), X(161,163), X(165,167), X(169,171), X(173,175), X(177,179),
  X(181,183), X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98),
  X(2,34), X(66,98), X(130,162), X(18,82), X(82,146), X(18,82), X(50,114),
  X(114,178), X(50,114), X(18,50), X(82,114), X(146,178), X(2,18), X(34,50),
  X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138), X(10,74),
  X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170), X(26,90),
  X(90,154), X(26,90), X(58,122), X(58,90), X(122,154), X(26,58), X(90,122),
  X(26,42), X(58,74), X(90,106), X(122,138), X(154,170), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(10,18), X(26,34), X(42,50), X(58,66),
  X(74,82), X(90,98), X(106,114), X(122,130), X(138,146), X(154,162), X(170,178),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(162,170), X(6,70), X(70,134), X(6,70),
  X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86),
  X(86,150), X(22,86), X(54,118), X(118,182), X(54,118), X(22,54), X(86,118),
  X(150,182), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(166,182),
  X(14,78), X(78,142), X(14,78), X(46,110), X(110,174), X(46,110), X(14,46),
  X(78,110), X(142,174), X(30,94), X(94,158), X(30,94), X(62,126), X(62,94),
  X(126,158), X(30,62), X(94,126), X(30,46), X(62,78), X(94,110), X(126,142),
  X(158,174), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(14,22),
  X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118), X(126,134),
  X(142,150), X(158,166), X(174,182), X(6,14), X(22,30), X(38,46), X(54,62),
  X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174),
  X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62),
  X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118),
  X(122,126), X(130,134), X(138,142), X(146,150), X(154,158), X(162,166),
  X(170,174), X(178,182), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164),
  X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84),
  X(52,116), X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140),
  X(12,76), X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172),
  X(28,92), X(92,156), X(28,92), X(60,124), X(60,92), X(124,156), X(28,60),
  X(92,124), X(28,44), X(60,76), X(92,108), X(124,140), X(156,172), X(12,28),
  X(44,60), X(76,92), X(108,124), X(140,156), X(12,20), X(28,36), X(44,52),
  X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(156,164),
  X(172,180), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(8,72), X(72,136),
  X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104), X(136,168),
  X(24,88), X(88,152), X(24,88), X(56,120), X(120,184), X(56,120), X(24,56),
  X(88,120), X(152,184), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(168,184), X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112),
  X(16,48), X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128),
  X(64,96), X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112),
  X(128,144), X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(160,168), X(176,184), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160),
  X(168,176), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160),
  X(164,168), X(172,176), X(180,184), X(2,4), X(6,8), X(10,12), X(14,16),
  X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48),
  X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80),
  X(82,84), X(86,88), X(90,92), X(94,96), X(98,100), X(102,104), X(106,108),
  X(110,112), X(114,116), X(118,120), X(122,124), X(126,128), X(130,132),
  X(134,136), X(138,140), X(142,144), X(146,148), X(150,152), X(154,156),
  X(158,160), X(162,164), X(166,168), X(170,172), X(174,176), X(178,180),
  X(182,184), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(138,139), X(140,141), X(142,143), X(144,145),
  X(146,147), X(148,149), X(150,151), X(152,153), X(154,155), X(156,157),
  X(158,159), X(160,161), X(162,163), X(164,165), X(166,167), X(168,169),
  X(170,171), X(172,173), X(174,175), X(176,177), X(178,179), X(180,181),
  X(182,183), X(184,185), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162), X(163,164), X(165,166),
  X(167,168), X(169,170), X(171,172), X(173,174), X(175,176), X(177,178),
  X(179,180), X(181,182), X(183,184)
};
M(186) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173),
  X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149),
  X(157,165), X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(173,177),
  X(181,185), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115), X(147,179),
  X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179), X(11,75),
  X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43), X(75,107),
  X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(59,91), X(123,155),
  X(27,59), X(91,123), X(27,43), X(59,75), X(91,107), X(123,139), X(155,171),
  X(11,27), X(43,59), X(75,91), X(107,123), X(139,155), X(11,19), X(27,35),
  X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(139,147),
  X(155,163), X(171,179), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(119,183), X(55,119),
  X(23,55), X(87,119), X(151,183), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(167,183), X(15,79), X(79,143), X(15,79), X(47,111), X(111,175),
  X(47,111), X(15,47), X(79,111), X(143,175), X(31,95), X(95,159), X(31,95),
  X(63,127), X(63,95), X(127,159), X(31,63), X(95,127), X(31,47), X(63,79),
  X(95,111), X(127,143), X(159,175), X(15,31), X(47,63), X(79,95), X(111,127),
  X(143,159), X(15,23), X(31,39), X(47,55), X(63,71), X(79,87), X(95,103),
  X(111,119), X(127,135), X(143,151), X(159,167), X(175,183), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(151,159), X(167,175), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39),
  X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(163,167), X(171,175), X(179,183), X(3,5), X(7,9),
  X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41),
  X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73),
  X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101),
  X(103,105), X(107,109), X(111,113), X(115,117), X(119,121), X(123,125),
  X(127,129), X(131,133), X(135,137), X(139,141), X(143,145), X(147,149),
  X(151,153), X(155,157), X(159,161), X(163,165), X(167,169), X(171,173),
  X(175,177), X(179,181), X(183,185), X(1,3), X(5,7), X(9,11), X(13,15),
  X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43), X(45,47),
  X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75), X(77,79),
  X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103), X(105,107),
  X(109,111), X(113,115), X(117,119), X(121,123), X(125,127), X(129,131),
  X(133,135), X(137,139), X(141,143), X(145,147), X(149,151), X(153,155),
  X(157,159), X(161,163), X(165,167), X(169,171), X(173,175), X(177,179),
  X(181,183), X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98),
  X(2,34), X(66,98), X(130,162), X(18,82), X(82,146), X(18,82), X(50,114),
  X(114,178), X(50,114), X(18,50), X(82,114), X(146,178), X(2,18), X(34,50),
  X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138), X(10,74),
  X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170), X(26,90),
  X(90,154), X(26,90), X(58,122), X(122,186), X(58,122), X(26,58), X(90,122),
  X(154,186), X(10,26), X(42,58), X(74,90), X(106,122), X(138,154), X(170,186),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(162,170), X(178,186), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(118,182), X(54,118), X(22,54),
  X(86,118), X(150,182), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(166,182), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174), X(46,110),
  X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94), X(62,126),
  X(62,94), X(126,158), X(30,62), X(94,126), X(30,46), X(62,78), X(94,110),
  X(126,142), X(158,174), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158),
  X(14,22), X(30,38), X(46,54), X(62,70), X(78,86), X(94,102), X(110,118),
  X(126,134), X(142,150), X(158,166), X(174,182), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158),
  X(166,174), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42), X(46,50),
  X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98), X(102,106),
  X(110,114), X(118,122), X(126,130), X(134,138), X(142,146), X(150,154),
  X(158,162), X(166,170), X(174,178), X(182,186), X(2,6), X(10,14), X(18,22),
  X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78), X(82,86),
  X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(170,174), X(178,182),
  X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100), X(4,36),
  X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116), X(116,180),
  X(52,116), X(20,52), X(84,116), X(148,180), X(4,20), X(36,52), X(68,84),
  X(100,116), X(132,148), X(164,180), X(12,76), X(76,140), X(12,76), X(44,108),
  X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92), X(92,156),
  X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124), X(28,44),
  X(60,76), X(92,108), X(124,140), X(156,172), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(12,20), X(28,36), X(44,52), X(60,68), X(76,84),
  X(92,100), X(108,116), X(124,132), X(140,148), X(156,164), X(172,180), X(4,12),
  X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108), X(116,124),
  X(132,140), X(148,156), X(164,172), X(8,72), X(72,136), X(8,72), X(40,104),
  X(104,168), X(40,104), X(8,40), X(72,104), X(136,168), X(24,88), X(88,152),
  X(24,88), X(56,120), X(120,184), X(56,120), X(24,56), X(88,120), X(152,184),
  X(8,24), X(40,56), X(72,88), X(104,120), X(136,152), X(168,184), X(16,80),
  X(80,144), X(16,80), X(48,112), X(112,176), X(48,112), X(16,48), X(80,112),
  X(144,176), X(32,96), X(96,160), X(32,96), X(64,128), X(64,96), X(128,160),
  X(32,64), X(96,128), X(32,48), X(64,80), X(96,112), X(128,144), X(160,176),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(16,24), X(32,40),
  X(48,56), X(64,72), X(80,88), X(96,104), X(112,120), X(128,136), X(144,152),
  X(160,168), X(176,184), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80),
  X(88,96), X(104,112), X(120,128), X(136,144), X(152,160), X(168,176), X(4,8),
  X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72),
  X(76,80), X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128),
  X(132,136), X(140,144), X(148,152), X(156,160), X(164,168), X(172,176),
  X(180,184), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62),
  X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94),
  X(96,98), X(100,102), X(104,106), X(108,110), X(112,114), X(116,118),
  X(120,122), X(124,126), X(128,130), X(132,134), X(136,138), X(140,142),
  X(144,146), X(148,150), X(152,154), X(156,158), X(160,162), X(164,166),
  X(168,170), X(172,174), X(176,178), X(180,182), X(184,186), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(122,124),
  X(126,128), X(130,132), X(134,136), X(138,140), X(142,144), X(146,148),
  X(150,152), X(154,156), X(158,160), X(162,164), X(166,168), X(170,172),
  X(174,176), X(178,180), X(182,184), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164),
  X(165,166), X(167,168), X(169,170), X(171,172), X(173,174), X(175,176),
  X(177,178), X(179,180), X(181,182), X(183,184), X(185,186)
};
M(187) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173),
  X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149),
  X(157,165), X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(173,177),
  X(181,185), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115), X(147,179),
  X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179), X(11,75),
  X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43), X(75,107),
  X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(123,187), X(59,123),
  X(27,59), X(91,123), X(155,187), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(171,187), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31), X(47,63),
  X(79,95), X(111,127), X(143,159), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(159,167),
  X(175,183), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(167,175), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(171,175),
  X(179,183), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(129,131), X(133,135), X(137,139), X(141,143),
  X(145,147), X(149,151), X(153,155), X(157,159), X(161,163), X(165,167),
  X(169,171), X(173,175), X(177,179), X(181,183), X(185,187), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50),
  X(82,114), X(146,178), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146),
  X(162,178), X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106),
  X(10,42), X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122),
  X(122,186), X(58,122), X(26,58), X(90,122), X(154,186), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(170,186), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(162,170), X(178,186), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166),
  X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86),
  X(54,118), X(118,182), X(54,118), X(22,54), X(86,118), X(150,182), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(166,182), X(14,78), X(78,142),
  X(14,78), X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174),
  X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62),
  X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(158,174), X(14,30),
  X(46,62), X(78,94), X(110,126), X(142,158), X(14,22), X(30,38), X(46,54),
  X(62,70), X(78,86), X(94,102), X(110,118), X(126,134), X(142,150), X(158,166),
  X(174,182), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(150,158), X(166,174), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(166,170), X(174,178), X(182,186), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140), X(12,76),
  X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92),
  X(92,156), X(28,92), X(60,124), X(60,92), X(124,156), X(28,60), X(92,124),
  X(28,44), X(60,76), X(92,108), X(124,140), X(156,172), X(12,28), X(44,60),
  X(76,92), X(108,124), X(140,156), X(12,20), X(28,36), X(44,52), X(60,68),
  X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(156,164),
  X(172,180), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(8,72), X(72,136),
  X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104), X(136,168),
  X(24,88), X(88,152), X(24,88), X(56,120), X(120,184), X(56,120), X(24,56),
  X(88,120), X(152,184), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(168,184), X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112),
  X(16,48), X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128),
  X(64,96), X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112),
  X(128,144), X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(160,168), X(176,184), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160),
  X(168,176), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160),
  X(164,168), X(172,176), X(180,184), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110),
  X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(132,134),
  X(136,138), X(140,142), X(144,146), X(148,150), X(152,154), X(156,158),
  X(160,162), X(164,166), X(168,170), X(172,174), X(176,178), X(180,182),
  X(184,186), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(182,184), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171),
  X(172,173), X(174,175), X(176,177), X(178,179), X(180,181), X(182,183),
  X(184,185), X(186,187), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162), X(163,164), X(165,166),
  X(167,168), X(169,170), X(171,172), X(173,174), X(175,176), X(177,178),
  X(179,180), X(181,182), X(183,184), X(185,186)
};
M(188) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(61,93), X(125,157),
  X(29,61), X(93,125), X(29,45), X(61,77), X(93,109), X(125,141), X(157,173),
  X(13,29), X(45,61), X(77,93), X(109,125), X(141,157), X(13,21), X(29,37),
  X(45,53), X(61,69), X(77,85), X(93,101), X(109,117), X(125,133), X(141,149),
  X(157,165), X(173,181), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(5,9),
  X(13,17), X(21,25), X(29,33), X(37,41), X(45,49), X(53,57), X(61,65), X(69,73),
  X(77,81), X(85,89), X(93,97), X(101,105), X(109,113), X(117,121), X(125,129),
  X(133,137), X(141,145), X(149,153), X(157,161), X(165,169), X(173,177),
  X(181,185), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(3,67), X(67,131), X(3,67), X(35,99),
  X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147),
  X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115), X(147,179),
  X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179), X(11,75),
  X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43), X(75,107),
  X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(123,187), X(59,123),
  X(27,59), X(91,123), X(155,187), X(11,27), X(43,59), X(75,91), X(107,123),
  X(139,155), X(171,187), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31), X(47,63),
  X(79,95), X(111,127), X(143,159), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(159,167),
  X(175,183), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(167,175), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(171,175),
  X(179,183), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(129,131), X(133,135), X(137,139), X(141,143),
  X(145,147), X(149,151), X(153,155), X(157,159), X(161,163), X(165,167),
  X(169,171), X(173,175), X(177,179), X(181,183), X(185,187), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50),
  X(82,114), X(146,178), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146),
  X(162,178), X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106),
  X(10,42), X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122),
  X(122,186), X(58,122), X(26,58), X(90,122), X(154,186), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(170,186), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(162,170), X(178,186), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166),
  X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86),
  X(54,118), X(118,182), X(54,118), X(22,54), X(86,118), X(150,182), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(166,182), X(14,78), X(78,142),
  X(14,78), X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174),
  X(30,94), X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62),
  X(94,126), X(30,46), X(62,78), X(94,110), X(126,142), X(158,174), X(14,30),
  X(46,62), X(78,94), X(110,126), X(142,158), X(14,22), X(30,38), X(46,54),
  X(62,70), X(78,86), X(94,102), X(110,118), X(126,134), X(142,150), X(158,166),
  X(174,182), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(150,158), X(166,174), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(166,170), X(174,178), X(182,186), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140), X(12,76),
  X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92),
  X(92,156), X(28,92), X(60,124), X(124,188), X(60,124), X(28,60), X(92,124),
  X(156,188), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(172,188),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(132,140), X(148,156), X(164,172), X(180,188), X(8,72), X(72,136),
  X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104), X(136,168),
  X(24,88), X(88,152), X(24,88), X(56,120), X(120,184), X(56,120), X(24,56),
  X(88,120), X(152,184), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(168,184), X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112),
  X(16,48), X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128),
  X(64,96), X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112),
  X(128,144), X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(160,168), X(176,184), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160),
  X(168,176), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(152,156),
  X(160,164), X(168,172), X(176,180), X(184,188), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(166,168),
  X(170,172), X(174,176), X(178,180), X(182,184), X(186,188), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(169,170),
  X(171,172), X(173,174), X(175,176), X(177,178), X(179,180), X(181,182),
  X(183,184), X(185,186), X(187,188)
};
M(189) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(125,189), X(61,125),
  X(29,61), X(93,125), X(157,189), X(13,29), X(45,61), X(77,93), X(109,125),
  X(141,157), X(173,189), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173),
  X(181,189), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(185,189), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115),
  X(147,179), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179),
  X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43),
  X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(123,187),
  X(59,123), X(27,59), X(91,123), X(155,187), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(171,187), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31), X(47,63),
  X(79,95), X(111,127), X(143,159), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(159,167),
  X(175,183), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(167,175), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(171,175),
  X(179,183), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93),
  X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(139,141),
  X(143,145), X(147,149), X(151,153), X(155,157), X(159,161), X(163,165),
  X(167,169), X(171,173), X(175,177), X(179,181), X(183,185), X(187,189), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(185,187), X(2,66), X(66,130), X(2,66),
  X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114),
  X(146,178), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178),
  X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42),
  X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(122,186),
  X(58,122), X(26,58), X(90,122), X(154,186), X(10,26), X(42,58), X(74,90),
  X(106,122), X(138,154), X(170,186), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170),
  X(178,186), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102),
  X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118),
  X(118,182), X(54,118), X(22,54), X(86,118), X(150,182), X(6,22), X(38,54),
  X(70,86), X(102,118), X(134,150), X(166,182), X(14,78), X(78,142), X(14,78),
  X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94),
  X(94,158), X(30,94), X(62,126), X(62,94), X(126,158), X(30,62), X(94,126),
  X(30,46), X(62,78), X(94,110), X(126,142), X(158,174), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(14,22), X(30,38), X(46,54), X(62,70),
  X(78,86), X(94,102), X(110,118), X(126,134), X(142,150), X(158,166),
  X(174,182), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(150,158), X(166,174), X(6,10), X(14,18),
  X(22,26), X(30,34), X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82),
  X(86,90), X(94,98), X(102,106), X(110,114), X(118,122), X(126,130), X(134,138),
  X(142,146), X(150,154), X(158,162), X(166,170), X(174,178), X(182,186), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140), X(12,76),
  X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92),
  X(92,156), X(28,92), X(60,124), X(124,188), X(60,124), X(28,60), X(92,124),
  X(156,188), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(172,188),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(132,140), X(148,156), X(164,172), X(180,188), X(8,72), X(72,136),
  X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104), X(136,168),
  X(24,88), X(88,152), X(24,88), X(56,120), X(120,184), X(56,120), X(24,56),
  X(88,120), X(152,184), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(168,184), X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112),
  X(16,48), X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128),
  X(64,96), X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112),
  X(128,144), X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(160,168), X(176,184), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160),
  X(168,176), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(152,156),
  X(160,164), X(168,172), X(176,180), X(184,188), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(166,168),
  X(170,172), X(174,176), X(178,180), X(182,184), X(186,188), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171),
  X(172,173), X(174,175), X(176,177), X(178,179), X(180,181), X(182,183),
  X(184,185), X(186,187), X(188,189), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164),
  X(165,166), X(167,168), X(169,170), X(171,172), X(173,174), X(175,176),
  X(177,178), X(179,180), X(181,182), X(183,184), X(185,186), X(187,188)
};
M(190) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(125,189), X(61,125),
  X(29,61), X(93,125), X(157,189), X(13,29), X(45,61), X(77,93), X(109,125),
  X(141,157), X(173,189), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173),
  X(181,189), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(185,189), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115),
  X(147,179), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179),
  X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43),
  X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(123,187),
  X(59,123), X(27,59), X(91,123), X(155,187), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(171,187), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(63,95), X(127,159), X(31,63), X(95,127),
  X(31,47), X(63,79), X(95,111), X(127,143), X(159,175), X(15,31), X(47,63),
  X(79,95), X(111,127), X(143,159), X(15,23), X(31,39), X(47,55), X(63,71),
  X(79,87), X(95,103), X(111,119), X(127,135), X(143,151), X(159,167),
  X(175,183), X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95),
  X(103,111), X(119,127), X(135,143), X(151,159), X(167,175), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187), X(3,7),
  X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71),
  X(75,79), X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127),
  X(131,135), X(139,143), X(147,151), X(155,159), X(163,167), X(171,175),
  X(179,183), X(3,5), X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29),
  X(31,33), X(35,37), X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61),
  X(63,65), X(67,69), X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93),
  X(95,97), X(99,101), X(103,105), X(107,109), X(111,113), X(115,117),
  X(119,121), X(123,125), X(127,129), X(131,133), X(135,137), X(139,141),
  X(143,145), X(147,149), X(151,153), X(155,157), X(159,161), X(163,165),
  X(167,169), X(171,173), X(175,177), X(179,181), X(183,185), X(187,189), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(185,187), X(2,66), X(66,130), X(2,66),
  X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114),
  X(146,178), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178),
  X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42),
  X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(122,186),
  X(58,122), X(26,58), X(90,122), X(154,186), X(10,26), X(42,58), X(74,90),
  X(106,122), X(138,154), X(170,186), X(2,10), X(18,26), X(34,42), X(50,58),
  X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154), X(162,170),
  X(178,186), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166), X(38,102),
  X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86), X(54,118),
  X(118,182), X(54,118), X(22,54), X(86,118), X(150,182), X(6,22), X(38,54),
  X(70,86), X(102,118), X(134,150), X(166,182), X(14,78), X(78,142), X(14,78),
  X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174), X(30,94),
  X(94,158), X(30,94), X(62,126), X(126,190), X(62,126), X(30,62), X(94,126),
  X(158,190), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158), X(174,190),
  X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94), X(102,110),
  X(118,126), X(134,142), X(150,158), X(166,174), X(182,190), X(2,6), X(10,14),
  X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70), X(74,78),
  X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126), X(130,134),
  X(138,142), X(146,150), X(154,158), X(162,166), X(170,174), X(178,182),
  X(186,190), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164), X(36,100),
  X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116),
  X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20), X(36,52),
  X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140), X(12,76),
  X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172), X(28,92),
  X(92,156), X(28,92), X(60,124), X(124,188), X(60,124), X(28,60), X(92,124),
  X(156,188), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156), X(172,188),
  X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92), X(100,108),
  X(116,124), X(132,140), X(148,156), X(164,172), X(180,188), X(8,72), X(72,136),
  X(8,72), X(40,104), X(104,168), X(40,104), X(8,40), X(72,104), X(136,168),
  X(24,88), X(88,152), X(24,88), X(56,120), X(120,184), X(56,120), X(24,56),
  X(88,120), X(152,184), X(8,24), X(40,56), X(72,88), X(104,120), X(136,152),
  X(168,184), X(16,80), X(80,144), X(16,80), X(48,112), X(112,176), X(48,112),
  X(16,48), X(80,112), X(144,176), X(32,96), X(96,160), X(32,96), X(64,128),
  X(64,96), X(128,160), X(32,64), X(96,128), X(32,48), X(64,80), X(96,112),
  X(128,144), X(160,176), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160),
  X(16,24), X(32,40), X(48,56), X(64,72), X(80,88), X(96,104), X(112,120),
  X(128,136), X(144,152), X(160,168), X(176,184), X(8,16), X(24,32), X(40,48),
  X(56,64), X(72,80), X(88,96), X(104,112), X(120,128), X(136,144), X(152,160),
  X(168,176), X(8,12), X(16,20), X(24,28), X(32,36), X(40,44), X(48,52),
  X(56,60), X(64,68), X(72,76), X(80,84), X(88,92), X(96,100), X(104,108),
  X(112,116), X(120,124), X(128,132), X(136,140), X(144,148), X(152,156),
  X(160,164), X(168,172), X(176,180), X(184,188), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(152,154), X(156,158), X(160,162), X(164,166), X(168,170),
  X(172,174), X(176,178), X(180,182), X(184,186), X(188,190), X(2,4), X(6,8),
  X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36), X(38,40),
  X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68), X(70,72),
  X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96), X(98,100),
  X(102,104), X(106,108), X(110,112), X(114,116), X(118,120), X(122,124),
  X(126,128), X(130,132), X(134,136), X(138,140), X(142,144), X(146,148),
  X(150,152), X(154,156), X(158,160), X(162,164), X(166,168), X(170,172),
  X(174,176), X(178,180), X(182,184), X(186,188), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168), X(169,170), X(171,172), X(173,174),
  X(175,176), X(177,178), X(179,180), X(181,182), X(183,184), X(185,186),
  X(187,188), X(189,190)
};
M(191) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(125,189), X(61,125),
  X(29,61), X(93,125), X(157,189), X(13,29), X(45,61), X(77,93), X(109,125),
  X(141,157), X(173,189), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173),
  X(181,189), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(185,189), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115),
  X(147,179), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179),
  X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43),
  X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(123,187),
  X(59,123), X(27,59), X(91,123), X(155,187), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(171,187), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(127,191), X(63,127), X(31,63), X(95,127),
  X(159,191), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(175,191),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(183,191), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(179,183),
  X(187,191), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(129,131), X(133,135), X(137,139), X(141,143),
  X(145,147), X(149,151), X(153,155), X(157,159), X(161,163), X(165,167),
  X(169,171), X(173,175), X(177,179), X(181,183), X(185,187), X(189,191),
  X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98),
  X(130,162), X(18,82), X(82,146), X(18,82), X(50,114), X(114,178), X(50,114),
  X(18,50), X(82,114), X(146,178), X(2,18), X(34,50), X(66,82), X(98,114),
  X(130,146), X(162,178), X(10,74), X(74,138), X(10,74), X(42,106), X(106,170),
  X(42,106), X(10,42), X(74,106), X(138,170), X(26,90), X(90,154), X(26,90),
  X(58,122), X(122,186), X(58,122), X(26,58), X(90,122), X(154,186), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(170,186), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138),
  X(146,154), X(162,170), X(178,186), X(6,70), X(70,134), X(6,70), X(38,102),
  X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150),
  X(22,86), X(54,118), X(118,182), X(54,118), X(22,54), X(86,118), X(150,182),
  X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(166,182), X(14,78),
  X(78,142), X(14,78), X(46,110), X(110,174), X(46,110), X(14,46), X(78,110),
  X(142,174), X(30,94), X(94,158), X(30,94), X(62,126), X(126,190), X(62,126),
  X(30,62), X(94,126), X(158,190), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(174,190), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174),
  X(182,190), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(154,158),
  X(162,166), X(170,174), X(178,182), X(186,190), X(4,68), X(68,132), X(4,68),
  X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84),
  X(84,148), X(20,84), X(52,116), X(116,180), X(52,116), X(20,52), X(84,116),
  X(148,180), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(164,180),
  X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108), X(12,44),
  X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124), X(124,188),
  X(60,124), X(28,60), X(92,124), X(156,188), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(172,188), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172),
  X(180,188), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(120,184), X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56),
  X(72,88), X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80),
  X(48,112), X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96),
  X(96,160), X(32,96), X(64,128), X(64,96), X(128,160), X(32,64), X(96,128),
  X(32,48), X(64,80), X(96,112), X(128,144), X(160,176), X(16,32), X(48,64),
  X(80,96), X(112,128), X(144,160), X(16,24), X(32,40), X(48,56), X(64,72),
  X(80,88), X(96,104), X(112,120), X(128,136), X(144,152), X(160,168),
  X(176,184), X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96),
  X(104,112), X(120,128), X(136,144), X(152,160), X(168,176), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(144,148), X(152,156), X(160,164), X(168,172), X(176,180),
  X(184,188), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40), X(44,48), X(52,56),
  X(60,64), X(68,72), X(76,80), X(84,88), X(92,96), X(100,104), X(108,112),
  X(116,120), X(124,128), X(132,136), X(140,144), X(148,152), X(156,160),
  X(164,168), X(172,176), X(180,184), X(4,6), X(8,10), X(12,14), X(16,18),
  X(20,22), X(24,26), X(28,30), X(32,34), X(36,38), X(40,42), X(44,46), X(48,50),
  X(52,54), X(56,58), X(60,62), X(64,66), X(68,70), X(72,74), X(76,78), X(80,82),
  X(84,86), X(88,90), X(92,94), X(96,98), X(100,102), X(104,106), X(108,110),
  X(112,114), X(116,118), X(120,122), X(124,126), X(128,130), X(132,134),
  X(136,138), X(140,142), X(144,146), X(148,150), X(152,154), X(156,158),
  X(160,162), X(164,166), X(168,170), X(172,174), X(176,178), X(180,182),
  X(184,186), X(188,190), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24),
  X(26,28), X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56),
  X(58,60), X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88),
  X(90,92), X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(182,184), X(186,188), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171),
  X(172,173), X(174,175), X(176,177), X(178,179), X(180,181), X(182,183),
  X(184,185), X(186,187), X(188,189), X(190,191), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168), X(169,170), X(171,172), X(173,174),
  X(175,176), X(177,178), X(179,180), X(181,182), X(183,184), X(185,186),
  X(187,188), X(189,190)
};
M(192) = {
  X(1,65), X(65,129), X(1,65), X(33,97), X(97,161), X(33,97), X(1,33), X(65,97),
  X(129,161), X(17,81), X(81,145), X(17,81), X(49,113), X(113,177), X(49,113),
  X(17,49), X(81,113), X(145,177), X(1,17), X(33,49), X(65,81), X(97,113),
  X(129,145), X(161,177), X(9,73), X(73,137), X(9,73), X(41,105), X(105,169),
  X(41,105), X(9,41), X(73,105), X(137,169), X(25,89), X(89,153), X(25,89),
  X(57,121), X(121,185), X(57,121), X(25,57), X(89,121), X(153,185), X(9,25),
  X(41,57), X(73,89), X(105,121), X(137,153), X(169,185), X(1,9), X(17,25),
  X(33,41), X(49,57), X(65,73), X(81,89), X(97,105), X(113,121), X(129,137),
  X(145,153), X(161,169), X(177,185), X(5,69), X(69,133), X(5,69), X(37,101),
  X(101,165), X(37,101), X(5,37), X(69,101), X(133,165), X(21,85), X(85,149),
  X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117), X(149,181),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(125,189), X(61,125),
  X(29,61), X(93,125), X(157,189), X(13,29), X(45,61), X(77,93), X(109,125),
  X(141,157), X(173,189), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77),
  X(85,93), X(101,109), X(117,125), X(133,141), X(149,157), X(165,173),
  X(181,189), X(1,5), X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53),
  X(57,61), X(65,69), X(73,77), X(81,85), X(89,93), X(97,101), X(105,109),
  X(113,117), X(121,125), X(129,133), X(137,141), X(145,149), X(153,157),
  X(161,165), X(169,173), X(177,181), X(185,189), X(3,67), X(67,131), X(3,67),
  X(35,99), X(99,163), X(35,99), X(3,35), X(67,99), X(131,163), X(19,83),
  X(83,147), X(19,83), X(51,115), X(115,179), X(51,115), X(19,51), X(83,115),
  X(147,179), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147), X(163,179),
  X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107), X(11,43),
  X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123), X(123,187),
  X(59,123), X(27,59), X(91,123), X(155,187), X(11,27), X(43,59), X(75,91),
  X(107,123), X(139,155), X(171,187), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(127,191), X(63,127), X(31,63), X(95,127),
  X(159,191), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(175,191),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(183,191), X(3,7), X(11,15),
  X(19,23), X(27,31), X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79),
  X(83,87), X(91,95), X(99,103), X(107,111), X(115,119), X(123,127), X(131,135),
  X(139,143), X(147,151), X(155,159), X(163,167), X(171,175), X(179,183),
  X(187,191), X(1,3), X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27),
  X(29,31), X(33,35), X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59),
  X(61,63), X(65,67), X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91),
  X(93,95), X(97,99), X(101,103), X(105,107), X(109,111), X(113,115), X(117,119),
  X(121,123), X(125,127), X(129,131), X(133,135), X(137,139), X(141,143),
  X(145,147), X(149,151), X(153,155), X(157,159), X(161,163), X(165,167),
  X(169,171), X(173,175), X(177,179), X(181,183), X(185,187), X(189,191),
  X(2,66), X(66,130), X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98),
  X(130,162), X(18,82), X(82,146), X(18,82), X(50,114), X(114,178), X(50,114),
  X(18,50), X(82,114), X(146,178), X(2,18), X(34,50), X(66,82), X(98,114),
  X(130,146), X(162,178), X(10,74), X(74,138), X(10,74), X(42,106), X(106,170),
  X(42,106), X(10,42), X(74,106), X(138,170), X(26,90), X(90,154), X(26,90),
  X(58,122), X(122,186), X(58,122), X(26,58), X(90,122), X(154,186), X(10,26),
  X(42,58), X(74,90), X(106,122), X(138,154), X(170,186), X(2,10), X(18,26),
  X(34,42), X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138),
  X(146,154), X(162,170), X(178,186), X(6,70), X(70,134), X(6,70), X(38,102),
  X(102,166), X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150),
  X(22,86), X(54,118), X(118,182), X(54,118), X(22,54), X(86,118), X(150,182),
  X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(166,182), X(14,78),
  X(78,142), X(14,78), X(46,110), X(110,174), X(46,110), X(14,46), X(78,110),
  X(142,174), X(30,94), X(94,158), X(30,94), X(62,126), X(126,190), X(62,126),
  X(30,62), X(94,126), X(158,190), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(174,190), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78),
  X(86,94), X(102,110), X(118,126), X(134,142), X(150,158), X(166,174),
  X(182,190), X(2,6), X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54),
  X(58,62), X(66,70), X(74,78), X(82,86), X(90,94), X(98,102), X(106,110),
  X(114,118), X(122,126), X(130,134), X(138,142), X(146,150), X(154,158),
  X(162,166), X(170,174), X(178,182), X(186,190), X(4,68), X(68,132), X(4,68),
  X(36,100), X(100,164), X(36,100), X(4,36), X(68,100), X(132,164), X(20,84),
  X(84,148), X(20,84), X(52,116), X(116,180), X(52,116), X(20,52), X(84,116),
  X(148,180), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148), X(164,180),
  X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108), X(12,44),
  X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124), X(124,188),
  X(60,124), X(28,60), X(92,124), X(156,188), X(12,28), X(44,60), X(76,92),
  X(108,124), X(140,156), X(172,188), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172),
  X(180,188), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(120,184), X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56),
  X(72,88), X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80),
  X(48,112), X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96),
  X(96,160), X(32,96), X(64,128), X(128,192), X(64,128), X(32,64), X(96,128),
  X(160,192), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(176,192),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(136,144), X(152,160), X(168,176), X(184,192), X(4,8), X(12,16),
  X(20,24), X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80),
  X(84,88), X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184),
  X(188,192), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(182,184), X(186,188),
  X(190,192), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172), X(173,174), X(175,176), X(177,178), X(179,180),
  X(181,182), X(183,184), X(185,186), X(187,188), X(189,190), X(191,192)
};
M(193) = {
  X(1,129), X(65,193), X(1,65), X(129,193), X(33,97), X(97,161), X(33,97),
  X(33,65), X(97,129), X(161,193), X(1,33), X(65,97), X(129,161), X(17,81),
  X(81,145), X(17,81), X(49,113), X(113,177), X(49,113), X(17,49), X(81,113),
  X(145,177), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161), X(177,193),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(161,177), X(9,73),
  X(73,137), X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105),
  X(137,169), X(25,89), X(89,153), X(25,89), X(57,121), X(121,185), X(57,121),
  X(25,57), X(89,121), X(153,185), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(169,185), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(121,129), X(137,145), X(153,161), X(169,177),
  X(185,193), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(161,169), X(177,185), X(5,69),
  X(69,133), X(5,69), X(37,101), X(101,165), X(37,101), X(5,37), X(69,101),
  X(133,165), X(21,85), X(85,149), X(21,85), X(53,117), X(117,181), X(53,117),
  X(21,53), X(85,117), X(149,181), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(165,181), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173),
  X(45,109), X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93),
  X(61,125), X(125,189), X(61,125), X(29,61), X(93,125), X(157,189), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(173,189), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141),
  X(149,157), X(165,173), X(181,189), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145),
  X(149,153), X(157,161), X(165,169), X(173,177), X(181,185), X(189,193), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(145,149), X(153,157), X(161,165), X(169,173),
  X(177,181), X(185,189), X(3,67), X(67,131), X(3,67), X(35,99), X(99,163),
  X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147), X(19,83),
  X(51,115), X(115,179), X(51,115), X(19,51), X(83,115), X(147,179), X(3,19),
  X(35,51), X(67,83), X(99,115), X(131,147), X(163,179), X(11,75), X(75,139),
  X(11,75), X(43,107), X(107,171), X(43,107), X(11,43), X(75,107), X(139,171),
  X(27,91), X(91,155), X(27,91), X(59,123), X(123,187), X(59,123), X(27,59),
  X(91,123), X(155,187), X(11,27), X(43,59), X(75,91), X(107,123), X(139,155),
  X(171,187), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(179,187), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(119,183), X(55,119),
  X(23,55), X(87,119), X(151,183), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(167,183), X(15,79), X(79,143), X(15,79), X(47,111), X(111,175),
  X(47,111), X(15,47), X(79,111), X(143,175), X(31,95), X(95,159), X(31,95),
  X(63,127), X(127,191), X(63,127), X(31,63), X(95,127), X(159,191), X(15,31),
  X(47,63), X(79,95), X(111,127), X(143,159), X(175,191), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(151,159), X(167,175), X(183,191), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(163,167), X(171,175), X(179,183), X(187,191), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(131,133), X(135,137), X(139,141), X(143,145),
  X(147,149), X(151,153), X(155,157), X(159,161), X(163,165), X(167,169),
  X(171,173), X(175,177), X(179,181), X(183,185), X(187,189), X(191,193), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(185,187), X(189,191), X(2,66), X(66,130),
  X(2,66), X(34,98), X(98,162), X(34,98), X(2,34), X(66,98), X(130,162),
  X(18,82), X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50),
  X(82,114), X(146,178), X(2,18), X(34,50), X(66,82), X(98,114), X(130,146),
  X(162,178), X(10,74), X(74,138), X(10,74), X(42,106), X(106,170), X(42,106),
  X(10,42), X(74,106), X(138,170), X(26,90), X(90,154), X(26,90), X(58,122),
  X(122,186), X(58,122), X(26,58), X(90,122), X(154,186), X(10,26), X(42,58),
  X(74,90), X(106,122), X(138,154), X(170,186), X(2,10), X(18,26), X(34,42),
  X(50,58), X(66,74), X(82,90), X(98,106), X(114,122), X(130,138), X(146,154),
  X(162,170), X(178,186), X(6,70), X(70,134), X(6,70), X(38,102), X(102,166),
  X(38,102), X(6,38), X(70,102), X(134,166), X(22,86), X(86,150), X(22,86),
  X(54,118), X(118,182), X(54,118), X(22,54), X(86,118), X(150,182), X(6,22),
  X(38,54), X(70,86), X(102,118), X(134,150), X(166,182), X(14,78), X(78,142),
  X(14,78), X(46,110), X(110,174), X(46,110), X(14,46), X(78,110), X(142,174),
  X(30,94), X(94,158), X(30,94), X(62,126), X(126,190), X(62,126), X(30,62),
  X(94,126), X(158,190), X(14,30), X(46,62), X(78,94), X(110,126), X(142,158),
  X(174,190), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(150,158), X(166,174), X(182,190), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(186,190), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164),
  X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84),
  X(52,116), X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140),
  X(12,76), X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172),
  X(28,92), X(92,156), X(28,92), X(60,124), X(124,188), X(60,124), X(28,60),
  X(92,124), X(156,188), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(172,188), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(180,188),
  X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40),
  X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(120,184),
  X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56), X(72,88),
  X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80), X(48,112),
  X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96), X(96,160),
  X(32,96), X(64,128), X(128,192), X(64,128), X(32,64), X(96,128), X(160,192),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(176,192), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(168,176), X(184,192), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184),
  X(188,192), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(182,184), X(186,188),
  X(190,192), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(138,139), X(140,141), X(142,143), X(144,145),
  X(146,147), X(148,149), X(150,151), X(152,153), X(154,155), X(156,157),
  X(158,159), X(160,161), X(162,163), X(164,165), X(166,167), X(168,169),
  X(170,171), X(172,173), X(174,175), X(176,177), X(178,179), X(180,181),
  X(182,183), X(184,185), X(186,187), X(188,189), X(190,191), X(192,193), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(169,170),
  X(171,172), X(173,174), X(175,176), X(177,178), X(179,180), X(181,182),
  X(183,184), X(185,186), X(187,188), X(189,190), X(191,192)
};
M(194) = {
  X(1,129), X(65,193), X(1,65), X(129,193), X(33,97), X(97,161), X(33,97),
  X(33,65), X(97,129), X(161,193), X(1,33), X(65,97), X(129,161), X(17,81),
  X(81,145), X(17,81), X(49,113), X(113,177), X(49,113), X(17,49), X(81,113),
  X(145,177), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161), X(177,193),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(161,177), X(9,73),
  X(73,137), X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105),
  X(137,169), X(25,89), X(89,153), X(25,89), X(57,121), X(121,185), X(57,121),
  X(25,57), X(89,121), X(153,185), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(169,185), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(121,129), X(137,145), X(153,161), X(169,177),
  X(185,193), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(161,169), X(177,185), X(5,69),
  X(69,133), X(5,69), X(37,101), X(101,165), X(37,101), X(5,37), X(69,101),
  X(133,165), X(21,85), X(85,149), X(21,85), X(53,117), X(117,181), X(53,117),
  X(21,53), X(85,117), X(149,181), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(165,181), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173),
  X(45,109), X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93),
  X(61,125), X(125,189), X(61,125), X(29,61), X(93,125), X(157,189), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(173,189), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141),
  X(149,157), X(165,173), X(181,189), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145),
  X(149,153), X(157,161), X(165,169), X(173,177), X(181,185), X(189,193), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(145,149), X(153,157), X(161,165), X(169,173),
  X(177,181), X(185,189), X(3,67), X(67,131), X(3,67), X(35,99), X(99,163),
  X(35,99), X(3,35), X(67,99), X(131,163), X(19,83), X(83,147), X(19,83),
  X(51,115), X(115,179), X(51,115), X(19,51), X(83,115), X(147,179), X(3,19),
  X(35,51), X(67,83), X(99,115), X(131,147), X(163,179), X(11,75), X(75,139),
  X(11,75), X(43,107), X(107,171), X(43,107), X(11,43), X(75,107), X(139,171),
  X(27,91), X(91,155), X(27,91), X(59,123), X(123,187), X(59,123), X(27,59),
  X(91,123), X(155,187), X(11,27), X(43,59), X(75,91), X(107,123), X(139,155),
  X(171,187), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75), X(83,91),
  X(99,107), X(115,123), X(131,139), X(147,155), X(163,171), X(179,187), X(7,71),
  X(71,135), X(7,71), X(39,103), X(103,167), X(39,103), X(7,39), X(71,103),
  X(135,167), X(23,87), X(87,151), X(23,87), X(55,119), X(119,183), X(55,119),
  X(23,55), X(87,119), X(151,183), X(7,23), X(39,55), X(71,87), X(103,119),
  X(135,151), X(167,183), X(15,79), X(79,143), X(15,79), X(47,111), X(111,175),
  X(47,111), X(15,47), X(79,111), X(143,175), X(31,95), X(95,159), X(31,95),
  X(63,127), X(127,191), X(63,127), X(31,63), X(95,127), X(159,191), X(15,31),
  X(47,63), X(79,95), X(111,127), X(143,159), X(175,191), X(7,15), X(23,31),
  X(39,47), X(55,63), X(71,79), X(87,95), X(103,111), X(119,127), X(135,143),
  X(151,159), X(167,175), X(183,191), X(3,7), X(11,15), X(19,23), X(27,31),
  X(35,39), X(43,47), X(51,55), X(59,63), X(67,71), X(75,79), X(83,87), X(91,95),
  X(99,103), X(107,111), X(115,119), X(123,127), X(131,135), X(139,143),
  X(147,151), X(155,159), X(163,167), X(171,175), X(179,183), X(187,191), X(3,5),
  X(7,9), X(11,13), X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37),
  X(39,41), X(43,45), X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69),
  X(71,73), X(75,77), X(79,81), X(83,85), X(87,89), X(91,93), X(95,97),
  X(99,101), X(103,105), X(107,109), X(111,113), X(115,117), X(119,121),
  X(123,125), X(127,129), X(131,133), X(135,137), X(139,141), X(143,145),
  X(147,149), X(151,153), X(155,157), X(159,161), X(163,165), X(167,169),
  X(171,173), X(175,177), X(179,181), X(183,185), X(187,189), X(191,193), X(1,3),
  X(5,7), X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35),
  X(37,39), X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67),
  X(69,71), X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(185,187), X(189,191), X(2,130),
  X(66,194), X(2,66), X(130,194), X(34,98), X(98,162), X(34,98), X(34,66),
  X(98,130), X(162,194), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114), X(146,178),
  X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(178,194), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138),
  X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170),
  X(26,90), X(90,154), X(26,90), X(58,122), X(122,186), X(58,122), X(26,58),
  X(90,122), X(154,186), X(10,26), X(42,58), X(74,90), X(106,122), X(138,154),
  X(170,186), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(122,130), X(138,146), X(154,162), X(170,178), X(186,194),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(162,170), X(178,186), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(118,182), X(54,118), X(22,54),
  X(86,118), X(150,182), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(166,182), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174), X(46,110),
  X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94), X(62,126),
  X(126,190), X(62,126), X(30,62), X(94,126), X(158,190), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(174,190), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158),
  X(166,174), X(182,190), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(158,162), X(166,170), X(174,178), X(182,186), X(190,194), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(186,190), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164),
  X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84),
  X(52,116), X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140),
  X(12,76), X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172),
  X(28,92), X(92,156), X(28,92), X(60,124), X(124,188), X(60,124), X(28,60),
  X(92,124), X(156,188), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(172,188), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(180,188),
  X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40),
  X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(120,184),
  X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56), X(72,88),
  X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80), X(48,112),
  X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96), X(96,160),
  X(32,96), X(64,128), X(128,192), X(64,128), X(32,64), X(96,128), X(160,192),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(176,192), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(168,176), X(184,192), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184),
  X(188,192), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62),
  X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94),
  X(96,98), X(100,102), X(104,106), X(108,110), X(112,114), X(116,118),
  X(120,122), X(124,126), X(128,130), X(132,134), X(136,138), X(140,142),
  X(144,146), X(148,150), X(152,154), X(156,158), X(160,162), X(164,166),
  X(168,170), X(172,174), X(176,178), X(180,182), X(184,186), X(188,190),
  X(192,194), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(182,184), X(186,188),
  X(190,192), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172), X(173,174), X(175,176), X(177,178), X(179,180),
  X(181,182), X(183,184), X(185,186), X(187,188), X(189,190), X(191,192),
  X(193,194)
};
M(195) = {
  X(1,129), X(65,193), X(1,65), X(129,193), X(33,97), X(97,161), X(33,97),
  X(33,65), X(97,129), X(161,193), X(1,33), X(65,97), X(129,161), X(17,81),
  X(81,145), X(17,81), X(49,113), X(113,177), X(49,113), X(17,49), X(81,113),
  X(145,177), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161), X(177,193),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(161,177), X(9,73),
  X(73,137), X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105),
  X(137,169), X(25,89), X(89,153), X(25,89), X(57,121), X(121,185), X(57,121),
  X(25,57), X(89,121), X(153,185), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(169,185), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(121,129), X(137,145), X(153,161), X(169,177),
  X(185,193), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(161,169), X(177,185), X(5,69),
  X(69,133), X(5,69), X(37,101), X(101,165), X(37,101), X(5,37), X(69,101),
  X(133,165), X(21,85), X(85,149), X(21,85), X(53,117), X(117,181), X(53,117),
  X(21,53), X(85,117), X(149,181), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(165,181), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173),
  X(45,109), X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93),
  X(61,125), X(125,189), X(61,125), X(29,61), X(93,125), X(157,189), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(173,189), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141),
  X(149,157), X(165,173), X(181,189), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145),
  X(149,153), X(157,161), X(165,169), X(173,177), X(181,185), X(189,193), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(145,149), X(153,157), X(161,165), X(169,173),
  X(177,181), X(185,189), X(3,131), X(67,195), X(3,67), X(131,195), X(35,99),
  X(99,163), X(35,99), X(35,67), X(99,131), X(163,195), X(3,35), X(67,99),
  X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115),
  X(19,51), X(83,115), X(147,179), X(19,35), X(51,67), X(83,99), X(115,131),
  X(147,163), X(179,195), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147),
  X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107),
  X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123),
  X(123,187), X(59,123), X(27,59), X(91,123), X(155,187), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(171,187), X(11,19), X(27,35), X(43,51),
  X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(139,147), X(155,163),
  X(171,179), X(187,195), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(127,191), X(63,127), X(31,63), X(95,127),
  X(159,191), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(175,191),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(183,191), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187),
  X(191,195), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(155,159),
  X(163,167), X(171,175), X(179,183), X(187,191), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(145,147), X(149,151),
  X(153,155), X(157,159), X(161,163), X(165,167), X(169,171), X(173,175),
  X(177,179), X(181,183), X(185,187), X(189,191), X(193,195), X(2,130),
  X(66,194), X(2,66), X(130,194), X(34,98), X(98,162), X(34,98), X(34,66),
  X(98,130), X(162,194), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114), X(146,178),
  X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(178,194), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138),
  X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170),
  X(26,90), X(90,154), X(26,90), X(58,122), X(122,186), X(58,122), X(26,58),
  X(90,122), X(154,186), X(10,26), X(42,58), X(74,90), X(106,122), X(138,154),
  X(170,186), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(122,130), X(138,146), X(154,162), X(170,178), X(186,194),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(162,170), X(178,186), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(118,182), X(54,118), X(22,54),
  X(86,118), X(150,182), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(166,182), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174), X(46,110),
  X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94), X(62,126),
  X(126,190), X(62,126), X(30,62), X(94,126), X(158,190), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(174,190), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158),
  X(166,174), X(182,190), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(158,162), X(166,170), X(174,178), X(182,186), X(190,194), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(186,190), X(4,68), X(68,132), X(4,68), X(36,100), X(100,164),
  X(36,100), X(4,36), X(68,100), X(132,164), X(20,84), X(84,148), X(20,84),
  X(52,116), X(116,180), X(52,116), X(20,52), X(84,116), X(148,180), X(4,20),
  X(36,52), X(68,84), X(100,116), X(132,148), X(164,180), X(12,76), X(76,140),
  X(12,76), X(44,108), X(108,172), X(44,108), X(12,44), X(76,108), X(140,172),
  X(28,92), X(92,156), X(28,92), X(60,124), X(124,188), X(60,124), X(28,60),
  X(92,124), X(156,188), X(12,28), X(44,60), X(76,92), X(108,124), X(140,156),
  X(172,188), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76), X(84,92),
  X(100,108), X(116,124), X(132,140), X(148,156), X(164,172), X(180,188),
  X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104), X(8,40),
  X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120), X(120,184),
  X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56), X(72,88),
  X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80), X(48,112),
  X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96), X(96,160),
  X(32,96), X(64,128), X(128,192), X(64,128), X(32,64), X(96,128), X(160,192),
  X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(176,192), X(8,16),
  X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112), X(120,128),
  X(136,144), X(152,160), X(168,176), X(184,192), X(4,8), X(12,16), X(20,24),
  X(28,32), X(36,40), X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88),
  X(92,96), X(100,104), X(108,112), X(116,120), X(124,128), X(132,136),
  X(140,144), X(148,152), X(156,160), X(164,168), X(172,176), X(180,184),
  X(188,192), X(4,6), X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30),
  X(32,34), X(36,38), X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62),
  X(64,66), X(68,70), X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94),
  X(96,98), X(100,102), X(104,106), X(108,110), X(112,114), X(116,118),
  X(120,122), X(124,126), X(128,130), X(132,134), X(136,138), X(140,142),
  X(144,146), X(148,150), X(152,154), X(156,158), X(160,162), X(164,166),
  X(168,170), X(172,174), X(176,178), X(180,182), X(184,186), X(188,190),
  X(192,194), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(182,184), X(186,188),
  X(190,192), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(138,139), X(140,141), X(142,143), X(144,145),
  X(146,147), X(148,149), X(150,151), X(152,153), X(154,155), X(156,157),
  X(158,159), X(160,161), X(162,163), X(164,165), X(166,167), X(168,169),
  X(170,171), X(172,173), X(174,175), X(176,177), X(178,179), X(180,181),
  X(182,183), X(184,185), X(186,187), X(188,189), X(190,191), X(192,193),
  X(194,195), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172), X(173,174), X(175,176), X(177,178), X(179,180),
  X(181,182), X(183,184), X(185,186), X(187,188), X(189,190), X(191,192),
  X(193,194)
};
M(196) = {
  X(1,129), X(65,193), X(1,65), X(129,193), X(33,97), X(97,161), X(33,97),
  X(33,65), X(97,129), X(161,193), X(1,33), X(65,97), X(129,161), X(17,81),
  X(81,145), X(17,81), X(49,113), X(113,177), X(49,113), X(17,49), X(81,113),
  X(145,177), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161), X(177,193),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(161,177), X(9,73),
  X(73,137), X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105),
  X(137,169), X(25,89), X(89,153), X(25,89), X(57,121), X(121,185), X(57,121),
  X(25,57), X(89,121), X(153,185), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(169,185), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(121,129), X(137,145), X(153,161), X(169,177),
  X(185,193), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(161,169), X(177,185), X(5,69),
  X(69,133), X(5,69), X(37,101), X(101,165), X(37,101), X(5,37), X(69,101),
  X(133,165), X(21,85), X(85,149), X(21,85), X(53,117), X(117,181), X(53,117),
  X(21,53), X(85,117), X(149,181), X(5,21), X(37,53), X(69,85), X(101,117),
  X(133,149), X(165,181), X(13,77), X(77,141), X(13,77), X(45,109), X(109,173),
  X(45,109), X(13,45), X(77,109), X(141,173), X(29,93), X(93,157), X(29,93),
  X(61,125), X(125,189), X(61,125), X(29,61), X(93,125), X(157,189), X(13,29),
  X(45,61), X(77,93), X(109,125), X(141,157), X(173,189), X(5,13), X(21,29),
  X(37,45), X(53,61), X(69,77), X(85,93), X(101,109), X(117,125), X(133,141),
  X(149,157), X(165,173), X(181,189), X(5,9), X(13,17), X(21,25), X(29,33),
  X(37,41), X(45,49), X(53,57), X(61,65), X(69,73), X(77,81), X(85,89), X(93,97),
  X(101,105), X(109,113), X(117,121), X(125,129), X(133,137), X(141,145),
  X(149,153), X(157,161), X(165,169), X(173,177), X(181,185), X(189,193), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(145,149), X(153,157), X(161,165), X(169,173),
  X(177,181), X(185,189), X(3,131), X(67,195), X(3,67), X(131,195), X(35,99),
  X(99,163), X(35,99), X(35,67), X(99,131), X(163,195), X(3,35), X(67,99),
  X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179), X(51,115),
  X(19,51), X(83,115), X(147,179), X(19,35), X(51,67), X(83,99), X(115,131),
  X(147,163), X(179,195), X(3,19), X(35,51), X(67,83), X(99,115), X(131,147),
  X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171), X(43,107),
  X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91), X(59,123),
  X(123,187), X(59,123), X(27,59), X(91,123), X(155,187), X(11,27), X(43,59),
  X(75,91), X(107,123), X(139,155), X(171,187), X(11,19), X(27,35), X(43,51),
  X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(139,147), X(155,163),
  X(171,179), X(187,195), X(3,11), X(19,27), X(35,43), X(51,59), X(67,75),
  X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(127,191), X(63,127), X(31,63), X(95,127),
  X(159,191), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(175,191),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(183,191), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187),
  X(191,195), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(155,159),
  X(163,167), X(171,175), X(179,183), X(187,191), X(1,3), X(5,7), X(9,11),
  X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39), X(41,43),
  X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71), X(73,75),
  X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99), X(101,103),
  X(105,107), X(109,111), X(113,115), X(117,119), X(121,123), X(125,127),
  X(129,131), X(133,135), X(137,139), X(141,143), X(145,147), X(149,151),
  X(153,155), X(157,159), X(161,163), X(165,167), X(169,171), X(173,175),
  X(177,179), X(181,183), X(185,187), X(189,191), X(193,195), X(2,130),
  X(66,194), X(2,66), X(130,194), X(34,98), X(98,162), X(34,98), X(34,66),
  X(98,130), X(162,194), X(2,34), X(66,98), X(130,162), X(18,82), X(82,146),
  X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114), X(146,178),
  X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(178,194), X(2,18),
  X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74), X(74,138),
  X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106), X(138,170),
  X(26,90), X(90,154), X(26,90), X(58,122), X(122,186), X(58,122), X(26,58),
  X(90,122), X(154,186), X(10,26), X(42,58), X(74,90), X(106,122), X(138,154),
  X(170,186), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82), X(90,98),
  X(106,114), X(122,130), X(138,146), X(154,162), X(170,178), X(186,194),
  X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90), X(98,106),
  X(114,122), X(130,138), X(146,154), X(162,170), X(178,186), X(6,70), X(70,134),
  X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102), X(134,166),
  X(22,86), X(86,150), X(22,86), X(54,118), X(118,182), X(54,118), X(22,54),
  X(86,118), X(150,182), X(6,22), X(38,54), X(70,86), X(102,118), X(134,150),
  X(166,182), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174), X(46,110),
  X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94), X(62,126),
  X(126,190), X(62,126), X(30,62), X(94,126), X(158,190), X(14,30), X(46,62),
  X(78,94), X(110,126), X(142,158), X(174,190), X(6,14), X(22,30), X(38,46),
  X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142), X(150,158),
  X(166,174), X(182,190), X(6,10), X(14,18), X(22,26), X(30,34), X(38,42),
  X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(158,162), X(166,170), X(174,178), X(182,186), X(190,194), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(186,190), X(4,132), X(68,196), X(4,68), X(132,196), X(36,100),
  X(100,164), X(36,100), X(36,68), X(100,132), X(164,196), X(4,36), X(68,100),
  X(132,164), X(20,84), X(84,148), X(20,84), X(52,116), X(116,180), X(52,116),
  X(20,52), X(84,116), X(148,180), X(20,36), X(52,68), X(84,100), X(116,132),
  X(148,164), X(180,196), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(164,180), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108),
  X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124),
  X(124,188), X(60,124), X(28,60), X(92,124), X(156,188), X(12,28), X(44,60),
  X(76,92), X(108,124), X(140,156), X(172,188), X(12,20), X(28,36), X(44,52),
  X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(156,164),
  X(172,180), X(188,196), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172),
  X(180,188), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(120,184), X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56),
  X(72,88), X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80),
  X(48,112), X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96),
  X(96,160), X(32,96), X(64,128), X(128,192), X(64,128), X(32,64), X(96,128),
  X(160,192), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(176,192),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(136,144), X(152,160), X(168,176), X(184,192), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(144,148), X(152,156), X(160,164), X(168,172), X(176,180),
  X(184,188), X(192,196), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(164,168), X(172,176), X(180,184), X(188,192), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(166,168),
  X(170,172), X(174,176), X(178,180), X(182,184), X(186,188), X(190,192),
  X(194,196), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(109,110), X(111,112), X(113,114), X(115,116), X(117,118), X(119,120),
  X(121,122), X(123,124), X(125,126), X(127,128), X(129,130), X(131,132),
  X(133,134), X(135,136), X(137,138), X(139,140), X(141,142), X(143,144),
  X(145,146), X(147,148), X(149,150), X(151,152), X(153,154), X(155,156),
  X(157,158), X(159,160), X(161,162), X(163,164), X(165,166), X(167,168),
  X(169,170), X(171,172), X(173,174), X(175,176), X(177,178), X(179,180),
  X(181,182), X(183,184), X(185,186), X(187,188), X(189,190), X(191,192),
  X(193,194), X(195,196)
};
M(197) = {
  X(1,129), X(65,193), X(1,65), X(129,193), X(33,97), X(97,161), X(33,97),
  X(33,65), X(97,129), X(161,193), X(1,33), X(65,97), X(129,161), X(17,81),
  X(81,145), X(17,81), X(49,113), X(113,177), X(49,113), X(17,49), X(81,113),
  X(145,177), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161), X(177,193),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(161,177), X(9,73),
  X(73,137), X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105),
  X(137,169), X(25,89), X(89,153), X(25,89), X(57,121), X(121,185), X(57,121),
  X(25,57), X(89,121), X(153,185), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(169,185), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(121,129), X(137,145), X(153,161), X(169,177),
  X(185,193), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(161,169), X(177,185),
  X(5,133), X(69,197), X(5,69), X(133,197), X(37,101), X(101,165), X(37,101),
  X(37,69), X(101,133), X(165,197), X(5,37), X(69,101), X(133,165), X(21,85),
  X(85,149), X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117),
  X(149,181), X(21,37), X(53,69), X(85,101), X(117,133), X(149,165), X(181,197),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(125,189), X(61,125),
  X(29,61), X(93,125), X(157,189), X(13,29), X(45,61), X(77,93), X(109,125),
  X(141,157), X(173,189), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(141,149), X(157,165), X(173,181),
  X(189,197), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(181,189), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(145,149), X(153,157), X(161,165), X(169,173),
  X(177,181), X(185,189), X(193,197), X(3,131), X(67,195), X(3,67), X(131,195),
  X(35,99), X(99,163), X(35,99), X(35,67), X(99,131), X(163,195), X(3,35),
  X(67,99), X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179),
  X(51,115), X(19,51), X(83,115), X(147,179), X(19,35), X(51,67), X(83,99),
  X(115,131), X(147,163), X(179,195), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171),
  X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91),
  X(59,123), X(123,187), X(59,123), X(27,59), X(91,123), X(155,187), X(11,27),
  X(43,59), X(75,91), X(107,123), X(139,155), X(171,187), X(11,19), X(27,35),
  X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(139,147),
  X(155,163), X(171,179), X(187,195), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(127,191), X(63,127), X(31,63), X(95,127),
  X(159,191), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(175,191),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(183,191), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187),
  X(191,195), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(155,159),
  X(163,167), X(171,175), X(179,183), X(187,191), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153),
  X(155,157), X(159,161), X(163,165), X(167,169), X(171,173), X(175,177),
  X(179,181), X(183,185), X(187,189), X(191,193), X(195,197), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(185,187), X(189,191), X(193,195),
  X(2,130), X(66,194), X(2,66), X(130,194), X(34,98), X(98,162), X(34,98),
  X(34,66), X(98,130), X(162,194), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114),
  X(146,178), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(178,194),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74),
  X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106),
  X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(122,186), X(58,122),
  X(26,58), X(90,122), X(154,186), X(10,26), X(42,58), X(74,90), X(106,122),
  X(138,154), X(170,186), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(106,114), X(122,130), X(138,146), X(154,162), X(170,178),
  X(186,194), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(178,186), X(6,70),
  X(70,134), X(6,70), X(38,102), X(102,166), X(38,102), X(6,38), X(70,102),
  X(134,166), X(22,86), X(86,150), X(22,86), X(54,118), X(118,182), X(54,118),
  X(22,54), X(86,118), X(150,182), X(6,22), X(38,54), X(70,86), X(102,118),
  X(134,150), X(166,182), X(14,78), X(78,142), X(14,78), X(46,110), X(110,174),
  X(46,110), X(14,46), X(78,110), X(142,174), X(30,94), X(94,158), X(30,94),
  X(62,126), X(126,190), X(62,126), X(30,62), X(94,126), X(158,190), X(14,30),
  X(46,62), X(78,94), X(110,126), X(142,158), X(174,190), X(6,14), X(22,30),
  X(38,46), X(54,62), X(70,78), X(86,94), X(102,110), X(118,126), X(134,142),
  X(150,158), X(166,174), X(182,190), X(6,10), X(14,18), X(22,26), X(30,34),
  X(38,42), X(46,50), X(54,58), X(62,66), X(70,74), X(78,82), X(86,90), X(94,98),
  X(102,106), X(110,114), X(118,122), X(126,130), X(134,138), X(142,146),
  X(150,154), X(158,162), X(166,170), X(174,178), X(182,186), X(190,194), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(186,190), X(4,132), X(68,196), X(4,68), X(132,196), X(36,100),
  X(100,164), X(36,100), X(36,68), X(100,132), X(164,196), X(4,36), X(68,100),
  X(132,164), X(20,84), X(84,148), X(20,84), X(52,116), X(116,180), X(52,116),
  X(20,52), X(84,116), X(148,180), X(20,36), X(52,68), X(84,100), X(116,132),
  X(148,164), X(180,196), X(4,20), X(36,52), X(68,84), X(100,116), X(132,148),
  X(164,180), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172), X(44,108),
  X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92), X(60,124),
  X(124,188), X(60,124), X(28,60), X(92,124), X(156,188), X(12,28), X(44,60),
  X(76,92), X(108,124), X(140,156), X(172,188), X(12,20), X(28,36), X(44,52),
  X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(140,148), X(156,164),
  X(172,180), X(188,196), X(4,12), X(20,28), X(36,44), X(52,60), X(68,76),
  X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172),
  X(180,188), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(120,184), X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56),
  X(72,88), X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80),
  X(48,112), X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96),
  X(96,160), X(32,96), X(64,128), X(128,192), X(64,128), X(32,64), X(96,128),
  X(160,192), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(176,192),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(136,144), X(152,160), X(168,176), X(184,192), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(144,148), X(152,156), X(160,164), X(168,172), X(176,180),
  X(184,188), X(192,196), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(164,168), X(172,176), X(180,184), X(188,192), X(2,4),
  X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28), X(30,32), X(34,36),
  X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60), X(62,64), X(66,68),
  X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92), X(94,96),
  X(98,100), X(102,104), X(106,108), X(110,112), X(114,116), X(118,120),
  X(122,124), X(126,128), X(130,132), X(134,136), X(138,140), X(142,144),
  X(146,148), X(150,152), X(154,156), X(158,160), X(162,164), X(166,168),
  X(170,172), X(174,176), X(178,180), X(182,184), X(186,188), X(190,192),
  X(194,196), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(138,139), X(140,141), X(142,143), X(144,145),
  X(146,147), X(148,149), X(150,151), X(152,153), X(154,155), X(156,157),
  X(158,159), X(160,161), X(162,163), X(164,165), X(166,167), X(168,169),
  X(170,171), X(172,173), X(174,175), X(176,177), X(178,179), X(180,181),
  X(182,183), X(184,185), X(186,187), X(188,189), X(190,191), X(192,193),
  X(194,195), X(196,197), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162), X(163,164), X(165,166),
  X(167,168), X(169,170), X(171,172), X(173,174), X(175,176), X(177,178),
  X(179,180), X(181,182), X(183,184), X(185,186), X(187,188), X(189,190),
  X(191,192), X(193,194), X(195,196)
};
M(198) = {
  X(1,129), X(65,193), X(1,65), X(129,193), X(33,97), X(97,161), X(33,97),
  X(33,65), X(97,129), X(161,193), X(1,33), X(65,97), X(129,161), X(17,81),
  X(81,145), X(17,81), X(49,113), X(113,177), X(49,113), X(17,49), X(81,113),
  X(145,177), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161), X(177,193),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(161,177), X(9,73),
  X(73,137), X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105),
  X(137,169), X(25,89), X(89,153), X(25,89), X(57,121), X(121,185), X(57,121),
  X(25,57), X(89,121), X(153,185), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(169,185), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(121,129), X(137,145), X(153,161), X(169,177),
  X(185,193), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(161,169), X(177,185),
  X(5,133), X(69,197), X(5,69), X(133,197), X(37,101), X(101,165), X(37,101),
  X(37,69), X(101,133), X(165,197), X(5,37), X(69,101), X(133,165), X(21,85),
  X(85,149), X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117),
  X(149,181), X(21,37), X(53,69), X(85,101), X(117,133), X(149,165), X(181,197),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(125,189), X(61,125),
  X(29,61), X(93,125), X(157,189), X(13,29), X(45,61), X(77,93), X(109,125),
  X(141,157), X(173,189), X(13,21), X(29,37), X(45,53), X(61,69), X(77,85),
  X(93,101), X(109,117), X(125,133), X(141,149), X(157,165), X(173,181),
  X(189,197), X(5,13), X(21,29), X(37,45), X(53,61), X(69,77), X(85,93),
  X(101,109), X(117,125), X(133,141), X(149,157), X(165,173), X(181,189), X(1,5),
  X(9,13), X(17,21), X(25,29), X(33,37), X(41,45), X(49,53), X(57,61), X(65,69),
  X(73,77), X(81,85), X(89,93), X(97,101), X(105,109), X(113,117), X(121,125),
  X(129,133), X(137,141), X(145,149), X(153,157), X(161,165), X(169,173),
  X(177,181), X(185,189), X(193,197), X(3,131), X(67,195), X(3,67), X(131,195),
  X(35,99), X(99,163), X(35,99), X(35,67), X(99,131), X(163,195), X(3,35),
  X(67,99), X(131,163), X(19,83), X(83,147), X(19,83), X(51,115), X(115,179),
  X(51,115), X(19,51), X(83,115), X(147,179), X(19,35), X(51,67), X(83,99),
  X(115,131), X(147,163), X(179,195), X(3,19), X(35,51), X(67,83), X(99,115),
  X(131,147), X(163,179), X(11,75), X(75,139), X(11,75), X(43,107), X(107,171),
  X(43,107), X(11,43), X(75,107), X(139,171), X(27,91), X(91,155), X(27,91),
  X(59,123), X(123,187), X(59,123), X(27,59), X(91,123), X(155,187), X(11,27),
  X(43,59), X(75,91), X(107,123), X(139,155), X(171,187), X(11,19), X(27,35),
  X(43,51), X(59,67), X(75,83), X(91,99), X(107,115), X(123,131), X(139,147),
  X(155,163), X(171,179), X(187,195), X(3,11), X(19,27), X(35,43), X(51,59),
  X(67,75), X(83,91), X(99,107), X(115,123), X(131,139), X(147,155), X(163,171),
  X(179,187), X(7,71), X(71,135), X(7,71), X(39,103), X(103,167), X(39,103),
  X(7,39), X(71,103), X(135,167), X(23,87), X(87,151), X(23,87), X(55,119),
  X(119,183), X(55,119), X(23,55), X(87,119), X(151,183), X(7,23), X(39,55),
  X(71,87), X(103,119), X(135,151), X(167,183), X(15,79), X(79,143), X(15,79),
  X(47,111), X(111,175), X(47,111), X(15,47), X(79,111), X(143,175), X(31,95),
  X(95,159), X(31,95), X(63,127), X(127,191), X(63,127), X(31,63), X(95,127),
  X(159,191), X(15,31), X(47,63), X(79,95), X(111,127), X(143,159), X(175,191),
  X(7,15), X(23,31), X(39,47), X(55,63), X(71,79), X(87,95), X(103,111),
  X(119,127), X(135,143), X(151,159), X(167,175), X(183,191), X(7,11), X(15,19),
  X(23,27), X(31,35), X(39,43), X(47,51), X(55,59), X(63,67), X(71,75), X(79,83),
  X(87,91), X(95,99), X(103,107), X(111,115), X(119,123), X(127,131), X(135,139),
  X(143,147), X(151,155), X(159,163), X(167,171), X(175,179), X(183,187),
  X(191,195), X(3,7), X(11,15), X(19,23), X(27,31), X(35,39), X(43,47), X(51,55),
  X(59,63), X(67,71), X(75,79), X(83,87), X(91,95), X(99,103), X(107,111),
  X(115,119), X(123,127), X(131,135), X(139,143), X(147,151), X(155,159),
  X(163,167), X(171,175), X(179,183), X(187,191), X(3,5), X(7,9), X(11,13),
  X(15,17), X(19,21), X(23,25), X(27,29), X(31,33), X(35,37), X(39,41), X(43,45),
  X(47,49), X(51,53), X(55,57), X(59,61), X(63,65), X(67,69), X(71,73), X(75,77),
  X(79,81), X(83,85), X(87,89), X(91,93), X(95,97), X(99,101), X(103,105),
  X(107,109), X(111,113), X(115,117), X(119,121), X(123,125), X(127,129),
  X(131,133), X(135,137), X(139,141), X(143,145), X(147,149), X(151,153),
  X(155,157), X(159,161), X(163,165), X(167,169), X(171,173), X(175,177),
  X(179,181), X(183,185), X(187,189), X(191,193), X(195,197), X(1,3), X(5,7),
  X(9,11), X(13,15), X(17,19), X(21,23), X(25,27), X(29,31), X(33,35), X(37,39),
  X(41,43), X(45,47), X(49,51), X(53,55), X(57,59), X(61,63), X(65,67), X(69,71),
  X(73,75), X(77,79), X(81,83), X(85,87), X(89,91), X(93,95), X(97,99),
  X(101,103), X(105,107), X(109,111), X(113,115), X(117,119), X(121,123),
  X(125,127), X(129,131), X(133,135), X(137,139), X(141,143), X(145,147),
  X(149,151), X(153,155), X(157,159), X(161,163), X(165,167), X(169,171),
  X(173,175), X(177,179), X(181,183), X(185,187), X(189,191), X(193,195),
  X(2,130), X(66,194), X(2,66), X(130,194), X(34,98), X(98,162), X(34,98),
  X(34,66), X(98,130), X(162,194), X(2,34), X(66,98), X(130,162), X(18,82),
  X(82,146), X(18,82), X(50,114), X(114,178), X(50,114), X(18,50), X(82,114),
  X(146,178), X(18,34), X(50,66), X(82,98), X(114,130), X(146,162), X(178,194),
  X(2,18), X(34,50), X(66,82), X(98,114), X(130,146), X(162,178), X(10,74),
  X(74,138), X(10,74), X(42,106), X(106,170), X(42,106), X(10,42), X(74,106),
  X(138,170), X(26,90), X(90,154), X(26,90), X(58,122), X(122,186), X(58,122),
  X(26,58), X(90,122), X(154,186), X(10,26), X(42,58), X(74,90), X(106,122),
  X(138,154), X(170,186), X(10,18), X(26,34), X(42,50), X(58,66), X(74,82),
  X(90,98), X(106,114), X(122,130), X(138,146), X(154,162), X(170,178),
  X(186,194), X(2,10), X(18,26), X(34,42), X(50,58), X(66,74), X(82,90),
  X(98,106), X(114,122), X(130,138), X(146,154), X(162,170), X(178,186),
  X(6,134), X(70,198), X(6,70), X(134,198), X(38,102), X(102,166), X(38,102),
  X(38,70), X(102,134), X(166,198), X(6,38), X(70,102), X(134,166), X(22,86),
  X(86,150), X(22,86), X(54,118), X(118,182), X(54,118), X(22,54), X(86,118),
  X(150,182), X(22,38), X(54,70), X(86,102), X(118,134), X(150,166), X(182,198),
  X(6,22), X(38,54), X(70,86), X(102,118), X(134,150), X(166,182), X(14,78),
  X(78,142), X(14,78), X(46,110), X(110,174), X(46,110), X(14,46), X(78,110),
  X(142,174), X(30,94), X(94,158), X(30,94), X(62,126), X(126,190), X(62,126),
  X(30,62), X(94,126), X(158,190), X(14,30), X(46,62), X(78,94), X(110,126),
  X(142,158), X(174,190), X(14,22), X(30,38), X(46,54), X(62,70), X(78,86),
  X(94,102), X(110,118), X(126,134), X(142,150), X(158,166), X(174,182),
  X(190,198), X(6,14), X(22,30), X(38,46), X(54,62), X(70,78), X(86,94),
  X(102,110), X(118,126), X(134,142), X(150,158), X(166,174), X(182,190), X(2,6),
  X(10,14), X(18,22), X(26,30), X(34,38), X(42,46), X(50,54), X(58,62), X(66,70),
  X(74,78), X(82,86), X(90,94), X(98,102), X(106,110), X(114,118), X(122,126),
  X(130,134), X(138,142), X(146,150), X(154,158), X(162,166), X(170,174),
  X(178,182), X(186,190), X(194,198), X(4,132), X(68,196), X(4,68), X(132,196),
  X(36,100), X(100,164), X(36,100), X(36,68), X(100,132), X(164,196), X(4,36),
  X(68,100), X(132,164), X(20,84), X(84,148), X(20,84), X(52,116), X(116,180),
  X(52,116), X(20,52), X(84,116), X(148,180), X(20,36), X(52,68), X(84,100),
  X(116,132), X(148,164), X(180,196), X(4,20), X(36,52), X(68,84), X(100,116),
  X(132,148), X(164,180), X(12,76), X(76,140), X(12,76), X(44,108), X(108,172),
  X(44,108), X(12,44), X(76,108), X(140,172), X(28,92), X(92,156), X(28,92),
  X(60,124), X(124,188), X(60,124), X(28,60), X(92,124), X(156,188), X(12,28),
  X(44,60), X(76,92), X(108,124), X(140,156), X(172,188), X(12,20), X(28,36),
  X(44,52), X(60,68), X(76,84), X(92,100), X(108,116), X(124,132), X(140,148),
  X(156,164), X(172,180), X(188,196), X(4,12), X(20,28), X(36,44), X(52,60),
  X(68,76), X(84,92), X(100,108), X(116,124), X(132,140), X(148,156), X(164,172),
  X(180,188), X(8,72), X(72,136), X(8,72), X(40,104), X(104,168), X(40,104),
  X(8,40), X(72,104), X(136,168), X(24,88), X(88,152), X(24,88), X(56,120),
  X(120,184), X(56,120), X(24,56), X(88,120), X(152,184), X(8,24), X(40,56),
  X(72,88), X(104,120), X(136,152), X(168,184), X(16,80), X(80,144), X(16,80),
  X(48,112), X(112,176), X(48,112), X(16,48), X(80,112), X(144,176), X(32,96),
  X(96,160), X(32,96), X(64,128), X(128,192), X(64,128), X(32,64), X(96,128),
  X(160,192), X(16,32), X(48,64), X(80,96), X(112,128), X(144,160), X(176,192),
  X(8,16), X(24,32), X(40,48), X(56,64), X(72,80), X(88,96), X(104,112),
  X(120,128), X(136,144), X(152,160), X(168,176), X(184,192), X(8,12), X(16,20),
  X(24,28), X(32,36), X(40,44), X(48,52), X(56,60), X(64,68), X(72,76), X(80,84),
  X(88,92), X(96,100), X(104,108), X(112,116), X(120,124), X(128,132),
  X(136,140), X(144,148), X(152,156), X(160,164), X(168,172), X(176,180),
  X(184,188), X(192,196), X(4,8), X(12,16), X(20,24), X(28,32), X(36,40),
  X(44,48), X(52,56), X(60,64), X(68,72), X(76,80), X(84,88), X(92,96),
  X(100,104), X(108,112), X(116,120), X(124,128), X(132,136), X(140,144),
  X(148,152), X(156,160), X(164,168), X(172,176), X(180,184), X(188,192), X(4,6),
  X(8,10), X(12,14), X(16,18), X(20,22), X(24,26), X(28,30), X(32,34), X(36,38),
  X(40,42), X(44,46), X(48,50), X(52,54), X(56,58), X(60,62), X(64,66), X(68,70),
  X(72,74), X(76,78), X(80,82), X(84,86), X(88,90), X(92,94), X(96,98),
  X(100,102), X(104,106), X(108,110), X(112,114), X(116,118), X(120,122),
  X(124,126), X(128,130), X(132,134), X(136,138), X(140,142), X(144,146),
  X(148,150), X(152,154), X(156,158), X(160,162), X(164,166), X(168,170),
  X(172,174), X(176,178), X(180,182), X(184,186), X(188,190), X(192,194),
  X(196,198), X(2,4), X(6,8), X(10,12), X(14,16), X(18,20), X(22,24), X(26,28),
  X(30,32), X(34,36), X(38,40), X(42,44), X(46,48), X(50,52), X(54,56), X(58,60),
  X(62,64), X(66,68), X(70,72), X(74,76), X(78,80), X(82,84), X(86,88), X(90,92),
  X(94,96), X(98,100), X(102,104), X(106,108), X(110,112), X(114,116),
  X(118,120), X(122,124), X(126,128), X(130,132), X(134,136), X(138,140),
  X(142,144), X(146,148), X(150,152), X(154,156), X(158,160), X(162,164),
  X(166,168), X(170,172), X(174,176), X(178,180), X(182,184), X(186,188),
  X(190,192), X(194,196), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162), X(163,164), X(165,166),
  X(167,168), X(169,170), X(171,172), X(173,174), X(175,176), X(177,178),
  X(179,180), X(181,182), X(183,184), X(185,186), X(187,188), X(189,190),
  X(191,192), X(193,194), X(195,196), X(197,198)
};
M(199) = {
  X(1,129), X(65,193), X(1,65), X(129,193), X(33,97), X(97,161), X(33,97),
  X(33,65), X(97,129), X(161,193), X(1,33), X(65,97), X(129,161), X(17,81),
  X(81,145), X(17,81), X(49,113), X(113,177), X(49,113), X(17,49), X(81,113),
  X(145,177), X(17,33), X(49,65), X(81,97), X(113,129), X(145,161), X(177,193),
  X(1,17), X(33,49), X(65,81), X(97,113), X(129,145), X(161,177), X(9,73),
  X(73,137), X(9,73), X(41,105), X(105,169), X(41,105), X(9,41), X(73,105),
  X(137,169), X(25,89), X(89,153), X(25,89), X(57,121), X(121,185), X(57,121),
  X(25,57), X(89,121), X(153,185), X(9,25), X(41,57), X(73,89), X(105,121),
  X(137,153), X(169,185), X(9,17), X(25,33), X(41,49), X(57,65), X(73,81),
  X(89,97), X(105,113), X(121,129), X(137,145), X(153,161), X(169,177),
  X(185,193), X(1,9), X(17,25), X(33,41), X(49,57), X(65,73), X(81,89),
  X(97,105), X(113,121), X(129,137), X(145,153), X(161,169), X(177,185),
  X(5,133), X(69,197), X(5,69), X(133,197), X(37,101), X(101,165), X(37,101),
  X(37,69), X(101,133), X(165,197), X(5,37), X(69,101), X(133,165), X(21,85),
  X(85,149), X(21,85), X(53,117), X(117,181), X(53,117), X(21,53), X(85,117),
  X(149,181), X(21,37), X(53,69), X(85,101), X(117,133), X(149,165), X(181,197),
  X(5,21), X(37,53), X(69,85), X(101,117), X(133,149), X(165,181), X(13,77),
  X(77,141), X(13,77), X(45,109), X(109,173), X(45,109), X(13,45), X(77,109),
  X(141,173), X(29,93), X(93,157), X(29,93), X(61,125), X(125,189), X(61,125),
  X(29,61), X(93,125), X(157,189), X(1