
#line 1 "hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb.hh"


#line 36 "hb-ot-shape-complex-indic-machine.hh"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	8u, 8u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 
	4u, 13u, 4u, 8u, 4u, 13u, 8u, 8u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 
	4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 8u, 8u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 
	5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 
	4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 
	8u, 8u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 
	4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 
	16u, 16u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 4u, 13u, 4u, 8u, 
	4u, 13u, 4u, 8u, 4u, 13u, 4u, 13u, 5u, 8u, 5u, 8u, 5u, 7u, 5u, 8u, 
	5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 
	8u, 8u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 
	6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 8u, 8u, 1u, 19u, 3u, 17u, 
	3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 
	3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 
	3u, 17u, 4u, 17u, 5u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 
	5u, 10u, 3u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 
	3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 
	3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 
	1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 
	1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 
	3u, 17u, 3u, 17u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 
	4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 
	4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 10u, 5u, 10u, 5u, 10u, 
	10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 
	3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 
	5u, 10u, 3u, 10u, 4u, 10u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 
	3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 4u, 8u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 10u, 
	5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 3u, 10u, 3u, 10u, 
	4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 
	3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 3u, 17u, 3u, 17u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 
	3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 13u, 3u, 17u, 4u, 8u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 
	3u, 17u, 3u, 17u, 4u, 17u, 5u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 
	10u, 10u, 5u, 10u, 3u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 
	5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 
	4u, 10u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 
	3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 
	1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 
	1u, 16u, 3u, 17u, 1u, 17u, 3u, 17u, 1u, 17u, 4u, 13u, 5u, 10u, 10u, 10u, 
	10u, 10u, 10u, 10u, 5u, 10u, 1u, 16u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 
	4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 3u, 10u, 4u, 10u, 5u, 10u, 
	3u, 10u, 5u, 10u, 5u, 10u, 10u, 10u, 10u, 10u, 10u, 10u, 5u, 10u, 1u, 16u, 
	0
};

static const char _indic_syllable_machine_key_spans[] = {
	1, 4, 3, 1, 4, 3, 1, 4, 
	3, 1, 4, 3, 1, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 5, 10, 5, 10, 5, 10, 5, 
	10, 5, 10, 1, 4, 3, 1, 4, 
	3, 1, 4, 3, 1, 4, 3, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 5, 1, 1, 5, 10, 5, 10, 
	5, 10, 5, 10, 5, 10, 1, 4, 
	3, 1, 4, 3, 1, 4, 3, 1, 
	4, 3, 1, 5, 1, 1, 5, 1, 
	1, 5, 1, 1, 5, 1, 1, 5, 
	10, 5, 10, 5, 10, 5, 10, 5, 
	1, 4, 3, 1, 4, 3, 1, 4, 
	3, 1, 4, 3, 1, 5, 1, 1, 
	5, 1, 1, 5, 1, 1, 5, 1, 
	1, 5, 10, 5, 10, 5, 10, 5, 
	10, 5, 10, 10, 4, 4, 3, 4, 
	3, 1, 4, 3, 1, 4, 3, 1, 
	1, 5, 1, 1, 5, 1, 1, 5, 
	1, 1, 5, 1, 1, 1, 19, 15, 
	15, 14, 16, 15, 15, 14, 16, 15, 
	15, 14, 16, 15, 15, 14, 16, 15, 
	15, 14, 6, 6, 6, 1, 1, 1, 
	6, 8, 8, 7, 6, 8, 7, 6, 
	8, 7, 6, 8, 7, 6, 8, 7, 
	15, 15, 16, 16, 16, 16, 15, 15, 
	16, 16, 16, 16, 15, 15, 16, 16, 
	16, 16, 15, 15, 16, 16, 16, 16, 
	15, 15, 15, 15, 14, 16, 15, 15, 
	14, 16, 15, 15, 14, 16, 15, 15, 
	14, 16, 15, 15, 14, 6, 6, 6, 
	1, 1, 1, 6, 8, 8, 7, 6, 
	8, 7, 6, 8, 7, 6, 8, 7, 
	6, 8, 7, 15, 15, 16, 16, 16, 
	16, 15, 15, 16, 16, 16, 16, 15, 
	15, 16, 16, 16, 16, 15, 15, 16, 
	16, 16, 16, 5, 15, 15, 14, 16, 
	15, 15, 14, 16, 15, 15, 14, 16, 
	15, 15, 14, 16, 15, 15, 14, 6, 
	6, 6, 1, 1, 1, 6, 8, 8, 
	7, 6, 8, 7, 6, 8, 7, 6, 
	8, 7, 6, 8, 7, 15, 15, 16, 
	16, 16, 16, 15, 15, 16, 16, 16, 
	16, 15, 15, 16, 16, 16, 16, 15, 
	15, 16, 16, 16, 16, 10, 15, 5, 
	15, 15, 14, 16, 15, 15, 14, 16, 
	15, 15, 14, 16, 15, 15, 14, 16, 
	15, 15, 14, 6, 6, 6, 1, 1, 
	1, 6, 8, 8, 7, 6, 8, 7, 
	6, 8, 7, 6, 8, 7, 6, 8, 
	7, 15, 15, 16, 16, 16, 16, 15, 
	15, 16, 16, 16, 16, 15, 15, 16, 
	16, 16, 16, 15, 15, 16, 16, 16, 
	16, 15, 17, 15, 17, 10, 6, 1, 
	1, 1, 6, 16, 8, 7, 6, 8, 
	7, 6, 8, 7, 6, 8, 7, 6, 
	8, 6, 6, 1, 1, 1, 6, 16
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 2, 7, 11, 13, 18, 22, 24, 
	29, 33, 35, 40, 44, 46, 52, 54, 
	56, 62, 64, 66, 72, 74, 76, 82, 
	84, 86, 92, 103, 109, 120, 126, 137, 
	143, 154, 160, 171, 173, 178, 182, 184, 
	189, 193, 195, 200, 204, 206, 211, 215, 
	217, 223, 225, 227, 233, 235, 237, 243, 
	245, 247, 253, 255, 257, 263, 274, 280, 
	291, 297, 308, 314, 325, 331, 342, 344, 
	349, 353, 355, 360, 364, 366, 371, 375, 
	377, 382, 386, 388, 394, 396, 398, 404, 
	406, 408, 414, 416, 418, 424, 426, 428, 
	434, 445, 451, 462, 468, 479, 485, 496, 
	502, 504, 509, 513, 515, 520, 524, 526, 
	531, 535, 537, 542, 546, 548, 554, 556, 
	558, 564, 566, 568, 574, 576, 578, 584, 
	586, 588, 594, 605, 611, 622, 628, 639, 
	645, 656, 662, 673, 684, 689, 694, 698, 
	703, 707, 709, 714, 718, 720, 725, 729, 
	731, 733, 739, 741, 743, 749, 751, 753, 
	759, 761, 763, 769, 771, 773, 775, 795, 
	811, 827, 842, 859, 875, 891, 906, 923, 
	939, 955, 970, 987, 1003, 1019, 1034, 1051, 
	1067, 1083, 1098, 1105, 1112, 1119, 1121, 1123, 
	1125, 1132, 1141, 1150, 1158, 1165, 1174, 1182, 
	1189, 1198, 1206, 1213, 1222, 1230, 1237, 1246, 
	1254, 1270, 1286, 1303, 1320, 1337, 1354, 1370, 
	1386, 1403, 1420, 1437, 1454, 1470, 1486, 1503, 
	1520, 1537, 1554, 1570, 1586, 1603, 1620, 1637, 
	1654, 1670, 1686, 1702, 1718, 1733, 1750, 1766, 
	1782, 1797, 1814, 1830, 1846, 1861, 1878, 1894, 
	1910, 1925, 1942, 1958, 1974, 1989, 1996, 2003, 
	2010, 2012, 2014, 2016, 2023, 2032, 2041, 2049, 
	2056, 2065, 2073, 2080, 2089, 2097, 2104, 2113, 
	2121, 2128, 2137, 2145, 2161, 2177, 2194, 2211, 
	2228, 2245, 2261, 2277, 2294, 2311, 2328, 2345, 
	2361, 2377, 2394, 2411, 2428, 2445, 2461, 2477, 
	2494, 2511, 2528, 2545, 2551, 2567, 2583, 2598, 
	2615, 2631, 2647, 2662, 2679, 2695, 2711, 2726, 
	2743, 2759, 2775, 2790, 2807, 2823, 2839, 2854, 
	2861, 2868, 2875, 2877, 2879, 2881, 2888, 2897, 
	2906, 2914, 2921, 2930, 2938, 2945, 2954, 2962, 
	2969, 2978, 2986, 2993, 3002, 3010, 3026, 3042, 
	3059, 3076, 3093, 3110, 3126, 3142, 3159, 3176, 
	3193, 3210, 3226, 3242, 3259, 3276, 3293, 3310, 
	3326, 3342, 3359, 3376, 3393, 3410, 3421, 3437, 
	3443, 3459, 3475, 3490, 3507, 3523, 3539, 3554, 
	3571, 3587, 3603, 3618, 3635, 3651, 3667, 3682, 
	3699, 3715, 3731, 3746, 3753, 3760, 3767, 3769, 
	3771, 3773, 3780, 3789, 3798, 3806, 3813, 3822, 
	3830, 3837, 3846, 3854, 3861, 3870, 3878, 3885, 
	3894, 3902, 3918, 3934, 3951, 3968, 3985, 4002, 
	4018, 4034, 4051, 4068, 4085, 4102, 4118, 4134, 
	4151, 4168, 4185, 4202, 4218, 4234, 4251, 4268, 
	4285, 4302, 4318, 4336, 4352, 4370, 4381, 4388, 
	4390, 4392, 4394, 4401, 4418, 4427, 4435, 4442, 
	4451, 4459, 4466, 4475, 4483, 4490, 4499, 4507, 
	4514, 4523, 4530, 4537, 4539, 4541, 4543, 4550
};

static const short _indic_syllable_machine_indicies[] = {
	1, 0, 2, 2, 3, 1, 0, 4, 
	4, 3, 0, 3, 0, 5, 5, 6, 
	1, 0, 7, 7, 6, 0, 6, 0, 
	8, 8, 9, 1, 0, 10, 10, 9, 
	0, 9, 0, 11, 11, 12, 1, 0, 
	13, 13, 12, 0, 12, 0, 14, 0, 
	0, 0, 1, 0, 15, 0, 16, 0, 
	17, 11, 11, 12, 1, 0, 18, 0, 
	19, 0, 20, 8, 8, 9, 1, 0, 
	21, 0, 22, 0, 23, 5, 5, 6, 
	1, 0, 24, 0, 25, 0, 26, 2, 
	2, 3, 1, 0, 26, 2, 2, 3, 
	1, 0, 0, 0, 0, 27, 0, 28, 
	2, 2, 3, 1, 0, 28, 2, 2, 
	3, 1, 0, 0, 0, 0, 29, 0, 
	30, 2, 2, 3, 1, 0, 30, 2, 
	2, 3, 1, 0, 0, 0, 0, 31, 
	0, 32, 2, 2, 3, 1, 0, 32, 
	2, 2, 3, 1, 0, 0, 0, 0, 
	33, 0, 34, 2, 2, 3, 1, 0, 
	34, 2, 2, 3, 1, 0, 0, 0, 
	0, 35, 0, 37, 36, 38, 38, 39, 
	37, 36, 40, 40, 39, 36, 39, 36, 
	41, 41, 42, 37, 36, 43, 43, 42, 
	36, 42, 36, 44, 44, 45, 37, 36, 
	46, 46, 45, 36, 45, 36, 47, 47, 
	48, 37, 36, 49, 49, 48, 36, 48, 
	36, 50, 36, 36, 36, 37, 36, 51, 
	36, 52, 36, 53, 47, 47, 48, 37, 
	36, 54, 36, 55, 36, 56, 44, 44, 
	45, 37, 36, 57, 36, 58, 36, 59, 
	41, 41, 42, 37, 36, 60, 36, 61, 
	36, 62, 38, 38, 39, 37, 36, 62, 
	38, 38, 39, 37, 36, 36, 36, 36, 
	63, 36, 64, 38, 38, 39, 37, 36, 
	64, 38, 38, 39, 37, 36, 36, 36, 
	36, 65, 36, 66, 38, 38, 39, 37, 
	36, 66, 38, 38, 39, 37, 36, 36, 
	36, 36, 67, 36, 68, 38, 38, 39, 
	37, 36, 68, 38, 38, 39, 37, 36, 
	36, 36, 36, 69, 36, 70, 38, 38, 
	39, 37, 36, 70, 38, 38, 39, 37, 
	36, 36, 36, 36, 71, 36, 73, 72, 
	74, 74, 75, 73, 72, 77, 77, 75, 
	76, 75, 76, 78, 78, 79, 73, 72, 
	80, 80, 79, 72, 79, 72, 81, 81, 
	82, 73, 72, 83, 83, 82, 72, 82, 
	72, 84, 84, 85, 73, 72, 86, 86, 
	85, 72, 85, 72, 87, 72, 72, 72, 
	73, 72, 88, 72, 89, 72, 90, 84, 
	84, 85, 73, 72, 91, 72, 92, 72, 
	93, 81, 81, 82, 73, 72, 94, 72, 
	95, 72, 96, 78, 78, 79, 73, 72, 
	97, 72, 98, 72, 99, 74, 74, 75, 
	73, 72, 99, 74, 74, 75, 73, 72, 
	72, 72, 72, 100, 72, 101, 74, 74, 
	75, 73, 72, 101, 74, 74, 75, 73, 
	72, 72, 72, 72, 102, 72, 103, 74, 
	74, 75, 73, 72, 103, 74, 74, 75, 
	73, 72, 72, 72, 72, 104, 72, 105, 
	74, 74, 75, 73, 72, 105, 74, 74, 
	75, 73, 72, 72, 72, 72, 106, 72, 
	107, 74, 74, 75, 73, 72, 109, 108, 
	110, 110, 111, 109, 108, 112, 112, 111, 
	108, 111, 108, 113, 113, 114, 109, 108, 
	115, 115, 114, 108, 114, 108, 116, 116, 
	117, 109, 108, 118, 118, 117, 108, 117, 
	108, 119, 119, 120, 109, 108, 121, 121, 
	120, 108, 120, 108, 122, 108, 108, 108, 
	109, 108, 123, 108, 124, 108, 125, 119, 
	119, 120, 109, 108, 126, 108, 127, 108, 
	128, 116, 116, 117, 109, 108, 129, 108, 
	130, 108, 131, 113, 113, 114, 109, 108, 
	132, 108, 133, 108, 134, 110, 110, 111, 
	109, 108, 134, 110, 110, 111, 109, 108, 
	108, 108, 108, 135, 108, 136, 110, 110, 
	111, 109, 108, 136, 110, 110, 111, 109, 
	108, 108, 108, 108, 137, 108, 138, 110, 
	110, 111, 109, 108, 138, 110, 110, 111, 
	109, 108, 108, 108, 108, 139, 108, 140, 
	110, 110, 111, 109, 108, 140, 110, 110, 
	111, 109, 108, 108, 108, 108, 141, 108, 
	142, 110, 110, 111, 109, 108, 142, 110, 
	110, 111, 109, 108, 108, 108, 108, 143, 
	108, 107, 74, 74, 75, 73, 72, 72, 
	72, 72, 144, 72, 77, 77, 75, 1, 
	0, 145, 145, 146, 1, 0, 4, 4, 
	146, 0, 147, 147, 148, 149, 0, 150, 
	150, 148, 0, 148, 0, 151, 151, 152, 
	149, 0, 153, 153, 152, 0, 152, 0, 
	154, 154, 155, 149, 0, 156, 156, 155, 
	0, 155, 0, 149, 0, 157, 0, 0, 
	0, 149, 0, 158, 0, 159, 0, 160, 
	154, 154, 155, 149, 0, 161, 0, 162, 
	0, 163, 151, 151, 152, 149, 0, 164, 
	0, 165, 0, 166, 147, 147, 148, 149, 
	0, 167, 0, 168, 0, 170, 169, 172, 
	173, 174, 175, 176, 177, 75, 73, 171, 
	178, 179, 179, 144, 171, 180, 181, 182, 
	183, 184, 171, 186, 187, 188, 189, 3, 
	1, 185, 190, 185, 185, 35, 185, 185, 
	185, 191, 185, 192, 187, 193, 193, 3, 
	1, 185, 190, 185, 185, 185, 185, 185, 
	185, 191, 185, 187, 193, 193, 3, 1, 
	185, 190, 185, 185, 185, 185, 185, 185, 
	191, 185, 194, 185, 185, 185, 16, 195, 
	185, 1, 185, 190, 185, 185, 185, 185, 
	185, 194, 185, 196, 197, 198, 199, 3, 
	1, 185, 190, 185, 185, 33, 185, 185, 
	185, 191, 185, 200, 197, 201, 201, 3, 
	1, 185, 190, 185, 185, 185, 185, 185, 
	185, 191, 185, 197, 201, 201, 3, 1, 
	185, 190, 185, 185, 185, 185, 185, 185, 
	191, 185, 202, 185, 185, 185, 16, 203, 
	185, 1, 185, 190, 185, 185, 185, 185, 
	185, 202, 185, 204, 205, 206, 207, 3, 
	1, 185, 190, 185, 185, 31, 185, 185, 
	185, 191, 185, 208, 205, 209, 209, 3, 
	1, 185, 190, 185, 185, 185, 185, 185, 
	185, 191, 185, 205, 209, 209, 3, 1, 
	185, 190, 185, 185, 185, 185, 185, 185, 
	191, 185, 210, 185, 185, 185, 16, 211, 
	185, 1, 185, 190, 185, 185, 185, 185, 
	185, 210, 185, 212, 213, 214, 215, 3, 
	1, 185, 190, 185, 185, 29, 185, 185, 
	185, 191, 185, 216, 213, 217, 217, 3, 
	1, 185, 190, 185, 185, 185, 185, 185, 
	185, 191, 185, 213, 217, 217, 3, 1, 
	185, 190, 185, 185, 185, 185, 185, 185, 
	191, 185, 218, 185, 185, 185, 16, 219, 
	185, 1, 185, 190, 185, 185, 185, 185, 
	185, 218, 185, 220, 221, 222, 223, 3, 
	1, 185, 190, 185, 185, 27, 185, 185, 
	185, 191, 185, 224, 221, 225, 225, 3, 
	1, 185, 190, 185, 185, 185, 185, 185, 
	185, 191, 185, 221, 225, 225, 3, 1, 
	185, 190, 185, 185, 185, 185, 185, 185, 
	191, 185, 16, 226, 185, 1, 185, 190, 
	185, 227, 227, 185, 1, 185, 190, 185, 
	228, 185, 185, 229, 185, 190, 185, 190, 
	185, 230, 185, 231, 185, 228, 185, 185, 
	185, 185, 190, 185, 16, 185, 232, 232, 
	3, 1, 185, 190, 185, 233, 25, 234, 
	235, 6, 1, 185, 190, 185, 25, 234, 
	235, 6, 1, 185, 190, 185, 234, 234, 
	6, 1, 185, 190, 185, 236, 22, 237, 
	238, 9, 1, 185, 190, 185, 22, 237, 
	238, 9, 1, 185, 190, 185, 237, 237, 
	9, 1, 185, 190, 185, 239, 19, 240, 
	241, 12, 1, 185, 190, 185, 19, 240, 
	241, 12, 1, 185, 190, 185, 240, 240, 
	12, 1, 185, 190, 185, 242, 16, 227, 
	243, 185, 1, 185, 190, 185, 16, 227, 
	243, 185, 1, 185, 190, 185, 227, 244, 
	185, 1, 185, 190, 185, 16, 185, 227, 
	227, 185, 1, 185, 190, 185, 221, 225, 
	225, 3, 1, 185, 190, 185, 220, 221, 
	225, 225, 3, 1, 185, 190, 185, 185, 
	185, 185, 185, 185, 191, 185, 220, 221, 
	222, 225, 3, 1, 185, 190, 185, 185, 
	27, 185, 185, 185, 191, 185, 218, 185, 
	245, 185, 232, 232, 3, 1, 185, 190, 
	185, 185, 185, 185, 185, 218, 185, 218, 
	185, 185, 185, 227, 227, 185, 1, 185, 
	190, 185, 185, 185, 185, 185, 218, 185, 
	218, 185, 185, 185, 227, 246, 185, 1, 
	185, 190, 185, 185, 185, 185, 185, 218, 
	185, 218, 185, 245, 185, 227, 227, 185, 
	1, 185, 190, 185, 185, 185, 185, 185, 
	218, 185, 212, 213, 217, 217, 3, 1, 
	185, 190, 185, 185, 185, 185, 185, 185, 
	191, 185, 212, 213, 214, 217, 3, 1, 
	185, 190, 185, 185, 29, 185, 185, 185, 
	191, 185, 210, 185, 247, 185, 232, 232, 
	3, 1, 185, 190, 185, 185, 185, 185, 
	185, 210, 185, 210, 185, 185, 185, 227, 
	227, 185, 1, 185, 190, 185, 185, 185, 
	185, 185, 210, 185, 210, 185, 185, 185, 
	227, 248, 185, 1, 185, 190, 185, 185, 
	185, 185, 185, 210, 185, 210, 185, 247, 
	185, 227, 227, 185, 1, 185, 190, 185, 
	185, 185, 185, 185, 210, 185, 204, 205, 
	209, 209, 3, 1, 185, 190, 185, 185, 
	185, 185, 185, 185, 191, 185, 204, 205, 
	206, 209, 3, 1, 185, 190, 185, 185, 
	31, 185, 185, 185, 191, 185, 202, 185, 
	249, 185, 232, 232, 3, 1, 185, 190, 
	185, 185, 185, 185, 185, 202, 185, 202, 
	185, 185, 185, 227, 227, 185, 1, 185, 
	190, 185, 185, 185, 185, 185, 202, 185, 
	202, 185, 185, 185, 227, 250, 185, 1, 
	185, 190, 185, 185, 185, 185, 185, 202, 
	185, 202, 185, 249, 185, 227, 227, 185, 
	1, 185, 190, 185, 185, 185, 185, 185, 
	202, 185, 196, 197, 201, 201, 3, 1, 
	185, 190, 185, 185, 185, 185, 185, 185, 
	191, 185, 196, 197, 198, 201, 3, 1, 
	185, 190, 185, 185, 33, 185, 185, 185, 
	191, 185, 194, 185, 251, 185, 232, 232, 
	3, 1, 185, 190, 185, 185, 185, 185, 
	185, 194, 185, 194, 185, 185, 185, 227, 
	227, 185, 1, 185, 190, 185, 185, 185, 
	185, 185, 194, 185, 194, 185, 185, 185, 
	227, 252, 185, 1, 185, 190, 185, 185, 
	185, 185, 185, 194, 185, 194, 185, 251, 
	185, 227, 227, 185, 1, 185, 190, 185, 
	185, 185, 185, 185, 194, 185, 186, 187, 
	193, 193, 3, 1, 185, 190, 185, 185, 
	185, 185, 185, 185, 191, 185, 186, 187, 
	188, 193, 3, 1, 185, 190, 185, 185, 
	35, 185, 185, 185, 191, 185, 254, 255, 
	256, 257, 39, 37, 253, 258, 253, 253, 
	71, 253, 253, 253, 259, 253, 260, 255, 
	261, 257, 39, 37, 253, 258, 253, 253, 
	253, 253, 253, 253, 259, 253, 255, 261, 
	257, 39, 37, 253, 258, 253, 253, 253, 
	253, 253, 253, 259, 253, 262, 253, 253, 
	253, 52, 263, 253, 37, 253, 258, 253, 
	253, 253, 253, 253, 262, 253, 264, 265, 
	266, 267, 39, 37, 253, 258, 253, 253, 
	69, 253, 253, 253, 259, 253, 268, 265, 
	269, 269, 39, 37, 253, 258, 253, 253, 
	253, 253, 253, 253, 259, 253, 265, 269, 
	269, 39, 37, 253, 258, 253, 253, 253, 
	253, 253, 253, 259, 253, 270, 253, 253, 
	253, 52, 271, 253, 37, 253, 258, 253, 
	253, 253, 253, 253, 270, 253, 272, 273, 
	274, 275, 39, 37, 253, 258, 253, 253, 
	67, 253, 253, 253, 259, 253, 276, 273, 
	277, 277, 39, 37, 253, 258, 253, 253, 
	253, 253, 253, 253, 259, 253, 273, 277, 
	277, 39, 37, 253, 258, 253, 253, 253, 
	253, 253, 253, 259, 253, 278, 253, 253, 
	253, 52, 279, 253, 37, 253, 258, 253, 
	253, 253, 253, 253, 278, 253, 280, 281, 
	282, 283, 39, 37, 253, 258, 253, 253, 
	65, 253, 253, 253, 259, 253, 284, 281, 
	285, 285, 39, 37, 253, 258, 253, 253, 
	253, 253, 253, 253, 259, 253, 281, 285, 
	285, 39, 37, 253, 258, 253, 253, 253, 
	253, 253, 253, 259, 253, 286, 253, 253, 
	253, 52, 287, 253, 37, 253, 258, 253, 
	253, 253, 253, 253, 286, 253, 288, 289, 
	290, 291, 39, 37, 253, 258, 253, 253, 
	63, 253, 253, 253, 259, 253, 292, 289, 
	293, 293, 39, 37, 253, 258, 253, 253, 
	253, 253, 253, 253, 259, 253, 289, 293, 
	293, 39, 37, 253, 258, 253, 253, 253, 
	253, 253, 253, 259, 253, 52, 294, 253, 
	37, 253, 258, 253, 295, 295, 253, 37, 
	253, 258, 253, 296, 253, 253, 297, 253, 
	258, 253, 258, 253, 298, 253, 299, 253, 
	296, 253, 253, 253, 253, 258, 253, 52, 
	253, 300, 300, 39, 37, 253, 258, 253, 
	301, 61, 302, 303, 42, 37, 253, 258, 
	253, 61, 302, 303, 42, 37, 253, 258, 
	253, 302, 302, 42, 37, 253, 258, 253, 
	304, 58, 305, 306, 45, 37, 253, 258, 
	253, 58, 305, 306, 45, 37, 253, 258, 
	253, 305, 305, 45, 37, 253, 258, 253, 
	307, 55, 308, 309, 48, 37, 253, 258, 
	253, 55, 308, 309, 48, 37, 253, 258, 
	253, 308, 308, 48, 37, 253, 258, 253, 
	310, 52, 295, 311, 253, 37, 253, 258, 
	253, 52, 295, 311, 253, 37, 253, 258, 
	253, 295, 312, 253, 37, 253, 258, 253, 
	52, 253, 295, 295, 253, 37, 253, 258, 
	253, 289, 293, 293, 39, 37, 253, 258, 
	253, 288, 289, 293, 293, 39, 37, 253, 
	258, 253, 253, 253, 253, 253, 253, 259, 
	253, 288, 289, 290, 293, 39, 37, 253, 
	258, 253, 253, 63, 253, 253, 253, 259, 
	253, 286, 253, 313, 253, 300, 300, 39, 
	37, 253, 258, 253, 253, 253, 253, 253, 
	286, 253, 286, 253, 253, 253, 295, 295, 
	253, 37, 253, 258, 253, 253, 253, 253, 
	253, 286, 253, 286, 253, 253, 253, 295, 
	314, 253, 37, 253, 258, 253, 253, 253, 
	253, 253, 286, 253, 286, 253, 313, 253, 
	295, 295, 253, 37, 253, 258, 253, 253, 
	253, 253, 253, 286, 253, 280, 281, 285, 
	285, 39, 37, 253, 258, 253, 253, 253, 
	253, 253, 253, 259, 253, 280, 281, 282, 
	285, 39, 37, 253, 258, 253, 253, 65, 
	253, 253, 253, 259, 253, 278, 253, 315, 
	253, 300, 300, 39, 37, 253, 258, 253, 
	253, 253, 253, 253, 278, 253, 278, 253, 
	253, 253, 295, 295, 253, 37, 253, 258, 
	253, 253, 253, 253, 253, 278, 253, 278, 
	253, 253, 253, 295, 316, 253, 37, 253, 
	258, 253, 253, 253, 253, 253, 278, 253, 
	278, 253, 315, 253, 295, 295, 253, 37, 
	253, 258, 253, 253, 253, 253, 253, 278, 
	253, 272, 273, 277, 277, 39, 37, 253, 
	258, 253, 253, 253, 253, 253, 253, 259, 
	253, 272, 273, 274, 277, 39, 37, 253, 
	258, 253, 253, 67, 253, 253, 253, 259, 
	253, 270, 253, 317, 253, 300, 300, 39, 
	37, 253, 258, 253, 253, 253, 253, 253, 
	270, 253, 270, 253, 253, 253, 295, 295, 
	253, 37, 253, 258, 253, 253, 253, 253, 
	253, 270, 253, 270, 253, 253, 253, 295, 
	318, 253, 37, 253, 258, 253, 253, 253, 
	253, 253, 270, 253, 270, 253, 317, 253, 
	295, 295, 253, 37, 253, 258, 253, 253, 
	253, 253, 253, 270, 253, 264, 265, 269, 
	269, 39, 37, 253, 258, 253, 253, 253, 
	253, 253, 253, 259, 253, 264, 265, 266, 
	269, 39, 37, 253, 258, 253, 253, 69, 
	253, 253, 253, 259, 253, 262, 253, 319, 
	253, 300, 300, 39, 37, 253, 258, 253, 
	253, 253, 253, 253, 262, 253, 262, 253, 
	253, 253, 295, 295, 253, 37, 253, 258, 
	253, 253, 253, 253, 253, 262, 253, 262, 
	253, 253, 253, 295, 320, 253, 37, 253, 
	258, 253, 253, 253, 253, 253, 262, 253, 
	262, 253, 319, 253, 295, 295, 253, 37, 
	253, 258, 253, 253, 253, 253, 253, 262, 
	253, 70, 38, 38, 39, 37, 253, 254, 
	255, 261, 257, 39, 37, 253, 258, 253, 
	253, 253, 253, 253, 253, 259, 253, 322, 
	175, 323, 323, 75, 73, 321, 178, 321, 
	321, 321, 321, 321, 321, 182, 321, 175, 
	323, 323, 75, 73, 321, 178, 321, 321, 
	321, 321, 321, 321, 182, 321, 324, 321, 
	321, 321, 89, 325, 321, 73, 321, 178, 
	321, 321, 321, 321, 321, 324, 321, 326, 
	327, 328, 329, 75, 73, 321, 178, 321, 
	321, 106, 321, 321, 321, 182, 321, 330, 
	327, 331, 331, 75, 73, 321, 178, 321, 
	321, 321, 321, 321, 321, 182, 321, 327, 
	331, 331, 75, 73, 321, 178, 321, 321, 
	321, 321, 321, 321, 182, 321, 332, 321, 
	321, 321, 89, 333, 321, 73, 321, 178, 
	321, 321, 321, 321, 321, 332, 321, 334, 
	335, 336, 337, 75, 73, 321, 178, 321, 
	321, 104, 321, 321, 321, 182, 321, 338, 
	335, 339, 339, 75, 73, 321, 178, 321, 
	321, 321, 321, 321, 321, 182, 321, 335, 
	339, 339, 75, 73, 321, 178, 321, 321, 
	321, 321, 321, 321, 182, 321, 340, 321, 
	321, 321, 89, 341, 321, 73, 321, 178, 
	321, 321, 321, 321, 321, 340, 321, 342, 
	343, 344, 345, 75, 73, 321, 178, 321, 
	321, 102, 321, 321, 321, 182, 321, 346, 
	343, 347, 347, 75, 73, 321, 178, 321, 
	321, 321, 321, 321, 321, 182, 321, 343, 
	347, 347, 75, 73, 321, 178, 321, 321, 
	321, 321, 321, 321, 182, 321, 348, 321, 
	321, 321, 89, 349, 321, 73, 321, 178, 
	321, 321, 321, 321, 321, 348, 321, 350, 
	351, 352, 353, 75, 73, 321, 178, 321, 
	321, 100, 321, 321, 321, 182, 321, 354, 
	351, 355, 355, 75, 73, 321, 178, 321, 
	321, 321, 321, 321, 321, 182, 321, 351, 
	355, 355, 75, 73, 321, 178, 321, 321, 
	321, 321, 321, 321, 182, 321, 89, 356, 
	321, 73, 321, 178, 321, 357, 357, 321, 
	73, 321, 178, 321, 358, 321, 321, 359, 
	321, 178, 321, 178, 321, 360, 321, 361, 
	321, 358, 321, 321, 321, 321, 178, 321, 
	89, 321, 362, 362, 75, 73, 321, 178, 
	321, 363, 98, 364, 365, 79, 73, 321, 
	178, 321, 98, 364, 365, 79, 73, 321, 
	178, 321, 364, 364, 79, 73, 321, 178, 
	321, 366, 95, 367, 368, 82, 73, 321, 
	178, 321, 95, 367, 368, 82, 73, 321, 
	178, 321, 367, 367, 82, 73, 321, 178, 
	321, 369, 92, 370, 371, 85, 73, 321, 
	178, 321, 92, 370, 371, 85, 73, 321, 
	178, 321, 370, 370, 85, 73, 321, 178, 
	321, 372, 89, 357, 373, 321, 73, 321, 
	178, 321, 89, 357, 373, 321, 73, 321, 
	178, 321, 357, 374, 321, 73, 321, 178, 
	321, 89, 321, 357, 357, 321, 73, 321, 
	178, 321, 351, 355, 355, 75, 73, 321, 
	178, 321, 350, 351, 355, 355, 75, 73, 
	321, 178, 321, 321, 321, 321, 321, 321, 
	182, 321, 350, 351, 352, 355, 75, 73, 
	321, 178, 321, 321, 100, 321, 321, 321, 
	182, 321, 348, 321, 375, 321, 362, 362, 
	75, 73, 321, 178, 321, 321, 321, 321, 
	321, 348, 321, 348, 321, 321, 321, 357, 
	357, 321, 73, 321, 178, 321, 321, 321, 
	321, 321, 348, 321, 348, 321, 321, 321, 
	357, 376, 321, 73, 321, 178, 321, 321, 
	321, 321, 321, 348, 321, 348, 321, 375, 
	321, 357, 357, 321, 73, 321, 178, 321, 
	321, 321, 321, 321, 348, 321, 342, 343, 
	347, 347, 75, 73, 321, 178, 321, 321, 
	321, 321, 321, 321, 182, 321, 342, 343, 
	344, 347, 75, 73, 321, 178, 321, 321, 
	102, 321, 321, 321, 182, 321, 340, 321, 
	377, 321, 362, 362, 75, 73, 321, 178, 
	321, 321, 321, 321, 321, 340, 321, 340, 
	321, 321, 321, 357, 357, 321, 73, 321, 
	178, 321, 321, 321, 321, 321, 340, 321, 
	340, 321, 321, 321, 357, 378, 321, 73, 
	321, 178, 321, 321, 321, 321, 321, 340, 
	321, 340, 321, 377, 321, 357, 357, 321, 
	73, 321, 178, 321, 321, 321, 321, 321, 
	340, 321, 334, 335, 339, 339, 75, 73, 
	321, 178, 321, 321, 321, 321, 321, 321, 
	182, 321, 334, 335, 336, 339, 75, 73, 
	321, 178, 321, 321, 104, 321, 321, 321, 
	182, 321, 332, 321, 379, 321, 362, 362, 
	75, 73, 321, 178, 321, 321, 321, 321, 
	321, 332, 321, 332, 321, 321, 321, 357, 
	357, 321, 73, 321, 178, 321, 321, 321, 
	321, 321, 332, 321, 332, 321, 321, 321, 
	357, 380, 321, 73, 321, 178, 321, 321, 
	321, 321, 321, 332, 321, 332, 321, 379, 
	321, 357, 357, 321, 73, 321, 178, 321, 
	321, 321, 321, 321, 332, 321, 326, 327, 
	331, 331, 75, 73, 321, 178, 321, 321, 
	321, 321, 321, 321, 182, 321, 326, 327, 
	328, 331, 75, 73, 321, 178, 321, 321, 
	106, 321, 321, 321, 182, 321, 324, 321, 
	381, 321, 362, 362, 75, 73, 321, 178, 
	321, 321, 321, 321, 321, 324, 321, 324, 
	321, 321, 321, 357, 357, 321, 73, 321, 
	178, 321, 321, 321, 321, 321, 324, 321, 
	324, 321, 321, 321, 357, 382, 321, 73, 
	321, 178, 321, 321, 321, 321, 321, 324, 
	321, 324, 321, 381, 321, 357, 357, 321, 
	73, 321, 178, 321, 321, 321, 321, 321, 
	324, 321, 107, 74, 74, 75, 73, 383, 
	383, 383, 383, 144, 383, 174, 175, 323, 
	323, 75, 73, 321, 178, 321, 321, 321, 
	321, 321, 321, 182, 321, 107, 74, 74, 
	75, 73, 383, 385, 386, 387, 388, 111, 
	109, 384, 389, 384, 384, 143, 384, 384, 
	384, 390, 384, 391, 386, 388, 388, 111, 
	109, 384, 389, 384, 384, 384, 384, 384, 
	384, 390, 384, 386, 388, 388, 111, 109, 
	384, 389, 384, 384, 384, 384, 384, 384, 
	390, 384, 392, 384, 384, 384, 124, 393, 
	384, 109, 384, 389, 384, 384, 384, 384, 
	384, 392, 384, 394, 395, 396, 397, 111, 
	109, 384, 389, 384, 384, 141, 384, 384, 
	384, 390, 384, 398, 395, 399, 399, 111, 
	109, 384, 389, 384, 384, 384, 384, 384, 
	384, 390, 384, 395, 399, 399, 111, 109, 
	384, 389, 384, 384, 384, 384, 384, 384, 
	390, 384, 400, 384, 384, 384, 124, 401, 
	384, 109, 384, 389, 384, 384, 384, 384, 
	384, 400, 384, 402, 403, 404, 405, 111, 
	109, 384, 389, 384, 384, 139, 384, 384, 
	384, 390, 384, 406, 403, 407, 407, 111, 
	109, 384, 389, 384, 384, 384, 384, 384, 
	384, 390, 384, 403, 407, 407, 111, 109, 
	384, 389, 384, 384, 384, 384, 384, 384, 
	390, 384, 408, 384, 384, 384, 124, 409, 
	384, 109, 384, 389, 384, 384, 384, 384, 
	384, 408, 384, 410, 411, 412, 413, 111, 
	109, 384, 389, 384, 384, 137, 384, 384, 
	384, 390, 384, 414, 411, 415, 415, 111, 
	109, 384, 389, 384, 384, 384, 384, 384, 
	384, 390, 384, 411, 415, 415, 111, 109, 
	384, 389, 384, 384, 384, 384, 384, 384, 
	390, 384, 416, 384, 384, 384, 124, 417, 
	384, 109, 384, 389, 384, 384, 384, 384, 
	384, 416, 384, 418, 419, 420, 421, 111, 
	109, 384, 389, 384, 384, 135, 384, 384, 
	384, 390, 384, 422, 419, 423, 423, 111, 
	109, 384, 389, 384, 384, 384, 384, 384, 
	384, 390, 384, 419, 423, 423, 111, 109, 
	384, 389, 384, 384, 384, 384, 384, 384, 
	390, 384, 124, 424, 384, 109, 384, 389, 
	384, 425, 425, 384, 109, 384, 389, 384, 
	426, 384, 384, 427, 384, 389, 384, 389, 
	384, 428, 384, 429, 384, 426, 384, 384, 
	384, 384, 389, 384, 124, 384, 430, 430, 
	111, 109, 384, 389, 384, 431, 133, 432, 
	433, 114, 109, 384, 389, 384, 133, 432, 
	433, 114, 109, 384, 389, 384, 432, 432, 
	114, 109, 384, 389, 384, 434, 130, 435, 
	436, 117, 109, 384, 389, 384, 130, 435, 
	436, 117, 109, 384, 389, 384, 435, 435, 
	117, 109, 384, 389, 384, 437, 127, 438, 
	439, 120, 109, 384, 389, 384, 127, 438, 
	439, 120, 109, 384, 389, 384, 438, 438, 
	120, 109, 384, 389, 384, 440, 124, 425, 
	441, 384, 109, 384, 389, 384, 124, 425, 
	441, 384, 109, 384, 389, 384, 425, 442, 
	384, 109, 384, 389, 384, 124, 384, 425, 
	425, 384, 109, 384, 389, 384, 419, 423, 
	423, 111, 109, 384, 389, 384, 418, 419, 
	423, 423, 111, 109, 384, 389, 384, 384, 
	384, 384, 384, 384, 390, 384, 418, 419, 
	420, 423, 111, 109, 384, 389, 384, 384, 
	135, 384, 384, 384, 390, 384, 416, 384, 
	443, 384, 430, 430, 111, 109, 384, 389, 
	384, 384, 384, 384, 384, 416, 384, 416, 
	384, 384, 384, 425, 425, 384, 109, 384, 
	389, 384, 384, 384, 384, 384, 416, 384, 
	416, 384, 384, 384, 425, 444, 384, 109, 
	384, 389, 384, 384, 384, 384, 384, 416, 
	384, 416, 384, 443, 384, 425, 425, 384, 
	109, 384, 389, 384, 384, 384, 384, 384, 
	416, 384, 410, 411, 415, 415, 111, 109, 
	384, 389, 384, 384, 384, 384, 384, 384, 
	390, 384, 410, 411, 412, 415, 111, 109, 
	384, 389, 384, 384, 137, 384, 384, 384, 
	390, 384, 408, 384, 445, 384, 430, 430, 
	111, 109, 384, 389, 384, 384, 384, 384, 
	384, 408, 384, 408, 384, 384, 384, 425, 
	425, 384, 109, 384, 389, 384, 384, 384, 
	384, 384, 408, 384, 408, 384, 384, 384, 
	425, 446, 384, 109, 384, 389, 384, 384, 
	384, 384, 384, 408, 384, 408, 384, 445, 
	384, 425, 425, 384, 109, 384, 389, 384, 
	384, 384, 384, 384, 408, 384, 402, 403, 
	407, 407, 111, 109, 384, 389, 384, 384, 
	384, 384, 384, 384, 390, 384, 402, 403, 
	404, 407, 111, 109, 384, 389, 384, 384, 
	139, 384, 384, 384, 390, 384, 400, 384, 
	447, 384, 430, 430, 111, 109, 384, 389, 
	384, 384, 384, 384, 384, 400, 384, 400, 
	384, 384, 384, 425, 425, 384, 109, 384, 
	389, 384, 384, 384, 384, 384, 400, 384, 
	400, 384, 384, 384, 425, 448, 384, 109, 
	384, 389, 384, 384, 384, 384, 384, 400, 
	384, 400, 384, 447, 384, 425, 425, 384, 
	109, 384, 389, 384, 384, 384, 384, 384, 
	400, 384, 394, 395, 399, 399, 111, 109, 
	384, 389, 384, 384, 384, 384, 384, 384, 
	390, 384, 394, 395, 396, 399, 111, 109, 
	384, 389, 384, 384, 141, 384, 384, 384, 
	390, 384, 392, 384, 449, 384, 430, 430, 
	111, 109, 384, 389, 384, 384, 384, 384, 
	384, 392, 384, 392, 384, 384, 384, 425, 
	425, 384, 109, 384, 389, 384, 384, 384, 
	384, 384, 392, 384, 392, 384, 384, 384, 
	425, 450, 384, 109, 384, 389, 384, 384, 
	384, 384, 384, 392, 384, 392, 384, 449, 
	384, 425, 425, 384, 109, 384, 389, 384, 
	384, 384, 384, 384, 392, 384, 385, 386, 
	388, 388, 111, 109, 384, 389, 384, 384, 
	384, 384, 384, 384, 390, 384, 172, 173, 
	174, 175, 451, 323, 75, 73, 321, 178, 
	179, 179, 144, 321, 321, 172, 182, 321, 
	186, 452, 188, 189, 3, 1, 185, 190, 
	185, 185, 35, 185, 185, 185, 191, 185, 
	194, 173, 174, 175, 453, 454, 75, 149, 
	185, 455, 185, 179, 144, 185, 185, 194, 
	182, 185, 107, 456, 456, 75, 149, 185, 
	190, 185, 185, 144, 185, 457, 185, 185, 
	458, 185, 455, 185, 455, 185, 459, 185, 
	231, 185, 457, 185, 185, 185, 185, 455, 
	185, 194, 185, 251, 107, 460, 460, 146, 
	149, 185, 190, 185, 185, 185, 185, 185, 
	194, 185, 461, 168, 462, 463, 148, 149, 
	185, 455, 185, 168, 462, 463, 148, 149, 
	185, 455, 185, 462, 462, 148, 149, 185, 
	455, 185, 464, 165, 465, 466, 152, 149, 
	185, 455, 185, 165, 465, 466, 152, 149, 
	185, 455, 185, 465, 465, 152, 149, 185, 
	455, 185, 467, 162, 468, 469, 155, 149, 
	185, 455, 185, 162, 468, 469, 155, 149, 
	185, 455, 185, 468, 468, 155, 149, 185, 
	455, 185, 470, 159, 471, 472, 185, 149, 
	185, 455, 185, 159, 471, 472, 185, 149, 
	185, 455, 185, 471, 471, 185, 149, 185, 
	455, 185, 474, 473, 475, 475, 473, 170, 
	473, 476, 473, 475, 475, 473, 170, 473, 
	476, 473, 477, 473, 473, 478, 473, 476, 
	473, 476, 473, 479, 473, 480, 473, 477, 
	473, 473, 473, 473, 476, 473, 172, 383, 
	383, 383, 383, 383, 383, 383, 383, 383, 
	179, 383, 383, 383, 383, 172, 383, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	166, 188, 2, 194, 3, 5, 197, 6, 
	8, 200, 9, 11, 203, 12, 14, 15, 
	187, 17, 18, 202, 20, 21, 199, 23, 
	24, 196, 205, 208, 212, 214, 218, 220, 
	224, 226, 230, 232, 166, 255, 37, 261, 
	38, 40, 264, 41, 43, 267, 44, 46, 
	270, 47, 49, 50, 254, 52, 53, 269, 
	55, 56, 266, 58, 59, 263, 272, 275, 
	279, 281, 285, 287, 291, 293, 297, 300, 
	166, 321, 72, 327, 166, 73, 75, 330, 
	76, 78, 333, 79, 81, 336, 82, 84, 
	85, 320, 87, 88, 335, 90, 91, 332, 
	93, 94, 329, 338, 341, 345, 347, 351, 
	353, 357, 359, 363, 166, 389, 106, 395, 
	107, 109, 398, 110, 112, 401, 113, 115, 
	404, 116, 118, 119, 388, 121, 122, 403, 
	124, 125, 400, 127, 128, 397, 406, 409, 
	413, 415, 419, 421, 425, 427, 431, 433, 
	366, 142, 444, 144, 447, 438, 145, 147, 
	450, 148, 150, 453, 151, 154, 155, 455, 
	157, 158, 452, 160, 161, 449, 163, 164, 
	446, 166, 458, 166, 167, 234, 301, 303, 
	365, 367, 323, 368, 434, 435, 340, 456, 
	463, 166, 168, 170, 34, 233, 190, 207, 
	169, 33, 171, 228, 172, 174, 32, 227, 
	173, 31, 175, 222, 176, 178, 30, 221, 
	177, 29, 179, 216, 180, 182, 28, 215, 
	181, 27, 183, 210, 184, 186, 26, 209, 
	185, 25, 193, 0, 189, 192, 191, 166, 
	1, 195, 4, 22, 198, 7, 19, 201, 
	10, 16, 204, 13, 206, 211, 213, 217, 
	219, 223, 225, 229, 231, 166, 235, 237, 
	69, 299, 257, 274, 236, 68, 238, 295, 
	239, 241, 67, 294, 240, 66, 242, 289, 
	243, 245, 65, 288, 244, 64, 246, 283, 
	247, 249, 63, 282, 248, 62, 250, 277, 
	251, 253, 61, 276, 252, 60, 260, 35, 
	256, 259, 258, 166, 36, 262, 39, 57, 
	265, 42, 54, 268, 45, 51, 271, 48, 
	273, 278, 280, 284, 286, 290, 292, 296, 
	298, 166, 302, 103, 304, 361, 305, 307, 
	102, 360, 306, 101, 308, 355, 309, 311, 
	100, 354, 310, 99, 312, 349, 313, 315, 
	98, 348, 314, 97, 316, 343, 317, 319, 
	96, 342, 318, 95, 326, 70, 322, 325, 
	324, 166, 71, 328, 74, 92, 331, 77, 
	89, 334, 80, 86, 337, 83, 339, 344, 
	346, 350, 352, 356, 358, 362, 364, 166, 
	166, 369, 371, 138, 137, 391, 408, 370, 
	372, 429, 373, 375, 136, 428, 374, 135, 
	376, 423, 377, 379, 134, 422, 378, 133, 
	380, 417, 381, 383, 132, 416, 382, 131, 
	384, 411, 385, 387, 130, 410, 386, 129, 
	394, 104, 390, 393, 392, 166, 105, 396, 
	108, 126, 399, 111, 123, 402, 114, 120, 
	405, 117, 407, 412, 414, 418, 420, 424, 
	426, 430, 432, 139, 436, 437, 443, 440, 
	140, 439, 442, 441, 141, 445, 143, 162, 
	448, 146, 159, 451, 149, 156, 454, 152, 
	153, 166, 457, 165, 460, 459, 462, 461, 
	166
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	4, 0, 0, 2, 5, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 2, 6, 2, 6, 2, 
	6, 2, 6, 2, 7, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	6, 0, 2, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 8, 0, 11, 2, 2, 6, 0, 
	12, 12, 0, 2, 6, 2, 6, 2, 
	0, 13, 2, 0, 0, 2, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 2, 2, 0, 0, 2, 
	2, 0, 2, 0, 0, 0, 0, 14, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 15, 2, 0, 
	0, 2, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 2, 0, 2, 0, 
	0, 0, 0, 16, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 17, 6, 0, 6, 6, 6, 0, 
	0, 6, 6, 0, 6, 6, 6, 0, 
	0, 6, 6, 0, 6, 6, 6, 0, 
	0, 6, 6, 0, 6, 6, 6, 0, 
	0, 6, 6, 0, 6, 0, 0, 0, 
	0, 18, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 19, 
	20, 2, 0, 0, 0, 0, 2, 2, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 2, 2, 0, 0, 2, 2, 0, 
	2, 0, 0, 0, 0, 21, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 0, 0, 22, 2, 0, 
	0, 0, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 23, 2, 0, 0, 0, 0, 0, 
	24
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 9, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 37, 73, 73, 
	77, 77, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 109, 109, 109, 109, 109, 
	109, 109, 109, 73, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 170, 0, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 254, 254, 254, 
	254, 254, 254, 254, 254, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 322, 322, 322, 
	322, 322, 322, 322, 322, 384, 322, 384, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 385, 385, 385, 385, 385, 385, 
	385, 385, 322, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	186, 186, 186, 186, 186, 186, 186, 186, 
	474, 474, 474, 474, 474, 474, 474, 384
};

static const int indic_syllable_machine_start = 166;
static const int indic_syllable_machine_first_final = 166;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 166;


#line 36 "hb-ot-shape-complex-indic-machine.rl"



#line 92 "hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts HB_UNUSED, te, act;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1137 "hb-ot-shape-complex-indic-machine.hh"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 113 "hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 1154 "hb-ot-shape-complex-indic-machine.hh"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 10:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1168 "hb-ot-shape-complex-indic-machine.hh"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 14:
#line 83 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 16:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 21:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 24:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (symbol_cluster); }}
	break;
	case 18:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 11:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 13:
#line 83 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 15:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 20:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 23:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (symbol_cluster); }}
	break;
	case 17:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 19:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 83 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 84 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 85 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 8:
#line 86 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (symbol_cluster); }}
	break;
	case 4:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} found_syllable (consonant_syllable); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 6:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 22:
#line 1 "NONE"
	{te = p+1;}
#line 83 "hb-ot-shape-complex-indic-machine.rl"
	{act = 1;}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 87 "hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
	case 12:
#line 1 "NONE"
	{te = p+1;}
#line 88 "hb-ot-shape-complex-indic-machine.rl"
	{act = 6;}
	break;
#line 1291 "hb-ot-shape-complex-indic-machine.hh"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 9:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1300 "hb-ot-shape-complex-indic-machine.hh"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 122 "hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
