      SUBROUTINE NDF1_WSTA( IACB, STATE, STATUS )
*+
* Name:
*    NDF1_WSTA

*  Purpose:
*     Determine the state of the WCS component of an NDF.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL NDF1_WSTA( IACB, STATE, STATUS )

*  Description:
*     The routine returns a logical value indicating if the WCS
*     component of an NDF is defined. The NDF is identified by its ACB
*     entry.

*  Arguments:
*     IACB = INTEGER (Given)
*        Index to the NDF's ACB entry.
*     STATE = LOGICAL (Returned)
*        Whether the WCS component is defined (.TRUE. for defined,
*        .FALSE. for undefined).
*     STATUS = INTEGER (Given and Returned)
*        The global status.

*  Copyright:
*     Copyright (C) 1997 Rutherford Appleton Laboratory

*  Authors:
*     RFWS: R.F. Warren-Smith (STARLINK, RAL)
*     {enter_new_authors_here}

*  History:
*     30-JUN-1997 (RFWS):
*        Original version.
*     {enter_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*-

*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
      INCLUDE 'DAT_PAR'          ! DAT_ public constants
      INCLUDE 'NDF_PAR'          ! NDF_ public constants
      INCLUDE 'NDF_CONST'        ! NDF_ private constants
      INCLUDE 'AST_PAR'          ! AST_ public interface
      
*           Global Variables:
      INCLUDE 'NDF_DCB'          ! NDF_ Data Control Block
*        DCB_IWCS( NDF__MXDCB ) = INTEGER (Read)
*           WCS Object pointer.

      INCLUDE 'NDF_ACB'          ! NDF_ Access Control Block
*        ACB_IDCB( NDF__MXACB ) = INTEGER (Read)
*           Index to data object entry in the DCB.

*  Arguments Given:
      INTEGER IACB
      
*  Arguments Returned:
      LOGICAL STATE
      
*  Status:
      INTEGER STATUS             ! Global status

*  Local Variables:
      INTEGER IDCB               ! Index to data object in the DCB
      
*.

*  Check inherited global status.
      IF ( STATUS .NE. SAI__OK ) RETURN
      
*  Obtain the index of the data object entry in the DCB.
      IDCB = ACB_IDCB( IACB )

*  Ensure that WCS information is available in the DCB.
      CALL NDF1_DW( IDCB, STATUS )
      IF ( STATUS .EQ. SAI__OK ) THEN

*  Use the WCS Object pointer in the DCB to determine the state.
         STATE = DCB_IWCS( IDCB ) .NE. AST__NULL
      END IF

*  Call error tracing routine and exit.
      IF ( STATUS .NE. SAI__OK ) CALL NDF1_TRACE( 'NDF1_WSTA', STATUS )

      END
