/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;

public class RexxTaskPool
implements Executor,
Runnable {
    private static final String $0 = "RexxTaskPool.nrx";
    protected static HashMap poolmap;
    public int poolnumber;
    public int poolsize;
    public ThreadPoolExecutor threadpool;
    private Rexx poolno;
    private Rexx poolsiz3;
    private Object realtask;
    private String saveparms;
    protected static final String[] sa0;
    protected static final Class[] ca1;

    static {
        sa0 = new String[0];
        ca1 = new Class[]{sa0.getClass()};
    }

    public RexxTaskPool() throws Exception {
        this(Runtime.getRuntime().availableProcessors());
    }

    public RexxTaskPool(int n) throws Exception {
        this(n, -1);
    }

    public RexxTaskPool(int n, int n2) throws Exception {
        if (n == 0) {
            throw new Exception("RexxTaskPool - pool of zero threads not allowed.");
        }
        this.poolsize = n;
        this.poolnumber = n2 == -1 ? 0 : n2;
        this.poolno = new Rexx(this.poolnumber);
        this.poolsiz3 = new Rexx(this.poolsize);
        if (poolmap == null) {
            poolmap = new HashMap();
        }
        if (!poolmap.containsKey(this.poolno)) {
            poolmap.put(this.poolno, new HashMap());
        }
        if (!((HashMap)poolmap.get(this.poolno)).containsKey(this.poolsiz3)) {
            ((HashMap)poolmap.get(this.poolno)).put(this.poolsiz3, new ThreadPoolExecutor(this.poolsize, this.poolsize, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>()));
        }
        this.threadpool = (ThreadPoolExecutor)((HashMap)poolmap.get(this.poolno)).get(this.poolsiz3);
    }

    public RexxTaskPool start(Object object) throws ClassNotFoundException, SecurityException {
        return this.start(object, null);
    }

    public RexxTaskPool start(Object object, String string) throws ClassNotFoundException, SecurityException {
        if (object instanceof Runnable) {
            this.startrunnable((Runnable)object);
        } else {
            this.startmain(object, string);
        }
        return this;
    }

    public RexxTaskPool execute(Object object) throws ClassNotFoundException, SecurityException {
        return this.execute(object, null);
    }

    public RexxTaskPool execute(Object object, String string) throws ClassNotFoundException, SecurityException {
        return this.start(object, string);
    }

    @Override
    public void execute(Runnable runnable) {
        this.startrunnable(runnable);
    }

    public void startrunnable(Runnable runnable) {
        ((ThreadPoolExecutor)((HashMap)poolmap.get(this.poolno)).get(this.poolsiz3)).execute(runnable);
    }

    public void startmain(Object clazz, String string) throws ClassNotFoundException, SecurityException {
        Method method = null;
        Exception exception = null;
        if (clazz instanceof String) {
            clazz = Class.forName((String)((Object)clazz));
        }
        if (clazz instanceof Class) {
            try {
                method = clazz.getMethod("main", ca1);
            }
            catch (Exception exception2) {
                exception = exception2;
                RexxIO.Say(exception);
            }
        } else {
            try {
                method = clazz.getClass().getMethod("main", ca1);
            }
            catch (Exception exception3) {
                exception = exception3;
                RexxIO.Say(exception);
            }
        }
        if (method == null) {
            return;
        }
        ((ThreadPoolExecutor)((HashMap)poolmap.get(this.poolno)).get(this.poolsiz3)).execute(new RexxTaskPool(clazz, string));
    }

    public void waituntildone() {
        Exception exception = null;
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)((HashMap)poolmap.get(this.poolno)).get(this.poolsiz3);
        try {
            while (true) {
                if (threadPoolExecutor.getQueue().size() + threadPoolExecutor.getActiveCount() == 0) {
                    return;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            RexxIO.Say(exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitforallpools() {
        Object object = null;
        HashMap hashMap = null;
        Object object2 = null;
        Exception exception = null;
        try {
            block8: while (true) {
                int n;
                Set set = poolmap.keySet();
                Object[] objectArray = new Object[set.size()];
                Set set2 = set;
                synchronized (set2) {
                    Iterator iterator = set.iterator();
                    for (n = 0; n != objectArray.length; ++n) {
                        objectArray[n] = iterator.next();
                    }
                }
                while (--n >= 0) {
                    int n2;
                    object = objectArray[n];
                    hashMap = (HashMap)poolmap.get(object);
                    set2 = hashMap.keySet();
                    Object[] objectArray2 = new Object[set2.size()];
                    Set set3 = set2;
                    synchronized (set3) {
                        Iterator iterator = set2.iterator();
                        for (n2 = 0; n2 != objectArray2.length; ++n2) {
                            objectArray2[n2] = iterator.next();
                        }
                    }
                    while (--n2 >= 0) {
                        object2 = objectArray2[n2];
                        if (((ThreadPoolExecutor)hashMap.get(object2)).getQueue().size() + ((ThreadPoolExecutor)hashMap.get(object2)).getActiveCount() == 0) continue;
                        Thread.sleep(100L);
                        continue block8;
                    }
                }
                break;
            }
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            RexxIO.Say(exception);
            return;
        }
    }

    public RexxTaskPool(Object object, String string) {
        this.realtask = object;
        this.saveparms = string;
    }

    @Override
    public void run() {
        String[] stringArray = null;
        Method method = null;
        Exception exception = null;
        stringArray = this.saveparms != null ? this.saveparms.split(" ") : sa0;
        Object[] objectArray = new Object[]{stringArray};
        if (this.realtask instanceof Class) {
            try {
                method = ((Class)this.realtask).getMethod("main", ca1);
                method.setAccessible(true);
                method.invoke(null, objectArray);
            }
            catch (Exception exception2) {
                exception = exception2;
                RexxIO.Say(exception);
            }
        } else {
            try {
                method = this.realtask.getClass().getMethod("main", ca1);
                method.setAccessible(true);
                method.invoke(null, objectArray);
            }
            catch (Exception exception3) {
                exception = exception3;
                RexxIO.Say(exception);
            }
        }
    }
}

