# Copyright (C) 1999, 2000, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
# 2008 Peter Hanecak <hany@hany.sk>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# See the COPYING file for license information.

%define name hd2u
%define version 1.0.4

Name: %{name}
Version: %{version}
Release: 1%{?dist}
Summary: Converts DOS-style EOLs to UNIX-style EOLs and vice versa
License: GPL
Group: Applications/Text
Vendor: Peter Hanecak <hany@hany.sk>
Url: http://hany.sk/~hany/software/hd2u/
Provides: dos2unix
Obsoletes: dos2unix
Prefix: %{_prefix}

Source: %{name}-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-root

%description
hd2u is "Hany's Dos2Unix convertor". It provides 'dos2unix'.

'dos2unix' is filter used to convert DOS-style EOLs to UNIX-style EOLs and vice
versa (EOL - End Of Line character). Aditionaly it can also handle files
with Macintosh-style EOLs and convert them into other EOLs.

%prep
%setup

%build
%configure
make dos2unix-optimized
# test is not necessary when building optimized hd2u - optimized build runs also tests
#make test

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_bindir}
make BUILD_ROOT="$RPM_BUILD_ROOT" install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/dos2unix
%doc AUTHORS COPYING CREDITS ChangeLog INSTALL NEWS README TODO

%changelog
* Fri Sep  1 2017 Peter Hanecak <hany@hany.sk> 1.0.4-1
- README, configure.in, hd2u.spec: bumped-up version
- NEWS: added info about this release
- use getopt from glibc instead of popt
- packaging/hd2u.spec: converted to UTF-8
- Makefile.in: `make clean` removes also config.h

* Wed Sep 10 2008 Peter Hanecak <hany@hany.sk> 1.0.3-1
- README, configure.in, hd2u.spec: bumped-up version
- NEWS: added info about this release
- dos2unix.c: print "stdin" instead of "(null)" in verbose mode
- dos2unix.c: if file type is undetermined (file without line
  endings or empty file), print so in verbose mode and do not try to
  convert such file
- Makefile.in: "$^" changed into "$(@:%=%.c)" as the "$^" gets
  expanded into "dos2unix.c config.h" and that causes problem for
  gcc 2.95.3 ("gcc: Compilation of header file requested")

* Tue Aug 28 2007 Peter Hanecak <hany@hany.sk> 1.0.2-1
- README, configure.in, hd2u.spec: bumped-up version
- NEWS: added info about this release

* Thu Jul  5 2007 Peter Hanecak <hany@hany.sk>
- dos2unix.c: added 'b' to 'fopen()' calls so that conversion is not
  confused on platforms like Cygwin

* Sun Jan 28 2007 Peter Hanecak <hany@hany.sk>
- added %%{?dist} into spec

* Sun Jan 28 2007 Peter Hanecak <hany@hany.sk> 1.0.1-1
- use profile-directed optimizations
- updated email and URLs

* Tue Mar 15 2005 Peter Hanecak <hanecak@megaloman.sk> 1.0.0-1
- TODO: removed notice about big files being truncated
- NEWS:
  - added info about this release
  - fixed few typos

* Thu Oct 28 2004 Peter Hanecak <hanecak@megaloman.sk> 0.9.2-1
- NEWS: updated

* Mon Oct 25 2004 Peter Hanecak <hanecak@megaloman.sk>
- Makefile.in: changed '$(CC) $(CFLAGS) -o $(TARGET) $(TARGET).c $(LIBS)' to
  '$(CC) $(CFLAGS) -o $@ $(@:%=%.c) $(LIBS)' (based on suggestion by Marty
  Leisner <mleisner@eng.mc.xerox.com>)
- install-sh: updated from automake-1.8.3 package
- INSTALL: added notice about popt-devel as suggested by max
- README: fixed typo (thanks to N. Roeser <n-roeser@gmx.net> and Ryan
  Schmidt <hello-200407@ryandesign.com> for pointing out the mistake)
- dos2unix.c: do not clear FT_BINARY flag from fileType when Mac line
  endings are detected which should avoid image or sound (or other binary)
  files to be confused with Mac text files (thanks to basic
  <basic@mozdev.org> and Caj Nordström <caj.nordstrom@beamex.com> for
  pointing out the bug and suggesting the fix)

* Sun Apr 18 2004 Peter Hanecak <hanecak@megaloman.sk>
- ChangeLog, README: fixed typos

* Wed Apr 14 2004 Peter Hanecak <hanecak@megaloman.sk> 0.9.1-1
- dos2unix.c: --version (-V) option added: display version
  information
- config.h.in added (as created by autoheader)
- configure.in:
  - incorporated changes sugested by configure.scan generated by autoscan
  - config.h is generated by configure
- Makefile.in:
  - 'make cleanall' removes also cache directory created by 'autoconf
  - incorporated changes done to configure.in
- README: added info about --version (-V) option

* Fri Nov 14 2003 Peter Hanecak <hanecak@megaloman.sk> 0.9.0-1
- dos2unix.c:
  - files in Mac format are now recognized; thanks to Sam Barnum
    <sbarnum@pointsystems.com> and max <max@oddjob.utias.utoronto.ca>
    for suggestion (and to max also for pushing me to actualy do that :)
  - new conversion types: MAC -> UNIX, UNIX -> MAC, DOS -> MAC and MAC -> DOS
  - when autodetected input format does not match input format suggested by
    conversion type option on command line, conversion type is automaticaly
    corrected
  - --force (-f) option, which supress above mentioned behaviour
- install-sh: updated from automake-1.6 package
- README: updated
- TODO: what should be fixed till next stable release

* Fri Oct  3 2003 Peter Hanecak <hanecak@megaloman.sk> 0.8.2-1
- dos2unix.c:
  - read/write buffers implemented - increases performance about 9 times
  - message "File format '<file>':" changed to "File format of '<file>':"
- TODO: updated

* Wed Feb 26 2003 Peter Hanecak <hanecak@megaloman.sk> 0.8.1-1
- dos2unix.c:
  - mkstemp() used instead of tmpnam()
  - temporary directory specified by TMPDIR or TMP environment variable
    used; if none of them is avialable, then "/tmp" is used
- spec:
  - group changed from Utilities/Text to Applications/Text
  - s/Copyright/License

* Tue May  7 2002 Peter Hanecak <hanecak@megaloman.sk>
[0.8.0-1]
- ChangeLog: fixed typo
- README: updated "Usage" chapter
- dos2unix.c: updated help
- applied patch from Philip White <pwhite@mailhaven.com>
  (minor grammar corrections and miscellaneous beautifying in help & docs)

* Fri Jan  4 2002 Peter Hanecak <hanecak@megaloman.sk>
[0.7.2-1]
- INSTALL: fixed info about changing prefix
- Makefile.in: create bin directory before installing hd2u binary into it;
  this should solve the problem when using custom prefix in which 'bin'
  directory does not exists (thanks to Emanuele Olivetti <olivetti@itc.it>
  for reporting the problem)
- dos2unix.c: fix gcc 2.96 warning: string length '687' is greater than the
  minimum length '509' ISO C89 is required to support

* Sun Feb 11 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.7.1-1]
- dos2unix.c: --skipbin (-b) switch added: binary files won't be converted
- dos2unix.c: --test (-t): NO output (not even verbose)
- dos2unix.c: conversion of input data from stdin works again
- dos2unix.c: reworked convert(): conversion of input data from stdin works
  again; better separation of detection, verbose info output and other logic
- dos2unix.c: rouge '\r' are reported but only conversion dos -> unix affects
  them (they are skipped)
- dos2unix.c: directories when given as input are skipped

* Sun Feb 11 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.7.0-1]
- documentation updates

* Wed Feb  7 2001 Rob Ginda <rginda@netscape.com>
- dos2unix.c: more robust source format detection can detect binary files,
  mixed mode files, and files with no line endings at all
- dos2unix.c: added automatic skipping of binary files
- dos2unix.c: added --test mode to check filetype without converting
- dos2unix.c: added --verbose option to show status messages while working
- dos2unix.c: converted C++ style (//) comments to C style (/**/) (some C
  compilers will choke on //)
- dos2unix.c: reorderd function definition to avoid prototypes
- dos2unix.c: replaced hard tabs with 4 spaces
- dos2unix.c: added emacs modeline

* Sun Jan 21 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.6.0-1]
- documentation: fixed typos
- dos2unix.c: handle NULL when returned by tmpnam()
- Makefile.in: added '-Wall -pedantic' to CFLAGS

* Tue Oct  3 2000 Peter Hanecak <hanecak@megaloman.sk>
[0.5.12-1]
- documentation extended (popt) and updated (configure)
- configure.in: check for getopt_long() function

* Tue Sep 26 2000 Peter Hanecak <hanecak@megaloman.sk>
[0.5.11-1]
- configure.in: check for popt library

* Mon Aug  7 2000 Peter Hanecak <hanecak@megaloman.sk>
[0.5.10-1]
- autoconfigure

* Sat Aug  5 2000 Peter Hanecak <hanecak@megaloman.sk>
[0.5.9-2]
- --auto switch
- do not touch files which are alredy in specified target format
- spec: Prefix, %%{_tmppath} and %%{_bindir} used

* Thu Nov 25 1999 Peter Hanecak <hanecak@megaloman.sk>
[0.5.0-2]
- added URL to spec
- mostly typo fixes

* Thu Nov 25 1999 Peter Hanecak <hanecak@megaloman.sk>
[0.5.0]
- renamed package to 'hd2u' to avoid conflicts with alredy existing
  dos2unix package(s) (is 'hd2u' original enough? :)
- moved binary to '/usr/bin'
- added some documentation
- first public release

* Thu Oct 21 1999 Peter Hanecak <hanecak@megaloman.sk>
[0.5.0]
- speed optimisation

* Thu Oct 21 1999 Peter Hanecak <hanecak@megaloman.sk>
[0.4.0]
- coversion of file(s) specified as command line parameters

* Tue Oct 19 1999 Peter Hanecak <hanecak@megaloman.sk>
[0.3.0]
- getopt used to process parameters
- help displayed when incorect options

* Sun Sep 26 1999 Peter Hanecak <hanecak@megaloman.sk>
[0.3.0]

* Fri Mar 26 1999 Peter Hanecak <hanecak@megaloman.sk>
[0.2.0]
- initial spec
