// Copyright 2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// Tests that we consider `i16: Remote` to be ambiguous, even
// though the upstream crate doesn't implement it for now.

// aux-build:coherence_lib.rs

extern crate coherence_lib;

use coherence_lib::Remote;

struct A<X>(X);
impl<T> A<T> where T: Remote { fn dummy(&self) { } }
//~^ ERROR E0592
//~| NOTE duplicate definitions for `dummy`
//~| NOTE upstream crates may add new impl of trait `coherence_lib::Remote` for type `i16`
impl A<i16> { fn dummy(&self) { } }
//~^ NOTE other definition for `dummy`

fn main() {}
