// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/safe_browsing_db/v4_feature_list.h"

#include "base/feature_list.h"
#include "components/safe_browsing/features.h"

namespace safe_browsing {

namespace V4FeatureList {

bool IsV4OnlyEnabled() {
  return base::FeatureList::IsEnabled(kV4OnlyEnabled);
}

bool IsLocalDatabaseManagerEnabled() {
  return base::FeatureList::IsEnabled(kLocalDatabaseManagerEnabled) ||
         IsV4OnlyEnabled();
}

V4UsageStatus GetV4UsageStatus() {
  V4UsageStatus v4_usage_status;
  if (safe_browsing::V4FeatureList::IsV4OnlyEnabled()) {
    v4_usage_status = V4UsageStatus::V4_ONLY;
  } else if (safe_browsing::V4FeatureList::IsLocalDatabaseManagerEnabled()) {
    v4_usage_status = V4UsageStatus::V4_INSTANTIATED;
  } else {
    v4_usage_status = V4UsageStatus::V4_DISABLED;
  }
  return v4_usage_status;
}

}  // namespace V4FeatureList

}  // namespace safe_browsing
