// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: GraalDebugConfig.java
package org.graalvm.compiler.debug;

import java.util.*;
import org.graalvm.compiler.options.*;

public class GraalDebugConfig_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        // CheckStyle: stop line length check
        switch (value) {
            case "BootstrapInitializeOnly": return OptionDescriptor.create("BootstrapInitializeOnly", Boolean.class, "Do not compile anything on bootstrap but just initialize the compiler.", GraalDebugConfig.Options.class, "BootstrapInitializeOnly", GraalDebugConfig.Options.BootstrapInitializeOnly);
            case "CanonicalGraphStringsCheckConstants": return OptionDescriptor.create("CanonicalGraphStringsCheckConstants", Boolean.class, "Exclude virtual nodes when dumping canonical text for graphs.", GraalDebugConfig.Options.class, "CanonicalGraphStringsCheckConstants", GraalDebugConfig.Options.CanonicalGraphStringsCheckConstants);
            case "CanonicalGraphStringsExcludeVirtuals": return OptionDescriptor.create("CanonicalGraphStringsExcludeVirtuals", Boolean.class, "Exclude virtual nodes when dumping canonical text for graphs.", GraalDebugConfig.Options.class, "CanonicalGraphStringsExcludeVirtuals", GraalDebugConfig.Options.CanonicalGraphStringsExcludeVirtuals);
            case "CanonicalGraphStringsRemoveIdentities": return OptionDescriptor.create("CanonicalGraphStringsRemoveIdentities", Boolean.class, "Attempts to remove object identity hashes when dumping canonical text for graphs.", GraalDebugConfig.Options.class, "CanonicalGraphStringsRemoveIdentities", GraalDebugConfig.Options.CanonicalGraphStringsRemoveIdentities);
            case "ClearMetricsAfterBootstrap": return OptionDescriptor.create("ClearMetricsAfterBootstrap", Boolean.class, "Clear the debug metrics after bootstrap.", GraalDebugConfig.Options.class, "ClearMetricsAfterBootstrap", GraalDebugConfig.Options.ClearMetricsAfterBootstrap);
            case "Count": return OptionDescriptor.create("Count", String.class, "Pattern for scope(s) in which counting is enabled (see DebugFilter and Debug.counter). An empty value enables all counters unconditionally.", GraalDebugConfig.Options.class, "Count", GraalDebugConfig.Options.Count);
            case "DebugValueFile": return OptionDescriptor.create("DebugValueFile", String.class, "Write debug values into a file instead of the terminal. If DebugValueSummary is Thread, the thread name will be prepended.", GraalDebugConfig.Options.class, "DebugValueFile", GraalDebugConfig.Options.DebugValueFile);
            case "DebugValueHumanReadable": return OptionDescriptor.create("DebugValueHumanReadable", Boolean.class, "Print counters and timers in a human readable form.", GraalDebugConfig.Options.class, "DebugValueHumanReadable", GraalDebugConfig.Options.DebugValueHumanReadable);
            case "DebugValueSummary": return OptionDescriptor.create("DebugValueSummary", String.class, "How to print counters and timing values:%nName - aggregate by unqualified name%nPartial - aggregate by partially qualified name (e.g., A.B.C.D.Counter and X.Y.Z.D.Counter will be merged to D.Counter)%nComplete - aggregate by qualified name%nThread - aggregate by qualified name and thread", GraalDebugConfig.Options.class, "DebugValueSummary", GraalDebugConfig.Options.DebugValueSummary);
            case "DebugValueThreadFilter": return OptionDescriptor.create("DebugValueThreadFilter", String.class, "Only report debug values for maps which match the regular expression.", GraalDebugConfig.Options.class, "DebugValueThreadFilter", GraalDebugConfig.Options.DebugValueThreadFilter);
            case "Dump": return OptionDescriptor.create("Dump", String.class, "Pattern for scope(s) in which dumping is enabled (see DebugFilter and Debug.dump)", GraalDebugConfig.Options.class, "Dump", GraalDebugConfig.Options.Dump);
            case "DumpOnError": return OptionDescriptor.create("DumpOnError", Boolean.class, "Send Graal compiler IR to dump handlers on error", GraalDebugConfig.Options.class, "DumpOnError", GraalDebugConfig.Options.DumpOnError);
            case "DumpPath": return OptionDescriptor.create("DumpPath", String.class, "The directory where various Graal dump files are written.", GraalDebugConfig.Options.class, "DumpPath", GraalDebugConfig.Options.DumpPath);
            case "ForceDebugEnable": return OptionDescriptor.create("ForceDebugEnable", Boolean.class, "Force-enable debug code paths", GraalDebugConfig.Options.class, "ForceDebugEnable", GraalDebugConfig.Options.ForceDebugEnable);
            case "GlobalMetricsInterceptedByMethodMetrics": return OptionDescriptor.create("GlobalMetricsInterceptedByMethodMetrics", String.class, "If a global metric (DebugTimer, DebugCounter or DebugMemUseTracker) is enabled in the same scope as a method metric, use the global metric to update the method metric for the current compilation. This option enables the re-use of global metrics on per-compilation basis. Whenever a value is added to a global metric, the value is also added to a MethodMetric under the same name as the global metric. This option incurs a small but constant overhead due to the context method lookup at each metric update. Format to specify GlobalMetric interception:(Timers|Counters|MemUseTrackers)(,Timers|,Counters|,MemUseTrackers)*", GraalDebugConfig.Options.class, "GlobalMetricsInterceptedByMethodMetrics", GraalDebugConfig.Options.GlobalMetricsInterceptedByMethodMetrics);
            case "InterceptBailout": return OptionDescriptor.create("InterceptBailout", Boolean.class, "Intercept also bailout exceptions", GraalDebugConfig.Options.class, "InterceptBailout", GraalDebugConfig.Options.InterceptBailout);
            case "Log": return OptionDescriptor.create("Log", String.class, "Pattern for scope(s) in which logging is enabled (see DebugFilter and Debug.log)", GraalDebugConfig.Options.class, "Log", GraalDebugConfig.Options.Log);
            case "LogVerbose": return OptionDescriptor.create("LogVerbose", Boolean.class, "Enable more verbose log output when available", GraalDebugConfig.Options.class, "LogVerbose", GraalDebugConfig.Options.LogVerbose);
            case "MethodFilter": return OptionDescriptor.create("MethodFilter", String.class, "Pattern for filtering debug scope output based on method context (see MethodFilter)", GraalDebugConfig.Options.class, "MethodFilter", GraalDebugConfig.Options.MethodFilter);
            case "MethodFilterRootOnly": return OptionDescriptor.create("MethodFilterRootOnly", Boolean.class, "Only check MethodFilter against the root method in the context if true, otherwise check all methods", GraalDebugConfig.Options.class, "MethodFilterRootOnly", GraalDebugConfig.Options.MethodFilterRootOnly);
            case "MethodMeter": return OptionDescriptor.create("MethodMeter", String.class, "Enable per method metrics that are collected across all compilations of a method.Pattern for scope(s) in which method metering is enabled (see DebugFilter and Debug.metric).", GraalDebugConfig.Options.class, "MethodMeter", GraalDebugConfig.Options.MethodMeter);
            case "PrintBackendCFG": return OptionDescriptor.create("PrintBackendCFG", Boolean.class, "Enable dumping LIR, register allocation and code generation info to the C1Visualizer.", GraalDebugConfig.Options.class, "PrintBackendCFG", GraalDebugConfig.Options.PrintBackendCFG);
            case "PrintBinaryGraphPort": return OptionDescriptor.create("PrintBinaryGraphPort", Integer.class, "", GraalDebugConfig.Options.class, "PrintBinaryGraphPort", GraalDebugConfig.Options.PrintBinaryGraphPort);
            case "PrintBinaryGraphs": return OptionDescriptor.create("PrintBinaryGraphs", Boolean.class, "Dump IdealGraphVisualizer output in binary format", GraalDebugConfig.Options.class, "PrintBinaryGraphs", GraalDebugConfig.Options.PrintBinaryGraphs);
            case "PrintCFG": return OptionDescriptor.create("PrintCFG", Boolean.class, "Enable dumping to the C1Visualizer. Enabling this option implies PrintBackendCFG.", GraalDebugConfig.Options.class, "PrintCFG", GraalDebugConfig.Options.PrintCFG);
            case "PrintCFGFileName": return OptionDescriptor.create("PrintCFGFileName", String.class, "Base filename when dumping C1Visualizer output to files.", GraalDebugConfig.Options.class, "PrintCFGFileName", GraalDebugConfig.Options.PrintCFGFileName);
            case "PrintCanonicalGraphStringFlavor": return OptionDescriptor.create("PrintCanonicalGraphStringFlavor", Integer.class, "Choose format used when dumping canonical text for graphs: 0 gives a scheduled graph (better for spotting changes involving the schedule)while 1 gives a CFG containing expressions rooted at fixed nodes (better for spotting small structure differences)", GraalDebugConfig.Options.class, "PrintCanonicalGraphStringFlavor", GraalDebugConfig.Options.PrintCanonicalGraphStringFlavor);
            case "PrintCanonicalGraphStrings": return OptionDescriptor.create("PrintCanonicalGraphStrings", Boolean.class, "Enable dumping canonical text from for graphs.", GraalDebugConfig.Options.class, "PrintCanonicalGraphStrings", GraalDebugConfig.Options.PrintCanonicalGraphStrings);
            case "PrintCanonicalGraphStringsDirectory": return OptionDescriptor.create("PrintCanonicalGraphStringsDirectory", String.class, "Base directory when dumping graphs strings to files.", GraalDebugConfig.Options.class, "PrintCanonicalGraphStringsDirectory", GraalDebugConfig.Options.PrintCanonicalGraphStringsDirectory);
            case "PrintGraphProbabilities": return OptionDescriptor.create("PrintGraphProbabilities", Boolean.class, "Output probabilities for fixed nodes during binary graph dumping", GraalDebugConfig.Options.class, "PrintGraphProbabilities", GraalDebugConfig.Options.PrintGraphProbabilities);
            case "PrintIdealGraph": return OptionDescriptor.create("PrintIdealGraph", Boolean.class, "Enable dumping to the IdealGraphVisualizer.", GraalDebugConfig.Options.class, "PrintIdealGraph", GraalDebugConfig.Options.PrintIdealGraph);
            case "PrintIdealGraphAddress": return OptionDescriptor.create("PrintIdealGraphAddress", String.class, "", GraalDebugConfig.Options.class, "PrintIdealGraphAddress", GraalDebugConfig.Options.PrintIdealGraphAddress);
            case "PrintIdealGraphFile": return OptionDescriptor.create("PrintIdealGraphFile", Boolean.class, "Print Ideal graphs as opposed to sending them over the network.", GraalDebugConfig.Options.class, "PrintIdealGraphFile", GraalDebugConfig.Options.PrintIdealGraphFile);
            case "PrintIdealGraphFileName": return OptionDescriptor.create("PrintIdealGraphFileName", String.class, "Base filename when dumping Ideal graphs to files.", GraalDebugConfig.Options.class, "PrintIdealGraphFileName", GraalDebugConfig.Options.PrintIdealGraphFileName);
            case "PrintIdealGraphPort": return OptionDescriptor.create("PrintIdealGraphPort", Integer.class, "", GraalDebugConfig.Options.class, "PrintIdealGraphPort", GraalDebugConfig.Options.PrintIdealGraphPort);
            case "PrintIdealGraphSchedule": return OptionDescriptor.create("PrintIdealGraphSchedule", Boolean.class, "", GraalDebugConfig.Options.class, "PrintIdealGraphSchedule", GraalDebugConfig.Options.PrintIdealGraphSchedule);
            case "PrintTruffleTrees": return OptionDescriptor.create("PrintTruffleTrees", Boolean.class, "Enable dumping Truffle ASTs to the IdealGraphVisualizer.", GraalDebugConfig.Options.class, "PrintTruffleTrees", GraalDebugConfig.Options.PrintTruffleTrees);
            case "SuppressZeroDebugValues": return OptionDescriptor.create("SuppressZeroDebugValues", Boolean.class, "Omit reporting 0-value counters", GraalDebugConfig.Options.class, "SuppressZeroDebugValues", GraalDebugConfig.Options.SuppressZeroDebugValues);
            case "Time": return OptionDescriptor.create("Time", String.class, "Pattern for scope(s) in which timing is enabled (see DebugFilter and Debug.timer). An empty value enables all timers unconditionally.", GraalDebugConfig.Options.class, "Time", GraalDebugConfig.Options.Time);
            case "TrackMemUse": return OptionDescriptor.create("TrackMemUse", String.class, "Pattern for scope(s) in which memory use tracking is enabled (see DebugFilter and Debug.counter). An empty value enables all memory use trackers unconditionally.", GraalDebugConfig.Options.class, "TrackMemUse", GraalDebugConfig.Options.TrackMemUse);
            case "Verify": return OptionDescriptor.create("Verify", String.class, "Pattern for scope(s) in which verification is enabled (see DebugFilter and Debug.verify).", GraalDebugConfig.Options.class, "Verify", GraalDebugConfig.Options.Verify);
        }
        // CheckStyle: resume line length check
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        // CheckStyle: stop line length check
        List<OptionDescriptor> options = Arrays.asList(
            OptionDescriptor.create("BootstrapInitializeOnly", Boolean.class, "Do not compile anything on bootstrap but just initialize the compiler.", GraalDebugConfig.Options.class, "BootstrapInitializeOnly", GraalDebugConfig.Options.BootstrapInitializeOnly),
            OptionDescriptor.create("CanonicalGraphStringsCheckConstants", Boolean.class, "Exclude virtual nodes when dumping canonical text for graphs.", GraalDebugConfig.Options.class, "CanonicalGraphStringsCheckConstants", GraalDebugConfig.Options.CanonicalGraphStringsCheckConstants),
            OptionDescriptor.create("CanonicalGraphStringsExcludeVirtuals", Boolean.class, "Exclude virtual nodes when dumping canonical text for graphs.", GraalDebugConfig.Options.class, "CanonicalGraphStringsExcludeVirtuals", GraalDebugConfig.Options.CanonicalGraphStringsExcludeVirtuals),
            OptionDescriptor.create("CanonicalGraphStringsRemoveIdentities", Boolean.class, "Attempts to remove object identity hashes when dumping canonical text for graphs.", GraalDebugConfig.Options.class, "CanonicalGraphStringsRemoveIdentities", GraalDebugConfig.Options.CanonicalGraphStringsRemoveIdentities),
            OptionDescriptor.create("ClearMetricsAfterBootstrap", Boolean.class, "Clear the debug metrics after bootstrap.", GraalDebugConfig.Options.class, "ClearMetricsAfterBootstrap", GraalDebugConfig.Options.ClearMetricsAfterBootstrap),
            OptionDescriptor.create("Count", String.class, "Pattern for scope(s) in which counting is enabled (see DebugFilter and Debug.counter). An empty value enables all counters unconditionally.", GraalDebugConfig.Options.class, "Count", GraalDebugConfig.Options.Count),
            OptionDescriptor.create("DebugValueFile", String.class, "Write debug values into a file instead of the terminal. If DebugValueSummary is Thread, the thread name will be prepended.", GraalDebugConfig.Options.class, "DebugValueFile", GraalDebugConfig.Options.DebugValueFile),
            OptionDescriptor.create("DebugValueHumanReadable", Boolean.class, "Print counters and timers in a human readable form.", GraalDebugConfig.Options.class, "DebugValueHumanReadable", GraalDebugConfig.Options.DebugValueHumanReadable),
            OptionDescriptor.create("DebugValueSummary", String.class, "How to print counters and timing values:%nName - aggregate by unqualified name%nPartial - aggregate by partially qualified name (e.g., A.B.C.D.Counter and X.Y.Z.D.Counter will be merged to D.Counter)%nComplete - aggregate by qualified name%nThread - aggregate by qualified name and thread", GraalDebugConfig.Options.class, "DebugValueSummary", GraalDebugConfig.Options.DebugValueSummary),
            OptionDescriptor.create("DebugValueThreadFilter", String.class, "Only report debug values for maps which match the regular expression.", GraalDebugConfig.Options.class, "DebugValueThreadFilter", GraalDebugConfig.Options.DebugValueThreadFilter),
            OptionDescriptor.create("Dump", String.class, "Pattern for scope(s) in which dumping is enabled (see DebugFilter and Debug.dump)", GraalDebugConfig.Options.class, "Dump", GraalDebugConfig.Options.Dump),
            OptionDescriptor.create("DumpOnError", Boolean.class, "Send Graal compiler IR to dump handlers on error", GraalDebugConfig.Options.class, "DumpOnError", GraalDebugConfig.Options.DumpOnError),
            OptionDescriptor.create("DumpPath", String.class, "The directory where various Graal dump files are written.", GraalDebugConfig.Options.class, "DumpPath", GraalDebugConfig.Options.DumpPath),
            OptionDescriptor.create("ForceDebugEnable", Boolean.class, "Force-enable debug code paths", GraalDebugConfig.Options.class, "ForceDebugEnable", GraalDebugConfig.Options.ForceDebugEnable),
            OptionDescriptor.create("GlobalMetricsInterceptedByMethodMetrics", String.class, "If a global metric (DebugTimer, DebugCounter or DebugMemUseTracker) is enabled in the same scope as a method metric, use the global metric to update the method metric for the current compilation. This option enables the re-use of global metrics on per-compilation basis. Whenever a value is added to a global metric, the value is also added to a MethodMetric under the same name as the global metric. This option incurs a small but constant overhead due to the context method lookup at each metric update. Format to specify GlobalMetric interception:(Timers|Counters|MemUseTrackers)(,Timers|,Counters|,MemUseTrackers)*", GraalDebugConfig.Options.class, "GlobalMetricsInterceptedByMethodMetrics", GraalDebugConfig.Options.GlobalMetricsInterceptedByMethodMetrics),
            OptionDescriptor.create("InterceptBailout", Boolean.class, "Intercept also bailout exceptions", GraalDebugConfig.Options.class, "InterceptBailout", GraalDebugConfig.Options.InterceptBailout),
            OptionDescriptor.create("Log", String.class, "Pattern for scope(s) in which logging is enabled (see DebugFilter and Debug.log)", GraalDebugConfig.Options.class, "Log", GraalDebugConfig.Options.Log),
            OptionDescriptor.create("LogVerbose", Boolean.class, "Enable more verbose log output when available", GraalDebugConfig.Options.class, "LogVerbose", GraalDebugConfig.Options.LogVerbose),
            OptionDescriptor.create("MethodFilter", String.class, "Pattern for filtering debug scope output based on method context (see MethodFilter)", GraalDebugConfig.Options.class, "MethodFilter", GraalDebugConfig.Options.MethodFilter),
            OptionDescriptor.create("MethodFilterRootOnly", Boolean.class, "Only check MethodFilter against the root method in the context if true, otherwise check all methods", GraalDebugConfig.Options.class, "MethodFilterRootOnly", GraalDebugConfig.Options.MethodFilterRootOnly),
            OptionDescriptor.create("MethodMeter", String.class, "Enable per method metrics that are collected across all compilations of a method.Pattern for scope(s) in which method metering is enabled (see DebugFilter and Debug.metric).", GraalDebugConfig.Options.class, "MethodMeter", GraalDebugConfig.Options.MethodMeter),
            OptionDescriptor.create("PrintBackendCFG", Boolean.class, "Enable dumping LIR, register allocation and code generation info to the C1Visualizer.", GraalDebugConfig.Options.class, "PrintBackendCFG", GraalDebugConfig.Options.PrintBackendCFG),
            OptionDescriptor.create("PrintBinaryGraphPort", Integer.class, "", GraalDebugConfig.Options.class, "PrintBinaryGraphPort", GraalDebugConfig.Options.PrintBinaryGraphPort),
            OptionDescriptor.create("PrintBinaryGraphs", Boolean.class, "Dump IdealGraphVisualizer output in binary format", GraalDebugConfig.Options.class, "PrintBinaryGraphs", GraalDebugConfig.Options.PrintBinaryGraphs),
            OptionDescriptor.create("PrintCFG", Boolean.class, "Enable dumping to the C1Visualizer. Enabling this option implies PrintBackendCFG.", GraalDebugConfig.Options.class, "PrintCFG", GraalDebugConfig.Options.PrintCFG),
            OptionDescriptor.create("PrintCFGFileName", String.class, "Base filename when dumping C1Visualizer output to files.", GraalDebugConfig.Options.class, "PrintCFGFileName", GraalDebugConfig.Options.PrintCFGFileName),
            OptionDescriptor.create("PrintCanonicalGraphStringFlavor", Integer.class, "Choose format used when dumping canonical text for graphs: 0 gives a scheduled graph (better for spotting changes involving the schedule)while 1 gives a CFG containing expressions rooted at fixed nodes (better for spotting small structure differences)", GraalDebugConfig.Options.class, "PrintCanonicalGraphStringFlavor", GraalDebugConfig.Options.PrintCanonicalGraphStringFlavor),
            OptionDescriptor.create("PrintCanonicalGraphStrings", Boolean.class, "Enable dumping canonical text from for graphs.", GraalDebugConfig.Options.class, "PrintCanonicalGraphStrings", GraalDebugConfig.Options.PrintCanonicalGraphStrings),
            OptionDescriptor.create("PrintCanonicalGraphStringsDirectory", String.class, "Base directory when dumping graphs strings to files.", GraalDebugConfig.Options.class, "PrintCanonicalGraphStringsDirectory", GraalDebugConfig.Options.PrintCanonicalGraphStringsDirectory),
            OptionDescriptor.create("PrintGraphProbabilities", Boolean.class, "Output probabilities for fixed nodes during binary graph dumping", GraalDebugConfig.Options.class, "PrintGraphProbabilities", GraalDebugConfig.Options.PrintGraphProbabilities),
            OptionDescriptor.create("PrintIdealGraph", Boolean.class, "Enable dumping to the IdealGraphVisualizer.", GraalDebugConfig.Options.class, "PrintIdealGraph", GraalDebugConfig.Options.PrintIdealGraph),
            OptionDescriptor.create("PrintIdealGraphAddress", String.class, "", GraalDebugConfig.Options.class, "PrintIdealGraphAddress", GraalDebugConfig.Options.PrintIdealGraphAddress),
            OptionDescriptor.create("PrintIdealGraphFile", Boolean.class, "Print Ideal graphs as opposed to sending them over the network.", GraalDebugConfig.Options.class, "PrintIdealGraphFile", GraalDebugConfig.Options.PrintIdealGraphFile),
            OptionDescriptor.create("PrintIdealGraphFileName", String.class, "Base filename when dumping Ideal graphs to files.", GraalDebugConfig.Options.class, "PrintIdealGraphFileName", GraalDebugConfig.Options.PrintIdealGraphFileName),
            OptionDescriptor.create("PrintIdealGraphPort", Integer.class, "", GraalDebugConfig.Options.class, "PrintIdealGraphPort", GraalDebugConfig.Options.PrintIdealGraphPort),
            OptionDescriptor.create("PrintIdealGraphSchedule", Boolean.class, "", GraalDebugConfig.Options.class, "PrintIdealGraphSchedule", GraalDebugConfig.Options.PrintIdealGraphSchedule),
            OptionDescriptor.create("PrintTruffleTrees", Boolean.class, "Enable dumping Truffle ASTs to the IdealGraphVisualizer.", GraalDebugConfig.Options.class, "PrintTruffleTrees", GraalDebugConfig.Options.PrintTruffleTrees),
            OptionDescriptor.create("SuppressZeroDebugValues", Boolean.class, "Omit reporting 0-value counters", GraalDebugConfig.Options.class, "SuppressZeroDebugValues", GraalDebugConfig.Options.SuppressZeroDebugValues),
            OptionDescriptor.create("Time", String.class, "Pattern for scope(s) in which timing is enabled (see DebugFilter and Debug.timer). An empty value enables all timers unconditionally.", GraalDebugConfig.Options.class, "Time", GraalDebugConfig.Options.Time),
            OptionDescriptor.create("TrackMemUse", String.class, "Pattern for scope(s) in which memory use tracking is enabled (see DebugFilter and Debug.counter). An empty value enables all memory use trackers unconditionally.", GraalDebugConfig.Options.class, "TrackMemUse", GraalDebugConfig.Options.TrackMemUse),
            OptionDescriptor.create("Verify", String.class, "Pattern for scope(s) in which verification is enabled (see DebugFilter and Debug.verify).", GraalDebugConfig.Options.class, "Verify", GraalDebugConfig.Options.Verify)
        );
        // CheckStyle: resume line length check
        return options.iterator();
    }
}
