/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxSet;
import netrexx.lang.RexxTrace;
import org.netrexx.process.NrAssign;
import org.netrexx.process.NrBlock;
import org.netrexx.process.NrCatch;
import org.netrexx.process.NrEnd;
import org.netrexx.process.NrIf;
import org.netrexx.process.NrLevel;
import org.netrexx.process.NrLoop;
import org.netrexx.process.NrNumeric;
import org.netrexx.process.NrTrace;
import org.netrexx.process.RxArray;
import org.netrexx.process.RxClass;
import org.netrexx.process.RxClassInfo;
import org.netrexx.process.RxClause;
import org.netrexx.process.RxClauseParser;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxField;
import org.netrexx.process.RxMethod;
import org.netrexx.process.RxProgram;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxSignal;
import org.netrexx.process.RxSignalPend;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;
import org.netrexx.process.RxVariable;

public class RxInterpreter {
    private static final Rexx $01 = Rexx.toRexx(">> iarge:");
    private static final String $0 = "RxInterpreter.nrx";
    RxTranslator rxt;
    private static final Integer int0 = new Integer(0);
    private static final Long long0 = new Long(0L);
    private static final Double dub0 = new Double(0.0);
    private static final Rexx char0 = new Rexx('\u0000');
    private static final RxClause nojump = new RxClause();

    public RxInterpreter(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
    }

    private void initializeProperties(RxClass rxClass, Object object) {
        String string = null;
        int n = 0;
        NrNumeric nrNumeric = null;
        NrTrace nrTrace = null;
        RxClauseParser rxClauseParser = null;
        boolean bl = false;
        if (rxClass.classclauses == null && rxClass.classprogram.pendtrace.size() == 0 && rxClass.classprogram.pendnumeric.size() == 0) {
            return;
        }
        boolean bl2 = object == null;
        RxCursor rxCursor = new RxCursor(rxClass.classprogram, rxClass, null, null);
        rxCursor.curexec = true;
        rxCursor.curbinary = rxClass.classbinary;
        rxCursor.curstatic = bl2;
        rxCursor.curthis = object;
        RxProgram rxProgram = rxCursor.curprogram;
        if (rxProgram.flag.diag) {
            string = bl2 ? "static" : "instance";
            RexxIO.Say(Rexx.toRexx("# " + string + " " + "Initialize class:").OpCcblank(null, rxClass.classname));
        }
        int n2 = rxProgram.pendnumeric.size();
        n = 0;
        while (n2 > 0) {
            rxCursor.curclause = (RxClause)rxProgram.pendnumeric.elementAt(n);
            nrNumeric = (NrNumeric)rxCursor.curclause.lookaside;
            nrNumeric.interpret(rxCursor);
            --n2;
            ++n;
        }
        if (rxCursor.curstatic) {
            n2 = rxProgram.pendtrace.size();
            n = 0;
            while (n2 > 0) {
                rxCursor.curclause = (RxClause)rxProgram.pendtrace.elementAt(n);
                nrTrace = (NrTrace)rxCursor.curclause.lookaside;
                nrTrace.interpret(rxCursor);
                --n2;
                ++n;
            }
        }
        RxClause rxClause = rxClass.classclauses;
        rxCursor.curpropatts = rxClass.classpropatts;
        while (rxClause != null) {
            rxCursor.curclause = rxClause;
            if (rxClause.lookaside != null && !((rxClauseParser = rxClause.lookaside) instanceof NrAssign ? (bl = (rxCursor.curpropatts & 0x300) != 0) != bl2 : rxClauseParser instanceof NrTrace && !bl2)) {
                rxClauseParser.interpret(rxCursor);
            }
            rxClause = rxClause.next;
        }
    }

    public Object initvalue(RxType rxType) {
        if (rxType.isPrimitive()) {
            if (rxType.equals(RxType.INT_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.BOOL_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.LONG_TYPE)) {
                return long0;
            }
            if (rxType.equals(RxType.DOUBLE_TYPE)) {
                return dub0;
            }
            if (rxType.equals(RxType.BYTE_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.SHORT_TYPE)) {
                return int0;
            }
            if (rxType.equals(RxType.FLOAT_TYPE)) {
                return dub0;
            }
            if (rxType.equals(RxType.CHAR_TYPE)) {
                return char0;
            }
            throw new NoOtherwiseException();
        }
        return null;
    }

    public String stringvalue(RxCode rxCode) {
        if (rxCode.value == null) {
            return null;
        }
        if (rxCode.type.isPrimitive()) {
            if (rxCode.type.equals(RxType.INT_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.BOOL_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.LONG_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.DOUBLE_TYPE)) {
                return rxCode.value.toString();
            }
            if (rxCode.type.equals(RxType.BYTE_TYPE)) {
                return String.valueOf(((Integer)rxCode.value).byteValue());
            }
            if (rxCode.type.equals(RxType.SHORT_TYPE)) {
                return String.valueOf(((Integer)rxCode.value).shortValue());
            }
            if (rxCode.type.equals(RxType.FLOAT_TYPE)) {
                return String.valueOf(((Double)rxCode.value).floatValue());
            }
            if (rxCode.type.equals(RxType.CHAR_TYPE)) {
                return rxCode.value.toString();
            }
            throw new NoOtherwiseException();
        }
        if (rxCode.value instanceof char[]) {
            return new String((char[])rxCode.value);
        }
        return rxCode.value.toString();
    }

    public int signvalue(RxCode rxCode) {
        char c = '\u0000';
        if (rxCode.value == null) {
            throw new NullPointerException("numeric value null");
        }
        if (rxCode.type.equals(RxType.INT_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.BYTE_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.SHORT_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.BOOL_TYPE)) {
            return (Integer)rxCode.value;
        }
        if (rxCode.type.equals(RxType.LONG_TYPE)) {
            return ((Long)rxCode.value).compareTo(long0);
        }
        if (rxCode.type.equals(RxType.DOUBLE_TYPE)) {
            return ((Double)rxCode.value).compareTo(dub0);
        }
        if (rxCode.type.equals(RxType.FLOAT_TYPE)) {
            return ((Double)rxCode.value).compareTo(dub0);
        }
        if (rxCode.type.equals(RxType.CHAR_TYPE)) {
            c = ((Rexx)rxCode.value).tochar();
            if (c == '0') {
                return 0;
            }
            if (c > '0' && c <= '9') {
                return 1;
            }
            throw new NumberFormatException(String.valueOf(c));
        }
        if (rxCode.type.equals(RxType.REXX_TYPE)) {
            return ((Rexx)rxCode.value).sign().toint();
        }
        throw new NumberFormatException(rxCode.value.toString());
    }

    private void setupArgs(RxType[] rxTypeArray, Object[] objectArray, Class[] classArray, Object[] objectArray2, RxType rxType, Object object) {
        int n = 0;
        int n2 = 0;
        RxType rxType2 = null;
        if (rxType == null) {
            n = 0;
        } else {
            n = 1;
            classArray[0] = rxType.getClassObject(this.rxt.loader);
            objectArray2[0] = this.code2ref(object, rxType);
        }
        int n3 = objectArray.length;
        n2 = 0;
        while (n3 > 0) {
            rxType2 = rxTypeArray[n2];
            classArray[n2 + n] = rxType2.getClassObject(this.rxt.loader);
            objectArray2[n2 + n] = this.code2ref(objectArray[n2], rxType2);
            --n3;
            ++n2;
        }
    }

    public Object code2ref(Object object, RxType rxType) {
        if (rxType.isPrimitive() && !rxType.equals(RxType.INT_TYPE) && !rxType.equals(RxType.LONG_TYPE) && !rxType.equals(RxType.DOUBLE_TYPE)) {
            if (rxType.equals(RxType.BYTE_TYPE)) {
                object = new Byte(((Integer)object).byteValue());
            } else if (rxType.equals(RxType.SHORT_TYPE)) {
                object = new Short(((Integer)object).shortValue());
            } else if (rxType.equals(RxType.FLOAT_TYPE)) {
                object = new Float(((Number)object).floatValue());
            } else if (rxType.equals(RxType.BOOL_TYPE)) {
                object = new Boolean((Integer)object == 1);
            } else if (rxType.equals(RxType.CHAR_TYPE)) {
                object = new Character(((Rexx)object).tochar());
            } else {
                throw new NoOtherwiseException();
            }
        }
        return object;
    }

    public Object ref2code(Object object, RxType rxType) {
        if (rxType.isPrimitive() && !rxType.equals(RxType.INT_TYPE) && !rxType.equals(RxType.LONG_TYPE) && !rxType.equals(RxType.DOUBLE_TYPE)) {
            if (rxType.equals(RxType.BYTE_TYPE)) {
                object = new Integer(((Byte)object).byteValue());
            } else if (rxType.equals(RxType.SHORT_TYPE)) {
                object = new Integer(((Short)object).shortValue());
            } else if (rxType.equals(RxType.FLOAT_TYPE)) {
                object = new Double(((Float)object).floatValue());
            } else if (rxType.equals(RxType.BOOL_TYPE)) {
                object = ((Boolean)object).booleanValue() ? new Integer(1) : new Integer(0);
            } else if (rxType.equals(RxType.CHAR_TYPE)) {
                object = new Rexx(((Character)object).charValue());
            } else {
                throw new NoOtherwiseException();
            }
        }
        return object;
    }

    public Object getArrayElementValue(RxCursor rxCursor, Object object, RxType rxType, RxArray rxArray, RxToken rxToken) {
        int n = 0;
        int n2 = 0;
        RxType rxType2 = null;
        ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = null;
        if (object == null) {
            throw new NullPointerException("null array reference");
        }
        int n3 = rxArray.arraydim - 1;
        try {
            int n4 = rxArray.arraydim;
            n = 0;
            while (n4 > 0) {
                n2 = (Integer)rxArray.arraycode[n].value;
                object = Array.get(object, n2);
                if (n3 == 0) {
                    rxType2 = rxType.basetype(rxType.dimension - rxArray.arraydim);
                    object = this.ref2code(object, rxType2);
                }
                --n3;
                --n4;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
            arrayIndexOutOfBoundsException = arrayIndexOutOfBoundsException2;
            throw new RxSignal(rxCursor, arrayIndexOutOfBoundsException, rxToken);
        }
        return object;
    }

    public void setArrayElementValue(RxCursor rxCursor, Object object, RxType rxType, RxArray rxArray, RxToken rxToken, Object object2) {
        int n = 0;
        int n2 = 0;
        ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = null;
        if (object == null) {
            throw new NullPointerException("null array reference");
        }
        int n3 = rxArray.arraydim - 1;
        try {
            int n4 = rxArray.arraydim;
            n = 0;
            while (n4 > 0) {
                n2 = (Integer)rxArray.arraycode[n].value;
                if (n3 > 0) {
                    object = Array.get(object, n2);
                } else {
                    object2 = this.code2ref(object2, rxType);
                    Array.set(object, n2, object2);
                }
                --n3;
                --n4;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
            arrayIndexOutOfBoundsException = arrayIndexOutOfBoundsException2;
            throw new RxSignal(rxCursor, arrayIndexOutOfBoundsException, rxToken);
        }
    }

    public Rexx getStemElementValue(RxCursor rxCursor, Rexx rexx, RxArray rxArray, RxToken rxToken) {
        int n = 0;
        Rexx rexx2 = null;
        if (rexx == null) {
            throw new RxSignal(rxCursor, new NullPointerException(), rxToken);
        }
        int n2 = rxArray.arraydim;
        n = 0;
        while (n2 > 0) {
            rexx2 = (Rexx)rxArray.arraycode[n].value;
            rexx = rexx.getnode((Rexx)rexx2).leaf;
            --n2;
            ++n;
        }
        return rexx;
    }

    public void setStemElementValue(RxCursor rxCursor, Rexx rexx, RxArray rxArray, RxToken rxToken, Rexx rexx2) {
        int n;
        int n2 = 0;
        Rexx rexx3 = null;
        if (rexx == null) {
            throw new RxSignal(rxCursor, new NullPointerException(), rxToken);
        }
        int n3 = n = rxArray.arraydim - 1;
        n2 = 0;
        while (n2 <= n3) {
            rexx3 = (Rexx)rxArray.arraycode[n2].value;
            if (n2 < n) {
                rexx = rexx.getnode((Rexx)rexx3).leaf;
            } else {
                rexx.getnode((Rexx)rexx3).leaf = rexx2;
            }
            ++n2;
        }
    }

    public Object getVar(RxCursor rxCursor, RxVariable rxVariable, RxToken rxToken) {
        if ((rxVariable.varatts & 4) == 0) {
            return rxVariable.varvalue;
        }
        return this.getProperty(rxCursor.curthis, rxVariable.varfield, rxToken);
    }

    public void setVar(RxCursor rxCursor, RxVariable rxVariable, RxToken rxToken, Object object) {
        if ((rxVariable.varatts & 4) == 0) {
            rxVariable.varvalue = object;
            return;
        }
        this.setProperty(rxCursor.curthis, rxVariable.varfield, rxToken, object);
    }

    public Object getProperty(Object object, RxField rxField, RxToken rxToken) {
        return this.doProperty(object, rxField, rxToken, false, null);
    }

    public void setProperty(Object object, RxField rxField, RxToken rxToken, Object object2) {
        this.doProperty(object, rxField, rxToken, true, object2);
    }

    private Object doProperty(Object object, RxField rxField, RxToken rxToken, boolean bl, Object object2) {
        Field field = null;
        Field field2 = null;
        int n = 0;
        Object object3 = null;
        IllegalAccessException illegalAccessException = null;
        SecurityException securityException = null;
        IllegalArgumentException illegalArgumentException = null;
        Class clazz = rxField.fieldinfo.getClassObject(this.rxt.loader);
        try {
            field = clazz.getDeclaredField(Rexx.toString(rxField.fieldname));
            field.setAccessible(true);
            if (bl) {
                object2 = this.code2ref(object2, rxField.fieldtype);
                field2 = field.getClass().getDeclaredField("modifiers");
                field2.setAccessible(true);
                n = field.getModifiers();
                if (Modifier.isFinal(n)) {
                    field2.setInt(field, n - 16);
                }
                field.set(object, object2);
                if (Modifier.isFinal(n)) {
                    field2.setInt(field, n);
                }
                object3 = null;
            } else {
                object3 = field.get(object);
                object3 = this.ref2code(object3, rxField.fieldtype);
            }
        }
        catch (IllegalAccessException illegalAccessException2) {
            illegalAccessException = illegalAccessException2;
            throw new RxSignalPend(illegalAccessException, rxToken);
        }
        catch (SecurityException securityException2) {
            securityException = securityException2;
            throw new RxSignalPend(securityException, rxToken);
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
            throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxInterpreter: pia " + illegalArgumentException.getMessage()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RxQuit(this.rxt, rxToken, "internal.error", Rexx.toRexx("RxInterpreter: pnf"));
        }
        return object3;
    }

    public void proxyInit(int n) {
        RxClassInfo rxClassInfo = this.rxt.classer.findclassbyid(n);
        RxClass rxClass = rxClassInfo.localclass;
        this.initializeProperties(rxClass, null);
    }

    public Object callMethod(Object object, int n, Object[] objectArray) {
        boolean bl = false;
        Object object2 = null;
        RxSignal rxSignal = null;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        RxField rxField = this.rxt.classer.findfieldbyid(n);
        if (rxField.fieldtype.equals(RxType.VOID_TYPE)) {
            try {
                object2 = this.callMethod(object, rxField, objectArray, null, bl, true);
                return object2;
            }
            catch (RxSignal rxSignal2) {
                rxSignal = rxSignal2;
                if (rxSignal.signalobj == null) {
                    return null;
                }
                throw rxSignal;
            }
        }
        return this.callMethod(object, rxField, objectArray, null, bl, true);
    }

    public Object callMethod(Object object, RxField rxField, RxCode[] rxCodeArray, RxToken rxToken) {
        int n = 0;
        Object[] objectArray = new Object[rxCodeArray.length];
        int n2 = rxCodeArray.length;
        n = 0;
        while (n2 > 0) {
            objectArray[n] = rxCodeArray[n].value;
            --n2;
            ++n;
        }
        return this.callMethod(object, rxField, objectArray, rxToken, false, false);
    }

    /*
     * Unable to fully structure code
     */
    public Object callMethod(Object var1_1, RxField var2_2, Object[] var3_3, RxToken var4_4, boolean var5_5, boolean var6_6) {
        var9_7 = null;
        var10_8 = null;
        var11_9 = null;
        var12_10 = null;
        var13_11 = null;
        var14_12 = null;
        var15_13 = null;
        var16_14 = 0;
        var17_15 = null;
        var18_16 = null;
        var19_17 = null;
        var20_18 = 0;
        var24_19 = null;
        var25_20 = null;
        var26_21 = 0;
        var27_22 = null;
        var31_23 = null;
        var32_24 = null;
        var34_25 = null;
        var35_26 = null;
        var36_27 = null;
        var38_28 = null;
        var39_29 = null;
        var7_30 = var2_2.isConstructor();
        var8_31 = (RxMethod)var2_2.fieldlocal;
        if (var8_31 == null || var7_30 & var6_6 == false) {
            block46: {
                var9_7 = var2_2.fieldinfo.getClassObject(this.rxt.loader);
                try {
                    if (var7_30) {
                        if (var2_2.fieldinfo.isdependent) {
                            var10_8 = new Class[var3_3.length + 1];
                            var11_9 = new Object[var3_3.length + 1];
                            this.setupArgs(var2_2.fieldargtypes, var3_3, var10_8, var11_9, var2_2.fieldinfo.parentinfo.type, var1_1);
                        } else {
                            var10_8 = new Class[var3_3.length];
                            var11_9 = new Object[var3_3.length];
                            this.setupArgs(var2_2.fieldargtypes, var3_3, var10_8, var11_9, null, null);
                        }
                        var12_10 = var9_7.getDeclaredConstructor(var10_8);
                        var12_10.setAccessible(true);
                        var13_11 = var12_10.newInstance(var11_9);
                    } else {
                        var10_8 = new Class[var3_3.length];
                        var11_9 = new Object[var3_3.length];
                        this.setupArgs(var2_2.fieldargtypes, var3_3, var10_8, var11_9, null, null);
                        var14_12 = var9_7.getDeclaredMethod(Rexx.toString(var2_2.fieldname), var10_8);
                        var14_12.setAccessible(true);
                        var13_11 = var14_12.invoke(var1_1, var11_9);
                        var13_11 = this.ref2code(var13_11, var2_2.fieldtype);
                    }
                    break block46;
                }
                catch (IllegalArgumentException var40_32) {
                    var15_13 = var40_32;
                    RexxIO.Say(RxInterpreter.$01.OpCcblank(null, var2_2.fieldname).OpCcblank(null, new Rexx(var1_1 == null)).OpCcblank(null, Rexx.toRexx(var15_13.getMessage())));
                    var41_38 = var3_3.length;
                    var16_14 = 0;
                    ** while (var41_38 > 0)
                }
lbl-1000:
                // 1 sources

                {
                    RexxIO.Say("  Type: " + var10_8[var16_14].toString() + " " + "VType:" + " " + var11_9[var16_14].getClass().toString() + " " + "Value:" + " " + var11_9[var16_14].toString());
                    --var41_38;
                    ++var16_14;
                    continue;
                }
lbl62:
                // 1 sources

                throw new RxQuit(this.rxt, var4_4, "internal.error", Rexx.toRexx("RxInterpreter: iarge"));
                catch (InvocationTargetException var40_33) {
                    var17_15 = var40_33;
                    throw new RxSignalPend(var17_15.getTargetException(), var4_4);
                }
                catch (IllegalAccessException var40_34) {
                    var18_16 = var40_34;
                    throw new RxSignalPend(var18_16, var4_4);
                }
                catch (SecurityException var40_35) {
                    var19_17 = var40_35;
                    throw new RxSignalPend(var19_17, var4_4);
                }
                catch (InstantiationException v0) {
                    throw new RxQuit(this.rxt, var4_4, "internal.error", Rexx.toRexx("RxInterpreter: cie"));
                }
                catch (NoSuchMethodException v1) {
                    RexxIO.Say("Field: " + var2_2.toConciseString(var2_2.fieldprogram));
                    var40_36 = var10_8.length;
                    var20_18 = 0;
                    ** while (var40_36 > 0)
                }
lbl-1000:
                // 1 sources

                {
                    RexxIO.Say("     : " + var10_8[var20_18].getName());
                    --var40_36;
                    ++var20_18;
                    continue;
                }
lbl85:
                // 1 sources

                throw new RxQuit(this.rxt, var4_4, "internal.error", Rexx.toRexx("RxInterpreter: mnf"));
            }
            return var13_11;
        }
        this.rxt.program = var8_31.methodprogram;
        var21_39 = var2_2.fieldinfo;
        var22_40 = var21_39.localclass;
        var23_41 = new RxCursor(var22_40.classprogram, var22_40, var8_31, var8_31.methodclause);
        var23_41.curbinary = var8_31.methodbinary;
        var23_41.curprecall = var5_5;
        var23_41.curexec = true;
        var23_41.curthis = var1_1;
        if (this.rxt.exiting) {
            throw new RxSignal(var23_41, null, null);
        }
        if (!var21_39.initialized) {
            var21_39.getClassObject(this.rxt.loader);
        }
        if (this.rxt.superflag.diag) {
            if (var7_30) {
                var24_19 = "constructor";
                var24_19 = var5_5 ? String.valueOf(var24_19) + " " + "precall" : String.valueOf(var24_19) + " " + "body";
            } else {
                var24_19 = var8_31.methodstatic != false ? "function" : "method";
            }
            RexxIO.Say(Rexx.toRexx("# -> invoke " + var24_19 + ":").OpCcblank(null, var8_31.methodname).OpCcblank(null, new Rexx(var1_1 == null)).OpCcblank(null, new Rexx(var8_31.methodprotected)));
        }
        if (var7_30) {
            if (!var5_5) {
                this.initializeProperties(var22_40, var1_1);
                if (var8_31.methodhadthissuper) {
                    var23_41.curskipone = true;
                    var25_20 = var2_2.fieldspecial;
                    var26_21 = var25_20.fieldargtypes.length;
                    if (var26_21 > 0) {
                        var23_41.curskiptrace = true;
                    }
                }
            } else {
                var23_41.curparent = var1_1;
                var23_41.curthis = null;
            }
        }
        var23_41.curnumer = var8_31.methodhadnumeric == false ? var23_41.curclass.classrunnumer : (var23_41.curclass.classrunnumer == null ? new RexxSet() : new RexxSet(var23_41.curclass.classrunnumer));
        if (!var8_31.methodtracechange) {
            var23_41.curtrace = var23_41.curclass.classruntrace;
        } else if (var23_41.curclass.classruntrace == null) {
            var27_22 = var23_41.curprogram.flag.trace == 1 ? System.out : System.err;
            var23_41.curtrace = new RexxTrace(var23_41.curprogram.source.getLineCount(), var27_22, var23_41.curprogram.source.getName());
        } else {
            var23_41.curtrace = new RexxTrace(var23_41.curclass.classruntrace);
        }
        if (!(var23_41.curtrace == null || var8_31.methoddefault || var8_31.methodsynthetic || var23_41.curskiptrace)) {
            var23_41.curtrace.traceclause(var8_31.methodclause.tokens[0].line, var8_31.methodclause.tracelines(this.rxt), 2, null);
        }
        var28_42 = var8_31.methodprotopool.size() * 7 / 4;
        var23_41.curlpool = new Hashtable<K, V>(var28_42);
        var29_43 = var8_31.methodprotopool.elements();
        var30_44 = var8_31.methodprotopool.keys();
        while (var29_43.hasMoreElements()) {
            var31_23 = (RxVariable)var29_43.nextElement();
            var31_23 = var31_23.copy();
            var31_23.varvalue = this.initvalue(var31_23.vartype);
            var32_24 = (String)var30_44.nextElement();
            var23_41.curlpool.put(var32_24, var31_23);
        }
        var33_45 = var8_31.methodargvars;
        var40_37 = var33_45.length;
        var16_14 = 0;
        while (var40_37 > 0) {
            var31_23 = var23_41.curprogram.pooler.refindvar(var23_41, var33_45[var16_14].varname);
            if (var16_14 < var3_3.length) {
                var31_23.varvalue = var3_3[var16_14];
                if (var31_23.varmain) {
                    var31_23.varvalue = new Rexx((String[])var31_23.varvalue);
                }
            } else {
                var34_25 = var8_31.methodargcode[var16_14];
                if (!var34_25.constant || var23_41.curtrace != null) {
                    var34_25 = this.rxt.eparser.evalexpr(var23_41, false, var34_25.begoff, RxMethod.methodargends.toCharArray(), null, '\u0000', null);
                }
                var31_23.varvalue = var34_25.value;
            }
            if (!(var23_41.curtrace == null || var31_23.varmain || var23_41.curskiptrace || var8_31.methodsynthetic)) {
                if (var16_14 < var3_3.length) {
                    var34_25 = new RxCode('G', var31_23.vartype, null);
                    var34_25.value = var31_23.varvalue;
                }
                var35_26 = this.stringvalue(var34_25);
                var36_27 = "m";
                var23_41.curtrace.traceString(var8_31.methodclause.tokens[0].line, var35_26, Rexx.tochar(var36_27), 2, Rexx.toString(var31_23.varname));
            }
            --var40_37;
            ++var16_14;
        }
        var37_46 = null;
        if (var8_31.methodsynthetic) {
            if (var23_41.curprogram.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# synthetic method:").OpCcblank(null, var8_31.methodname));
            }
            var8_31.interpret(var23_41);
            if (var23_41.curreturn != null) {
                return var23_41.curreturn;
            }
            return var37_46;
        }
        var23_41.curstatic = var8_31.methodstatic;
        var23_41.curjump = RxInterpreter.nojump;
        var23_41.curclause = null;
        this.pushlevel(var23_41);
        var23_41.curclause = var8_31.methodclauses;
        if (!var8_31.methodprotected) {
            this.runfree(var23_41);
        } else {
            var38_28 = var8_31.methodstatic == false ? var23_41.curthis : var22_40.classinfo.getClassObject();
            this.runprotected(var23_41, var38_28);
        }
        if (var23_41.curreturn != null) {
            var37_46 = var23_41.curreturn;
            var23_41.curreturn = null;
        }
        this.poplevel(var23_41);
        if (var23_41.curacttype == 2) {
            var39_29 = (RxSignal)var37_46;
            if (var39_29.signalobj == null) {
                this.rxt.exiting = true;
                return null;
            }
            if (var39_29.signalobj instanceof Object[]) {
                return var39_29.signalobj;
            }
            v2 = var39_29;
            v2.getClass();
            new RxSignal.Frame(v2, var23_41.curprogram, var2_2, var4_4);
            throw var39_29;
        }
        return var37_46;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runprotected(RxCursor rxCursor, Object object) {
        Object object2 = object;
        synchronized (object2) {
            if (rxCursor.curprogram.flag.diag) {
                RexxIO.Say("# protecting: " + object.toString());
            }
            this.runfree(rxCursor);
            if (rxCursor.curprogram.flag.diag) {
                RexxIO.Say("# unprotecting: " + object.toString());
            }
        }
    }

    public void runfree(RxCursor rxCursor) {
        RxClause rxClause = null;
        String[] stringArray = null;
        int n = 0;
        NrBlock nrBlock = null;
        Object object = null;
        RxSignal rxSignal = null;
        RxClauseParser rxClauseParser = null;
        while (rxCursor.curclause != null) {
            rxClause = rxCursor.curclause;
            if (rxCursor.curtrace != null && !rxCursor.curnewprot && !rxCursor.curskiptrace) {
                if (rxClause.lookaside != null) {
                    stringArray = rxClause.lookaside.getAssigns();
                    n = 1;
                } else {
                    stringArray = null;
                    n = 3;
                }
                rxCursor.curtrace.traceclause(rxClause.tokens[0].line, rxClause.tracelines(this.rxt), n, stringArray);
            }
            if (rxClause.lookaside != null) {
                if (rxClause.startprot & !rxCursor.curnewprot) {
                    nrBlock = (NrBlock)rxClause.lookaside;
                    object = nrBlock.evalProtect(rxCursor);
                    rxCursor.curnewprot = true;
                    this.runprotected(rxCursor, object);
                    rxClause = rxCursor.curclause;
                } else {
                    try {
                        rxCursor.curnewprot = false;
                        if (rxCursor.curskipone) {
                            rxCursor.curskipone = false;
                            rxCursor.curskiptrace = false;
                        } else {
                            rxClause.lookaside.interpret(rxCursor);
                        }
                        if (rxCursor.curendprot) {
                            rxCursor.curendprot = false;
                            return;
                        }
                    }
                    catch (RxSignal rxSignal2) {
                        rxSignal = rxSignal2;
                        rxCursor.curreturn = rxSignal;
                        rxCursor.curact = true;
                        rxCursor.curacttype = 2;
                    }
                }
                while (rxCursor.curlevel.thisone) {
                    rxClauseParser = rxCursor.curlevel.clause.lookaside;
                    if (rxClauseParser instanceof NrIf) {
                        rxCursor.curjump = ((NrIf)rxClauseParser).nextclause;
                        this.poplevel(rxCursor);
                        continue;
                    }
                    rxCursor.curlevel.thisone = false;
                    this.endblock(rxCursor);
                }
                if (rxCursor.curlevel.nextone) {
                    rxCursor.curlevel.thisone = true;
                    rxCursor.curlevel.nextone = false;
                } else if (rxCursor.curacttype != 0) {
                    if (rxCursor.curact || rxCursor.curclause.lookaside instanceof NrEnd) {
                        this.unwind(rxCursor);
                    }
                    if (rxCursor.curlevel.prev == null) break;
                }
            }
            if (rxCursor.curjump != nojump) {
                rxCursor.curclause = rxCursor.curjump;
                rxCursor.curjump = nojump;
            } else {
                rxCursor.curclause = rxClause.next;
            }
            if (rxCursor.curact) {
                rxCursor.curact = false;
                continue;
            }
            if (rxCursor.curclause == null || !rxCursor.curclause.skipend || rxCursor.curlevel.trystate == 2) continue;
            this.endBody(rxCursor);
            rxCursor.curclause = rxCursor.curjump;
            rxCursor.curjump = nojump;
        }
    }

    public void endBody(RxCursor rxCursor) {
        RxClauseParser rxClauseParser = rxCursor.curlevel.clause.lookaside;
        if (rxClauseParser instanceof NrLoop) {
            rxCursor.curjump = rxCursor.curlevel.clause;
        } else {
            this.endblock(rxCursor);
        }
    }

    private void endblock(RxCursor rxCursor) {
        NrBlock nrBlock = (NrBlock)rxCursor.curlevel.clause.lookaside;
        rxCursor.curjump = rxCursor.curlevel.trystate == 2 ? nrBlock.endclause : (nrBlock.finclause != null ? nrBlock.finclause : nrBlock.endclause);
        rxCursor.curlevel.trystate = 2;
    }

    private void unwind(RxCursor rxCursor) {
        block16: {
            Vector vector2 = null;
            RxSignal rxSignal = null;
            int n = 0;
            RxClause rxClause = null;
            if (rxCursor.curlevel.prev == null) {
                return;
            }
            RxClauseParser rxClauseParser = rxCursor.curlevel.clause.lookaside;
            while (rxClauseParser instanceof NrIf) {
                this.poplevel(rxCursor);
                if (rxCursor.curlevel.prev == null) {
                    return;
                }
                rxClauseParser = rxCursor.curlevel.clause.lookaside;
            }
            if (rxCursor.curacttype == 2) {
                if (rxCursor.curlevel.trystate == 0 && (vector2 = ((NrBlock)rxClauseParser).catches) != null) {
                    rxSignal = (RxSignal)rxCursor.curreturn;
                    int n2 = vector2.size();
                    n = 0;
                    while (n2 > 0) {
                        rxClause = (RxClause)vector2.elementAt(n);
                        if (((NrCatch)rxClause.lookaside).canCatch(rxCursor, rxSignal)) {
                            rxCursor.curjump = rxClause;
                            break block16;
                        }
                        --n2;
                        ++n;
                    }
                }
                this.endblock(rxCursor);
            } else if (rxCursor.curacttype == 3) {
                if ((NrBlock)rxClauseParser == rxCursor.curactblock) {
                    rxCursor.curacttype = 0;
                }
                this.endblock(rxCursor);
            } else if (rxCursor.curacttype == 4) {
                if ((NrBlock)rxClauseParser == rxCursor.curactblock) {
                    rxCursor.curacttype = 0;
                }
                this.endBody(rxCursor);
            } else if (rxCursor.curacttype == 1) {
                this.endblock(rxCursor);
            } else {
                throw new NoOtherwiseException();
            }
        }
    }

    public NrLevel pushlevel(RxCursor rxCursor) {
        NrLevel nrLevel = new NrLevel(rxCursor.curclause);
        nrLevel.prev = rxCursor.curlevel;
        rxCursor.curlevel = nrLevel;
        return nrLevel;
    }

    public void poplevel(RxCursor rxCursor) {
        rxCursor.curlevel = rxCursor.curlevel.prev;
    }
}

