/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJsr199;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class EclipseCompilerImpl
extends Main {
    private static final CompilationUnit[] NO_UNITS = new CompilationUnit[0];
    private HashMap<CompilationUnit, JavaFileObject> javaFileObjectMap;
    Iterable<? extends JavaFileObject> compilationUnits;
    public JavaFileManager fileManager;
    protected Processor[] processors;
    public DiagnosticListener<? super JavaFileObject> diagnosticListener;

    public EclipseCompilerImpl(PrintWriter out, PrintWriter err, boolean systemExitWhenFinished) {
        super(out, err, systemExitWhenFinished, null, null);
    }

    public boolean call() {
        try {
            try {
                if (this.proceed) {
                    this.globalProblemsCount = 0;
                    this.globalErrorsCount = 0;
                    this.globalWarningsCount = 0;
                    this.globalTasksCount = 0;
                    this.exportedClassFilesCounter = 0;
                    this.performCompilation();
                }
            }
            catch (IllegalArgumentException e) {
                this.logger.logException(e);
                if (this.systemExitWhenFinished) {
                    this.cleanup();
                    System.exit(-1);
                }
                this.cleanup();
                return false;
            }
            catch (RuntimeException e) {
                this.logger.logException(e);
                this.cleanup();
                return false;
            }
        }
        finally {
            this.cleanup();
        }
        return this.globalErrorsCount == 0;
    }

    private void cleanup() {
        this.logger.flush();
        this.logger.close();
        this.processors = null;
        try {
            if (this.fileManager != null) {
                this.fileManager.flush();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        if (this.compilationUnits == null) {
            return NO_UNITS;
        }
        ArrayList<1> units = new ArrayList<1>();
        for (final JavaFileObject javaFileObject : this.compilationUnits) {
            if (javaFileObject.getKind() != JavaFileObject.Kind.SOURCE) {
                throw new IllegalArgumentException();
            }
            String name = javaFileObject.getName();
            name = name.replace('\\', '/');
            CompilationUnit compilationUnit = new CompilationUnit(null, name, null){

                @Override
                public char[] getContents() {
                    try {
                        return javaFileObject.getCharContent(true).toString().toCharArray();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new AbortCompilationUnit(null, e, null);
                    }
                }
            };
            units.add(compilationUnit);
            this.javaFileObjectMap.put(compilationUnit, javaFileObject);
        }
        CompilationUnit[] compilationUnitArray = new CompilationUnit[units.size()];
        units.toArray(compilationUnitArray);
        return compilationUnitArray;
    }

    @Override
    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return false;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }

            @Override
            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    @Override
    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(){

            @Override
            public CategorizedProblem createProblem(final char[] originatingFileName, final int problemId, final String[] problemArguments, String[] messageArguments, final int severity, final int startPosition, final int endPosition, final int lineNumber, final int columnNumber) {
                DiagnosticListener<? super JavaFileObject> diagListener = EclipseCompilerImpl.this.diagnosticListener;
                if (diagListener != null) {
                    diagListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(problemId);
                        }

                        @Override
                        public long getColumnNumber() {
                            return columnNumber;
                        }

                        @Override
                        public long getEndPosition() {
                            return endPosition;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((severity & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((severity & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if (false) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return lineNumber;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(problemId, problemArguments);
                        }

                        @Override
                        public long getPosition() {
                            return startPosition;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File f = new File(new String(originatingFileName));
                            if (f.exists()) {
                                return new EclipseFileObject(null, f.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return startPosition;
                        }
                    });
                }
                return super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }

            @Override
            public CategorizedProblem createProblem(final char[] originatingFileName, final int problemId, final String[] problemArguments, int elaborationID, String[] messageArguments, final int severity, final int startPosition, final int endPosition, final int lineNumber, final int columnNumber) {
                DiagnosticListener<? super JavaFileObject> diagListener = EclipseCompilerImpl.this.diagnosticListener;
                if (diagListener != null) {
                    diagListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(problemId);
                        }

                        @Override
                        public long getColumnNumber() {
                            return columnNumber;
                        }

                        @Override
                        public long getEndPosition() {
                            return endPosition;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((severity & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((severity & 0x400) != 0) {
                                return Diagnostic.Kind.NOTE;
                            }
                            if ((severity & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if (false) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return lineNumber;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            if (locale != null) {
                                this.setLocale(locale);
                            }
                            return this.getLocalizedMessage(problemId, problemArguments);
                        }

                        @Override
                        public long getPosition() {
                            return startPosition;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            File f = new File(new String(originatingFileName));
                            if (f.exists()) {
                                return new EclipseFileObject(null, f.toURI(), JavaFileObject.Kind.SOURCE, null);
                            }
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return startPosition;
                        }
                    });
                }
                return super.createProblem(originatingFileName, problemId, problemArguments, elaborationID, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }
        };
    }

    @Override
    protected void initialize(PrintWriter outWriter, PrintWriter errWriter, boolean systemExit, Map<String, String> customDefaultOptions, CompilationProgress compilationProgress) {
        super.initialize(outWriter, errWriter, systemExit, customDefaultOptions, compilationProgress);
        this.javaFileObjectMap = new HashMap();
    }

    @Override
    protected void initializeAnnotationProcessorManager() {
        super.initializeAnnotationProcessorManager();
        if (this.batchCompiler.annotationProcessorManager != null && this.processors != null) {
            this.batchCompiler.annotationProcessorManager.setProcessors(this.processors);
        } else if (this.processors != null) {
            throw new UnsupportedOperationException("Cannot handle annotation processing");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void outputClassFiles(CompilationResult unitResult) {
        if (unitResult == null) return;
        if (unitResult.hasErrors()) {
            if (!this.proceedOnError) return;
        }
        ClassFile[] classFiles = unitResult.getClassFiles();
        boolean generateClasspathStructure = this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT);
        String currentDestinationPath = this.destinationPath;
        File outputLocation = null;
        if (currentDestinationPath != null) {
            outputLocation = new File(currentDestinationPath);
            outputLocation.mkdirs();
        }
        int i = 0;
        int fileCount = classFiles.length;
        while (true) {
            String relativeStringName;
            block25: {
                if (i >= fileCount) {
                    this.batchCompiler.lookupEnvironment.releaseClassFiles(classFiles);
                    return;
                }
                ClassFile classFile = classFiles[i];
                char[] filename = classFile.fileName();
                int length = filename.length;
                char[] relativeName = new char[length + 6];
                System.arraycopy(filename, 0, relativeName, 0, length);
                System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                CharOperation.replace(relativeName, '/', File.separatorChar);
                relativeStringName = new String(relativeName);
                if (this.compilerOptions.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), relativeStringName}));
                }
                try {
                    JavaFileObject javaFileForOutput = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, new String(filename), JavaFileObject.Kind.CLASS, this.javaFileObjectMap.get(unitResult.compilationUnit));
                    if (generateClasspathStructure) {
                        if (currentDestinationPath != null) {
                            int index = CharOperation.lastIndexOf(File.separatorChar, relativeName);
                            if (index != -1) {
                                File currentFolder = new File(currentDestinationPath, relativeStringName.substring(0, index));
                                currentFolder.mkdirs();
                            }
                        } else {
                            String path = javaFileForOutput.toUri().getPath();
                            int index = path.lastIndexOf(47);
                            if (index != -1) {
                                File file2 = new File(path.substring(0, index));
                                file2.mkdirs();
                            }
                        }
                    }
                    Throwable throwable = null;
                    Object var15_18 = null;
                    try {
                        OutputStream openOutputStream = javaFileForOutput.openOutputStream();
                        try {
                            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(openOutputStream);){
                                bufferedOutputStream.write(classFile.header, 0, classFile.headerOffset);
                                bufferedOutputStream.write(classFile.contents, 0, classFile.contentsOffset);
                                bufferedOutputStream.flush();
                            }
                            if (openOutputStream == null) break block25;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (openOutputStream == null) throw throwable;
                            openOutputStream.close();
                            throw throwable;
                        }
                        openOutputStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.logger.logNoClassFileCreated(currentDestinationPath, relativeStringName, e);
                }
            }
            this.logger.logClassFile(generateClasspathStructure, currentDestinationPath, relativeStringName);
            ++this.exportedClassFilesCounter;
            ++i;
        }
    }

    @Override
    protected void setPaths(ArrayList bootclasspaths, String sourcepathClasspathArg, ArrayList sourcepathClasspaths, ArrayList classpaths, ArrayList extdirsClasspaths, ArrayList endorsedDirClasspaths, String customEncoding) {
        int n;
        ArrayList fileSystemClasspaths = new ArrayList();
        EclipseFileManager eclipseJavaFileManager = null;
        StandardJavaFileManager standardJavaFileManager = null;
        JavaFileManager javaFileManager = null;
        boolean havePlatformPaths = false;
        boolean haveClassPaths = false;
        if (this.fileManager instanceof EclipseFileManager) {
            eclipseJavaFileManager = (EclipseFileManager)this.fileManager;
        }
        if (this.fileManager instanceof StandardJavaFileManager) {
            standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
        }
        javaFileManager = this.fileManager;
        if (eclipseJavaFileManager != null && (eclipseJavaFileManager.flags & 4) == 0 && (eclipseJavaFileManager.flags & 2) != 0) {
            fileSystemClasspaths.addAll(this.handleEndorseddirs(null));
        }
        Iterable<? extends File> location = null;
        if (standardJavaFileManager != null) {
            location = standardJavaFileManager.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
            if (location != null) {
                for (File file2 : location) {
                    FileSystem.Classpath classpath22 = FileSystem.getClasspath(file2.getAbsolutePath(), null, null, this.options);
                    if (classpath22 == null) continue;
                    fileSystemClasspaths.add(classpath22);
                    havePlatformPaths = true;
                }
            }
        } else if (javaFileManager != null) {
            ClasspathJsr199 classpathJsr199 = new ClasspathJsr199(this.fileManager, StandardLocation.PLATFORM_CLASS_PATH);
            fileSystemClasspaths.add(classpathJsr199);
            havePlatformPaths = true;
        }
        if (eclipseJavaFileManager != null && (eclipseJavaFileManager.flags & 1) == 0 && (eclipseJavaFileManager.flags & 2) != 0) {
            fileSystemClasspaths.addAll(this.handleExtdirs(null));
        }
        if (standardJavaFileManager != null) {
            FileSystem.Classpath classpath;
            location = standardJavaFileManager.getLocation(StandardLocation.SOURCE_PATH);
            if (location != null) {
                for (File file3 : location) {
                    classpath = FileSystem.getClasspath(file3.getAbsolutePath(), null, null, this.options);
                    if (classpath == null) continue;
                    fileSystemClasspaths.add(classpath);
                }
            }
            if ((location = standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH)) != null) {
                for (File file4 : location) {
                    classpath = FileSystem.getClasspath(file4.getAbsolutePath(), null, null, this.options);
                    if (classpath == null) continue;
                    fileSystemClasspaths.add(classpath);
                    haveClassPaths = true;
                }
            }
        } else if (javaFileManager != null) {
            Object var15_24 = null;
            if (this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                ClasspathJsr199 classpathJsr199 = new ClasspathJsr199(this.fileManager, StandardLocation.SOURCE_PATH);
                fileSystemClasspaths.add(classpathJsr199);
            }
            ClasspathJsr199 classpathJsr199 = new ClasspathJsr199(this.fileManager, StandardLocation.CLASS_PATH);
            fileSystemClasspaths.add(classpathJsr199);
            haveClassPaths = true;
        }
        if (this.checkedClasspaths == null) {
            if (!havePlatformPaths) {
                fileSystemClasspaths.addAll(this.handleBootclasspath(null, null));
            }
            if (!haveClassPaths) {
                fileSystemClasspaths.addAll(this.handleClasspath(null, null));
            }
        }
        if ((n = (fileSystemClasspaths = FileSystem.ClasspathNormalizer.normalize(fileSystemClasspaths)).size()) != 0) {
            this.checkedClasspaths = new FileSystem.Classpath[n];
            int i = 0;
            for (FileSystem.Classpath classpath : fileSystemClasspaths) {
                this.checkedClasspaths[i++] = classpath;
            }
        }
    }

    @Override
    protected void loggingExtraProblems() {
        super.loggingExtraProblems();
        for (final CategorizedProblem problem : this.extraProblems) {
            if (this.diagnosticListener == null) continue;
            this.diagnosticListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                @Override
                public String getCode() {
                    return null;
                }

                @Override
                public long getColumnNumber() {
                    if (problem instanceof DefaultProblem) {
                        return ((DefaultProblem)problem).column;
                    }
                    return -1L;
                }

                @Override
                public long getEndPosition() {
                    if (problem instanceof DefaultProblem) {
                        return ((DefaultProblem)problem).getSourceEnd();
                    }
                    return -1L;
                }

                @Override
                public Diagnostic.Kind getKind() {
                    if (problem.isError()) {
                        return Diagnostic.Kind.ERROR;
                    }
                    if (problem.isWarning()) {
                        return Diagnostic.Kind.WARNING;
                    }
                    if (problem instanceof DefaultProblem && ((DefaultProblem)problem).isInfo()) {
                        return Diagnostic.Kind.NOTE;
                    }
                    return Diagnostic.Kind.OTHER;
                }

                @Override
                public long getLineNumber() {
                    if (problem instanceof DefaultProblem) {
                        return ((DefaultProblem)problem).getSourceLineNumber();
                    }
                    return -1L;
                }

                @Override
                public String getMessage(Locale locale) {
                    return problem.getMessage();
                }

                @Override
                public long getPosition() {
                    if (problem instanceof DefaultProblem) {
                        return ((DefaultProblem)problem).getSourceStart();
                    }
                    return -1L;
                }

                @Override
                public JavaFileObject getSource() {
                    if (problem instanceof DefaultProblem) {
                        File f = new File(new String(((DefaultProblem)problem).getOriginatingFileName()));
                        if (f.exists()) {
                            Charset charset = EclipseCompilerImpl.this.fileManager instanceof EclipseFileManager ? ((EclipseFileManager)EclipseCompilerImpl.this.fileManager).charset : Charset.defaultCharset();
                            return new EclipseFileObject(null, f.toURI(), JavaFileObject.Kind.SOURCE, charset);
                        }
                        return null;
                    }
                    return null;
                }

                @Override
                public long getStartPosition() {
                    return this.getPosition();
                }
            });
        }
    }
}

