/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.util.keyrange;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryCursor;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.keyrange.KeyRange;
import java.nio.ByteOrder;

public class RangeCursor
implements Cloneable {
    private SCursor cursor;
    private SSecondaryCursor secCursor;
    private KeyRange range;
    private KeyRange pkRange;
    private boolean sortedDups;
    private SDatabaseEntry privKey;
    private SDatabaseEntry privPKey;
    private SDatabaseEntry privData;
    private boolean initialized;

    public RangeCursor(KeyRange keyRange, KeyRange keyRange2, boolean bl, SCursor sCursor) {
        if (keyRange2 != null && !keyRange.singleKey) {
            throw new IllegalArgumentException();
        }
        this.range = keyRange;
        this.pkRange = keyRange2;
        this.sortedDups = bl;
        this.cursor = sCursor;
        this.init();
        if (keyRange2 != null && this.secCursor == null) {
            throw new IllegalArgumentException();
        }
    }

    public RangeCursor dup(boolean bl) throws SDatabaseException {
        try {
            RangeCursor rangeCursor = (RangeCursor)super.clone();
            rangeCursor.cursor = this.dupCursor(this.cursor, bl);
            rangeCursor.init();
            return rangeCursor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void init() {
        this.secCursor = this.cursor instanceof SSecondaryCursor ? (SSecondaryCursor)this.cursor : null;
        if (this.range.hasBound()) {
            this.privKey = new SDatabaseEntry();
            this.privPKey = new SDatabaseEntry();
            this.privData = new SDatabaseEntry();
        } else {
            this.privKey = null;
            this.privPKey = null;
            this.privData = null;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public SCursor getCursor() {
        return this.cursor;
    }

    private void setParams(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        this.privKey = sDatabaseEntry;
        this.privPKey = sDatabaseEntry2;
        this.privData = sDatabaseEntry3;
    }

    private SCursor beginOperation() throws SDatabaseException {
        SCursor sCursor = this.cursor;
        if (this.initialized) {
            this.cursor = this.dupCursor(this.cursor, true);
            if (this.secCursor != null) {
                this.secCursor = (SSecondaryCursor)this.cursor;
            }
        } else {
            return this.cursor;
        }
        return sCursor;
    }

    private void endOperation(SCursor sCursor, DbCompat.OpResult opResult, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) throws SDatabaseException {
        if (opResult.isSuccess()) {
            if (sCursor != null && sCursor != this.cursor) {
                this.closeCursor(sCursor);
            }
            if (sDatabaseEntry != null) {
                RangeCursor.swapData(sDatabaseEntry, this.privKey);
            }
            if (sDatabaseEntry2 != null && this.secCursor != null) {
                RangeCursor.swapData(sDatabaseEntry2, this.privPKey);
            }
            if (sDatabaseEntry3 != null) {
                RangeCursor.swapData(sDatabaseEntry3, this.privData);
            }
            this.initialized = true;
        } else if (sCursor != null && sCursor != this.cursor) {
            this.closeCursor(this.cursor);
            this.cursor = sCursor;
            if (this.secCursor != null) {
                this.secCursor = (SSecondaryCursor)this.cursor;
            }
        }
    }

    private static void swapData(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        byte[] byArray = sDatabaseEntry.getData();
        sDatabaseEntry.setData(sDatabaseEntry2.getData());
        sDatabaseEntry2.setData(byArray);
    }

    private static void shareData(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        if (sDatabaseEntry != null) {
            sDatabaseEntry2.setData(sDatabaseEntry.getData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getFirst(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetFirst(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.pkRange != null && this.pkRange.isSingleKey()) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            KeyRange.copy(this.pkRange.beginKey, this.privPKey);
            DbCompat.OpResult opResult3 = this.doGetSearchBoth(opReadOptions);
            this.endOperation(null, opResult3, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            return opResult3;
        }
        if (this.pkRange != null) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            opResult = DbCompat.OpResult.FAILURE;
            SCursor sCursor = this.beginOperation();
            try {
                if (this.pkRange.beginKey == null || !this.sortedDups) {
                    opResult = this.doGetSearchKey(opReadOptions);
                } else {
                    KeyRange.copy(this.pkRange.beginKey, this.privPKey);
                    opResult = this.doGetSearchBothRange(opReadOptions);
                    if (opResult.isSuccess() && !this.pkRange.beginInclusive && this.pkRange.compare(this.privPKey, this.pkRange.beginKey) == 0) {
                        opResult = this.doGetNextDup(opReadOptions);
                    }
                }
                if (!opResult.isSuccess() || this.pkRange.check(this.privPKey)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
        }
        if (this.range.singleKey) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            opResult = this.doGetSearchKey(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            return opResult;
        }
        opResult = DbCompat.OpResult.FAILURE;
        SCursor sCursor = this.beginOperation();
        try {
            if (this.range.beginKey == null) {
                opResult = this.doGetFirst(opReadOptions);
            } else {
                KeyRange.copy(this.range.beginKey, this.privKey);
                opResult = this.doGetSearchKeyRange(opReadOptions);
                if (opResult.isSuccess() && !this.range.beginInclusive && this.range.compare(this.privKey, this.range.beginKey) == 0) {
                    opResult = this.doGetNextNoDup(opReadOptions);
                }
            }
            if (!opResult.isSuccess() || this.range.check(this.privKey)) return opResult;
            opResult = DbCompat.OpResult.FAILURE;
            return opResult;
        }
        finally {
            this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getLast(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            opResult = this.doGetLast(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        }
        SCursor sCursor = this.beginOperation();
        try {
            if (this.pkRange != null) {
                opResult = this.getLastInPKeyRange(opReadOptions);
                if (!(!opResult.isSuccess() || this.range.check(this.privKey) && this.pkRange.check(this.privPKey))) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            } else {
                opResult = this.getLastInKeyRange(opReadOptions);
                if (opResult.isSuccess() && !this.range.check(this.privKey)) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            }
            DbCompat.OpResult opResult2 = opResult;
            return opResult2;
        }
        finally {
            this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
    }

    private DbCompat.OpResult getLastInKeyRange(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (this.range.endKey == null) {
            return this.doGetLast(opReadOptions);
        }
        do {
            KeyRange.copy(this.range.endKey, this.privKey);
            opResult = this.doGetSearchKeyRange(opReadOptions);
            if (opResult.isSuccess()) {
                if (this.range.endInclusive && this.range.compare(this.range.endKey, this.privKey) == 0) {
                    if (!this.sortedDups) {
                        return opResult;
                    }
                    opResult = this.doGetNextNoDup(opReadOptions);
                    opResult = opResult.isSuccess() ? this.doGetPrev(opReadOptions) : this.doGetLast(opReadOptions);
                } else {
                    opResult = this.doGetPrev(opReadOptions);
                }
            } else {
                opResult = this.doGetLast(opReadOptions);
            }
            if (opResult.isSuccess()) continue;
            return opResult;
        } while (!this.range.checkEnd(this.privKey, true));
        return opResult;
    }

    private DbCompat.OpResult getLastInPKeyRange(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (this.pkRange.isSingleKey()) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            KeyRange.copy(this.pkRange.beginKey, this.privPKey);
            return this.doGetSearchBoth(opReadOptions);
        }
        if (!this.sortedDups) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            return this.doGetSearchKey(opReadOptions);
        }
        while (true) {
            if (this.pkRange.endKey != null) {
                KeyRange.copy(this.range.beginKey, this.privKey);
                KeyRange.copy(this.pkRange.endKey, this.privPKey);
                opResult = this.doGetSearchBothRange(opReadOptions);
                if (opResult.isSuccess()) {
                    if (!this.pkRange.endInclusive || this.pkRange.compare(this.pkRange.endKey, this.privPKey) != 0) {
                        opResult = this.doGetPrevDup(opReadOptions);
                        if (!opResult.isSuccess()) {
                            return opResult;
                        }
                        if (!this.pkRange.checkEnd(this.privPKey, true)) continue;
                    }
                    return opResult;
                }
            }
            KeyRange.copy(this.range.beginKey, this.privKey);
            opResult = this.doGetSearchKey(opReadOptions);
            if (!opResult.isSuccess()) {
                return opResult;
            }
            opResult = this.doGetNextNoDup(opReadOptions);
            opResult = opResult.isSuccess() ? this.doGetPrev(opReadOptions) : this.doGetLast(opReadOptions);
            if (!opResult.isSuccess()) {
                return opResult;
            }
            if (this.range.checkEnd(this.privKey, true)) break;
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getNext(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getFirst(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetNext(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.endKey == null) {
                opResult = this.doGetNextDup(opReadOptions);
                this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
                return opResult;
            } else {
                opResult = DbCompat.OpResult.FAILURE;
                SCursor sCursor = this.beginOperation();
                try {
                    opResult = this.doGetNextDup(opReadOptions);
                    if (!opResult.isSuccess() || this.pkRange.checkEnd(this.privPKey, true)) return opResult;
                    opResult = DbCompat.OpResult.FAILURE;
                    return opResult;
                }
                finally {
                    this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
                }
            }
        }
        if (this.range.singleKey) {
            opResult = this.doGetNextDup(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            return opResult;
        }
        opResult = DbCompat.OpResult.FAILURE;
        SCursor sCursor = this.beginOperation();
        try {
            opResult = this.doGetNext(opReadOptions);
            if (!opResult.isSuccess() || this.range.check(this.privKey)) return opResult;
            opResult = DbCompat.OpResult.FAILURE;
            return opResult;
        }
        finally {
            this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getNextNoDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getFirst(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetNextNoDup(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.range.singleKey) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            opResult = DbCompat.OpResult.FAILURE;
            SCursor sCursor = this.beginOperation();
            try {
                opResult = this.doGetNextNoDup(opReadOptions);
                if (opResult.isSuccess() && !this.range.check(this.privKey)) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            }
            finally {
                this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getPrev(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getLast(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetPrev(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.beginKey == null) {
                opResult = this.doGetPrevDup(opReadOptions);
                this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
                return opResult;
            } else {
                opResult = DbCompat.OpResult.FAILURE;
                SCursor sCursor = this.beginOperation();
                try {
                    opResult = this.doGetPrevDup(opReadOptions);
                    if (!opResult.isSuccess() || this.pkRange.checkBegin(this.privPKey, true)) return opResult;
                    opResult = DbCompat.OpResult.FAILURE;
                    return opResult;
                }
                finally {
                    this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
                }
            }
        }
        if (this.range.singleKey) {
            opResult = this.doGetPrevDup(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            return opResult;
        }
        opResult = DbCompat.OpResult.FAILURE;
        SCursor sCursor = this.beginOperation();
        try {
            opResult = this.doGetPrev(opReadOptions);
            if (!opResult.isSuccess() || this.range.check(this.privKey)) return opResult;
            opResult = DbCompat.OpResult.FAILURE;
            return opResult;
        }
        finally {
            this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getPrevNoDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            return this.getLast(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, opReadOptions);
        }
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetPrevNoDup(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (this.range.singleKey) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            opResult = DbCompat.OpResult.FAILURE;
            SCursor sCursor = this.beginOperation();
            try {
                opResult = this.doGetPrevNoDup(opReadOptions);
                if (opResult.isSuccess() && !this.range.check(this.privKey)) {
                    opResult = DbCompat.OpResult.FAILURE;
                }
            }
            finally {
                this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getSearchKey(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetSearchKey(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (!this.range.check(sDatabaseEntry)) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.pkRange != null) {
            opResult = DbCompat.OpResult.FAILURE;
            SCursor sCursor = this.beginOperation();
            try {
                RangeCursor.shareData(sDatabaseEntry, this.privKey);
                opResult = this.doGetSearchKey(opReadOptions);
                if (!opResult.isSuccess()) return opResult;
                if (this.pkRange.check(this.privPKey)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
        } else {
            RangeCursor.shareData(sDatabaseEntry, this.privKey);
            opResult = this.doGetSearchKey(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        return opResult;
    }

    public DbCompat.OpResult getSearchBoth(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetSearchBoth(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (!this.range.check(sDatabaseEntry) || this.pkRange != null && !this.pkRange.check(sDatabaseEntry2)) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            RangeCursor.shareData(sDatabaseEntry, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(sDatabaseEntry2, this.privPKey);
            } else {
                RangeCursor.shareData(sDatabaseEntry3, this.privData);
            }
            opResult = this.doGetSearchBoth(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getSearchKeyRange(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            opResult = this.doGetSearchKeyRange(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        }
        SCursor sCursor = this.beginOperation();
        try {
            RangeCursor.shareData(sDatabaseEntry, this.privKey);
            opResult = this.doGetSearchKeyRange(opReadOptions);
            if (opResult.isSuccess() && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(sDatabaseEntry2))) {
                opResult = DbCompat.OpResult.FAILURE;
            }
        }
        finally {
            this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbCompat.OpResult getSearchBothRange(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult = DbCompat.OpResult.FAILURE;
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            opResult = this.doGetSearchBothRange(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        }
        SCursor sCursor = this.beginOperation();
        try {
            RangeCursor.shareData(sDatabaseEntry, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(sDatabaseEntry2, this.privPKey);
            } else {
                RangeCursor.shareData(sDatabaseEntry3, this.privData);
            }
            opResult = this.doGetSearchBothRange(opReadOptions);
            if (opResult.isSuccess() && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(sDatabaseEntry2))) {
                opResult = DbCompat.OpResult.FAILURE;
            }
        }
        finally {
            this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        return opResult;
    }

    public DbCompat.OpResult getSearchRecordNumber(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            DbCompat.OpResult opResult2 = this.doGetSearchRecordNumber(opReadOptions);
            this.endOperation(null, opResult2, null, null, null);
            return opResult2;
        }
        if (!this.range.check(sDatabaseEntry)) {
            opResult = DbCompat.OpResult.FAILURE;
        } else {
            RangeCursor.shareData(sDatabaseEntry, this.privKey);
            opResult = this.doGetSearchRecordNumber(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getNextDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            throw new IllegalStateException("SCursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            opResult = this.doGetNextDup(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        } else if (this.pkRange != null && this.pkRange.endKey != null) {
            opResult = DbCompat.OpResult.FAILURE;
            SCursor sCursor = this.beginOperation();
            try {
                opResult = this.doGetNextDup(opReadOptions);
                if (!opResult.isSuccess() || this.pkRange.checkEnd(this.privPKey, true)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
        } else {
            opResult = this.doGetNextDup(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        return opResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbCompat.OpResult getPrevDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        DbCompat.OpResult opResult;
        if (!this.initialized) {
            throw new IllegalStateException("SCursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            opResult = this.doGetPrevDup(opReadOptions);
            this.endOperation(null, opResult, null, null, null);
            return opResult;
        } else if (this.pkRange != null && this.pkRange.beginKey != null) {
            opResult = DbCompat.OpResult.FAILURE;
            SCursor sCursor = this.beginOperation();
            try {
                opResult = this.doGetPrevDup(opReadOptions);
                if (!opResult.isSuccess() || this.pkRange.checkBegin(this.privPKey, true)) return opResult;
                opResult = DbCompat.OpResult.FAILURE;
                return opResult;
            }
            finally {
                this.endOperation(sCursor, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
            }
        } else {
            opResult = this.doGetPrevDup(opReadOptions);
            this.endOperation(null, opResult, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        }
        return opResult;
    }

    public DbCompat.OpResult getCurrent(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (!this.initialized) {
            throw new IllegalStateException("SCursor not initialized");
        }
        if (this.secCursor != null && sDatabaseEntry2 != null) {
            return DbCompat.OpResult.make(this.secCursor.getCurrent(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getCurrent(sDatabaseEntry, sDatabaseEntry3, opReadOptions.getLockMode()));
    }

    public void close() throws SDatabaseException {
        this.closeCursor(this.cursor);
    }

    public int count() throws SDatabaseException {
        return this.cursor.count();
    }

    public SOperationStatus delete() throws SDatabaseException {
        return this.cursor.delete();
    }

    public SOperationStatus put(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursor.put(sDatabaseEntry, sDatabaseEntry2);
    }

    public SOperationStatus putNoOverwrite(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursor.putNoOverwrite(sDatabaseEntry, sDatabaseEntry2);
    }

    public SOperationStatus putNoDupData(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursor.putNoDupData(sDatabaseEntry, sDatabaseEntry2);
    }

    public SOperationStatus putCurrent(SDatabaseEntry sDatabaseEntry) throws SDatabaseException {
        return this.cursor.putCurrent(sDatabaseEntry);
    }

    public SOperationStatus putAfter(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return DbCompat.putAfter(this.cursor, sDatabaseEntry, sDatabaseEntry2);
    }

    public SOperationStatus putBefore(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return DbCompat.putBefore(this.cursor, sDatabaseEntry, sDatabaseEntry2);
    }

    private DbCompat.OpResult doGetFirst(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getFirst(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getFirst(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetLast(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getLast(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getLast(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetNext(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getNext(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getNext(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetNextDup(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getNextDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getNextDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetNextNoDup(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getNextNoDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getNextNoDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetPrev(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getPrev(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getPrev(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetPrevDup(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getPrevDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getPrevDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetPrevNoDup(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getPrevNoDup(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getPrevNoDup(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchKey(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey, this.getServerByteOrder()) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchKey(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchKey(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchKeyRange(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey, this.getServerByteOrder()) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchKeyRange(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchKeyRange(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchBoth(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey, this.getServerByteOrder()) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchBoth(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchBoth(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchBothRange(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey, this.getServerByteOrder()) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(this.secCursor.getSearchBothRange(this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(this.cursor.getSearchBothRange(this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private DbCompat.OpResult doGetSearchRecordNumber(DbCompat.OpReadOptions opReadOptions) throws SDatabaseException {
        if (DbCompat.getRecordNumber(this.privKey, this.getServerByteOrder()) <= 0) {
            return DbCompat.OpResult.FAILURE;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.OpResult.make(DbCompat.getSearchRecordNumber(this.secCursor, this.privKey, this.privPKey, this.privData, opReadOptions.getLockMode()));
        }
        return DbCompat.OpResult.make(DbCompat.getSearchRecordNumber(this.cursor, this.privKey, this.privData, opReadOptions.getLockMode()));
    }

    private ByteOrder getServerByteOrder() {
        return this.cursor.getDatabase().getServerByteOrder();
    }

    protected SCursor dupCursor(SCursor sCursor, boolean bl) throws SDatabaseException {
        return sCursor.dup(bl);
    }

    protected void closeCursor(SCursor sCursor) throws SDatabaseException {
        sCursor.close();
    }

    protected boolean checkRecordNumber() {
        return false;
    }
}

