/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.util.keyrange;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.util.keyrange.KeyRangeException;
import java.util.Comparator;

public class KeyRange {
    public static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    Comparator<byte[]> comparator;
    SDatabaseEntry beginKey;
    SDatabaseEntry endKey;
    boolean singleKey;
    boolean beginInclusive;
    boolean endInclusive;

    public KeyRange(Comparator<byte[]> comparator) {
        this.comparator = comparator;
    }

    public KeyRange subRange(SDatabaseEntry sDatabaseEntry) throws KeyRangeException {
        if (!this.check(sDatabaseEntry)) {
            throw new KeyRangeException("singleKey out of range");
        }
        KeyRange keyRange = new KeyRange(this.comparator);
        keyRange.beginKey = sDatabaseEntry;
        keyRange.endKey = sDatabaseEntry;
        keyRange.beginInclusive = true;
        keyRange.endInclusive = true;
        keyRange.singleKey = true;
        return keyRange;
    }

    public KeyRange subRange(SDatabaseEntry sDatabaseEntry, boolean bl, SDatabaseEntry sDatabaseEntry2, boolean bl2) throws KeyRangeException {
        if (sDatabaseEntry == null) {
            sDatabaseEntry = this.beginKey;
            bl = this.beginInclusive;
        } else if (!this.check(sDatabaseEntry, bl)) {
            throw new KeyRangeException("beginKey out of range");
        }
        if (sDatabaseEntry2 == null) {
            sDatabaseEntry2 = this.endKey;
            bl2 = this.endInclusive;
        } else if (!this.check(sDatabaseEntry2, bl2)) {
            throw new KeyRangeException("endKey out of range");
        }
        KeyRange keyRange = new KeyRange(this.comparator);
        keyRange.beginKey = sDatabaseEntry;
        keyRange.endKey = sDatabaseEntry2;
        keyRange.beginInclusive = bl;
        keyRange.endInclusive = bl2;
        return keyRange;
    }

    public final boolean isSingleKey() {
        return this.singleKey;
    }

    public final SDatabaseEntry getSingleKey() {
        return this.singleKey ? this.beginKey : null;
    }

    public final boolean hasBound() {
        return this.endKey != null || this.beginKey != null;
    }

    public String toString() {
        return "[KeyRange " + this.beginKey + ' ' + this.beginInclusive + this.endKey + ' ' + this.endInclusive + (this.singleKey ? " single" : "");
    }

    public boolean check(SDatabaseEntry sDatabaseEntry) {
        if (this.singleKey) {
            return this.compare(sDatabaseEntry, this.beginKey) == 0;
        }
        return this.checkBegin(sDatabaseEntry, true) && this.checkEnd(sDatabaseEntry, true);
    }

    public boolean check(SDatabaseEntry sDatabaseEntry, boolean bl) {
        if (this.singleKey) {
            return this.compare(sDatabaseEntry, this.beginKey) == 0;
        }
        return this.checkBegin(sDatabaseEntry, bl) && this.checkEnd(sDatabaseEntry, bl);
    }

    public boolean checkBegin(SDatabaseEntry sDatabaseEntry, boolean bl) {
        if (this.beginKey == null) {
            return true;
        }
        if (!this.beginInclusive && bl) {
            return this.compare(sDatabaseEntry, this.beginKey) > 0;
        }
        return this.compare(sDatabaseEntry, this.beginKey) >= 0;
    }

    public boolean checkEnd(SDatabaseEntry sDatabaseEntry, boolean bl) {
        if (this.endKey == null) {
            return true;
        }
        if (!this.endInclusive && bl) {
            return this.compare(sDatabaseEntry, this.endKey) < 0;
        }
        return this.compare(sDatabaseEntry, this.endKey) <= 0;
    }

    public int compare(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        if (this.comparator != null) {
            return this.comparator.compare(KeyRange.getByteArray(sDatabaseEntry), KeyRange.getByteArray(sDatabaseEntry2));
        }
        return KeyRange.compareBytes(sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), sDatabaseEntry.getSize(), sDatabaseEntry2.getData(), sDatabaseEntry2.getOffset(), sDatabaseEntry2.getSize());
    }

    public static byte[] copyBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static int compareBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        for (int i = 0; i < n2 && i < n4; ++i) {
            int n5 = 0xFF & byArray[n + i];
            int n6 = 0xFF & byArray2[n3 + i];
            if (n5 < n6) {
                return -1;
            }
            if (n5 <= n6) continue;
            return 1;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 > n4) {
            return 1;
        }
        return 0;
    }

    public static boolean equalBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i + n] == byArray2[i + n3]) continue;
            return false;
        }
        return true;
    }

    public static SDatabaseEntry copy(SDatabaseEntry sDatabaseEntry) {
        return new SDatabaseEntry(KeyRange.getByteArray(sDatabaseEntry));
    }

    public static void copy(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        sDatabaseEntry2.setData(KeyRange.getByteArray(sDatabaseEntry));
    }

    public static byte[] getByteArray(SDatabaseEntry sDatabaseEntry) {
        return KeyRange.getByteArrayInternal(sDatabaseEntry, Integer.MAX_VALUE);
    }

    public static byte[] getByteArray(SDatabaseEntry sDatabaseEntry, int n) {
        return KeyRange.getByteArrayInternal(sDatabaseEntry, n);
    }

    private static byte[] getByteArrayInternal(SDatabaseEntry sDatabaseEntry, int n) {
        byte[] byArray;
        byte[] byArray2 = sDatabaseEntry.getData();
        if (byArray2 == null) {
            return null;
        }
        int n2 = Math.min(sDatabaseEntry.getSize(), n);
        if (n2 == 0) {
            byArray = ZERO_LENGTH_BYTE_ARRAY;
        } else {
            byArray = new byte[n2];
            System.arraycopy(byArray2, sDatabaseEntry.getOffset(), byArray, 0, n2);
        }
        return byArray;
    }

    public static boolean equalBytes(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        if (sDatabaseEntry == null && sDatabaseEntry2 == null) {
            return true;
        }
        if (sDatabaseEntry == null || sDatabaseEntry2 == null) {
            return false;
        }
        byte[] byArray = sDatabaseEntry.getData();
        byte[] byArray2 = sDatabaseEntry2.getData();
        int n = sDatabaseEntry.getSize();
        int n2 = sDatabaseEntry2.getSize();
        int n3 = sDatabaseEntry.getOffset();
        int n4 = sDatabaseEntry2.getOffset();
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[n3 + i] == byArray2[n4 + i]) continue;
            return false;
        }
        return true;
    }

    public static String toString(SDatabaseEntry sDatabaseEntry) {
        int n = sDatabaseEntry.getOffset() + sDatabaseEntry.getSize();
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        byte[] byArray = sDatabaseEntry.getData();
        for (int i = sDatabaseEntry.getOffset(); i < n; ++i) {
            String string = Integer.toHexString(byArray[i]);
            if (string.length() < 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

