/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.BasicIterator;
import com.sleepycat.client.persist.EntityCursor;
import com.sleepycat.client.persist.ValueAdapter;
import com.sleepycat.client.util.keyrange.RangeCursor;
import java.util.Iterator;

class BasicCursor<V>
implements EntityCursor<V> {
    RangeCursor cursor;
    ValueAdapter<V> adapter;
    boolean updateAllowed;
    SDatabaseEntry key;
    SDatabaseEntry pkey;
    SDatabaseEntry data;

    BasicCursor(RangeCursor rangeCursor, ValueAdapter<V> valueAdapter, boolean bl) {
        this.cursor = rangeCursor;
        this.adapter = valueAdapter;
        this.updateAllowed = bl;
        this.key = valueAdapter.initKey();
        this.pkey = valueAdapter.initPKey();
        this.data = valueAdapter.initData();
    }

    @Override
    public V first() throws SDatabaseException {
        return this.first(null);
    }

    @Override
    public V first(SLockMode sLockMode) throws SDatabaseException {
        return this.returnValue(this.cursor.getFirst(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V last() throws SDatabaseException {
        return this.last(null);
    }

    @Override
    public V last(SLockMode sLockMode) throws SDatabaseException {
        return this.returnValue(this.cursor.getLast(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V next() throws SDatabaseException {
        return this.next(null);
    }

    @Override
    public V next(SLockMode sLockMode) throws SDatabaseException {
        return this.returnValue(this.cursor.getNext(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V nextDup() throws SDatabaseException {
        return this.nextDup(null);
    }

    @Override
    public V nextDup(SLockMode sLockMode) throws SDatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getNextDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V nextNoDup() throws SDatabaseException {
        return this.nextNoDup(null);
    }

    @Override
    public V nextNoDup(SLockMode sLockMode) throws SDatabaseException {
        return this.returnValue(this.cursor.getNextNoDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V prev() throws SDatabaseException {
        return this.prev(null);
    }

    @Override
    public V prev(SLockMode sLockMode) throws SDatabaseException {
        return this.returnValue(this.cursor.getPrev(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V prevDup() throws SDatabaseException {
        return this.prevDup(null);
    }

    @Override
    public V prevDup(SLockMode sLockMode) throws SDatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getPrevDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V prevNoDup() throws SDatabaseException {
        return this.prevNoDup(null);
    }

    @Override
    public V prevNoDup(SLockMode sLockMode) throws SDatabaseException {
        return this.returnValue(this.cursor.getPrevNoDup(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public V current() throws SDatabaseException {
        return this.current(null);
    }

    @Override
    public V current(SLockMode sLockMode) throws SDatabaseException {
        this.checkInitialized();
        return this.returnValue(this.cursor.getCurrent(this.key, this.pkey, this.data, DbCompat.OpReadOptions.make(sLockMode)));
    }

    @Override
    public int count() throws SDatabaseException {
        this.checkInitialized();
        return this.cursor.count();
    }

    @Override
    public Iterator<V> iterator() {
        return this.iterator(null);
    }

    @Override
    public Iterator<V> iterator(SLockMode sLockMode) {
        return new BasicIterator(this, sLockMode);
    }

    @Override
    public boolean update(V v) throws SDatabaseException {
        if (!this.updateAllowed) {
            throw new UnsupportedOperationException("Update not allowed on a secondary index");
        }
        this.checkInitialized();
        this.adapter.valueToData(v, this.data);
        return this.cursor.getCursor().putCurrent(this.data) == SOperationStatus.SUCCESS;
    }

    @Override
    public boolean delete() throws SDatabaseException {
        this.checkInitialized();
        return this.cursor.getCursor().delete() == SOperationStatus.SUCCESS;
    }

    @Override
    public EntityCursor<V> dup() throws SDatabaseException {
        return new BasicCursor<V>(this.cursor.dup(true), this.adapter, this.updateAllowed);
    }

    @Override
    public void close() throws SDatabaseException {
        this.cursor.close();
    }

    void checkInitialized() throws IllegalStateException {
        if (!this.cursor.isInitialized()) {
            throw new IllegalStateException("Cursor is not initialized at a valid position");
        }
    }

    V returnValue(DbCompat.OpResult opResult) {
        V v = opResult.isSuccess() ? (V)this.adapter.entryToValue(this.key, this.pkey, this.data) : null;
        this.adapter.clearEntries(this.key, this.pkey, this.data);
        return v;
    }
}

