/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.GetHelper;
import com.sleepycat.client.PutHelper;
import com.sleepycat.client.SCacheFilePriority;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseEntryBase;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SMultipleDataEntry;
import com.sleepycat.client.SMultiplePairs;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.STransaction;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TCursor;
import com.sleepycat.thrift.TCursorGetConfig;
import com.sleepycat.thrift.TCursorGetMode;
import com.sleepycat.thrift.TCursorPutConfig;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TIsolationLevel;
import com.sleepycat.thrift.TKeyDataWithSecondaryKeys;
import java.util.Collections;
import java.util.Set;

public class SCursor
implements GetHelper,
PutHelper,
AutoCloseable {
    protected final TCursor tCursor;
    protected final BdbService.Client client;
    private final SDatabase database;
    private final STransaction txn;
    private SDatabaseEntry currentKey;

    protected SCursor(TCursor tCursor, SDatabase sDatabase, STransaction sTransaction, BdbService.Client client) {
        this.tCursor = tCursor;
        this.database = sDatabase;
        this.txn = sTransaction;
        this.client = client;
        this.currentKey = null;
    }

    @Override
    public void close() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.closeCursorHandle(this.tCursor);
            return null;
        });
    }

    public int compare(SCursor sCursor) throws SDatabaseException {
        return this.remoteCall(() -> this.client.cursorCompare(this.tCursor, sCursor.tCursor)).shortValue();
    }

    public int count() throws SDatabaseException {
        return this.remoteCall(() -> this.client.cursorCount(this.tCursor));
    }

    public SCursor dup(boolean bl) throws SDatabaseException {
        return this.remoteCall(() -> {
            TCursor tCursor = this.client.cursorDup(this.tCursor, bl);
            SCursor sCursor = new SCursor(tCursor, this.database, this.txn, this.client);
            if (bl) {
                sCursor.currentKey = this.currentKey;
            }
            return sCursor;
        });
    }

    public SCursorConfig getConfig() throws SDatabaseException {
        return this.remoteCall(() -> new SCursorConfig(this.client.getCursorConfig(this.tCursor)));
    }

    public SCacheFilePriority getPriority() throws SDatabaseException {
        return this.remoteCall(() -> SCacheFilePriority.toBdb(this.client.getCursorCachePriority(this.tCursor)));
    }

    public void setPriority(SCacheFilePriority sCacheFilePriority) throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.setCursorCachePriority(this.tCursor, SCacheFilePriority.toThrift(sCacheFilePriority));
            return null;
        });
    }

    public SDatabase getDatabase() {
        return this.database;
    }

    STransaction getTransaction() {
        return this.txn;
    }

    @Override
    public Set<SSecondaryDatabase> getSecondaryDatabases() {
        return this.database.getSecondaryDatabases();
    }

    public SOperationStatus getCurrent(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.CURRENT);
    }

    public SOperationStatus getFirst(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.FIRST);
    }

    public SOperationStatus getLast(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntry2, sLockMode, TCursorGetMode.LAST);
    }

    public SOperationStatus getNext(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.NEXT);
    }

    public SOperationStatus getNextDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.NEXT_DUP);
    }

    public SOperationStatus getNextNoDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.NEXT_NO_DUP);
    }

    public SOperationStatus getPrev(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntry2, sLockMode, TCursorGetMode.PREV);
    }

    public SOperationStatus getPrevDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntry2, sLockMode, TCursorGetMode.PREV_DUP);
    }

    public SOperationStatus getPrevNoDup(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntry2, sLockMode, TCursorGetMode.PREV_NO_DUP);
    }

    public SOperationStatus getRecordNumber(SDatabaseEntry sDatabaseEntry, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(null, sDatabaseEntry, sLockMode, TCursorGetMode.GET_RECNO);
    }

    public SOperationStatus getSearchBoth(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial key is not supported.");
        }
        if (sDatabaseEntryBase != null && !(sDatabaseEntryBase instanceof SDatabaseEntry)) {
            throw new IllegalArgumentException("data must be a SDatabaseEntry.");
        }
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.GET_BOTH);
    }

    public SOperationStatus getSearchBothRange(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial key is not supported.");
        }
        if (sDatabaseEntryBase != null && !(sDatabaseEntryBase instanceof SDatabaseEntry)) {
            throw new IllegalArgumentException("data must be a SDatabaseEntry.");
        }
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.GET_BOTH_RANGE);
    }

    public SOperationStatus getSearchKey(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial key is not supported.");
        }
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.SET);
    }

    public SOperationStatus getSearchKeyRange(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.SET_RANGE);
    }

    public SOperationStatus getSearchRecordNumber(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) throws SDatabaseException {
        if (sDatabaseEntry.getPartial()) {
            throw new IllegalArgumentException("Partial key is not supported.");
        }
        return this.cursorGet(sDatabaseEntry, sDatabaseEntryBase, sLockMode, TCursorGetMode.SET_RECNO);
    }

    private SOperationStatus cursorGet(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode, TCursorGetMode tCursorGetMode) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry2 = sDatabaseEntry == null ? new SDatabaseEntry() : sDatabaseEntry;
        SOperationStatus sOperationStatus = this.remoteGet(sDatabaseEntry2, sDatabaseEntryBase, tKeyData -> {
            TCursorGetConfig tCursorGetConfig = this.createConfig(sDatabaseEntryBase, sLockMode);
            tCursorGetConfig.setMode(tCursorGetMode);
            return this.client.cursorGet(this.tCursor, tKeyData, tCursorGetConfig);
        });
        if (sDatabaseEntryBase instanceof SMultiplePairs) {
            this.currentKey = null;
        } else if (tCursorGetMode != TCursorGetMode.GET_RECNO) {
            this.currentKey = new SDatabaseEntry(new TDbt((TDbt)sDatabaseEntry2.getThriftObj()));
        }
        return sOperationStatus;
    }

    protected TCursorGetConfig createConfig(SDatabaseEntryBase sDatabaseEntryBase, SLockMode sLockMode) {
        TCursorGetConfig tCursorGetConfig = new TCursorGetConfig();
        if (sLockMode != null) {
            switch (sLockMode) {
                case READ_COMMITTED: {
                    tCursorGetConfig.setIsoLevel(TIsolationLevel.READ_COMMITTED);
                    break;
                }
                case READ_UNCOMMITTED: {
                    tCursorGetConfig.setIsoLevel(TIsolationLevel.READ_UNCOMMITTED);
                    break;
                }
                case RMW: {
                    tCursorGetConfig.setRmw(true);
                }
            }
        }
        if (sDatabaseEntryBase instanceof SMultipleDataEntry) {
            tCursorGetConfig.setMultiple(true);
            tCursorGetConfig.setBatchSize(((SMultipleDataEntry)sDatabaseEntryBase).getBatchSize());
        } else if (sDatabaseEntryBase instanceof SMultiplePairs) {
            tCursorGetConfig.setMultiKey(true);
            tCursorGetConfig.setBatchSize(((SMultiplePairs)sDatabaseEntryBase).getBatchSize());
        }
        return tCursorGetConfig;
    }

    public SOperationStatus put(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursorPut(sDatabaseEntry, sDatabaseEntry2, TCursorPutConfig.DEFAULT);
    }

    public SOperationStatus putKeyFirst(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursorPut(sDatabaseEntry, sDatabaseEntry2, TCursorPutConfig.KEY_FIRST);
    }

    public SOperationStatus putKeyLast(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursorPut(sDatabaseEntry, sDatabaseEntry2, TCursorPutConfig.KEY_LAST);
    }

    public SOperationStatus putNoDupData(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursorPut(sDatabaseEntry, sDatabaseEntry2, TCursorPutConfig.NO_DUP_DATA);
    }

    public SOperationStatus putNoOverwrite(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        return this.cursorPut(sDatabaseEntry, sDatabaseEntry2, TCursorPutConfig.NO_OVERWRITE);
    }

    public SOperationStatus putAfter(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        if (this.currentKey == null) {
            throw new IllegalStateException("putAfter cannot be called when the cursor's position is not set or right after a MULTIPLE_KEY get operation or a delete operation.");
        }
        sDatabaseEntry.setDataFromTDbt((TDbt)this.currentKey.getThriftObj());
        return this.cursorPut(sDatabaseEntry, sDatabaseEntry2, TCursorPutConfig.AFTER);
    }

    public SOperationStatus putBefore(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) throws SDatabaseException {
        if (this.currentKey == null) {
            throw new IllegalStateException("putBefore cannot be called when the cursor's position is not set or right after a MULTIPLE_KEY get operation or a delete operation.");
        }
        sDatabaseEntry.setDataFromTDbt((TDbt)this.currentKey.getThriftObj());
        return this.cursorPut(sDatabaseEntry, sDatabaseEntry2, TCursorPutConfig.BEFORE);
    }

    public SOperationStatus putCurrent(SDatabaseEntry sDatabaseEntry) throws SDatabaseException {
        if (this.currentKey == null) {
            throw new IllegalStateException("putCurrent cannot be called when the cursor's position is not set or right after a MULTIPLE_KEY get operation or a delete operation.");
        }
        return this.cursorPut(this.currentKey, sDatabaseEntry, TCursorPutConfig.CURRENT);
    }

    private SOperationStatus cursorPut(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, TCursorPutConfig tCursorPutConfig) throws SDatabaseException {
        SOperationStatus sOperationStatus = this.remotePut(Collections.singletonList(this.calculateSKey(sDatabaseEntry, sDatabaseEntry2)), sDatabaseEntry, list -> this.client.cursorPut(this.tCursor, (TKeyDataWithSecondaryKeys)list.get(0), tCursorPutConfig));
        this.currentKey = new SDatabaseEntry(new TDbt((TDbt)sDatabaseEntry.getThriftObj()));
        return sOperationStatus;
    }

    public SOperationStatus delete() throws SDatabaseException {
        this.getDatabase().updatePrimaryData(this.txn, Collections.singletonList(this.currentKey));
        return this.remoteCall(() -> SOperationStatus.toBdb(this.client.cursorDelete(this.tCursor)));
    }
}

