/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SJoinConfig;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryConfig;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.SSecondaryKeyCreator;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.bind.RecordNumberBinding;
import com.sleepycat.client.collections.CurrentTransaction;
import com.sleepycat.client.collections.DataCursor;
import com.sleepycat.client.collections.PrimaryKeyAssigner;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import com.sleepycat.client.util.keyrange.KeyRange;
import com.sleepycat.client.util.keyrange.KeyRangeException;
import java.nio.ByteOrder;

final class DataView
implements Cloneable {
    SDatabase db;
    SSecondaryDatabase secDb;
    CurrentTransaction currentTxn;
    KeyRange range;
    EntryBinding keyBinding;
    EntryBinding valueBinding;
    EntityBinding entityBinding;
    PrimaryKeyAssigner keyAssigner;
    SSecondaryKeyCreator secKeyCreator;
    SCursorConfig cursorConfig;
    boolean writeAllowed;
    boolean ordered;
    boolean keyRangesAllowed;
    boolean recNumAllowed;
    boolean recNumAccess;
    boolean btreeRecNumDb;
    boolean btreeRecNumAccess;
    boolean recNumRenumber;
    boolean keysRenumbered;
    boolean dupsAllowed;
    boolean dupsOrdered;
    boolean transactional;
    boolean readUncommittedAllowed;
    SDatabaseEntry dupsKey;
    boolean dupsView;
    KeyRange dupsRange;

    DataView(SDatabase sDatabase, EntryBinding entryBinding, EntryBinding entryBinding2, EntityBinding entityBinding, boolean bl, PrimaryKeyAssigner primaryKeyAssigner) throws IllegalArgumentException {
        if (sDatabase == null) {
            throw new IllegalArgumentException("database is null");
        }
        this.db = sDatabase;
        try {
            SDatabaseConfig sDatabaseConfig;
            this.currentTxn = CurrentTransaction.getInstanceInternal(this.db.getEnvironment());
            if (this.db instanceof SSecondaryDatabase) {
                this.secDb = (SSecondaryDatabase)sDatabase;
                SSecondaryConfig sSecondaryConfig = this.secDb.getSecondaryConfig();
                this.secKeyCreator = sSecondaryConfig.getKeyCreator();
                sDatabaseConfig = sSecondaryConfig;
            } else {
                sDatabaseConfig = this.db.getConfig();
            }
            this.ordered = !DbCompat.isTypeHash(sDatabaseConfig);
            this.keyRangesAllowed = DbCompat.isTypeBtree(sDatabaseConfig);
            this.recNumAllowed = DbCompat.isTypeQueue(sDatabaseConfig) || DbCompat.isTypeRecno(sDatabaseConfig) || DbCompat.getBtreeRecordNumbers(sDatabaseConfig);
            this.recNumRenumber = DbCompat.getRenumbering(sDatabaseConfig);
            this.dupsAllowed = DbCompat.getSortedDuplicates(sDatabaseConfig) || DbCompat.getUnsortedDuplicates(sDatabaseConfig);
            this.dupsOrdered = DbCompat.getSortedDuplicates(sDatabaseConfig);
            this.transactional = this.currentTxn.isTxnMode() && sDatabaseConfig.getTransactional();
            this.readUncommittedAllowed = DbCompat.getReadUncommitted(sDatabaseConfig);
            this.btreeRecNumDb = this.recNumAllowed && DbCompat.isTypeBtree(sDatabaseConfig);
            this.range = new KeyRange(sDatabaseConfig.getBtreeComparator());
        }
        catch (SDatabaseException sDatabaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
        }
        this.writeAllowed = bl;
        this.keyBinding = entryBinding;
        this.valueBinding = entryBinding2;
        this.entityBinding = entityBinding;
        this.keyAssigner = primaryKeyAssigner;
        this.cursorConfig = SCursorConfig.DEFAULT;
        if (entryBinding2 != null && entityBinding != null) {
            throw new IllegalArgumentException("both valueBinding and entityBinding are non-null");
        }
        if (entryBinding instanceof RecordNumberBinding) {
            if (!this.recNumAllowed) {
                throw new IllegalArgumentException("RecordNumberBinding requires DB_BTREE/DB_RECNUM, DB_RECNO, or DB_QUEUE");
            }
            this.recNumAccess = true;
            if (this.btreeRecNumDb) {
                this.btreeRecNumAccess = true;
            }
        }
        this.keysRenumbered = this.recNumRenumber || this.btreeRecNumAccess;
    }

    private DataView cloneView() {
        try {
            return (DataView)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw DbCompat.unexpectedState();
        }
    }

    DataView keySetView() {
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException("Must have keyBinding");
        }
        DataView dataView = this.cloneView();
        dataView.valueBinding = null;
        dataView.entityBinding = null;
        return dataView;
    }

    DataView valueSetView() {
        if (this.valueBinding == null && this.entityBinding == null) {
            throw new UnsupportedOperationException("Must have valueBinding or entityBinding");
        }
        DataView dataView = this.cloneView();
        dataView.keyBinding = null;
        return dataView;
    }

    DataView valueSetView(Object object) throws SDatabaseException, KeyRangeException {
        KeyRange keyRange = this.subRange(this.range, object);
        DataView dataView = this.valueSetView();
        dataView.range = keyRange;
        return dataView;
    }

    DataView subView(Object object, boolean bl, Object object2, boolean bl2, EntryBinding entryBinding) throws SDatabaseException, KeyRangeException {
        DataView dataView = this.cloneView();
        dataView.setRange(object, bl, object2, bl2);
        if (entryBinding != null) {
            dataView.keyBinding = entryBinding;
        }
        return dataView;
    }

    DataView duplicatesView(Object object, EntryBinding entryBinding) throws SDatabaseException, KeyRangeException {
        if (!this.isSecondary()) {
            throw new UnsupportedOperationException("Only allowed for maps on secondary databases");
        }
        if (this.dupsView) {
            throw DbCompat.unexpectedState();
        }
        DataView dataView = this.cloneView();
        dataView.range = this.subRange(dataView.range, object);
        dataView.dupsKey = dataView.range.getSingleKey();
        dataView.dupsView = true;
        dataView.keyBinding = entryBinding;
        return dataView;
    }

    DataView configuredView(SCursorConfig sCursorConfig) {
        DataView dataView = this.cloneView();
        dataView.cursorConfig = sCursorConfig != null ? DbCompat.cloneCursorConfig(sCursorConfig) : SCursorConfig.DEFAULT;
        return dataView;
    }

    CurrentTransaction getCurrentTxn() {
        return this.transactional ? this.currentTxn : null;
    }

    private void setRange(Object object, boolean bl, Object object2, boolean bl2) throws SDatabaseException, KeyRangeException {
        if (!(object == null && object2 == null || this.keyRangesAllowed)) {
            throw new UnsupportedOperationException("Key ranges allowed only for BTREE databases");
        }
        KeyRange keyRange = this.useSubRange();
        keyRange = this.subRange(keyRange, object, bl, object2, bl2);
        if (this.dupsView) {
            this.dupsRange = keyRange;
        } else {
            this.range = keyRange;
        }
    }

    SDatabaseEntry getSingleKeyThang() {
        return this.range.getSingleKey();
    }

    final SEnvironment getEnv() {
        return this.currentTxn.getEnvironment();
    }

    final boolean isSecondary() {
        return this.secDb != null;
    }

    boolean isEmpty() throws SDatabaseException {
        try (DataCursor dataCursor = new DataCursor(this, false);){
            boolean bl = dataCursor.getFirst(false) != SOperationStatus.SUCCESS;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SOperationStatus append(Object object, Object[] objectArray, Object[] objectArray2) throws SDatabaseException {
        SOperationStatus sOperationStatus;
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        this.useValue(object, sDatabaseEntry2, null);
        if (this.keyAssigner != null) {
            this.keyAssigner.assignKey(sDatabaseEntry);
            if (!this.range.check(sDatabaseEntry)) {
                throw new IllegalArgumentException("assigned key out of range");
            }
            try (DataCursor dataCursor = new DataCursor(this, true);){
                sOperationStatus = dataCursor.getCursor().putNoOverwrite(sDatabaseEntry, sDatabaseEntry2);
            }
        } else {
            throw new IllegalStateException("Key assigner must be used.");
        }
        if (sOperationStatus == SOperationStatus.SUCCESS) {
            this.returnPrimaryKeyAndValue(sDatabaseEntry, sDatabaseEntry2, objectArray, objectArray2);
        }
        return sOperationStatus;
    }

    STransaction useTransaction() {
        return this.transactional ? this.currentTxn.getTransaction() : null;
    }

    void clear() throws SDatabaseException {
        try (DataCursor dataCursor = new DataCursor(this, true);){
            SOperationStatus sOperationStatus = SOperationStatus.SUCCESS;
            while (sOperationStatus == SOperationStatus.SUCCESS) {
                sOperationStatus = this.keysRenumbered ? dataCursor.getFirst(true) : dataCursor.getNext(true);
                if (sOperationStatus != SOperationStatus.SUCCESS) continue;
                dataCursor.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataCursor join(DataView[] dataViewArray, Object[] objectArray, SJoinConfig sJoinConfig) throws SDatabaseException {
        DataCursor dataCursor = null;
        DataCursor[] dataCursorArray = new DataCursor[dataViewArray.length];
        try {
            for (int i = 0; i < dataViewArray.length; ++i) {
                dataCursorArray[i] = new DataCursor(dataViewArray[i], false);
                dataCursorArray[i].getSearchKey(objectArray[i], null, false);
            }
            DataCursor dataCursor2 = dataCursor = new DataCursor(this, dataCursorArray, sJoinConfig, true);
            return dataCursor2;
        }
        finally {
            if (dataCursor == null) {
                for (int i = 0; i < dataCursorArray.length; ++i) {
                    if (dataCursorArray[i] == null) continue;
                    try {
                        dataCursorArray[i].close();
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    DataCursor join(DataCursor[] dataCursorArray, SJoinConfig sJoinConfig) throws SDatabaseException {
        return new DataCursor(this, dataCursorArray, sJoinConfig, false);
    }

    private void returnPrimaryKeyAndValue(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("returning key requires primary key binding");
            }
            if (this.isSecondary()) {
                throw new IllegalArgumentException("returning key requires unindexed view");
            }
            objectArray[0] = this.keyBinding.entryToObject(sDatabaseEntry);
        }
        if (objectArray2 != null) {
            objectArray2[0] = this.makeValue(sDatabaseEntry, sDatabaseEntry2);
        }
    }

    boolean useKey(Object object, Object object2, SDatabaseEntry sDatabaseEntry, KeyRange keyRange) throws SDatabaseException {
        if (object != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("non-null key with null key binding");
            }
            this.keyBinding.objectToEntry(object, sDatabaseEntry);
        } else {
            if (object2 == null) {
                throw new IllegalArgumentException("null key and null value");
            }
            if (this.entityBinding == null) {
                throw new IllegalStateException("EntityBinding required to derive key from value");
            }
            if (!this.dupsView && this.isSecondary()) {
                SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
                this.entityBinding.objectToKey(object2, sDatabaseEntry2);
                SDatabaseEntry sDatabaseEntry3 = new SDatabaseEntry();
                this.entityBinding.objectToData(object2, sDatabaseEntry3);
                this.secKeyCreator.createSecondaryKey(this.secDb, sDatabaseEntry2, sDatabaseEntry3, sDatabaseEntry);
            } else {
                this.entityBinding.objectToKey(object2, sDatabaseEntry);
            }
        }
        if (this.recNumAccess && DbCompat.getRecordNumber(sDatabaseEntry, this.getServerByteOrder()) <= 0) {
            return false;
        }
        return keyRange == null || keyRange.check(sDatabaseEntry);
    }

    ByteOrder getServerByteOrder() {
        return this.db.getServerByteOrder();
    }

    final boolean canDeriveKeyFromValue() {
        return this.entityBinding != null;
    }

    void useValue(Object object, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        if (this.valueBinding != null) {
            this.valueBinding.objectToEntry(object, sDatabaseEntry);
        } else if (this.entityBinding != null) {
            if (object == null) {
                throw new IllegalArgumentException("null value with entity binding");
            }
            this.entityBinding.objectToData(object, sDatabaseEntry);
            if (sDatabaseEntry2 != null) {
                SDatabaseEntry sDatabaseEntry3 = new SDatabaseEntry();
                this.entityBinding.objectToKey(object, sDatabaseEntry3);
                if (!KeyRange.equalBytes(sDatabaseEntry3, sDatabaseEntry2)) {
                    throw new IllegalArgumentException("cannot change primary key");
                }
            }
        } else {
            if (object != null) {
                throw new IllegalArgumentException("non-null value with null value/entity binding");
            }
            sDatabaseEntry.setData(KeyRange.ZERO_LENGTH_BYTE_ARRAY);
        }
    }

    Object makeKey(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        SDatabaseEntry sDatabaseEntry3;
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException();
        }
        SDatabaseEntry sDatabaseEntry4 = sDatabaseEntry3 = this.dupsView ? sDatabaseEntry2 : sDatabaseEntry;
        if (sDatabaseEntry3.getSize() == 0) {
            return null;
        }
        return this.keyBinding.entryToObject(sDatabaseEntry3);
    }

    Object makeValue(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2) {
        Object e;
        if (this.valueBinding != null) {
            e = this.valueBinding.entryToObject(sDatabaseEntry2);
        } else if (this.entityBinding != null) {
            e = this.entityBinding.entryToObject(sDatabaseEntry, sDatabaseEntry2);
        } else {
            throw new UnsupportedOperationException("Requires valueBinding or entityBinding");
        }
        return e;
    }

    KeyRange subRange(KeyRange keyRange, Object object) throws SDatabaseException, KeyRangeException {
        return keyRange.subRange(this.makeRangeKey(object));
    }

    KeyRange subRange(KeyRange keyRange, Object object, boolean bl, Object object2, boolean bl2) throws SDatabaseException, KeyRangeException {
        if (object == object2 && bl && bl2) {
            return this.subRange(keyRange, object);
        }
        if (!this.ordered) {
            throw new UnsupportedOperationException("Cannot use key ranges on an unsorted database");
        }
        SDatabaseEntry sDatabaseEntry = object != null ? this.makeRangeKey(object) : null;
        SDatabaseEntry sDatabaseEntry2 = object2 != null ? this.makeRangeKey(object2) : null;
        return keyRange.subRange(sDatabaseEntry, bl, sDatabaseEntry2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyRange useSubRange() throws SDatabaseException {
        if (this.dupsView) {
            DataView dataView = this;
            synchronized (dataView) {
                if (this.dupsRange == null) {
                    SDatabaseConfig sDatabaseConfig = this.secDb.getPrimaryDatabase().getConfig();
                    this.dupsRange = new KeyRange(sDatabaseConfig.getBtreeComparator());
                }
            }
            return this.dupsRange;
        }
        return this.range;
    }

    private SDatabaseEntry makeRangeKey(Object object) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        if (this.keyBinding != null) {
            this.useKey(object, null, sDatabaseEntry, null);
        } else {
            this.useKey(null, object, sDatabaseEntry, null);
        }
        return sDatabaseEntry;
    }
}

