/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class IntegerBinding
extends TupleBinding<Integer> {
    private static final int INT_SIZE = 4;

    @Override
    public Integer entryToObject(TupleInput tupleInput) {
        return tupleInput.readInt();
    }

    @Override
    public void objectToEntry(Integer n, TupleOutput tupleOutput) {
        tupleOutput.writeInt(n);
    }

    @Override
    protected TupleOutput getTupleOutput(Integer n) {
        return IntegerBinding.sizedOutput();
    }

    public static int entryToInt(SDatabaseEntry sDatabaseEntry) {
        return IntegerBinding.entryToInput(sDatabaseEntry).readInt();
    }

    public static void intToEntry(int n, SDatabaseEntry sDatabaseEntry) {
        IntegerBinding.outputToEntry(IntegerBinding.sizedOutput().writeInt(n), sDatabaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[4]);
    }
}

