/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.tuple;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.tuple.TupleBinding;
import com.sleepycat.client.bind.tuple.TupleInput;
import com.sleepycat.client.bind.tuple.TupleOutput;

public class DoubleBinding
extends TupleBinding<Double> {
    private static final int DOUBLE_SIZE = 8;

    @Override
    public Double entryToObject(TupleInput tupleInput) {
        return tupleInput.readDouble();
    }

    @Override
    public void objectToEntry(Double d, TupleOutput tupleOutput) {
        tupleOutput.writeDouble(d);
    }

    @Override
    protected TupleOutput getTupleOutput(Double d) {
        return DoubleBinding.sizedOutput();
    }

    public static double entryToDouble(SDatabaseEntry sDatabaseEntry) {
        return DoubleBinding.entryToInput(sDatabaseEntry).readDouble();
    }

    public static void doubleToEntry(double d, SDatabaseEntry sDatabaseEntry) {
        DoubleBinding.outputToEntry(DoubleBinding.sizedOutput().writeDouble(d), sDatabaseEntry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

