/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.serial;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironmentConfig;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.bind.serial.ClassCatalog;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import com.sleepycat.client.util.UtfOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;

public class StoredClassCatalog
implements ClassCatalog {
    private static final byte REC_LAST_CLASS_ID = 0;
    private static final byte REC_CLASS_FORMAT = 1;
    private static final byte REC_CLASS_INFO = 2;
    private static final byte[] LAST_CLASS_ID_KEY = new byte[]{0};
    private SDatabase db;
    private HashMap<String, ClassInfo> classMap;
    private HashMap<BigInteger, ObjectStreamClass> formatMap;
    private SLockMode writeLockMode;
    private boolean cdbMode;
    private boolean txnMode;
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    public StoredClassCatalog(SDatabase sDatabase) throws SDatabaseException, IllegalArgumentException {
        this.db = sDatabase;
        SDatabaseConfig sDatabaseConfig = this.db.getConfig();
        SEnvironmentConfig sEnvironmentConfig = this.db.getEnvironment().getConfig();
        this.writeLockMode = DbCompat.getInitializeLocking(sEnvironmentConfig) || sEnvironmentConfig.getTransactional() ? SLockMode.RMW : SLockMode.DEFAULT;
        this.cdbMode = DbCompat.getInitializeCDB(sEnvironmentConfig);
        this.txnMode = sDatabaseConfig.getTransactional();
        if (!DbCompat.isTypeBtree(sDatabaseConfig)) {
            throw new IllegalArgumentException("The class catalog must be a BTREE database.");
        }
        if (DbCompat.getSortedDuplicates(sDatabaseConfig) || DbCompat.getUnsortedDuplicates(sDatabaseConfig)) {
            throw new IllegalArgumentException("The class catalog database must not allow duplicates.");
        }
        this.classMap = new HashMap();
        this.formatMap = new HashMap();
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry(LAST_CLASS_ID_KEY);
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        if (sDatabaseConfig.getReadOnly()) {
            SOperationStatus sOperationStatus = this.db.get(null, sDatabaseEntry, sDatabaseEntry2, null);
            if (sOperationStatus != SOperationStatus.SUCCESS) {
                throw DbCompat.unexpectedState("A read-only catalog database may not be empty");
            }
        } else {
            sDatabaseEntry2.setData(new byte[1]);
            SOperationStatus sOperationStatus = this.db.get(null, sDatabaseEntry, sDatabaseEntry2, null);
            if (sOperationStatus == SOperationStatus.NOTFOUND) {
                this.db.putNoOverwrite(null, sDatabaseEntry, sDatabaseEntry2);
            }
        }
    }

    @Override
    public synchronized void close() throws SDatabaseException {
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
        this.formatMap = null;
        this.classMap = null;
    }

    @Override
    public synchronized byte[] getClassID(ObjectStreamClass objectStreamClass) throws SDatabaseException, ClassNotFoundException {
        ClassInfo classInfo = this.getClassInfo(objectStreamClass);
        return classInfo.getClassID();
    }

    @Override
    public synchronized ObjectStreamClass getClassFormat(byte[] byArray) throws SDatabaseException, ClassNotFoundException {
        return this.getClassFormat(byArray, new SDatabaseEntry());
    }

    private ObjectStreamClass getClassFormat(byte[] byArray, SDatabaseEntry sDatabaseEntry) throws SDatabaseException, ClassNotFoundException {
        BigInteger bigInteger = new BigInteger(byArray);
        ObjectStreamClass objectStreamClass = this.formatMap.get(bigInteger);
        if (objectStreamClass == null) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = 1;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry(byArray2);
            SOperationStatus sOperationStatus = this.db.get(null, sDatabaseEntry2, sDatabaseEntry, SLockMode.DEFAULT);
            if (sOperationStatus != SOperationStatus.SUCCESS) {
                throw new ClassNotFoundException("Catalog class ID not found");
            }
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), sDatabaseEntry.getSize()));
                objectStreamClass = (ObjectStreamClass)objectInputStream.readObject();
            }
            catch (IOException iOException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
            }
            this.formatMap.put(bigInteger, objectStreamClass);
        }
        return objectStreamClass;
    }

    private ClassInfo getClassInfo(ObjectStreamClass objectStreamClass) throws SDatabaseException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        ClassInfo classInfo = this.classMap.get(string);
        if (classInfo != null) {
            return classInfo;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[1 + UtfOps.getByteLength(cArray)];
        byArray[0] = 2;
        UtfOps.charsToBytes(cArray, 0, byArray, 1, cArray.length);
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry(byArray);
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        SOperationStatus sOperationStatus = this.db.get(null, sDatabaseEntry, sDatabaseEntry2, SLockMode.DEFAULT);
        if (sOperationStatus != SOperationStatus.SUCCESS) {
            classInfo = this.putClassInfo(new ClassInfo(), string, sDatabaseEntry, objectStreamClass);
        } else {
            classInfo = new ClassInfo(sDatabaseEntry2);
            SDatabaseEntry sDatabaseEntry3 = new SDatabaseEntry();
            ObjectStreamClass objectStreamClass2 = this.getClassFormat(classInfo.getClassID(), sDatabaseEntry3);
            if (!StoredClassCatalog.areClassFormatsEqual(objectStreamClass2, StoredClassCatalog.getBytes(sDatabaseEntry3), objectStreamClass)) {
                classInfo = this.putClassInfo(classInfo, string, sDatabaseEntry, objectStreamClass);
            }
            classInfo.setClassFormat(objectStreamClass);
            this.classMap.put(string, classInfo);
        }
        return classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassInfo putClassInfo(ClassInfo classInfo, String string, SDatabaseEntry sDatabaseEntry, ObjectStreamClass objectStreamClass) throws SDatabaseException {
        SCursorConfig sCursorConfig = null;
        if (this.cdbMode) {
            sCursorConfig = new SCursorConfig();
            DbCompat.setWriteCursor(sCursorConfig, true);
        }
        SCursor sCursor = null;
        STransaction sTransaction = null;
        try {
            SDatabaseEntry sDatabaseEntry2;
            SDatabaseEntry sDatabaseEntry3;
            SOperationStatus sOperationStatus;
            if (this.txnMode) {
                sTransaction = this.db.getEnvironment().beginTransaction(null, null);
            }
            if ((sOperationStatus = (sCursor = this.db.openCursor(sTransaction, sCursorConfig)).getSearchKey(sDatabaseEntry3 = new SDatabaseEntry(LAST_CLASS_ID_KEY), sDatabaseEntry2 = new SDatabaseEntry(), this.writeLockMode)) != SOperationStatus.SUCCESS) {
                throw DbCompat.unexpectedState("Class ID not initialized");
            }
            byte[] byArray = StoredClassCatalog.getBytes(sDatabaseEntry2);
            byArray = StoredClassCatalog.incrementID(byArray);
            sDatabaseEntry2.setData(byArray);
            sCursor.put(sDatabaseEntry3, sDatabaseEntry2);
            byte[] byArray2 = new byte[1 + byArray.length];
            byArray2[0] = 1;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            sDatabaseEntry3.setData(byArray2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(objectStreamClass);
            }
            catch (IOException iOException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
            }
            sDatabaseEntry2.setData(byteArrayOutputStream.toByteArray());
            sCursor.put(sDatabaseEntry3, sDatabaseEntry2);
            classInfo.setClassID(byArray);
            classInfo.toDbt(sDatabaseEntry2);
            sCursor.put(sDatabaseEntry, sDatabaseEntry2);
            classInfo.setClassFormat(objectStreamClass);
            this.classMap.put(string, classInfo);
            this.formatMap.put(new BigInteger(byArray), objectStreamClass);
            ClassInfo classInfo2 = classInfo;
            return classInfo2;
        }
        finally {
            if (sCursor != null) {
                sCursor.close();
            }
            if (sTransaction != null) {
                sTransaction.commit();
            }
        }
    }

    private static byte[] incrementID(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        bigInteger = bigInteger.add(BigInteger.valueOf(1L));
        return bigInteger.toByteArray();
    }

    private static boolean areClassFormatsEqual(ObjectStreamClass objectStreamClass, byte[] byArray, ObjectStreamClass objectStreamClass2) {
        try {
            if (byArray == null) {
                byArray = StoredClassCatalog.getObjectBytes(objectStreamClass);
            }
            byte[] byArray2 = StoredClassCatalog.getObjectBytes(objectStreamClass2);
            return Arrays.equals(byArray2, byArray);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static byte[] getBytes(SDatabaseEntry sDatabaseEntry) {
        byte[] byArray = sDatabaseEntry.getData();
        if (byArray == null) {
            return null;
        }
        if (sDatabaseEntry.getOffset() == 0 && byArray.length == sDatabaseEntry.getSize()) {
            return byArray;
        }
        int n = sDatabaseEntry.getSize();
        if (n == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, sDatabaseEntry.getOffset(), byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static byte[] getObjectBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public ClassLoader getClassLoader() {
        try {
            return DbCompat.getClassLoader(this.db.getEnvironment());
        }
        catch (SDatabaseException sDatabaseException) {
            throw new RuntimeException(sDatabaseException);
        }
    }

    private static class ClassInfo
    implements Serializable {
        static final long serialVersionUID = 3845446969989650562L;
        private byte[] classID;
        private transient ObjectStreamClass classFormat;

        ClassInfo() {
        }

        ClassInfo(SDatabaseEntry sDatabaseEntry) {
            byte[] byArray = sDatabaseEntry.getData();
            byte by = byArray[0];
            this.classID = new byte[by];
            System.arraycopy(byArray, 1, this.classID, 0, by);
        }

        void toDbt(SDatabaseEntry sDatabaseEntry) {
            byte[] byArray = new byte[1 + this.classID.length];
            byArray[0] = (byte)this.classID.length;
            System.arraycopy(this.classID, 0, byArray, 1, this.classID.length);
            sDatabaseEntry.setData(byArray);
        }

        void setClassID(byte[] byArray) {
            this.classID = byArray;
        }

        byte[] getClassID() {
            return this.classID;
        }

        ObjectStreamClass getClassFormat() {
            return this.classFormat;
        }

        void setClassFormat(ObjectStreamClass objectStreamClass) {
            this.classFormat = objectStreamClass;
        }
    }
}

