/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.serial;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.bind.serial.ClassCatalog;
import com.sleepycat.client.bind.serial.SerialBase;
import com.sleepycat.client.bind.serial.SerialInput;
import com.sleepycat.client.bind.serial.SerialOutput;
import com.sleepycat.client.util.FastInputStream;
import com.sleepycat.client.util.FastOutputStream;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class SerialBinding<E>
extends SerialBase
implements EntryBinding<E> {
    private ClassCatalog classCatalog;
    private Class<E> baseClass;

    public SerialBinding(ClassCatalog classCatalog, Class<E> clazz) {
        if (classCatalog == null) {
            throw new NullPointerException("classCatalog must be non-null");
        }
        this.classCatalog = classCatalog;
        this.baseClass = clazz;
    }

    public final Class<E> getBaseClass() {
        return this.baseClass;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.classCatalog.getClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public E entryToObject(SDatabaseEntry sDatabaseEntry) {
        int n = sDatabaseEntry.getSize();
        byte[] byArray = SerialOutput.getStreamHeader();
        byte[] byArray2 = new byte[n + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(sDatabaseEntry.getData(), sDatabaseEntry.getOffset(), byArray2, byArray.length, n);
        try {
            SerialInput serialInput = new SerialInput(new FastInputStream(byArray2, 0, byArray2.length), this.classCatalog, this.getClassLoader());
            return (E)serialInput.readObject();
        }
        catch (IOException iOException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(classNotFoundException);
        }
    }

    @Override
    public void objectToEntry(E e, SDatabaseEntry sDatabaseEntry) {
        Object object;
        if (this.baseClass != null && !this.baseClass.isInstance(e)) {
            throw new IllegalArgumentException((e != null ? "Data object class (" + e.getClass() + ')' : "Null value") + " is not an instance of binding's base class (" + this.baseClass + ')');
        }
        FastOutputStream fastOutputStream = this.getSerialOutput(e);
        try {
            object = new SerialOutput(fastOutputStream, this.classCatalog);
            ((ObjectOutputStream)object).writeObject(e);
        }
        catch (IOException iOException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
        }
        object = SerialOutput.getStreamHeader();
        sDatabaseEntry.setData(fastOutputStream.getBufferBytes(), ((Object)object).length, fastOutputStream.getBufferLength() - ((Object)object).length);
    }
}

