/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.compat.DbCompat;
import java.nio.ByteOrder;
import java.util.Objects;

public class RecordNumberBinding
implements EntryBinding {
    private final ByteOrder byteOrder;

    public RecordNumberBinding(ByteOrder byteOrder) {
        this.byteOrder = Objects.requireNonNull(byteOrder);
    }

    public Long entryToObject(SDatabaseEntry sDatabaseEntry) {
        return RecordNumberBinding.entryToRecordNumber(sDatabaseEntry, this.byteOrder);
    }

    public void objectToEntry(Object object, SDatabaseEntry sDatabaseEntry) {
        RecordNumberBinding.recordNumberToEntry(((Number)object).longValue(), sDatabaseEntry, this.byteOrder);
    }

    public static long entryToRecordNumber(SDatabaseEntry sDatabaseEntry, ByteOrder byteOrder) {
        return (long)DbCompat.getRecordNumber(sDatabaseEntry, byteOrder) & 0xFFFFFFFFL;
    }

    public static void recordNumberToEntry(long l, SDatabaseEntry sDatabaseEntry, ByteOrder byteOrder) {
        sDatabaseEntry.setData(new byte[4], 0, 4);
        DbCompat.setRecordNumber(sDatabaseEntry, (int)l, byteOrder);
    }
}

