/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.handle;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.server.handle.HandleDescriptor;
import com.sleepycat.server.handle.ResourceKey;
import com.sleepycat.server.handle.ResourceMemberManager;
import com.sleepycat.server.handle.ResourceMembers;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleManager {
    private static final Logger logger = LoggerFactory.getLogger(HandleManager.class);
    private AtomicLong idCounter = new AtomicLong(0L);
    private ConcurrentMap<Long, HandleDescriptor> idMap = new ConcurrentHashMap<Long, HandleDescriptor>();
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private ResourceMemberManager resourceManager = new ResourceMemberManager();

    public HandleDescriptor register(HandleDescriptor handleDescriptor) {
        long l;
        do {
            if ((l = this.idCounter.incrementAndGet()) == 0L) {
                throw new IllegalStateException("No new handle id available.");
            }
            handleDescriptor.registerManager(this, l);
        } while (this.idMap.putIfAbsent(l, handleDescriptor) != null);
        this.resourceManager.register(handleDescriptor);
        if (this.shutdown.get()) {
            this.closeDescriptor(handleDescriptor);
        }
        return handleDescriptor;
    }

    public void closeHandle(long l) throws DatabaseException {
        this.closeHandle(l, handleDescriptor -> {});
    }

    public void closeHandle(long l, Consumer<HandleDescriptor> consumer) throws DatabaseException {
        HandleDescriptor handleDescriptor = (HandleDescriptor)this.idMap.remove(l);
        if (handleDescriptor != null) {
            consumer.accept(handleDescriptor);
            DatabaseException databaseException = this.closeDescriptor(handleDescriptor);
            if (databaseException != null) {
                throw databaseException;
            }
        } else {
            throw new IllegalArgumentException("The handle is closed or expired.");
        }
    }

    public DatabaseException closeHandles(Collection<HandleDescriptor> collection) {
        DatabaseException databaseException = null;
        for (HandleDescriptor handleDescriptor : collection) {
            if (this.idMap.remove(handleDescriptor.getId()) == null) continue;
            DatabaseException databaseException2 = this.closeDescriptor(handleDescriptor);
            if (databaseException != null) continue;
            databaseException = databaseException2;
        }
        return databaseException;
    }

    public void closeInactiveHandles(int n) {
        long l = System.currentTimeMillis();
        List<HandleDescriptor> list = this.idMap.values().stream().filter(handleDescriptor -> handleDescriptor.isExpired(l, (long)n * 1000L)).collect(Collectors.toList());
        DatabaseException databaseException = this.closeHandles(list);
        if (databaseException != null) {
            logger.warn("Failed to close inactive handles.", (Throwable)databaseException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseException closeDescriptor(HandleDescriptor handleDescriptor) {
        handleDescriptor.writeLock();
        try {
            this.idMap.remove(handleDescriptor.getId());
            this.resourceManager.remove(handleDescriptor);
            DatabaseException databaseException = handleDescriptor.close();
            if (databaseException != null) {
                logger.warn("Failed to close handle. " + handleDescriptor, (Throwable)databaseException);
            }
            DatabaseException databaseException2 = databaseException;
            return databaseException2;
        }
        finally {
            handleDescriptor.unlockWrite();
        }
    }

    public HandleDescriptor readLockHandle(long l) {
        HandleDescriptor handleDescriptor = (HandleDescriptor)this.idMap.get(l);
        if (handleDescriptor != null && handleDescriptor.tryReadLock()) {
            try {
                if (this.idMap.containsKey(l)) {
                    handleDescriptor.touch(System.currentTimeMillis());
                    return handleDescriptor;
                }
            }
            catch (RuntimeException runtimeException) {
                handleDescriptor.unlockRead();
                throw runtimeException;
            }
            handleDescriptor.unlockRead();
        }
        throw new IllegalArgumentException("The handle is closed or expired.");
    }

    public void unlockHandle(HandleDescriptor handleDescriptor) {
        if (handleDescriptor != null) {
            handleDescriptor.unlockRead();
        }
    }

    public ResourceMembers getResourceMembers(ResourceKey resourceKey) {
        return this.resourceManager.getResourceMembers(resourceKey);
    }

    public ResourceMembers readLockResource(ResourceKey resourceKey) {
        return this.resourceManager.readLockResource(resourceKey);
    }

    public void unlockRead(ResourceMembers resourceMembers) {
        this.resourceManager.unlockRead(resourceMembers);
    }

    public ResourceMembers writeLockResource(ResourceKey resourceKey) {
        return this.resourceManager.writeLockResource(resourceKey);
    }

    public void unlockWrite(ResourceMembers resourceMembers) {
        this.resourceManager.unlockWrite(resourceMembers);
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.closeHandles(this.idMap.values());
        }
    }
}

