/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `afblue.dat'.                           */

/***************************************************************************/
/*                                                                         */
/*  afblue.h                                                               */
/*                                                                         */
/*    Auto-fitter data for blue strings (specification).                   */
/*                                                                         */
/*  Copyright 2013-2017 by                                                 */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/


#ifndef AFBLUE_H_
#define AFBLUE_H_


FT_BEGIN_HEADER


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed     */
#define GET_UTF8_CHAR( ch, p )                      \
          do                                        \
          {                                         \
            ch = (unsigned char)*p++;               \
            if ( ch >= 0x80 )                       \
            {                                       \
              FT_UInt  len_;                        \
                                                    \
                                                    \
              if ( ch < 0xE0 )                      \
              {                                     \
                len_ = 1;                           \
                ch  &= 0x1F;                        \
              }                                     \
              else if ( ch < 0xF0 )                 \
              {                                     \
                len_ = 2;                           \
                ch  &= 0x0F;                        \
              }                                     \
              else                                  \
              {                                     \
                len_ = 3;                           \
                ch  &= 0x07;                        \
              }                                     \
                                                    \
              for ( ; len_ > 0; len_-- )            \
                ch = ( ch << 6 ) | ( *p++ & 0x3F ); \
            }                                       \
          } while ( 0 )


  /*************************************************************************/
  /*************************************************************************/
  /*****                                                               *****/
  /*****                    B L U E   S T R I N G S                    *****/
  /*****                                                               *****/
  /*************************************************************************/
  /*************************************************************************/

  /* At the bottommost level, we define strings for finding blue zones. */


#define AF_BLUE_STRING_MAX_LEN  51

  /* The AF_Blue_String enumeration values are offsets into the */
  /* `af_blue_strings' array.                                   */

  typedef enum  AF_Blue_String_
  {
    AF_BLUE_STRING_ARABIC_TOP = 0,
    AF_BLUE_STRING_ARABIC_BOTTOM = 18,
    AF_BLUE_STRING_ARABIC_JOIN = 33,
    AF_BLUE_STRING_ARMENIAN_CAPITAL_TOP = 36,
    AF_BLUE_STRING_ARMENIAN_CAPITAL_BOTTOM = 60,
    AF_BLUE_STRING_ARMENIAN_SMALL_ASCENDER = 84,
    AF_BLUE_STRING_ARMENIAN_SMALL_TOP = 105,
    AF_BLUE_STRING_ARMENIAN_SMALL_BOTTOM = 129,
    AF_BLUE_STRING_ARMENIAN_SMALL_DESCENDER = 153,
    AF_BLUE_STRING_BENGALI_BASE = 177,
    AF_BLUE_STRING_BENGALI_TOP = 209,
    AF_BLUE_STRING_BENGALI_HEAD = 237,
    AF_BLUE_STRING_CHEROKEE_CAPITAL = 269,
    AF_BLUE_STRING_CHEROKEE_SMALL_ASCENDER = 301,
    AF_BLUE_STRING_CHEROKEE_SMALL = 333,
    AF_BLUE_STRING_CHEROKEE_SMALL_DESCENDER = 365,
    AF_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 381,
    AF_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 405,
    AF_BLUE_STRING_CYRILLIC_SMALL = 429,
    AF_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 453,
    AF_BLUE_STRING_DEVANAGARI_BASE = 462,
    AF_BLUE_STRING_DEVANAGARI_TOP = 494,
    AF_BLUE_STRING_DEVANAGARI_HEAD = 526,
    AF_BLUE_STRING_DEVANAGARI_BOTTOM = 558,
    AF_BLUE_STRING_ETHIOPIC_TOP = 566,
    AF_BLUE_STRING_ETHIOPIC_BOTTOM = 598,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_TOP = 630,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_BOTTOM = 662,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_ASCENDER = 694,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_DESCENDER = 726,
    AF_BLUE_STRING_GEORGIAN_ASOMTAVRULI_TOP = 758,
    AF_BLUE_STRING_GEORGIAN_ASOMTAVRULI_BOTTOM = 790,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_TOP = 822,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_BOTTOM = 854,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_ASCENDER = 886,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_DESCENDER = 918,
    AF_BLUE_STRING_GREEK_CAPITAL_TOP = 950,
    AF_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 971,
    AF_BLUE_STRING_GREEK_SMALL_BETA_TOP = 989,
    AF_BLUE_STRING_GREEK_SMALL = 1007,
    AF_BLUE_STRING_GREEK_SMALL_DESCENDER = 1031,
    AF_BLUE_STRING_GUJARATI_TOP = 1055,
    AF_BLUE_STRING_GUJARATI_BOTTOM = 1087,
    AF_BLUE_STRING_GUJARATI_ASCENDER = 1119,
    AF_BLUE_STRING_GUJARATI_DESCENDER = 1169,
    AF_BLUE_STRING_GUJARATI_DIGIT_TOP = 1202,
    AF_BLUE_STRING_GURMUKHI_BASE = 1222,
    AF_BLUE_STRING_GURMUKHI_HEAD = 1254,
    AF_BLUE_STRING_GURMUKHI_TOP = 1286,
    AF_BLUE_STRING_GURMUKHI_BOTTOM = 1318,
    AF_BLUE_STRING_GURMUKHI_DIGIT_TOP = 1350,
    AF_BLUE_STRING_HEBREW_TOP = 1370,
    AF_BLUE_STRING_HEBREW_BOTTOM = 1394,
    AF_BLUE_STRING_HEBREW_DESCENDER = 1412,
    AF_BLUE_STRING_KANNADA_TOP = 1427,
    AF_BLUE_STRING_KANNADA_BOTTOM = 1471,
    AF_BLUE_STRING_KHMER_TOP = 1503,
    AF_BLUE_STRING_KHMER_SUBSCRIPT_TOP = 1527,
    AF_BLUE_STRING_KHMER_BOTTOM = 1567,
    AF_BLUE_STRING_KHMER_DESCENDER = 1599,
    AF_BLUE_STRING_KHMER_LARGE_DESCENDER = 1633,
    AF_BLUE_STRING_KHMER_SYMBOLS_WAXING_TOP = 1720,
    AF_BLUE_STRING_KHMER_SYMBOLS_WANING_BOTTOM = 1728,
    AF_BLUE_STRING_LAO_TOP = 1736,
    AF_BLUE_STRING_LAO_BOTTOM = 1768,
    AF_BLUE_STRING_LAO_ASCENDER = 1800,
    AF_BLUE_STRING_LAO_LARGE_ASCENDER = 1816,
    AF_BLUE_STRING_LAO_DESCENDER = 1828,
    AF_BLUE_STRING_LATIN_CAPITAL_TOP = 1852,
    AF_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 1868,
    AF_BLUE_STRING_LATIN_SMALL_F_TOP = 1884,
    AF_BLUE_STRING_LATIN_SMALL_TOP = 1898,
    AF_BLUE_STRING_LATIN_SMALL_BOTTOM = 1914,
    AF_BLUE_STRING_LATIN_SMALL_DESCENDER = 1930,
    AF_BLUE_STRING_LATIN_SUBS_CAPITAL_TOP = 1940,
    AF_BLUE_STRING_LATIN_SUBS_CAPITAL_BOTTOM = 1960,
    AF_BLUE_STRING_LATIN_SUBS_SMALL_F_TOP = 1980,
    AF_BLUE_STRING_LATIN_SUBS_SMALL = 2000,
    AF_BLUE_STRING_LATIN_SUBS_SMALL_DESCENDER = 2036,
    AF_BLUE_STRING_LATIN_SUPS_CAPITAL_TOP = 2056,
    AF_BLUE_STRING_LATIN_SUPS_CAPITAL_BOTTOM = 2087,
    AF_BLUE_STRING_LATIN_SUPS_SMALL_F_TOP = 2116,
    AF_BLUE_STRING_LATIN_SUPS_SMALL = 2142,
    AF_BLUE_STRING_LATIN_SUPS_SMALL_DESCENDER = 2167,
    AF_BLUE_STRING_MALAYALAM_TOP = 2178,
    AF_BLUE_STRING_MALAYALAM_BOTTOM = 2222,
    AF_BLUE_STRING_MYANMAR_TOP = 2254,
    AF_BLUE_STRING_MYANMAR_BOTTOM = 2286,
    AF_BLUE_STRING_MYANMAR_ASCENDER = 2318,
    AF_BLUE_STRING_MYANMAR_DESCENDER = 2346,
    AF_BLUE_STRING_SINHALA_TOP = 2378,
    AF_BLUE_STRING_SINHALA_BOTTOM = 2410,
    AF_BLUE_STRING_SINHALA_DESCENDER = 2442,
    AF_BLUE_STRING_TAMIL_TOP = 2486,
    AF_BLUE_STRING_TAMIL_BOTTOM = 2518,
    AF_BLUE_STRING_TELUGU_TOP = 2550,
    AF_BLUE_STRING_TELUGU_BOTTOM = 2578,
    AF_BLUE_STRING_THAI_TOP = 2606,
    AF_BLUE_STRING_THAI_BOTTOM = 2630,
    AF_BLUE_STRING_THAI_ASCENDER = 2658,
    AF_BLUE_STRING_THAI_LARGE_ASCENDER = 2670,
    AF_BLUE_STRING_THAI_DESCENDER = 2682,
    AF_BLUE_STRING_THAI_LARGE_DESCENDER = 2698,
    AF_BLUE_STRING_THAI_DIGIT_TOP = 2706,
    af_blue_1_1 = 2717,
#ifdef AF_CONFIG_OPTION_CJK
    AF_BLUE_STRING_CJK_TOP = af_blue_1_1 + 1,
    AF_BLUE_STRING_CJK_BOTTOM = af_blue_1_1 + 203,
    af_blue_1_1_1 = af_blue_1_1 + 404,
#ifdef AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT
    AF_BLUE_STRING_CJK_LEFT = af_blue_1_1_1 + 1,
    AF_BLUE_STRING_CJK_RIGHT = af_blue_1_1_1 + 204,
    af_blue_1_1_2 = af_blue_1_1_1 + 405,
#else
    af_blue_1_1_2 = af_blue_1_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT */
    af_blue_1_2 = af_blue_1_1_2 + 0,
#else
    af_blue_1_2 = af_blue_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK                */


    AF_BLUE_STRING_MAX   /* do not remove */

  } AF_Blue_String;


  FT_LOCAL_ARRAY( char )
  af_blue_strings[];


  /*************************************************************************/
  /*************************************************************************/
  /*****                                                               *****/
  /*****                 B L U E   S T R I N G S E T S                 *****/
  /*****                                                               *****/
  /*************************************************************************/
  /*************************************************************************/

  /* The next level is to group blue strings into style-specific sets. */


  /* Properties are specific to a writing system.  We assume that a given  */
  /* blue string can't be used in more than a single writing system, which */
  /* is a safe bet.                                                        */
#define AF_BLUE_PROPERTY_LATIN_TOP       ( 1U << 0 )  /* must have value 1 */
#define AF_BLUE_PROPERTY_LATIN_SUB_TOP   ( 1U << 1 )
#define AF_BLUE_PROPERTY_LATIN_NEUTRAL   ( 1U << 2 )
#define AF_BLUE_PROPERTY_LATIN_X_HEIGHT  ( 1U << 3 )
#define AF_BLUE_PROPERTY_LATIN_LONG      ( 1U << 4 )

#define AF_BLUE_PROPERTY_CJK_TOP    ( 1U << 0 )       /* must have value 1 */
#define AF_BLUE_PROPERTY_CJK_HORIZ  ( 1U << 1 )       /* must have value 2 */
#define AF_BLUE_PROPERTY_CJK_RIGHT  AF_BLUE_PROPERTY_CJK_TOP


#define AF_BLUE_STRINGSET_MAX_LEN  8

  /* The AF_Blue_Stringset enumeration values are offsets into the */
  /* `af_blue_stringsets' array.                                   */

  typedef enum  AF_Blue_Stringset_
  {
    AF_BLUE_STRINGSET_ARAB = 0,
    AF_BLUE_STRINGSET_ARMN = 4,
    AF_BLUE_STRINGSET_BENG = 11,
    AF_BLUE_STRINGSET_CHER = 16,
    AF_BLUE_STRINGSET_CYRL = 23,
    AF_BLUE_STRINGSET_DEVA = 29,
    AF_BLUE_STRINGSET_ETHI = 35,
    AF_BLUE_STRINGSET_GEOR = 38,
    AF_BLUE_STRINGSET_GEOK = 43,
    AF_BLUE_STRINGSET_GREK = 50,
    AF_BLUE_STRINGSET_GUJR = 57,
    AF_BLUE_STRINGSET_GURU = 63,
    AF_BLUE_STRINGSET_HEBR = 69,
    AF_BLUE_STRINGSET_KNDA = 73,
    AF_BLUE_STRINGSET_KHMR = 76,
    AF_BLUE_STRINGSET_KHMS = 82,
    AF_BLUE_STRINGSET_LAO = 85,
    AF_BLUE_STRINGSET_LATN = 91,
    AF_BLUE_STRINGSET_LATB = 98,
    AF_BLUE_STRINGSET_LATP = 105,
    AF_BLUE_STRINGSET_MLYM = 112,
    AF_BLUE_STRINGSET_MYMR = 115,
    AF_BLUE_STRINGSET_NONE = 120,
    AF_BLUE_STRINGSET_SINH = 121,
    AF_BLUE_STRINGSET_TAML = 125,
    AF_BLUE_STRINGSET_TELU = 128,
    AF_BLUE_STRINGSET_THAI = 131,
    af_blue_2_1 = 139,
#ifdef AF_CONFIG_OPTION_CJK
    AF_BLUE_STRINGSET_HANI = af_blue_2_1 + 0,
    af_blue_2_1_1 = af_blue_2_1 + 2,
#ifdef AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT
    af_blue_2_1_2 = af_blue_2_1_1 + 2,
#else
    af_blue_2_1_2 = af_blue_2_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT */
    af_blue_2_2 = af_blue_2_1_2 + 1,
#else
    af_blue_2_2 = af_blue_2_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK                */


    AF_BLUE_STRINGSET_MAX   /* do not remove */

  } AF_Blue_Stringset;


  typedef struct  AF_Blue_StringRec_
  {
    AF_Blue_String  string;
    FT_UShort       properties;

  } AF_Blue_StringRec;


  FT_LOCAL_ARRAY( AF_Blue_StringRec )
  af_blue_stringsets[];

/* */

FT_END_HEADER


#endif /* AFBLUE_H_ */


/* END */
