/*---------------------------------------------------------------------------------
 * General string routines that are sometimes missing.
 *
 * Filename:    find_substring.c 
 * Author:      Randall Gellens.
 * Version:     
 * Last edited: 2 November 1998
 *---------------------------------------------------------------------------------
 */

#include <string.h>

#include "find_substring.h"
#include "missing.h"


/**********************************************************************
   Returns a pointer to the first occurrence of strCharSet in string, 
   or NULL if strCharSet does not appear in string.  If strCharSet 
   points to a string of zero length, the function returns string.

   Uses a case-insensitive compare.
***********************************************************************
*/
char *find_substring ( const char *string, const char *strCharSet )
	{
	char       *p;
	int         ip;
	int         is;


	p  = (char *) string;
	ip = strlen(p);
	is = strlen(strCharSet);

	while ( p != NULL && strCharSet != NULL && ip >= is )
		{
		if ( str_comp_len ( p, strCharSet, is ) == 0 )  /* str_comp_len() returns 0 if match */
			return ( p );
		p++;
		ip--;
		}
	return NULL;
	}