/* Subroutine:  psx_rand( inum, maxnum, fnum, status )
*+
*  Name:
*     PSX_RAND

*  Purpose:
*     Generate a random number

*  Language:
*     ANSI C

*  Invocation:
*     CALL PSX_RAND( INUM, MAXNUM, FNUM, STATUS )

*  Description:
*     Generate a random number. The number is generated as the integer
*     INUM. The maximum value that this may have is returned as MAXNUM.
*     Also the value of INUM/MAXNUM is returned as FNUM.

*  Arguments:
*     INUM = INTEGER (Returned)
*        The random (integer) number.
*     MAXNUM = INTEGER (Returned)
*        The maximum value that INUM may have.
*     FNUM = REAL (Returned)
*        The value INUM/MAXNUM.
*     STATUS = INTEGER (Given)
*        The global status.

*  Notes:
*     -  A seed for the random number generator may be set with
*        PSX_SRAND.
*     -  The sequence of numbers generated by the operating system
*        service that is called by this routine is not always as random
*        as it should be. It is probably better to use a different
*        routine such as one of the NAG routines. This routine is
*        included here for completeness, though.

*  References:
*     -  POSIX standard (1988), section 8.1
*     -  ANSI C standard (1989), section 4.10.2.1
      
*  Copyright:
*     Copyright (C) 1991 Science & Engineering Research Council

*  Authors:
*     PMA: Peter Allan (Starlink, RAL)
*     {enter_new_authors_here}

*  History:
*     19-APR-1991 (PMA):
*        Original version.
*     27-JUN-1991 (PMA):
*        Changed IMPORT and EXPORT macros to GENPTR.
*     14-APR-1993 (PMA):
*        Only set RAND_MAX if it is not already set.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*-
*-----------------------------------------------------------------------------
*/

/* Global Constants:		.					    */

#include <stdlib.h>		 /* Standard C library			    */
#include "f77.h"		 /* C - Fortran interface		    */
#include "sae_par.h"		 /* ADAM constants			    */

#if !defined (RAND_MAX)		 /* RAND_MAX is not defined in stdlib.h on  */
#define RAND_MAX 2147483647	 /* the Sun				    */
#endif


F77_SUBROUTINE(psx_rand)( INTEGER(inum), INTEGER(maxnum), REAL(fnum),
                          INTEGER(status) )
{

/* Pointers to Arguments:						    */

   GENPTR_INTEGER(inum)
   GENPTR_INTEGER(maxnum)
   GENPTR_REAL(fnum)
   GENPTR_INTEGER(status)

/* Check inherited global status.					    */

   if( *status != SAI__OK ) return;

/* Get the random number.						    */

   *inum = rand();
   *maxnum = RAND_MAX;
   *fnum = (float)*inum / (float)RAND_MAX;

}
