#if !defined(AST_INCLUDED)
#define AST_INCLUDED
/*
*+
*  Name:
*     ast.h

*  Purpose:
*     Define the public C interface to the AST library.

*  Language:
*     ANSI C

*  Type of Module:
*     C header file.

*  Description:
*     This file defines the public C interface to the AST library. It contains
*     all the type definitions, function prototypes, macro definitions, etc.
*     needed to use the library.

*  Copyright:
*     Copyright (C) 2004 Central Laboratory of the Research Councils

*  Authors:
*     DSB: D.S. Berry (STARLINK)
*     RFWS: R.F. Warren-Smith (STARLINK)
*     {enter_new_authors_here}

*  History:
*     16-SEP-2004 (makeh):
*        Original version, generated automatically from the internal header
*        files by the "makeh" script.
*     {enter_changes_here}
*-
*/

/* This is AST version 3.4-5. Note, these macros are kept for backwards 
   compatibility only. The AST__VMAJOR, AST__VMINOR and AST__RELEASE macros 
   should normally be used in preference to these, due to the non-standard 
   use of single underscores. */
#define AST_MAJOR_VERS 3
#define AST_MINOR_VERS 4
#define AST_RELEASE 5

/* xml. */
/* ==== */
#define AST__XMLBAD 0
#define AST__XMLOBJECT 198263577
#define AST__XMLELEM 182874779
#define AST__XMLATTR 837746634
#define AST__XMLCDATA 293854662
#define AST__XMLCOM 748737648
#define AST__XMLPI 983763553
#define AST__XMLNAME 236756469
#define AST__XMLDOC 356274395
#define AST__XMLPRO 743682474
#define AST__XMLDEC 987546328
#define AST__XMLDTD 874673747
#define AST__XMLWHITE 675849952
#define AST__XMLBLACK 347657863

#define AST__XMLCHAR 456739289
#define AST__XMLCONT 673882993
#define AST__XMLMISC 358768954
#define AST__XMLPAR 874366235

typedef struct AstXmlObject AstXmlObject;
typedef struct AstXmlAttribute AstXmlAttribute;
typedef struct AstXmlNamespace AstXmlNamespace;
typedef struct AstXmlElement AstXmlElement;
typedef struct AstXmlBlack AstXmlBlack;
typedef struct AstXmlWhite AstXmlWhite;
typedef struct AstXmlCDataSection AstXmlCDataSection;
typedef struct AstXmlComment AstXmlComment;
typedef struct AstXmlPI AstXmlPI;
typedef struct AstXmlDocument AstXmlDocument;
typedef struct AstXmlPrologue AstXmlPrologue;
typedef struct AstXmlDeclPI AstXmlDeclPI;
typedef struct AstXmlDTDec AstXmlDTDec;

typedef AstXmlObject AstXmlCharData;

typedef AstXmlObject AstXmlContentItem;

typedef AstXmlObject AstXmlMiscItem;

typedef AstXmlObject AstXmlParent;

struct AstXmlObject {
   AstXmlParent *parent;
   long int type;
   int id;
};

struct AstXmlAttribute {
   AstXmlObject obj;
   char *name;
   char *value;
   char *prefix;
};

struct AstXmlNamespace {
   AstXmlObject obj;
   char *prefix;
   char *uri;
};

struct AstXmlElement {
   AstXmlObject obj;
   char *name;
   AstXmlAttribute **attrs;
   int nattr;
   AstXmlContentItem **items;
   int nitem;
   char *defns;
   char *prefix;
   AstXmlNamespace **nsprefs;
   int nnspref;
   int complete;
};

struct AstXmlBlack {
   AstXmlObject obj;
   char *text;
};

struct AstXmlWhite {
   AstXmlObject obj;
   char *text;
};

struct AstXmlCDataSection {
   AstXmlObject obj;
   char *text;
};

struct AstXmlComment {
   AstXmlObject obj;
   char *text;
};

struct AstXmlPI {
   AstXmlObject obj;
   char *target;
   char *text;
};

struct AstXmlDocument {
   AstXmlObject obj;
   AstXmlPrologue *prolog;
   AstXmlElement *root;
   AstXmlMiscItem **epilog;
   int nepi;
   AstXmlElement *current;
};

struct AstXmlPrologue {
   AstXmlObject obj;
   AstXmlDeclPI *xmldecl;
   AstXmlMiscItem **misc1;
   int nmisc1;
   AstXmlDTDec *dtdec;
   AstXmlMiscItem **misc2;
   int nmisc2;
};

struct AstXmlDeclPI {
   AstXmlObject obj;
   char *text;
};

struct AstXmlDTDec {
   AstXmlObject obj;
   char *name;
   char *external;
   char *internal;
};
AstXmlAttribute *astXmlCheckAttribute_( void *, int );
AstXmlBlack *astXmlCheckBlack_( void *, int );
AstXmlCDataSection *astXmlCheckCDataSection_( void *, int );
AstXmlComment *astXmlCheckComment_( void *, int );
AstXmlContentItem *astXmlGetItem_( AstXmlElement *, int );
AstXmlDTDec *astXmlCheckDTDec_( void *, int );
AstXmlDeclPI *astXmlCheckDeclPI_( void *, int );
AstXmlDocument *astXmlCheckDocument_( void *, int );
AstXmlElement *astXmlAddElement_( AstXmlElement *, const char *, const char * );
AstXmlElement *astXmlCheckElement_( void *, int );
AstXmlParent *astXmlGetParent_( AstXmlObject * );
AstXmlObject *astXmlGetRoot_( AstXmlObject * );
AstXmlElement *astXmlReadDocument_( AstXmlDocument **, int (*)( AstXmlElement * ), int, char (*)( void * ), void * );
AstXmlNamespace *astXmlCheckNamespace_( void *, int );
AstXmlObject *astXmlCopy_( AstXmlObject * );
AstXmlObject *astXmlCheckObject_( void *, int );
AstXmlPI *astXmlCheckPI_( void *, int );
AstXmlPrologue *astXmlCheckPrologue_( void *, int );
AstXmlWhite *astXmlCheckWhite_( void *, int );
AstXmlCharData *astXmlCheckCharData_( void *, int );
AstXmlContentItem *astXmlCheckContentItem_( void *, int );
AstXmlMiscItem *astXmlCheckMiscItem_( void *, int );
AstXmlParent *astXmlCheckParent_( void *, int );
const char *astXmlFormat_( AstXmlObject * );
const char *astXmlGetAttributeValue_( AstXmlElement *, const char *);
const char *astXmlGetName_( AstXmlObject * );
const char *astXmlGetTag_( AstXmlObject *, int );
const char *astXmlGetURI_( AstXmlObject * );
const char *astXmlGetValue_( AstXmlObject *, int );
const char *astXmlShow_( AstXmlObject * );
int astXmlCheckType_( void *, long int );
int astXmlGetNitem_( AstXmlElement *);
int astXmlTrace_( int );
void *astXmlAnnulTree_( AstXmlObject * );
void *astXmlAnnul_( AstXmlObject * );
void astXmlAddAttr_( AstXmlElement *, const char *, const char *, const char * );
void astXmlAddCDataSection_( AstXmlElement *, const char * );
void astXmlAddCharData_( AstXmlParent *, int, const char * );
void astXmlAddComment_( AstXmlParent *, int, const char * );
void astXmlAddPI_( AstXmlParent *, int, const char *, const char * );
void astXmlAddURI_( AstXmlElement *, const char *, const char * );
void astXmlInsertElement_( AstXmlElement *, AstXmlElement * );
void astXmlPurge_( AstXmlParent * );
void astXmlRemoveAttr_( AstXmlElement *, const char *, const char * );
void astXmlRemoveItem_( AstXmlContentItem * );
void astXmlRemoveURI_( AstXmlElement *, const char * );
void astXmlSetXmlDec_( AstXmlDocument *, const char * );
void astXmlSetDTDEC_( AstXmlDocument *, const char *, const char *, const char *);

#define astXmlCheckAttribute(this,nullok) astXmlCheckAttribute_(this,nullok)
#define astXmlCheckBlack(this,nullok) astXmlCheckBlack_(this,nullok)
#define astXmlCheckCDataSection(this,nullok) astXmlCheckCDataSection_(this,nullok)
#define astXmlCheckCharData(this,nullok) astXmlCheckCharData_(this,nullok)
#define astXmlCheckComment(this,nullok) astXmlCheckComment_(this,nullok)
#define astXmlCheckContentItem(this,nullok) astXmlCheckContentItem_(this,nullok)
#define astXmlCheckDTDec(this,nullok) astXmlCheckDTDec_(this,nullok)
#define astXmlCheckDeclPI(this,nullok) astXmlCheckDeclPI_(this,nullok)
#define astXmlCheckDocument(this,nullok) astXmlCheckDocument_(this,nullok)
#define astXmlCheckElement(this,nullok) astXmlCheckElement_(this,nullok)
#define astXmlCheckMiscItem(this,nullok) astXmlCheckMiscItem_(this,nullok)
#define astXmlCheckNamespace(this,nullok) astXmlCheckNamespace_(this,nullok)
#define astXmlCheckObject(this,nullok) astXmlCheckObject_(this,nullok)
#define astXmlCheckPI(this,nullok) astXmlCheckPI_(this,nullok)
#define astXmlCheckParent(this,nullok) astXmlCheckParent_(this,nullok)
#define astXmlCheckPrologue(this,nullok) astXmlCheckPrologue_(this,nullok)
#define astXmlCheckWhite(this,nullok) astXmlCheckWhite_(this,nullok)

#define astXmlAddAttr(elem,name,value,prefix) astXmlAddAttr_(astXmlCheckElement(elem,0),name,value,prefix)
#define astXmlAddURI(elem,prefix,uri) astXmlAddURI_(astXmlCheckElement(elem,0),prefix,uri)
#define astXmlAnnul(this) astXmlAnnul_(astXmlCheckObject(this,1))
#define astXmlAnnulTree(this) astXmlAnnulTree_(astXmlCheckObject(this,1))
#define astXmlAddCDataSection(this,text) astXmlAddCDataSection_(astXmlCheckElement(this,0),text)
#define astXmlAddCharData(this,where,text) astXmlAddCharData_(astXmlCheckParent(this,0),where,text)
#define astXmlAddComment(this,where,text) astXmlAddComment_(astXmlCheckParent(this,0),where,text)
#define astXmlAddElement(this,name,prefix) astXmlAddElement_(astXmlCheckElement(this,1),name,prefix)
#define astXmlAddPI(this,where,target,text) astXmlAddPI_(astXmlCheckParent(this,0),where,target,text)
#define astXmlTrace(show) astXmlTrace_(show)
#define astXmlGetParent(this) astXmlGetParent_(astXmlCheckObject(this,0))
#define astXmlGetRoot(this) astXmlGetRoot_(astXmlCheckObject(this,0))
#define astXmlGetName(this) astXmlGetName_(astXmlCheckObject(this,0))
#define astXmlGetValue(this,report) astXmlGetValue_(astXmlCheckObject(this,0),report)
#define astXmlGetAttributeValue(this,name) astXmlGetAttributeValue_(astXmlCheckElement(this,0),name)
#define astXmlGetNitem(this) astXmlGetNitem_(astXmlCheckElement(this,0))
#define astXmlGetItem(this,item) astXmlGetItem_(astXmlCheckElement(this,0),item)
#define astXmlGetAttributeValue(this,name) astXmlGetAttributeValue_(astXmlCheckElement(this,0),name)
#define astXmlGetTag(this,opening) astXmlGetTag_(astXmlCheckObject(this,0),opening)
#define astXmlGetURI(this) astXmlGetURI_(astXmlCheckObject(this,0))
#define astXmlFormat(this) astXmlFormat_(astXmlCheckObject(this,0))
#define astXmlShow(this) astXmlShow_(astXmlCheckObject(this,0))
#define astXmlRemoveItem(this) astXmlRemoveItem_(astXmlCheckContentItem(this,0))
#define astXmlRemoveAttr(this,name,prefix) astXmlRemoveAttr_(astXmlCheckElement(this,0),name,prefix)
#define astXmlRemoveURI(this,prefix) astXmlRemoveURI_(astXmlCheckElement(this,0),prefix)
#define astXmlReadDocument(doc,is_wanted,skip,source,data) astXmlReadDocument_(doc,is_wanted,skip,source,data)
#define astXmlInsertElement(this,elem) astXmlInsertElement_(astXmlCheckElement(this,0),astXmlCheckElement(elem,0))
#define astXmlPurge(this) astXmlPurge_(astXmlCheckParent(this,1))
#define astXmlSetXmlDec(this,text) astXmlSetXmlDec_(astXmlCheckDocument(this,0),text)
#define astXmlSetDTDec(this,text1,text2,text3) astXmlSetDTDec_(astXmlCheckDocument(this,0),text1,text2,text3)
#define astXmlCheckType(this,type) astXmlCheckType_(this,type)
#define astXmlCopy(this) astXmlCopy_(astXmlCheckObject(this,1))
/* wcstrig. */
/* ======== */
double astCosd(const double);
double astSind(const double);
double astTand(const double);
double astACosd(const double);
double astASind(const double);
double astATand(const double);
double astATan2d(const double, const double);

#define WCSTRIG_TOL 1e-10
/* proj. */
/* ===== */
#define WCSLIB_MXPAR 100

extern int npcode;
extern char pcodes[26][4];

struct AstPrjPrm {
   char code[4];
   int flag;
   double phi0, theta0;
   double r0;
   double p[WCSLIB_MXPAR];
   double p2[WCSLIB_MXPAR];
   double w[20];
   int n;
   int (*astPRJfwd)(const double, const double,
                 struct AstPrjPrm *,
                 double *, double *);
   int (*astPRJrev)(const double, const double,
                 struct AstPrjPrm *,
                 double *, double *);
};

   int astPRJset(const char [], struct AstPrjPrm *);
   int astPRJfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astPRJrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astAZPset(struct AstPrjPrm *);
   int astAZPfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astAZPrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSZPset(struct AstPrjPrm *);
   int astSZPfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSZPrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astTANset(struct AstPrjPrm *);
   int astTANfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astTANrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSTGset(struct AstPrjPrm *);
   int astSTGfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSTGrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSINset(struct AstPrjPrm *);
   int astSINfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSINrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astARCset(struct AstPrjPrm *);
   int astARCfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astARCrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astZPNset(struct AstPrjPrm *);
   int astZPNfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astZPNrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astZEAset(struct AstPrjPrm *);
   int astZEAfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astZEArev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astAIRset(struct AstPrjPrm *);
   int astAIRfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astAIRrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCYPset(struct AstPrjPrm *);
   int astCYPfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCYPrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCEAset(struct AstPrjPrm *);
   int astCEAfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCEArev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCARset(struct AstPrjPrm *);
   int astCARfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCARrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astMERset(struct AstPrjPrm *);
   int astMERfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astMERrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSFLset(struct AstPrjPrm *);
   int astSFLfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astSFLrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astPARset(struct AstPrjPrm *);
   int astPARfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astPARrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astMOLset(struct AstPrjPrm *);
   int astMOLfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astMOLrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astAITset(struct AstPrjPrm *);
   int astAITfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astAITrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCOPset(struct AstPrjPrm *);
   int astCOPfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCOPrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCOEset(struct AstPrjPrm *);
   int astCOEfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCOErev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCODset(struct AstPrjPrm *);
   int astCODfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCODrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCOOset(struct AstPrjPrm *);
   int astCOOfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCOOrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astBONset(struct AstPrjPrm *);
   int astBONfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astBONrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astPCOset(struct AstPrjPrm *);
   int astPCOfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astPCOrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astTSCset(struct AstPrjPrm *);
   int astTSCfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astTSCrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCSCset(struct AstPrjPrm *);
   int astCSCfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astCSCrev(const double, const double, struct AstPrjPrm *, double *, double *);
   int astQSCset(struct AstPrjPrm *);
   int astQSCfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astQSCrev(const double, const double, struct AstPrjPrm *, double *, double *);

   int astTPNset(struct AstPrjPrm *);
   int astTPNfwd(const double, const double, struct AstPrjPrm *, double *, double *);
   int astTPNrev(const double, const double, struct AstPrjPrm *, double *, double *);

extern const char *astPRJset_errmsg[];
extern const char *astPRJfwd_errmsg[];
extern const char *astPRJrev_errmsg[];
/* memory. */
/* ======= */
#include <stddef.h>

int astChrMatch_( const char *, const char * );
int astChrMatchN_( const char *, const char *, size_t );
char **astStringArray_( const char *, int, int );
char *astString_( const char *, int );
int astSscanf_( const char *str, const char *format, ...);
size_t astSizeOf_( void * );
void *astFree_( void * );
void *astGrow_( void *, int, size_t );
void *astMalloc_( size_t );
void *astRealloc_( void *, size_t );
void *astStore_( void *, const void *, size_t );
size_t astChrLen_( const char * );
char *astAppendString_( char *, int *, const char * );
#define astChrMatch(str1,str2) astChrMatch_(str1,str2)
#define astChrMatchN(str1,str2,n) astChrMatchN_(str1,str2,n)
#define astFree(ptr) astFree_(ptr)
#define astGrow(ptr,n,size) astGrow_(ptr,n,size)
#define astMalloc(size) astMalloc_(size)
#define astRealloc(ptr,size) astRealloc_(ptr,size)
#define astSizeOf(ptr) astSizeOf_(ptr)
#define astStore(ptr,data,size) astStore_(ptr,data,size)
#define astAppendString(ptr,len,text) astAppendString_(ptr,len,text)
#define astString(chars,nchars) astString_(chars,nchars)
#define astStringArray(chars,nel,len) astStringArray_(chars,nel,len)
#define astChrLen(string) astChrLen_(string)
#define astSscanf astSscanf_
/* error. */
/* ====== */
int *astWatch_( int * );
int astOK_( void );
int astStatus_( void );
void astClearStatus_( void );
void astSetStatus_( int );

void astAt_( const char *, const char *, int, int );
void astError_( int, const char *, ... );
int astReporting_( int );

#define astClearStatus astClearStatus_()
#define astOK astOK_()
#define astSetStatus(status) astSetStatus_(status)
#define astStatus astStatus_()
#define astWatch(status_address) astWatch_(status_address)

#define astAt(routine,file,line) astAt_(routine,file,line,1)

#define astError astError_
#define astReporting astReporting_
/* unit. */
/* ===== */
#define astINVOKE(rettype,function) (astAt_(NULL,__FILE__,__LINE__,0),astRet##rettype##_(function))

#define astRetF_(x) (x)
#define astRetV_(x) (x)

#define astRetO_(x) ((void *)astMakeId_((AstObject *)(x)))
#define astINVOKE_CHECK(class,this) astCheck##class##_((Ast##class *)astEnsurePointer_(this))
#define astINVOKE_ISA(class,this) astINVOKE(V,astIsA##class##_((const Ast##class *)astEnsurePointer_(this)))
#define astEnsurePointer_(x) ((void *)astMakePointer_((AstObject *)(x)))
#define astPROTO_CHECK(class) Ast##class *astCheck##class##_( Ast##class * );
#define astPROTO_ISA(class) int astIsA##class##_( const Ast##class * );

#define AST__NULL (astI2P(0))

#define AST__VMAJOR 3
#define AST__VMINOR 4
#define AST__RELEASE 5
typedef struct AstObject {

   unsigned long check;
   size_t size;
   struct AstObjectVtab *vtab;
   int dynamic;
   int ref_count;
   char *id;
   char *ident;
} AstObject;

struct AstChannel;
typedef struct AstChannel {

   AstObject object;

   const char *(* source)( void );
   char *(* source_wrap)( const char *(*)( void ) );

   void (* sink)( const char * );
   void (* sink_wrap)( void (*)( const char * ), const char * );

   int comment;
   int full;
   int skip;
} AstChannel;
astPROTO_CHECK(Channel)
astPROTO_ISA(Channel)

AstChannel *astChannelId_( const char *(*)( void ), void (*)( const char * ),
                           const char *, ... );
AstChannel *astChannelForId_( const char *(*)( void ),
                              char *(*)( const char *(*)( void ) ),
                              void (*)( const char * ),
                              void (*)( void (*)( const char * ),
                                        const char * ),
                              const char *, ... );
AstObject *astRead_( AstChannel * );
int astWrite_( AstChannel *, AstObject * );

char *astSourceWrap_( const char *(*)( void ) );
void astSinkWrap_( void (*)( const char * ), const char * );
#define astCheckChannel(this) astINVOKE_CHECK(Channel,this)

#define astIsAChannel(this) astINVOKE_ISA(Channel,this)

#define astChannel astINVOKE(F,astChannelId_)
#define astChannelFor astINVOKE(F,astChannelForId_)
#define astRead(this) astINVOKE(O,astRead_(astCheckChannel(this)))
#define astWrite(this,object) astINVOKE(V,astWrite_(astCheckChannel(this),astCheckObject(object)))

#define astSourceWrap astSourceWrap_
#define astSinkWrap astSinkWrap_

astPROTO_CHECK(Object)
astPROTO_ISA(Object)
void astBegin_( void );
void astEnd_( void );

AstObject *astI2P_( int );
AstObject *astMakeId_( AstObject * );
AstObject *astMakePointer_( AstObject * );
int astP2I_( AstObject * );
int astVersion_( void );
int astEscapes_( int );
AstObject *astDeleteId_( AstObject * );
void astExemptId_( AstObject * );
void astExportId_( AstObject * );
void astSetId_( void *, const char *, ... );

AstObject *astAnnulId_( AstObject * );
AstObject *astClone_( AstObject * );
AstObject *astCopy_( const AstObject * );
const char *astGetC_( AstObject *, const char * );
double astGetD_( AstObject *, const char * );
float astGetF_( AstObject *, const char * );
int astGetI_( AstObject *, const char * );
int astTest_( AstObject *, const char * );
long astGetL_( AstObject *, const char * );
void astClear_( AstObject *, const char * );
void astSetC_( AstObject *, const char *, const char * );
void astSetD_( AstObject *, const char *, double );
void astSetF_( AstObject *, const char *, float );
void astSetI_( AstObject *, const char *, int );
void astSetL_( AstObject *, const char *, long );
void astShow_( AstObject * );
#define astCheckObject(this) astINVOKE_CHECK(Object,this)

#define astIsAObject(this) astINVOKE_ISA(Object,this)
#define astBegin astINVOKE(V,astBegin_())
#define astEnd astINVOKE(V,astEnd_())

#define astVersion astVersion_()
#define astEscapes(int) astEscapes_(int)
#define astI2P(integer) ((void *)astI2P_(integer))
#define astMakeId(pointer) ((void *)astMakeId_((AstObject *)(pointer)))
#define astMakePointer(id) ((void *)astMakePointer_((AstObject *)(id)))
#define astP2I(pointer) astP2I_((AstObject *)(pointer))
#define astAnnul(this) astINVOKE(O,astAnnulId_((AstObject *)(this)))
#define astDelete(this) astINVOKE(O,astDeleteId_((AstObject *)(this)))
#define astExempt(this) astINVOKE(V,astExemptId_((AstObject *)(this)))
#define astExport(this) astINVOKE(V,astExportId_((AstObject *)(this)))
#define astSet astINVOKE(F,astSetId_)

#define astClear(this,attrib) astINVOKE(V,astClear_(astCheckObject(this),attrib))

#define astClone(this) astINVOKE(O,astClone_(astCheckObject(this)))
#define astCopy(this) astINVOKE(O,astCopy_(astCheckObject(this)))
#define astGetC(this,attrib) astINVOKE(V,astGetC_(astCheckObject(this),attrib))

#define astGetD(this,attrib) astINVOKE(V,astGetD_(astCheckObject(this),attrib))

#define astGetF(this,attrib) astINVOKE(V,astGetF_(astCheckObject(this),attrib))

#define astGetI(this,attrib) astINVOKE(V,astGetI_(astCheckObject(this),attrib))

#define astGetL(this,attrib) astINVOKE(V,astGetL_(astCheckObject(this),attrib))

#define astSetC(this,attrib,value) astINVOKE(V,astSetC_(astCheckObject(this),attrib,value))

#define astSetD(this,attrib,value) astINVOKE(V,astSetD_(astCheckObject(this),attrib,value))

#define astSetF(this,attrib,value) astINVOKE(V,astSetF_(astCheckObject(this),attrib,value))

#define astSetI(this,attrib,value) astINVOKE(V,astSetI_(astCheckObject(this),attrib,value))

#define astSetL(this,attrib,value) astINVOKE(V,astSetL_(astCheckObject(this),attrib,value))

#define astShow(this) astINVOKE(V,astShow_(astCheckObject(this)))

#define astTest(this,attrib) astINVOKE(V,astTest_(astCheckObject(this),attrib))
#include <float.h>
#define AST__BAD (-(DBL_MAX))
typedef struct AstPointSet {

   AstObject object;

   double **ptr;
   double *values;
   int ncoord;
   int npoint;
} AstPointSet;
astPROTO_CHECK(PointSet)
astPROTO_ISA(PointSet)

AstPointSet *astPointSetId_( int, int, const char *, ... );
double **astGetPoints_( AstPointSet * );
void astPermPoints_( AstPointSet *, int, const int[] );
void astSetPoints_( AstPointSet *, double ** );
void astSetSubPoints_( AstPointSet *, int, int, AstPointSet * );
#define astCheckPointSet(this) astINVOKE_CHECK(PointSet,this)

#define astIsAPointSet(this) astINVOKE_ISA(PointSet,this)

#define astPointSet astINVOKE(F,astPointSetId_)
#define astGetPoints(this) astINVOKE(V,astGetPoints_(astCheckPointSet(this)))

#define astPermPoints(this,forward,perm) astINVOKE(V,astPermPoints_(astCheckPointSet(this),forward,perm))

#define astSetPoints(this,ptr) astINVOKE(V,astSetPoints_(astCheckPointSet(this),ptr))

#define astSetSubPoints(point1,point,coord,point2) astINVOKE(V,astSetSubPoints_(astCheckPointSet(point1),point,coord,astCheckPointSet(point2)))
#define AST__URESAMP1 (1)
#define AST__URESAMP2 (2)
#define AST__URESAMP3 (4)
#define AST__URESAMP4 (8)

#define AST__USEBAD (32)

#define AST__UKERN1 (1)

#define AST__UINTERP (3)
#define AST__NEAREST (4)
#define AST__LINEAR (5)
#define AST__SINC (6)
#define AST__SINCSINC (7)
#define AST__SINCCOS (8)
#define AST__SINCGAUSS (9)
#define AST__BLOCKAVE (10)

typedef struct AstMapping {

   AstObject object;

   int invert;
   int nin;
   int nout;
   int report;
   int tran_forward;
   int tran_inverse;
} AstMapping;
astPROTO_CHECK(Mapping)
astPROTO_ISA(Mapping)
AstMapping *astSimplify_( AstMapping * );
int astResampleB_( AstMapping *, int, const int [], const int [], const signed char [], const signed char [], int, void (*)(), const double [], int, double, int, signed char, int, const int [], const int [], const int [], const int [], signed char [], signed char [] );
int astResampleD_( AstMapping *, int, const int [], const int [], const double [], const double [], int, void (*)(), const double [], int, double, int, double, int, const int [], const int [], const int [], const int [], double [], double [] );
int astResampleF_( AstMapping *, int, const int [], const int [], const float [], const float [], int, void (*)(), const double [], int, double, int, float, int, const int [], const int [], const int [], const int [], float [], float [] );
int astResampleI_( AstMapping *, int, const int [], const int [], const int [], const int [], int, void (*)(), const double [], int, double, int, int, int, const int [], const int [], const int [], const int [], int [], int [] );
int astResampleL_( AstMapping *, int, const int [], const int [], const long int [], const long int [], int, void (*)(), const double [], int, double, int, long int, int, const int [], const int [], const int [], const int [], long int [], long int [] );
int astResampleS_( AstMapping *, int, const int [], const int [], const short int [], const short int [], int, void (*)(), const double [], int, double, int, short int, int, const int [], const int [], const int [], const int [], short int [], short int [] );
int astResampleUB_( AstMapping *, int, const int [], const int [], const unsigned char [], const unsigned char [], int, void (*)(), const double [], int, double, int, unsigned char, int, const int [], const int [], const int [], const int [], unsigned char [], unsigned char [] );
int astResampleUI_( AstMapping *, int, const int [], const int [], const unsigned int [], const unsigned int [], int, void (*)(), const double [], int, double, int, unsigned int, int, const int [], const int [], const int [], const int [], unsigned int [], unsigned int [] );
int astResampleUL_( AstMapping *, int, const int [], const int [], const unsigned long int [], const unsigned long int [], int, void (*)(), const double [], int, double, int, unsigned long int, int, const int [], const int [], const int [], const int [], unsigned long int [], unsigned long int [] );
int astResampleUS_( AstMapping *, int, const int [], const int [], const unsigned short int [], const unsigned short int [], int, void (*)(), const double [], int, double, int, unsigned short int, int, const int [], const int [], const int [], const int [], unsigned short int [], unsigned short int [] );
void astInvert_( AstMapping * );
void astTran1_( AstMapping *, int, const double [], int, double [] );
void astTran2_( AstMapping *, int, const double [], const double [], int, double [], double [] );
void astTranN_( AstMapping *, int, int, int, const double *, int, int, int, double * );
void astTranP_( AstMapping *, int, int, const double *[], int, int, double *[] );

void astDecomposeId_( AstMapping *, AstMapping **, AstMapping **, int *, int *, int * );
void astMapBoxId_( AstMapping *, const double [], const double [], int, int, double *, double *, double [], double [] );
double astRateId_( AstMapping *, double *, int, int, double * );
#define astCheckMapping(this) astINVOKE_CHECK(Mapping,this)

#define astIsAMapping(this) astINVOKE_ISA(Mapping,this)
#define astInvert(this) astINVOKE(V,astInvert_(astCheckMapping(this)))

#define astResampleD(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleD_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleF(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleF_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleL(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleL_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleUL(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleUL_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleI(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleI_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleUI(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleUI_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleS(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleS_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleUS(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleUS_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleB(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleB_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astResampleUB(this,ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var) astINVOKE(V,astResampleUB_(astCheckMapping(this),ndim_in,lbnd_in,ubnd_in,in,in_var,interp,finterp,params,flags,tol,maxpix,badval,ndim_out,lbnd_out,ubnd_out,lbnd,ubnd,out,out_var))

#define astSimplify(this) astINVOKE(O,astSimplify_(astCheckMapping(this)))
#define astTran1(this,npoint,xin,forward,xout) astINVOKE(V,astTran1_(astCheckMapping(this),npoint,xin,forward,xout))

#define astTran2(this,npoint,xin,yin,forward,xout,yout) astINVOKE(V,astTran2_(astCheckMapping(this),npoint,xin,yin,forward,xout,yout))

#define astTranN(this,npoint,ncoord_in,indim,in,forward,ncoord_out,outdim,out) astINVOKE(V,astTranN_(astCheckMapping(this),npoint,ncoord_in,indim,in,forward,ncoord_out,outdim,out))

#define astTranP(this,npoint,ncoord_in,ptr_in,forward,ncoord_out,ptr_out) astINVOKE(V,astTranP_(astCheckMapping(this),npoint,ncoord_in,ptr_in,forward,ncoord_out,ptr_out))
#define astDecompose(this,map1,map2,series,inv1,inv2) astINVOKE(V,astDecomposeId_(astCheckMapping(this),(AstMapping **)(map1),(AstMapping **)(map2),series,inv1,inv2))

#define astMapBox(this,lbnd_in,ubnd_in,forward,coord_out,lbnd_out,ubnd_out,xl,xu) astINVOKE(V,astMapBoxId_(astCheckMapping(this),lbnd_in,ubnd_in,forward,coord_out,lbnd_out,ubnd_out,xl,xu))

#define astRate(this,at,ax1,ax2,d2) astINVOKE(V,astRateId_(astCheckMapping(this),at,ax1,ax2,d2))
/* ast_err. */
/* ======== */

#define AST_ERROR_DEFINED

#define AST__ATGER 233933154

#define AST__ATSER 233933162

#define AST__ATTIN 233933170

#define AST__AXIIN 233933178

#define AST__BADAT 233933186

#define AST__BADBX 233933194

#define AST__BADIN 233933202

#define AST__BADNI 233933210

#define AST__BADNO 233933218

#define AST__BADPW 233933226

#define AST__BADSM 233933234

#define AST__BADWM 233933242

#define AST__BDBRK 233933250

#define AST__BDFMT 233933258

#define AST__BDFTS 233933266

#define AST__BDOBJ 233933274

#define AST__CLPAX 233933282

#define AST__CORNG 233933290

#define AST__CVBRK 233933298

#define AST__DIMIN 233933306

#define AST__DTERR 233933314

#define AST__ENDIN 233933322

#define AST__EOCHN 233933330

#define AST__EXPIN 233933338

#define AST__FCRPT 233933346

#define AST__FMTER 233933354

#define AST__FRMIN 233933362

#define AST__FRSIN 233933370

#define AST__FTCNV 233933378

#define AST__GRFER 233933386

#define AST__INHAN 233933394

#define AST__INNCO 233933402

#define AST__INTER 233933410

#define AST__INTRD 233933418

#define AST__LDERR 233933426

#define AST__LUTII 233933434

#define AST__LUTIN 233933442

#define AST__MEMIN 233933450

#define AST__MTR23 233933458

#define AST__MTRAX 233933466

#define AST__MTRML 233933474

#define AST__MTRMT 233933482

#define AST__NAXIN 233933490

#define AST__NCHIN 233933498

#define AST__NCOIN 233933506

#define AST__NCPIN 233933514

#define AST__NELIN 233933522

#define AST__NOCTS 233933530

#define AST__NODEF 233933538

#define AST__NOFTS 233933546

#define AST__NOMEM 233933554

#define AST__NOPTS 233933562

#define AST__NOWRT 233933570

#define AST__NPTIN 233933578

#define AST__OBJIN 233933586

#define AST__OPT 233933594

#define AST__PDSIN 233933602

#define AST__PLFMT 233933610

#define AST__PRMIN 233933618

#define AST__PTRIN 233933626

#define AST__PTRNG 233933634

#define AST__RDERR 233933642

#define AST__REMIN 233933650

#define AST__SCSIN 233933658

#define AST__SELIN 233933666

#define AST__SLAIN 233933674

#define AST__TRNND 233933682

#define AST__UNMQT 233933690

#define AST__VSMAL 233933698

#define AST__WCSAX 233933706

#define AST__WCSNC 233933714

#define AST__WCSPA 233933722

#define AST__WCSTY 233933730

#define AST__XSOBJ 233933738

#define AST__ZOOMI 233933746

#define AST__BADCI 233933754

#define AST__ILOST 233933762

#define AST__ITFER 233933770

#define AST__ITFNI 233933778

#define AST__MBBNF 233933786

#define AST__MRITF 233933794

#define AST__OCLUK 233933802

#define AST__UNFER 233933810

#define AST__URITF 233933818

#define AST__GBDIN 233933826

#define AST__NGDIN 233933834

#define AST__PATIN 233933842

#define AST__SISIN 233933850

#define AST__SSPIN 233933858

#define AST__UINER 233933866

#define AST__UK1ER 233933874

#define AST__COMIN 233933882

#define AST__CONIN 233933890

#define AST__DUVAR 233933898

#define AST__INNTF 233933906

#define AST__MIOPA 233933914

#define AST__MIOPR 233933922

#define AST__MISVN 233933930

#define AST__MLPAR 233933938

#define AST__MRPAR 233933946

#define AST__NORHS 233933954

#define AST__UDVOF 233933962

#define AST__VARIN 233933970

#define AST__WRNFA 233933978

#define AST__BADUN 233933986

#define AST__NORSF 233933994

#define AST__NOSOR 233934002

#define AST__SPCIN 233934010

#define AST__XMLNM 233934018

#define AST__XMLCM 233934026

#define AST__XMLPT 233934034

#define AST__XMLIT 233934042

#define AST__XMLWF 233934050

#define AST__ZERAX 233934058

#define AST__BADOC 233934066
/* object. */
/* ======= */

/* pointset. */
/* ========= */

/* axis. */
/* ===== */
typedef struct AstAxis {

   AstObject object;

   char *label;
   char *format;
   char *symbol;
   char *unit;
   int digits;
   int direction;
   double top;
   double bottom;
} AstAxis;
astPROTO_CHECK(Axis)
astPROTO_ISA(Axis)

AstAxis *astAxisId_( const char *, ... );
const char *astAxisFormat_( AstAxis *, double );
int astAxisUnformat_( AstAxis *, const char *, double * );
void astAxisNorm_( AstAxis *, double * );
#define astCheckAxis(this) astINVOKE_CHECK(Axis,this)

#define astIsAAxis(this) astINVOKE_ISA(Axis,this)

#define astAxis astINVOKE(F,astAxisId_)
#define astAxisFormat(this,value) astINVOKE(V,astAxisFormat_(astCheckAxis(this),value))

#define astAxisNorm(this,value) astINVOKE(V,astAxisNorm_(astCheckAxis(this),value))

#define astAxisUnformat(this,string,value) astINVOKE(V,astAxisUnformat_(astCheckAxis(this),string,value))
/* skyaxis. */
/* ======== */
typedef struct AstSkyAxis {

   AstAxis axis;

   char *skyformat;
   int as_time;
   int is_latitude;
} AstSkyAxis;
astPROTO_CHECK(SkyAxis)
astPROTO_ISA(SkyAxis)

AstSkyAxis *astSkyAxisId_( const char *, ... );
#define astCheckSkyAxis(this) astINVOKE_CHECK(SkyAxis,this)

#define astIsASkyAxis(this) astINVOKE_ISA(SkyAxis,this)

#define astSkyAxis astINVOKE(F,astSkyAxisId_)
/* mapping. */
/* ======== */

/* cmpmap. */
/* ======= */
typedef struct AstCmpMap {

   AstMapping mapping;

   AstMapping *map1;
   AstMapping *map2;
   int invert1;
   int invert2;
   int series;
} AstCmpMap;
astPROTO_CHECK(CmpMap)
astPROTO_ISA(CmpMap)

AstCmpMap *astCmpMapId_( void *, void *, int, const char *, ... );
#define astCheckCmpMap(this) astINVOKE_CHECK(CmpMap,this)

#define astIsACmpMap(this) astINVOKE_ISA(CmpMap,this)

#define astCmpMap astINVOKE(F,astCmpMapId_)
/* dssmap. */
/* ======= */
typedef struct AstFitsChan {

   AstChannel channel;

   int encoding;
   int defb1950;
   int cdmatrix;
   int carlin;
   int iwc;
   int clean;
   int fitsdigits;
   char *warnings;
   void *card;
   void *head;
   void *keyseq;
   const char *(* source)( void );
   char *(* source_wrap)( const char *(*)( void ) );

   void (* sink)( const char * );
   void (* sink_wrap)( void (*)( const char * ), const char * );

} AstFitsChan;
astPROTO_CHECK(FitsChan)
astPROTO_ISA(FitsChan)

AstFitsChan *astFitsChanId_( const char *(*)( void ), void (*)( const char * ),
                            const char *, ... );
AstFitsChan *astFitsChanForId_( const char *(*)( void ),
                              char *(*)( const char *(*)( void ) ),
                              void (*)( const char * ),
                              void (*)( void (*)( const char * ),
                                        const char * ),
                              const char *, ... );
   void astPutFits_( AstFitsChan *, const char [81], int );
   void astPutCards_( AstFitsChan *, const char * );
   int astFindFits_( AstFitsChan *, const char *, char [81], int );
   void astDelFits_( AstFitsChan * );
#define astCheckFitsChan(this) astINVOKE_CHECK(FitsChan,this)

#define astIsAFitsChan(this) astINVOKE_ISA(FitsChan,this)

#define astFitsChan astINVOKE(F,astFitsChanId_)
#define astFitsChanFor astINVOKE(F,astFitsChanForId_)
#define astPutFits(this,card,overwrite) astINVOKE(V,astPutFits_(astCheckFitsChan(this),card,overwrite))

#define astPutCards(this,cards) astINVOKE(V,astPutCards_(astCheckFitsChan(this),cards))

#define astDelFits(this) astINVOKE(V,astDelFits_(astCheckFitsChan(this)))

#define astFindFits( this, name, card, inc ) astINVOKE(V,astFindFits_(astCheckFitsChan(this),name,card,inc))
typedef struct AstDssMap {

   AstMapping mapping;

   void *wcs;

} AstDssMap;
astPROTO_CHECK(DssMap)
astPROTO_ISA(DssMap)
#define astCheckDssMap(this) astINVOKE_CHECK(DssMap,this)

#define astIsADssMap(this) astINVOKE_ISA(DssMap,this)
/* grismmap. */
/* ========= */
typedef struct AstGrismMap {

   AstMapping mapping;

   double nr;
   double nrp;
   double waver;
   double alpha;
   double g;
   double m;
   double eps;
   double theta;
   double k1;
   double k2;
   double k3;

} AstGrismMap;
astPROTO_CHECK(GrismMap)
astPROTO_ISA(GrismMap)

AstGrismMap *astGrismMapId_( const char *, ... );
#define astCheckGrismMap(this) astINVOKE_CHECK(GrismMap,this)

#define astIsAGrismMap(this) astINVOKE_ISA(GrismMap,this)

#define astGrismMap astINVOKE(F,astGrismMapId_)
/* intramap. */
/* ========= */
#define AST__NOFWD (1U)
#define AST__NOINV (2U)
#define AST__SIMPFI (4U)
#define AST__SIMPIF (8U)

#define AST__ANY (-66)

typedef struct AstIntraMap {

   AstMapping mapping;

   char *intraflag;
   int ifun;
} AstIntraMap;
astPROTO_CHECK(IntraMap)
astPROTO_ISA(IntraMap)

AstIntraMap *astIntraMapId_( const char *, int, int, const char *, ... );
void astIntraReg_( const char *, int, int, void (*)( AstMapping *, int, int, const double *[], int, int, double *[] ), unsigned int, const char *, const char *, const char * );
void astIntraRegFor_( const char *, int, int, void (*)( AstMapping *, int, int, const double *[], int, int, double *[] ), void (*)( void (*)( AstMapping *, int, int, const double *[], int, int, double *[] ), AstMapping *, int, int, const double *[], int, int, double *[] ), unsigned int, const char *, const char *, const char * );
#define astCheckIntraMap(this) astINVOKE_CHECK(IntraMap,this)

#define astIsAIntraMap(this) astINVOKE_ISA(IntraMap,this)

#define astIntraMap astINVOKE(F,astIntraMapId_)
#define astIntraReg(name,nin,nout,tran,flags,purpose,author,contact) astIntraReg_(name,nin,nout,tran,flags,purpose,author,contact)
#define astIntraRegFor(name,nin,nout,tran,tran_wrap,flags,purpose,author,contact) astIntraRegFor_(name,nin,nout,tran,tran_wrap,flags,purpose,author,contact)
/* lutmap. */
/* ======= */
typedef struct AstLutMap {

   AstMapping mapping;

   double *lut;
   double start;
   double inc;
   double last_fwd_in;
   double last_fwd_out;
   double last_inv_in;
   double last_inv_out;
   int nlut;
} AstLutMap;
astPROTO_CHECK(LutMap)
astPROTO_ISA(LutMap)

AstLutMap *astLutMapId_( int, const double [], double, double, const char *, ... );
#define astCheckLutMap(this) astINVOKE_CHECK(LutMap,this)

#define astIsALutMap(this) astINVOKE_ISA(LutMap,this)

#define astLutMap astINVOKE(F,astLutMapId_)
/* mathmap. */
/* ======== */
#define AST_MATHMAP_RAND_CONTEXT_NTAB_ (32)
typedef struct AstMathMapRandContext_ {
   long int rand1;
   long int rand2;
   long int random_int;
   long int table[ AST_MATHMAP_RAND_CONTEXT_NTAB_ ];
   int active;
   int seed;
   int seed_set;
} AstMathMapRandContext_;

typedef struct AstMathMap {

   AstMapping mapping;

   AstMathMapRandContext_ rcontext;
   char **fwdfun;
   char **invfun;
   double **fwdcon;
   double **invcon;
   int **fwdcode;
   int **invcode;
   int fwdstack;
   int invstack;
   int nfwd;
   int ninv;
   int simp_fi;
   int simp_if;
} AstMathMap;
astPROTO_CHECK(MathMap)
astPROTO_ISA(MathMap)

AstMathMap *astMathMapId_( int, int, int, const char *[], int, const char *[],
                           const char *, ... );
#define astCheckMathMap(this) astINVOKE_CHECK(MathMap,this)

#define astIsAMathMap(this) astINVOKE_ISA(MathMap,this)

#define astMathMap astINVOKE(F,astMathMapId_)
/* matrixmap. */
/* ========== */
typedef struct AstMatrixMap {

   AstMapping mapping;

   double *f_matrix;
   double *i_matrix;
   int form;

} AstMatrixMap;
astPROTO_CHECK(MatrixMap)
astPROTO_ISA(MatrixMap)

AstMatrixMap *astMatrixMapId_( int, int, int, const double[], const char *, ... );
#define astCheckMatrixMap(this) astINVOKE_CHECK(MatrixMap,this)

#define astIsAMatrixMap(this) astINVOKE_ISA(MatrixMap,this)

#define astMatrixMap astINVOKE(F,astMatrixMapId_)
/* pcdmap. */
/* ======= */
typedef struct AstPcdMap {

   AstMapping mapping;

   double disco;
   double pcdcen[2];

} AstPcdMap;
astPROTO_CHECK(PcdMap)
astPROTO_ISA(PcdMap)

AstPcdMap *astPcdMapId_( double, const double [2], const char *, ... );
#define astCheckPcdMap(this) astINVOKE_CHECK(PcdMap,this)

#define astIsAPcdMap(this) astINVOKE_ISA(PcdMap,this)

#define astPcdMap astINVOKE(F,astPcdMapId_)
/* permmap. */
/* ======== */
typedef struct AstPermMap {

   AstMapping mapping;

   int *inperm;
   int *outperm;
   double *constant;
} AstPermMap;
astPROTO_CHECK(PermMap)
astPROTO_ISA(PermMap)

AstPermMap *astPermMapId_( int, const int [], int, const int [],
                           const double [], const char *, ... );
#define astCheckPermMap(this) astINVOKE_CHECK(PermMap,this)

#define astIsAPermMap(this) astINVOKE_ISA(PermMap,this)

#define astPermMap astINVOKE(F,astPermMapId_)
/* polymap. */
/* ======== */
typedef struct AstPolyMap {

   AstMapping mapping;

   int *ncoeff_f;
   int *mxpow_f;
   int ***power_f;
   double **coeff_f;
   int *ncoeff_i;
   int *mxpow_i;
   int ***power_i;
   double **coeff_i;
} AstPolyMap;
astPROTO_CHECK(PolyMap)
astPROTO_ISA(PolyMap)

AstPolyMap *astPolyMapId_( int, int, int, const double[], int, const double[], const char *, ... );
#define astCheckPolyMap(this) astINVOKE_CHECK(PolyMap,this)

#define astIsAPolyMap(this) astINVOKE_ISA(PolyMap,this)

#define astPolyMap astINVOKE(F,astPolyMapId_)
/* shiftmap. */
/* ========= */
typedef struct AstShiftMap {

   AstMapping mapping;

   double *shift;

} AstShiftMap;
astPROTO_CHECK(ShiftMap)
astPROTO_ISA(ShiftMap)

AstShiftMap *astShiftMapId_( int, const double [], const char *, ... );
#define astCheckShiftMap(this) astINVOKE_CHECK(ShiftMap,this)

#define astIsAShiftMap(this) astINVOKE_ISA(ShiftMap,this)

#define astShiftMap astINVOKE(F,astShiftMapId_)
/* slamap. */
/* ======= */
#define AST__AU 1.49597870E11

#define AST__SOLRAD 6.96E8

typedef struct AstSlaMap {

   AstMapping mapping;

   int *cvttype;
   double **cvtargs;
   int ncvt;
} AstSlaMap;
astPROTO_CHECK(SlaMap)
astPROTO_ISA(SlaMap)

AstSlaMap *astSlaMapId_( int, const char *, ... );
void astSlaAdd_( AstSlaMap *, const char *, const double[] );
#define astCheckSlaMap(this) astINVOKE_CHECK(SlaMap,this)

#define astIsASlaMap(this) astINVOKE_ISA(SlaMap,this)

#define astSlaMap astINVOKE(F,astSlaMapId_)
#define astSlaAdd(this,cvt,args) astINVOKE(V,astSlaAdd_(astCheckSlaMap(this),cvt,args))
/* specmap. */
/* ======== */
#define AST__C 2.99792458E8
#define AST__H 6.6260755E-34

typedef struct AstSpecMap {

   AstMapping mapping;

   int *cvttype;
   double **cvtargs;
   int ncvt;
} AstSpecMap;
astPROTO_CHECK(SpecMap)
astPROTO_ISA(SpecMap)

AstSpecMap *astSpecMapId_( int, int, const char *, ... );
void astSpecAdd_( AstSpecMap *, const char *, const double[] );
#define astCheckSpecMap(this) astINVOKE_CHECK(SpecMap,this)

#define astIsASpecMap(this) astINVOKE_ISA(SpecMap,this)

#define astSpecMap astINVOKE(F,astSpecMapId_)
#define astSpecAdd(this,cvt,args) astINVOKE(V,astSpecAdd_(astCheckSpecMap(this),cvt,args))
/* sphmap. */
/* ======= */
typedef struct AstSphMap {

   AstMapping mapping;

   double polarlong;
   int unitradius;
} AstSphMap;
astPROTO_CHECK(SphMap)
astPROTO_ISA(SphMap)

AstSphMap *astSphMapId_( const char *, ... );
#define astCheckSphMap(this) astINVOKE_CHECK(SphMap,this)

#define astIsASphMap(this) astINVOKE_ISA(SphMap,this)

#define astSphMap astINVOKE(F,astSphMapId_)
/* tranmap. */
/* ======== */
typedef struct AstTranMap {

   AstMapping mapping;

   AstMapping *map1;
   AstMapping *map2;
   int invert1;
   int invert2;
} AstTranMap;
astPROTO_CHECK(TranMap)
astPROTO_ISA(TranMap)

AstTranMap *astTranMapId_( void *, void *, const char *, ... );
#define astCheckTranMap(this) astINVOKE_CHECK(TranMap,this)

#define astIsATranMap(this) astINVOKE_ISA(TranMap,this)

#define astTranMap astINVOKE(F,astTranMapId_)
/* unitmap. */
/* ======== */
typedef struct AstUnitMap {

   AstMapping mapping;

} AstUnitMap;
astPROTO_CHECK(UnitMap)
astPROTO_ISA(UnitMap)

AstUnitMap *astUnitMapId_( int, const char *, ... );
#define astCheckUnitMap(this) astINVOKE_CHECK(UnitMap,this)

#define astIsAUnitMap(this) astINVOKE_ISA(UnitMap,this)

#define astUnitMap astINVOKE(F,astUnitMapId_)
/* wcsmap. */
/* ======= */
#define AST__WCSMX 10

#define AST__DPI 3.1415926535897932384626433832795028841971693993751

#define AST__DPIBY2 1.5707963267948966192313216916397514420985846996876

#define AST__DD2R 0.017453292519943295769236907684886127134428718885417

#define AST__DR2D 57.295779513082320876798154814105170332405472466564

#define AST__AZP 1
#define AST__SZP 2
#define AST__TAN 3
#define AST__STG 4
#define AST__SIN 5
#define AST__ARC 6
#define AST__ZPN 7
#define AST__ZEA 8
#define AST__AIR 9
#define AST__CYP 10
#define AST__CEA 11
#define AST__CAR 12
#define AST__MER 13
#define AST__SFL 14
#define AST__PAR 15
#define AST__MOL 16
#define AST__AIT 17
#define AST__COP 18
#define AST__COE 19
#define AST__COD 20
#define AST__COO 21
#define AST__BON 22
#define AST__PCO 23
#define AST__TSC 24
#define AST__CSC 25
#define AST__QSC 26
#define AST__NCP 27
#define AST__GLS 28
#define AST__TPN 29
#define AST__WCSBAD 30

typedef struct AstWcsMap {

   AstMapping mapping;

   int type;
   int wcsaxis[2];
   double **p;
   int *np;
   struct AstPrjPrm params;

} AstWcsMap;
astPROTO_CHECK(WcsMap)
astPROTO_ISA(WcsMap)

AstWcsMap *astWcsMapId_( int, int, int, int, const char *, ... );
#define astCheckWcsMap(this) astINVOKE_CHECK(WcsMap,this)

#define astIsAWcsMap(this) astINVOKE_ISA(WcsMap,this)

#define astWcsMap astINVOKE(F,astWcsMapId_)
/* winmap. */
/* ======= */
typedef struct AstWinMap {

   AstMapping mapping;

   double *a;
   double *b;

} AstWinMap;
astPROTO_CHECK(WinMap)
astPROTO_ISA(WinMap)

AstWinMap *astWinMapId_( int, const double [], const double [], const double [], const double [], const char *, ... );
#define astCheckWinMap(this) astINVOKE_CHECK(WinMap,this)

#define astIsAWinMap(this) astINVOKE_ISA(WinMap,this)

#define astWinMap astINVOKE(F,astWinMapId_)
/* xmlchan. */
/* ======== */
#define AST__XMLNS "http://www.starlink.ac.uk/ast/xml/"
typedef struct AstXmlChan {

   AstChannel channel;

   const char *objectname;
   const char *objectcomment;
   int objectset;
   AstXmlParent *container;
   AstXmlDocument *readcontext;
   int write_isa;
   int xmlindent;
   int xmllength;
   int xmlformat;
   int formatdef;
   char *xmlprefix;
   int reset_source;
   const char *isa_class;
} AstXmlChan;
astPROTO_CHECK(XmlChan)
astPROTO_ISA(XmlChan)

AstXmlChan *astXmlChanId_( const char *(*)( void ), void (*)( const char * ),
                            const char *, ... );
AstXmlChan *astXmlChanForId_( const char *(*)( void ),
                              char *(*)( const char *(*)( void ) ),
                              void (*)( const char * ),
                              void (*)( void (*)( const char * ),
                                        const char * ),
                              const char *, ... );
#define astCheckXmlChan(this) astINVOKE_CHECK(XmlChan,this)

#define astIsAXmlChan(this) astINVOKE_ISA(XmlChan,this)

#define astXmlChan astINVOKE(F,astXmlChanId_)
#define astXmlChanFor astINVOKE(F,astXmlChanForId_)
/* zoommap. */
/* ======== */
typedef struct AstZoomMap {

   AstMapping mapping;

   double zoom;
} AstZoomMap;
astPROTO_CHECK(ZoomMap)
astPROTO_ISA(ZoomMap)

AstZoomMap *astZoomMapId_( int, double, const char *, ... );
#define astCheckZoomMap(this) astINVOKE_CHECK(ZoomMap,this)

#define astIsAZoomMap(this) astINVOKE_ISA(ZoomMap,this)

#define astZoomMap astINVOKE(F,astZoomMapId_)
/* frame. */
/* ====== */
typedef int AstSystemType;

typedef struct AstFrame {

   AstMapping mapping;

   AstAxis **axis;
   char *domain;
   char *title;
   double epoch;
   int *perm;
   int digits;
   int match_end;
   int active_unit;
   int max_axes;
   int min_axes;
   int naxes;
   int permute;
   int preserve_axes;
   AstSystemType system;
   AstSystemType alignsystem;
} AstFrame;

struct AstFrameSet;
#define AST__BASE (0)
#define AST__CURRENT (-1)
#define AST__NOFRAME (-99)

typedef struct AstFrameSet {

   AstFrame parent;

   AstFrame **frame;
   AstMapping **map;
   int *invert;
   int *link;
   int *node;
   int base;
   int current;
   int nframe;
   int nnode;
} AstFrameSet;
astPROTO_CHECK(FrameSet)
astPROTO_ISA(FrameSet)

AstFrameSet *astFrameSetId_( void *, const char *, ... );
AstFrame *astGetFrame_( AstFrameSet *, int );
AstMapping *astGetMapping_( AstFrameSet *, int, int );
void astAddFrame_( AstFrameSet *, int , AstMapping *, AstFrame * );
void astRemapFrame_( AstFrameSet *, int, AstMapping * );
void astRemoveFrame_( AstFrameSet *, int );
#define astCheckFrameSet(this) astINVOKE_CHECK(FrameSet,this)

#define astIsAFrameSet(this) astINVOKE_ISA(FrameSet,this)

#define astFrameSet astINVOKE(F,astFrameSetId_)
#define astAddFrame(this,iframe,map,frame) astINVOKE(V,astAddFrame_(astCheckFrameSet(this),iframe,astCheckMapping(map),astCheckFrame(frame)))

#define astGetFrame(this,iframe) astINVOKE(O,astGetFrame_(astCheckFrameSet(this),iframe))

#define astGetMapping(this,iframe1,iframe2) astINVOKE(O,astGetMapping_(astCheckFrameSet(this),iframe1,iframe2))

#define astRemapFrame(this,iframe,map) astINVOKE(V,astRemapFrame_(astCheckFrameSet(this),iframe,astCheckMapping(map)))

#define astRemoveFrame(this,iframe) astINVOKE(V,astRemoveFrame_(astCheckFrameSet(this),iframe))

astPROTO_CHECK(Frame)
astPROTO_ISA(Frame)

AstFrame *astFrameId_( int, const char *, ... );
AstFrameSet *astConvert_( AstFrame *, AstFrame *, const char * );
AstFrameSet *astFindFrame_( AstFrame *, AstFrame *, const char * );
double astAngle_( AstFrame *, const double[], const double[], const double[] );
double astDistance_( AstFrame *, const double[], const double[] );
void astNorm_( AstFrame *, double[] );
double astAxDistance_( AstFrame *, int, double, double );
double astAxOffset_( AstFrame *, int, double, double );
double astAxAngle_( AstFrame *, const double[2], const double[2], int );
double astOffset2_( AstFrame *, const double[2], double, double, double[2] );
void astOffset_( AstFrame *, const double[], const double[], double, double[] );
void astResolve_( AstFrame *, const double [], const double [], const double [], double [], double *, double * );
int astGetActiveUnit_( AstFrame * );
void astSetActiveUnit_( AstFrame *, int );

AstFrame *astPickAxesId_( AstFrame *, int, const int[], AstMapping ** );
const char *astFormatId_( AstFrame *, int, double );
int astUnformatId_( AstFrame *, int, const char *, double * );
void astPermAxesId_( AstFrame *, const int[] );
#define astCheckFrame(this) astINVOKE_CHECK(Frame,this)

#define astIsAFrame(this) astINVOKE_ISA(Frame,this)

#define astFrame astINVOKE(F,astFrameId_)
#define astConvert(from,to,domainlist) astINVOKE(O,astConvert_(astCheckFrame(from),astCheckFrame(to),domainlist))

#define astAngle(this,a,b,c) astINVOKE(V,astAngle_(astCheckFrame(this),a,b,c))

#define astDistance(this,point1,point2) astINVOKE(V,astDistance_(astCheckFrame(this),point1,point2))

#define astFindFrame(target,template,domainlist) astINVOKE(O,astFindFrame_(astCheckFrame(target),astCheckFrame(template),domainlist))

#define astNorm(this,value) astINVOKE(V,astNorm_(astCheckFrame(this),value))

#define astAxDistance(this,axis,v1,v2) astINVOKE(V,astAxDistance_(astCheckFrame(this),axis,v1,v2))

#define astAxOffset(this,axis,v1,dist) astINVOKE(V,astAxOffset_(astCheckFrame(this),axis,v1,dist))

#define astOffset(this,point1,point2,offset,point3) astINVOKE(V,astOffset_(astCheckFrame(this),point1,point2,offset,point3))

#define astAxAngle(this,a,b,axis) astINVOKE(V,astAxAngle_(astCheckFrame(this),a,b,axis))

#define astOffset2(this,point1,angle,offset,point2) astINVOKE(V,astOffset2_(astCheckFrame(this),point1,angle,offset,point2))

#define astResolve(this,point1,point2,point3,point4,d1,d2) astINVOKE(V,astResolve_(astCheckFrame(this),point1,point2,point3,point4,d1,d2))

#define astGetActiveUnit(this) astINVOKE(V,astGetActiveUnit_(astCheckFrame(this)))

#define astSetActiveUnit(this,value) astINVOKE(V,astSetActiveUnit_(astCheckFrame(this),value))
#define astFormat(this,axis,value) astINVOKE(V,astFormatId_(astCheckFrame(this),axis,value))

#define astPermAxes(this,perm) astINVOKE(V,astPermAxesId_(astCheckFrame(this),perm))

#define astPickAxes(this,naxes,axes,map) astINVOKE(O,astPickAxesId_(astCheckFrame(this),naxes,axes,(AstMapping **)(map)))

#define astUnformat(this,axis,string,value) astINVOKE(V,astUnformatId_(astCheckFrame(this),axis,string,value))
/* cmpframe. */
/* ========= */
typedef struct AstCmpFrame {

   AstFrame frame;

   AstFrame *frame1;
   AstFrame *frame2;
   int *perm;
} AstCmpFrame;
astPROTO_CHECK(CmpFrame)
astPROTO_ISA(CmpFrame)

AstCmpFrame *astCmpFrameId_( void *, void *, const char *, ... );
#define astCheckCmpFrame(this) astINVOKE_CHECK(CmpFrame,this)

#define astIsACmpFrame(this) astINVOKE_ISA(CmpFrame,this)

#define astCmpFrame astINVOKE(F,astCmpFrameId_)
/* frameset. */
/* ========= */
/* plot. */
/* ===== */

#define AST__NPID 15

#define AST__GATTR 0
#define AST__GFLUSH 1
#define AST__GLINE 2
#define AST__GMARK 3
#define AST__GTEXT 4
#define AST__GTXEXT 5
#define AST__GSCALES 6
#define AST__GQCH 7
#define AST__GCAP 8

#define AST__NGRFFUN 9
struct AstPlot;

typedef void (* AstGrfFun)();

typedef int (* AstGAttrFun)( int, double, double *, int );
typedef int (* AstGFlushFun)();
typedef int (* AstGLineFun)( int, const float *, const float * );
typedef int (* AstGMarkFun)( int, const float *, const float *, int );
typedef int (* AstGTextFun)( const char *, float, float, const char *, float, float );
typedef int (* AstGCapFun)( int, int );
typedef int (* AstGTxExtFun)( const char *, float, float, const char *, float, float, float *, float * );
typedef int (* AstGScalesFun)( float *, float * );
typedef int (* AstGQchFun)( float *, float * );

typedef void (* AstGrfWrap)();

typedef int (* AstGAttrWrap)( struct AstPlot *, int, double, double *, int );
typedef int (* AstGFlushWrap)( struct AstPlot * );
typedef int (* AstGLineWrap)( struct AstPlot *, int, const float *, const float * );
typedef int (* AstGMarkWrap)( struct AstPlot *, int, const float *, const float *, int );
typedef int (* AstGTextWrap)( struct AstPlot *, const char *, float, float, const char *, float, float );
typedef int (* AstGCapWrap)( struct AstPlot *, int, int );
typedef int (* AstGTxExtWrap)( struct AstPlot *, const char *, float, float, const char *, float, float, float *, float * );
typedef int (* AstGScalesWrap)( struct AstPlot *, float *, float * );
typedef int (* AstGQchWrap)( struct AstPlot *, float *, float * );

typedef struct AstGrfPtrs {
   AstGrfFun grffun[AST__NGRFFUN];
   AstGAttrWrap GAttr;
   AstGFlushWrap GFlush;
   AstGLineWrap GLine;
   AstGMarkWrap GMark;
   AstGTextWrap GText;
   AstGCapWrap GCap;
   AstGTxExtWrap GTxExt;
   AstGScalesWrap GScales;
   AstGQchWrap GQch;
} AstGrfPtrs;

typedef struct AstGat {
   float rise;
   double size;
   double width;
   double col;
   double font;
   double style;
} AstGat;

typedef struct AstPlot {

   AstFrameSet parent;

   double *clip_lbnd;
   double *clip_ubnd;
   double centre[ 2 ];
   double gap[ 2 ];
   double loggap[ 2 ];
   double labelat[ 2 ];
   double majticklen[ 2 ];
   double minticklen[ 2 ];
   double numlabgap[ 2 ];
   double size[ AST__NPID ];
   double textlabgap[ 2 ];
   double titlegap;
   double tol;
   double ucentre[ 2 ];
   double ugap[ 2 ];
   double uloggap[ 2 ];
   double ulblat[ 2 ];
   double umjtkln[ 2 ];
   double width[ AST__NPID ];
   double xhi;
   double xlo;
   double yhi;
   double ylo;
   double bbox[ 4 ];
   int border;
   int clip_axes;
   int clip_frame;
   int clipop;
   int colour[ AST__NPID ];
   int drawaxes[ 2 ];
   int escape;
   int drawtitle;
   int edge[ 2 ];
   int font[ AST__NPID ];
   int grf;
   int grid;
   int invisible;
   int labelling;
   int labelunits[ 2 ];
   int labelup[ 2 ];
   int mintick[ 2 ];
   int numlab[ 2 ];
   int style[ AST__NPID ];
   int textlab[ 2 ];
   int tickall;
   int uborder;
   int uedge[ 2 ];
   int ugrid;
   int ulbling;
   int ulbunit[ 2 ];
   int ulgtk[ 2 ];
   int ulglb[ 2 ];
   int umintk[ 2 ];
   int utxtlb[ 2 ];
   int xrev;
   int yrev;
   int ink;
   int logplot[ 2 ];
   int logticks[ 2 ];
   int loglabel[ 2 ];
   AstGrfFun grffun[AST__NGRFFUN];
   AstGAttrWrap GAttr;
   AstGFlushWrap GFlush;
   AstGLineWrap GLine;
   AstGMarkWrap GMark;
   AstGTextWrap GText;
   AstGCapWrap GCap;
   AstGTxExtWrap GTxExt;
   AstGScalesWrap GScales;
   AstGQchWrap GQch;
   AstGrfPtrs *grfstack;
   int grfnstack;
   AstGat **gat;
   int ngat;

} AstPlot;
astPROTO_CHECK(Plot)
astPROTO_ISA(Plot)

AstPlot *astPlotId_( void *, const float [], const double [], const char *, ... );
   const char *astStripEscapes_( const char * );
   int astFindEscape_( const char *, int *, int *, int * );
   int astBorder_( AstPlot * );
   void astBoundingBox_( AstPlot *, float[2], float[2] );
   void astClip_( AstPlot *, int, const double [], const double [] );
   void astGridLine_( AstPlot *, int, const double [], double );
   void astCurve_( AstPlot *, const double [], const double [] );
   void astGrid_( AstPlot * );
   void astMark_( AstPlot *, int, int, int, const double *, int );
   void astGrfSet_( AstPlot *, const char *, AstGrfFun );
   void astGrfPush_( AstPlot * );
   void astGrfPop_( AstPlot * );
   void astGenCurve_( AstPlot *, AstMapping * );
   void astPolyCurve_( AstPlot *, int, int, int, const double * );
   void astText_( AstPlot *, const char *, const double [], const float [2], const char * );

   void astGrfWrapper_( AstPlot *, const char *, AstGrfWrap );
   int astGrfFunID_( const char *, const char *, const char * );
#define astCheckPlot(this) astINVOKE_CHECK(Plot,this)

#define astIsAPlot(this) astINVOKE_ISA(Plot,this)

#define astPlot astINVOKE(F,astPlotId_)
#define astBorder(this) astINVOKE(V,astBorder_(astCheckPlot(this)))

#define astBoundingBox(this,lbnd,ubnd) astINVOKE(V,astBoundingBox_(astCheckPlot(this),lbnd,ubnd))

#define astClip(this,iframe,lbnd,ubnd) astINVOKE(V,astClip_(astCheckPlot(this),iframe,lbnd,ubnd))

#define astMark(this,nmark,ncoord,indim,in,type) astINVOKE(V,astMark_(astCheckPlot(this),nmark,ncoord,indim,in,type))

#define astText(this,text,pos,up,just) astINVOKE(V,astText_(astCheckPlot(this),text,pos,up,just))

#define astGrid(this) astINVOKE(V,astGrid_(astCheckPlot(this)))

#define astGridLine(this,axis,start,length) astINVOKE(V,astGridLine_(astCheckPlot(this),axis,start,length))

#define astCurve(this,start,finish) astINVOKE(V,astCurve_(astCheckPlot(this),start,finish))

#define astGenCurve(this,map) astINVOKE(V,astGenCurve_(astCheckPlot(this),astCheckMapping(map)))

#define astPolyCurve(this,npoint,ncoord,dim,in) astINVOKE(V,astPolyCurve_(astCheckPlot(this),npoint,ncoord,dim,in))

#define astGrfSet(this,name,fun) astINVOKE(V,astGrfSet_(astCheckPlot(this),name,fun))

#define astGrfPush(this) astINVOKE(V,astGrfPush_(astCheckPlot(this)))

#define astGrfPop(this) astINVOKE(V,astGrfPop_(astCheckPlot(this)))

#define astGrfFunID astGrfFunID_
#define astFindEscape astFindEscape_
#define astStripEscapes(text) astStripEscapes_(text)

#define astGrfWrapper(this,name,wrapper) astINVOKE(V,astGrfWrapper_(astCheckPlot(this),name,wrapper))
/* skyframe. */
/* ========= */
typedef struct AstSkyFrame {

   AstFrame frame;

   char *projection;
   double equinox;
   int neglon;
   int alignoffset;
   int skyrefis;
   double skyref[ 2 ];
   double skyrefp[ 2 ];
} AstSkyFrame;
astPROTO_CHECK(SkyFrame)
astPROTO_ISA(SkyFrame)

AstSkyFrame *astSkyFrameId_( const char *, ... );
#define astCheckSkyFrame(this) astINVOKE_CHECK(SkyFrame,this)

#define astIsASkyFrame(this) astINVOKE_ISA(SkyFrame,this)

#define astSkyFrame astINVOKE(F,astSkyFrameId_)
/* specframe. */
/* ========== */
typedef int AstStdOfRestType;

typedef struct AstSpecFrame {

   AstFrame frame;

   AstStdOfRestType alignstdofrest;
   AstStdOfRestType stdofrest;
   double geolat;
   double geolon;
   double refdec;
   double refra;
   double restfreq;
   double sourcevel;
   AstStdOfRestType sourcevrf;
   int nuunits;
   char **usedunits;
} AstSpecFrame;
astPROTO_CHECK(SpecFrame)
astPROTO_ISA(SpecFrame)

AstSpecFrame *astSpecFrameId_( const char *, ... );
void astGetRefPos_( AstSpecFrame *, AstSkyFrame *, double *, double * );
void astSetRefPos_( AstSpecFrame *, AstSkyFrame *, double, double );
#define astCheckSpecFrame(this) astINVOKE_CHECK(SpecFrame,this)

#define astIsASpecFrame(this) astINVOKE_ISA(SpecFrame,this)

#define astSpecFrame astINVOKE(F,astSpecFrameId_)
#define astGetRefPos(this,frm,lon,lat) astINVOKE(V,astGetRefPos_(astCheckSpecFrame(this),(frm==NULL?NULL:astCheckSkyFrame(frm)),lon,lat))
#define astSetRefPos(this,frm,lon,lat) astINVOKE(V,astSetRefPos_(astCheckSpecFrame(this),(frm==NULL?NULL:astCheckSkyFrame(frm)),lon,lat))
/* dsbspecframe. */
/* ============= */
typedef struct AstDSBSpecFrame {

   AstSpecFrame specframe;

   double dsbcentre;
   double ifr;
   int sideband;

} AstDSBSpecFrame;
astPROTO_CHECK(DSBSpecFrame)
astPROTO_ISA(DSBSpecFrame)

AstDSBSpecFrame *astDSBSpecFrameId_( const char *, ... );
#define astCheckDSBSpecFrame(this) astINVOKE_CHECK(DSBSpecFrame,this)

#define astIsADSBSpecFrame(this) astINVOKE_ISA(DSBSpecFrame,this)

#define astDSBSpecFrame astINVOKE(F,astDSBSpecFrameId_)
/* channel. */
/* ======== */
/* fitschan. */
/* ========= */

#endif
