static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Author: Hirotsuna Mizuno <s1041150@u-aizu.ac.jp>                           \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_displace_mode)                                               \n"
"  enum_value (GEGL_DISPLACE_MODE_CARTESIAN, \"cartesian\", N_(\"Cartesian\")) \n"
"  enum_value (GEGL_DISPLACE_MODE_POLAR, \"polar\", N_(\"Polar\"))             \n"
"enum_end (GeglDisplaceMode)                                                   \n"
"                                                                              \n"
"property_enum (displace_mode, _(\"Displacement mode\"),                       \n"
"                GeglDisplaceMode, gegl_displace_mode,                         \n"
"                GEGL_DISPLACE_MODE_CARTESIAN)                                 \n"
"  description (_(\"Mode of displacement\"))                                   \n"
"                                                                              \n"
"property_enum (sampler_type, _(\"Sampler\"),                                  \n"
"               GeglSamplerType, gegl_sampler_type,                            \n"
"               GEGL_SAMPLER_CUBIC)                                            \n"
"  description (_(\"Type of GeglSampler used to fetch input pixels\"))         \n"
"                                                                              \n"
"property_enum (abyss_policy, _(\"Abyss policy\"),                             \n"
"               GeglAbyssPolicy, gegl_abyss_policy,                            \n"
"               GEGL_ABYSS_CLAMP)                                              \n"
"  description (_(\"How image edges are handled\"))                            \n"
"                                                                              \n"
"property_double (amount_x, _(\"X displacement\"), 0.0)                        \n"
"    description (_(\"Displace multiplier for X or radial direction\"))        \n"
"    value_range (-500.0, 500.0)                                               \n"
"    ui_range    (-500.0, 500.0)                                               \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (amount_y, _(\"Y displacement\"), 0.0)                        \n"
"    description (_(\"Displace multiplier for Y or tangent (degrees) direction\"))\n"
"    value_range (-500.0, 500.0)                                               \n"
"    ui_range    (-500.0, 500.0)                                               \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     displace                                             \n"
"#define GEGL_OP_C_SOURCE displace.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static gdouble                                                                \n"
"get_base_displacement (gdouble  amount,                                       \n"
"                       gfloat  *map_pixel)                                    \n"
"{                                                                             \n"
"  return (2.0 * amount * (map_pixel[0] - 0.5) - 0.5) * map_pixel[1] + 0.5;    \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"get_input_cartesian_coordinates (gint     x,                                  \n"
"                                 gint     y,                                  \n"
"                                 gdouble  x_amount,                           \n"
"                                 gdouble  y_amount,                           \n"
"                                 gfloat  *xmap_pixel,                         \n"
"                                 gfloat  *ymap_pixel,                         \n"
"                                 gdouble *x_input,                            \n"
"                                 gdouble *y_input)                            \n"
"{                                                                             \n"
"  *x_input = x;                                                               \n"
"  *y_input = y;                                                               \n"
"                                                                              \n"
"  if (xmap_pixel && x_amount)                                                 \n"
"    {                                                                         \n"
"      *x_input += get_base_displacement (x_amount, xmap_pixel);               \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (ymap_pixel && y_amount)                                                 \n"
"    {                                                                         \n"
"      *y_input += get_base_displacement (y_amount, ymap_pixel);               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"get_input_polar_coordinates (gint     x,                                      \n"
"                             gint     y,                                      \n"
"                             gdouble  x_amount,                               \n"
"                             gdouble  y_amount,                               \n"
"                             gfloat  *xmap_pixel,                             \n"
"                             gfloat  *ymap_pixel,                             \n"
"                             gdouble  cx,                                     \n"
"                             gdouble  cy,                                     \n"
"                             gdouble *x_input,                                \n"
"                             gdouble *y_input)                                \n"
"{                                                                             \n"
"  gdouble radius, d_alpha;                                                    \n"
"                                                                              \n"
"  radius  = sqrt ((x - cx) * (x - cx) + (y - cy) * (y - cy));                 \n"
"  d_alpha = atan2 (x - cx, y - cy);                                           \n"
"                                                                              \n"
"  if (xmap_pixel && x_amount)                                                 \n"
"    {                                                                         \n"
"      radius += get_base_displacement (x_amount, xmap_pixel);                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (ymap_pixel && y_amount)                                                 \n"
"    {                                                                         \n"
"      d_alpha += (y_amount / 180) * M_PI * (ymap_pixel[0] - 0.5) / 0.5;       \n"
"    }                                                                         \n"
"                                                                              \n"
"  *x_input = cx + radius * sin (d_alpha);                                     \n"
"  *y_input = cy + radius * cos (d_alpha);                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *self)                                                  \n"
"{                                                                             \n"
"  GeglOperation *operation = GEGL_OPERATION (self);                           \n"
"  GParamSpec    *pspec;                                                       \n"
"                                                                              \n"
"  pspec = g_param_spec_object (\"output\",                                    \n"
"                               \"Output\",                                    \n"
"                               \"Output pad for generated image buffer.\",    \n"
"                               GEGL_TYPE_BUFFER,                              \n"
"                               G_PARAM_READABLE |                             \n"
"                               GEGL_PARAM_PAD_OUTPUT);                        \n"
"  gegl_operation_create_pad (operation, pspec);                               \n"
"  g_param_spec_sink (pspec);                                                  \n"
"                                                                              \n"
"  pspec = g_param_spec_object (\"input\",                                     \n"
"                               \"Input\",                                     \n"
"                               \"Input pad, for image buffer input.\",        \n"
"                               GEGL_TYPE_BUFFER,                              \n"
"                               G_PARAM_READWRITE |                            \n"
"                               GEGL_PARAM_PAD_INPUT);                         \n"
"  gegl_operation_create_pad (operation, pspec);                               \n"
"  g_param_spec_sink (pspec);                                                  \n"
"                                                                              \n"
"  pspec = g_param_spec_object (\"aux\",                                       \n"
"                               \"Aux\",                                       \n"
"                               \"Auxiliary image buffer input pad.\",         \n"
"                               GEGL_TYPE_BUFFER,                              \n"
"                               G_PARAM_READWRITE |                            \n"
"                               GEGL_PARAM_PAD_INPUT);                         \n"
"  gegl_operation_create_pad (operation, pspec);                               \n"
"  g_param_spec_sink (pspec);                                                  \n"
"                                                                              \n"
"  pspec = g_param_spec_object (\"aux2\",                                      \n"
"                               \"Aux2\",                                      \n"
"                               \"Second auxiliary image buffer input pad.\",  \n"
"                               GEGL_TYPE_BUFFER,                              \n"
"                               G_PARAM_READWRITE |                            \n"
"                               GEGL_PARAM_PAD_INPUT);                         \n"
"  gegl_operation_create_pad (operation, pspec);                               \n"
"  g_param_spec_sink (pspec);                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *inout_format = babl_format (\"R'G'B'A float\");                 \n"
"  const Babl *aux_format   = babl_format (\"Y'A float\");                     \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  inout_format);            \n"
"  gegl_operation_set_format (operation, \"output\", inout_format);            \n"
"  gegl_operation_set_format (operation, \"aux\",  aux_format);                \n"
"  gegl_operation_set_format (operation, \"aux2\", aux_format);                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle *result = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (!strcmp (input_pad, \"aux\")  ||                                        \n"
"      !strcmp (input_pad, \"aux2\") ||                                        \n"
"      !result)                                                                \n"
"    {                                                                         \n"
"      return *roi;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return *result;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_invalidated_by_change (GeglOperation       *operation,                    \n"
"                           const gchar         *input_pad,                    \n"
"                           const GeglRectangle *input_region)                 \n"
"{                                                                             \n"
"  GeglRectangle *result = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (!strcmp (input_pad, \"aux\")  ||                                        \n"
"      !strcmp (input_pad, \"aux2\") ||                                        \n"
"      !result)                                                                \n"
"    {                                                                         \n"
"      return *input_region;                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  return *result;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *aux2,                                           \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties     *o = GEGL_PROPERTIES (operation);                        \n"
"  GeglBufferIterator *iter;                                                   \n"
"  GeglSampler        *in_sampler;                                             \n"
"                                                                              \n"
"  gint     x, y;                                                              \n"
"  gdouble  cx = 0, cy = 0;                                                    \n"
"  gfloat  *in_pixel;                                                          \n"
"  gint     n_components;                                                      \n"
"  gint     aux_index, aux2_index;                                             \n"
"                                                                              \n"
"  const Babl *inout_format = gegl_operation_get_format (operation, \"input\");\n"
"  const Babl *aux_format  = gegl_operation_get_format (operation, \"aux\");   \n"
"                                                                              \n"
"  n_components = babl_format_get_n_components (inout_format);                 \n"
"                                                                              \n"
"  in_pixel = g_new (gfloat, n_components);                                    \n"
"                                                                              \n"
"  in_sampler = gegl_buffer_sampler_new_at_level (input, inout_format,         \n"
"                                                 o->sampler_type, level);     \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (output, result, level, inout_format,       \n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  if (aux)                                                                    \n"
"    aux_index = gegl_buffer_iterator_add (iter, aux, result, level, aux_format,\n"
"                                          GEGL_ACCESS_READ, o->abyss_policy); \n"
"                                                                              \n"
"  if (aux2)                                                                   \n"
"    aux2_index = gegl_buffer_iterator_add (iter, aux2, result, level, aux_format,\n"
"                                           GEGL_ACCESS_READ, o->abyss_policy);\n"
"                                                                              \n"
"  if (o->displace_mode == GEGL_DISPLACE_MODE_POLAR)                           \n"
"    {                                                                         \n"
"      cx = gegl_buffer_get_width (input) / 2.0;                               \n"
"      cy = gegl_buffer_get_height (input) / 2.0;                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gfloat *out_pixel  = iter->data[0];                                     \n"
"      gfloat *aux_pixel  = aux ? iter->data[aux_index] : NULL;                \n"
"      gfloat *aux2_pixel = aux2 ? iter->data[aux2_index] : NULL;              \n"
"      gint b;                                                                 \n"
"                                                                              \n"
"      for (y = iter->roi[0].y; y < iter->roi[0].y + iter->roi[0].height; y++) \n"
"        for (x = iter->roi[0].x; x < iter->roi[0].x + iter->roi[0].width; x++)\n"
"          {                                                                   \n"
"            gdouble  src_x, src_y;                                            \n"
"                                                                              \n"
"            if (o->displace_mode == GEGL_DISPLACE_MODE_POLAR)                 \n"
"              {                                                               \n"
"                get_input_polar_coordinates (x, y, o->amount_x, o->amount_y,  \n"
"                                             aux_pixel, aux2_pixel, cx, cy,   \n"
"                                             &src_x, &src_y);                 \n"
"              }                                                               \n"
"            else                                                              \n"
"              {                                                               \n"
"                get_input_cartesian_coordinates (x, y, o->amount_x, o->amount_y,\n"
"                                                 aux_pixel, aux2_pixel,       \n"
"                                                 &src_x, &src_y);             \n"
"              }                                                               \n"
"                                                                              \n"
"            gegl_sampler_get (in_sampler, src_x, src_y, NULL,                 \n"
"                              in_pixel, o->abyss_policy);                     \n"
"                                                                              \n"
"            for (b = 0; b < n_components; b++)                                \n"
"              out_pixel[b] = in_pixel[b];                                     \n"
"                                                                              \n"
"            out_pixel += n_components;                                        \n"
"                                                                              \n"
"            if (aux)                                                          \n"
"              aux_pixel += 2;                                                 \n"
"                                                                              \n"
"            if (aux2)                                                         \n"
"              aux2_pixel += 2;                                                \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (in_pixel);                                                          \n"
"  g_object_unref (in_sampler);                                                \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglBuffer     *input = NULL;                                               \n"
"  GeglBuffer     *aux;                                                        \n"
"  GeglBuffer     *aux2;                                                       \n"
"  GeglBuffer     *output;                                                     \n"
"  gboolean        success;                                                    \n"
"                                                                              \n"
"  aux   = gegl_operation_context_get_source (context, \"aux\");               \n"
"  aux2  = gegl_operation_context_get_source (context, \"aux2\");              \n"
"                                                                              \n"
"  if ((!aux && !aux2) ||                                                      \n"
"      (GEGL_FLOAT_IS_ZERO (o->amount_x) && GEGL_FLOAT_IS_ZERO (o->amount_y))) \n"
"    {                                                                         \n"
"      gpointer in = gegl_operation_context_get_object (context, \"input\");   \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                          g_object_ref (G_OBJECT (in)));      \n"
"      success = TRUE;                                                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      input = gegl_operation_context_get_source (context, \"input\");         \n"
"      output = gegl_operation_context_get_target (context, \"output\");       \n"
"                                                                              \n"
"      success = process (operation, input, aux, aux2, output, result, level); \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (input != NULL)                                                          \n"
"    g_object_unref (input);                                                   \n"
"                                                                              \n"
"  if (aux != NULL)                                                            \n"
"    g_object_unref (aux);                                                     \n"
"                                                                              \n"
"  if (aux2 != NULL)                                                           \n"
"    g_object_unref (aux2);                                                    \n"
"                                                                              \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach                    = attach;                        \n"
"  operation_class->prepare                   = prepare;                       \n"
"  operation_class->process                   = operation_process;             \n"
"  operation_class->get_required_for_output   = get_required_for_output;       \n"
"  operation_class->get_invalidated_by_change = get_invalidated_by_change;     \n"
"  operation_class->opencl_support            = FALSE;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:displace\",                                       \n"
"    \"title\",       _(\"Displace\"),                                         \n"
"    \"categories\",  \"map\",                                                 \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Displace pixels as indicated by displacement maps\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
