/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.STransaction;
import com.sleepycat.thrift.BdbService;
import com.sleepycat.thrift.TSequence;

public class SSequence
implements RemoteCallHelper,
AutoCloseable {
    private final TSequence tSequence;
    private final BdbService.Client client;
    private final SDatabase database;
    private final SDatabaseEntry key;

    SSequence(TSequence tSequence, BdbService.Client client, SDatabase sDatabase, SDatabaseEntry sDatabaseEntry) {
        this.tSequence = tSequence;
        this.client = client;
        this.database = sDatabase;
        this.key = sDatabaseEntry;
    }

    public SDatabase getDatabase() {
        return this.database;
    }

    public SDatabaseEntry getKey() {
        return this.key;
    }

    @Override
    public void close() throws SDatabaseException {
        this.remoteCall(() -> {
            this.client.closeSequenceHandle(this.tSequence);
            return null;
        });
    }

    public long get(STransaction sTransaction, int n) throws SDatabaseException {
        return this.remoteCall(() -> this.client.sequenceGet(this.tSequence, STransaction.nullSafeGet(sTransaction), n));
    }
}

