/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.objects.BoundScriptFunctionImpl;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.PrototypeObject;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.GlobalFunctions;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.RecompilableScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptFunctionData;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

public class ScriptFunctionImpl
extends ScriptFunction {
    private Object prototype;
    private static final PropertyMap strictmodemap$;
    private static final PropertyMap boundfunctionmap$;
    private static final PropertyMap map$;
    private static final Object LAZY_PROTOTYPE;

    private ScriptFunctionImpl(String name, MethodHandle invokeHandle, MethodHandle[] specs, Global global) {
        super(name, invokeHandle, map$, null, specs, 6);
        this.init(global);
    }

    ScriptFunctionImpl(String name, MethodHandle invokeHandle, MethodHandle[] specs) {
        this(name, invokeHandle, specs, Global.instance());
    }

    private ScriptFunctionImpl(String name, MethodHandle invokeHandle, PropertyMap map, MethodHandle[] specs, Global global) {
        super(name, invokeHandle, map.addAll(map$), null, specs, 6);
        this.init(global);
    }

    ScriptFunctionImpl(String name, MethodHandle invokeHandle, PropertyMap map, MethodHandle[] specs) {
        this(name, invokeHandle, map, specs, Global.instance());
    }

    private ScriptFunctionImpl(String name, MethodHandle methodHandle, ScriptObject scope, MethodHandle[] specs, int flags, Global global) {
        super(name, methodHandle, ScriptFunctionImpl.getMap(ScriptFunctionImpl.isStrict(flags)), scope, specs, flags);
        this.init(global);
    }

    ScriptFunctionImpl(String name, MethodHandle methodHandle, ScriptObject scope, MethodHandle[] specs, int flags) {
        this(name, methodHandle, scope, specs, flags, Global.instance());
    }

    private ScriptFunctionImpl(RecompilableScriptFunctionData data, ScriptObject scope, Global global) {
        super(data, ScriptFunctionImpl.getMap(data.isStrict()), scope);
        this.init(global);
    }

    public ScriptFunctionImpl(RecompilableScriptFunctionData data, ScriptObject scope) {
        this(data, scope, Global.instance());
    }

    ScriptFunctionImpl(ScriptFunctionData data, Global global) {
        super(data, boundfunctionmap$, null);
        this.init(global);
    }

    private static PropertyMap createStrictModeMap(PropertyMap map) {
        int flags = 6;
        PropertyMap newMap = map;
        newMap = newMap.addPropertyNoHistory(map.newUserAccessors("arguments", 6));
        newMap = newMap.addPropertyNoHistory(map.newUserAccessors("caller", 6));
        return newMap;
    }

    private static boolean isStrict(int flags) {
        return (flags & 1) != 0;
    }

    private static PropertyMap getMap(boolean strict) {
        return strict ? strictmodemap$ : map$;
    }

    private static PropertyMap createBoundFunctionMap(PropertyMap strictModeMap) {
        return strictModeMap.deleteProperty(strictModeMap.findProperty("prototype"));
    }

    static ScriptFunctionImpl newAnonymousFunction(Global global) {
        return new AnonymousFunction(global);
    }

    static ScriptFunction makeFunction(String name, MethodHandle methodHandle, MethodHandle[] specs) {
        ScriptFunctionImpl func = new ScriptFunctionImpl(name, methodHandle, null, specs, 2);
        func.setPrototype(ScriptRuntime.UNDEFINED);
        func.deleteOwnProperty(func.getMap().findProperty("prototype"));
        return func;
    }

    static ScriptFunction makeFunction(String name, MethodHandle methodHandle) {
        return ScriptFunctionImpl.makeFunction(name, methodHandle, null);
    }

    @Override
    public ScriptFunction makeSynchronizedFunction(Object sync) {
        MethodHandle mh = Lookup.MH.insertArguments(ScriptFunction.INVOKE_SYNC, 0, this, sync);
        return ScriptFunctionImpl.makeFunction(this.getName(), mh);
    }

    @Override
    protected ScriptFunction makeBoundFunction(Object self, Object[] args) {
        return super.makeBoundFunction(self, args);
    }

    @Override
    protected ScriptFunction makeBoundFunction(ScriptFunctionData data) {
        return new BoundScriptFunctionImpl(data, this.getTargetFunction());
    }

    @Override
    protected final ScriptObject getObjectPrototype() {
        return Global.objectPrototype();
    }

    @Override
    public final Object getPrototype() {
        if (this.prototype == LAZY_PROTOTYPE) {
            this.prototype = new PrototypeObject(this);
        }
        return this.prototype;
    }

    @Override
    public final void setPrototype(Object newProto) {
        if (newProto instanceof ScriptObject && newProto != this.prototype && this.allocatorMap != null) {
            this.allocatorMap = this.allocatorMap.changeProto((ScriptObject)newProto);
        }
        this.prototype = newProto;
    }

    private void init(Global global) {
        this.setInitialProto(global.getFunctionPrototype());
        this.prototype = LAZY_PROTOTYPE;
        ScriptFunction errorThrower = global.getTypeErrorThrower();
        if (this.findProperty("arguments", true) != null) {
            this.setUserAccessors("arguments", errorThrower, errorThrower);
        }
        if (this.findProperty("caller", true) != null) {
            this.setUserAccessors("caller", errorThrower, errorThrower);
        }
    }

    static {
        LAZY_PROTOTYPE = new Object();
        ArrayList<Property> properties = new ArrayList<Property>(3);
        properties.add(AccessorProperty.create("prototype", 6, G$PROTOTYPE, S$PROTOTYPE));
        properties.add(AccessorProperty.create("length", 7, G$LENGTH, null));
        properties.add(AccessorProperty.create("name", 7, G$NAME, null));
        map$ = PropertyMap.newMap(properties);
        strictmodemap$ = ScriptFunctionImpl.createStrictModeMap(map$);
        boundfunctionmap$ = ScriptFunctionImpl.createBoundFunctionMap(strictmodemap$);
    }

    private static class AnonymousFunction
    extends ScriptFunctionImpl {
        private static final PropertyMap anonmap$ = PropertyMap.newMap();

        AnonymousFunction(Global global) {
            super("", GlobalFunctions.ANONYMOUS, anonmap$, null);
        }
    }
}

