/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.api.scripting;

import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import jdk.nashorn.api.scripting.AbstractJSObject;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.api.scripting.NashornException;
import jdk.nashorn.api.scripting.ScriptUtils;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

public final class ScriptObjectMirror
extends AbstractJSObject
implements Bindings {
    private static final AccessControlContext GET_CONTEXT_ACC_CTXT = ScriptObjectMirror.getContextAccCtxt();
    private final ScriptObject sobj;
    private final Global global;
    private final boolean strict;

    private static AccessControlContext getContextAccCtxt() {
        Permissions perms = new Permissions();
        perms.add(new RuntimePermission("nashorn.getContext"));
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ScriptObjectMirror) {
            return this.sobj.equals(((ScriptObjectMirror)other).sobj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.sobj.hashCode();
    }

    public String toString() {
        return this.inGlobal(new Callable<String>(){

            @Override
            public String call() {
                return ScriptRuntime.safeToString(ScriptObjectMirror.this.sobj);
            }
        });
    }

    @Override
    public Object call(Object thiz, Object ... args) {
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.global;
        try {
            if (globalChanged) {
                Context.setGlobal(this.global);
            }
            if (this.sobj instanceof ScriptFunction) {
                Object[] modArgs = globalChanged ? ScriptObjectMirror.wrapArray(args, oldGlobal) : args;
                Object self = globalChanged ? ScriptObjectMirror.wrap(thiz, oldGlobal) : thiz;
                Object object = ScriptObjectMirror.wrap(ScriptRuntime.apply((ScriptFunction)this.sobj, ScriptObjectMirror.unwrap(self, this.global), ScriptObjectMirror.unwrapArray(modArgs, this.global)), this.global);
                return object;
            }
            try {
                throw new RuntimeException("not a function: " + this.toString());
            }
            catch (NashornException ne) {
                throw ne.initEcmaError(this.global);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
    }

    @Override
    public Object newObject(Object ... args) {
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.global;
        try {
            if (globalChanged) {
                Context.setGlobal(this.global);
            }
            if (this.sobj instanceof ScriptFunction) {
                Object[] modArgs = globalChanged ? ScriptObjectMirror.wrapArray(args, oldGlobal) : args;
                Object object = ScriptObjectMirror.wrap(ScriptRuntime.construct((ScriptFunction)this.sobj, ScriptObjectMirror.unwrapArray(modArgs, this.global)), this.global);
                return object;
            }
            try {
                throw new RuntimeException("not a constructor: " + this.toString());
            }
            catch (NashornException ne) {
                throw ne.initEcmaError(this.global);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
    }

    @Override
    public Object eval(final String s) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                Context context = AccessController.doPrivileged(new PrivilegedAction<Context>(){

                    @Override
                    public Context run() {
                        return Context.getContext();
                    }
                }, GET_CONTEXT_ACC_CTXT);
                return ScriptObjectMirror.wrap(context.eval(ScriptObjectMirror.this.global, s, null, null, false), ScriptObjectMirror.this.global);
            }
        });
    }

    public Object callMember(String functionName, Object ... args) {
        functionName.getClass();
        Global oldGlobal = Context.getGlobal();
        boolean globalChanged = oldGlobal != this.global;
        try {
            Object val;
            if (globalChanged) {
                Context.setGlobal(this.global);
            }
            if ((val = this.sobj.get(functionName)) instanceof ScriptFunction) {
                Object[] modArgs = globalChanged ? ScriptObjectMirror.wrapArray(args, oldGlobal) : args;
                Object object = ScriptObjectMirror.wrap(ScriptRuntime.apply((ScriptFunction)val, this.sobj, ScriptObjectMirror.unwrapArray(modArgs, this.global)), this.global);
                return object;
            }
            if (val instanceof JSObject && ((JSObject)val).isFunction()) {
                Object object = ((JSObject)val).call(this.sobj, args);
                return object;
            }
            try {
                throw new NoSuchMethodException("No such function " + functionName);
            }
            catch (NashornException ne) {
                throw ne.initEcmaError(this.global);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
    }

    @Override
    public Object getMember(final String name) {
        name.getClass();
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(name), ScriptObjectMirror.this.global);
            }
        });
    }

    @Override
    public Object getSlot(final int index) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(index), ScriptObjectMirror.this.global);
            }
        });
    }

    @Override
    public boolean hasMember(final String name) {
        name.getClass();
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.has(name);
            }
        });
    }

    @Override
    public boolean hasSlot(final int slot) {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.has(slot);
            }
        });
    }

    @Override
    public void removeMember(String name) {
        name.getClass();
        this.remove(name);
    }

    @Override
    public void setMember(String name, Object value) {
        name.getClass();
        this.put(name, value);
    }

    @Override
    public void setSlot(final int index, final Object value) {
        this.inGlobal(new Callable<Void>(){

            @Override
            public Void call() {
                ScriptObjectMirror.this.sobj.set(index, ScriptObjectMirror.unwrap(value, ScriptObjectMirror.this.global), ScriptObjectMirror.this.strict);
                return null;
            }
        });
    }

    public void setIndexedPropertiesToExternalArrayData(final ByteBuffer buf) {
        this.inGlobal(new Callable<Void>(){

            @Override
            public Void call() {
                ScriptObjectMirror.this.sobj.setArray(ArrayData.allocate(buf));
                return null;
            }
        });
    }

    @Override
    public boolean isInstance(Object obj) {
        if (!(obj instanceof ScriptObjectMirror)) {
            return false;
        }
        final ScriptObjectMirror instance = (ScriptObjectMirror)obj;
        if (this.global != instance.global) {
            return false;
        }
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.isInstance(instance.sobj);
            }
        });
    }

    @Override
    public String getClassName() {
        return this.sobj.getClassName();
    }

    @Override
    public boolean isFunction() {
        return this.sobj instanceof ScriptFunction;
    }

    @Override
    public boolean isStrictFunction() {
        return this.isFunction() && ((ScriptFunction)this.sobj).isStrict();
    }

    @Override
    public boolean isArray() {
        return this.sobj.isArray();
    }

    @Override
    public void clear() {
        this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                ScriptObjectMirror.this.sobj.clear(ScriptObjectMirror.this.strict);
                return null;
            }
        });
    }

    @Override
    public boolean containsKey(final Object key) {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.containsKey(ScriptObjectMirror.unwrap(key, ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public boolean containsValue(final Object value) {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.containsValue(ScriptObjectMirror.unwrap(value, ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.inGlobal(new Callable<Set<Map.Entry<String, Object>>>(){

            @Override
            public Set<Map.Entry<String, Object>> call() {
                Iterator<String> iter = ScriptObjectMirror.this.sobj.propertyIterator();
                LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, Object>> entries = new LinkedHashSet<AbstractMap.SimpleImmutableEntry<String, Object>>();
                while (iter.hasNext()) {
                    String key = iter.next();
                    Object value = ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(key), ScriptObjectMirror.this.global));
                    entries.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, value));
                }
                return Collections.unmodifiableSet(entries);
            }
        });
    }

    @Override
    public Object get(final Object key) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.get(key), ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.isEmpty();
            }
        });
    }

    @Override
    public Set<String> keySet() {
        return this.inGlobal(new Callable<Set<String>>(){

            @Override
            public Set<String> call() {
                Iterator<String> iter = ScriptObjectMirror.this.sobj.propertyIterator();
                LinkedHashSet<String> keySet = new LinkedHashSet<String>();
                while (iter.hasNext()) {
                    keySet.add(iter.next());
                }
                return Collections.unmodifiableSet(keySet);
            }
        });
    }

    @Override
    public Object put(final String key, final Object value) {
        final Global oldGlobal = Context.getGlobal();
        final boolean globalChanged = oldGlobal != this.global;
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                Object modValue = globalChanged ? ScriptObjectMirror.wrap(value, oldGlobal) : value;
                return ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.put(key, ScriptObjectMirror.unwrap(modValue, ScriptObjectMirror.this.global), ScriptObjectMirror.this.strict), ScriptObjectMirror.this.global));
            }
        });
    }

    @Override
    public void putAll(final Map<? extends String, ? extends Object> map) {
        final Global oldGlobal = Context.getGlobal();
        final boolean globalChanged = oldGlobal != this.global;
        this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object modValue = globalChanged ? ScriptObjectMirror.wrap(value, oldGlobal) : value;
                    ScriptObjectMirror.this.sobj.set(entry.getKey(), ScriptObjectMirror.unwrap(modValue, ScriptObjectMirror.this.global), ScriptObjectMirror.this.strict);
                }
                return null;
            }
        });
    }

    @Override
    public Object remove(final Object key) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.remove(ScriptObjectMirror.unwrap(key, ScriptObjectMirror.this.global), ScriptObjectMirror.this.strict), ScriptObjectMirror.this.global);
            }
        });
    }

    public boolean delete(final Object key) {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.delete(ScriptObjectMirror.unwrap(key, ScriptObjectMirror.this.global), ScriptObjectMirror.this.strict);
            }
        });
    }

    @Override
    public int size() {
        return this.inGlobal(new Callable<Integer>(){

            @Override
            public Integer call() {
                return ScriptObjectMirror.this.sobj.size();
            }
        });
    }

    @Override
    public Collection<Object> values() {
        return this.inGlobal(new Callable<Collection<Object>>(){

            @Override
            public Collection<Object> call() {
                ArrayList<Object> values = new ArrayList<Object>(ScriptObjectMirror.this.size());
                Iterator<Object> iter = ScriptObjectMirror.this.sobj.valueIterator();
                while (iter.hasNext()) {
                    values.add(ScriptObjectMirror.translateUndefined(ScriptObjectMirror.wrap(iter.next(), ScriptObjectMirror.this.global)));
                }
                return Collections.unmodifiableList(values);
            }
        });
    }

    public Object getProto() {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.getProto(), ScriptObjectMirror.this.global);
            }
        });
    }

    public void setProto(final Object proto) {
        this.inGlobal(new Callable<Void>(){

            @Override
            public Void call() {
                ScriptObjectMirror.this.sobj.setPrototypeOf(ScriptObjectMirror.unwrap(proto, ScriptObjectMirror.this.global));
                return null;
            }
        });
    }

    public Object getOwnPropertyDescriptor(final String key) {
        return this.inGlobal(new Callable<Object>(){

            @Override
            public Object call() {
                return ScriptObjectMirror.wrap(ScriptObjectMirror.this.sobj.getOwnPropertyDescriptor(key), ScriptObjectMirror.this.global);
            }
        });
    }

    public String[] getOwnKeys(final boolean all) {
        return this.inGlobal(new Callable<String[]>(){

            @Override
            public String[] call() {
                return ScriptObjectMirror.this.sobj.getOwnKeys(all);
            }
        });
    }

    public ScriptObjectMirror preventExtensions() {
        return this.inGlobal(new Callable<ScriptObjectMirror>(){

            @Override
            public ScriptObjectMirror call() {
                ScriptObjectMirror.this.sobj.preventExtensions();
                return ScriptObjectMirror.this;
            }
        });
    }

    public boolean isExtensible() {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.isExtensible();
            }
        });
    }

    public ScriptObjectMirror seal() {
        return this.inGlobal(new Callable<ScriptObjectMirror>(){

            @Override
            public ScriptObjectMirror call() {
                ScriptObjectMirror.this.sobj.seal();
                return ScriptObjectMirror.this;
            }
        });
    }

    public boolean isSealed() {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.isSealed();
            }
        });
    }

    public ScriptObjectMirror freeze() {
        return this.inGlobal(new Callable<ScriptObjectMirror>(){

            @Override
            public ScriptObjectMirror call() {
                ScriptObjectMirror.this.sobj.freeze();
                return ScriptObjectMirror.this;
            }
        });
    }

    public boolean isFrozen() {
        return this.inGlobal(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ScriptObjectMirror.this.sobj.isFrozen();
            }
        });
    }

    public static boolean isUndefined(Object obj) {
        return obj == ScriptRuntime.UNDEFINED;
    }

    public <T> T to(final Class<T> type) {
        return (T)this.inGlobal(new Callable<T>(){

            @Override
            public T call() {
                return type.cast(ScriptUtils.convert(ScriptObjectMirror.this.sobj, type));
            }
        });
    }

    public static Object wrap(Object obj, Object homeGlobal) {
        if (obj instanceof ScriptObject) {
            return homeGlobal instanceof Global ? new ScriptObjectMirror((ScriptObject)obj, (Global)homeGlobal) : obj;
        }
        if (obj instanceof ConsString) {
            return obj.toString();
        }
        return obj;
    }

    public static Object unwrap(Object obj, Object homeGlobal) {
        if (obj instanceof ScriptObjectMirror) {
            ScriptObjectMirror mirror = (ScriptObjectMirror)obj;
            return mirror.global == homeGlobal ? mirror.sobj : obj;
        }
        return obj;
    }

    public static Object[] wrapArray(Object[] args, Object homeGlobal) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] newArgs = new Object[args.length];
        int index = 0;
        for (Object obj : args) {
            newArgs[index] = ScriptObjectMirror.wrap(obj, homeGlobal);
            ++index;
        }
        return newArgs;
    }

    public static Object[] unwrapArray(Object[] args, Object homeGlobal) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] newArgs = new Object[args.length];
        int index = 0;
        for (Object obj : args) {
            newArgs[index] = ScriptObjectMirror.unwrap(obj, homeGlobal);
            ++index;
        }
        return newArgs;
    }

    ScriptObjectMirror(ScriptObject sobj, Global global) {
        assert (sobj != null) : "ScriptObjectMirror on null!";
        assert (global != null) : "home Global is null";
        this.sobj = sobj;
        this.global = global;
        this.strict = global.isStrictContext();
    }

    ScriptObject getScriptObject() {
        return this.sobj;
    }

    Global getHomeGlobal() {
        return this.global;
    }

    static Object translateUndefined(Object obj) {
        return obj == ScriptRuntime.UNDEFINED ? null : obj;
    }

    private <V> V inGlobal(Callable<V> callable) {
        boolean globalChanged;
        Global oldGlobal = Context.getGlobal();
        boolean bl = globalChanged = oldGlobal != this.global;
        if (globalChanged) {
            Context.setGlobal(this.global);
        }
        try {
            V v = callable.call();
            return v;
        }
        catch (NashornException ne) {
            throw ne.initEcmaError(this.global);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError("Cannot happen", e);
        }
        finally {
            if (globalChanged) {
                Context.setGlobal(oldGlobal);
            }
        }
    }

    @Override
    public double toNumber() {
        return this.inGlobal(new Callable<Double>(){

            @Override
            public Double call() {
                return JSType.toNumber(ScriptObjectMirror.this.sobj);
            }
        });
    }
}

