/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WindowsProgressBarUI
extends BasicProgressBarUI {
    private Rectangle previousFullBox;
    private Insets indeterminateInsets;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() != null) {
            LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
            this.progressBar.setBorder(null);
            this.indeterminateInsets = UIManager.getInsets("ProgressBar.indeterminateInsets");
        }
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        int n3 = super.getBaseline(jComponent, n, n2);
        if (XPStyle.getXP() != null && this.progressBar.isStringPainted() && this.progressBar.getOrientation() == 0) {
            FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
            int n4 = this.progressBar.getInsets().top;
            if (this.progressBar.isIndeterminate()) {
                n4 = -1;
                --n2;
            } else {
                n4 = 0;
                n2 -= 3;
            }
            n3 = n4 + (n2 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
        }
        return n3;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, TMSchema.Part.PP_BAR);
            return new Dimension((int)super.getPreferredInnerHorizontal().getWidth(), skin.getHeight());
        }
        return super.getPreferredInnerHorizontal();
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, TMSchema.Part.PP_BARVERT);
            return new Dimension(skin.getWidth(), (int)super.getPreferredInnerVertical().getHeight());
        }
        return super.getPreferredInnerVertical();
    }

    @Override
    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.progressBar.getOrientation() == 1;
            boolean bl2 = WindowsGraphicsUtils.isLeftToRight(jComponent);
            int n = this.progressBar.getWidth();
            int n2 = this.progressBar.getHeight() - 1;
            int n3 = this.getAmountFull(null, n, n2);
            this.paintXPBackground(graphics, bl, n, n2);
            if (this.progressBar.isStringPainted()) {
                graphics.setColor(this.progressBar.getForeground());
                if ((n -= 2) <= 0 || (n2 -= 2) <= 0) {
                    return;
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(new BasicStroke(bl ? n : n2, 0, 2));
                if (!bl) {
                    if (bl2) {
                        graphics2D.drawLine(2, n2 / 2 + 1, n3 - 2, n2 / 2 + 1);
                    } else {
                        graphics2D.drawLine(2 + n, n2 / 2 + 1, 2 + n - (n3 - 2), n2 / 2 + 1);
                    }
                    this.paintString(graphics, 0, 0, n, n2, n3, null);
                } else {
                    graphics2D.drawLine(n / 2 + 1, n2 + 1, n / 2 + 1, n2 + 1 - n3 + 2);
                    this.paintString(graphics, 2, 2, n, n2, n3, null);
                }
            } else {
                XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, bl ? TMSchema.Part.PP_CHUNKVERT : TMSchema.Part.PP_CHUNK);
                int n4 = bl ? n - 5 : n2 - 5;
                int n5 = xPStyle.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSCHUNKSIZE, 2);
                int n6 = xPStyle.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
                int n7 = (n3 - 4) / (n5 + n6);
                if (n6 > 0 && n7 * (n5 + n6) + n5 < n3 - 4) {
                    ++n7;
                }
                for (int i = 0; i < n7; ++i) {
                    if (bl) {
                        skin.paintSkin(graphics, 3, n2 - i * (n5 + n6) - n5 - 2, n4, n5, null);
                        continue;
                    }
                    if (bl2) {
                        skin.paintSkin(graphics, 4 + i * (n5 + n6), 2, n5, n4, null);
                        continue;
                    }
                    skin.paintSkin(graphics, n - (2 + (i + 1) * (n5 + n6)), 2, n5, n4, null);
                }
            }
        } else {
            super.paintDeterminate(graphics, jComponent);
        }
    }

    @Override
    protected void setAnimationIndex(int n) {
        super.setAnimationIndex(n);
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            if (this.boxRect != null) {
                Rectangle rectangle = this.getFullChunkBounds(this.boxRect);
                if (this.previousFullBox != null) {
                    rectangle.add(this.previousFullBox);
                }
                this.progressBar.repaint(rectangle);
            } else {
                this.progressBar.repaint();
            }
        }
    }

    @Override
    protected int getBoxLength(int n, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            return 6;
        }
        return super.getBoxLength(n, n2);
    }

    @Override
    protected Rectangle getBox(Rectangle rectangle) {
        Rectangle rectangle2 = super.getBox(rectangle);
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.progressBar.getOrientation() == 1;
            TMSchema.Part part = bl ? TMSchema.Part.PP_BARVERT : TMSchema.Part.PP_BAR;
            Insets insets = this.indeterminateInsets;
            int n = this.getAnimationIndex();
            int n2 = this.getFrameCount() / 2;
            int n3 = xPStyle.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
            n %= n2;
            if (!bl) {
                rectangle2.y += insets.top;
                rectangle2.height = this.progressBar.getHeight() - insets.top - insets.bottom;
                int n4 = this.progressBar.getWidth() - insets.left - insets.right;
                double d = (double)(n4 += (rectangle2.width + n3) * 2) / (double)n2;
                rectangle2.x = (int)(d * (double)n) + insets.left;
            } else {
                rectangle2.x += insets.left;
                rectangle2.width = this.progressBar.getWidth() - insets.left - insets.right;
                int n5 = this.progressBar.getHeight() - insets.top - insets.bottom;
                double d = (double)(n5 += (rectangle2.height + n3) * 2) / (double)n2;
                rectangle2.y = (int)(d * (double)n) + insets.top;
            }
        }
        return rectangle2;
    }

    @Override
    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.progressBar.getOrientation() == 1;
            int n = this.progressBar.getWidth();
            int n2 = this.progressBar.getHeight();
            this.paintXPBackground(graphics, bl, n, n2);
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                graphics.setColor(this.progressBar.getForeground());
                if (!(graphics instanceof Graphics2D)) {
                    return;
                }
                this.paintIndeterminateFrame(this.boxRect, (Graphics2D)graphics, bl, n, n2);
                if (this.progressBar.isStringPainted()) {
                    if (!bl) {
                        this.paintString(graphics, -1, -1, n, n2, 0, null);
                    } else {
                        this.paintString(graphics, 1, 1, n, n2, 0, null);
                    }
                }
            }
        } else {
            super.paintIndeterminate(graphics, jComponent);
        }
    }

    private Rectangle getFullChunkBounds(Rectangle rectangle) {
        boolean bl = this.progressBar.getOrientation() == 1;
        XPStyle xPStyle = XPStyle.getXP();
        int n = xPStyle.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
        if (!bl) {
            int n2 = rectangle.width + n;
            return new Rectangle(rectangle.x - n2 * 2, rectangle.y, n2 * 3, rectangle.height);
        }
        int n3 = rectangle.height + n;
        return new Rectangle(rectangle.x, rectangle.y - n3 * 2, rectangle.width, n3 * 3);
    }

    private void paintIndeterminateFrame(Rectangle rectangle, Graphics2D graphics2D, boolean bl, int n, int n2) {
        Rectangle rectangle2;
        XPStyle xPStyle = XPStyle.getXP();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        TMSchema.Part part = bl ? TMSchema.Part.PP_BARVERT : TMSchema.Part.PP_BAR;
        TMSchema.Part part2 = bl ? TMSchema.Part.PP_CHUNKVERT : TMSchema.Part.PP_CHUNK;
        int n3 = xPStyle.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
        int n4 = 0;
        int n5 = 0;
        if (!bl) {
            n4 = -rectangle.width - n3;
            n5 = 0;
        } else {
            n4 = 0;
            n5 = -rectangle.height - n3;
        }
        this.previousFullBox = rectangle2 = this.getFullChunkBounds(rectangle);
        Insets insets = this.indeterminateInsets;
        Rectangle rectangle3 = new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
        Rectangle rectangle4 = rectangle3.intersection(rectangle2);
        graphics2D2.clip(rectangle4);
        XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, part2);
        graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.8f));
        skin.paintSkin(graphics2D2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        rectangle.translate(n4, n5);
        graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        skin.paintSkin(graphics2D2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        rectangle.translate(n4, n5);
        graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.2f));
        skin.paintSkin(graphics2D2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        graphics2D2.dispose();
    }

    private void paintXPBackground(Graphics graphics, boolean bl, int n, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        TMSchema.Part part = bl ? TMSchema.Part.PP_BARVERT : TMSchema.Part.PP_BAR;
        XPStyle.Skin skin = xPStyle.getSkin(this.progressBar, part);
        skin.paintSkin(graphics, 0, 0, n, n2, null);
    }
}

