// -*- Mode: ObjC; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
//
// This file is part of the LibreOffice project.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#include <stdlib.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include <premac.h>
#import <UIKit/UIKit.h>
#include <postmac.h>

#include <osl/process.h>
#include <touch/touch.h>

#include <unicode/udata.h>
#include <unicode/ucnv.h>

// generated by solenv/bin/native-code.py:
#include "native-code.mm"

static NSString *createPaths(NSString *base, NSString *appRootEscaped, NSArray *fileNames)
{
    NSString *result;
    NSString *prefix = @"file://";
    BOOL first = YES;

    result = base;
    for (NSString *fileName in fileNames) {
        result = [result stringByAppendingString: prefix];
        result = [result stringByAppendingString: [appRootEscaped stringByAppendingPathComponent: fileName]];

        if (first) {
            prefix = [@" " stringByAppendingString:prefix];
            first = NO;
        }
    }

    return result;
}

extern "C" void lo_initialize(NSString *documentPath)
{
    NSString *bundlePath = [[NSBundle mainBundle] bundlePath];
    NSString *app_root_escaped = [bundlePath stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
    NSString *uno_types = createPaths(@"-env:UNO_TYPES=", app_root_escaped, @[@"offapi.rdb", @"oovbaapi.rdb", @"types.rdb"]);
    NSString *uno_services = createPaths(@"-env:UNO_SERVICES=", app_root_escaped, @[@"ure/services.rdb", @"services.rdb"]);

    int fd = open([[bundlePath stringByAppendingPathComponent:@U_ICUDATA_NAME".dat"] UTF8String], O_RDONLY);
    if (fd != -1) {
        struct stat st;
        if (fstat(fd, &st) != -1
            && st.st_size < (size_t)-1) {
            void *icudata = mmap(0, (size_t) st.st_size, PROT_READ, MAP_FILE|MAP_PRIVATE, fd, 0);
            if (icudata == MAP_FAILED) {
#if OSL_DEBUG_LEVEL > 0
                NSLog(@"mmap failed:%s", strerror(errno));
#endif
            } else {
                UErrorCode icuStatus = U_ZERO_ERROR;
                udata_setCommonData(icudata, &icuStatus);
#if OSL_DEBUG_LEVEL > 0
                if (U_FAILURE(icuStatus))
                    NSLog(@"udata_setCommonData failed");
                else {
                    // Test that ICU works...
                    UConverter *cnv = ucnv_open("iso-8859-3", &icuStatus);
                    NSLog(@"ucnv_open(iso-8859-3)-> %p, err = %s, name=%s",
                          (void *)cnv, u_errorName(icuStatus), (!cnv)?"?":ucnv_getName(cnv,&icuStatus));
                    if (U_SUCCESS(icuStatus))
                        ucnv_close(cnv);
                }
#endif
            }
        }
        close(fd);
    }

    const char *argv[] = {
        [[[NSBundle mainBundle] executablePath] UTF8String],
        "-env:URE_INTERNAL_LIB_DIR=file:///",
        [uno_types UTF8String],
        [uno_services UTF8String],
        [[@"file://" stringByAppendingString: [documentPath stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]] UTF8String]
    };

    const int argc = sizeof(argv)/sizeof(*argv);

    osl_setCommandArgs(argc, (char **) argv);
}

// vim:set shiftwidth=4 softtabstop=4 expandtab:
