/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.ProviderException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class Secmod {
    private static final boolean DEBUG = false;
    private static final Secmod INSTANCE;
    private static final String NSS_LIB_NAME = "nss3";
    private static final String SOFTTOKEN_LIB_NAME = "softokn3";
    private static final String TRUST_LIB_NAME = "nssckbi";
    private long nssHandle;
    private boolean supported;
    private List<Module> modules;
    private String configDir;
    private String nssLibDir;
    static final String TEMPLATE_EXTERNAL = "library = %s\nname = \"%s\"\nslotListIndex = %d\n";
    static final String TEMPLATE_TRUSTANCHOR = "library = %s\nname = \"NSS Trust Anchors\"\nslotListIndex = 0\nenabledMechanisms = { KeyStore }\nnssUseSecmodTrust = true\n";
    static final String TEMPLATE_CRYPTO = "library = %s\nname = \"NSS SoftToken Crypto\"\nslotListIndex = 0\ndisabledMechanisms = { KeyStore }\n";
    static final String TEMPLATE_KEYSTORE = "library = %s\nname = \"NSS SoftToken KeyStore\"\nslotListIndex = 1\nnssUseSecmodTrust = true\n";
    static final String TEMPLATE_FIPS = "library = %s\nname = \"NSS FIPS SoftToken\"\nslotListIndex = 0\nnssUseSecmodTrust = true\n";

    private Secmod() {
    }

    public static Secmod getInstance() {
        return INSTANCE;
    }

    private boolean isLoaded() {
        if (this.nssHandle == 0L) {
            this.nssHandle = Secmod.nssGetLibraryHandle(System.mapLibraryName(NSS_LIB_NAME));
            if (this.nssHandle != 0L) {
                this.fetchVersions();
            }
        }
        return this.nssHandle != 0L;
    }

    private void fetchVersions() {
        this.supported = Secmod.nssVersionCheck(this.nssHandle, "3.7");
    }

    public synchronized boolean isInitialized() throws IOException {
        if (!this.isLoaded()) {
            return false;
        }
        if (!this.supported) {
            throw new IOException("An incompatible version of NSS is already loaded, 3.7 or later required");
        }
        return true;
    }

    String getConfigDir() {
        return this.configDir;
    }

    String getLibDir() {
        return this.nssLibDir;
    }

    public void initialize(String configDir, String nssLibDir) throws IOException {
        this.initialize(DbMode.READ_WRITE, configDir, nssLibDir, false);
    }

    public void initialize(DbMode dbMode, String configDir, String nssLibDir) throws IOException {
        this.initialize(dbMode, configDir, nssLibDir, false);
    }

    public synchronized void initialize(DbMode dbMode, String configDir, String nssLibDir, boolean nssOptimizeSpace) throws IOException {
        String platformPath;
        if (this.isInitialized()) {
            throw new IOException("NSS is already initialized");
        }
        if (dbMode == null) {
            throw new NullPointerException();
        }
        if (dbMode != DbMode.NO_DB && configDir == null) {
            throw new NullPointerException();
        }
        String platformLibName = System.mapLibraryName(NSS_LIB_NAME);
        if (nssLibDir == null) {
            platformPath = platformLibName;
        } else {
            File base = new File(nssLibDir);
            if (!base.isDirectory()) {
                throw new IOException("nssLibDir must be a directory:" + nssLibDir);
            }
            File platformFile = new File(base, platformLibName);
            if (!platformFile.isFile()) {
                throw new FileNotFoundException(platformFile.getPath());
            }
            platformPath = platformFile.getPath();
        }
        if (configDir != null) {
            File configBase = new File(configDir);
            if (!configBase.isDirectory()) {
                throw new IOException("configDir must be a directory: " + configDir);
            }
            File secmodFile = new File(configBase, "secmod.db");
            if (!secmodFile.isFile()) {
                throw new FileNotFoundException(secmodFile.getPath());
            }
        }
        this.nssHandle = Secmod.nssLoadLibrary(platformPath);
        this.fetchVersions();
        if (!this.supported) {
            throw new IOException("The specified version of NSS is incompatible, 3.7 or later required");
        }
        boolean initok = Secmod.nssInitialize(dbMode.functionName, this.nssHandle, configDir, nssOptimizeSpace);
        if (!initok) {
            throw new IOException("NSS initialization failed");
        }
        this.configDir = configDir;
        this.nssLibDir = nssLibDir;
    }

    public synchronized List<Module> getModules() {
        try {
            if (!this.isInitialized()) {
                throw new IllegalStateException("NSS not initialized");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (this.modules == null) {
            List modules = (List)Secmod.nssGetModuleList(this.nssHandle, this.nssLibDir);
            this.modules = Collections.unmodifiableList(modules);
        }
        return this.modules;
    }

    private static byte[] getDigest(X509Certificate cert, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            return md.digest(cert.getEncoded());
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
    }

    boolean isTrusted(X509Certificate cert, TrustType trustType) {
        Bytes bytes = new Bytes(Secmod.getDigest(cert, "SHA-1"));
        TrustAttributes attr = this.getModuleTrust(ModuleType.KEYSTORE, bytes);
        if (attr == null && (attr = this.getModuleTrust(ModuleType.FIPS, bytes)) == null) {
            attr = this.getModuleTrust(ModuleType.TRUSTANCHOR, bytes);
        }
        return attr == null ? false : attr.isTrusted(trustType);
    }

    private TrustAttributes getModuleTrust(ModuleType type, Bytes bytes) {
        Module module = this.getModule(type);
        TrustAttributes t = module == null ? null : module.getTrust(bytes);
        return t;
    }

    public Module getModule(ModuleType type) {
        for (Module module : this.getModules()) {
            if (module.getType() != type) continue;
            return module;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Bytes, TrustAttributes> getTrust(SunPKCS11 provider) throws PKCS11Exception {
        HashMap<Bytes, TrustAttributes> trustMap = new HashMap<Bytes, TrustAttributes>();
        Token token = provider.getToken();
        Session session = null;
        try {
            session = token.getOpSession();
            int MAX_NUM = 8192;
            CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3461563219L)};
            token.p11.C_FindObjectsInit(session.id(), attrs);
            long[] handles = token.p11.C_FindObjects(session.id(), MAX_NUM);
            token.p11.C_FindObjectsFinal(session.id());
            for (long handle : handles) {
                TrustAttributes trust = new TrustAttributes(token, session, handle);
                trustMap.put(trust.getHash(), trust);
            }
        }
        finally {
            token.releaseSession(session);
        }
        return trustMap;
    }

    private static native long nssGetLibraryHandle(String var0);

    private static native long nssLoadLibrary(String var0) throws IOException;

    private static native boolean nssVersionCheck(long var0, String var2);

    private static native boolean nssInitialize(String var0, long var1, String var3, boolean var4);

    private static native Object nssGetModuleList(long var0, String var2);

    static {
        PKCS11.loadNative();
        INSTANCE = new Secmod();
    }

    private static class Bytes {
        final byte[] b;

        Bytes(byte[] b) {
            this.b = b;
        }

        public int hashCode() {
            return Arrays.hashCode(this.b);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Bytes)) {
                return false;
            }
            Bytes other = (Bytes)o;
            return Arrays.equals(this.b, other.b);
        }
    }

    static class TrustAttributes {
        final long handle;
        final long clientAuth;
        final long serverAuth;
        final long codeSigning;
        final long emailProtection;
        final byte[] shaHash;

        TrustAttributes(Token token, X509Certificate cert, Bytes bytes, long trustValue) {
            Session session = null;
            try {
                session = token.getOpSession();
                CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3461563219L), new CK_ATTRIBUTE(3461571416L, trustValue), new CK_ATTRIBUTE(3461571418L, trustValue), new CK_ATTRIBUTE(3461571419L, trustValue), new CK_ATTRIBUTE(3461571417L, trustValue), new CK_ATTRIBUTE(3461571508L, bytes.b), new CK_ATTRIBUTE(3461571509L, Secmod.getDigest(cert, "MD5")), new CK_ATTRIBUTE(129L, cert.getIssuerX500Principal().getEncoded()), new CK_ATTRIBUTE(130L, cert.getSerialNumber().toByteArray())};
                this.handle = token.p11.C_CreateObject(session.id(), attrs);
                this.shaHash = bytes.b;
                this.clientAuth = trustValue;
                this.serverAuth = trustValue;
                this.codeSigning = trustValue;
                this.emailProtection = trustValue;
            }
            catch (PKCS11Exception e) {
                throw new ProviderException("Could not create trust object", e);
            }
            finally {
                token.releaseSession(session);
            }
        }

        TrustAttributes(Token token, Session session, long handle) throws PKCS11Exception {
            long c;
            this.handle = handle;
            CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3461571416L), new CK_ATTRIBUTE(3461571418L), new CK_ATTRIBUTE(3461571419L), new CK_ATTRIBUTE(3461571508L)};
            token.p11.C_GetAttributeValue(session.id(), handle, attrs);
            this.serverAuth = attrs[0].getLong();
            this.codeSigning = attrs[1].getLong();
            this.emailProtection = attrs[2].getLong();
            this.shaHash = attrs[3].getByteArray();
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3461571417L)};
            try {
                token.p11.C_GetAttributeValue(session.id(), handle, attrs);
                c = attrs[0].getLong();
            }
            catch (PKCS11Exception e) {
                c = this.serverAuth;
            }
            this.clientAuth = c;
        }

        Bytes getHash() {
            return new Bytes(this.shaHash);
        }

        boolean isTrusted(TrustType type) {
            switch (type) {
                case CLIENT_AUTH: {
                    return this.isTrusted(this.clientAuth);
                }
                case SERVER_AUTH: {
                    return this.isTrusted(this.serverAuth);
                }
                case CODE_SIGNING: {
                    return this.isTrusted(this.codeSigning);
                }
                case EMAIL_PROTECTION: {
                    return this.isTrusted(this.emailProtection);
                }
                case ALL: {
                    return this.isTrusted(TrustType.CLIENT_AUTH) && this.isTrusted(TrustType.SERVER_AUTH) && this.isTrusted(TrustType.CODE_SIGNING) && this.isTrusted(TrustType.EMAIL_PROTECTION);
                }
            }
            return false;
        }

        private boolean isTrusted(long l) {
            return l == 3461563218L;
        }
    }

    public static final class KeyStoreLoadParameter
    implements KeyStore.LoadStoreParameter {
        final TrustType trustType;
        final KeyStore.ProtectionParameter protection;

        public KeyStoreLoadParameter(TrustType trustType, char[] password) {
            this(trustType, new KeyStore.PasswordProtection(password));
        }

        public KeyStoreLoadParameter(TrustType trustType, KeyStore.ProtectionParameter prot) {
            if (trustType == null) {
                throw new NullPointerException("trustType must not be null");
            }
            this.trustType = trustType;
            this.protection = prot;
        }

        @Override
        public KeyStore.ProtectionParameter getProtectionParameter() {
            return this.protection;
        }

        public TrustType getTrustType() {
            return this.trustType;
        }
    }

    public static enum DbMode {
        READ_WRITE("NSS_InitReadWrite"),
        READ_ONLY("NSS_Init"),
        NO_DB("NSS_NoDB_Init");

        final String functionName;

        private DbMode(String functionName) {
            this.functionName = functionName;
        }
    }

    public static enum TrustType {
        ALL,
        CLIENT_AUTH,
        SERVER_AUTH,
        CODE_SIGNING,
        EMAIL_PROTECTION;

    }

    public static final class Module {
        final String libraryName;
        final String commonName;
        final int slot;
        final ModuleType type;
        private String config;
        private SunPKCS11 provider;
        private Map<Bytes, TrustAttributes> trust;

        Module(String libraryDir, String libraryName, String commonName, boolean fips, int slot) {
            ModuleType type;
            if (libraryName == null || libraryName.length() == 0) {
                libraryName = System.mapLibraryName(Secmod.SOFTTOKEN_LIB_NAME);
                if (!fips) {
                    type = slot == 0 ? ModuleType.CRYPTO : ModuleType.KEYSTORE;
                } else {
                    type = ModuleType.FIPS;
                    if (slot != 0) {
                        throw new RuntimeException("Slot index should be 0 for FIPS slot");
                    }
                }
            } else {
                type = libraryName.endsWith(System.mapLibraryName(Secmod.TRUST_LIB_NAME)) || commonName.equals("Builtin Roots Module") ? ModuleType.TRUSTANCHOR : ModuleType.EXTERNAL;
                if (fips) {
                    throw new RuntimeException("FIPS flag set for non-internal module: " + libraryName + ", " + commonName);
                }
            }
            this.libraryName = new File(libraryDir, libraryName).getPath();
            this.commonName = commonName;
            this.slot = slot;
            this.type = type;
            this.initConfiguration();
        }

        private void initConfiguration() {
            switch (this.type) {
                case EXTERNAL: {
                    this.config = String.format(Secmod.TEMPLATE_EXTERNAL, this.libraryName, this.commonName + " " + this.slot, this.slot);
                    break;
                }
                case CRYPTO: {
                    this.config = String.format(Secmod.TEMPLATE_CRYPTO, this.libraryName);
                    break;
                }
                case KEYSTORE: {
                    this.config = String.format(Secmod.TEMPLATE_KEYSTORE, this.libraryName);
                    break;
                }
                case FIPS: {
                    this.config = String.format(Secmod.TEMPLATE_FIPS, this.libraryName);
                    break;
                }
                case TRUSTANCHOR: {
                    this.config = String.format(Secmod.TEMPLATE_TRUSTANCHOR, this.libraryName);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown module type: " + (Object)((Object)this.type));
                }
            }
        }

        @Deprecated
        public synchronized String getConfiguration() {
            return this.config;
        }

        @Deprecated
        public synchronized void setConfiguration(String config) {
            if (this.provider != null) {
                throw new IllegalStateException("Provider instance already created");
            }
            this.config = config;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public ModuleType getType() {
            return this.type;
        }

        @Deprecated
        public synchronized Provider getProvider() {
            if (this.provider == null) {
                this.provider = this.newProvider();
            }
            return this.provider;
        }

        synchronized boolean hasInitializedProvider() {
            return this.provider != null;
        }

        void setProvider(SunPKCS11 p) {
            if (this.provider != null) {
                throw new ProviderException("Secmod provider already initialized");
            }
            this.provider = p;
        }

        private SunPKCS11 newProvider() {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(this.config.getBytes("UTF8"));
                return new SunPKCS11(in);
            }
            catch (Exception e) {
                throw new ProviderException(e);
            }
        }

        synchronized void setTrust(Token token, X509Certificate cert) {
            Bytes bytes = new Bytes(Secmod.getDigest(cert, "SHA-1"));
            TrustAttributes attr = this.getTrust(bytes);
            if (attr == null) {
                attr = new TrustAttributes(token, cert, bytes, 3461563218L);
                this.trust.put(bytes, attr);
            } else if (!attr.isTrusted(TrustType.ALL)) {
                throw new ProviderException("Cannot change existing trust attributes");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TrustAttributes getTrust(Bytes hash) {
            if (this.trust == null) {
                Module module = this;
                synchronized (module) {
                    SunPKCS11 p = this.provider;
                    if (p == null) {
                        p = this.newProvider();
                    }
                    try {
                        this.trust = Secmod.getTrust(p);
                    }
                    catch (PKCS11Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return this.trust.get(hash);
        }

        public String toString() {
            return this.commonName + " (" + (Object)((Object)this.type) + ", " + this.libraryName + ", slot " + this.slot + ")";
        }
    }

    public static enum ModuleType {
        CRYPTO,
        KEYSTORE,
        FIPS,
        TRUSTANCHOR,
        EXTERNAL;

    }
}

