/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import sun.security.pkcs11.ConstructKeys;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11RSACipher
extends CipherSpi {
    private static final int PKCS1_MIN_PADDING_LENGTH = 11;
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final int PAD_NONE = 1;
    private static final int PAD_PKCS1 = 2;
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private Session session;
    private int mode;
    private int padType;
    private byte[] buffer;
    private int bufOfs;
    private P11Key p11Key;
    private boolean initialized;
    private int maxInputSize;
    private int outputSize;

    P11RSACipher(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = "RSA";
        this.mechanism = mechanism;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String lowerPadding = padding.toLowerCase(Locale.ENGLISH);
        if (lowerPadding.equals("pkcs1padding")) {
            this.padType = 2;
        } else if (lowerPadding.equals("nopadding")) {
            this.padType = 1;
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + padding);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.implInit(opmode, key);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.implInit(opmode, key);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.implInit(opmode, key);
    }

    private void implInit(int opmode, Key key) throws InvalidKeyException {
        int n;
        boolean encrypt;
        this.cancelOperation();
        this.p11Key = P11KeyFactory.convertKey(this.token, key, this.algorithm);
        if (opmode == 1) {
            encrypt = true;
        } else if (opmode == 2) {
            encrypt = false;
        } else {
            if (opmode == 3) {
                if (!this.p11Key.isPublic()) {
                    throw new InvalidKeyException("Wrap has to be used with public keys");
                }
                return;
            }
            if (opmode == 4) {
                if (!this.p11Key.isPrivate()) {
                    throw new InvalidKeyException("Unwrap has to be used with private keys");
                }
                return;
            }
            throw new InvalidKeyException("Unsupported mode: " + opmode);
        }
        if (this.p11Key.isPublic()) {
            this.mode = encrypt ? 1 : 4;
        } else if (this.p11Key.isPrivate()) {
            this.mode = encrypt ? 3 : 2;
        } else {
            throw new InvalidKeyException("Unknown key type: " + this.p11Key);
        }
        this.outputSize = n = this.p11Key.length() + 7 >> 3;
        this.buffer = new byte[n];
        this.maxInputSize = this.padType == 2 && encrypt ? n - 11 : n;
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("init() failed", e);
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        if (!this.session.hasObjects()) {
            this.session = this.token.killSession(this.session);
            return;
        }
        try {
            PKCS11 p11 = this.token.p11;
            int inLen = this.maxInputSize;
            int outLen = this.buffer.length;
            switch (this.mode) {
                case 1: {
                    p11.C_Encrypt(this.session.id(), this.buffer, 0, inLen, this.buffer, 0, outLen);
                    break;
                }
                case 2: {
                    p11.C_Decrypt(this.session.id(), this.buffer, 0, inLen, this.buffer, 0, outLen);
                    break;
                }
                case 3: {
                    byte[] tmpBuffer = new byte[this.maxInputSize];
                    p11.C_Sign(this.session.id(), tmpBuffer);
                    break;
                }
                case 4: {
                    p11.C_VerifyRecover(this.session.id(), this.buffer, 0, inLen, this.buffer, 0, outLen);
                    break;
                }
                default: {
                    throw new ProviderException("internal error");
                }
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        this.token.ensureValid();
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        PKCS11 p11 = this.token.p11;
        CK_MECHANISM ckMechanism = new CK_MECHANISM(this.mechanism);
        switch (this.mode) {
            case 1: {
                p11.C_EncryptInit(this.session.id(), ckMechanism, this.p11Key.keyID);
                break;
            }
            case 2: {
                p11.C_DecryptInit(this.session.id(), ckMechanism, this.p11Key.keyID);
                break;
            }
            case 3: {
                p11.C_SignInit(this.session.id(), ckMechanism, this.p11Key.keyID);
                break;
            }
            case 4: {
                p11.C_VerifyRecoverInit(this.session.id(), ckMechanism, this.p11Key.keyID);
                break;
            }
            default: {
                throw new AssertionError((Object)"internal error");
            }
        }
        this.bufOfs = 0;
        this.initialized = true;
    }

    private void implUpdate(byte[] in, int inOfs, int inLen) {
        try {
            this.ensureInitialized();
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
        if (inLen == 0 || in == null) {
            return;
        }
        if (this.bufOfs + inLen > this.maxInputSize) {
            this.bufOfs = this.maxInputSize + 1;
            return;
        }
        System.arraycopy(in, inOfs, this.buffer, this.bufOfs, inLen);
        this.bufOfs += inLen;
    }

    private int implDoFinal(byte[] out, int outOfs, int outLen) throws BadPaddingException, IllegalBlockSizeException {
        if (this.bufOfs > this.maxInputSize) {
            throw new IllegalBlockSizeException("Data must not be longer than " + this.maxInputSize + " bytes");
        }
        try {
            int n;
            this.ensureInitialized();
            PKCS11 p11 = this.token.p11;
            switch (this.mode) {
                case 1: {
                    n = p11.C_Encrypt(this.session.id(), this.buffer, 0, this.bufOfs, out, outOfs, outLen);
                    break;
                }
                case 2: {
                    n = p11.C_Decrypt(this.session.id(), this.buffer, 0, this.bufOfs, out, outOfs, outLen);
                    break;
                }
                case 3: {
                    byte[] tmpBuffer = new byte[this.bufOfs];
                    System.arraycopy(this.buffer, 0, tmpBuffer, 0, this.bufOfs);
                    tmpBuffer = p11.C_Sign(this.session.id(), tmpBuffer);
                    if (tmpBuffer.length > outLen) {
                        throw new BadPaddingException("Output buffer too small");
                    }
                    System.arraycopy(tmpBuffer, 0, out, outOfs, tmpBuffer.length);
                    n = tmpBuffer.length;
                    break;
                }
                case 4: {
                    n = p11.C_VerifyRecover(this.session.id(), this.buffer, 0, this.bufOfs, out, outOfs, outLen);
                    break;
                }
                default: {
                    throw new ProviderException("internal error");
                }
            }
            int n2 = n;
            return n2;
        }
        catch (PKCS11Exception e) {
            throw (BadPaddingException)new BadPaddingException("doFinal() failed").initCause(e);
        }
        finally {
            this.initialized = false;
            this.session = this.token.releaseSession(this.session);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        this.implUpdate(in, inOfs, inLen);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException {
        this.implUpdate(in, inOfs, inLen);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        this.implUpdate(in, inOfs, inLen);
        int n = this.implDoFinal(this.buffer, 0, this.buffer.length);
        byte[] out = new byte[n];
        System.arraycopy(this.buffer, 0, out, 0, n);
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.implUpdate(in, inOfs, inLen);
        return this.implDoFinal(out, outOfs, out.length - outOfs);
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        byte[] t = new byte[2048];
        int n = this.implDoFinal(t, 0, t.length);
        byte[] out = new byte[n];
        System.arraycopy(t, 0, out, 0, n);
        return out;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        String keyAlg = key.getAlgorithm();
        P11Key sKey = null;
        try {
            sKey = P11SecretKeyFactory.convertKey(this.token, key, keyAlg);
        }
        catch (InvalidKeyException ike) {
            byte[] toBeWrappedKey = key.getEncoded();
            if (toBeWrappedKey == null) {
                throw new InvalidKeyException("wrap() failed, no encoding available", ike);
            }
            this.implInit(1, this.p11Key);
            this.implUpdate(toBeWrappedKey, 0, toBeWrappedKey.length);
            try {
                byte[] byArray = this.doFinal();
                return byArray;
            }
            catch (BadPaddingException bpe) {
                throw new InvalidKeyException("wrap() failed", bpe);
            }
            finally {
                this.implInit(3, this.p11Key);
            }
        }
        Session s = null;
        try {
            s = this.token.getOpSession();
            byte[] toBeWrappedKey = this.token.p11.C_WrapKey(s.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID, sKey.keyID);
            return toBeWrappedKey;
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("wrap() failed", e);
        }
        finally {
            this.token.releaseSession(s);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        this.implInit(2, this.p11Key);
        if (wrappedKey.length > this.maxInputSize) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        this.implUpdate(wrappedKey, 0, wrappedKey.length);
        try {
            byte[] encoded = this.doFinal();
            return ConstructKeys.constructKey(encoded, algorithm, type);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11KeyFactory.convertKey(this.token, key, this.algorithm).length();
        return n;
    }
}

