/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl.krb5;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.Ticket;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.krb5.KerberosPreMasterSecret;

public final class KerberosClientKeyExchangeImpl
extends KerberosClientKeyExchange {
    private KerberosPreMasterSecret preMaster;
    private byte[] encodedTicket;
    private KerberosPrincipal peerPrincipal;
    private KerberosPrincipal localPrincipal;

    @Override
    public void init(String serverName, boolean isLoopback, AccessControlContext acc, ProtocolVersion protocolVersion, SecureRandom rand) throws IOException {
        KerberosTicket ticket = KerberosClientKeyExchangeImpl.getServiceTicket(serverName, isLoopback, acc);
        this.encodedTicket = ticket.getEncoded();
        this.peerPrincipal = ticket.getServer();
        this.localPrincipal = ticket.getClient();
        EncryptionKey sessionKey = new EncryptionKey(ticket.getSessionKeyType(), ticket.getSessionKey().getEncoded());
        this.preMaster = new KerberosPreMasterSecret(protocolVersion, rand, sessionKey);
    }

    @Override
    public void init(ProtocolVersion protocolVersion, ProtocolVersion clientVersion, SecureRandom rand, HandshakeInStream input, SecretKey[] secretKeys) throws IOException {
        KerberosKey[] serverKeys = (KerberosKey[])secretKeys;
        this.encodedTicket = input.getBytes16();
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(System.out, "encoded Kerberos service ticket", this.encodedTicket);
        }
        EncryptionKey sessionKey = null;
        try {
            Ticket t = new Ticket(this.encodedTicket);
            EncryptedData encPart = t.encPart;
            PrincipalName ticketSname = t.sname;
            Realm ticketRealm = t.realm;
            String serverPrincipal = serverKeys[0].getPrincipal().getName();
            String ticketPrinc = ticketSname.toString().concat("@" + ticketRealm.toString());
            if (!ticketPrinc.equals(serverPrincipal)) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Service principal in Ticket does not match associated principal in KerberosKey");
                }
                throw new IOException("Server principal is " + serverPrincipal + " but ticket is for " + ticketPrinc);
            }
            int encPartKeyType = encPart.getEType();
            Integer encPartKeyVersion = encPart.getKeyVersionNumber();
            KerberosKey dkey = null;
            try {
                dkey = KerberosClientKeyExchangeImpl.findKey(encPartKeyType, encPartKeyVersion, serverKeys);
            }
            catch (KrbException ke) {
                throw new IOException("Cannot find key matching version number", ke);
            }
            if (dkey == null) {
                throw new IOException("Cannot find key of appropriate type to decrypt ticket - need etype " + encPartKeyType);
            }
            EncryptionKey secretKey = new EncryptionKey(encPartKeyType, dkey.getEncoded());
            byte[] bytes = encPart.decrypt(secretKey, 2);
            byte[] temp = encPart.reset(bytes);
            EncTicketPart encTicketPart = new EncTicketPart(temp);
            this.peerPrincipal = new KerberosPrincipal(encTicketPart.cname.getName());
            this.localPrincipal = new KerberosPrincipal(ticketSname.getName());
            sessionKey = encTicketPart.key;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("server principal: " + serverPrincipal);
                System.out.println("realm: " + encTicketPart.crealm.toString());
                System.out.println("cname: " + encTicketPart.cname.toString());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("KerberosWrapper error getting session key, generating random secret (" + e.getMessage() + ")");
            }
            sessionKey = null;
        }
        input.getBytes16();
        this.preMaster = sessionKey != null ? new KerberosPreMasterSecret(protocolVersion, clientVersion, rand, input, sessionKey) : new KerberosPreMasterSecret(clientVersion, rand);
    }

    @Override
    public int messageLength() {
        return 6 + this.encodedTicket.length + this.preMaster.getEncrypted().length;
    }

    @Override
    public void send(HandshakeOutStream s) throws IOException {
        s.putBytes16(this.encodedTicket);
        s.putBytes16(null);
        s.putBytes16(this.preMaster.getEncrypted());
    }

    @Override
    public void print(PrintStream s) throws IOException {
        s.println("*** ClientKeyExchange, Kerberos");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(s, "Kerberos service ticket", this.encodedTicket);
            Debug.println(s, "Random Secret", this.preMaster.getUnencrypted());
            Debug.println(s, "Encrypted random Secret", this.preMaster.getEncrypted());
        }
    }

    private static KerberosTicket getServiceTicket(String srvName, boolean isLoopback, final AccessControlContext acc) throws IOException {
        PrincipalName principal;
        String serverName = srvName;
        if (isLoopback) {
            String localHost;
            serverName = localHost = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String hostname;
                    try {
                        hostname = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        hostname = "localhost";
                    }
                    return hostname;
                }
            });
        }
        String serviceName = "host/" + serverName;
        try {
            principal = new PrincipalName(serviceName, 3);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Invalid service principal name: " + serviceName);
            ioe.initCause(e);
            throw ioe;
        }
        String realm = principal.getRealmAsString();
        final String serverPrincipal = principal.toString();
        final String tgsPrincipal = "krbtgt/" + realm + "@" + realm;
        final String clientPrincipal = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServicePermission(serverPrincipal, "initiate"), acc);
        }
        try {
            KerberosTicket ticket = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getTicketFromSubjectAndTgs((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (String)clientPrincipal, (String)serverPrincipal, (String)tgsPrincipal, (AccessControlContext)acc);
                }
            });
            if (ticket == null) {
                throw new IOException("Failed to find any kerberos service ticket for " + serverPrincipal);
            }
            return ticket;
        }
        catch (PrivilegedActionException e) {
            IOException ioe = new IOException("Attempt to obtain kerberos service ticket for " + serverPrincipal + " failed!");
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public byte[] getUnencryptedPreMasterSecret() {
        return this.preMaster.getUnencrypted();
    }

    @Override
    public KerberosPrincipal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    @Override
    public KerberosPrincipal getLocalPrincipal() {
        return this.localPrincipal;
    }

    private static boolean versionMatches(Integer v1, int v2) {
        if (v1 == null || v1 == 0 || v2 == 0) {
            return true;
        }
        return v1.equals(v2);
    }

    private static KerberosKey findKey(int etype, Integer version, KerberosKey[] keys) throws KrbException {
        int ktype;
        int i;
        boolean etypeFound = false;
        for (i = 0; i < keys.length; ++i) {
            ktype = keys[i].getKeyType();
            if (etype != ktype) continue;
            etypeFound = true;
            if (!KerberosClientKeyExchangeImpl.versionMatches(version, keys[i].getVersionNumber())) continue;
            return keys[i];
        }
        if (etype == 1 || etype == 3) {
            for (i = 0; i < keys.length; ++i) {
                ktype = keys[i].getKeyType();
                if (ktype != 1 && ktype != 3) continue;
                etypeFound = true;
                if (!KerberosClientKeyExchangeImpl.versionMatches(version, keys[i].getVersionNumber())) continue;
                return new KerberosKey(keys[i].getPrincipal(), keys[i].getEncoded(), etype, keys[i].getVersionNumber());
            }
        }
        if (etypeFound) {
            throw new KrbException(44);
        }
        return null;
    }
}

