/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.synth.SynthContext;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthFileChooserUI;

public class SynthFileChooserUIImpl
extends SynthFileChooserUI {
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private FilePane filePane;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private boolean readOnly;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static Dimension LIST_PREF_SIZE = new Dimension(405, 135);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int folderNameLabelMnemonic = 0;
    private String folderNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private AlignedLabel fileNameLabel;
    private final PropertyChangeListener modeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (SynthFileChooserUIImpl.this.fileNameLabel != null) {
                SynthFileChooserUIImpl.this.populateFileNameLabel();
            }
        }
    };
    static final int space = 10;

    private void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == 1) {
            this.fileNameLabel.setText(this.folderNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.folderNameLabelMnemonic);
        } else {
            this.fileNameLabel.setText(this.fileNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        }
    }

    public SynthFileChooserUIImpl(JFileChooser b) {
        super(b);
    }

    @Override
    protected void installDefaults(JFileChooser fc) {
        super.installDefaults(fc);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
    }

    @Override
    public void installComponents(JFileChooser fc) {
        super.installComponents(fc);
        SynthContext context = this.getContext(fc, 1);
        fc.setLayout(new BorderLayout(0, 11));
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        this.filePane = new FilePane(new SynthFileChooserUIAccessor());
        fc.addPropertyChangeListener(this.filePane);
        JPopupMenu contextMenu = this.filePane.getComponentPopupMenu();
        if (contextMenu != null) {
            contextMenu.insert(this.getChangeToParentDirectoryAction(), 0);
            if (File.separatorChar == '/') {
                contextMenu.insert(this.getGoHomeAction(), 1);
            }
        }
        FileSystemView fsv = fc.getFileSystemView();
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.setText(null);
        upFolderButton.setIcon(this.upFolderIcon);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(shrinkwrap);
        topButtonPanel.add(upFolderButton);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.homeFolderIcon);
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.addActionListener(this.getGoHomeAction());
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        if (!this.readOnly) {
            b = new JButton(this.filePane.getNewFolderAction());
            b.setText(null);
            b.setIcon(this.newFolderIcon);
            b.setToolTipText(this.newFolderToolTipText);
            b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
            b.setAlignmentX(0.0f);
            b.setAlignmentY(0.5f);
            b.setMargin(shrinkwrap);
            topButtonPanel.add(b);
            topButtonPanel.add(Box.createRigidArea(hstrut5));
        }
        ButtonGroup viewButtonGroup = new ButtonGroup();
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(this.filePane.getViewTypeAction(0));
        topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(this.filePane.getViewTypeAction(1));
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("viewType".equals(e.getPropertyName())) {
                    int viewType = SynthFileChooserUIImpl.this.filePane.getViewType();
                    switch (viewType) {
                        case 0: {
                            SynthFileChooserUIImpl.this.listViewButton.setSelected(true);
                            break;
                        }
                        case 1: {
                            SynthFileChooserUIImpl.this.detailsViewButton.setSelected(true);
                        }
                    }
                }
            }
        });
        fc.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        fc.add((Component)this.filePane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        fc.add((Component)this.bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        this.bottomPanel.add(fileNamePanel);
        this.bottomPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        this.fileNameLabel = new AlignedLabel();
        this.populateFileNameLabel();
        fileNamePanel.add(this.fileNameLabel);
        this.fileNameTextField = new JTextField(35){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fileNamePanel.add(this.fileNameTextField);
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!SynthFileChooserUIImpl.this.getFileChooser().isMultiSelectionEnabled()) {
                    SynthFileChooserUIImpl.this.filePane.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        this.bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new ButtonAreaLayout());
        this.buttonPanel.add(this.getApproveButton(fc));
        this.buttonPanel.add(this.getCancelButton(fc));
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        SynthFileChooserUIImpl.groupLabels(new AlignedLabel[]{this.fileNameLabel, filesOfTypeLabel});
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        fc.addPropertyChangeListener("fileSelectionChanged", this.modeListener);
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        fc.removePropertyChangeListener("fileSelectionChanged", this.modeListener);
        super.uninstallListeners(fc);
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        c.removePropertyChangeListener(this.filePane);
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = this.getMnemonic("FileChooser.lookInLabelMnemonic", l);
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = this.getMnemonic("FileChooser.fileNameLabelMnemonic", l);
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.folderNameLabelMnemonic = this.getMnemonic("FileChooser.folderNameLabelMnemonic", l);
        this.folderNameLabelText = UIManager.getString((Object)"FileChooser.folderNameLabelText", l);
        this.filesOfTypeLabelMnemonic = this.getMnemonic("FileChooser.filesOfTypeLabelMnemonic", l);
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", l);
    }

    private int getMnemonic(String key, Locale l) {
        return SwingUtilities2.getUIDefaultsInt((Object)key, l);
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String fileName) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(fileName);
        }
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.filePane.rescanCurrentDirectory();
    }

    @Override
    protected void doSelectedFileChanged(PropertyChangeEvent e) {
        super.doSelectedFileChanged(e);
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
        }
    }

    @Override
    protected void doSelectedFilesChanged(PropertyChangeEvent e) {
        super.doSelectedFilesChanged(e);
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        }
    }

    @Override
    protected void doDirectoryChanged(PropertyChangeEvent e) {
        super.doDirectoryChanged(e);
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        File currentDirectory = fc.getCurrentDirectory();
        if (!this.readOnly && currentDirectory != null) {
            this.getNewFolderAction().setEnabled(this.filePane.canWrite(currentDirectory));
        }
        if (currentDirectory != null) {
            ComboBoxModel model;
            JComponent cb = this.getDirectoryComboBox();
            if (cb instanceof JComboBox && (model = ((JComboBox)cb).getModel()) instanceof DirectoryComboBoxModel) {
                ((DirectoryComboBoxModel)model).addItem(currentDirectory);
            }
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    @Override
    protected void doFileSelectionModeChanged(PropertyChangeEvent e) {
        super.doFileSelectionModeChanged(e);
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    @Override
    protected void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    @Override
    protected void doControlButtonsChanged(PropertyChangeEvent e) {
        super.doControlButtonsChanged(e);
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    protected void addControlButtons() {
        if (this.bottomPanel != null) {
            this.bottomPanel.add(this.buttonPanel);
        }
    }

    protected void removeControlButtons() {
        if (this.bottomPanel != null) {
            this.bottomPanel.remove(this.buttonPanel);
        }
    }

    @Override
    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        FilePane.addActionsToMap(map, this.filePane.getActions());
        map.put("fileNameCompletion", this.getFileNameCompletionAction());
        return map;
    }

    protected JComponent getDirectoryComboBox() {
        return this.directoryComboBox;
    }

    protected Action getDirectoryComboBoxAction() {
        return this.directoryComboBoxAction;
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer(this.directoryComboBox.getRenderer());
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer(this.filterComboBox.getRenderer());
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (int i = 0; i < group.length; ++i) {
            AlignedLabel.access$1402(group[i], group);
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel() {
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        AlignedLabel(String text) {
            super(text);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int i;
                int max = 0;
                for (i = 0; i < this.group.length; ++i) {
                    max = Math.max(this.group[i].getSuperPreferredWidth(), max);
                }
                for (i = 0; i < this.group.length; ++i) {
                    this.group[i].maxWidth = max;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$1402(AlignedLabel x0, AlignedLabel[] x1) {
            x0.group = x1;
            return x1;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = this.hGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.hGap + maxWidth);
                }
                for (int counter = numChildren - 1; counter >= 0; --counter) {
                    children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                    xLocation -= xOffset;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = SynthFileChooserUIImpl.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                SynthFileChooserUIImpl.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (FileFilter filter : this.filters) {
                    if (filter != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    SynthFileChooserUIImpl.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;

        private FilterComboBoxRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null && value instanceof FileFilter) {
                text = ((FileFilter)value).getDescription();
            }
            assert (c instanceof JLabel);
            if (text != null) {
                ((JLabel)c).setText(text);
            }
            return c;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SynthFileChooserUIImpl.this.directoryComboBox.hidePopup();
            JComponent cb = SynthFileChooserUIImpl.this.getDirectoryComboBox();
            if (cb instanceof JComboBox) {
                File f = (File)((JComboBox)cb).getSelectedItem();
                SynthFileChooserUIImpl.this.getFileChooser().setCurrentDirectory(f);
            }
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = SynthFileChooserUIImpl.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = SynthFileChooserUIImpl.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        public void addItem(File directory) {
            File canonical;
            if (directory == null) {
                return;
            }
            boolean useShellFolder = FilePane.usesShellFolder(this.chooser);
            int oldSize = this.directories.size();
            this.directories.clear();
            if (oldSize > 0) {
                this.fireIntervalRemoved(this, 0, oldSize);
            }
            File[] baseFolders = useShellFolder ? AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                @Override
                public File[] run() {
                    return (File[])ShellFolder.get("fileChooserComboBoxFolders");
                }
            }) : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(baseFolders));
            try {
                canonical = ShellFolder.getNormalizedFile(directory);
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                File sf;
                File f = sf = useShellFolder ? ShellFolder.getShellFolder(canonical) : canonical;
                Vector<File> path = new Vector<File>(10);
                do {
                    path.addElement(f);
                } while ((f = f.getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(c, g, x + this.depth * 10, y);
                } else {
                    this.icon.paintIcon(c, g, x, y);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return (this.icon != null ? this.icon.getIconWidth() : 0) + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon != null ? this.icon.getIconHeight() : 0;
        }
    }

    private class DirectoryComboBoxRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;
        IndentIcon ii;

        private DirectoryComboBoxRenderer(ListCellRenderer delegate) {
            this.ii = new IndentIcon();
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            Component c = this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            assert (c instanceof JLabel);
            JLabel label = (JLabel)c;
            if (value == null) {
                label.setText("");
                return label;
            }
            File directory = (File)value;
            label.setText(SynthFileChooserUIImpl.this.getFileChooser().getName(directory));
            this.ii.icon = icon = SynthFileChooserUIImpl.this.getFileChooser().getIcon(directory);
            this.ii.depth = SynthFileChooserUIImpl.this.directoryComboBoxModel.getDepth(index);
            label.setIcon(this.ii);
            return label;
        }
    }

    private class SynthFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private SynthFileChooserUIAccessor() {
        }

        @Override
        public JFileChooser getFileChooser() {
            return SynthFileChooserUIImpl.this.getFileChooser();
        }

        @Override
        public BasicDirectoryModel getModel() {
            return SynthFileChooserUIImpl.this.getModel();
        }

        @Override
        public JPanel createList() {
            return null;
        }

        @Override
        public JPanel createDetailsView() {
            return null;
        }

        @Override
        public boolean isDirectorySelected() {
            return SynthFileChooserUIImpl.this.isDirectorySelected();
        }

        @Override
        public File getDirectory() {
            return SynthFileChooserUIImpl.this.getDirectory();
        }

        @Override
        public Action getChangeToParentDirectoryAction() {
            return SynthFileChooserUIImpl.this.getChangeToParentDirectoryAction();
        }

        @Override
        public Action getApproveSelectionAction() {
            return SynthFileChooserUIImpl.this.getApproveSelectionAction();
        }

        @Override
        public Action getNewFolderAction() {
            return SynthFileChooserUIImpl.this.getNewFolderAction();
        }

        @Override
        public MouseListener createDoubleClickListener(JList list) {
            return SynthFileChooserUIImpl.this.createDoubleClickListener(this.getFileChooser(), list);
        }

        @Override
        public ListSelectionListener createListSelectionListener() {
            return SynthFileChooserUIImpl.this.createListSelectionListener(this.getFileChooser());
        }
    }
}

