/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.util.Arrays;
import sun.security.provider.DigestBase;

public final class MD2
extends DigestBase {
    private final int[] X;
    private final int[] C;
    private final byte[] cBytes;
    private static final int[] S = new int[]{41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237, 31, 26, 219, 153, 141, 51, 159, 17, 131, 20};
    private static final byte[][] PADDING = new byte[17][];

    public MD2() {
        super("MD2", 16, 16);
        this.X = new int[48];
        this.C = new int[16];
        this.cBytes = new byte[16];
    }

    private MD2(MD2 base) {
        super(base);
        this.X = (int[])base.X.clone();
        this.C = (int[])base.C.clone();
        this.cBytes = new byte[16];
    }

    @Override
    public Object clone() {
        return new MD2(this);
    }

    @Override
    void implReset() {
        Arrays.fill(this.X, 0);
        Arrays.fill(this.C, 0);
    }

    @Override
    void implDigest(byte[] out, int ofs) {
        int i;
        int padValue = 16 - ((int)this.bytesProcessed & 0xF);
        this.engineUpdate(PADDING[padValue], 0, padValue);
        for (i = 0; i < 16; ++i) {
            this.cBytes[i] = (byte)this.C[i];
        }
        this.implCompress(this.cBytes, 0);
        for (i = 0; i < 16; ++i) {
            out[ofs + i] = (byte)this.X[i];
        }
    }

    @Override
    void implCompress(byte[] b, int ofs) {
        int i;
        for (int i2 = 0; i2 < 16; ++i2) {
            int k;
            this.X[16 + i2] = k = b[ofs + i2] & 0xFF;
            this.X[32 + i2] = k ^ this.X[i2];
        }
        int t = this.C[15];
        for (i = 0; i < 16; ++i) {
            int n = i;
            int n2 = this.C[n] ^ S[this.X[16 + i] ^ t];
            this.C[n] = n2;
            t = n2;
        }
        t = 0;
        for (i = 0; i < 18; ++i) {
            int j = 0;
            while (j < 48) {
                int n = j++;
                int n3 = this.X[n] ^ S[t];
                this.X[n] = n3;
                t = n3;
            }
            t = t + i & 0xFF;
        }
    }

    static {
        for (int i = 1; i < 17; ++i) {
            byte[] b = new byte[i];
            Arrays.fill(b, (byte)i);
            MD2.PADDING[i] = b;
        }
    }
}

