/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCRep;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;

public class Credentials {
    PrincipalName cname;
    Realm crealm;
    PrincipalName sname;
    Realm srealm;
    EncryptionKey key;
    KerberosTime authtime;
    KerberosTime starttime;
    KerberosTime endtime;
    KerberosTime renewTill;
    HostAddresses caddr;
    AuthorizationData authorizationData;
    public boolean isEncInSKey;
    TicketFlags flags;
    Ticket ticket;
    Ticket secondTicket;
    private boolean DEBUG = Krb5.DEBUG;

    public Credentials(PrincipalName new_cname, PrincipalName new_sname, EncryptionKey new_key, KerberosTime new_authtime, KerberosTime new_starttime, KerberosTime new_endtime, KerberosTime new_renewTill, boolean new_isEncInSKey, TicketFlags new_flags, HostAddresses new_caddr, AuthorizationData new_authData, Ticket new_ticket, Ticket new_secondTicket) {
        this.cname = (PrincipalName)new_cname.clone();
        if (new_cname.getRealm() != null) {
            this.crealm = (Realm)new_cname.getRealm().clone();
        }
        this.sname = (PrincipalName)new_sname.clone();
        if (new_sname.getRealm() != null) {
            this.srealm = (Realm)new_sname.getRealm().clone();
        }
        this.key = (EncryptionKey)new_key.clone();
        this.authtime = (KerberosTime)new_authtime.clone();
        if (new_starttime != null) {
            this.starttime = (KerberosTime)new_starttime.clone();
        }
        this.endtime = (KerberosTime)new_endtime.clone();
        if (new_renewTill != null) {
            this.renewTill = (KerberosTime)new_renewTill.clone();
        }
        if (new_caddr != null) {
            this.caddr = (HostAddresses)new_caddr.clone();
        }
        if (new_authData != null) {
            this.authorizationData = (AuthorizationData)new_authData.clone();
        }
        this.isEncInSKey = new_isEncInSKey;
        this.flags = (TicketFlags)new_flags.clone();
        this.ticket = (Ticket)new_ticket.clone();
        if (new_secondTicket != null) {
            this.secondTicket = (Ticket)new_secondTicket.clone();
        }
    }

    public Credentials(KDCRep kdcRep, Ticket new_secondTicket, AuthorizationData new_authorizationData, boolean new_isEncInSKey) {
        if (kdcRep.encKDCRepPart == null) {
            return;
        }
        this.crealm = (Realm)kdcRep.crealm.clone();
        this.cname = (PrincipalName)kdcRep.cname.clone();
        this.ticket = (Ticket)kdcRep.ticket.clone();
        this.key = (EncryptionKey)kdcRep.encKDCRepPart.key.clone();
        this.flags = (TicketFlags)kdcRep.encKDCRepPart.flags.clone();
        this.authtime = (KerberosTime)kdcRep.encKDCRepPart.authtime.clone();
        if (kdcRep.encKDCRepPart.starttime != null) {
            this.starttime = (KerberosTime)kdcRep.encKDCRepPart.starttime.clone();
        }
        this.endtime = (KerberosTime)kdcRep.encKDCRepPart.endtime.clone();
        if (kdcRep.encKDCRepPart.renewTill != null) {
            this.renewTill = (KerberosTime)kdcRep.encKDCRepPart.renewTill.clone();
        }
        this.srealm = (Realm)kdcRep.encKDCRepPart.srealm.clone();
        this.sname = (PrincipalName)kdcRep.encKDCRepPart.sname.clone();
        this.caddr = (HostAddresses)kdcRep.encKDCRepPart.caddr.clone();
        this.secondTicket = (Ticket)new_secondTicket.clone();
        this.authorizationData = (AuthorizationData)new_authorizationData.clone();
        this.isEncInSKey = new_isEncInSKey;
    }

    public Credentials(KDCRep kdcRep) {
        this(kdcRep, null);
    }

    public Credentials(KDCRep kdcRep, Ticket new_ticket) {
        this.sname = (PrincipalName)kdcRep.encKDCRepPart.sname.clone();
        this.srealm = (Realm)kdcRep.encKDCRepPart.srealm.clone();
        try {
            this.sname.setRealm(this.srealm);
        }
        catch (RealmException e) {
            // empty catch block
        }
        this.cname = (PrincipalName)kdcRep.cname.clone();
        this.crealm = (Realm)kdcRep.crealm.clone();
        try {
            this.cname.setRealm(this.crealm);
        }
        catch (RealmException realmException) {
            // empty catch block
        }
        this.key = (EncryptionKey)kdcRep.encKDCRepPart.key.clone();
        this.authtime = (KerberosTime)kdcRep.encKDCRepPart.authtime.clone();
        this.starttime = kdcRep.encKDCRepPart.starttime != null ? (KerberosTime)kdcRep.encKDCRepPart.starttime.clone() : null;
        this.endtime = (KerberosTime)kdcRep.encKDCRepPart.endtime.clone();
        this.renewTill = kdcRep.encKDCRepPart.renewTill != null ? (KerberosTime)kdcRep.encKDCRepPart.renewTill.clone() : null;
        this.flags = kdcRep.encKDCRepPart.flags;
        this.caddr = kdcRep.encKDCRepPart.caddr != null ? (HostAddresses)kdcRep.encKDCRepPart.caddr.clone() : null;
        this.ticket = (Ticket)kdcRep.ticket.clone();
        if (new_ticket != null) {
            this.secondTicket = (Ticket)new_ticket.clone();
            this.isEncInSKey = true;
        } else {
            this.secondTicket = null;
            this.isEncInSKey = false;
        }
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.endtime.getTime() < System.currentTimeMillis()) {
            valid = false;
        } else if (this.starttime != null) {
            if (this.starttime.getTime() > System.currentTimeMillis()) {
                valid = false;
            }
        } else if (this.authtime.getTime() > System.currentTimeMillis()) {
            valid = false;
        }
        return valid;
    }

    public PrincipalName getServicePrincipal() throws RealmException {
        if (this.sname.getRealm() == null) {
            this.sname.setRealm(this.srealm);
        }
        return this.sname;
    }

    public sun.security.krb5.Credentials setKrbCreds() {
        return new sun.security.krb5.Credentials(this.ticket, this.cname, this.sname, this.key, this.flags, this.authtime, this.starttime, this.endtime, this.renewTill, this.caddr);
    }

    public KerberosTime getAuthTime() {
        return this.authtime;
    }

    public KerberosTime getEndTime() {
        return this.endtime;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public int getEType() {
        return this.key.getEType();
    }
}

