/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsRep;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.TGSReq;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbTgsReq {
    private PrincipalName princName;
    private PrincipalName servName;
    private TGSReq tgsReqMessg;
    private KerberosTime ctime;
    private Ticket secondTicket = null;
    private boolean useSubkey = false;
    EncryptionKey tgsReqKey;
    private static final boolean DEBUG = Krb5.DEBUG;
    private byte[] obuf;
    private byte[] ibuf;

    public KrbTgsReq(Credentials asCreds, PrincipalName sname) throws KrbException, IOException {
        this(new KDCOptions(), asCreds, sname, null, null, null, null, null, null, null, null);
    }

    KrbTgsReq(KDCOptions options, Credentials asCreds, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, AuthorizationData authorizationData, Ticket[] additionalTickets, EncryptionKey subKey) throws KrbException, IOException {
        this.princName = asCreds.client;
        this.servName = sname;
        this.ctime = new KerberosTime(true);
        if (options.get(1) && !asCreds.flags.get(1)) {
            throw new KrbException(101);
        }
        if (options.get(2) && !asCreds.flags.get(1)) {
            throw new KrbException(101);
        }
        if (options.get(3) && !asCreds.flags.get(3)) {
            throw new KrbException(101);
        }
        if (options.get(4) && !asCreds.flags.get(3)) {
            throw new KrbException(101);
        }
        if (options.get(5) && !asCreds.flags.get(5)) {
            throw new KrbException(101);
        }
        if (options.get(8) && !asCreds.flags.get(8)) {
            throw new KrbException(101);
        }
        if (options.get(6)) {
            if (!asCreds.flags.get(6)) {
                throw new KrbException(101);
            }
        } else if (from != null) {
            from = null;
        }
        if (options.get(8)) {
            if (!asCreds.flags.get(8)) {
                throw new KrbException(101);
            }
        } else if (rtime != null) {
            rtime = null;
        }
        if (options.get(28)) {
            if (additionalTickets == null) {
                throw new KrbException(101);
            }
            this.secondTicket = additionalTickets[0];
        } else if (additionalTickets != null) {
            additionalTickets = null;
        }
        this.tgsReqMessg = this.createRequest(options, asCreds.ticket, asCreds.key, this.ctime, this.princName, this.princName.getRealm(), this.servName, from, till, rtime, eTypes, addresses, authorizationData, additionalTickets, subKey);
        this.obuf = this.tgsReqMessg.asn1Encode();
        if (asCreds.flags.get(2)) {
            options.set(2, true);
        }
    }

    public void send() throws IOException, KrbException {
        String realmStr = null;
        if (this.servName != null) {
            realmStr = this.servName.getRealmString();
        }
        KdcComm comm = new KdcComm(realmStr);
        this.ibuf = comm.send(this.obuf);
    }

    public KrbTgsRep getReply() throws KrbException, IOException {
        return new KrbTgsRep(this.ibuf, this);
    }

    public Credentials sendAndGetCreds() throws IOException, KrbException {
        KrbTgsRep tgs_rep = null;
        Object kdc = null;
        this.send();
        tgs_rep = this.getReply();
        return tgs_rep.getCreds();
    }

    KerberosTime getCtime() {
        return this.ctime;
    }

    private TGSReq createRequest(KDCOptions kdc_options, Ticket ticket, EncryptionKey key, KerberosTime ctime, PrincipalName cname, Realm crealm, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, AuthorizationData authorizationData, Ticket[] additionalTickets, EncryptionKey subKey) throws Asn1Exception, IOException, KdcErrException, KrbApErrException, UnknownHostException, KrbCryptoException {
        Checksum cksum;
        KerberosTime req_till = null;
        req_till = till == null ? new KerberosTime(0L) : till;
        this.tgsReqKey = key;
        int[] req_eTypes = null;
        if (eTypes == null) {
            req_eTypes = EType.getDefaults("default_tgs_enctypes");
            if (req_eTypes == null) {
                throw new KrbCryptoException("No supported encryption types listed in default_tgs_enctypes");
            }
        } else {
            req_eTypes = eTypes;
        }
        EncryptionKey reqKey = null;
        EncryptedData encAuthorizationData = null;
        if (authorizationData != null) {
            byte[] ad = authorizationData.asn1Encode();
            if (subKey != null) {
                reqKey = subKey;
                this.tgsReqKey = subKey;
                this.useSubkey = true;
                encAuthorizationData = new EncryptedData(reqKey, ad, 5);
            } else {
                encAuthorizationData = new EncryptedData(key, ad, 4);
            }
        }
        KDCReqBody reqBody = new KDCReqBody(kdc_options, cname, sname.getRealm(), sname, from, req_till, rtime, Nonce.value(), req_eTypes, addresses, encAuthorizationData, additionalTickets);
        byte[] temp = reqBody.asn1Encode(12);
        switch (Checksum.CKSUMTYPE_DEFAULT) {
            case -138: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                cksum = new Checksum(Checksum.CKSUMTYPE_DEFAULT, temp, key, 6);
                break;
            }
            default: {
                cksum = new Checksum(Checksum.CKSUMTYPE_DEFAULT, temp);
            }
        }
        byte[] tgs_ap_req = new KrbApReq(new APOptions(), ticket, key, crealm, cname, cksum, ctime, reqKey, null, null).getMessage();
        PAData[] tgsPAData = new PAData[]{new PAData(1, tgs_ap_req)};
        return new TGSReq(tgsPAData, reqBody);
    }

    TGSReq getMessage() {
        return this.tgsReqMessg;
    }

    Ticket getSecondTicket() {
        return this.secondTicket;
    }

    private static void debug(String message) {
    }

    boolean usedSubkey() {
        return this.useSubkey;
    }
}

