/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.IOException;
import java.io.OutputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexOutputStream
extends OutputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int pos = 0;
    private int requested = 0;
    private boolean disconnected = false;
    private Object lock = new Object();

    MultiplexOutputStream(ConnectionMultiplexer manager, MultiplexConnectionInfo info, int bufferLength) {
        this.manager = manager;
        this.info = info;
        this.buffer = new byte[bufferLength];
        this.pos = 0;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        while (this.pos >= this.buffer.length) {
            this.push();
        }
        this.buffer[this.pos++] = (byte)b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        Object object;
        if (len <= 0) {
            return;
        }
        int freeSpace = this.buffer.length - this.pos;
        if (len <= freeSpace) {
            System.arraycopy(b, off, this.buffer, this.pos, len);
            this.pos += len;
            return;
        }
        this.flush();
        while (true) {
            int local_requested;
            object = this.lock;
            synchronized (object) {
                while ((local_requested = this.requested) < 1 && !this.disconnected) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (this.disconnected) {
                    throw new IOException("Connection closed");
                }
            }
            if (local_requested >= len) break;
            this.manager.sendTransmit(this.info, b, off, local_requested);
            off += local_requested;
            len -= local_requested;
            object = this.lock;
            synchronized (object) {
                this.requested -= local_requested;
            }
        }
        this.manager.sendTransmit(this.info, b, off, len);
        object = this.lock;
        synchronized (object) {
            this.requested -= len;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        while (this.pos > 0) {
            this.push();
        }
    }

    @Override
    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void request(int num) {
        Object object = this.lock;
        synchronized (object) {
            this.requested += num;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push() throws IOException {
        int local_requested;
        Object object = this.lock;
        synchronized (object) {
            while ((local_requested = this.requested) < 1 && !this.disconnected) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.disconnected) {
                throw new IOException("Connection closed");
            }
        }
        if (local_requested < this.pos) {
            this.manager.sendTransmit(this.info, this.buffer, 0, local_requested);
            System.arraycopy(this.buffer, local_requested, this.buffer, 0, this.pos - local_requested);
            this.pos -= local_requested;
            object = this.lock;
            synchronized (object) {
                this.requested -= local_requested;
            }
        }
        this.manager.sendTransmit(this.info, this.buffer, 0, this.pos);
        object = this.lock;
        synchronized (object) {
            this.requested -= this.pos;
        }
        this.pos = 0;
    }
}

