/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.LoadLibraryAction;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock = new Object();
    private static long lastRefresh = -1L;
    private static final int TIMEOUT = 300000;
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private LinkedList<String> searchlist;
    private LinkedList<String> nameservers;

    private LinkedList<String> resolvconf(String keyword, int maxperkeyword, int maxkeywords) {
        LinkedList<String> ll = new LinkedList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader("/etc/resolv.conf"));
            while ((line = in.readLine()) != null) {
                String val;
                String value;
                int maxvalues = maxperkeyword;
                if (line.length() == 0 || line.charAt(0) == '#' || line.charAt(0) == ';' || !line.startsWith(keyword) || (value = line.substring(keyword.length())).length() == 0 || value.charAt(0) != ' ' && value.charAt(0) != '\t') continue;
                StringTokenizer st = new StringTokenizer(value, " \t");
                while (st.hasMoreTokens() && (val = st.nextToken()).charAt(0) != '#' && val.charAt(0) != ';') {
                    ll.add(val);
                    if (--maxvalues != 0) continue;
                    break;
                }
                if (--maxkeywords != 0) continue;
                break;
            }
            in.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return ll;
    }

    private void loadConfig() {
        long currTime;
        assert (Thread.holdsLock(lock));
        if (lastRefresh >= 0L && (currTime = System.currentTimeMillis()) - lastRefresh < 300000L) {
            return;
        }
        this.nameservers = AccessController.doPrivileged(new PrivilegedAction<LinkedList<String>>(){

            @Override
            public LinkedList<String> run() {
                return ResolverConfigurationImpl.this.resolvconf("nameserver", 1, 5);
            }
        });
        this.searchlist = this.getSearchList();
        lastRefresh = System.currentTimeMillis();
    }

    private LinkedList<String> getSearchList() {
        LinkedList<String> sl = AccessController.doPrivileged(new PrivilegedAction<LinkedList<String>>(){

            @Override
            public LinkedList<String> run() {
                LinkedList ll = ResolverConfigurationImpl.this.resolvconf("search", 6, 1);
                if (ll.size() > 0) {
                    return ll;
                }
                return null;
            }
        });
        if (sl != null) {
            return sl;
        }
        String localDomain = ResolverConfigurationImpl.localDomain0();
        if (localDomain != null && localDomain.length() > 0) {
            sl = new LinkedList();
            sl.add(localDomain);
            return sl;
        }
        sl = AccessController.doPrivileged(new PrivilegedAction<LinkedList<String>>(){

            @Override
            public LinkedList<String> run() {
                LinkedList ll = ResolverConfigurationImpl.this.resolvconf("domain", 1, 1);
                if (ll.size() > 0) {
                    return ll;
                }
                return null;
            }
        });
        if (sl != null) {
            return sl;
        }
        sl = new LinkedList();
        String domain = ResolverConfigurationImpl.fallbackDomain0();
        if (domain != null && domain.length() > 0) {
            sl.add(domain);
        }
        return sl;
    }

    ResolverConfigurationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.searchlist.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.nameservers.clone();
        }
    }

    @Override
    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static native String localDomain0();

    static native String fallbackDomain0();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

