/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.MXBeanProxy;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;

public class MBeanServerInvocationHandler
implements InvocationHandler {
    private static final WeakHashMap<Class<?>, WeakReference<MXBeanProxy>> mxbeanProxies = new WeakHashMap();
    private final MBeanServerConnection connection;
    private final ObjectName objectName;
    private final boolean isMXBean;

    public MBeanServerInvocationHandler(MBeanServerConnection connection, ObjectName objectName) {
        this(connection, objectName, false);
    }

    public MBeanServerInvocationHandler(MBeanServerConnection connection, ObjectName objectName, boolean isMXBean) {
        if (connection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null object name");
        }
        this.connection = connection;
        this.objectName = objectName;
        this.isMXBean = isMXBean;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.connection;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isMXBean() {
        return this.isMXBean;
    }

    public static <T> T newProxyInstance(MBeanServerConnection connection, ObjectName objectName, Class<T> interfaceClass, boolean notificationBroadcaster) {
        return JMX.newMBeanProxy(connection, objectName, interfaceClass, notificationBroadcaster);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> methodClass = method.getDeclaringClass();
        if (methodClass.equals(NotificationBroadcaster.class) || methodClass.equals(NotificationEmitter.class)) {
            return this.invokeBroadcasterMethod(proxy, method, args);
        }
        if (this.shouldDoLocally(proxy, method)) {
            return this.doLocally(proxy, method, args);
        }
        try {
            int nargs;
            if (this.isMXBean()) {
                MXBeanProxy p = MBeanServerInvocationHandler.findMXBeanProxy(methodClass);
                return p.invoke(this.connection, this.objectName, method, args);
            }
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            int n = nargs = args == null ? 0 : args.length;
            if (methodName.startsWith("get") && methodName.length() > 3 && nargs == 0 && !returnType.equals(Void.TYPE)) {
                return this.connection.getAttribute(this.objectName, methodName.substring(3));
            }
            if (methodName.startsWith("is") && methodName.length() > 2 && nargs == 0 && (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class))) {
                return this.connection.getAttribute(this.objectName, methodName.substring(2));
            }
            if (methodName.startsWith("set") && methodName.length() > 3 && nargs == 1 && returnType.equals(Void.TYPE)) {
                Attribute attr = new Attribute(methodName.substring(3), args[0]);
                this.connection.setAttribute(this.objectName, attr);
                return null;
            }
            String[] signature = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                signature[i] = paramTypes[i].getName();
            }
            return this.connection.invoke(this.objectName, methodName, args, signature);
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (RuntimeMBeanException re) {
            throw re.getTargetException();
        }
        catch (RuntimeErrorException rre) {
            throw rre.getTargetError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MXBeanProxy findMXBeanProxy(Class<?> mxbeanInterface) {
        WeakHashMap<Class<?>, WeakReference<MXBeanProxy>> weakHashMap = mxbeanProxies;
        synchronized (weakHashMap) {
            MXBeanProxy p;
            WeakReference<MXBeanProxy> proxyRef = mxbeanProxies.get(mxbeanInterface);
            MXBeanProxy mXBeanProxy = p = proxyRef == null ? null : (MXBeanProxy)proxyRef.get();
            if (p == null) {
                try {
                    p = new MXBeanProxy(mxbeanInterface);
                }
                catch (IllegalArgumentException e) {
                    String msg = "Cannot make MXBean proxy for " + mxbeanInterface.getName() + ": " + e.getMessage();
                    IllegalArgumentException iae = new IllegalArgumentException(msg, e.getCause());
                    iae.setStackTrace(e.getStackTrace());
                    throw iae;
                }
                mxbeanProxies.put(mxbeanInterface, new WeakReference<MXBeanProxy>(p));
            }
            return p;
        }
    }

    private Object invokeBroadcasterMethod(Object proxy, Method method, Object[] args) throws Exception {
        int nargs;
        String methodName = method.getName();
        int n = nargs = args == null ? 0 : args.length;
        if (methodName.equals("addNotificationListener")) {
            if (nargs != 3) {
                String msg = "Bad arg count to addNotificationListener: " + nargs;
                throw new IllegalArgumentException(msg);
            }
            NotificationListener listener = (NotificationListener)args[0];
            NotificationFilter filter = (NotificationFilter)args[1];
            Object handback = args[2];
            this.connection.addNotificationListener(this.objectName, listener, filter, handback);
            return null;
        }
        if (methodName.equals("removeNotificationListener")) {
            NotificationListener listener = (NotificationListener)args[0];
            switch (nargs) {
                case 1: {
                    this.connection.removeNotificationListener(this.objectName, listener);
                    return null;
                }
                case 3: {
                    NotificationFilter filter = (NotificationFilter)args[1];
                    Object handback = args[2];
                    this.connection.removeNotificationListener(this.objectName, listener, filter, handback);
                    return null;
                }
            }
            String msg = "Bad arg count to removeNotificationListener: " + nargs;
            throw new IllegalArgumentException(msg);
        }
        if (methodName.equals("getNotificationInfo")) {
            if (args != null) {
                throw new IllegalArgumentException("getNotificationInfo has args");
            }
            MBeanInfo info = this.connection.getMBeanInfo(this.objectName);
            return info.getNotifications();
        }
        throw new IllegalArgumentException("Bad method name: " + methodName);
    }

    private boolean shouldDoLocally(Object proxy, Method method) {
        String methodName = method.getName();
        if ((methodName.equals("hashCode") || methodName.equals("toString")) && method.getParameterTypes().length == 0 && MBeanServerInvocationHandler.isLocal(proxy, method)) {
            return true;
        }
        return methodName.equals("equals") && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class}) && MBeanServerInvocationHandler.isLocal(proxy, method);
    }

    private Object doLocally(Object proxy, Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.equals("equals")) {
            if (this == args[0]) {
                return true;
            }
            if (!(args[0] instanceof Proxy)) {
                return false;
            }
            InvocationHandler ihandler = Proxy.getInvocationHandler(args[0]);
            if (ihandler == null || !(ihandler instanceof MBeanServerInvocationHandler)) {
                return false;
            }
            MBeanServerInvocationHandler handler = (MBeanServerInvocationHandler)ihandler;
            return this.connection.equals(handler.connection) && this.objectName.equals(handler.objectName) && proxy.getClass().equals(args[0].getClass());
        }
        if (methodName.equals("toString")) {
            return (this.isMXBean() ? "MX" : "M") + "BeanProxy(" + this.connection + "[" + this.objectName + "])";
        }
        if (methodName.equals("hashCode")) {
            return this.objectName.hashCode() + this.connection.hashCode();
        }
        throw new RuntimeException("Unexpected method name: " + methodName);
    }

    private static boolean isLocal(Object proxy, Method method) {
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        if (interfaces == null) {
            return true;
        }
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        for (Class<?> intf : interfaces) {
            try {
                intf.getMethod(methodName, params);
                return false;
            }
            catch (NoSuchMethodException nsme) {
            }
        }
        return true;
    }
}

